/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.UserTypeBO;
import com.sybase.aseplugin.so.ASEBaseCodeItemSO;
import com.sybase.aseplugin.so.ASEBaseDBCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.DefaultsCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class DefaultSO
extends ASEBaseCodeItemSO
implements DateSorter {
    private Object[] _attrs;
    private String _expression;

    public DefaultSO(ASConnection aSConnection, String string, DatabaseSO databaseSO) {
        super(aSConnection, string, databaseSO);
        this.setType("D");
        this.load(new String[DefaultsCtrSO.NUM_ATTRS + 1]);
    }

    public void load(Object[] objectArray) {
        this._attrs = objectArray;
        this._attrs[4] = this.getCreationDate();
    }

    @Override
    public final Date getDate(int n) {
        return (Date)this._attrs[5];
    }

    @Override
    public final String getOwner() {
        return (String)this._attrs[3];
    }

    @Override
    public final void setOwner(String string) {
        this._attrs[3] = string;
    }

    public final String getCreationDate() {
        Date date = this.getDate(0);
        if (date == null) {
            return "";
        }
        return DateFormat.getDateTimeInstance(2, 3).format(date);
    }

    @Override
    public final String getObjectID() {
        return (String)this._attrs[2];
    }

    @Override
    public Object[] getAttributes() {
        return this._attrs;
    }

    @Override
    public void setAttribute(int n, Object object) {
        this._attrs[n] = object.toString();
    }

    public void setExpression(String string) {
        this._expression = string;
    }

    public final String getExpression() {
        return this._expression;
    }

    @Override
    public void remove() throws SQLException {
        this.useDB();
        this._conn.executeCommand(this.getRemoveCode());
    }

    @Override
    public String getRemoveCode() {
        return SQLs.getString("drop default {0}.{1}", this.getOwner(), this.getName());
    }

    @Override
    public void create() throws SQLException {
        this.useDB();
        if (this.getOwner() != null && this.getName() != null) {
            String string = SQLs.getString("create default {0}.{1}\nas\n{2} ", this.getOwner(), this.getName(), this.getExpression());
            this._conn.executeCommand(string);
        } else {
            this._conn.executeCommand(this.getSQLText());
        }
    }

    @Override
    public String getTemplateText() {
        String string = "create default " + this.getTemplateOwnerDotName() + "\n";
        string = string + "as\n";
        string = string + "default_expression";
        return string;
    }

    @Override
    public DefaultSO findObject() throws SQLException {
        DefaultsCtrSO defaultsCtrSO = new DefaultsCtrSO(this.getConnection(), this.getDatabaseSO());
        Object[] objectArray = new Object[]{this.getOwner(), this.getName()};
        List list = ((ASEBaseDBCtrSO)defaultsCtrSO).open(1, objectArray);
        return list.isEmpty() ? null : (DefaultSO)list.get(0);
    }

    public boolean reName(String string, String string2) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_rename ''{0}'', ''{1}''", string, string2));
        this._conn.executeCommand("setuser ");
        return true;
    }

    public void setUser() throws SQLException {
        this._conn.executeCommand(SQLs.getString("setuser ''{0}''", this.getOwner()));
    }

    public Vector referbyTable() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = TableBO.TABLE_ICON;
        this.getRSet().open(SQLs.getString("select distinct O.name, U.name from {0}.dbo.syscolumns C, {0}.dbo.sysobjects O, {0}.dbo.sysusers U where ( O.type = ''U'' or O.type = ''S'') and O.uid = U.uid and C.id = O.id and C.cdefault = {1}", this.getDatabaseName(), this.getObjectID()));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referbyUserType() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = UserTypeBO.UDT_ICON;
        this.getRSet().open(SQLs.getString("select t.name, b.name from {0}.dbo.systypes t, {0}.dbo.sysusers b, {0}.dbo.systypes p where t.uid = b.uid and t.usertype >= 100 and t.type = p.type and p.usertype = (select min(usertype) from {0}.dbo.systypes where type = t.type ) and t.tdefault = {1}", this.getDatabaseName(), this.getObjectID()));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getDatabaseName() + "." + this.getOwner() + "." + this.getName();
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_DEFAULT_TYPE");
    }

    static {
        TMPL_DEFAULT_NAME = "default-name";
    }
}

