/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DumpDevicesCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.List;

public class DumpDeviceSO
extends ASEBaseItemSO {
    private String _dumpDeviceName;
    private String _capacity;
    private String _physicalName;
    private String _ddpath = "";
    private String _ddcapacitytext = "";
    boolean _diskselected = false;
    protected static final int NAME = 0;
    private int TYPE = 1;
    private int CAPACITY = 2;
    private int PHYNAME = 3;
    public static final String DISK_TYPE = "Disk Dump Device";
    public static final String TAPE_TYPE = "Tape Dump Device";
    public static final String ARCHIVEDB_TYPE = "Archive DB Dump Device";
    private String _deviceType = "Disk Dump Device";

    public DumpDeviceSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
    }

    public DumpDeviceSO(ASConnection aSConnection) {
        super(aSConnection);
    }

    public void load(Object object) {
        String[] stringArray = (String[])object;
        this.setDeviceType(stringArray[this.TYPE]);
        this._capacity = stringArray[this.CAPACITY];
        this._physicalName = stringArray[this.PHYNAME];
    }

    @Override
    public void create() throws SQLException {
        this.useMasterDB();
        if (this.getDeviceType().equals(DISK_TYPE)) {
            String string = SQLs.getString("exec sp_addumpdevice ''disk'', ''{0}'', ''{1}''", this._dumpDeviceName, this._ddpath);
            this._conn.executeCommand(string);
        } else if (this.getDeviceType().equals(TAPE_TYPE)) {
            String string = SQLs.getString("exec sp_addumpdevice ''tape'', ''{0}'', ''{1}'', {2}", this._dumpDeviceName, this._ddpath, this._ddcapacitytext);
            this._conn.executeCommand(string);
        }
    }

    @Override
    public DumpDeviceSO findObject() throws SQLException {
        DumpDevicesCtrSO dumpDevicesCtrSO = new DumpDevicesCtrSO(this.getConnection());
        Object[] objectArray = new Object[]{this.getName()};
        List list = dumpDevicesCtrSO.open(1, objectArray);
        return list.isEmpty() ? null : (DumpDeviceSO)list.get(0);
    }

    public void markArchive() throws SQLException {
        this.useMasterDB();
        this.remove();
        String string = SQLs.getString("exec sp_addumpdevice ''archive database'', ''{0}'', ''{1}''", this.getName(), this._physicalName);
        this._conn.executeCommand(string);
    }

    @Override
    public void remove() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_dropdevice ''{0}''", this.getName());
        this._conn.executeCommand(string);
    }

    public String getDeviceType() {
        return this._deviceType;
    }

    public String getCapacity() {
        return this.getDeviceType().equals(DISK_TYPE) || this.getDeviceType().equals(ARCHIVEDB_TYPE) ? "NA" : this._capacity;
    }

    public String getPhysicalName() {
        return this._physicalName;
    }

    public void setPath(String string) {
        this._ddpath = string;
    }

    public void setCapacityText(String string) {
        this._ddcapacitytext = string;
    }

    public String getPath() {
        return this._ddpath;
    }

    public String getCapacityText() {
        return this._ddcapacitytext;
    }

    public void setDeviceType(String string) {
        if (this.getDumpDeviceName().equals("tapedump1")) {
            this._deviceType = TAPE_TYPE;
            return;
        }
        this._deviceType = Integer.parseInt(string) == 2 ? DISK_TYPE : (Integer.parseInt(string) == 0 ? ARCHIVEDB_TYPE : TAPE_TYPE);
    }

    public void setDumpDeviceName(String string) {
        this._dumpDeviceName = string;
    }

    public String getDumpDeviceName() {
        return this.getName();
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getDeviceType(), this.getCapacity(), this._physicalName};
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_DUMP_DEVICE_TYPE");
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSARole();
    }
}

