/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.ExecutionClassSO;
import com.sybase.aseplugin.so.SOCtrInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;

public class EngineGroupSO
extends ASEBaseItemSO {
    public static final String ANYENGINE = "ANYENGINE";
    public static final String LASTONLINE = "LASTONLINE";
    public static final String PRIORITY_HIGH = "HIGH";
    public static final String PRIORITY_MEDIUM = "MEDIUM";
    public static final String PRIORITY_LOW = "LOW";
    public static final String EC1 = "EC1";
    public static final String EC2 = "EC2";
    public static final String EC3 = "EC3";
    public static final int COL_NAME = 0;
    public static final int COL_ENGINE_NUMBER = 1;
    public static final int ATTR_ENGINE_NUMBER = 0;
    public static final int ATTR_ENGINE_STATUS = 1;
    public static final int ATTR_ENGINE_AFFINITIED = 2;
    public static final int ATTR_ENGINE_START_TIME = 3;
    private Object[] _attrs;
    private String _engineNumber;
    private int _instanceID = -1;

    public EngineGroupSO(ASConnection aSConnection) {
        super(aSConnection);
    }

    public EngineGroupSO(ASConnection aSConnection, int n) {
        super(aSConnection);
        this._instanceID = n;
    }

    public EngineGroupSO(ASConnection aSConnection, String string, String string2) {
        super(aSConnection, string);
        this._engineNumber = string2.trim();
        this._attrs = new String[]{string, this._engineNumber};
    }

    public EngineGroupSO(ASConnection aSConnection, SOCtrInterface sOCtrInterface, String[] stringArray) {
        super(aSConnection, sOCtrInterface);
        this._attrs = stringArray;
    }

    @Override
    public Object[] getAttributes() {
        return this._attrs;
    }

    @Override
    public Object getAttribute(int n) {
        return this._attrs[n];
    }

    @Override
    public void setAttribute(int n, Object object) {
        this._attrs[n] = object;
    }

    @Override
    public void create() throws SQLException {
        Object[] objectArray = this.getEngineNumbers();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            String string = this.getConnection().isCluster() ? SQLs.getString("exec sp_addengine {0}, ''{1}'', {2}", object, this.getName(), this._instanceID + "") : SQLs.getString("exec sp_addengine {0}, ''{1}''", object, this.getName());
            this._conn.executeCommand(string);
        }
    }

    @Override
    public void remove() throws SQLException {
        Object[] objectArray = this.getEngineNumbers();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = SQLs.getString("exec sp_dropengine {0}, ''{1}''", objectArray[i], this.getName(), this._instanceID + "");
            this._conn.executeCommand(string);
        }
    }

    public final String getEngineNumber() {
        return this._engineNumber;
    }

    public final void setEngineNumber(String string) {
        this._engineNumber = string;
    }

    public Object[] getEngineNumbers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getEngineNumber(), ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            arrayList.add(string);
        }
        return arrayList.toArray();
    }

    @Override
    public boolean exists() throws SQLException {
        String string = SQLs.getString("select * from master.dbo.sysattributes where class = 6 and attribute = 1 and object_type = ''EG'' and object_cinfo = ''{0}'' ", this.getName());
        this.getRSet().open(string);
        boolean bl = this.getRSet().getNextRow();
        this.getRSet().close();
        return bl;
    }

    public Vector getExecutionClasses() throws SQLException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        String string = SQLs.getString("select object_cinfo, substring(char_value,1, char_length(char_value)-1) from master.dbo.sysattributes where class = 6 and attribute = 2 and object_type = ''UC'' and charindex(''{0}'', char_value) > 0 ", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            object = this.getRSet().getColumnString(1).trim();
            String string2 = this.getRSet().getColumnString(2).trim();
            string2 = string2.substring(0, string2.indexOf(":"));
            ExecutionClassSO executionClassSO = new ExecutionClassSO(this.getConnection(), (String)object);
            executionClassSO.load(new String[]{object, string2, this.getDisplayName()});
            vector.add(executionClassSO);
        }
        this.getRSet().close();
        if (this.getDisplayName().equals(ANYENGINE)) {
            object = new ExecutionClassSO(this.getConnection(), EC1);
            ((ExecutionClassSO)object).load(new String[]{EC1, PRIORITY_HIGH, this.getDisplayName()});
            vector.add(object);
            object = new ExecutionClassSO(this.getConnection(), EC2);
            ((ExecutionClassSO)object).load(new String[]{EC2, PRIORITY_MEDIUM, this.getDisplayName()});
            vector.add(object);
        }
        if (this.getDisplayName().equals(LASTONLINE)) {
            object = new ExecutionClassSO(this.getConnection(), EC3);
            ((ExecutionClassSO)object).load(new String[]{EC3, PRIORITY_LOW, this.getDisplayName()});
            vector.add(object);
        }
        return vector;
    }

    public Vector getEngineList() throws SQLException {
        String string = "";
        Vector vector = new Vector();
        String string2 = SQLs.getString("select object_cinfo, substring(char_value,1, char_length(char_value)-1), text_value from master.dbo.sysattributes where class = 6 and attribute = 1 and object_type = ''EG'' and object_cinfo = ''{0}'' ", this.getName());
        this.getRSet().open(string2);
        while (this.getRSet().getNextRow()) {
            string = this.getRSet().getColumnString(2);
        }
        this.getRSet().close();
        string = string.replace(':', ',');
        if (string.length() > 0) {
            String string3 = SQLs.getString("select engine, status, affinitied, convert(varchar, starttime, 100) from master.dbo.sysengines where engine in ({0}) ", string);
            this.getRSet().open(string3);
            while (this.getRSet().getNextRow()) {
                Vector<Object> vector2 = new Vector<Object>();
                vector2.addElement(new JLabel(this.getRSet().getColumnString(1)));
                vector2.addElement(this.getRSet().getColumnString(2));
                vector2.addElement(this.getRSet().getColumnString(3));
                vector2.addElement(this.getRSet().getColumnString(4));
                vector.addElement(vector2);
            }
            this.getRSet().close();
        }
        return vector;
    }

    public Vector getEngineSelectionList() throws SQLException {
        Vector vector = new Vector();
        this.getRSet().open("select engine, status, affinitied, convert(varchar, starttime, 100) from master.dbo.sysengines where status = 'online'");
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1)));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector2.addElement(this.getRSet().getColumnString(3));
            vector2.addElement(this.getRSet().getColumnString(4));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getLastOnlineEngine() throws SQLException {
        Vector<Object> vector = new Vector<Object>();
        this.getRSet().open("select engine, status, affinitied, convert(varchar, starttime, 100) from master.dbo.sysengines where status = 'online' and engine in (select  max(engine) from master.dbo.sysengines where status = 'online') ");
        while (this.getRSet().getNextRow()) {
            vector.addElement(new JLabel(this.getRSet().getColumnString(1)));
            vector.addElement(this.getRSet().getColumnString(2));
            vector.addElement(this.getRSet().getColumnString(3));
            vector.addElement(this.getRSet().getColumnString(4));
        }
        this.getRSet().close();
        return vector;
    }

    public void dropEngine(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_dropengine {0}, ''{1}''", string, this.getName());
        this._conn.executeCommand(string2);
    }

    public void addEngine(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_addengine {0}, ''{1}''", string, this.getName());
        this._conn.executeCommand(string2);
    }

    public boolean isSystem() {
        String string = this.getName();
        boolean bl = string != null && (string.equals(LASTONLINE) || string.equals(ANYENGINE));
        return bl;
    }

    @Override
    public boolean includeDelete() {
        return !this.isSystem();
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSARole();
    }
}

