/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseTableItemSO;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class IndexSO
extends ASEBaseTableItemSO {
    public static final int ATTR_NAME = 0;
    public static final int ATTR_TYPE = 1;
    public static final int ATTR_SUSPECT = 2;
    public static final String ASCENDING = "asc";
    public static final String DESCENDING = "desc";
    private static final int FLAG_ABORT_DUPLICATE_KEY = 1;
    private static final int FLAG_UNIQUE = 2;
    private static final int FLAG_ABORT_DUPLICATE_ROW = 4;
    private static final int FLAG_CLUSTERED = 16;
    private static final int FLAG_ALLOW_DUPLICATE_ROW = 64;
    private static final int FLAG_SORTED_OBJECT = 128;
    private static final int FLAG_SORTED_DATA = 512;
    private static final int FLAG_INDEX_CREATED = 1024;
    private static final int FLAG_INDEX_PRIMARY_KEY = 2048;
    private static final int FLAG_SUSPECT = 32768;
    private static final int FLAG_SUPPORT_FKEY = 1;
    private static final int FLAG_SUPPORT_PKEY = 2;
    private static final int FLAG_IDENTITY = 4;
    private static final int FLAG_NO_CONSTRAINT_NAME = 8;
    private static final int FLAG_PREFETCH_ENABLE = 16;
    private static final int FLAG_MRU_CACHE_STRATEGY = 32;
    private static final int FLAG_ASCENDING_INSERTS = 64;
    private static final int IDX_STATUS2_FOR_CONSTRAINT = 2;
    private static final int IDX_STATUS_ONPKEY = 2048;
    private static final int IDX_STATUS_IGNORE_DUPKEYS = 1;
    private static final int IDX_STATUS_ABORT_DUPROWS = 4;
    private static final int IDX_STATUS2_MRU = 32;
    private static final int IDX_STATUS2_PREFETCH = 16;
    private static final int IDX_STATUS_PRESORTED = 512;
    private static final int IDX_STATUS2_CLUSTERED = 512;
    private int _id = 0;
    private int _status = 1;
    private int _status2 = 0;
    private Vector _columns;
    private Vector _columnsOrder;
    private String _segmentName = "";
    private String _cacheName = "";
    private int _colKeyCnt = 0;
    private int _maxRowsPerPage = 0;
    private int _fillFactor = 0;
    private int _pageGap = 0;
    private boolean _cacheStrategyModified = false;
    private String _indexedColumnNamesString = "";
    private String _partitionSpec;
    private boolean _isIndexPartition;

    public IndexSO(ASConnection aSConnection, TableSO tableSO, String string) {
        super(aSConnection, string, tableSO);
        this.setType("I");
    }

    public IndexSO(ASConnection aSConnection, TableSO tableSO, String string, int n, int n2, int n3, int n4, int n5, String string2) {
        super(aSConnection, string, tableSO);
        this._id = n;
        this._status = n2;
        this._status2 = n3;
        this._colKeyCnt = n4;
        this._maxRowsPerPage = n5;
        this._cacheName = string2;
        this.setType("I");
        this._indexedColumnNamesString = this.getIndexedColumnNames();
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getDatabaseName() + "." + this.getTableOwner() + "." + this.getTableName() + "." + this.getName();
    }

    @Override
    public void create() throws SQLException {
        int n;
        String string = "create ";
        if (this.isUniqueIndex()) {
            string = string + "unique ";
        }
        string = this.isClustered() ? string + "clustered " : string + "nonclustered ";
        string = string + "index " + this.getName() + " on ";
        string = string + this.getDatabaseName() + "." + this.getTableOwner() + "." + this.getTableName() + " ( ";
        for (n = 0; n < this._columns.size(); ++n) {
            string = string + this._columns.elementAt(n) + " " + this._columnsOrder.elementAt(n);
            if (n == this._columns.size() - 1) continue;
            string = string + ", ";
        }
        string = string + ") ";
        if (this.isDuplicateKey() || this.isDataSorted() || this.isIgnoreDuplicateRow() || this.isAllowDuplicateRow() || this.getPageGap() != 0 || this.getFillFactor() != 0 || this.getMaxRowsPerPage() != 0) {
            string = string + "with ";
        }
        n = 0;
        if (this.getFillFactor() != 0) {
            string = string + "fillfactor=" + this.getFillFactor() + " ";
            n = 1;
        }
        if (this.getMaxRowsPerPage() != 0) {
            if (n != 0) {
                string = string + ", ";
            }
            string = string + "max_rows_per_page=" + this.getMaxRowsPerPage() + " ";
            n = 1;
        }
        if (this.getPageGap() != 0) {
            if (n != 0) {
                string = string + ", ";
            }
            string = string + "reservepagegap=" + this.getPageGap();
            n = 1;
        }
        if (this.isDuplicateKey()) {
            if (n != 0) {
                string = string + ", ";
            }
            string = string + "ignore_dup_key ";
            n = 1;
        }
        if (!this.isDuplicateKey() && this.isClustered() && this.isAllowDuplicateRow()) {
            if (n != 0) {
                string = string + ", ";
            }
            string = string + "allow_dup_row ";
            n = 1;
        } else if (!this.isDuplicateKey() && this.isClustered() && this.isIgnoreDuplicateRow()) {
            if (n != 0) {
                string = string + ", ";
            }
            string = string + "ignore_dup_row ";
            n = 1;
        }
        if (this.isDataSorted()) {
            if (n != 0) {
                string = string + ", ";
            }
            string = string + "sorted_data ";
            n = 1;
        }
        this._databaseSO.useDB();
        Utility.setUser(this.getConnection(), this.getTableOwner());
        if (this.getSegmentName().length() > 0 && !this.getSegmentName().equals("default")) {
            string = string + "on " + this.getSegmentName();
        }
        if (this._partitionSpec != null) {
            string = string + " local index " + this._partitionSpec;
        }
        this._conn.executeCommand(string);
        if (this._cacheStrategyModified) {
            string = "exec sp_cachestrategy '" + this.getDatabaseName() + "', '" + this.getTableOwner() + "." + this.getTableName() + "', '" + this.getName() + "', mru, '";
            string = string + (this.isMRUCacheStrategy() ? "on" : "off") + "' ";
            this._conn.executeCommand(string);
            string = "exec sp_cachestrategy '" + this.getDatabaseName() + "', '" + this.getTableOwner() + "." + this.getTableName() + "', '" + this.getName() + "', prefetch, '";
            string = string + (this.isBufferPrefetch() ? "on" : "off") + "' ";
            this._conn.executeCommand(string);
        }
        if (this.getCacheName().length() > 0 && !this.isDefaultDataCache(this.getCacheName())) {
            string = "exec sp_bindcache '" + this.getCacheName() + "', '" + this.getDatabaseName() + "', '" + this.getTableOwner() + "." + this.getTableName() + "', '" + this.getName() + "' ";
            this._conn.executeCommand(string);
        }
        if (this._fillFactor != 0) {
            this.setFillFactor(String.valueOf(this._fillFactor));
        }
        if (this._maxRowsPerPage != 0) {
            this.setMaxRowsPerPage(String.valueOf(this._maxRowsPerPage));
        }
        if (this._pageGap != 0) {
            this.setReservePageGap(String.valueOf(this._pageGap));
        }
        Utility.unSetUser(this.getConnection());
    }

    @Override
    public void remove() throws SQLException {
        String string = SQLs.getString("drop index {0}.{1}", this.getTableName(), this.getName());
        this._databaseSO.useDB();
        this.assignTableUser();
        this._conn.executeCommand(string);
        this.unAssignTableUser();
    }

    @Override
    public Object[] getAttributes() {
        return new Object[]{this.getName(), ASEUtils.getString("MSG_INDEX_TYPE"), this.clusteredYesNoText(), this.uniqueYesNoText(), this.getIndexedColumnNamesString()};
    }

    public boolean isSuspect() {
        return 0 != (this._status & 0x8000);
    }

    public String isSuspectText() {
        return this.isSuspect() ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
    }

    public boolean isClustered() {
        boolean bl = (this._status & 0x10) != 0 || (this._status2 & 0x200) != 0;
        return bl;
    }

    public String clusteredText() {
        return this.isClustered() ? ASEUtils.getString("MSG_CLUSTERED_TYPE") : ASEUtils.getString("MSG_NOT_CLUSTERED_TYPE");
    }

    public String clusteredYesNoText() {
        return this.isClustered() ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
    }

    public boolean isUniqueIndex() {
        return (this._status & 2) != 0;
    }

    public String uniqueText() {
        return this.isUniqueIndex() ? ASEUtils.getString("MSG_UNIQUE_TYPE") : ASEUtils.getString("MSG_NOT_UNIQUE_TYPE");
    }

    public String uniqueYesNoText() {
        return this.isUniqueIndex() ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
    }

    public boolean isDuplicateKey() {
        boolean bl = (this._status & 1) == 0;
        return bl;
    }

    public boolean isDataSorted() {
        return 0 != (this._status & 0x200);
    }

    public boolean isIgnoreDuplicateRow() {
        boolean bl = (this._status & 4) != 0;
        return bl;
    }

    public boolean isAllowDuplicateRow() {
        boolean bl = (this._status & 0x40) != 0;
        return bl;
    }

    public int getPageGap() {
        return this._pageGap;
    }

    public int getFillFactor() {
        return this._fillFactor;
    }

    public final void setFillFactor(int n) {
        this._fillFactor = n;
    }

    public void setFillFactor(String string) throws SQLException {
        this._databaseSO.useDB();
        this.assignTableUser();
        String string2 = SQLs.getString("exec sp_chgattribute ''{0}'', ''fillfactor'', {1}", this.getTableName() + "." + this.getName(), string);
        this._conn.executeCommand(string2);
        this.unAssignTableUser();
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public boolean isMRUCacheStrategy() {
        return 0 != (this._status2 & 0x20);
    }

    public boolean isBufferPrefetch() {
        return 0 != (this._status2 & 0x10);
    }

    public String getCacheName() {
        return this._cacheName;
    }

    private void assignTableUser() throws SQLException {
        Utility.setUser(this.getConnection(), this.getTableOwner());
    }

    private void unAssignTableUser() throws SQLException {
        Utility.unSetUser(this.getConnection());
    }

    public boolean isDefaultDataCache(String string) throws SQLException {
        List list = this.getAvailableCaches();
        String string2 = "";
        for (CacheSO cacheSO : list) {
            if (!cacheSO.isDefaultDataCache()) continue;
            string2 = cacheSO.getName();
            break;
        }
        return string.equals(string2);
    }

    public List getAvailableCaches() throws SQLException {
        return this._databaseSO.getActiveCaches();
    }

    public void reName(String string, String string2) throws SQLException {
        this.assignTableUser();
        Utility.reName(this.getConnection(), string, string2, this.getDatabaseName());
        Utility.unSetUser(this.getConnection());
    }

    public void unSetCache() throws SQLException {
        String string = SQLs.getString("exec sp_unbindcache  {0} , ''{1}.{2}'', {3}", new Object[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getName()});
        this._conn.executeCommand(string);
    }

    public void setCache(String string) throws SQLException {
        this._databaseSO.useDB();
        this.assignTableUser();
        String string2 = SQLs.getString("exec sp_bindcache ''{0}'', {1} , ''{2}.{3}'', {4}", new Object[]{string, this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getName()});
        this._conn.executeCommand(string2);
        this.unAssignTableUser();
    }

    public List getAvailableSegments() throws SQLException {
        return this._tableSO.getAvailableSegments();
    }

    public Vector getColumnNameOrderList() throws SQLException {
        String string = this._tableSO.getFullyQualifiedName();
        Vector vector = new Vector();
        for (int i = 0; i < this._colKeyCnt; ++i) {
            String string2 = SQLs.getString("select index_col(''{0}'', {1}, {2}), index_colorder(''{0}'', {1}, {2})", string, String.valueOf(this._id), String.valueOf(i + 1));
            Vector<String[]> vector2 = Utility.openQuery2(string2, this.getConnection());
            String[] stringArray = vector2.elementAt(0);
            if (stringArray[0].length() == 0) continue;
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement(stringArray[0]);
            vector3.addElement(stringArray[1]);
            vector.addElement(vector3);
        }
        return vector;
    }

    public String getIndexedColumnNamesString() {
        return this._indexedColumnNamesString;
    }

    public String getIndexedColumnNames() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = null;
        try {
            vector = this.getColumnNameOrderList();
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.get(i);
                stringBuffer.append(vector2.get(0));
                if (i >= vector.size() - 1) continue;
                stringBuffer.append(", ");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public boolean supportsConstraint() {
        boolean bl = (this._status2 & 2) != 0;
        return bl;
    }

    public boolean isOnPrimaryKey() {
        boolean bl = (this._status & 0x800) != 0;
        return bl;
    }

    public boolean getMruCaching() {
        boolean bl = (this._status2 & 0x20) == 0;
        return bl;
    }

    public void setMruCaching(boolean bl) throws SQLException {
        this._databaseSO.useDB();
        this.assignTableUser();
        String string = this.getTableOwner() + "." + this.getTableName();
        String string2 = SQLs.getString("exec sp_cachestrategy ''{0}'', ''{1}'', ''{2}'', {3}, ''{4}''", new Object[]{this.getDatabaseName(), string, this.getName(), "mru", bl ? "on" : "off"});
        this._conn.executeCommand(string2);
        this.unAssignTableUser();
    }

    public boolean getPrefetchCaching() {
        boolean bl = (this._status2 & 0x10) == 0;
        return bl;
    }

    public void setPrefetchCaching(boolean bl) throws SQLException {
        this._databaseSO.useDB();
        this.assignTableUser();
        String string = this.getTableOwner() + "." + this.getTableName();
        String string2 = SQLs.getString("exec sp_cachestrategy ''{0}'', ''{1}'', ''{2}'', {3}, ''{4}''", new Object[]{this.getDatabaseName(), string, this.getName(), "prefetch", bl ? "on" : "off"});
        this._conn.executeCommand(string2);
        this.unAssignTableUser();
    }

    public int getMaxRowsPerPage() {
        return this._maxRowsPerPage;
    }

    public final void setMaxRowsPerPage(int n) {
        this._maxRowsPerPage = n;
    }

    public void setMaxRowsPerPage(String string) throws SQLException {
        this._databaseSO.useDB();
        this.assignTableUser();
        String string2 = SQLs.getString("exec sp_chgattribute ''{0}'', ''max_rows_per_page'', {1}", this.getTableName() + "." + this.getName(), string);
        this._conn.executeCommand(string2);
        this.unAssignTableUser();
    }

    public boolean ignoreDuplicateKeys() {
        boolean bl = (this._status & 1) != 0;
        return bl;
    }

    public boolean abortDuplicateRows() {
        boolean bl = (this._status & 4) != 0;
        return bl;
    }

    public boolean wasDataPresorted() {
        boolean bl = (this._status & 0x200) != 0;
        return bl;
    }

    public void getUniqueFactorAttr() throws SQLException {
        this._databaseSO.useDB();
        String string = SQLs.getString("select I.res_page_gap, I.fill_factor, S.name from {0}.dbo.sysobjects O, {0}.dbo.sysindexes I, {0}.dbo.sysusers U, {0}.dbo.syssegments S where U.uid = O.uid and I.id = {1} and I.id = O.id and I.segment = S.segment and I.indid = {2} ", this.getDatabaseName(), this._tableSO.getTableObjectID(), this.getIndexID());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            this._pageGap = this.getRSet().getColumnInt(1);
            this._fillFactor = this.getRSet().getColumnInt(2);
            this._segmentName = this.getRSet().getColumnString(3);
        }
        this.getRSet().close();
    }

    public int getReservePageGap() {
        return this._pageGap;
    }

    public final void setReservePageGap(int n) {
        this._pageGap = n;
    }

    public void setReservePageGap(String string) throws SQLException {
        this._databaseSO.useDB();
        this.assignTableUser();
        String string2 = SQLs.getString("exec sp_chgattribute ''{0}'', ''reservepagegap'', {1}", this.getTableName() + "." + this.getName(), string);
        this._conn.executeCommand(string2);
        this.unAssignTableUser();
    }

    public int getID() {
        return this._id;
    }

    public String getIndexID() {
        return String.valueOf(this.getID());
    }

    public Vector getTableIndex() throws SQLException {
        String string = SQLs.getString("select C.name, isnull(X.xtname, isnull(get_xtypename(C.xtype), T.name)),C.length, C.prec, C.scale, C.status, C.remote_name,(select T.name from {0}.dbo.systypes T where C.remote_type = T.type and C.usertype = T.usertype) from {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X where C.id = {1} and C.usertype *= T.usertype and C.xtype *= X.xtid order by C.name ", this.getDatabaseName(), this._tableSO.getTableObjectID());
        Vector<String[]> vector = Utility.openQuery2(string, this.getConnection());
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = vector.elementAt(i);
            if (stringArray[0].length() == 0) continue;
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement(stringArray[0]);
            vector3.addElement(stringArray[1]);
            vector2.addElement(vector3);
        }
        return vector2;
    }

    public void bindToSegment(String string) throws SQLException {
        this._databaseSO.useDB();
        this.assignTableUser();
        String string2 = SQLs.getString("exec sp_placeobject ''{0}'', ''{1}''", string, this.getTableOwner() + "." + this.getTableName() + "." + this.getName());
        this._conn.executeCommand(string2);
        this.unAssignTableUser();
    }

    public void setColumns(Vector vector) {
        this._columns = vector;
    }

    public Object[] getColumns() {
        return this._columns.toArray();
    }

    public void setColumnsOrder(Vector vector) {
        this._columnsOrder = vector;
    }

    public void setSegmentName(String string) {
        this._segmentName = string;
    }

    public void setCacheName(String string) {
        this._cacheName = string;
    }

    public void setUniqueIndex(boolean bl) {
        this._status = this.setResetBit(this._status, 2, bl);
    }

    public void setClusteredIndex(boolean bl) {
        this._status = this.setResetBit(this._status, 16, bl);
    }

    public void setDuplicateKey(boolean bl) {
        this._status = this.setResetBit(this._status, 1, !bl);
    }

    public void setDuplicateRow(boolean bl, boolean bl2) throws IllegalArgumentException {
        if (bl && bl2) {
            throw new IllegalArgumentException("Error: cannot allow and ignore duplicate row simultaneously.");
        }
        this._status = this.setResetBit(this._status, 64, bl);
        this._status = this.setResetBit(this._status, 4, bl2);
    }

    private int setResetBit(int n, int n2, boolean bl) {
        int n3 = bl ? n | n2 : n & ~n2;
        return n3;
    }

    public boolean isNotAllowDuplicateRow() {
        return !this.isAllowDuplicateRow() && !this.isIgnoreDuplicateRow();
    }

    @Override
    public boolean exists() throws SQLException {
        String string = SQLs.getString("select I.name from {0}.dbo.sysobjects O, {0}.dbo.sysindexes I, {0}.dbo.sysusers U where I.id = O.id and I.id = {1} and I.name = ''{2}'' and I.indid between 1 and 254", this.getDatabaseName(), this._tableSO.getTableObjectID(), this.getName());
        this.getRSet().open(string);
        boolean bl = this.getRSet().getNextRow();
        this.getRSet().close();
        return bl;
    }

    public void setDataSorted(boolean bl) {
        this._status = this.setResetBit(this._status, 512, bl);
    }

    public void setMRUCacheStrategy(boolean bl) {
        this._cacheStrategyModified = true;
        this._status2 = this.setResetBit(this._status2, 32, bl);
    }

    public void setBufferPrefetch(boolean bl) {
        this._cacheStrategyModified = true;
        this._status2 = this.setResetBit(this._status2, 16, bl);
    }

    public boolean clusteredIndexExists() throws SQLException {
        return this._tableSO.clusteredIndexExists();
    }

    public String checkDatabaseConsistency(String string) throws SQLException {
        return Utility.checkDatabaseConsistency(this.getConnection(), this.getDatabaseSO(), string);
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_INDEX_TYPE");
    }

    public void setPartitionSpec(String string) {
        this._partitionSpec = string;
    }

    public void setIndexPartition(boolean bl) {
        this._isIndexPartition = bl;
    }

    public boolean isIndexPartition() {
        return this._isIndexPartition;
    }
}

