/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;

public class JobHistorySO
extends ASEBaseItemSO
implements DateSorter {
    public static final int ID = 0;
    public static final int SJOB_ID = 1;
    public static final int JOB_NAME = 2;
    public static final int SCHED_NAME = 3;
    public static final int JOB_STATE = 4;
    public static final int JOB_START = 5;
    public static final int JOB_END = 6;
    public static final int JOB_EXIT_CODE = 7;
    public static final int JOB_USER_CODE = 8;
    public static final int JOB_ATAT_ERROR = 9;
    public static final int JOB_OS_CODE = 10;
    public static final int JOB_USER_RUN = 11;
    public static final int JOB_USER_REQ = 12;
    public static final int JOB_SHORT_MESSAGE = 13;
    public static final int JOB_LONG_MESSAGE = 14;
    public static final int JOB_LOG_SIZE = 15;
    public static final int JOB_SERVER = 16;
    public static final int JOB_SPID = 17;
    private static String NONE = ASEUtils.getString("MSG_NONE");
    private static String UNKNOWN = ASEUtils.getString("MSG_UNKNOWN");
    private static String WAITING = ASEUtils.getString("MSG_JS_STATE_WAITING");
    private static String QUEUED = ASEUtils.getString("MSG_JS_STATE_QUEUED");
    private static String RUNNABLE = ASEUtils.getString("MSG_JS_STATE_RUNNABLE");
    private static String RUNNING = ASEUtils.getString("MSG_JS_STATE_RUNNING");
    private static String EXPIRING = ASEUtils.getString("MSG_JS_STATE_EXPIRING");
    private static String EXPIRED = ASEUtils.getString("MSG_JS_STATE_EXPIRED");
    private static String COMPLETING = ASEUtils.getString("MSG_JS_STATE_COMPLETING");
    private static String COMPLETED = ASEUtils.getString("MSG_JS_STATE_COMPLETED");
    private static String TERMINATING = ASEUtils.getString("MSG_JS_STATE_TERMINATING");
    private static String TERMINATED = ASEUtils.getString("MSG_JS_STATE_TERMINATED");
    private static String BUSY = ASEUtils.getString("MSG_JS_STATE_BUSY");
    private static String MISSED = ASEUtils.getString("MSG_JS_STATE_MISSED");
    private int _id;
    private int _sjobid;
    private int _exitCode;
    private int _userCode;
    private int _osCode;
    private int _atatError;
    private int _jobLogSize;
    private int _spid;
    private String _jobName;
    private String _scheduleName;
    private String _server;
    private String _jobState;
    private String _jobStateDisplay;
    private String _userReq;
    private String _userRun;
    private String _jobLmsg;
    private String _jobSmsg;
    private Date _jobStart;
    private Date _jobEnd;
    private boolean _purgeByName = false;
    private boolean _purgeByUser = false;
    private boolean _purgeByAge = false;
    private boolean _purgeBySize = false;
    private boolean _verifyPurge = false;
    private String _purgeName;
    private String _purgeUser;
    private int _purgeAge;
    private int _purgeSize;
    private boolean _loaded = false;
    private boolean _allUsers;

    public JobHistorySO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
    }

    public void load(String[] stringArray) {
        this.setID(stringArray[0]);
        this.setSJID(stringArray[1]);
        this.setJobName(stringArray[2]);
        this.setScheduleName(stringArray[3]);
        this.setState(stringArray[4]);
        this.setStartTime(stringArray[5]);
        this.setEndTime(stringArray[6]);
        this.setExitCode(stringArray[7]);
        this.setUserCode(stringArray[8]);
        this.setOsCode(stringArray[10]);
        this.setAtAtError(stringArray[9]);
        this.setExecutedAs(stringArray[11]);
        this.setRequestor(stringArray[12]);
        this.setShortMessage(stringArray[13]);
        this.setLongMessage(stringArray[14]);
        this.setLogSize(stringArray[15]);
        this.setServer(stringArray[16]);
        this.setSPID(stringArray[17]);
        this._loaded = true;
    }

    public void setAllUsers(boolean bl) {
        this._allUsers = bl;
    }

    @Override
    public void create() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_dropjobhistory @option=''{0},force''", this.getPurgeOptions());
        this._conn.executeCommand(string);
    }

    @Override
    public void remove() throws SQLException {
        String string = this._allUsers ? SQLs.getString("exec sybmgmtdb..sp_dropjobhistory @option=''{0},all_users,force''", "runid=" + this.getID()) : SQLs.getString("exec sybmgmtdb..sp_dropjobhistory @option=''{0},force''", "runid=" + this.getID());
        this._conn.executeCommand(string);
    }

    @Override
    public Object[] getAttributes() {
        if (this._loaded) {
            return new String[]{this.getID(), this.getStartTime(), this.getJobName(), this.getScheduleName(), this.getServer(), this.getRequestor(), this.getExecutedAs(), this.getEndTime(), this.getStateForDisplay(), this.getResultForDisplay(), this.getJobLogSize()};
        }
        return null;
    }

    @Override
    public Date getDate(int n) {
        Date date;
        switch (n) {
            case 1: {
                date = this._jobStart;
                break;
            }
            case 7: {
                date = this._jobEnd;
                break;
            }
            default: {
                date = null;
            }
        }
        return date;
    }

    public void setID(String string) {
        try {
            this._id = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._id = -1;
        }
    }

    public void setSJID(String string) {
        try {
            this._sjobid = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._sjobid = -1;
        }
    }

    public void setSPID(String string) {
        try {
            this._spid = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._spid = -1;
        }
    }

    public void setJobName(String string) {
        this._jobName = string;
    }

    public void setScheduleName(String string) {
        this._scheduleName = string;
    }

    public void setServer(String string) {
        this._server = string;
    }

    public void setState(String string) {
        this._jobState = string;
        this._jobStateDisplay = this._jobState.equals("W") ? WAITING : (this._jobState.equals("Q") ? QUEUED : (this._jobState.equals("R1") ? RUNNABLE : (this._jobState.equals("R2") ? RUNNING : (this._jobState.equals("X1") ? EXPIRING : (this._jobState.equals("X2") ? EXPIRED : (this._jobState.equals("C1") ? COMPLETING : (this._jobState.equals("C2") ? COMPLETED : (this._jobState.equals("T1") ? TERMINATING : (this._jobState.equals("T2") ? TERMINATED : (this._jobState.equals("B") ? BUSY : (this._jobState.equals("M") ? MISSED : UNKNOWN)))))))))));
    }

    public void setStartTime(String string) {
        try {
            this._jobStart = JSBaseSO.aseDateTimeFormat.parse(string);
        }
        catch (ParseException parseException) {
            this._jobStart = null;
        }
    }

    public void setEndTime(String string) {
        try {
            this._jobEnd = JSBaseSO.aseDateTimeFormat.parse(string);
        }
        catch (ParseException parseException) {
            this._jobEnd = null;
        }
    }

    public void setExitCode(String string) {
        try {
            this._exitCode = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._exitCode = 0;
        }
    }

    public void setUserCode(String string) {
        try {
            this._userCode = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._userCode = 0;
        }
    }

    public void setOsCode(String string) {
        try {
            this._osCode = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._osCode = 0;
        }
    }

    public void setAtAtError(String string) {
        try {
            this._atatError = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._atatError = 0;
        }
    }

    public void setExecutedAs(String string) {
        this._userRun = string;
    }

    public void setRequestor(String string) {
        this._userReq = string;
    }

    public void setShortMessage(String string) {
        this._jobSmsg = string;
    }

    public void setLongMessage(String string) {
        this._jobLmsg = string;
    }

    public void setLogSize(String string) {
        try {
            this._jobLogSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._jobLogSize = 0;
        }
    }

    public String getID() {
        return String.valueOf(this._id);
    }

    public String getSJID() {
        return String.valueOf(this._sjobid);
    }

    public String getSPID() {
        return String.valueOf(this._spid);
    }

    public String getJobName() {
        if (this._jobName == null) {
            return UNKNOWN;
        }
        return this._jobName;
    }

    public String getScheduleName() {
        if (this._scheduleName == null) {
            return UNKNOWN;
        }
        return this._scheduleName;
    }

    public String getServer() {
        if (this._server == null) {
            return UNKNOWN;
        }
        return this._server;
    }

    public String getState() {
        return this._jobState;
    }

    public String getStateForDisplay() {
        return this._jobStateDisplay;
    }

    private String getResultForDisplay() {
        String string = null;
        string = this._exitCode == 1 && this._userCode == 0 && this._osCode == 0 && this._atatError == 0 ? ASEUtils.getString("MSG_NO_ERRORS") : ASEUtils.getString("MSG_ERRORS_REPORTED");
        return string;
    }

    public String getStartTime() {
        return this.getASEDateTime(this._jobStart);
    }

    public String getEndTime() {
        return this.getASEDateTime(this._jobEnd);
    }

    public String getExitCode() {
        return String.valueOf(this._exitCode);
    }

    public String getUserCode() {
        return String.valueOf(this._userCode);
    }

    public String getOsCode() {
        return String.valueOf(this._osCode);
    }

    public String getAtAtError() {
        return String.valueOf(this._atatError);
    }

    public String getExecutedAs() {
        if (this._userRun == null) {
            return UNKNOWN;
        }
        return this._userRun;
    }

    public String getRequestor() {
        if (this._userReq == null) {
            return UNKNOWN;
        }
        return this._userReq;
    }

    public String getShortMessage() {
        if (this._jobSmsg == null) {
            return NONE;
        }
        return this._jobSmsg;
    }

    public String getLongMessage() {
        if (this._jobLmsg == null) {
            return NONE;
        }
        return this._jobLmsg;
    }

    public String getJobLogSize() {
        return String.valueOf(this._jobLogSize);
    }

    public void setPurgeByName(boolean bl) {
        this._purgeByName = bl;
    }

    public boolean getPurgeByName() {
        return this._purgeByName;
    }

    public void setPurgeName(String string) {
        this._purgeName = string;
    }

    public String getPurgeName() {
        return this._purgeName;
    }

    public void setPurgeByUser(boolean bl) {
        this._purgeByUser = bl;
    }

    public boolean getPurgeByUser() {
        return this._purgeByUser;
    }

    public void setPurgeUser(String string) {
        this._purgeUser = string;
    }

    public String getPurgeUser() {
        return this._purgeUser;
    }

    public void setPurgeBySize(boolean bl) {
        this._purgeBySize = bl;
    }

    public boolean getPurgeBySize() {
        return this._purgeBySize;
    }

    public void setPurgeSize(int n) {
        this._purgeSize = n;
    }

    public int getPurgeSize() {
        return this._purgeSize;
    }

    public void setPurgeByAge(boolean bl) {
        this._purgeByAge = bl;
    }

    public boolean getPurgeByAge() {
        return this._purgeByAge;
    }

    public void setPurgeAge(int n) {
        this._purgeAge = n;
    }

    public int getPurgeAge() {
        return this._purgeAge;
    }

    public void setPurgeVerify(boolean bl) {
        this._verifyPurge = bl;
    }

    public boolean getPurgeVerify() {
        return this._verifyPurge;
    }

    public int getPurgeCount() {
        int n = 0;
        String string = SQLs.getString("exec sybmgmtdb..sp_listjobhistory @option=''list=count,{0}''", this.getPurgeOptions());
        try {
            this.getRSet().open(string);
            if (this.getRSet().getNextRow()) {
                n = this.getRSet().getColumnInt(1);
            }
            this.getRSet().close();
        }
        catch (SQLException sQLException) {
            n = 0;
        }
        return n;
    }

    public String getJobOutput() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = SQLs.getString("exec sybmgmtdb..sp_readjoboutput @runid=''{0}''", this.getID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringBuffer.append(this.getRSet().getColumnString(1));
        }
        this.getRSet().close();
        return stringBuffer.toString();
    }

    private String getASEDateTime(Date date) {
        String string = date == null ? "" : JSBaseSO.aseDateTimeFormat.format(date);
        return string;
    }

    private String getPurgeOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._purgeByName) {
            stringBuffer.append("jname=" + this._purgeName + ",");
        }
        if (this._purgeByUser) {
            stringBuffer.append("user=" + this._purgeUser + ",");
        }
        if (this._purgeByAge) {
            stringBuffer.append("age=" + this._purgeAge + ",");
        }
        if (this._purgeBySize) {
            stringBuffer.append("minsize=" + this._purgeSize + ",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.toString().lastIndexOf(","));
            return stringBuffer.toString();
        }
        return null;
    }
}

