/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.so.JobTemplateSO;
import com.sybase.aseplugin.so.JobsCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class JobSO
extends JSBaseSO {
    private JobTemplateSO _jstSO = null;

    public JobSO(ASConnection aSConnection, JobsCtrSO jobsCtrSO) {
        super(aSConnection, jobsCtrSO);
        this.detailedTraceThis("Constructor For JobSO(conn, parent)");
        this.init(null);
        this._jstSO = new JobTemplateSO(aSConnection, "");
    }

    public JobSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
        this.init(null);
        this.setColumn(1, string);
    }

    public JobSO(ASConnection aSConnection, JobsCtrSO jobsCtrSO, String[] stringArray) {
        super(aSConnection, jobsCtrSO);
        this.detailedTraceThis("Constructor For JobSO(conn, parent, columns[])");
        this.init(stringArray);
        super.setName(this.getColumn(1));
        this._jstSO = new JobTemplateSO(aSConnection, "");
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_JOB_TEXT");
    }

    private String[] getDefaultColumns() {
        return new String[]{"0", "", "", "", "", "0", "0", "60", "", "", "false", "false", "false", "false", "true"};
    }

    public void init(String[] stringArray) {
        this.setType("JS_JOB");
        if (stringArray == null) {
            this.setColumns(this.getDefaultColumns());
        } else {
            this.initColumns(stringArray);
        }
    }

    private void initColumns(String[] stringArray) {
        this.setColumns(this.getDefaultColumns());
        for (int i = 0; i < stringArray.length && i < 15; ++i) {
            this.setColumn(i, stringArray[i]);
        }
        boolean bl = false;
        bl = this.getPropValue("multi_task", this.getColumn(6));
        this.setColumn(10, Boolean.toString(bl));
        bl = this.getPropValue("run_as_owner", this.getColumn(6));
        this.setColumn(12, Boolean.toString(bl));
        bl = this.getPropValue("shared", this.getColumn(6));
        this.setColumn(11, Boolean.toString(bl));
        bl = this.getPropValue("no_conn_redirection", this.getColumn(6));
        this.setColumn(14, Boolean.toString(bl));
    }

    @Override
    public void convertListToProperties(String string) {
        this.setRunAsOwner(this.checkList(string, "run_as_owner"));
        this.setConcurrency(this.checkList(string, "multi_task"));
        this.setSharing(this.checkList(string, "shared"));
        this.setAllowRedirect(!this.checkList(string, "no_conn_redirection"));
    }

    @Override
    public String convertPropertiesToPropList() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("run_as_owner=" + this.getColumn(12) + ",");
        stringBuffer.append("multi_task=" + this.getColumn(10) + ",");
        stringBuffer.append("shared=" + this.getColumn(11));
        if (this.getConnection().isCluster()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("no_conn_redirection=" + (this.getColumn(14).equalsIgnoreCase("true") ? "false" : "true"));
        }
        return stringBuffer.toString();
    }

    public String getSQL() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_listjobtext @jname_id=''{0}''", this.getColumn(0));
        this.traceThis("openClause = " + string);
        StringBuffer stringBuffer = new StringBuffer("");
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringBuffer.append(this.getRSet().getColumnsAsArray()[0]);
        }
        this.setColumn(9, stringBuffer.toString());
        return stringBuffer.toString();
    }

    @Override
    public void copy(String string) throws SQLException {
        String string2 = SQLs.getString("exec sybmgmtdb..sp_copyjob @jname_id=''{0}'',@newname=''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    @Override
    public void remove() throws SQLException {
        String string = this.getAllUsers() ? SQLs.getString("exec sybmgmtdb..sp_dropjob @jname_id=''{0}'', @option=''all_users''", this.getColumn(0)) : SQLs.getString("exec sybmgmtdb..sp_dropjob @jname_id=''{0}''", this.getColumn(0));
        this.traceThis("SQL Job Def Delete String = " + string);
        this._conn.executeCommand(string);
    }

    @Override
    public boolean exists() {
        boolean bl;
        try {
            this.getRSet().open(SQLs.getString("exec sybmgmtdb..sp_listjob @option=''jname={0}''", this.getName()));
            bl = this.getRSet().getNextRow();
            this.getRSet().close();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public void createNewJob() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_createscheduledjob @jname=''{0}''", JobSO.fixSingleQuotesInString(this.getName()));
        this._conn.executeCommand(string);
        StringBuffer stringBuffer = new StringBuffer("exec sybmgmtdb..sp_listjob ");
        stringBuffer.append("@jname='" + JobSO.fixSingleQuotesInString(this.getName()) + "'");
        this.getRSet().open(stringBuffer.toString());
        String string2 = this.getColumn(0);
        while (this.getRSet().getNextRow()) {
            string2 = this.getRSet().getColumnsAsArray()[0];
        }
        this.setColumn(0, string2);
        this.createNewJobText();
        this.update(2);
        this.update(7);
        this.update(8);
        this.update(6);
    }

    public void createNewJobText() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_addjobtext @jname_id=''{0}'', @text=''{1}''", this.getColumn(0), JobSO.fixSingleQuotesInString(this.getJobSQLText()));
        this._conn.executeCommand(string);
    }

    @Override
    public void create() throws SQLException {
        String string = this.getConnection().getVersion();
        if (string.compareTo("15") < 0) {
            this.createNewJob();
            return;
        }
        Object[] objectArray = new Object[]{JobSO.fixSingleQuotesInString(this.getName()), JobSO.fixSingleQuotesInString(this.getDescription()), JobSO.fixSingleQuotesInString(this.convertPropertiesToPropList())};
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("exec sybmgmtdb..sp_createjob @jname=''{0}'', @jdesc=''{1}'', @properties=''{2}''", objectArray));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 7, this.getColumn(7));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 8, this.getColumn(8));
        this.traceThis("Create Job SQL: " + stringBuffer);
        this._conn.executeCommand(stringBuffer.toString());
        this.createJobCommand(this.getColumn(1), this.getJobSQLText());
    }

    protected void createJobCommand(String string, String string2) throws SQLException {
        int n = 8000;
        int n2 = 0;
        int n3 = 0;
        String string3 = null;
        while (n3 < string2.length()) {
            n3 = n3 + n < string2.length() ? n3 + n : string2.length();
            string3 = string2.substring(n2, n3);
            String string4 = SQLs.getString("exec sybmgmtdb..sp_addjobtext @jname_id=''{0}'', @text=''{1}''", JobSO.fixSingleQuotesInString(string), JobSO.fixSingleQuotesInString(string3));
            this.traceThis("Job Cmd Chunk: " + string4);
            this._conn.executeCommand(string4);
            n2 = n3;
        }
    }

    public void update() throws SQLException {
        Vector vector = this.getUpdateFlags();
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.indexOf(new Integer(9));
        boolean bl = false;
        if (n > -1) {
            vector.remove(n);
            bl = true;
        }
        this.setColumn(6, this.convertPropertiesToPropList());
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("exec sybmgmtdb..sp_modifyscheduledjob @jname_id=''{0}'',", this.getID(0)));
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            this.addColumnValuetoSQL(stringBuffer, n2, this.getColumn(n2));
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this._conn.executeCommand(stringBuffer.toString());
        if (bl) {
            this.updateJobCommand();
        }
        this.clearUpdateFlags();
    }

    public void update(int n, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("exec sybmgmtdb..sp_modifyscheduledjob @jname_id=''{0}'',", this.getColumn(0)));
        this.addColumnValuetoSQL(stringBuffer, n, string);
        this._conn.executeCommand(stringBuffer.toString());
    }

    public void update(int n) throws SQLException {
        if (n == 6) {
            this.setColumn(6, this.convertPropertiesToPropList());
        }
        this.update(n, this.getColumn(n));
    }

    public void updateJobCommand() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_dropjobtext @jname_id=''{0}''", this.getColumn(0));
        this.traceThis("SQL Job SQL Delete String = " + string);
        this._conn.executeCommand(string);
        this.createJobCommand(this.getColumn(1), this.getJobSQLText());
    }

    @Override
    public void addColumnValuetoSQL(StringBuffer stringBuffer, int n, String string) {
        if (string == null) {
            string = this.getColumn(n);
        }
        switch (n) {
            case 1: {
                stringBuffer.append("@jname=" + JobSO.argString(string));
                break;
            }
            case 2: {
                stringBuffer.append("@jdesc=" + JobSO.argString(string));
                break;
            }
            case 7: {
                stringBuffer.append("@default_timeout=" + JobSO.argInt(string));
                break;
            }
            case 8: {
                stringBuffer.append("@tmpl_id=" + JobSO.argInt(string));
                break;
            }
            case 6: {
                stringBuffer.append("@jproperties=" + JobSO.argString(string));
                break;
            }
            case 3: {
                stringBuffer.append("@jowner=" + JobSO.argString(string));
                break;
            }
            default: {
                return;
            }
        }
    }

    public JobTemplateSO getTemplateSO() {
        if (this._jstSO == null) {
            this._jstSO = new JobTemplateSO(this.getConnection());
        }
        return this._jstSO;
    }

    public boolean getRunAsOwner() {
        return this.getColumn(12).equals("true");
    }

    public boolean getConcurrency() {
        return this.getColumn(10).equals("true");
    }

    public boolean getSharing() {
        return this.getColumn(11).equals("true");
    }

    public boolean getAllowRedirect() {
        return this.ColumnToBoolean(14);
    }

    public Date getDate(int n) {
        Date date;
        try {
            date = JSBaseSO.aseDateTimeFormat.parse(this.getColumn(4));
        }
        catch (ParseException parseException) {
            date = null;
        }
        return date;
    }

    public String getOwner() {
        return this.getColumn(3);
    }

    public String getDescription() {
        return this.getColumn(2);
    }

    public String getTimeout() {
        return this.getColumn(7);
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getOwner() + "." + this.getName();
    }

    public String getJobSQLText() {
        return this.getColumn(9);
    }

    public void setTemplateSO(JobTemplateSO jobTemplateSO) {
        this._jstSO = jobTemplateSO;
    }

    public void setRunAsOwner(boolean bl) {
        this.setColumn(12, bl ? "true" : "false");
    }

    public void setConcurrency(boolean bl) {
        this.setColumn(10, bl ? "true" : "false");
    }

    public void setSharing(boolean bl) {
        this.setColumn(11, bl ? "true" : "false");
    }

    public void setAllowRedirect(boolean bl) {
        this.setColumn(14, Boolean.toString(bl));
    }

    public void setOwner(String string) {
        this.setColumn(3, string);
    }

    public void setDescription(String string) {
        this.setColumn(2, string);
    }

    public void setTimeout(String string) {
        this.setColumn(7, string);
    }

    public void setJobSQLText(String string) {
        this.setColumn(9, string);
    }

    public void displayReceivedColumns() {
        System.out.println("------------------------------");
        System.out.println("BEGIN DISPLAY COLUMNS");
        System.out.println("JDEF_NAME = " + this.getName());
        System.out.println("JDEF_ID = " + this.getColumn(0));
        System.out.println("JDEF_TYPE = " + this.getColumn(5));
        System.out.println("JDEF_PROPERTIES = " + this.getColumn(6));
        System.out.println("JDEF_OWNER = " + this.getColumn(3));
        System.out.println("JDEF_CREATED = " + this.getColumn(4));
        System.out.println("JDEF_TIMEOUT_VALUE = " + this.getColumn(7));
        System.out.println("JDEF_TMPL_ID = " + this.getColumn(8));
        System.out.println("JDEF_DESCRIPTION = " + this.getColumn(2));
        System.out.println(" END DISPLAY COLUMNS");
        System.out.println("------------------------------");
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getColumn(0), this.getColumn(3), this.getColumn(4), this.getColumn(2)};
    }
}

