/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;

public class JobSchedulerAdminSO
extends ASEBaseItemSO {
    public JobSchedulerAdminSO(ASConnection aSConnection) {
        super(aSConnection);
    }

    @Override
    public Object[] getAttributes() {
        return null;
    }

    public boolean isEnableAtBoot() throws SQLException {
        int n = this.readConfig("enable job scheduler");
        return n > 0;
    }

    public int getInterval() throws SQLException {
        return this.readConfig("job scheduler interval");
    }

    public int getThreads() throws SQLException {
        return this.readConfig("job scheduler tasks");
    }

    public int getMaxOutputSize() throws SQLException {
        return this.readConfig("maximum job output");
    }

    public int getHistorySize() throws SQLException {
        return this.readConfig("percent database for history");
    }

    public int getOutputSize() throws SQLException {
        return this.readConfig("percent database for output");
    }

    public int getHistoryFree() throws SQLException {
        return this.readConfig("percent history free");
    }

    public int getOutputFree() throws SQLException {
        return this.readConfig("percent output free");
    }

    public void setEnableAtBoot(boolean bl) throws SQLException {
        String string = bl ? "1" : "0";
        this.writeConfig("enable job scheduler", string);
    }

    public void setInterval(int n) throws SQLException {
        this.writeConfig("job scheduler interval", String.valueOf(n));
    }

    public void setThreads(int n) throws SQLException {
        this.writeConfig("job scheduler tasks", String.valueOf(n));
    }

    public void setMaxOutputSize(int n) throws SQLException {
        this.writeConfig("maximum job output", String.valueOf(n));
    }

    public void setHistorySize(int n) throws SQLException {
        this.writeConfig("percent database for history", String.valueOf(n));
    }

    public void setOutputSize(int n) throws SQLException {
        this.writeConfig("percent database for output", String.valueOf(n));
    }

    public void setHistoryFree(int n) throws SQLException {
        this.writeConfig("percent history free", String.valueOf(n));
    }

    public void setOutputFree(int n) throws SQLException {
        this.writeConfig("percent output free", String.valueOf(n));
    }

    public boolean isTaskRunning() throws SQLException {
        this.getRSet().open("exec sybmgmtdb..sp_controljob @option='wakeup_js'");
        if (!this.getRSet().getNextRow()) {
            this.getRSet().close();
            throw new SQLException(ASEUtils.getString("ERR_NO_TASK_STATE"));
        }
        int n = this.getRSet().getColumnInt(1);
        this.getRSet().close();
        return n != 0;
    }

    public void startTask() throws SQLException {
        this._conn.executeCommand("exec sybmgmtdb..sp_controljob @option='start_js'");
    }

    public void stopTask() throws SQLException {
        this._conn.executeCommand("exec sybmgmtdb..sp_controljob @option='stop_js_wait'");
    }

    public void terminateTask(int n) throws SQLException {
        String string = n == 0 ? "exec sybmgmtdb..sp_controljob @option='stop_js'" : SQLs.getString("exec sybmgmtdb..sp_controljob @option=''stop_js_timeout={0}''", n);
        this._conn.executeCommand(string);
    }

    private int readConfig(String string) throws SQLException {
        this.getRSet().open(SQLs.getString("select r.value from master..syscurconfigs r, master..sysconfigures c where r.config = c.config and c.name = ''{0}''", string));
        if (!this.getRSet().getNextRow()) {
            this.getRSet().close();
            throw new SQLException(ASEUtils.getString("ERR_JS_ADMIN_CFG_ERROR") + string);
        }
        int n = this.getRSet().getColumnInt(1);
        this.getRSet().close();
        return n;
    }

    private void writeConfig(String string, String string2) throws SQLException {
        String string3 = SQLs.getString("exec sp_configure ''{0}'', {1}", string, string2);
        this._conn.executeCommand(string3);
    }
}

