/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.JSTConstants;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ASEBaseCtrSO;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.XMLUtility;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class JobTemplateSO
extends JSBaseSO
implements JSTConstants {
    private static final String JTMPL_ID_DEFAULT = "";
    private static final String JTMPL_NAME_DEFAULT = "";
    private static final String JTMPL_VERSION_DEFAULT = "";
    private static final String JTMPL_DESCRIPTION_DEFAULT = "";
    private static final String JTMPL_OWNER_DEFAULT = "";
    private static final String JTMPL_CREATED_DEFAULT = "";
    private static final String JTMPL_GROUP_PATH_DEFAULT = "";
    private static final String JTMPL_XML_DEFAULT = "";
    private String[] _attributes;
    private XMLUtility _xmlParser;
    private StringBuffer _tmplJobText;
    private Vector _userResponses;

    public JobTemplateSO(ASConnection aSConnection) {
        super(aSConnection, "JSTemplate");
        this.init(null);
    }

    public JobTemplateSO(ASConnection aSConnection, String string) {
        this(aSConnection);
        this.setColumn(0, string);
    }

    public JobTemplateSO(ASConnection aSConnection, String[] stringArray) {
        super(aSConnection, "JS Template");
        this.init(stringArray);
        super.setName(this.getColumn(1) + " ( " + this.getColumn(0) + " ) ");
    }

    public JobTemplateSO(ASConnection aSConnection, ASEBaseCtrSO aSEBaseCtrSO, String[] stringArray) {
        super(aSConnection, aSEBaseCtrSO);
        this.init(stringArray);
        super.setName(this.getColumn(1) + " ( " + this.getColumn(0) + " ) ");
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_JS_TEMPLATE_TEXT");
    }

    private String[] getDefaultColumns() {
        return new String[]{"", "", "", "", "", "", "", ""};
    }

    public void init(String[] stringArray) {
        this.setType("JS_TEMPLATE");
        if (stringArray == null) {
            this.setColumns(this.getDefaultColumns());
        } else {
            this.initColumns(stringArray);
        }
        this._userResponses = new Vector();
        this._tmplJobText = new StringBuffer();
    }

    public void setUserResponse(int n, String string) {
        this._userResponses.add(n, string);
    }

    public String getUserResponse(int n) {
        return (String)this._userResponses.get(n);
    }

    private void initColumns(String[] stringArray) {
        this.setColumns(this.getDefaultColumns());
        for (int i = 0; i < stringArray.length && i < 8; ++i) {
            this.setColumn(i, stringArray[i]);
        }
    }

    @Override
    public void convertListToProperties(String string) {
    }

    @Override
    public String convertPropertiesToPropList() {
        return "";
    }

    @Override
    public void copy(String string) throws SQLException {
    }

    @Override
    public void remove() throws SQLException {
    }

    @Override
    public void create() {
    }

    public void update() {
    }

    @Override
    public void addColumnValuetoSQL(StringBuffer stringBuffer, int n, String string) {
    }

    public Vector getParmPropArray() {
        this.traceThis("getParmPropArray");
        this.xmlLoad();
        Vector vector = this._xmlParser.buildParmPropArray();
        Collections.sort(vector, new propTempOrderComparator());
        this.traceThis("ParmPropArray Size = " + vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            this._xmlParser.displayPropValues((Properties)vector.get(i));
        }
        return vector;
    }

    public Properties getTemplateProperties() {
        this.traceThis("Entering getTemplateProperties");
        this.xmlLoad();
        this._xmlParser.displayPropValues(this._xmlParser.buildProperties());
        return this._xmlParser.buildProperties();
    }

    public Vector getTemplateTree() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_listjobtemplate @option=''jtlanguage={0}''", Locale.getDefault().getLanguage());
        Vector<String[]> vector = new Vector<String[]>();
        this.traceThis("SQL clause = " + string);
        this.getRSet().open(string);
        String[] stringArray = new String[10];
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
            this.traceThis("Template Tree: [" + stringArray[0] + "] " + "[" + stringArray[1] + "] " + "[" + stringArray[6].trim() + "] " + "");
            vector.add(stringArray);
        }
        return vector;
    }

    public String[] getSQLList(String string) throws SQLException {
        this.traceThis("getting SQL List: " + string);
        String[] stringArray = new String[]{""};
        this.traceThis("Creating Vector");
        Vector<String> vector = new Vector<String>();
        try {
            this.traceThis("Trying Open");
            this.getRSet().open(string);
            this.traceThis("getting the rows");
            while (this.getRSet().getNextRow()) {
                String[] stringArray2 = this.getRSet().getColumnsAsArray();
                vector.add(stringArray2[0]);
            }
        }
        catch (SQLException sQLException) {
            this.traceThis("SQLException: " + sQLException.toString());
            throw sQLException;
        }
        this.traceThis("Listbuffer size = " + vector.size());
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
            this.traceThis("ReturnValue [" + i + "] = " + stringArray[i]);
        }
        return stringArray;
    }

    public StringBuffer getRawXML(String string) {
        String string2 = SQLs.getString("exec sybmgmtdb..sp_readjobtemplate @jtid={0}", this.getTemplateID());
        Vector vector = new Vector();
        this.traceThis("SQL clause = " + string2);
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            this.getRSet().open(string2);
            String[] stringArray = new String[10];
            while (this.getRSet().getNextRow()) {
                stringArray = this.getRSet().getColumnsAsArray();
                stringBuffer.append(stringArray[0]);
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            this.traceThis("SQLException: " + sQLException);
        }
        this.traceThis("XML Retrieved: \n" + stringBuffer.toString());
        return stringBuffer;
    }

    private void xmlLoad() {
        if (this._xmlParser != null) {
            return;
        }
        this.traceThis("");
        this.traceThis("Try building an XML Document from the raw text");
        this.traceThis("----------------------------------------------------------");
        StringBuffer stringBuffer = this.getRawXML(this.getTemplateID());
        this.traceThis("Template ID: " + this.getTemplateID());
        this.traceThis("Raw XML: \n" + stringBuffer.toString());
        if (stringBuffer == null || stringBuffer.equals("")) {
            return;
        }
        this._xmlParser = new XMLUtility(stringBuffer);
        this.traceThis("Template ID: " + this.getTemplateID());
        this.traceThis("Raw XML: \n" + stringBuffer.toString());
        this.traceThis("Finished building an XML Document");
        this.traceThis("Try Getting the elements by name");
        List list = this._xmlParser.getAllElementsByName(ASEUtils.getString("parameter"));
        this.traceThis("Element list size = " + list.size());
    }

    public String toString() {
        return this.getTemplateName();
    }

    @Override
    public Object[] getAttributes() {
        this._attributes = new String[]{this._columns[0], this._columns[1], this._columns[6]};
        return this._attributes;
    }

    public String getTemplateID() {
        return this.getColumn(0);
    }

    public String getTemplateName() {
        return this.getColumn(1).trim();
    }

    public String getTemplateGroup() {
        return this.getColumn(6).trim();
    }

    public String getTemplateXML() {
        this.xmlLoad();
        return this.getColumn(7);
    }

    public String getJobCmd() {
        return this._tmplJobText.toString();
    }

    public void setJobCmd(String string) {
        this._tmplJobText = new StringBuffer(string);
    }

    public class propTempOrderComparator
    implements Comparator {
        Properties p1;
        Properties p2;

        public int compare(Object object, Object object2) {
            this.p1 = (Properties)object;
            this.p2 = (Properties)object2;
            int n = Integer.parseInt(this.p1.getProperty("template.parameter.order"));
            int n2 = Integer.parseInt(this.p2.getProperty("template.parameter.order"));
            int n3 = 0;
            if (n < n2) {
                n3 = -1;
            }
            if (n == n2) {
                n3 = 0;
            }
            if (n > n2) {
                n3 = 1;
            }
            return n3;
        }
    }
}

