/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.WrkldMgmtUtilities;
import java.sql.SQLException;
import java.util.Vector;

public class LoadProfileSO
extends ASEBaseItemSO {
    private String[] columns;
    private static int ndx = 0;
    public static final int LP_LP_ID_NDX = ndx++;
    public static final int LP_LP_NAME_NDX = ndx++;
    public static final int LP_LP_DESC_NDX = ndx++;
    public static final int LP_LP_TYPE_NDX = ndx++;
    public static final int LP_START_METRICS_NDX = ndx;
    public static final int LP_CONN_WT_NDX = ndx++;
    public static final int LP_CPU_WT_NDX = ndx++;
    public static final int LP_RUNQ_WT_NDX = ndx++;
    public static final int LP_IO_LOAD_WT_NDX = ndx++;
    public static final int LP_ENG_DEF_WT_NDX = ndx++;
    public static final int LP_USER_WT_NDX = ndx++;
    public static final int LP_MIN_LS_NDX = ndx++;
    public static final int LP_LOGIN_REDIR_NDX = ndx++;
    public static final int LP_DYN_MIGRATION_NDX = ndx++;
    public static final int MAX_LP_COLUMNS = ndx;
    public static final int MAX_METRICS_COLUMNS = LP_USER_WT_NDX - LP_START_METRICS_NDX + 1;
    public static final String LP_SYSTEM_TYPE = "system";
    public static final String LP_USER_TYPE = "user";
    public static final String LP_SYSTEM_NAME_PREFIX = "sybase_profile";
    public static final int LP_EXISTS_ERROR = 19789;
    private boolean lpEditable = false;
    public static final String WLMGR_USR_CONN = "user connections";
    public static final String WLMGR_CPU_BUSY = "cpu busy";
    public static final String WLMGR_RUNQ = "run queue";
    public static final String WLMGR_IOLOAD = "io load";
    public static final String WLMGR_ENG_DEF = "engine deficit";
    public static final String WLMGR_USR_METRIC = "user metric";
    public static final String WLMGR_HYSTER = "hysteresis";
    public static final String WLMGR_LOGIN = "login";
    public static final String WLMGR_REDIR = "dynamic";

    public LoadProfileSO(ASConnection aSConnection) {
        this(aSConnection, "");
    }

    public LoadProfileSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
        this.init(null);
        this.setLPName(string);
    }

    public LoadProfileSO(ASConnection aSConnection, String[] stringArray) {
        super(aSConnection, "");
        this.init(stringArray);
        this.setName(this.getLPName());
    }

    private String[] getDefaultValues() {
        return new String[]{"0", "", "description placeholder", LP_USER_TYPE, "0", "0", "0", "0", "0", "0", "0", "0", "0"};
    }

    public void init(String[] stringArray) {
        this.setType("WRKLD_PROFILE");
        this.columns = new String[MAX_LP_COLUMNS];
        if (stringArray == null) {
            this.initColumns(this.getDefaultValues());
        } else {
            this.initColumns(stringArray);
            super.setName(this.getColumn(LP_LP_NAME_NDX));
        }
        this.lpEditable = !this.getLPType().equals(LP_SYSTEM_TYPE);
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_SDC_LOAD_PROFILE");
    }

    private void initColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length && i < MAX_LP_COLUMNS; ++i) {
            this.setColumn(i, stringArray[i]);
        }
    }

    private void setColumn(int n, String string) {
        this.columns[n] = string;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public int[] getMetrics() {
        int[] nArray = new int[MAX_METRICS_COLUMNS];
        int n = 0;
        int n2 = LP_START_METRICS_NDX;
        while (n < MAX_METRICS_COLUMNS) {
            nArray[n] = Integer.parseInt(this.getColumn(n2));
            ++n;
            ++n2;
        }
        return nArray;
    }

    public String getColumn(int n) {
        String string = "";
        if (n >= 0 && n < MAX_LP_COLUMNS) {
            string = this.columns[n];
        }
        return string;
    }

    @Override
    public void create() throws SQLException {
        block2: {
            String string = SQLs.getString("exec sp_cluster ''profile'', ''create'', ''{0}''", this.getLPName());
            try {
                this._conn.executeCommand(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 19789) break block2;
                throw new SQLException(ASEUtils.getString("LOAD_PROFILE_WIZ_CREATE_DUPLICATE_ERROR"));
            }
        }
        this.update();
    }

    @Override
    public boolean enableDelete() {
        return this.getLPType().equals(LP_USER_TYPE);
    }

    public void duplicate(String string) throws SQLException {
        block2: {
            String string2 = SQLs.getString("exec sp_cluster ''profile'', ''create'', ''{0}''", string);
            try {
                this._conn.executeCommand(string2);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 19789) break block2;
                throw new SQLException(ASEUtils.getString("LOAD_PROFILE_WIZ_CREATE_DUPLICATE_ERROR"));
            }
        }
        this.updateLPMetrics(string);
        this.updateLPThresholds(string);
    }

    @Override
    public void remove() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''profile'', ''drop'', ''{0}''", this.getLPName());
        this._conn.executeCommand(string);
    }

    public void update() throws SQLException {
        String string = this.getLPName();
        this.updateLPMetrics(string);
        this.updateLPThresholds(string);
    }

    public void updateLPMetrics(String string) throws SQLException {
        if (string == null || string.trim().length() == 0) {
            string = this.getLPName();
        }
        String string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''weight'', ''{1}'', ''{2}''", string, WLMGR_USR_CONN, this.getColumn(LP_CONN_WT_NDX));
        this._conn.executeCommand(string2);
        string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''weight'', ''{1}'', ''{2}''", string, WLMGR_CPU_BUSY, this.getColumn(LP_CPU_WT_NDX));
        this._conn.executeCommand(string2);
        string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''weight'', ''{1}'', ''{2}''", string, WLMGR_RUNQ, this.getColumn(LP_RUNQ_WT_NDX));
        this._conn.executeCommand(string2);
        string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''weight'', ''{1}'', ''{2}''", string, WLMGR_IOLOAD, this.getColumn(LP_IO_LOAD_WT_NDX));
        this._conn.executeCommand(string2);
        string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''weight'', ''{1}'', ''{2}''", string, WLMGR_ENG_DEF, this.getColumn(LP_ENG_DEF_WT_NDX));
        this._conn.executeCommand(string2);
        string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''weight'', ''{1}'', ''{2}''", string, WLMGR_USR_METRIC, this.getColumn(LP_USER_WT_NDX));
        this._conn.executeCommand(string2);
    }

    public void updateLPThresholds(String string) throws SQLException {
        if (string == null || string.trim().length() == 0) {
            string = this.getLPName();
        }
        String string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''threshold'', ''{1}'', ''{2}''", string, WLMGR_HYSTER, this.getMinLoadScore() + "");
        this._conn.executeCommand(string2);
        string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''threshold'', ''{1}'', ''{2}''", string, WLMGR_LOGIN, this.getLoginRedirection() + "");
        this._conn.executeCommand(string2);
        string2 = SQLs.getString("exec sp_cluster ''profile'', ''set'', ''{0}'', ''threshold'', ''{1}'', ''{2}''", string, WLMGR_REDIR, this.getDynamicMigration() + "");
        this._conn.executeCommand(string2);
    }

    public void setLPName(String string) {
        if (string == null) {
            string = "";
        }
        this.setColumn(LP_LP_NAME_NDX, string.trim());
    }

    public void setMetricWeight(String string, int n) {
        this.setColumn(this.getMetricNdx(string), n + "");
    }

    public void setMetricWeight(int n, int n2) {
        this.setColumn(n, n2 + "");
    }

    public void setMinLoadScore(int n) {
        this.setColumn(LP_MIN_LS_NDX, n + "");
    }

    public void setLoginRedirection(int n) {
        this.setColumn(LP_LOGIN_REDIR_NDX, n + "");
    }

    public void setDynamicMigration(int n) {
        this.setColumn(LP_DYN_MIGRATION_NDX, n + "");
    }

    public String getLPName() {
        return this.getColumn(LP_LP_NAME_NDX);
    }

    public String getLPType() {
        return this.getColumn(LP_LP_TYPE_NDX);
    }

    public int getMinLoadScore() {
        return Integer.parseInt(this.getColumn(LP_MIN_LS_NDX));
    }

    public int getLoginRedirection() {
        return Integer.parseInt(this.getColumn(LP_LOGIN_REDIR_NDX));
    }

    public int getDynamicMigration() {
        return Integer.parseInt(this.getColumn(LP_DYN_MIGRATION_NDX));
    }

    public Vector getMetricWeights() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(this.getColumn(LP_CONN_WT_NDX)));
        vector.add(new Integer(this.getColumn(LP_CPU_WT_NDX)));
        vector.add(new Integer(this.getColumn(LP_RUNQ_WT_NDX)));
        vector.add(new Integer(this.getColumn(LP_IO_LOAD_WT_NDX)));
        vector.add(new Integer(this.getColumn(LP_ENG_DEF_WT_NDX)));
        vector.add(new Integer(this.getColumn(LP_USER_WT_NDX)));
        return vector;
    }

    public Vector getMetricNameValuePairs() {
        Vector vector = new Vector();
        for (int i = 0; i < WrkldMgmtUtilities.WRKLD_METRICS_LABELS_ARRAY.length; ++i) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(WrkldMgmtUtilities.WRKLD_METRICS_LABELS_ARRAY[i]);
            vector2.add(this.getColumn(this.getMetricNdx(WrkldMgmtUtilities.WRKLD_METRICS_LABELS_ARRAY[i])));
            vector.add(vector2);
        }
        return vector;
    }

    public int getMetricNdx(String string) {
        int n = -1;
        if (string != null) {
            string = string.trim();
            string.replaceAll("% ", "");
            if (string.equals(WrkldMgmtUtilities.WRKLD_USER_CONNECTIONS)) {
                n = LP_CONN_WT_NDX;
            } else if (string.equals(WrkldMgmtUtilities.WRKLD_CPU_BUSY)) {
                n = LP_CPU_WT_NDX;
            } else if (string.equals(WrkldMgmtUtilities.WRKLD_RUNQ_LEN)) {
                n = LP_RUNQ_WT_NDX;
            } else if (string.equals(WrkldMgmtUtilities.WRKLD_IO_LOAD)) {
                n = LP_IO_LOAD_WT_NDX;
            } else if (string.equals(WrkldMgmtUtilities.WRKLD_ENG_DEFICIT)) {
                n = LP_ENG_DEF_WT_NDX;
            } else if (string.equals(WrkldMgmtUtilities.WRKLD_USER_METRIC)) {
                n = LP_USER_WT_NDX;
            }
        }
        return n;
    }

    public boolean metricsValid(int n) {
        return n > 0;
    }

    @Override
    public boolean hasValidName() throws SQLException {
        boolean bl = false;
        String string = this.getName();
        if (string == null || string.trim().length() == 0) {
            throw new SQLException(ASEUtils.getString("LOAD_PROFILE_ERROR_MISSING_NAME"));
        }
        bl = Utility.hasValidName(this._conn, string, true);
        if (bl) {
            if (string.trim().startsWith(LP_SYSTEM_NAME_PREFIX)) {
                throw new SQLException(ASEUtils.getString("LOAD_PROFILE_ERROR_RSRVD_NAME"));
            }
        } else {
            throw new SQLException(ASEUtils.getString("LOAD_PROFILE_ERROR_INVALID_NAME"));
        }
        return bl;
    }

    public boolean isLPEditable() throws SQLException {
        return this.lpEditable;
    }

    @Override
    public Object[] getAttributes() {
        Object[] objectArray = new String[]{this.getColumn(LP_LP_NAME_NDX), this.getColumn(LP_LP_TYPE_NDX), this.getColumn(LP_CONN_WT_NDX), this.getColumn(LP_CPU_WT_NDX), this.getColumn(LP_RUNQ_WT_NDX), this.getColumn(LP_IO_LOAD_WT_NDX), this.getColumn(LP_ENG_DEF_WT_NDX), this.getColumn(LP_USER_WT_NDX), this.getColumn(LP_MIN_LS_NDX), this.getColumn(LP_LOGIN_REDIR_NDX), this.getColumn(LP_DYN_MIGRATION_NDX)};
        return objectArray;
    }
}

