/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.RegExpression;
import com.sybase.aseplugin.so.ServerSO;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogSO
extends ASEBaseItemSO
implements DateSorter {
    private ServerSO _serverSO;
    private String _sdcInstanceId;
    private String _line;
    private String _engId;
    private String _familyId;
    private String _processId;
    private Date _date;
    private String _source;
    private String _message;
    private boolean _matchExpression = false;
    private String _description;

    public LogSO(ServerSO serverSO, String string) {
        super(null);
        this._serverSO = serverSO;
        if (this.isCluster()) {
            this._initSDC(string);
        } else {
            this._init(string);
        }
        this.setDate();
    }

    public LogSO(ServerSO serverSO, String string, String string2, String string3, Date date, String string4, String string5) {
        this._serverSO = serverSO;
        this._engId = string;
        this._familyId = string2;
        this._processId = string3;
        this._date = date;
        this._source = string4;
        this._message = string5;
        this.initExpressions();
        this.setDate();
    }

    public LogSO(ServerSO serverSO, String string, String string2, String string3, String string4, Date date, String string5, String string6) {
        this._serverSO = serverSO;
        this._sdcInstanceId = string;
        this._engId = string2;
        this._familyId = string3;
        this._processId = string4;
        this._date = date;
        this._source = string5;
        this._message = string6;
        this.initExpressions();
        this.setDate();
    }

    private void _init(String string) {
        if (this.getServer().getVersion().compareTo("15.5") >= 0) {
            string = string.substring(3, string.length());
        }
        this._line = string;
        if (string.length() < 45 || string.charAt(2) != ':' || string.charAt(8) != ':') {
            this._engId = "";
            this._familyId = "";
            this._processId = "";
            this._date = null;
            this._source = "";
            this._message = string;
            this._matchExpression = true;
        } else {
            Object object;
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 8);
            String string4 = string.substring(9, 14);
            String string5 = string.substring(15, 37);
            Date date = new Date();
            try {
                object = new SimpleDateFormat("yyyy/MM/dd H:mm:ss.SS");
                date = ((DateFormat)object).parse(string5);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            object = string.substring(38, 45).trim();
            String string6 = string.substring(46);
            this._engId = string2;
            this._familyId = string3;
            this._processId = string4;
            this._date = date;
            this._source = object;
            this._message = string6;
            this.initExpressions();
        }
    }

    private void _initSDC(String string) {
        this._line = string;
        if (string.length() < 48 || string.charAt(5) != ':' || string.charAt(11) != ':') {
            this._sdcInstanceId = "";
            this._engId = "";
            this._familyId = "";
            this._processId = "";
            this._date = null;
            this._source = "";
            this._message = string;
            this._matchExpression = true;
        } else {
            Object object;
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            String string4 = string.substring(6, 11);
            String string5 = string.substring(12, 17);
            String string6 = string.substring(18, 40);
            Date date = new Date();
            try {
                object = new SimpleDateFormat("yyyy/MM/dd H:mm:ss.SS");
                date = ((DateFormat)object).parse(string6);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            object = string.substring(41, 48).trim();
            String string7 = string.substring(49);
            this._sdcInstanceId = string2;
            this._engId = string3;
            this._familyId = string4;
            this._processId = string5;
            this._date = date;
            this._source = object;
            this._message = string7;
            this.initExpressions();
        }
    }

    public boolean isCluster() {
        return this._serverSO.isCluster();
    }

    public ServerSO getServer() {
        return this._serverSO;
    }

    public String getLine() {
        return this._line;
    }

    @Override
    public Object[] getAttributes() {
        if (this.isCluster()) {
            return new Object[]{this.getDate(), this.getSource(), this.getMessage(), this.getSDCInstanceId(), this.getEngineId(), this.getFamilyId(), this.getProcessId(), this.getDescription()};
        }
        return new Object[]{this.getDate(), this.getSource(), this.getMessage(), this.getEngineId(), this.getFamilyId(), this.getProcessId(), this.getDescription()};
    }

    public String getSDCInstanceId() {
        return this._sdcInstanceId;
    }

    public String getEngineId() {
        return this._engId;
    }

    public String getFamilyId() {
        return this._familyId;
    }

    public String getProcessId() {
        return this._processId;
    }

    public Date getDate() {
        return this._date;
    }

    @Override
    public final Date getDate(int n) {
        return this.getDate();
    }

    private void setDate() {
        if (this._date != null) {
            this.setName(this._date.toString());
        }
    }

    public String getSource() {
        return this._source;
    }

    public String getMessage() {
        return this._message;
    }

    private void initExpressions() {
        ArrayList arrayList = this._serverSO.getServerLogsExps();
        boolean bl = false;
        this._description = "";
        String string = "";
        for (RegExpression regExpression : arrayList) {
            Pattern pattern;
            Matcher matcher;
            if (!regExpression.enabled || !(bl = (matcher = (pattern = regExpression.ignoreCase ? Pattern.compile(regExpression.expression, 2) : Pattern.compile(regExpression.expression)).matcher(this._message)).find())) continue;
            this._matchExpression = true;
            this._description = this._description + string + regExpression.description;
            string = ", ";
        }
    }

    public String getDescription() {
        return this._description;
    }

    public boolean hasMatches() {
        return this._matchExpression;
    }
}

