/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.asa.ASAIconTextData;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.dlg.LoginRelatedUsersDeleteDialog;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.LoginsCtrSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;

public class LoginSO
extends ASEBaseItemSO {
    public static final String SA = "sa";
    public static final String PROBE = "probe";
    private int SY_LOGIN_ACCOUNT = 2;
    private int SY_LOGIN_PASSWORD_EXPIRED = 4;
    private int SY_LOGIN_PASSWORD_NULL = 1;
    private int SY_LOGIN_AUTH_ANY = 224;
    private int SY_LOGIN_AUTH_ASE = 32;
    private int SY_LOGIN_AUTH_LDAP = 64;
    private int SY_LOGIN_AUTH_PAM = 128;
    public static final int ID = 0;
    public static final int DBNAME = 1;
    public static final int FULLNAME = 2;
    public static final int NAME = 3;
    public static final int STATUS = 4;
    public static final int LANGUAGE = 5;
    public static final int CPUTIME = 6;
    public static final int IOTIME = 7;
    public static final int LASTSET = 8;
    public static final int PASSWOARDLASTSET = 9;
    public static final int LASTLOGINDATE = 10;
    public static final String ANY = "ANY";
    public static final String ASE = "ASE";
    public static final String LDAP = "LDAP";
    public static final String PAM = "PAM";
    private String _defaultDatabase;
    private String _authMechanism;
    private String _fullName;
    private String _status;
    private String _password;
    private String _defaultLanguage;
    private boolean _locked;
    private String _cputime;
    private String _iotime;
    private String _lastset;
    private String _id;
    private String _pwLastSet;
    private String _lastLoginDate;
    private String[] _userDBNames;
    private String[] _userNames;
    private String[] _userGroups;
    private String _tmpUserName = "";
    Hashtable _roles = new Hashtable();
    Hashtable _oldRoles = new Hashtable();
    Hashtable _localConnections = new Hashtable();

    public LoginSO(ASConnection aSConnection) {
        super(aSConnection);
        this.setType("L");
    }

    public LoginSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
        this.setType("L");
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getDefaultDatabase(), this.getFullName(), this.getLockStatusStr(), this.getLastLoginDate()};
    }

    public void load(String[] stringArray) {
        boolean bl;
        this._defaultDatabase = stringArray[1];
        this._fullName = stringArray[2];
        this._status = stringArray[4];
        this._defaultLanguage = stringArray[5];
        this._cputime = stringArray[6];
        this._iotime = stringArray[7];
        this._lastset = stringArray[8];
        this._id = stringArray[0];
        this._pwLastSet = stringArray[9];
        boolean bl2 = bl = this.getConnection().getVersion().compareTo("15.0.2") >= 0;
        if (bl) {
            this._lastLoginDate = stringArray[10];
        }
        this.initLockStatus();
        this.setAuthMechanism();
    }

    @Override
    public void create() throws SQLException {
        Object[] objectArray = new String[]{this.getName(), this.getPassword().length() == 0 ? null : "'" + this.getPassword() + "'", this.getDefaultDatabase(), this.getDefaultLanguage(), this.getAuthMechanism()};
        String string = SQLs.getString("exec sp_addlogin ''{0}'', {1}, @defdb = ''{2}'', @deflanguage = ''{3}'', @auth_mech = ''{4}''", objectArray);
        if (this.getFullName() != null && this.getFullName().length() > 0) {
            string = string + ", @fullname='" + this.getFullName() + "'";
        }
        this._conn.executeCommand(string);
        if (this._userDBNames != null && this._userDBNames.length > 0) {
            this.createUsers();
        }
    }

    @Override
    public LoginSO findObject() throws SQLException {
        LoginsCtrSO loginsCtrSO = new LoginsCtrSO(this.getConnection());
        Object[] objectArray = new Object[]{this.getName()};
        List list = loginsCtrSO.open(1, objectArray);
        return list.isEmpty() ? null : (LoginSO)list.get(0);
    }

    @Override
    public void remove() throws SQLException {
        block11: {
            if (Support.getEnableSQLPreview()) {
                Object object;
                int n;
                Vector<Vector> vector = new Vector<Vector>();
                String[] stringArray = this.getAliasDatabases();
                for (n = 0; n < stringArray.length; ++n) {
                    object = this.getDatabaseConnection(stringArray[n]);
                    String string = this.isDirect((ASConnection)object, stringArray[n]);
                    String string2 = this.isAlias((ASConnection)object, stringArray[n]);
                    if (string.length() > 0) {
                        vector.addElement(this.iconTextByName(string, stringArray[n], ASEUtils.getString("MSG_DIRECT")));
                        continue;
                    }
                    if (string2.length() <= 0) continue;
                    vector.addElement(this.iconTextByName(string2, stringArray[n], ASEUtils.getString("MSG_ALIAS")));
                }
                for (n = 0; n < vector.size(); ++n) {
                    object = (Vector)vector.elementAt(n);
                    if (((ASAIconTextData)((Vector)object).elementAt(2)).toString().equals(ASEUtils.getString("MSG_DIRECT"))) {
                        this.dropDirect(((ASAIconTextData)((Vector)object).elementAt(0)).toString(), ((ASAIconTextData)((Vector)object).elementAt(1)).toString());
                        continue;
                    }
                    this.dropAlias(((ASAIconTextData)((Vector)object).elementAt(1)).toString());
                }
                String string = SQLs.getString("exec sp_droplogin {0}", this.getName());
                this._conn.executeCommand(string);
            } else {
                try {
                    String string = SQLs.getString("exec sp_droplogin {0}", this.getName());
                    this._conn.executeCommand(string);
                }
                catch (SQLException sQLException) {
                    Vector<Vector> vector = new Vector<Vector>();
                    String[] stringArray = this.getAliasDatabases();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ASConnection aSConnection = this.getDatabaseConnection(stringArray[i]);
                        String string = this.isDirect(aSConnection, stringArray[i]);
                        String string3 = this.isAlias(aSConnection, stringArray[i]);
                        if (string.length() > 0) {
                            vector.addElement(this.iconTextByName(string, stringArray[i], ASEUtils.getString("MSG_DIRECT")));
                            continue;
                        }
                        if (string3.length() <= 0) continue;
                        vector.addElement(this.iconTextByName(string3, stringArray[i], ASEUtils.getString("MSG_ALIAS")));
                    }
                    if (vector.size() == 0) {
                        throw sQLException;
                    }
                    if (!LoginRelatedUsersDeleteDialog.showDialog(Support.getViewerFrame(), this, sQLException.getMessage(), vector)) break block11;
                    return;
                }
            }
        }
    }

    public void setFullName(String string) {
        this._fullName = string;
    }

    public String getFullName() {
        return this._fullName;
    }

    public void setPassword(String string) {
        this._password = string == null ? null : ASEUtils.encryptPassword(string);
    }

    public String getPassword() {
        return this._password == null ? null : ASEUtils.decryptPassword(this._password);
    }

    public void deleteClientLoginMapping(String string, String string2) throws SQLException {
        String string3 = SQLs.getString("exec sp_maplogin ''{0}'',  ''{1}'' , ''{2}'' ", string2, string, "drop");
        this._conn.executeCommand(string3);
    }

    public void addClientLoginMapping(String string, String string2) throws SQLException {
        String string3 = SQLs.getString("exec sp_maplogin ''{0}'',  ''{1}'' , ''{2}'' ", string2, string, this.getName());
        this._conn.executeCommand(string3);
    }

    public void alterAuthMechanism(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_modifylogin ''{0}'' ,  ''authentication with'' ,  ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
        this.setAuthMechanism(string);
    }

    public void setAuthMechanism(String string) {
        this._authMechanism = string;
    }

    public void setAuthMechanism() {
        try {
            int n = Integer.parseInt(this._status);
            this._authMechanism = (n & this.SY_LOGIN_AUTH_ANY) == this.SY_LOGIN_AUTH_ANY ? ANY : ((n & this.SY_LOGIN_AUTH_ASE) == this.SY_LOGIN_AUTH_ASE ? ASE : ((n & this.SY_LOGIN_AUTH_LDAP) == this.SY_LOGIN_AUTH_LDAP ? LDAP : ((n & this.SY_LOGIN_AUTH_PAM) == this.SY_LOGIN_AUTH_PAM ? PAM : ANY)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getAuthMechanism() {
        return this._authMechanism == null ? ANY : this._authMechanism;
    }

    public void setDefaultDatabase(String string) {
        this._defaultDatabase = string;
    }

    public String getDefaultDatabase() {
        return this._defaultDatabase;
    }

    public void setDefaultLanguage(String string) {
        this._defaultLanguage = string;
    }

    public String getDefaultLanguage() {
        if (this._defaultLanguage == null || this._defaultLanguage.length() == 0) {
            return this._conn.getLanguage();
        }
        return this._defaultLanguage;
    }

    public void initLockStatus() {
        this._locked = (Integer.parseInt(this._status) & this.SY_LOGIN_ACCOUNT) != 0;
    }

    public String getLockStatusStr() {
        if (this._locked) {
            return ASEUtils.getString("MSG_LOCKED");
        }
        return ASEUtils.getString("MSG_UNLOCKED");
    }

    public String getLockStatusYesNo() {
        if (this.getLockStatus()) {
            return ASEUtils.getString("MSG_YES");
        }
        return ASEUtils.getString("MSG_NO");
    }

    public boolean getLockStatus() {
        return this._locked;
    }

    public void setLockStatus(boolean bl) {
        this._locked = bl;
    }

    public String getPasswordNull() {
        if ((Integer.parseInt(this._status) & this.SY_LOGIN_PASSWORD_NULL) != 0) {
            return ASEUtils.getString("MSG_YES");
        }
        return ASEUtils.getString("MSG_NO");
    }

    public String getServerTime() throws SQLException {
        String[] stringArray;
        Vector<String[]> vector = Utility.openQuery2("select convert(datetime, getdate())", this._conn);
        String string = null;
        if (vector != null && (stringArray = vector.elementAt(0)) != null) {
            string = stringArray[0];
        }
        return string;
    }

    public String getPasswordExpired() throws NumberFormatException, SQLException {
        if (this.getPasswordExpireDays() == 0) {
            if ((Integer.parseInt(this._status) & this.SY_LOGIN_PASSWORD_EXPIRED) != 0) {
                return ASEUtils.getString("MSG_YES");
            }
            return ASEUtils.getString("MSG_NO");
        }
        long l = Date.parse(this._pwLastSet);
        long l2 = Date.parse(this.getServerTime());
        if (l2 - l < (long)(this.getPasswordExpireDays() * 1000 * 60 * 60 * 24)) {
            return ASEUtils.getString("MSG_NO");
        }
        return ASEUtils.getString("MSG_YES");
    }

    public boolean isPasswordExpired() {
        return (Integer.parseInt(this._status) & this.SY_LOGIN_PASSWORD_EXPIRED) != 0;
    }

    public void expireLoginPasswords() throws SQLException {
        String string = SQLs.getString("exec sp_passwordpolicy ''expire login passwords'', ''{0}''", this.getName());
        this._conn.executeCommand(string);
    }

    public String getCPUTime() {
        return this._cputime;
    }

    public String getIOTime() {
        return this._iotime;
    }

    public String getLastSet() {
        return this._pwLastSet;
    }

    public String getLastLoginDate() {
        return this._lastLoginDate;
    }

    public List getAvailableDatabases() throws SQLException {
        if (this._conn.isCluster()) {
            SDCInstancesCtrSO sDCInstancesCtrSO = new SDCInstancesCtrSO(this._conn);
            return sDCInstancesCtrSO.getSDCNormalDBList(1);
        }
        DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
        return databasesCtrSO.getNormalDBList(1);
    }

    public String[] getAvailableLanguages() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open("select name from master.dbo.syslanguages order by 1");
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1).trim());
        }
        this.getRSet().close();
        String string = this._conn.getLanguage();
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Vector getAvailableAuthentications() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open("select name from master.dbo.spt_values where type='ua' order by 1");
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1).trim());
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getClientMappings() throws SQLException {
        Vector vector = new Vector();
        this.getRSet().open(SQLs.getString("select case object_cinfo when ''*'' then convert(char(20),''ANY'') else convert(char(20), object_cinfo) end as ''client name'', convert(char(14), isnull(s.name, ''ANY'')) as authentication from master.dbo.sysattributes, master.dbo.spt_values s where class = 20 and attribute = 0 and (object_info1 = s.low) and (s.type = ''ua'') and (suser_name(object) = ''{0}'' ) order by 1,2", this.getName()));
        while (this.getRSet().getNextRow()) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(this.getRSet().getColumnString(1).trim());
            vector2.addElement(this.getRSet().getColumnString(2).trim());
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public void modifyFullName(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_modifylogin {0}, fullname, ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void modifyLang(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_modifylogin {0}, deflanguage, ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void modifyDB(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_modifylogin {0}, defdb, ''{1}'' ", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public int getPasswordExpireDays() throws SQLException {
        String string = SQLs.getString("select int_value from master.dbo.sysattributes where object_type = ''PS'' and attribute = 0 and object = {0} and object_cinfo = ''login''", this._id);
        Vector<String[]> vector = Utility.openQuery2(string, this.getConnection());
        if (vector.size() == 0) {
            if (this.getConnection().hasSSORole() && this.getConnection().isPwdComplexityApplicable()) {
                this.getRSet().open("exec sp_passwordpolicy 'list', 'systemwide password expiration'");
                if (this.getRSet().getNextRow()) {
                    return this.getRSet().getColumnInt("Curr_value");
                }
            }
            this.getRSet().open("select value from master.dbo.sysconfigures where name = 'systemwide password expiration'");
            if (this.getRSet().getNextRow()) {
                return this.getRSet().getColumnInt(1);
            }
        }
        String[] stringArray = vector.elementAt(0);
        return Integer.valueOf(stringArray[0]);
    }

    public void changePassword(String string, String string2) throws SQLException {
        String string3 = ASEUtils.encryptPassword("null");
        string = string.length() == 0 ? ASEUtils.decryptPassword(string3) : "'" + string + "'";
        string2 = string2.length() == 0 ? ASEUtils.decryptPassword(string3) : "'" + string2 + "'";
        Object[] objectArray = new Object[]{string, string2, this.getName()};
        String string4 = SQLs.getString("exec sp_password {0}, {1}, {2}", objectArray);
        this._conn.executeCommand(string4);
    }

    public void modifyLockStatus(boolean bl) throws SQLException {
        if (bl) {
            String string = SQLs.getString("exec sp_locklogin {0}, ''lock''", this.getName());
            this._conn.executeCommand(string);
        } else {
            String string = SQLs.getString("exec sp_locklogin {0}, ''unlock''", this.getName());
            this._conn.executeCommand(string);
        }
        this.setLockStatus(bl);
    }

    public List getDatabasesOwned() throws SQLException {
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = new Object[]{this._id, Integer.toString((int)Utility.getMBToPageSize(this.getConnection()))};
        String string = SQLs.getString("select a.name, sum(c.size/{1}) from master.dbo.sysdatabases a,master.dbo.syslogins b, master.dbo.sysusages c where (a.suid = b.suid) and (b.suid = {0}) and a.dbid=c.dbid group by a.name", objectArray);
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(this.getRSet().getColumnString(1).trim());
            vector.addElement(this.getRSet().getColumnString(2).trim());
            arrayList.add(vector);
        }
        this.getRSet().close();
        return arrayList;
    }

    public void copyHashtable() {
        this._oldRoles = (Hashtable)this._roles.clone();
    }

    public String getOldRoleStatus(String string) {
        String string2 = (String)this._oldRoles.get(string);
        return string2;
    }

    public void setRoleStatus() throws SQLException {
        String[] stringArray;
        String string = SQLs.getString("select name from master.dbo.syssrvroles where name not in (select role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid and l.name = ''{0}'') order by 1", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
            this._roles.put(stringArray[0], ASEUtils.getString("MSG_YES"));
        }
        this.getRSet().close();
        Object[] objectArray = new Object[]{this.getName(), ASEUtils.getString("MSG_YES"), ASEUtils.getString("MSG_NO")};
        string = SQLs.getString("select role_name(lr.srid), ''{1}'' from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid and l.name = ''{0}'' and lr.status = 1 union select role_name(lr.srid), ''{2}'' from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid and l.name = ''{0}'' and lr.status = 0 order by 1", objectArray);
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
            this._roles.put(stringArray[0], stringArray[1]);
        }
        this.getRSet().close();
    }

    public String getRoleStatus(String string) {
        return (String)this._roles.get(string);
    }

    public void setDefaultRole(String string, String string2) throws SQLException {
        String string3 = SQLs.getString("exec sp_modifylogin ''{1}'', ''add default role'', ''{0}'' ", string, string2);
        this._conn.executeCommand(string3);
    }

    public void alterRoleStatus(String string, String string2) {
        this._roles.put(string, string2);
    }

    public void revokeRole(String string, String string2) throws SQLException {
        String string3 = SQLs.getString("revoke role {0} from {1}", string, string2);
        this._conn.executeCommand(string3);
    }

    public void grantRole(String string, String string2) throws SQLException {
        String string3 = SQLs.getString("grant role {0} to {1} ", string, string2);
        this._conn.executeCommand(string3);
    }

    public void alterRole(String string, String string2) throws SQLException {
        if (((String)this._roles.get(string)).compareTo(ASEUtils.getString("MSG_YES")) == 0) {
            String string3 = SQLs.getString("exec sp_modifylogin ''{1}'', ''add default role'', ''{0}'' ", string, string2);
            this._conn.executeCommand(string3);
        } else {
            String string4 = SQLs.getString("exec sp_modifylogin ''{1}'', ''drop default role'', ''{0}'' ", string, string2);
            this._conn.executeCommand(string4);
        }
    }

    public Vector getRoles() throws SQLException {
        Vector vector = new Vector();
        Object[] objectArray = new Object[]{this.getName(), ASEUtils.getString("MSG_YES"), ASEUtils.getString("MSG_NO")};
        String string = SQLs.getString("select role_name(lr.srid), ''{1}'' from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid and l.name = ''{0}'' and lr.status = 1 union select role_name(lr.srid), ''{2}'' from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid and l.name = ''{0}'' and lr.status = 0 order by 1", objectArray);
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1).trim(), RoleBO.ROLE_ICON, 0));
            vector2.addElement(this.getRSet().getColumnString(2).trim());
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getAddRolesItems() throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = SQLs.getString("select name from master.dbo.syssrvroles where name not in (select role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid and l.name = ''{0}'') order by 1", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1).trim());
        }
        this.getRSet().close();
        return vector;
    }

    public Vector rowByName(String string) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement(this.getRoleStatus(string));
        return vector;
    }

    public Vector rowByName(String string, String string2, String string3) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(new JLabel(string, UserBO.USER_ICON, 0));
        vector.addElement(string2);
        vector.addElement(string3);
        return vector;
    }

    public Vector iconTextByName(String string) {
        Vector<ASAIconTextData> vector = new Vector<ASAIconTextData>();
        vector.addElement(new ASAIconTextData(string));
        vector.addElement(new ASAIconTextData(this.getRoleStatus(string)));
        return vector;
    }

    public Vector iconTextByName(String string, String string2, String string3) {
        Vector<ASAIconTextData> vector = new Vector<ASAIconTextData>();
        vector.addElement(new ASAIconTextData(string));
        vector.addElement(new ASAIconTextData(string2));
        vector.addElement(new ASAIconTextData(string3));
        return vector;
    }

    public String isAlias(String string) throws SQLException {
        return this.isAlias(null, string);
    }

    public String isAlias(ASConnection aSConnection, String string) throws SQLException {
        ASConnection aSConnection2 = aSConnection == null ? this._conn : aSConnection;
        String string2 = "";
        String string3 = SQLs.getString("select u.name from {0}.dbo.sysusers u, master.dbo.syslogins l, {0}.dbo.sysalternates a where l.name=''{1}'' and l.suid=a.suid and a.altsuid=u.suid", string, this.getName());
        aSConnection2.getRSet().open(string3);
        if (aSConnection2.getRSet().getNextRow()) {
            String[] stringArray = aSConnection2.getRSet().getColumnsAsArray();
            string2 = stringArray[0];
        }
        aSConnection2.getRSet().close();
        return string2;
    }

    public String isDirect(String string) throws SQLException {
        return this.isDirect(null, string);
    }

    public String isDirect(ASConnection aSConnection, String string) throws SQLException {
        ASConnection aSConnection2 = aSConnection == null ? this._conn : aSConnection;
        String string2 = "";
        String string3 = SQLs.getString("select u.name from {0}.dbo.sysusers u, master.dbo.syslogins l where u.gid!=u.uid and l.name=''{1}'' and l.suid=u.suid", string, this.getName());
        aSConnection2.getRSet().open(string3);
        if (aSConnection2.getRSet().getNextRow()) {
            String[] stringArray = aSConnection2.getRSet().getColumnsAsArray();
            string2 = stringArray[0];
        }
        aSConnection2.getRSet().close();
        return string2;
    }

    public String[] getAliasDatabases() throws SQLException {
        Object[] objectArray = this.getAliasDatabaseSOs();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            DatabaseSO databaseSO = (DatabaseSO)objectArray[i];
            stringArray[i] = databaseSO.getName();
        }
        return stringArray;
    }

    public Object[] getAliasDatabaseSOs() throws SQLException {
        List<DatabaseSO> list;
        Object object;
        Vector<DatabaseSO> vector = new Vector<DatabaseSO>();
        if (this._conn.isCluster()) {
            object = new SDCInstancesCtrSO(this._conn);
            list = ((SDCInstancesCtrSO)object).getSDCNormalDBList(1);
        } else {
            object = new DatabasesCtrSO(this.getConnection());
            list = ((DatabasesCtrSO)object).getNormalDBList(1);
        }
        for (DatabaseSO databaseSO : list) {
            vector.addElement(databaseSO);
        }
        return vector.toArray();
    }

    public String[] getAliasList(String string) throws SQLException {
        return this.getAliasList(null, string);
    }

    public String[] getAliasList(ASConnection aSConnection, String string) throws SQLException {
        ASConnection aSConnection2 = aSConnection == null ? this._conn : aSConnection;
        Vector<String> vector = new Vector<String>();
        String string2 = SQLs.getString("select u.name, g.name from {0}.dbo.sysusers u, {0}.dbo.sysusers g, master.dbo.syslogins m where u.suid *= m.suid and u.gid *= g.uid and u.uid <= 16383 and u.uid > 0 order by 1", string);
        aSConnection2.getRSet().open(string2);
        while (aSConnection2.getRSet().getNextRow()) {
            String[] stringArray = aSConnection2.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[0].trim());
        }
        aSConnection2.getRSet().close();
        return vector.toArray(new String[vector.size()]);
    }

    public void dropAlias(String string) throws SQLException {
        this.useDB(string);
        String string2 = SQLs.getString("exec sp_dropalias {0}", this.getName());
        this._conn.executeCommand(string2);
    }

    public void dropDirect(String string, String string2) throws SQLException {
        this.useDB(string2);
        String string3 = SQLs.getString("exec sp_dropuser {0}", string);
        this._conn.executeCommand(string3);
    }

    public void addAlias(String string, String string2) throws SQLException {
        this.useDB(string);
        String string3 = SQLs.getString("exec sp_addalias {0}, {1}", this.getName(), string2);
        this._conn.executeCommand(string3);
    }

    public int getConfigMinPasswordLength() throws SQLException {
        int n = 6;
        if (this.getConnection().hasSSORole() && this.getConnection().isPwdComplexityApplicable()) {
            this.getRSet().open("exec sp_passwordpolicy 'list', 'minimum password length'");
            if (this.getRSet().getNextRow()) {
                n = this.getRSet().getColumnInt("Curr_value");
                return n;
            }
        }
        this.getRSet().open("exec sp_configure 'minimum password length'");
        while (this.getRSet().getNextRow()) {
            n = this.getRSet().getColumnInt(4);
        }
        return n;
    }

    public int getMinLoginPasswordLength() throws SQLException {
        int n = -1;
        this.getRSet().open(SQLs.getString("select int_value from master.dbo.sysattributes where object_type = ''PS'' and attribute = 1 and object = {0} and object_cinfo = ''login''", this._id));
        while (this.getRSet().getNextRow()) {
            n = this.getRSet().getColumnInt(1);
        }
        if (n != -1) {
            return n;
        }
        return this.getConfigMinPasswordLength();
    }

    public int getMaxFailedLogins() throws SQLException {
        String string = SQLs.getString("select int_value from master.dbo.sysattributes where object_type = ''PS'' and attribute = 2 and object = {0} and object_cinfo = ''login''", this._id);
        Vector<String[]> vector = Utility.openQuery2(string, this.getConnection());
        if (vector.size() == 0) {
            if (this.getConnection().hasSSORole() && this.getConnection().isPwdComplexityApplicable()) {
                this.getRSet().open("exec sp_passwordpolicy 'list', 'maximum failed logins'");
                if (this.getRSet().getNextRow()) {
                    return this.getRSet().getColumnInt("Curr_value");
                }
            }
            this.getRSet().open("select value from master.dbo.sysconfigures where name = 'maximum failed logins'");
            if (this.getRSet().getNextRow()) {
                return this.getRSet().getColumnInt(1);
            }
        }
        String[] stringArray = vector.elementAt(0);
        return Integer.valueOf(stringArray[0]);
    }

    public void setMinLoginPasswordLength(int n) throws SQLException {
        String string = SQLs.getString("exec sp_modifylogin {0}, ''min passwd length'', ''{1}''", this.getName(), String.valueOf(n));
        this._conn.executeCommand(string);
    }

    public void setPasswordExpireDays(int n) throws SQLException {
        String string = SQLs.getString("exec sp_modifylogin {0}, ''passwd expiration'', ''{1}''", this.getName(), String.valueOf(n));
        this._conn.executeCommand(string);
    }

    public void setMaxFailedLogins(int n) throws SQLException {
        String string = SQLs.getString("exec sp_modifylogin {0}, ''max failed_logins'', ''{1}''", this.getName(), String.valueOf(n));
        this._conn.executeCommand(string);
    }

    public String getTempDBBinding() throws SQLException {
        this.getRSet().open(SQLs.getString(" select char_value from master.dbo.sysattributes a,  master.dbo.syslogins b  where  class = 16  and a.object_type = ''LG''  and a.object = b.suid  and b.name = ''{0}'' ", this.getName()));
        if (this.getRSet().getNextRow()) {
            return this.getRSet().getColumnString(1);
        }
        return "";
    }

    public void setTempDBBinding(String string) throws SQLException {
        if (string.equals("Null")) {
            this._conn.executeCommand(SQLs.getString("exec master..sp_tempdb 'unbind',''lg'', ''{0}'' ", this.getName()));
        } else if (string.equals("default")) {
            this._conn.executeCommand(SQLs.getString("exec master..sp_tempdb 'bind' , ''lg'',''{0}'', ''GR'', ''default'' ", this.getName()));
        } else {
            this._conn.executeCommand(SQLs.getString("exec master..sp_tempdb 'bind', ''lg'',''{0}'',  ''DB'', ''{1}'' ", this.getName(), string));
        }
    }

    public Vector getTempDBs() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open(SQLs.getString("select name from master.dbo.sysdatabases where status3 & 256 = 256 order by {0}", new Integer(1)));
        while (this.getRSet().getNextRow()) {
            vector.add(this.getRSet().getColumnString(1));
        }
        return vector;
    }

    public void setUserDBNames(String[] stringArray) {
        this._userDBNames = stringArray;
    }

    public String[] getUserDBNames() {
        return this._userDBNames;
    }

    public void setUserNames(String[] stringArray) {
        this._userNames = stringArray;
    }

    public String[] getUserNames() {
        return this._userNames;
    }

    public void setUserGroups(String[] stringArray) {
        this._userGroups = stringArray;
    }

    public String[] getUserGroups() {
        return this._userGroups;
    }

    public void setTmpUserName(String string) {
        this._tmpUserName = string;
    }

    public String getTmpUserName() {
        return this._tmpUserName;
    }

    public Vector getAvailableUserGroups(String string) throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string2 = SQLs.getString("select name from {0}.dbo.sysusers where gid=uid and gid not in (select lrid from {0}.dbo.sysroles) order by 1 ", string);
        this.getRSet().open(string2);
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1));
        }
        this.getRSet().close();
        return vector;
    }

    public void createUsers() throws SQLException {
        for (int i = 0; i < this._userDBNames.length; ++i) {
            DatabaseSO databaseSO = this.getDatabaseSO(this._userDBNames[i]);
            if (databaseSO != null && databaseSO.isSDCLocalTempDB()) {
                databaseSO.createUser(this.getName(), this._userNames[i], this._userGroups[i]);
                continue;
            }
            this.useDB(this._userDBNames[i]);
            String string = SQLs.getString("exec sp_adduser ''{0}'' , ''{1}'' , {2} ", this.getName(), this._userNames[i], "'" + this._userGroups[i] + "'");
            this._conn.executeCommand(string);
            this.useMasterDB();
        }
    }

    private DatabaseSO getDatabaseSO(String string) throws SQLException {
        String string2;
        DatabaseSO databaseSO = null;
        List list = this.getAvailableDatabases();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !(string2 = (databaseSO = (DatabaseSO)iterator.next()).getName()).equals(string)) {
        }
        return databaseSO;
    }

    private ASConnection getDatabaseConnection(String string) throws SQLException {
        if (this._localConnections.isEmpty()) {
            List list = this.getAvailableDatabases();
            for (DatabaseSO databaseSO : list) {
                String string2 = databaseSO.getName();
                this._localConnections.put(string2, databaseSO.getConnection());
            }
        }
        return (ASConnection)this._localConnections.get(string);
    }

    public boolean isTempDBGroupApplicable() throws SQLException {
        String string = SQLs.getString("select object_cinfo, int_value from master..sysattributes where class = 16 and attribute = 0 and object_type = ''GR'' order by {0} ", new Integer(1));
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            return true;
        }
        this.getRSet().close();
        return false;
    }

    public boolean isPAMSupportApplicable() {
        ASConnection aSConnection = this.getConnection();
        if (aSConnection.getVersion().compareTo("12.5.2") < 0) {
            return false;
        }
        String string = aSConnection.getPlatform().toLowerCase();
        if (string.indexOf("sun") == -1 && string.indexOf("linux") == -1) {
            return false;
        }
        return aSConnection.hasSARole() || aSConnection.hasSSORole();
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_LOGIN_TEXT");
    }

    @Override
    public SOItemInterface duplicate() {
        LoginSO loginSO = new LoginSO(this.getConnection(), this.getName());
        loginSO._defaultDatabase = this._defaultDatabase;
        loginSO._fullName = this._defaultDatabase;
        loginSO._status = this._status;
        loginSO._defaultLanguage = this._defaultLanguage;
        loginSO._cputime = this._cputime;
        loginSO._iotime = this._iotime;
        loginSO._lastset = this._lastset;
        loginSO._id = this._id;
        loginSO._pwLastSet = this._pwLastSet;
        loginSO.initLockStatus();
        loginSO.setAuthMechanism();
        return loginSO;
    }

    @Override
    public boolean includeDelete() {
        String string = this.getName();
        boolean bl = string != null && !string.equals(SA) && !string.equals(PROBE);
        return bl;
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSSORole();
    }

    public void updateColumns() throws SQLException {
        Object[] objectArray = new Object[]{this.getName()};
        boolean bl = this.getConnection().getVersion().compareTo("15.0.2") >= 0;
        String string = SQLs.getString(bl ? "select suid, dbname, fullname, name, status, language, totcpu, totio, accdate, pwdate, lastlogindate from master.dbo.syslogins where name like ''{0}''" : "select suid, dbname, fullname, name, status, language, totcpu, totio, accdate, pwdate from master.dbo.syslogins where name like ''{0}''", objectArray);
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            this.load(stringArray);
        }
        this.getRSet().close();
    }

    public boolean canGenerateDDL() {
        return this._conn.hasSARole() || this._conn.hasSSORole();
    }
}

