/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.MBeanSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.ua.security.ac.ARL;
import com.sybase.ua.security.ac.PermissionValue;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class OperationSO
extends ASEBaseItemSO {
    private MBeanSO _mbean;
    private MBeanOperationInfo _opInfo;

    public OperationSO(MBeanSO mBeanSO, MBeanOperationInfo mBeanOperationInfo) {
        this._mbean = mBeanSO;
        this.setName(mBeanOperationInfo.getName());
        this._opInfo = mBeanOperationInfo;
    }

    public String getDescription() {
        return this._opInfo.getDescription();
    }

    @Override
    public Object[] getAttributes() {
        return new Object[]{this.getName(), this.getDescription(), this.getSignatureDesc(), this.getReturnType()};
    }

    public String getReturnType() {
        String string = this._opInfo.getReturnType();
        string = Utility.convertArrayType(string);
        return string;
    }

    public String getAccess() {
        String string = this.checkPermission("execute") ? "X" : "";
        return string;
    }

    public MBeanParameterInfo[] getParameterInfo() {
        return this._opInfo.getSignature();
    }

    public String getSignatureDesc() {
        String string = "(";
        MBeanParameterInfo[] mBeanParameterInfoArray = this._opInfo.getSignature();
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            String string2 = mBeanParameterInfoArray[i].getType();
            string2 = Utility.convertArrayType(string2);
            string = string + string2;
            if (i >= mBeanParameterInfoArray.length - 1) continue;
            string = string + ", ";
        }
        return string + ")";
    }

    public String getSignature() {
        String string = "";
        MBeanParameterInfo[] mBeanParameterInfoArray = this._opInfo.getSignature();
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            String string2 = mBeanParameterInfoArray[i].getType();
            string = string + string2;
            if (i >= mBeanParameterInfoArray.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public Object invoke(Object[] objectArray) throws Exception {
        MBeanParameterInfo[] mBeanParameterInfoArray = this._opInfo.getSignature();
        String[] stringArray = new String[mBeanParameterInfoArray.length];
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            stringArray[i] = mBeanParameterInfoArray[i].getType();
        }
        return this._mbean.invoke(this.getName(), objectArray, stringArray);
    }

    public String[] getPermissionNames() {
        ARL aRL = this._mbean.getARL();
        List list = aRL.getOperationPermissionValues();
        if (list != null) {
            Object[] objectArray = list.toArray();
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = ((PermissionValue)objectArray[i]).getName();
            }
            return stringArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public Boolean getPermission(String string, String string2) {
        ARL aRL = this._mbean.getARL();
        return new Boolean(aRL.hasOperationPermission(this.getName(), this.getSignature(), string, string2));
    }

    public void setPermissions(String string, String[] stringArray) {
        ARL aRL = this._mbean.getARL();
        aRL.setOperationPermissions(this.getName(), this.getSignature(), string, stringArray);
    }

    public Boolean isSecurityModuleSupported(String string) {
        ARL aRL = this._mbean.getARL();
        if (aRL.isSecurityModSupportedByOp(this.getName(), this.getSignature(), string)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setSecurityModules(String[] stringArray) {
        ARL aRL = this._mbean.getARL();
        aRL.setOperationSecurityModules(this.getName(), this.getSignature(), stringArray);
    }

    public void store() throws Exception {
        this._mbean.saveARL();
        this._mbean.reloadACLCache();
    }

    public boolean checkPermission(String string) {
        return this._mbean.checkOperationPermission(this.getName(), this.getSignature(), string);
    }

    public boolean isSupported() {
        String string = this.getSignature();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("java.lang.String") || string2.equals("boolean") || string2.equals("int") || string2.equals("long") || string2.equals("double") || string2.equals("short") || string2.equals("float")) continue;
            return false;
        }
        return true;
    }

    public MBeanSO getMBean() {
        return this._mbean;
    }
}

