/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ArticleSO;
import com.sybase.aseplugin.so.ReplicationStatusSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class PublicationSO
extends ReplicationStatusSO {
    private String _ddb;
    protected String _ds;
    protected String _db;
    protected String _name;
    protected boolean _allTables = false;
    protected boolean _allProcs = false;

    public PublicationSO(ASConnection aSConnection, String string) {
        super(aSConnection);
        Debug.wassert(aSConnection != null, this, "Null network connection parameter");
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty ddb parameter");
        this._ddb = string;
        this._conn = aSConnection;
    }

    public String getDDB() {
        return this._ddb;
    }

    @Override
    public String getDisplayName() {
        return this._name;
    }

    public String getLongName() {
        return this._name;
    }

    public void load(ASResultSet aSResultSet) throws SQLException {
        Debug.wassert(aSResultSet != null, this, "Null result set");
        this._ds = aSResultSet.getColumnString(1);
        if (this._ds == null || this._ds.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_PUB_DS_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._db = aSResultSet.getColumnString(2);
        if (this._db == null || this._db.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_PUB_DB_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._name = aSResultSet.getColumnString(3);
        if (this._name == null || this._name.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_PUB_NAME_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
    }

    @Override
    public void create() throws SQLException {
        Debug.wassert(this.getServer() != null && this.getServer().length() > 0, this, "Empty ds name");
        Debug.wassert(this.getDatabase() != null && this.getDatabase().length() > 0, this, "Empty db name");
        Debug.wassert(this.getDisplayName() != null && this.getDisplayName().length() > 0, this, "Empty publication name");
        Object[] objectArray = new String[]{this.getDDB(), this.getServer(), this.getDatabase(), this.getDisplayName()};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("CREATE_PUBLICATION", objectArray);
        this.getConnection().executeCommand(string);
    }

    @Override
    public void remove() throws SQLException {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("DROP_PUBLICATION", this.getDDB(), this.getDisplayName());
        this.getConnection().executeCommand(string);
    }

    public void setPubName(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty publication name");
        this._name = string;
    }

    public String getServer() {
        Debug.wassert(this._ds != null && this._ds.length() > 0, this, "Null or empty data server attribute");
        return this._ds;
    }

    public void setServer(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty data server name");
        this._ds = string;
    }

    public String getDatabase() {
        Debug.wassert(this._db != null && this._db.length() > 0, this, "Null or empty database attribute");
        return this._db;
    }

    public void setDatabase(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty database name");
        this._db = string;
    }

    public void setAllTables(boolean bl) {
        this._allTables = bl;
    }

    public boolean isAllTables() {
        return this._allTables;
    }

    public void setAllProcedures(boolean bl) {
        this._allProcs = bl;
    }

    public boolean isAllProcedures() {
        return this._allProcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPublications(ASConnection aSConnection, String string, String string2, String string3) throws SQLException {
        Debug.wassert(aSConnection != null, "Null connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty ddb parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter");
        Vector<PublicationSO> vector = new Vector<PublicationSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_PUBLICATIONS", string, string2, string3));
            while (aSResultSet.getNextRow()) {
                PublicationSO publicationSO = new PublicationSO(aSConnection, string);
                publicationSO.load(aSResultSet);
                vector.addElement(publicationSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPublications(ASConnection aSConnection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        Debug.wassert(aSConnection != null, "Invalid connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty DDB parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter");
        Debug.wassert(string4 != null && string4.length() > 0, "Null or empty article owner parameter");
        Debug.wassert(string5 != null && string5.length() > 0, "Null or empty article name parameter");
        Vector<PublicationSO> vector = new Vector<PublicationSO>();
        Object[] objectArray = new String[]{string, string4, string5, string2, string3};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_PUBS_FOR_ARTICLE", objectArray));
            while (aSResultSet.getNextRow()) {
                PublicationSO publicationSO = new PublicationSO(aSConnection, string);
                publicationSO.load(aSResultSet);
                vector.addElement(publicationSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPublications(ASConnection aSConnection, String string) throws SQLException {
        Debug.wassert(aSConnection != null, "Invalid connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty DDB parameter");
        Vector<PublicationSO> vector = new Vector<PublicationSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_ALL_PUBLICATIONS", string));
            while (aSResultSet.getNextRow()) {
                PublicationSO publicationSO = new PublicationSO(aSConnection, string);
                publicationSO.load(aSResultSet);
                vector.addElement(publicationSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List open(int n, Object[] objectArray) throws SQLException {
        Debug.trace(this, "Open Publication - " + this.getDisplayName());
        Vector<ArticleSO> vector = new Vector<ArticleSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("QUERY_ARTICLES", this.getDDB(), this.getName());
        try {
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                String string2 = ArticleSO.formatName(this.getRSet().getColumnString(4), this.getRSet().getColumnString(5));
                Debug.wassert(string2 != null && string2.length() > 0, "Invalid Article Name from DDB");
                ArticleSO articleSO = new ArticleSO(this.getConnection(), this.getDDB());
                articleSO.setPublication(this);
                articleSO.load(this.getRSet());
                vector.addElement(articleSO);
            }
        }
        finally {
            try {
                this.getRSet().close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("PUB_PROP_DISP_TYPE");
    }
}

