/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.OptGoal;
import com.sybase.aseplugin.so.QPTuneCtrSO;
import com.sybase.aseplugin.so.QPTuneRule;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.util.ds.Utils;
import java.awt.Container;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class QPTuneSO
extends ASEBaseItemSO {
    private static final String ACTION_START = "start";
    public static final String ACTION_COLLECT = "collect";
    public static final String ACTION_COLLECT_FULL = "collect_full";
    private static final String ACTION_COMPARE = "compare";
    private static final String ACTION_FIX = "fix";
    private static final String ACTION_START_STATS = "start_stats";
    private static final String ACTION_COLLECT_STATS = "collect_stats";
    private static final String ACTION_FIX_STATS = "fix_stats";
    private static final String ACTION_UNDO_FIX_STATS = "undo_fix_stats";
    private static final String XML_TAG_START = "start";
    private static final String XML_TAG_END = "end";
    private static final String XML_TAG_FIX = "fix";
    private static final String XML_TAG_START_STATS = "start_stats";
    private static final String XML_TAG_START_CONFIG = "start_config";
    private static final String XML_TAG_END_CONFIG = "end_config";
    private static final String XML_TAG_FIX_CONFIG = "fix_config";
    private static final String XML_TAG_START_STATS_CONFIG = "start_stats_config";
    private static final String XML_TAG_OPT_GOAL = "opt_goal";
    private static final String XML_TAG_CUSTOM_RULE = "customrule";
    private static final String XML_ATTR_NAME = "name";
    private static final String XML_TAG_MODE = "mode";
    private static final String XML_TAG_OPTGOAL = "optgoal";
    private static final String XML_TAG_RULE = "rule";
    public static final String XML_TAG_QTEXT = "qtext";
    private static String _configDotXMLFile;
    private boolean _isFixingStats;
    private String _fixStatsFile;
    private int _fixStatsThreshold;
    private boolean _fixStatsNoExec;
    private String _fixStatsNoExecScriptFile;
    private String _appPath;
    private String _scriptPath;
    private boolean _appEnabled;
    private boolean _scriptEnabled;
    private String _configFile = "";
    private String _startConfig;
    private String _endConfig;
    private String _fixConfig;
    private String _startStatConfig;
    private String _dbName;
    private ArrayList<OptGoal> _optGoals = new ArrayList();
    private String _collectOption;
    private int _collectDelay;
    private String _evalField;
    private int _thresholdPercent;
    private int _thresholdValue;
    private boolean _sortBySize;
    private String _resultFile;
    private boolean _verbose;
    private boolean _defaultOptGoals;
    private String _compareOutput;
    private String _lastPageTitle;
    private ServerSO _sso;
    private static String _qClassPath;
    private static String _qJava;

    public QPTuneSO(ServerSO serverSO) {
        this(serverSO, "");
    }

    public QPTuneSO(ServerSO serverSO, String string) {
        super(serverSO.getConnection(), string);
        this._sso = serverSO;
    }

    public ServerSO getServer() {
        return this._sso;
    }

    @Override
    public SOItemInterface duplicate() {
        QPTuneSO qPTuneSO = new QPTuneSO(this._sso, this.getName());
        qPTuneSO.setAppEnabled(this.getAppEnabled());
        qPTuneSO.setAppPath(this.getAppPath());
        qPTuneSO.setCollectDelay(this.getCollectDelay());
        qPTuneSO.setCollectOption(this.getCollectOption());
        qPTuneSO.setCompareOutput(this.getCompareOutput());
        qPTuneSO.setConfigFile(this.getConfigFile());
        qPTuneSO.setDBName(this.getDBName());
        qPTuneSO.setDefaultOptGoals(this.getDefaultOptGoals());
        qPTuneSO.setEndConfig(this.getEndConfig());
        qPTuneSO.setEvalField(this.getEvalField());
        qPTuneSO.setFixConfig(this.getFixConfig());
        qPTuneSO.setFixingStats(this.isFixingStats());
        qPTuneSO.setFixStatsFile(this.getFixStatsFile());
        qPTuneSO.setFixStatsNoExec(this.getFixStatsNoExec());
        qPTuneSO.setFixStatsNoExecScriptFile(this.getFixStatsNoExecScriptFile());
        qPTuneSO.setFixStatsThreshold(this.getFixStatsThreshold());
        qPTuneSO.setLastPageTitle(this.getLastPageTitle());
        qPTuneSO.setOptGoals(this.getOptGoals());
        qPTuneSO.setResultFile(this.getResultFile());
        qPTuneSO.setScriptEnabled(this.getScriptEnabled());
        qPTuneSO.setScriptPath(this.getScriptPath());
        qPTuneSO.setSortBySize(this.getSortBySize());
        qPTuneSO.setStartConfig(this.getStartConfig());
        qPTuneSO.setStartStatConfig(this.getStartStatConfig());
        qPTuneSO.setThresholdPercent(this.getThresholdPercent());
        qPTuneSO.setThresholdValue(this.getThresholdValue());
        qPTuneSO.setVerbose(this.getVerbose());
        return qPTuneSO;
    }

    public static String init() {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (_qClassPath != null) {
            return null;
        }
        String string2 = null;
        String string3 = "config.xml";
        String string4 = System.getProperty("aseplugin.qptune.configFolder");
        if (string4 != null && !string4.isEmpty() && !ASEUtils.isExistingFile(_configDotXMLFile = string4 + File.separator + string3)) {
            object3 = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), _configDotXMLFile);
            string2 = ASEUtils.getString("MSG_QPTUNE_CONFIG_FILE_NOT_FOUND") + "\n" + ((ASEMessageText)object3).toString();
            _configDotXMLFile = null;
        }
        object3 = new String[]{"SYBASE", "SYBASE_ASE", "SYBASE_JRE6"};
        for (int i = 0; i < ((String[])object3).length; ++i) {
            object2 = Utils.getEnVariable((String)object3[i]);
            if (object2 != null && !((String)object2).isEmpty()) continue;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_ENV_VARIABLE_NOT_DEFINED"), object3[i]);
            string2 = aSEMessageText.toString();
            return string2;
        }
        File file = Utils.getSybaseDir();
        if (file != null) {
            String string5;
            object2 = Utils.getCanonicalPath((File)file);
            string = Utils.getEnVariable((String)"SYBASE_ASE");
            object = (String)object2 + File.separator + string;
            if (_configDotXMLFile == null) {
                string5 = (String)object + File.separator + "qptune" + File.separator + string3;
                if (ASEUtils.isExistingFile(string5)) {
                    _configDotXMLFile = ASEUtils.getCanonicalPath(string5);
                } else {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), string5);
                    string2 = ASEUtils.getString("MSG_QPTUNE_CONFIG_FILE_NOT_FOUND") + "\n" + aSEMessageText.toString();
                    return string2;
                }
            }
            string5 = (String)object + File.separator + "lib" + File.separator + "qptune.jar";
            String string6 = (String)object + File.separator + "qptune" + File.separator + "lib" + File.separator + "xercesImpl.jar";
            String string7 = (String)object + File.separator + "qptune" + File.separator + "lib" + File.separator + "xml-apis.jar";
            String string8 = (String)object2 + File.separator + "jConnect-7_0" + File.separator + "classes" + File.separator + "jconn4.jar";
            String[] stringArray = new String[]{string5, string6, string7, string8};
            for (int i = 0; i < stringArray.length && (string2 = QPTuneSO.verifyJar(stringArray[i])) == null; ++i) {
            }
            if (string2 == null) {
                _qClassPath = string5 + File.pathSeparator + string6 + File.pathSeparator + string7 + File.pathSeparator + string8;
            }
        } else {
            object2 = new ASEMessageText(ASEUtils.getString("ERR_DIRECTORY_NOT_FOUND"), Utils.getEnVariable((String)"SYBASE"));
            string2 = ((ASEMessageText)object2).toString();
        }
        if (string2 != null) {
            return string2;
        }
        object2 = Utils.getEnVariable((String)"SYBASE_JRE6");
        string = (String)object2 + File.separator + "bin" + File.separator + (ASEUtils.OS_WINDOWS ? "java.exe" : "java");
        if (!ASEUtils.isExistingFile(string)) {
            object = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), string);
            string2 = ((ASEMessageText)object).toString();
            return string2;
        }
        _qJava = string;
        return null;
    }

    private static String verifyJar(String string) {
        String string2 = null;
        if (!ASEUtils.isExistingFile(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), string);
            string2 = ASEUtils.getString("MSG_QPTUNE_LIBRARY_NOT_FOUND") + "\n" + aSEMessageText.toString();
        }
        return string2;
    }

    public static ArrayList<String[]> getEvalFields() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_EXEC_MIN"), "exec_min"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_EXEC_MAX"), "exec_max"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_EXEC_AVG"), "exec_avg"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_ELAP_MIN"), "elap_min"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_ELAP_MAX"), "elap_max"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_ELAP_AVG"), "elap_avg"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_LIO_MIN"), "lio_min"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_LIO_MAX"), "lio_max"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_LIO_AVG"), "lio_avg"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_PIO_MIN"), "pio_min"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_PIO_MAX"), "pio_max"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_PIO_AVG"), "pio_avg"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_CNT"), "cnt"});
        arrayList.add(new String[]{ASEUtils.getString("QMETRICS_ABORT_CNT"), "abort_cnt"});
        return arrayList;
    }

    @Override
    public void create() {
        this._sso.getServerGroup().addTuningTask(this._sso, this);
    }

    @Override
    public void remove() {
        this._sso.getServerGroup().removeTuningTask(this._sso, this);
    }

    public void setFixingStats(boolean bl) {
        this._isFixingStats = bl;
    }

    public boolean isFixingStats() {
        return this._isFixingStats;
    }

    public void setFixStatsFile(String string) {
        this._fixStatsFile = string;
    }

    public String getFixStatsFile() {
        return this._fixStatsFile;
    }

    public void setScriptPath(String string) {
        this._scriptPath = string;
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public String getLastScriptPath() {
        return ProfileHelper.getPreference("Setting.LastTuningScript");
    }

    public void setScriptEnabled(boolean bl) {
        this._scriptEnabled = bl;
    }

    public boolean getScriptEnabled() {
        return this._scriptEnabled;
    }

    public void setAppPath(String string) {
        this._appPath = string;
    }

    public String getAppPath() {
        return this._appPath;
    }

    public String getLastAppPath() {
        return ProfileHelper.getPreference("Setting.LastTuningApp");
    }

    public void setAppEnabled(boolean bl) {
        this._appEnabled = bl;
    }

    public boolean getAppEnabled() {
        return this._appEnabled;
    }

    public void setFixStatsThreshold(int n) {
        this._fixStatsThreshold = n;
    }

    public int getFixStatsThreshold() {
        return this._fixStatsThreshold;
    }

    public void setFixStatsNoExec(boolean bl) {
        this._fixStatsNoExec = bl;
    }

    public boolean getFixStatsNoExec() {
        return this._fixStatsNoExec;
    }

    public void setFixStatsNoExecScriptFile(String string) {
        this._fixStatsNoExecScriptFile = string;
    }

    public String getFixStatsNoExecScriptFile() {
        return this._fixStatsNoExecScriptFile;
    }

    public void setConfigFile(String string) {
        this._configFile = string;
    }

    public String getConfigFile() {
        return this._configFile;
    }

    public void setDBName(String string) {
        this._dbName = string;
    }

    public String getDBName() {
        return this._dbName;
    }

    private String getConfigFileName() {
        return ASEUtils.isExistingFile(this.getConfigFile()) ? this.getConfigFile() : QPTuneSO.getConfigDotXMLFile();
    }

    public Hashtable<String, ArrayList<QPTuneRule>> getRulesTable() throws IOException {
        Hashtable<String, ArrayList<QPTuneRule>> hashtable = new Hashtable<String, ArrayList<QPTuneRule>>();
        hashtable.put("allrows_dss", this.getRulesList("allrows_dss"));
        hashtable.put("allrows_mix", this.getRulesList("allrows_mix"));
        hashtable.put("allrows_oltp", this.getRulesList("allrows_oltp"));
        return hashtable;
    }

    private Document readXMLFile(String string) throws IOException {
        DocumentBuilder documentBuilder;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_READING_FILE"), string);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(aSEMessageText.toString() + "\n" + parserConfigurationException.getMessage());
        }
        if (ASEUtils.isExistingFile(string)) {
            File file = new File(string);
            try {
                document = documentBuilder.parse(file);
            }
            catch (SAXException sAXException) {
                throw new IOException(aSEMessageText.toString() + "\n" + sAXException.getMessage());
            }
            catch (IOException iOException) {
                throw new IOException(aSEMessageText.toString() + "\n" + iOException.getMessage());
            }
        }
        return document;
    }

    private void writeXMLFile(Document document, String string) throws IOException {
        Transformer transformer;
        FileOutputStream fileOutputStream;
        File file = new File(string);
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_WRITING_FILE"), string);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(aSEMessageText.toString() + "\n" + fileNotFoundException.getMessage());
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(aSEMessageText.toString() + "\n" + transformerConfigurationException.getMessage());
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException(aSEMessageText.toString() + "\n" + transformerException.getMessage());
        }
    }

    public Vector<Vector<String>> getQueryList(String[] stringArray, String string, int n) {
        Object object;
        int n2;
        int n3;
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        Vector<Vector> vector2 = new Vector<Vector>();
        Vector<String> vector3 = new Vector<String>();
        for (n3 = 0; n3 < n; ++n3) {
            vector3.add(String.valueOf(n3));
        }
        vector2.add(vector3);
        n3 = 1;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object = stringArray[n2];
            Vector vector4 = this.getContent(string, (String)object, n);
            if (vector4.size() != n) {
                n3 = 0;
                break;
            }
            vector2.add(vector4);
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < n; ++n2) {
                object = new Vector();
                for (int i = 0; i < stringArray.length + 1; ++i) {
                    Vector vector5 = (Vector)vector2.get(i);
                    ((Vector)object).add(vector5.get(n2));
                }
                vector.add((Vector<String>)object);
            }
        }
        return vector;
    }

    private ArrayList<QPTuneRule> getRulesList(String string) throws IOException {
        ArrayList<QPTuneRule> arrayList = new ArrayList<QPTuneRule>();
        Document document = this.readXMLFile(this.getConfigFileName());
        NodeList nodeList = document.getElementsByTagName(XML_TAG_OPT_GOAL);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(string2 = ((Element)node).getAttribute(XML_ATTR_NAME)).equalsIgnoreCase(string)) continue;
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                String string3 = node2.getNodeName();
                if (string3 == null || !string3.equalsIgnoreCase(XML_TAG_CUSTOM_RULE)) continue;
                arrayList.add(new QPTuneRule(true, node2.getTextContent().trim()));
            }
        }
        return arrayList;
    }

    private Vector getConfigsList(String string) {
        return this.getContent(this.getConfigFileName(), string, 0);
    }

    private Vector getContent(String string, String string2, int n) {
        Vector<String> vector = new Vector<String>();
        try {
            Document document = this.readXMLFile(string);
            NodeList nodeList = document.getElementsByTagName(string2);
            for (int i = 0; i < nodeList.getLength() && (n == 0 || i <= n - 1); ++i) {
                Node node = nodeList.item(i);
                Node node2 = node.getFirstChild();
                if (node2.getNodeType() != 3) continue;
                vector.add(node2.getNodeValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vector;
    }

    private String getConfig(String string) {
        Vector vector = this.getConfigsList(string);
        String string2 = "";
        if (vector != null) {
            String string3 = "";
            for (int i = 0; i < vector.size(); ++i) {
                string2 = string2 + string3 + vector.elementAt(i);
                string3 = "\n";
            }
        }
        return string2;
    }

    public String getInitStartConfig() {
        return this.getConfig(XML_TAG_START_CONFIG);
    }

    public String getInitEndConfig() {
        return this.getConfig(XML_TAG_END_CONFIG);
    }

    public String getInitFixConfig() {
        return this.getConfig(XML_TAG_FIX_CONFIG);
    }

    public String getInitStartStatConfig() {
        return this.getConfig(XML_TAG_START_STATS_CONFIG);
    }

    public void setStartConfig(String string) {
        this._startConfig = string;
    }

    public String getStartConfig() {
        return this._startConfig;
    }

    public void setEndConfig(String string) {
        this._endConfig = string;
    }

    public String getEndConfig() {
        return this._endConfig;
    }

    public void setFixConfig(String string) {
        this._fixConfig = string;
    }

    public String getFixConfig() {
        return this._fixConfig;
    }

    public void setStartStatConfig(String string) {
        this._startStatConfig = string;
    }

    public String getStartStatConfig() {
        return this._startStatConfig;
    }

    public void setOptGoals(ArrayList<OptGoal> arrayList) {
        this._optGoals.clear();
        this._optGoals.addAll(arrayList);
    }

    public ArrayList<OptGoal> getOptGoals() {
        return this._optGoals;
    }

    public void setCollectOption(String string) {
        this._collectOption = string;
    }

    public String getCollectOption() {
        return this._collectOption;
    }

    public void setCollectDelay(int n) {
        this._collectDelay = n;
    }

    public int getCollectDelay() {
        return this._collectDelay;
    }

    public void setEvalField(String string) {
        this._evalField = string;
    }

    public String getEvalField() {
        return this._evalField;
    }

    public void setThresholdPercent(int n) {
        this._thresholdPercent = n;
    }

    public int getThresholdPercent() {
        return this._thresholdPercent;
    }

    public void setThresholdValue(int n) {
        this._thresholdValue = n;
    }

    public int getThresholdValue() {
        return this._thresholdValue;
    }

    public void setSortBySize(boolean bl) {
        this._sortBySize = bl;
    }

    public boolean getSortBySize() {
        return this._sortBySize;
    }

    public void setResultFile(String string) {
        this._resultFile = string;
    }

    public String getResultFile() {
        return this._resultFile;
    }

    public String getVerifyCompareResultFile() {
        String string = ASEUtils.getFileFromPath(this.getResultFile());
        String string2 = ASEUtils.getDirectoryFromPath(this.getResultFile());
        return string2 + File.separator + "fixed-" + string;
    }

    public String getVerifyResultFile() {
        String string = ASEUtils.getFileFromPath(this.getResultFile());
        String string2 = ASEUtils.getDirectoryFromPath(this.getResultFile());
        return string2 + File.separator + "fixed-out-" + string;
    }

    public void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    public boolean getVerbose() {
        return this._verbose;
    }

    public void setDefaultOptGoals(boolean bl) {
        this._defaultOptGoals = bl;
    }

    public boolean getDefaultOptGoals() {
        return this._defaultOptGoals;
    }

    public void setLastPageTitle(String string) {
        this._lastPageTitle = string;
    }

    public String getLastPageTitle() {
        return this._lastPageTitle;
    }

    public void setCompareOutput(String string) {
        this._compareOutput = string;
    }

    public String getCompareOutput() {
        return this._compareOutput;
    }

    private ArrayList<String> getUPS(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-U");
        arrayList.add(this.getServer().getUserName());
        arrayList.add("-P");
        arrayList.add(bl ? "<password>" : this.getServer().getPassword());
        arrayList.add("-S");
        arrayList.add(this.getServer().getHostAndPortNumber() + "/" + this.getDBName());
        arrayList.add("-A");
        arrayList.add(string);
        if (this.getVerbose()) {
            arrayList.add("-v");
        }
        return arrayList;
    }

    private ArrayList<String> getUPSC(String string, boolean bl) {
        ArrayList<String> arrayList = this.getUPS(string, bl);
        arrayList.addAll(this.getC());
        return arrayList;
    }

    private ArrayList<String> getUPSM(String string, String string2, boolean bl) {
        ArrayList<String> arrayList = this.getUPS(string, bl);
        arrayList.addAll(this.getC());
        arrayList.add("-M");
        arrayList.add(string2);
        return arrayList;
    }

    private ArrayList<String> getC() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-c");
        arrayList.add(this.getConfigFileName());
        return arrayList;
    }

    private ArrayList<String> getUPSM(String string, OptGoal optGoal, boolean bl) {
        ArrayList<String> arrayList = this.getUPSM(string, optGoal.getModeName(), bl);
        if (!optGoal.isPredefined() && optGoal.getInputFileName() != null && optGoal.getQueryNumber() > 0) {
            arrayList.add("-l");
            arrayList.add(String.valueOf(optGoal.getQueryNumber()));
            arrayList.add("-i");
            arrayList.add(optGoal.getInputFileName());
        }
        return arrayList;
    }

    private ArrayList<String> getStartArgs(OptGoal optGoal, boolean bl) {
        return this.getUPSM("start", optGoal, bl);
    }

    private String getCollectOutputFile(String string) {
        String string2 = string;
        if (string.startsWith("_")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("_")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = this.getName() + "_" + string2 + ".xml";
        String string4 = ASEUtils.getDirectoryFromPath(this.getConfigFile());
        String string5 = string4.isEmpty() ? "" : File.separator;
        String string6 = string4 + string5 + string3;
        return string6;
    }

    private ArrayList<String> getCollectArgs(OptGoal optGoal, boolean bl, CompareOption compareOption) {
        ArrayList<String> arrayList = this.getUPSM(this.getCollectOption(), optGoal, bl);
        arrayList.add("-T");
        arrayList.add(String.valueOf(this.getCollectDelay()));
        arrayList.add("-e");
        arrayList.add(this.getEvalField());
        arrayList.add("-o");
        if (compareOption == CompareOption.COMPARE) {
            arrayList.add(this.getCollectOutputFile(optGoal.getModeName()));
        } else {
            arrayList.add(this.getVerifyCompareResultFile());
        }
        return arrayList;
    }

    private ArrayList<String> getCompareArgs(String string, String string2, boolean bl, CompareOption compareOption) {
        ArrayList<String> arrayList = this.getUPSM(ACTION_COMPARE, string, bl);
        arrayList.add("-d");
        arrayList.add(String.valueOf(this.getThresholdPercent()) + "," + String.valueOf(this.getThresholdValue()));
        if (this.getSortBySize()) {
            arrayList.add("-s");
        }
        arrayList.add("-f");
        arrayList.add(string2);
        arrayList.add("-o");
        if (compareOption == CompareOption.COMPARE) {
            arrayList.add(this.getResultFile());
        } else if (compareOption == CompareOption.VERIFY_COMPARE) {
            arrayList.add(this.getVerifyCompareResultFile());
        } else if (compareOption == CompareOption.VERIFY) {
            arrayList.add(this.getVerifyResultFile());
        }
        return arrayList;
    }

    private ArrayList<String> getFixArgs(boolean bl) {
        ArrayList<String> arrayList = this.getUPSC("fix", bl);
        arrayList.add("-i");
        arrayList.add(this.getResultFile());
        if (this.getDefaultOptGoals()) {
            arrayList.add("-g");
        }
        return arrayList;
    }

    public ArrayList<String> getStartStatsArgs(boolean bl) {
        return this.getUPSC("start_stats", bl);
    }

    public ArrayList<String> getCollectStatsArgs(boolean bl) {
        ArrayList<String> arrayList = this.getUPSC(ACTION_COLLECT_STATS, bl);
        arrayList.addAll(Arrays.asList("-m", String.valueOf(this.getFixStatsThreshold()), "-o", this.getFixStatsFile()));
        return arrayList;
    }

    public ArrayList<String> getFixStatsArgs(boolean bl) {
        ArrayList<String> arrayList = this.getUPSC(ACTION_FIX_STATS, bl);
        arrayList.addAll(Arrays.asList("-m", String.valueOf(this.getFixStatsThreshold()), "-i", this.getFixStatsFile()));
        if (this.getFixStatsNoExec()) {
            arrayList.add("-N");
            arrayList.addAll(Arrays.asList("-o", this.getFixStatsNoExecScriptFile()));
        }
        return arrayList;
    }

    public ArrayList<String> getUndoFixArgs(boolean bl) {
        ArrayList<String> arrayList = this.getUPSC(ACTION_UNDO_FIX_STATS, bl);
        arrayList.addAll(Arrays.asList("-m", String.valueOf(this.getFixStatsThreshold()), "-i", this.getFixStatsFile()));
        return arrayList;
    }

    public String getDisplayCommand(ArrayList<String> arrayList) {
        String string = "QPTune";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + " " + arrayList.get(i);
        }
        return string;
    }

    private String getCollectedFilesArg() {
        return Utility.stringArrayToString(this.getCollectedFiles().toArray(), ",");
    }

    public ArrayList<String> getCollectedFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getOptGoals().size(); ++i) {
            OptGoal optGoal = this.getOptGoals().get(i);
            if (!optGoal.getEnabled()) continue;
            String string = this.getCollectOutputFile(optGoal.getModeName());
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean verifyCollectedFiles() {
        ArrayList<String> arrayList = this.getCollectedFiles();
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            if (ASEUtils.isExistingFile(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public ArrayList<String> fix(boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = this.getFixArgs(bl);
        if (bl) {
            arrayList2.add(this.getDisplayCommand(arrayList3));
        } else {
            arrayList.add(this.qptuneMain(arrayList3));
        }
        return bl ? arrayList2 : arrayList;
    }

    public String runApp(String string) throws IOException {
        return this.runApp(string, false);
    }

    public String runApp(String string, boolean bl) throws IOException {
        if (bl) {
            boolean bl2 = ASEUtils.desktopOpen(string, Desktop.Action.OPEN);
            if (!bl2) {
                Runtime.getRuntime().exec(string);
            }
        } else {
            Process process = Runtime.getRuntime().exec(string);
            if (process != null) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                ASEUtils.handleProcess(process, stringBuffer, stringBuffer2);
                return stringBuffer.toString() + stringBuffer2.toString();
            }
        }
        return "";
    }

    private void runScript(String string, Container container) throws Exception {
        Support.getProvider().runScript(container, this.getConnection(), this.getDBName(), string);
    }

    public ArrayList<String> startCollect(OptGoal optGoal, boolean bl, CompareOption compareOption, Container container) throws Exception {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (!optGoal.getEnabled()) {
            return arrayList2;
        }
        if (compareOption == CompareOption.COMPARE) {
            arrayList = this.getStartArgs(optGoal, bl);
            if (bl) {
                arrayList3.add(this.getDisplayCommand(arrayList));
            } else {
                arrayList2.add(this.qptuneMain(arrayList));
            }
        }
        if (bl) {
            if (this.getAppEnabled() && ASEUtils.isExistingFile(this.getAppPath())) {
                arrayList3.add(this.getAppPath());
            }
            if (this.getScriptEnabled() && ASEUtils.isExistingFile(this.getScriptPath())) {
                arrayList3.add(this.getScriptPath());
            }
        } else {
            if (this.getAppEnabled() && ASEUtils.isExistingFile(this.getAppPath())) {
                arrayList2.add(this.runApp(this.getAppPath()));
            }
            if (this.getScriptEnabled() && ASEUtils.isExistingFile(this.getScriptPath())) {
                this.runScript(this.getScriptPath(), container);
            }
        }
        arrayList = this.getCollectArgs(optGoal, bl, compareOption);
        if (bl) {
            arrayList3.add(this.getDisplayCommand(arrayList));
            arrayList3.add("\n");
        } else {
            arrayList2.add(this.qptuneMain(arrayList));
        }
        return bl ? arrayList3 : arrayList2;
    }

    public ArrayList<String> compare(boolean bl, CompareOption compareOption) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = this.getCompareArgs(this.getName(), this.getCollectedFilesArg(), bl, compareOption);
        if (bl) {
            arrayList2.add(this.getDisplayCommand(arrayList3));
        } else if (this.verifyCollectedFiles()) {
            arrayList.add(this.qptuneMain(arrayList3));
        }
        return bl ? arrayList2 : arrayList;
    }

    public ArrayList<String> verify(boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = this.getResultFile();
        String string2 = this.getVerifyCompareResultFile();
        String string3 = string + "," + string2;
        ArrayList<String> arrayList3 = this.getCompareArgs(this.getName(), string3, bl, CompareOption.VERIFY);
        if (bl) {
            arrayList2.add(this.getDisplayCommand(arrayList3));
        } else {
            if (string == null || string.isEmpty()) {
                return arrayList;
            }
            if (!ASEUtils.isExistingFile(string)) {
                return arrayList;
            }
            if (!ASEUtils.isExistingFile(string2)) {
                return arrayList;
            }
            arrayList.add(this.qptuneMain(arrayList3));
            ASEUtils.deleteFile(string2);
            ASEUtils.deleteFile(this.getVerifyResultFile());
        }
        return bl ? arrayList2 : arrayList;
    }

    public int getNumberOfEnabledOptGoals() {
        int n = 0;
        for (int i = 0; i < this.getOptGoals().size(); ++i) {
            OptGoal optGoal = this.getOptGoals().get(i);
            if (!optGoal.getEnabled()) continue;
            ++n;
        }
        return n;
    }

    public ArrayList<String> execute(boolean bl, Container container) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!bl) {
            this.createConfigFile();
        }
        for (int i = 0; i < this.getOptGoals().size(); ++i) {
            OptGoal optGoal = this.getOptGoals().get(i);
            ArrayList<String> arrayList3 = this.startCollect(optGoal, bl, CompareOption.COMPARE, container);
            if (bl) {
                arrayList2.addAll(arrayList3);
                continue;
            }
            arrayList.addAll(arrayList3);
        }
        ArrayList<String> arrayList4 = this.getCompareArgs(this.getName(), this.getCollectedFilesArg(), bl, CompareOption.COMPARE);
        if (bl) {
            arrayList2.add(this.getDisplayCommand(arrayList4));
        } else if (this.verifyCollectedFiles()) {
            arrayList.add(this.qptuneMain(arrayList4));
        }
        return bl ? arrayList2 : arrayList;
    }

    public ArrayList<String> fixStats(boolean bl, Container container) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.isFixingStats()) {
            ArrayList<String> arrayList3;
            ArrayList<String> arrayList4 = this.getStartStatsArgs(bl);
            if (bl) {
                arrayList2.add(this.getDisplayCommand(arrayList4));
            } else {
                arrayList.add(this.qptuneMain(arrayList4));
            }
            if (!ASEUtils.isExistingFile(this.getFixStatsFile())) {
                if (bl) {
                    if (this.getAppEnabled() && ASEUtils.isExistingFile(this.getAppPath())) {
                        arrayList2.add(this.getAppPath());
                    }
                    if (this.getScriptEnabled() && ASEUtils.isExistingFile(this.getScriptPath())) {
                        arrayList2.add(this.getScriptPath());
                    }
                } else {
                    if (this.getAppEnabled() && ASEUtils.isExistingFile(this.getAppPath())) {
                        arrayList.add(this.runApp(this.getAppPath()));
                    }
                    if (this.getScriptEnabled() && ASEUtils.isExistingFile(this.getScriptPath())) {
                        this.runScript(this.getScriptPath(), container);
                    }
                }
                arrayList3 = this.getCollectStatsArgs(bl);
                if (bl) {
                    arrayList2.add(this.getDisplayCommand(arrayList3));
                } else {
                    arrayList.add(this.qptuneMain(arrayList3));
                }
            }
            arrayList3 = this.getFixStatsArgs(bl);
            if (bl) {
                arrayList2.add(this.getDisplayCommand(arrayList3));
            } else if (ASEUtils.isExistingFile(this.getFixStatsFile())) {
                arrayList.add(this.qptuneMain(arrayList3));
            }
        } else {
            ArrayList<String> arrayList5 = this.getUndoFixArgs(bl);
            if (bl) {
                arrayList2.add(this.getDisplayCommand(arrayList5));
            } else {
                arrayList.add(this.qptuneMain(arrayList5));
            }
        }
        return bl ? arrayList2 : arrayList;
    }

    @Override
    public QPTuneSO findObject() {
        QPTuneCtrSO qPTuneCtrSO = new QPTuneCtrSO(this._sso);
        Object[] objectArray = new Object[]{this.getName()};
        List list = qPTuneCtrSO.open(1, objectArray);
        return list.isEmpty() ? null : (QPTuneSO)list.get(0);
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getConfigFile(), this.getDBName()};
    }

    @Override
    public String getFullyQualifiedName() {
        return null;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_RESOURCELIMIT_TYPE");
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSARole() && this._conn.hasSSORole();
    }

    public static String getConfigDotXMLFile() {
        return _configDotXMLFile;
    }

    public void createConfigFile() throws IOException {
        OptGoal optGoal;
        int n;
        Object object;
        Object object2;
        int n2;
        FileWriter fileWriter;
        String string = QPTuneSO.getConfigDotXMLFile();
        String string2 = this.getConfigFile();
        if (!ASEUtils.isExistingFile(string)) {
            throw new IOException(ASEUtils.getString("MSG_QPTUNE_CONFIG_FILE_NOT_FOUND"));
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (file2.exists()) {
            file2.delete();
        }
        FileReader fileReader = new FileReader(file);
        try {
            fileWriter = new FileWriter(file2);
        }
        catch (IOException iOException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_WRITING_FILE"), file2);
            throw new IOException(aSEMessageText.toString());
        }
        while ((n2 = fileReader.read()) != -1) {
            fileWriter.write(n2);
        }
        fileReader.close();
        fileWriter.close();
        Document document = this.readXMLFile(string2);
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = nodeList.item(i);
            if (object2.getNodeType() == 8) {
                element.removeChild((Node)object2);
                continue;
            }
            object = object2.getNodeName();
            if ((object == null || !((String)object).equals("start")) && !((String)object).equals(XML_TAG_END) && !((String)object).equals("fix") && !((String)object).equals("start_stats")) continue;
            element.removeChild((Node)object2);
        }
        Element element2 = this.createConfigElement(document, this.getStartConfig(), "start", XML_TAG_START_CONFIG);
        element.appendChild(element2);
        element2 = this.createConfigElement(document, this.getEndConfig(), XML_TAG_END, XML_TAG_END_CONFIG);
        element.appendChild(element2);
        element2 = this.createConfigElement(document, this.getFixConfig(), "fix", XML_TAG_FIX_CONFIG);
        element.appendChild(element2);
        element2 = this.createConfigElement(document, this.getStartStatConfig(), "start_stats", XML_TAG_START_STATS_CONFIG);
        element.appendChild(element2);
        object2 = this.getOptGoals();
        object = new ArrayList();
        for (n = 0; n < ((ArrayList)object2).size(); ++n) {
            optGoal = (OptGoal)((ArrayList)object2).get(n);
            if (optGoal.isPredefined() || optGoal.isBasic()) continue;
            ((ArrayList)object).add(optGoal);
        }
        for (n = 0; n < ((ArrayList)object).size(); ++n) {
            optGoal = (OptGoal)((ArrayList)object).get(n);
            String string3 = optGoal.getModeName();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string4 = node.getNodeName();
                String string5 = null;
                if (node.getNodeType() == 1) {
                    string5 = ((Element)node).getAttribute(XML_ATTR_NAME);
                }
                if (string4 == null || !string4.equals(XML_TAG_MODE) || string5 == null || !string5.equals(string3)) continue;
                element.removeChild(node);
            }
        }
        for (n = 0; n < ((ArrayList)object).size(); ++n) {
            optGoal = (OptGoal)((ArrayList)object).get(n);
            element2 = this.createModeElement(document, optGoal);
            element.appendChild(element2);
        }
        this.writeXMLFile(document, string2);
    }

    private Element createConfigElement(Document document, String string, String string2, String string3) {
        Element element = document.createElement(string2);
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = document.createElement(string3);
            Text text = document.createTextNode(stringArray[i].trim());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element;
    }

    private Element createModeElement(Document document, OptGoal optGoal) {
        Element element = document.createElement(XML_TAG_MODE);
        element.setAttribute(XML_ATTR_NAME, optGoal.getModeName());
        Element element2 = document.createElement(XML_TAG_OPTGOAL);
        Text text = document.createTextNode("use optgoal " + optGoal.getOptGoalName());
        element2.appendChild(text);
        element.appendChild(element2);
        ArrayList<QPTuneRule> arrayList = optGoal.getRules();
        for (int i = 0; i < arrayList.size(); ++i) {
            QPTuneRule qPTuneRule = arrayList.get(i);
            if (!qPTuneRule.enabled) continue;
            element2 = document.createElement(XML_TAG_RULE);
            text = document.createTextNode(qPTuneRule.sql);
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element;
    }

    private String qptuneMain(ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(_qJava);
        arrayList2.add("-cp");
        arrayList2.add(_qClassPath);
        arrayList2.add("com.sybase.qp.QPTune");
        arrayList2.addAll(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            Process process = Runtime.getRuntime().exec(arrayList2.toArray(new String[0]));
            if (process != null) {
                ASEUtils.handleProcess(process, stringBuffer, stringBuffer2);
                return stringBuffer.toString() + stringBuffer2.toString();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    static {
        _qClassPath = null;
    }

    public static enum CompareOption {
        COMPARE,
        VERIFY_COMPARE,
        VERIFY;

    }
}

