/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;

public class RegisteredJSSO
extends ASEBaseItemSO {
    private boolean traceThis = false;
    private boolean detailedTraceThis = false;
    private String[] _columns;
    private ASConnection _localConn;
    private boolean _isRegistered = false;
    public static final int RJSDEF_JS_SERVER = 0;
    public static final int RJSDEF_MACHINE = 1;
    public static final int RJSDEF_PORT = 2;

    public RegisteredJSSO(ASConnection aSConnection, ServerSO serverSO) {
        super(aSConnection, serverSO);
        super.setName("DNAME_REGISTER_JS");
        this._localConn = aSConnection;
        this.init(null);
        this.detailedTraceThis("Constructor for RegisteredJSSO(conn, parent)");
        this.getRegisteredJS();
    }

    public void init(String[] stringArray) {
        this.setType("REGISTERED_JS");
        if (stringArray == null) {
            this.setColumns(this.getDefaultColumns());
        } else {
            this.initColumns(stringArray);
        }
    }

    private String[] getDefaultColumns() {
        return new String[]{"", "", ""};
    }

    private void initColumns(String[] stringArray) {
        this.setColumns(this.getDefaultColumns());
        for (int i = 0; i < stringArray.length && i < 3; ++i) {
            this.setColumn(i, stringArray[i]);
        }
    }

    public void getRegisteredJS() {
        ASResultSet aSResultSet = this.getRSet();
        try {
            aSResultSet.open("exec sp_rjs_retrieve");
            if (aSResultSet.getNextRow()) {
                this.setJSServerName(aSResultSet.getColumnString(1));
                this.setJSMachineName(aSResultSet.getColumnString(2));
                this.setJSServerPort(Integer.parseInt(aSResultSet.getColumnString(3)));
                this._isRegistered = true;
            } else {
                this._isRegistered = false;
            }
            if (this.detailedTraceThis) {
                this.displayReceivedColumns();
            }
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            this._isRegistered = false;
        }
    }

    public void registerJS() throws SQLException {
        this.traceThis("Register a Job Scheduler");
        String string = SQLs.getString("exec sp_rjs_register @js_server=''{0}'', @host_name=''{1}'', @host_port={2}", this.getJSServerName(), this.getJSMachineName(), this.getJSServerPort() + "");
        this.traceThis(string);
        this._localConn.executeCommand(string);
        this._isRegistered = true;
    }

    public void unregister(String string, String string2, int n) throws SQLException {
        this.traceThis("Unregister a Job Scheduler");
        String string3 = SQLs.getString("exec sp_rjs_unregister @js_server=''{0}'', @host_name=''{1}'', @host_port={2}", this.getJSServerName(), this.getJSMachineName(), this.getJSServerPort() + "");
        this.traceThis(string3);
        this._localConn.executeCommand(string3);
    }

    public void update() throws SQLException {
        this.registerJS();
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this._columns[0], this._columns[1], this._columns[2]};
    }

    public void setColumns(String[] stringArray) {
        this._columns = stringArray;
    }

    public String[] getColumns() {
        return this._columns;
    }

    public String getColumn(int n) {
        if (n >= this._columns.length) {
            return "";
        }
        return this._columns[n];
    }

    public void setColumn(int n, String string) {
        if (n < this._columns.length) {
            this._columns[n] = string;
        }
    }

    public void setJSServerName(String string) {
        this._columns[0] = string.trim();
    }

    public void setJSMachineName(String string) {
        this._columns[1] = string.trim();
    }

    public void setJSServerPort(int n) {
        this._columns[2] = n + "";
    }

    public String getJSServerName() {
        return this._columns[0].trim();
    }

    public String getJSMachineName() {
        return this._columns[1].trim();
    }

    public int getJSServerPort() {
        try {
            int n = Integer.parseInt(this._columns[2]);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean isRegistered() {
        if (!this._isRegistered) {
            this.getRegisteredJS();
        }
        return this._isRegistered;
    }

    public void displayReceivedColumns() {
        System.out.println("------------------------------");
        System.out.println("BEGIN DISPLAY COLUMNS");
        System.out.println("RJSDEF_JS_SERVER = " + this.getColumn(0));
        System.out.println("RJSDEF_MACHINE = " + this.getColumn(1));
        System.out.println("RJSDEF_PORT = " + this.getColumn(2));
        System.out.println("------------------------------");
    }

    public void traceThis(String string) {
        if (this.traceThis) {
            System.out.println(string);
        }
    }

    public void detailedTraceThis(String string) {
        if (this.detailedTraceThis) {
            System.out.println(string);
        }
    }
}

