/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.ProxyServer;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.Vector;

class RemoteDatabase {
    private String _sName;
    private ProxyServer _remSrv;
    private Vector _vTableAndView;
    private Vector _vRPCs;
    private Vector _vUsers;
    private ASResultSet _resultSet;
    private boolean _blnFilterSysTable;

    public RemoteDatabase(ProxyServer proxyServer, String string, ASResultSet aSResultSet) {
        this._sName = string;
        this._remSrv = proxyServer;
        this._resultSet = aSResultSet;
        this._vTableAndView = new Vector();
        this._vRPCs = new Vector();
        this._vUsers = new Vector();
        this._blnFilterSysTable = true;
    }

    public boolean getFilterSysTable() {
        return this._blnFilterSysTable;
    }

    public void setFilterSysTable(boolean bl) {
        this._blnFilterSysTable = bl;
    }

    public String getRemoteServerName() {
        return this._remSrv.getName();
    }

    public String getRemoteUserName() {
        return this._remSrv.getUser();
    }

    public String getName() {
        return this._sName;
    }

    public Vector getTablesAndViews() throws SQLException {
        if (this._vTableAndView.isEmpty()) {
            String string = "";
            this._remSrv.enableCisRpcHandler();
            if (this._remSrv.isGatewayLess() || this._remSrv.getType().equals(this._remSrv.DC_ORACLE) || this._remSrv.getType().equals(this._remSrv.DC_DB2)) {
                string = SQLs.getString("exec {0}...sp_tables null, ''{1}''", this.getRemoteServerName(), this.getRemoteUserName().toUpperCase());
            } else if (this._remSrv.getType().equals(this._remSrv.DC_ANY) || this._remSrv.getType().equals(this._remSrv.DC_UNKNOWN)) {
                string = SQLs.getString("exec {0}...sp_tables ''%'', ''%'', ''{1}''", this.getRemoteServerName(), this._sName);
            } else if (this._remSrv.getType().equals("ASEnterprise") || this._remSrv.getType().equals("ASAnywhere") || this._remSrv.getType().equals("ASIQ")) {
                string = SQLs.getString("exec {0}.{1}..sp_tables", this.getRemoteServerName(), this._sName);
            }
            this._resultSet.open(string);
            while (this._resultSet.getNextRow()) {
                Vector<String> vector = new Vector<String>();
                vector.addElement(this._resultSet.getColumnString(3).trim());
                vector.addElement(this._resultSet.getColumnString(2).trim());
                vector.addElement(this._resultSet.getColumnString(4).trim());
                this._vTableAndView.addElement(vector);
            }
            this._resultSet.close();
            this._remSrv.disableCisRpcHandler();
        }
        return (Vector)this._vTableAndView.clone();
    }

    public Vector getRPCs() throws SQLException {
        if (this._vRPCs.isEmpty()) {
            Object object;
            String string = "";
            this._remSrv.enableCisRpcHandler();
            if (this._remSrv.isGatewayLess() || this._remSrv.getType().equals(this._remSrv.DC_ORACLE) || this._remSrv.getType().equals(this._remSrv.DC_DB2)) {
                string = SQLs.getString("exec {0}...sp_stored_procedures null, ''{1}''", this.getRemoteServerName(), this.getRemoteUserName().toUpperCase());
            } else if (this._remSrv.getType().equals(this._remSrv.DC_ANY) || this._remSrv.getType().equals(this._remSrv.DC_UNKNOWN)) {
                string = SQLs.getString("exec {0}...sp_stored_procedures ''%'', ''%'', ''{1}''", this.getRemoteServerName(), this._sName);
            } else if (this._remSrv.getType().equals("ASEnterprise") || this._remSrv.getType().equals("ASAnywhere") || this._remSrv.getType().equals("ASIQ")) {
                string = SQLs.getString("exec {0}.{1}..sp_stored_procedures", this.getRemoteServerName(), this._sName);
            }
            this._resultSet.open(string);
            String string2 = "";
            while (this._resultSet.getNextRow()) {
                object = this._resultSet.getColumnString(3);
                String string3 = this._resultSet.getColumnString(2);
                String string4 = (String)(object = ((String)object).indexOf(59) != -1 ? ((String)object).substring(0, ((String)object).length() - 2) : object) + "." + string3;
                if (string4.equals(string2)) continue;
                string2 = (String)object + "." + string3;
                Vector<String> vector = new Vector<String>();
                vector.addElement(((String)object).trim());
                vector.addElement(string3.trim());
                this._vRPCs.addElement(vector);
            }
            this._resultSet.close();
            object = new Vector();
            ((Vector)object).addElement("");
            ((Vector)object).addElement("");
            this._vRPCs.addElement(object);
            this._remSrv.disableCisRpcHandler();
        }
        return (Vector)this._vRPCs.clone();
    }

    public Vector getUsers() throws SQLException {
        if (this._vUsers.isEmpty()) {
            String string = "";
            this._remSrv.enableCisRpcHandler();
            if (this._remSrv.isGatewayLess() || this._remSrv.getType().equals(this._remSrv.DC_DB2)) {
                string = "select distinct creator from sysibm.systables order by 1";
            } else if (this._remSrv.getType().equals(this._remSrv.DC_ORACLE)) {
                string = "select distinct username from all_users order by 1";
            } else if (this._remSrv.getType().equals(this._remSrv.DC_UNKNOWN) || this._remSrv.getType().equals("ASEnterprise")) {
                string = SQLs.getString("select distinct name from {0}.dbo.sysusers where uid>0 and suid >=-1 order by 1", this._sName);
            } else if (this._remSrv.getType().equals(this._remSrv.DC_ANY)) {
                string = SQLs.getString("select distinct name from {0}.dbo.sysusers where uid>0 order by 1", this._sName);
            } else if (this._remSrv.getType().equals("ASAnywhere") || this._remSrv.getType().equals("ASIQ")) {
                string = "select distinct user_name from sys.sysuserperms order by 1";
            }
            this._resultSet.getConnection().executeCommand(SQLs.getString("connect to {0}", this._remSrv.getName()));
            try {
                this._resultSet.open(string);
                while (this._resultSet.getNextRow()) {
                    this._vUsers.addElement(this._resultSet.getColumnString(1).trim());
                }
                this._resultSet.close();
            }
            catch (SQLException sQLException) {
                this._resultSet.getConnection().executeCommand("disconnect");
                throw sQLException;
            }
            this._resultSet.getConnection().executeCommand("disconnect");
            this._remSrv.disableCisRpcHandler();
        }
        return (Vector)this._vUsers.clone();
    }
}

