/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.RemoteServersCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class RemoteServerSO
extends ASEBaseItemSO {
    public static final String DEFAULT_SERVER_CLASS = "ASEnterprise";
    public static final String SYB_BACKUP = "SYB_BACKUP";
    private String _remoteServerName = "";
    private String _networkname = "";
    private String _classname = "";
    private String _globalLogin = "";
    private boolean _mapToSameName;
    private String _status = "";
    protected static final int NAME = 1;
    private int NETWORKNAME = 2;
    private int CLASSNAME = 3;
    private int STATUS = 4;

    public RemoteServerSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
    }

    public RemoteServerSO(ASConnection aSConnection) {
        super(aSConnection);
    }

    public void load(Object object) {
        String[] stringArray = (String[])object;
        this._remoteServerName = stringArray[1];
        this._networkname = stringArray[this.NETWORKNAME];
        if (stringArray.length > this.CLASSNAME) {
            this._classname = stringArray[this.CLASSNAME];
        }
        this._status = stringArray[this.STATUS];
    }

    @Override
    public void create() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_addserver ''{0}'', {1}, ''{2}''", this.getName(), this.getClassName(), this.getNetworkName());
        this._conn.executeCommand(string);
    }

    @Override
    public void remove() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_dropserver ''{0}'', droplogins", this._remoteServerName);
        this._conn.executeCommand(string);
    }

    @Override
    public RemoteServerSO findObject() throws SQLException {
        RemoteServersCtrSO remoteServersCtrSO = new RemoteServersCtrSO(this.getConnection());
        Object[] objectArray = new Object[]{this.getName()};
        List list = remoteServersCtrSO.open(1, objectArray);
        return list.isEmpty() ? null : (RemoteServerSO)list.get(0);
    }

    public String getRemoteServerName() {
        return this.getName();
    }

    public void setReServerName(String string) {
        this.setName(string);
    }

    public String getNetworkName() {
        return this._networkname;
    }

    public void setNetworkName(String string) {
        this._networkname = string;
    }

    public String getClassName() {
        return this._classname;
    }

    public void setClassName(String string) {
        this._classname = string;
    }

    public String[] getClassNameList() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open("select name from master.dbo.spt_values where type = 'X' and number >= 0 and name not in ('access_server') order by name");
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[0].trim());
        }
        this.getRSet().close();
        Collections.sort(vector);
        String[] stringArray = new String[vector.size() + 1];
        stringArray[0] = "null";
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i + 1] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public void changeNetworkName(String string) throws SQLException {
        this.useMasterDB();
        String string2 = SQLs.getString("exec sp_addserver ''{0}'', {1}, ''{2}''", this.getName(), this._classname, string);
        this._conn.executeCommand(string2);
    }

    public void addRemoteServer(String string, String string2, String string3) throws SQLException {
        this.useMasterDB();
        String string4 = SQLs.getString("exec sp_addserver ''{0}'', {1}, ''{2}''", string, string3, string2);
        this._conn.executeCommand(string4);
    }

    public void setDefaultLoginProperty() throws SQLException {
        String string = SQLs.getString("select  l.name from master.dbo.syslogins l, master.dbo.sysremotelogins r, master.dbo.sysservers s where r.remoteusername is null and r.suid > 0 and r.suid = l.suid and s.srvid = r.remoteserverid and s.srvname = ''{0}''", this.getName());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            this._globalLogin = this.getRSet().getColumnsAsArray()[0];
        }
        string = SQLs.getString("select ''Y'' from master.dbo.sysremotelogins r, master.dbo.sysservers s where r.remoteusername is null and r.suid < 0 and s.srvid = r.remoteserverid  and s.srvname = ''{0}''", this.getName());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnsAsArray()[0];
            this._mapToSameName = string2.equals("Y");
        }
    }

    public String[] getLoginNameList() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open(SQLs.getString("select suid, dbname, fullname, name, status, language, totcpu, totio, accdate, pwdate from master.dbo.syslogins where name like ''{0}''", "%"));
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[3].trim());
        }
        this.getRSet().close();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public String getGlobalLogin() {
        return this._globalLogin;
    }

    public boolean loginMapToOne() {
        return this._globalLogin.length() != 0;
    }

    public void dropMapToOne(String string) throws SQLException {
        this.useMasterDB();
        String string2 = SQLs.getString("exec sp_dropremotelogin {0}, {1}", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void setGlobalMapToOne(String string) throws SQLException {
        this.useMasterDB();
        String string2 = SQLs.getString("exec sp_addremotelogin {0}, {1}", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void dropMapToSame() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_dropremotelogin {0}", this.getName());
        this._conn.executeCommand(string);
    }

    public void globalMapToSame() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_addremotelogin {0}", this.getName());
        this._conn.executeCommand(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() {
        if (Support.getEnableSQLPreview()) {
            try {
                this._conn.setCISRPCHandler(true);
                this._conn.executeCommand(SQLs.getString("exec {0}...sp_who", this.getName()));
                this._conn.setCISRPCHandler(false);
            }
            catch (SQLException sQLException) {
                return false;
            }
            return true;
        }
        try {
            this._conn.executeCommand(SQLs.getString("exec {0}...sp_who", this.getName()));
            return true;
        }
        catch (SQLException sQLException) {
            try {
                this._conn.setCISRPCHandler(true);
                this._conn.executeCommand(SQLs.getString("exec {0}...sp_who", this.getName()));
                boolean bl = true;
                return bl;
            }
            catch (SQLException sQLException2) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    this._conn.setCISRPCHandler(false);
                }
                catch (SQLException sQLException3) {}
            }
        }
    }

    public boolean isLoginMapToSame() {
        return this._mapToSameName;
    }

    public ASResultSet getSpecificTableMapping() throws SQLException {
        String string = SQLs.getString("select r.remoteusername, suser_name( r.suid ), r.status from master.dbo.sysservers s, master.dbo.sysremotelogins r where s.srvid = r.remoteserverid and r.remoteusername is not null and s.srvid > 0 and s.srvname = ''{0}'' order by 1", this._remoteServerName);
        this.getRSet().open(string);
        return this.getRSet();
    }

    public Vector getLocalLogins() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open("select suid, dbname, fullname, name, status from master.dbo.syslogins order by name");
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(4));
        }
        return vector;
    }

    public Vector getRoles() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open("select name from master..syssrvroles");
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1));
        }
        return vector;
    }

    public void addRemoteLogin(String string, String string2, String string3) throws SQLException {
        this.useMasterDB();
        String string4 = SQLs.getString("exec sp_addremotelogin {0}, {1}", this.getName(), string2 + " , " + string);
        this._conn.executeCommand(string4);
        String string5 = ASEUtils.getString("MSG_TRUSTED");
        if (string5.compareTo(string3) == 0) {
            String string6 = SQLs.getString("exec sp_remoteoption {0}", this.getName() + "," + string2 + "," + string + "," + string5 + ",true");
            this._conn.executeCommand(string6);
        }
    }

    public void dropRemoteLogin(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = SQLs.getString("exec sp_dropremotelogin {0}, {1}", this.getName(), string2 + " , " + string);
        this._conn.executeCommand(string3);
    }

    public Vector getCISMapping() throws SQLException {
        Vector<String[]> vector = new Vector<String[]>();
        String string = SQLs.getString("select object_cinfo, LOGIN_NAME=suser_name(object), ROLE_NAME=role_name(object_info2) from master.dbo.sysattributes a, master.dbo.sysservers s where a.class = 9 and a.object_type = ''EL'' and a.object_info1 = s.srvid and s.srvname LIKE ''{0}'' order by object_cinfo", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnsAsArray());
        }
        return vector;
    }

    public void dropExternalLogin(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = "";
        string3 = string2.equals(ASEUtils.getString("DISP_LOGIN_TEXT")) ? SQLs.getString("exec sp_dropexternlogin {0}, {1}", this._remoteServerName, string) : SQLs.getString("exec sp_dropexternlogin {0}, NULL, {1} ", this._remoteServerName, string);
        this._conn.executeCommand(string3);
    }

    public void addExternalLoginRole(String string, String string2, String string3, String string4) throws SQLException {
        this.useMasterDB();
        String string5 = "";
        string3 = string4.length() > 0 ? string3 + "," + string4 : string3 + "," + "NULL";
        string5 = string2.equals(ASEUtils.getString("DISP_LOGIN_TEXT")) ? SQLs.getString("exec sp_addexternlogin {0}, {1}, {2}", this._remoteServerName, string, string3) : SQLs.getString("exec sp_addexternlogin {0}, NULL, {1} , {2}", this._remoteServerName, string3, string);
        this._conn.executeCommand(string5);
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this._networkname, this._classname};
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_REMOTE_SERVER_TYPE");
    }

    public Enumeration getOptionData() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open("exec sp_serveroption");
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[0]);
        }
        this.getRSet().close();
        return vector.elements();
    }

    public boolean getOptionStatus(String string) throws SQLException {
        this.getRSet().open(SQLs.getString("select number from master.dbo.spt_values where type = ''A'' and name = ''{0}''", string));
        if (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            String string2 = stringArray[0];
            if (string.equals("timeouts")) {
                return (Integer.parseInt(this._status) & Integer.parseInt(string2)) == 0;
            }
            return (Integer.parseInt(this._status) & Integer.parseInt(string2)) != 0;
        }
        return false;
    }

    public void setOptionStatus(String string, boolean bl) throws SQLException {
        this.useMasterDB();
        String string2 = "exec sp_serveroption '" + this.getName() + "' , '" + string + "' , " + new Boolean(bl).toString();
        this._conn.executeCommand(string2);
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSSORole();
    }
}

