/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.RLMetaData;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class RepArticleSO
extends ASEBaseItemSO {
    private String _ddb;
    protected String _ds;
    protected String _db;
    protected String _type = null;
    protected String _name = null;
    protected String _owner = null;
    protected String _subscription;
    protected String _publication;
    protected String _partOwner = null;
    protected String _partName = null;
    protected String _proxyTable = null;
    protected String _distProc = null;
    protected String _validState = null;
    protected String _whereClause = null;
    protected String _newArticleFields = null;
    protected String _validStatePending = "0000000000000000000000000000000000000000000000000000000000000000";
    public static final int LAST_COMMIT_DATE_COL = 0;
    public static final int LAST_COMMIT_LOCATOR_COL = 1;

    public RepArticleSO(ASConnection aSConnection, String string) {
        super(aSConnection);
        Debug.wassert(aSConnection != null, this, "Null network connection parameter");
        this._ddb = string;
    }

    public synchronized String getDDB() {
        return this._ddb;
    }

    public static String formatName(String string, String string2) {
        Debug.wassert(string2 != null && string2.length() > 0, "Invalid name");
        return string + string2;
    }

    @Override
    public String getDisplayName() {
        return this._name;
    }

    public String getLongName() {
        return this.getOwner() + "." + this.getDisplayName();
    }

    public String getFullName() {
        String string = null;
        if (this.getDisplayName() != null && this.getDisplayName().length() > 0) {
            string = this.getOwner() != null && this.getOwner().length() > 0 ? this.getOwner() + "." + this.getDisplayName() : this.getDisplayName();
        }
        return string;
    }

    public void load(ASResultSet aSResultSet) throws SQLException {
        Debug.wassert(aSResultSet != null, this, "Null result set");
        this._ds = aSResultSet.getColumnString(1);
        if (this._ds == null || this._ds.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_DS_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._db = aSResultSet.getColumnString(2);
        if (this._db == null || this._db.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_DB_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._type = aSResultSet.getColumnString(7);
        if (!this.isTable() && !this.isProcedure()) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_TYPE_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._name = aSResultSet.getColumnString(5);
        if (this._name == null || this._name.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_NAME_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._owner = aSResultSet.getColumnString(4);
        if (this._owner == null || this._owner.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_OWNER_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._subscription = aSResultSet.getColumnString(3);
        if (this._subscription == null || this._subscription.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_SUB_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._publication = aSResultSet.getColumnString(12);
        if (this._publication == null || this._publication.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_PUB_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._partOwner = aSResultSet.getColumnString(13);
        if (this._partOwner == null || this._partOwner.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_POWNER_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._partName = aSResultSet.getColumnString(14);
        if (this._partName == null || this._partName.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_RART_PART_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._proxyTable = aSResultSet.getColumnString(8);
        this._distProc = aSResultSet.getColumnString(9);
        this._whereClause = aSResultSet.getColumnString(11);
        this._validState = aSResultSet.getColumnString(10);
        this._validState = this._validState.equalsIgnoreCase("null") || this._validState.equalsIgnoreCase("false") || this._validState.length() == 0 ? ASEUtils.getString("REP_ART_INVALID") : (this._validState.equalsIgnoreCase(this._validStatePending) || this._validState.equalsIgnoreCase("pending") ? ASEUtils.getString("REP_ART_PENDING") : ASEUtils.getString("REP_ART_VALID"));
    }

    @Override
    public void create() throws SQLException {
        String string;
        String string2;
        String string3 = this.getPrimaryArticle();
        Debug.wassert(string3 != null && string3.length() > 0, this, "Null or blank primary article name");
        String string4 = this.getPrimaryArticleOwner();
        Debug.wassert(string4 != null && string4.length() > 0, this, "Null or blank primary article owner");
        boolean bl = false;
        String string5 = this.getDisplayName();
        if (string5 == null || string5.length() == 0) {
            string5 = string3;
            this.setRepArtName(string5);
            bl = true;
        }
        if ((string2 = this.getOwner()) == null) {
            string2 = "";
        }
        Debug.wassert((string = this.getFullName()) != null && string.length() > 0, this, "Null or Empty replicate article name");
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        if (bl) {
            Object[] objectArray = new String[]{this.getDDB(), this.getSubscription(), this.getPrimaryArticleOwner(), this.getPrimaryArticle(), string5};
            String string6 = rLSQLResourceBundle.getString("ADD_REP_ARTICLE_DEFAULT", objectArray);
            this.getConnection().executeCommand(string6);
        } else {
            if (this.isProcedure() && (this._newArticleFields == null || this._newArticleFields.length() == 0)) {
                this._newArticleFields = "0";
            }
            if (this.getWhereClause() != null && this.getWhereClause().length() > 0) {
                String string7 = this.AddExtraQuotes();
                Object[] objectArray = new String[]{this.getDDB(), this.getSubscription(), this.getPrimaryArticleOwner(), this.getPrimaryArticle(), string, this._newArticleFields, string7};
                String string8 = rLSQLResourceBundle.getString("ADD_REP_ARTICLE_WHERE", objectArray);
                this.getConnection().executeCommand(string8);
            } else {
                Object[] objectArray = new String[]{this.getDDB(), this.getSubscription(), this.getPrimaryArticleOwner(), this.getPrimaryArticle(), string, this._newArticleFields};
                String string9 = rLSQLResourceBundle.getString("ADD_REP_ARTICLE", objectArray);
                this.getConnection().executeCommand(string9);
            }
        }
    }

    @Override
    public void remove() throws SQLException {
        Object[] objectArray = new String[]{this.getDDB(), this.getSubscription(), this.getOwner(), this.getDisplayName()};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("DROP_REP_ARTICLE", objectArray);
        this.getConnection().executeCommand(string);
    }

    public void setRepArtName(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty replicate article name");
        this._name = string;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setOwner(String string) {
        this._owner = string;
    }

    public void setArticleType(String string) {
        this._type = string;
    }

    public String getArticleType() {
        return this._type;
    }

    public boolean isNotValid() {
        return this.getState().equals(ASEUtils.getString("REP_ART_INVALID"));
    }

    public boolean isTable() {
        boolean bl = false;
        if (this.getArticleType() != null) {
            bl = this.getArticleType().equals("table");
        }
        return bl;
    }

    public boolean isProcedure() {
        boolean bl = false;
        if (this.getArticleType() != null) {
            bl = this.getArticleType().equals("procedure");
        }
        return bl;
    }

    public String getTypeString() {
        if (this.isTable()) {
            return ASEUtils.getString("DISP_TABLE_ARTICLE");
        }
        if (this.isProcedure()) {
            return ASEUtils.getString("DISP_PROC_ARTICLE");
        }
        Debug.wassert(false, this, "Unexpected Article Type");
        return null;
    }

    public void setTableType() {
        this._type = "table";
    }

    public void setProcedureType() {
        this._type = "procedure";
    }

    public void setNewFields(String string) {
        this._newArticleFields = string;
    }

    public String getServer() {
        return this._ds;
    }

    public void setServer(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty data server name");
        this._ds = string;
    }

    public String getDatabase() {
        return this._db;
    }

    public void setDatabase(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty database name");
        this._db = string;
    }

    public String getSubscription() {
        return this._subscription;
    }

    public void setSubscription(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty subscription name");
        this._subscription = string;
    }

    public String getPublication() {
        return this._publication;
    }

    public void setPublication(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty publication name");
        this._publication = string;
    }

    public void setPrimaryArticleOwner(String string) {
        this._partOwner = string;
    }

    public String getPrimaryArticleOwner() {
        return this._partOwner;
    }

    public void setPrimaryArticle(String string) {
        this._partName = string;
    }

    public String getPrimaryArticle() {
        return this._partName;
    }

    public String getProxyTable() {
        return this._proxyTable;
    }

    public String getDistProc() {
        return this._distProc;
    }

    public String getState() {
        return this._validState;
    }

    public void setWhereClause(String string) {
        this._whereClause = string;
    }

    public String getWhereClause() {
        String string = this._whereClause == null || this._whereClause.equalsIgnoreCase("null") ? "" : this._whereClause;
        return string;
    }

    public String materialize() {
        String string = this.getFullName();
        Debug.wassert(string != null && string.length() > 0, this, "Null or Empty Replicate Article name");
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string2 = rLSQLResourceBundle.getString("MATERIALIZE_REP_ARTICLE", this.getDDB(), this.getSubscription(), string);
        Debug.wassert(string2 != null && string2.length() > 0, this, "Invalid SQL Resource");
        return string2;
    }

    public String validate() {
        String string = this.getFullName();
        Debug.wassert(string != null && string.length() > 0, this, "Null or Empty Replicate Article name");
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string2 = rLSQLResourceBundle.getString("VALIDATE_REP_ARTICLE", this.getDDB(), this.getSubscription(), string);
        Debug.wassert(string2 != null && string2.length() > 0, this, "Invalid SQL Resource");
        return string2;
    }

    public void doMaterialize() throws Exception {
        String string = this.getFullName();
        if (string != null && string.length() > 0) {
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            String string2 = rLSQLResourceBundle.getString("MATERIALIZE_REP_ARTICLE", this.getDDB(), this.getSubscription(), string);
            this.execute(string2);
        }
    }

    public void doValidate() throws Exception {
        String string = this.getFullName();
        if (string != null && string.length() > 0) {
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            String string2 = rLSQLResourceBundle.getString("VALIDATE_REP_ARTICLE", this.getDDB(), this.getSubscription(), string);
            this.execute(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String string) throws SQLException {
        SQLException sQLException = null;
        try {
            this.getConnection().executeCommand(string);
        }
        catch (SQLException sQLException2) {
            if (sQLException == null) {
                sQLException = sQLException2;
            }
            sQLException.setNextException(sQLException2);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFields() throws SQLException {
        Vector vector = new Vector();
        Object[] objectArray = new String[]{this.getDDB(), this.getSubscription(), this.getOwner(), this.getDisplayName()};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASConnection aSConnection = this.getConnection();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_ART_FIELDS", objectArray));
            while (aSResultSet.getNextRow()) {
                String string;
                Vector<String> vector2 = new Vector<String>();
                String string2 = aSResultSet.getColumnString(9);
                if (string2 == null || string2.length() == 0) {
                    string = ASEUtils.getString("ERR_INVALID_SQL_ART_FIELD_FLD");
                    SQLException sQLException = new SQLException(string);
                    throw sQLException;
                }
                vector2.addElement(string2);
                string = aSResultSet.getColumnString(10);
                if (string == null || string.length() == 0) {
                    String string3 = ASEUtils.getString("ERR_INVALID_SQL_ART_DT_FLD");
                    SQLException sQLException = new SQLException(string3);
                    throw sQLException;
                }
                int n = aSResultSet.getColumnInt(11);
                int n2 = aSResultSet.getColumnInt(12);
                vector2.addElement(RLMetaData.FormatDatatype(aSConnection, string, n, n, n2));
                vector.addElement(vector2);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getLastCommit() throws SQLException {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = new String[]{this.getDDB(), this.getSubscription(), this.getOwner(), this.getDisplayName()};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASConnection aSConnection = this.getConnection();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_ART_LAST_COMMIT", objectArray));
            if (aSResultSet.getNextRow()) {
                vector.addElement(aSResultSet.getColumnString(1));
                vector.addElement(aSResultSet.getColumnString(2));
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    private String AddExtraQuotes() {
        String string = new String(this._whereClause);
        int n = string.indexOf("'");
        while (n >= 0 && n < string.length()) {
            string = string.substring(0, n) + "'" + string.substring(n);
            n = string.indexOf("'", n + 2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getReplicateArticles(ASConnection aSConnection, String string, String string2, SOItemInterface sOItemInterface) throws SQLException {
        Debug.wassert(aSConnection != null, "Null connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty ddb parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty subscription parameter");
        Vector<RepArticleSO> vector = new Vector<RepArticleSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_ARTICLES", string, string2));
            while (aSResultSet.getNextRow()) {
                RepArticleSO repArticleSO = new RepArticleSO(aSConnection, string);
                repArticleSO.load(aSResultSet);
                vector.addElement(repArticleSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getReplicateArticles(ASConnection aSConnection, String string, String string2, String string3, SOItemInterface sOItemInterface) throws SQLException {
        Debug.wassert(aSConnection != null, "Null connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty ddb parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter");
        Vector<RepArticleSO> vector = new Vector<RepArticleSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_ARTICLES_FOR_CONN", string, string2, string3));
            while (aSResultSet.getNextRow()) {
                RepArticleSO repArticleSO = new RepArticleSO(aSConnection, string);
                repArticleSO.load(aSResultSet);
                vector.addElement(repArticleSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    @Override
    public Object[] getAttributes() {
        return null;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("RART_PROP_DISP_TYPE");
    }
}

