/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ReplicationStatusSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class ReplicationSO
extends ReplicationStatusSO {
    private static final String MONITORING_PARM = "status_monitoring";
    private static final String MONITORING_DELAY_PARM = "monitor_delay";
    private static final int DELAY_DEFAULT = 60;
    private boolean _statusMonitoring = false;
    private int _monitorDelay = 60;
    private String _DDB = null;
    public static final int REP_PARM_NAME_COL = 0;
    public static final int REP_PARM_CURR_VAL_COL = 1;
    public static final int REP_PARM_PEND_VAL_COL = 2;
    public static final int REP_PARM_TYPE_COL = 3;
    public static final int REP_PARM_DEF_VAL_COL = 4;
    public static final int REP_PARM_LEGAL_VAL_COL = 5;
    public static final int REP_PARM_RESTART_COL = 6;
    public static final int REP_PARM_DESC_COL = 7;
    public static final int REP_TRACE_NAME_COL = 0;
    public static final int REP_TRACE_VALUE_COL = 1;
    public static final int REP_TRACE_FILE_COL = 2;
    public static final int REP_TRACE_DESC_COL = 3;

    public ReplicationSO(ASConnection aSConnection) {
        super(aSConnection);
        Debug.wassert(aSConnection != null, this, "Null network connection parameter");
        this.load();
    }

    public synchronized String getDDB() {
        return this._DDB;
    }

    @Override
    public String getDisplayName() {
        return ASEUtils.getString("DNAME_REPLICATION");
    }

    public boolean getMonitoringFlag() {
        return this._statusMonitoring;
    }

    public void setMonitoringFlag(boolean bl) {
        this._statusMonitoring = bl;
        try {
            this.setConfigParm(MONITORING_PARM, String.valueOf(bl));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMonitorDelay() {
        return this._monitorDelay;
    }

    public void setMonitorDelay(int n) {
        this._monitorDelay = n;
        try {
            this.setConfigParm(MONITORING_DELAY_PARM, String.valueOf(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List open(int n, Object[] objectArray) {
        Vector vector = new Vector();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("QUERY_DDB");
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        try {
            aSResultSet.open(string);
            aSResultSet.getNextRow();
            this._DDB = aSResultSet.getColumnString(1);
        }
        catch (Exception exception) {
            this._DDB = null;
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (Exception exception) {}
        }
        this._statusMonitoring = false;
        this._monitorDelay = 60;
        if (this._DDB != null && this._DDB.length() > 0) {
            String string2;
            try {
                string2 = this.getConfigParm(MONITORING_PARM);
                this._statusMonitoring = Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                this._statusMonitoring = false;
            }
            try {
                string2 = this.getConfigParm(MONITORING_DELAY_PARM);
                this._monitorDelay = Integer.valueOf(string2);
            }
            catch (Exception exception) {
                this._monitorDelay = 60;
            }
        }
        Debug.trace(this, "Status Monitoring - " + this.getMonitoringFlag());
        Debug.trace(this, "Status Monitor Delay - " + this.getMonitorDelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersionString() {
        String string = null;
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_VERSION", this.getDDB()));
            if (aSResultSet.getNextRow()) {
                string = aSResultSet.getColumnString(1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String resume() {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("RESUME_REPLICATION", this.getDDB());
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        return string;
    }

    public String suspend() {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("SUSPEND_REPLICATION", this.getDDB());
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        return string;
    }

    public String shutdown(boolean bl) {
        String string = null;
        if (bl) {
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            string = rLSQLResourceBundle.getString("REP_SHUTDOWN_IMMEDIATELY", this.getDDB());
        } else {
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            string = rLSQLResourceBundle.getString("REP_SHUTDOWN", this.getDDB());
        }
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getConfigParms() throws SQLException {
        Vector vector = new Vector();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_PARMS", this.getDDB()));
            while (aSResultSet.getNextRow()) {
                String string;
                Vector<String> vector2 = new Vector<String>();
                String string2 = aSResultSet.getColumnString(1);
                if (string2 == null || string2.length() == 0) {
                    string = ASEUtils.getString("ERR_INVALID_REP_PARM_NAME_FLD");
                    SQLException sQLException = new SQLException(string);
                    throw sQLException;
                }
                if (string2.equals(MONITORING_DELAY_PARM) || string2.equals(MONITORING_PARM)) continue;
                vector2.addElement(string2);
                vector2.addElement(aSResultSet.getColumnString(3));
                vector2.addElement(aSResultSet.getColumnString(4));
                vector2.addElement(aSResultSet.getColumnString(2));
                vector2.addElement(aSResultSet.getColumnString(5));
                vector2.addElement(aSResultSet.getColumnString(6));
                string = ASEUtils.getString("DISP_REP_NO_RESTART");
                try {
                    if (aSResultSet.getColumnInt(8) == 1) {
                        string = ASEUtils.getString("DISP_REP_RESTART_REQ");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                vector2.addElement(string);
                vector2.addElement(aSResultSet.getColumnString(9));
                vector.addElement(vector2);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigParm(String string) throws SQLException {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty configuration parameter name");
        String string2 = "";
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_PARM_VALUE", this.getDDB(), string));
            if (aSResultSet.getNextRow()) {
                string2 = aSResultSet.getColumnString(3);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigParm(String string, String string2) throws SQLException {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty server configuration parameter");
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("SET_REP_PARMS", this.getDDB(), string, string2));
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTraceFlags() throws SQLException {
        Vector vector = new Vector();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_TRACE_FLAGS", this.getDDB()));
            while (aSResultSet.getNextRow()) {
                Vector<Object> vector2 = new Vector<Object>();
                String string = aSResultSet.getColumnString(1);
                if (string == null || string.length() == 0) {
                    String string2 = ASEUtils.getString("ERR_INVALID_REP_TRACE_NAME_FLD");
                    SQLException sQLException = new SQLException(string2);
                    throw sQLException;
                }
                vector2.addElement(string);
                vector2.addElement(new Boolean(aSResultSet.getColumnString(2)));
                vector2.addElement(aSResultSet.getColumnString(3));
                vector2.addElement(aSResultSet.getColumnString(4));
                vector.addElement(vector2);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    public void setTraceFlag(String string, Boolean bl) throws SQLException {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty trace flag parameter");
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string2 = rLSQLResourceBundle.getString("SET_REP_TRACE_FLAG", this.getDDB(), string, bl.toString());
        ASConnection aSConnection = this.getConnection();
        aSConnection.executeCommand(string2);
    }
}

