/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.ColumnsCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.PartitionSO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RestoreDataSO
extends ASEBaseItemSO {
    private String _sourceDB;
    private String _sourceOwner;
    private String _sourceTable;
    private TableSO _target;
    private PartitionSO _partition;
    private String _executionSQL;
    private Vector _partitionsList = new Vector();
    private boolean _hasEncryptedColumn;
    private boolean _hasComputedColumn;
    private Vector _sourceColumns;
    private Vector _targetColumns;
    public static final int COLUMNS_NUMBER_MISMATCH = 1;
    public static final int COLUMNS_DATATYPE_MISMATCH = 2;
    public static final int COLUMNS_MATCH = 0;

    public RestoreDataSO(TableSO tableSO) {
        super(tableSO.getConnection());
        this._target = tableSO;
    }

    public RestoreDataSO(PartitionSO partitionSO) {
        super(partitionSO.getConnection());
        this._target = partitionSO.getTableSO();
        this._partition = partitionSO;
    }

    @Override
    public Object[] getAttributes() {
        return null;
    }

    public List getAvailableDatabases() throws SQLException {
        DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
        List<DatabaseSO> list = databasesCtrSO.getNormalDBList(1, "%", false, false, false, true);
        list.addAll(databasesCtrSO.getNormalDBList(1, "%", true, false, true, false));
        return list;
    }

    public List getUsers() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getRSet().open("exec sp_helpuser ");
        while (this.getRSet().getNextRow()) {
            arrayList.add(this.getRSet().getColumnString(1));
        }
        return arrayList;
    }

    public void setSourceDB(String string) {
        if (this._sourceDB != null && !this._sourceDB.equals(string)) {
            this._executionSQL = null;
        }
        this._sourceDB = string;
    }

    public String getSourceDB() {
        return this._sourceDB;
    }

    public void setSourceOwner(String string) {
        if (this._sourceOwner != null && !this._sourceOwner.equals(string)) {
            this._executionSQL = null;
        }
        this._sourceOwner = string;
    }

    public String getSourceOwner() {
        return this._sourceOwner;
    }

    public void setSourceTable(String string) {
        if (this._sourceTable != null && !this._sourceTable.equals(string)) {
            this._executionSQL = null;
        }
        this._sourceTable = string;
    }

    public String getSourceTable() {
        return this._sourceTable;
    }

    public TableSO getTargetTable() {
        return this._target;
    }

    public List getTables(String string) throws SQLException {
        this.getRSet().open(SQLs.getString("select o.name from {0}..sysobjects o, {0}..sysusers u where o.type = ''U'' and o.uid = u.uid and u.name = ''{1}'' ", this._sourceDB, string));
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.getRSet().getNextRow()) {
            arrayList.add(this.getRSet().getColumnString(1));
        }
        return arrayList;
    }

    public String getPreviewSQL() {
        String string = SQLs.getString("select * into existing table {0} from {1}", this._target.getFullyQualifiedName(), this._sourceDB + "." + this._sourceOwner + "." + this._sourceTable);
        return string;
    }

    public String getSourceRows() throws SQLException {
        String string = this._sourceDB + "." + this._sourceOwner + "." + this._sourceTable;
        if (this._partitionsList.size() > 0) {
            int n = 0;
            for (int i = 0; i < this._partitionsList.size(); ++i) {
                String string2 = (String)this._partitionsList.elementAt(i);
                this.getRSet().open(SQLs.getString("select count(*) from {0}", string + " (partition " + string2 + " )"));
                while (this.getRSet().getNextRow()) {
                    n += new Integer(this.getRSet().getColumnString(1)).intValue();
                }
            }
            return n + "";
        }
        this.getRSet().open(SQLs.getString("select count(*) from {0}", string));
        if (this.getRSet().getNextRow()) {
            return this.getRSet().getColumnString(1);
        }
        return "0";
    }

    public String getSourceSQL() {
        return SQLs.getString("select * from {0}", this._sourceDB + "." + this._sourceOwner + "." + this._sourceTable);
    }

    public void setExecutionSQL(String string) {
        this._executionSQL = string;
    }

    public String getExecutionSQL() {
        return this._executionSQL;
    }

    public void copyData() throws SQLException {
        this._target.getDatabaseSO().useDB();
        if (!this._hasEncryptedColumn || !this._hasComputedColumn) {
            this.hasEncryptedOrComputedColumn();
        }
        if (this._hasEncryptedColumn) {
            this.getConnection().executeCommand("set ciphertext on");
        }
        if (this._hasComputedColumn) {
            this.getConnection().executeCommand("set dml_on_computed on");
        }
        this.getConnection().executeCommand(this._executionSQL);
        if (this._hasEncryptedColumn) {
            this.getConnection().executeCommand("set ciphertext off");
        }
        if (this._hasComputedColumn) {
            this.getConnection().executeCommand("set dml_on_computed off");
        }
    }

    private void hasEncryptedOrComputedColumn() {
        for (int i = 0; i < this._sourceColumns.size(); ++i) {
            ColumnSO columnSO = (ColumnSO)this._sourceColumns.elementAt(i);
            ColumnSO columnSO2 = (ColumnSO)this._targetColumns.elementAt(i);
            if (columnSO.isComputedColumn()) {
                this._hasComputedColumn = true;
            }
            if (columnSO.getEncrypt()) {
                this._hasEncryptedColumn = true;
            }
            if (!this._hasComputedColumn || !this._hasEncryptedColumn) continue;
            return;
        }
    }

    public void addPartition(String string) {
        this._partitionsList.add(string);
    }

    public void clearPartitions() {
        this._partitionsList.removeAllElements();
    }

    public PartitionSO getTargetPartition() {
        return this._partition;
    }

    public int compareTablesColumns(TableSO tableSO) throws SQLException {
        this._sourceColumns = (Vector)new ColumnsCtrSO(this.getConnection(), tableSO).open(1);
        this._targetColumns = (Vector)new ColumnsCtrSO(this.getConnection(), this._target).open(1);
        if (this._sourceColumns.size() != this._targetColumns.size()) {
            return 1;
        }
        for (int i = 0; i < this._sourceColumns.size(); ++i) {
            ColumnSO columnSO = (ColumnSO)this._sourceColumns.elementAt(i);
            ColumnSO columnSO2 = (ColumnSO)this._targetColumns.elementAt(i);
            if (columnSO.isComputedColumn()) {
                this._hasComputedColumn = true;
            }
            if (columnSO.getEncrypt()) {
                this._hasEncryptedColumn = true;
            }
            if (columnSO.getDatatype().equals(columnSO2.getDatatype())) continue;
            return 2;
        }
        return 0;
    }

    public boolean isSourceTableValid() throws SQLException {
        this.getRSet().open(SQLs.getString("select 1 from {0}..sysobjects o, {0}..sysusers u where o.type = ''U'' and o.uid = u.uid and u.name = ''{1}'' and o.name = ''{2}''", this._sourceDB, this._sourceOwner, this._sourceTable));
        return this.getRSet().getNextRow();
    }

    public boolean areSourceAndTargetTableSame() {
        return this._target.getFullyQualifiedName().equals(this._sourceDB + "." + this._sourceOwner + "." + this._sourceTable);
    }
}

