/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.LoginBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.RolesCtrSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.perm.ColumnPermission;
import com.sybase.aseplugin.util.perm.SyPermission;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.security.ac.RolesMap;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;

public class RoleSO
extends ASEBaseItemSO {
    public static final String DTM_TM_ROLE = "dtm_tm_role";
    public static final String HA_ROLE = "ha_role";
    public static final String NAVIGATOR_ROLE = "navigator_role";
    public static final String OPER_ROLE = "oper_role";
    public static final String REPLICATION_ROLE = "replication_role";
    public static final String SA_ROLE = "sa_role";
    public static final String SSO_ROLE = "sso_role";
    public static final String SYBASE_TS_ROLE = "sybase_ts_role";
    public static final String MON_ROLE = "mon_role";
    public static final String WEBSERVICES_ROLE = "webservices_role";
    public static final String JS_ADMIN_ROLE = "js_admin_role";
    public static final String JS_CLIENT_ROLE = "js_client_role";
    public static final String JS_USER_ROLE = "js_user_role";
    public static final String MESSAGING_ROLE = "messaging_role";
    public static final String KEYCUSTODIAN_ROLE = "keycustodian_role";
    protected static int NAME = 0;
    private String _encryptPassword = "";
    private String _mappedAgentRoles = "";
    private String _status;
    private int SY_ROLE_PASSWORD_EXPIRED = 4;
    private Hashtable _contents = new Hashtable();
    private Hashtable _oldContents = new Hashtable();
    private Hashtable _members = new Hashtable();
    private Hashtable _beforeExclusiveValue = new Hashtable();
    private int _roleID;
    private RolesCtrSO _rolesCtrSO;
    private Vector _columnRolePermissionList = new Vector();
    private Vector _columnPublicPermissionList = new Vector();
    private Hashtable _tableHT = new Hashtable();
    private String MSG_CREATE_DB = ASEUtils.getString("MSG_CREATE_DB");
    private String MSG_ADD_DEFAULTS_WIZ_TITLE = ASEUtils.getString("MSG_ADD_DEFAULTS_WIZ_TITLE");
    private String MSG_CREATE_PROCEDURE = ASEUtils.getString("MSG_CREATE_PROCEDURE");
    private String MSG_CREATE_RULE = ASEUtils.getString("MSG_CREATE_RULE");
    private String MSG_CREATE_TABLE = ASEUtils.getString("MSG_CREATE_TABLE");
    private String MSG_CREATE_VIEW = ASEUtils.getString("MSG_CREATE_VIEW");
    private String MSG_CREATE_ENCRYPTION_KEY = ASEUtils.getString("MSG_CREATE_ENCRYPTION_KEY");
    private String MSG_ALTER_ENCRYPTION_KEY = ASEUtils.getString("MSG_ALTER_ENCRYPTION_KEY");
    private String MSG_DROP_ENCRYPTION_KEY = ASEUtils.getString("MSG_DROP_ENCRYPTION_KEY");
    private static final int PASSWORD = 1;
    private static final int ROLE_ID = 2;
    private static final int STATUS = 3;

    public RoleSO(ASConnection aSConnection, String string, RolesCtrSO rolesCtrSO) {
        super(aSConnection, string, rolesCtrSO);
        this._rolesCtrSO = rolesCtrSO;
        this.setType("RO");
    }

    public RoleSO(ASConnection aSConnection, RolesCtrSO rolesCtrSO) {
        super(aSConnection, rolesCtrSO);
        this._rolesCtrSO = rolesCtrSO;
        this.setType("RO");
    }

    public void load(String[] stringArray, RolesMap rolesMap, ServerSO serverSO) throws Exception {
        this.setPassword(stringArray[1]);
        this._roleID = new Integer(stringArray[2]);
        this._status = stringArray[3];
        if (rolesMap != null) {
            try {
                this._mappedAgentRoles = Utility.stringArrayToString(serverSO.getMBean().getUARoles(rolesMap, this.getName()).toArray(), ", ");
            }
            catch (AuthorizationException authorizationException) {
                this._mappedAgentRoles = ASEUtils.getString("MSG_NO_AUTHORIZATION_FOR_PROP");
            }
        }
    }

    @Override
    public void create() throws SQLException {
        String string = ASEUtils.decryptPassword(this._encryptPassword).equals("") ? SQLs.getString("create role {0} ", this.getName()) : SQLs.getString("create role {0} with passwd ''{1}'' ", this.getName(), ASEUtils.decryptPassword(this._encryptPassword));
        this.useMasterDB();
        this._conn.executeCommand(string);
    }

    @Override
    public void remove() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("drop role {0} ", this.getName());
        this._conn.executeCommand(string);
    }

    @Override
    public RoleSO findObject() throws SQLException {
        RolesCtrSO rolesCtrSO = new RolesCtrSO(this.getConnection(), this._rolesCtrSO.getServer());
        Object[] objectArray = new Object[]{this.getName()};
        try {
            List list = rolesCtrSO.open(1, objectArray);
            return list.isEmpty() ? null : (RoleSO)list.get(0);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            return null;
        }
    }

    public String getPassword() {
        return ASEUtils.decryptPassword(this._encryptPassword);
    }

    public void setPassword(String string) {
        this._encryptPassword = ASEUtils.encryptPassword(string);
    }

    public boolean isPwdRequired() {
        return ASEUtils.decryptPassword(this._encryptPassword).equals("MSG_YES");
    }

    public boolean isExpirePasswordApplicable() {
        boolean bl = this.getConnection().getVersion().compareTo("15.0.2") >= 0;
        return bl && this.isPwdRequired();
    }

    public void dropPassword() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("alter role {0} drop passwd ", this.getName());
        this._conn.executeCommand(string);
    }

    public void addPassword(String string) throws SQLException {
        this.useMasterDB();
        String string2 = SQLs.getString("alter role {0} add passwd ''{1}'' ", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void changePassword(String string) throws SQLException {
        if (this.isPwdRequired()) {
            this.dropPassword();
        }
        this.addPassword(string);
    }

    public Vector getLogins() throws SQLException {
        Vector vector = new Vector();
        String string = SQLs.getString("select l.name, ''{1}'' from master.dbo.syslogins l, master.dbo.sysloginroles lr where lr.srid = {0} and l.suid = lr.suid and lr.status = 1 union select l.name, ''{2}'' from master.dbo.syslogins l, master.dbo.sysloginroles lr where lr.srid = {0} and l.suid = lr.suid and lr.status = 0 order by 1 ", new Integer(this._roleID), ASEUtils.getString("MSG_YES"), ASEUtils.getString("MSG_NO"));
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1).trim(), LoginBO.LOGIN_ICON, 0));
            vector2.addElement(this.getRSet().getColumnString(2).trim());
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getHierarchy() throws SQLException {
        Vector vector = new Vector();
        String string = SQLs.getString("exec sp_displayroles {0}, expand_down ", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(this.getRSet().getColumnString(1).trim());
            vector2.addElement(this.getRSet().getColumnString(2).trim());
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getEx() throws SQLException {
        Vector vector = new Vector();
        String string = SQLs.getString("select role_name(object), ''Activation'' from master.dbo.sysattributes where class = 8 and object_info1= {0} and attribute = 1 union select role_name(object_info1), ''Activation'' from master.dbo.sysattributes where class = 8 and object = {0} and attribute = 1 union select role_name(object), ''Membership'' from master.dbo.sysattributes where class = 8 and object_info1= {0} and attribute = 0 union select role_name(object_info1), ''Membership'' from master.dbo.sysattributes where class = 8 and object = {0} and attribute = 0 order by 1 ", this._roleID);
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(this.getRSet().getColumnString(1).trim());
            vector2.addElement(this.getRSet().getColumnString(2).trim());
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public void setRoleStatus() throws SQLException {
        String[] stringArray;
        String string = SQLs.getString("select name, ''{1}'' from master.dbo.syslogins where suid not in (select suid from master.dbo.sysloginroles where srid ={0}) order by 1", new Integer(this._roleID), ASEUtils.getString("MSG_NO"));
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
            this._contents.put(stringArray[0], stringArray[1]);
        }
        this.getRSet().close();
        string = SQLs.getString("select l.name, ''{1}'' from master.dbo.syslogins l, master.dbo.sysloginroles lr where lr.srid = {0} and l.suid = lr.suid and lr.status = 1 union select l.name, ''{2}'' from master.dbo.syslogins l, master.dbo.sysloginroles lr where lr.srid = {0} and l.suid = lr.suid and lr.status = 0 order by 1 ", new Integer(this._roleID), ASEUtils.getString("MSG_YES"), ASEUtils.getString("MSG_NO"));
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
            this._contents.put(stringArray[0], stringArray[1]);
        }
        this.getRSet().close();
    }

    public String getRoleStatus(String string) {
        String string2 = (String)this._contents.get(string);
        return string2;
    }

    public void alterRoleStatus(String string, String string2) {
        this._contents.put(string, string2);
    }

    public Vector getAddItems() throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = SQLs.getString("select name, ''{1}'' from master.dbo.syslogins where suid not in (select suid from master.dbo.sysloginroles where srid ={0}) order by 1", new Integer(this._roleID), ASEUtils.getString("MSG_NO"));
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1).trim());
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getVectorToArray(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Vector<Object> vector3 = new Vector<Object>();
            vector3.addElement(new JLabel((String)vector.elementAt(i), LoginBO.LOGIN_ICON, 0));
            vector3.addElement(this.getRoleStatus((String)vector.elementAt(i)));
            vector2.addElement(vector3);
        }
        return vector2;
    }

    public void revokeRole(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = SQLs.getString("revoke role {0} from {1} ", string, string2);
        this._conn.executeCommand(string3);
    }

    public void grantRole(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = SQLs.getString("grant role {0} to {1} ", string, string2);
        this._conn.executeCommand(string3);
    }

    public void alterRole(String string, String string2) throws SQLException {
        this.useMasterDB();
        if (((String)this._contents.get(string2)).compareTo(ASEUtils.getString("MSG_YES")) == 0) {
            String string3 = SQLs.getString("exec sp_modifylogin ''{1}'', ''add default role'', ''{0}'' ", string, string2);
            this._conn.executeCommand(string3);
        } else {
            String string4 = SQLs.getString("exec sp_modifylogin ''{1}'', ''drop default role'', ''{0}'' ", string, string2);
            this._conn.executeCommand(string4);
        }
    }

    public void setDefaultRole(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = SQLs.getString("exec sp_modifylogin ''{1}'', ''add default role'', ''{0}'' ", string, string2);
        this._conn.executeCommand(string3);
    }

    public void unsetDefaultRole(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = SQLs.getString("exec sp_modifylogin ''{1}'', ''drop default role'', ''{0}'' ", string, string2);
        this._conn.executeCommand(string3);
    }

    public void setEx() throws SQLException {
        String[] stringArray;
        String string = SQLs.getString("select role_name(object), ''Activation'' from master.dbo.sysattributes where class = 8 and object_info1= {0} and attribute = 1 union select role_name(object_info1), ''Activation'' from master.dbo.sysattributes where class = 8 and object = {0} and attribute = 1 union select role_name(object), ''Membership'' from master.dbo.sysattributes where class = 8 and object_info1= {0} and attribute = 0 union select role_name(object_info1), ''Membership'' from master.dbo.sysattributes where class = 8 and object = {0} and attribute = 0 order by 1 ", this._roleID);
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
            this._members.put(stringArray[0], stringArray[1]);
            this._beforeExclusiveValue.put(stringArray[0], stringArray[1]);
        }
        this.getRSet().close();
        string = SQLs.getString("select name from master.dbo.syssrvroles where name not in (select role_name(a.object) from master.dbo.sysattributes a where a.class = 8 and a.object_info1= {0} and ( a.attribute = 0 or a.attribute = 1 )) and name not in (select role_name(a.object_info1) from master.dbo.sysattributes a where a.class = 8 and a.object = {0} and ( a.attribute = 0 or a.attribute = 1 )) and name != ''{1}'' order by 1 ", new Integer(this._roleID), this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
            this._members.put(stringArray[0], ASEUtils.getString("MSG_UNDECIDED"));
        }
        this.getRSet().close();
    }

    public Vector getExclusiveAddItems() throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = SQLs.getString("select name from master.dbo.syssrvroles where name not in (select role_name(a.object) from master.dbo.sysattributes a where a.class = 8 and a.object_info1= {0} and ( a.attribute = 0 or a.attribute = 1 )) and name not in (select role_name(a.object_info1) from master.dbo.sysattributes a where a.class = 8 and a.object = {0} and ( a.attribute = 0 or a.attribute = 1 )) and name != ''{1}'' order by 1 ", new Integer(this._roleID), this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1).trim());
        }
        this.getRSet().close();
        return vector;
    }

    public String getMemActChoice(String string) {
        String string2 = (String)this._members.get(string);
        return string2;
    }

    public void alterMemActChoice(String string, String string2) {
        this._members.put(string, string2);
    }

    public void dropExclusiveRole(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = (String)this._beforeExclusiveValue.get(string2);
        String string4 = SQLs.getString("alter role {0} drop exclusive {1} {2} ", string, string3, string2);
        this._conn.executeCommand(string4);
    }

    public void addExclusiveRole(String string, String string2) throws SQLException {
        this.useMasterDB();
        String string3 = this.getMemActChoice(string2);
        this._beforeExclusiveValue.put(string2, string3);
        String string4 = SQLs.getString("alter role {0} add exclusive {1} {2} ", string, string3, string2);
        this._conn.executeCommand(string4);
    }

    public Vector getHierarchyAddItems() throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = SQLs.getString("select name from master.dbo.syssrvroles where name not in (select role_name(a.object_info1) from master.dbo.sysattributes a, master.dbo.syssrvroles r where a.class = 8 and a.object = r.srid and r.srid = {0} and a.attribute = 2 ) and name != role_name({0}) order by 1", new Integer(this._roleID));
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1).trim());
        }
        this.getRSet().close();
        return vector;
    }

    public List getDBChoice() throws SQLException {
        List<Object> list = new Vector();
        if (this.getConnection().isCluster()) {
            SDCInstancesCtrSO sDCInstancesCtrSO = new SDCInstancesCtrSO(this.getConnection());
            List list2 = sDCInstancesCtrSO.getSDCNormalDBList(1);
            for (DatabaseSO databaseSO : list2) {
                if (!this.getConnection().getServerName().equals(databaseSO.getSDCInstanceName()) && databaseSO.getSDCInstanceName() != null) continue;
                list.add(databaseSO);
            }
        } else {
            DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
            list = databasesCtrSO.getNormalDBList(1);
        }
        return list;
    }

    public ASResultSet getCommandPermissionList(String string) throws SQLException {
        String string2 = SQLs.getString("select (select min(protecttype) from {0}.dbo.sysprotects where id=0 and uid=u.uid and action=203)", string, this.getName());
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects where id=0 and uid=u.uid and action=233)", string, this.getName());
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects where id=0 and uid=u.uid and action=222)", string, this.getName());
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects where id=0 and uid=u.uid and action=236)", string, this.getName());
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects where id=0 and uid=u.uid and action=198)", string, this.getName());
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects where id=0 and uid=u.uid and action=207)", string, this.getName());
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects where id=0 and uid=u.uid and action=(select number from master..spt_values where name = ''Create Encryption Key'' and type = ''T''))", string, this.getName());
        string2 = string2 + SQLs.getString("  from {0}.dbo.sysusers u where u.name=''{1}'' ", string, this.getName());
        this.getRSet().open(string2);
        return this.getRSet();
    }

    public void grantPermission(String string, String string2) throws SQLException {
        this.useDB(string2);
        if (string.equals(this.MSG_CREATE_DB)) {
            String string3 = SQLs.getString("grant create database to {0} ", this.getName());
            this._conn.executeCommand(string3);
            this._conn.resetCommandPermission("203");
        } else if (string.equals(this.MSG_ADD_DEFAULTS_WIZ_TITLE)) {
            String string4 = SQLs.getString("grant create default to {0} ", this.getName());
            this._conn.executeCommand(string4);
        } else if (string.equals(this.MSG_CREATE_PROCEDURE)) {
            String string5 = SQLs.getString("grant create procedure to {0} ", this.getName());
            this._conn.executeCommand(string5);
        } else if (string.equals(this.MSG_CREATE_RULE)) {
            String string6 = SQLs.getString("grant create rule to {0} ", this.getName());
            this._conn.executeCommand(string6);
        } else if (string.equals(this.MSG_CREATE_TABLE)) {
            String string7 = SQLs.getString("grant create table to {0} ", this.getName());
            this._conn.executeCommand(string7);
        } else if (string.equals(this.MSG_CREATE_VIEW)) {
            String string8 = SQLs.getString("grant create view to {0}", this.getName());
            this._conn.executeCommand(string8);
        } else if (string.equals(this.MSG_CREATE_ENCRYPTION_KEY)) {
            String string9 = SQLs.getString("grant create encryption key to {0}", this.getName());
            this._conn.executeCommand(string9);
        } else if (string.equals(this.MSG_ALTER_ENCRYPTION_KEY)) {
            String string10 = SQLs.getString("grant alter encryption key to {0}", this.getName());
            this._conn.executeCommand(string10);
        } else if (string.equals(this.MSG_DROP_ENCRYPTION_KEY)) {
            String string11 = SQLs.getString("grant drop encryption key to {0}", this.getName());
            this._conn.executeCommand(string11);
        }
    }

    public void revokePermission(String string, String string2) throws SQLException {
        this.useDB(string2);
        if (string.equals(this.MSG_CREATE_DB)) {
            String string3 = SQLs.getString("revoke create database to {0}", this.getName());
            this._conn.executeCommand(string3);
            this._conn.resetCommandPermission("203");
        } else if (string.equals(this.MSG_ADD_DEFAULTS_WIZ_TITLE)) {
            String string4 = SQLs.getString("revoke create default to {0} ", this.getName());
            this._conn.executeCommand(string4);
        } else if (string.equals(this.MSG_CREATE_PROCEDURE)) {
            String string5 = SQLs.getString("revoke create procedure to {0} ", this.getName());
            this._conn.executeCommand(string5);
        } else if (string.equals(this.MSG_CREATE_RULE)) {
            String string6 = SQLs.getString("revoke create rule to {0} ", this.getName());
            this._conn.executeCommand(string6);
        } else if (string.equals(this.MSG_CREATE_TABLE)) {
            String string7 = SQLs.getString("revoke create table to {0} ", this.getName());
            this._conn.executeCommand(string7);
        } else if (string.equals(this.MSG_CREATE_VIEW)) {
            String string8 = SQLs.getString("revoke create view to {0} ", this.getName());
            this._conn.executeCommand(string8);
        } else if (string.equals(this.MSG_CREATE_ENCRYPTION_KEY)) {
            String string9 = SQLs.getString("revoke create encryption key to {0}", this.getName());
            this._conn.executeCommand(string9);
        }
    }

    public ASResultSet getInitPermission(String string) throws SQLException {
        String string2 = SQLs.getString("select o.name, o.id, ltrim(rtrim(o.type)), o.crdate, u.name", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=193 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=195 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=196 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=197 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=224 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=151 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=(select number from master..spt_values where name = ''Alter Encryption Key'' and type = ''T'') and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=(select number from master..spt_values where name = ''Decrypt'' and type = ''T'') and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p, {1}.dbo.sysusers u where p.id=o.id and p.uid=u.uid and u.name=''{0}'' and p.action=368 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getName(), string);
        string2 = string2 + SQLs.getString("  from {1}.dbo.sysobjects o, {1}.dbo.sysusers u where o.type in (''S'',''U'',''P'',''V'',''XP'',''EK'') and u.uid=o.uid order by 1", this.getName(), string);
        this.getRSet().open(string2);
        return this.getRSet();
    }

    public void grantSelect(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant select on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeSelect(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke select on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantInsert(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant insert on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeInsert(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke insert on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantDelete(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant delete on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeDelete(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke delete on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantUpdate(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant update on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeUpdate(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke update on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantReference(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant references on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeReference(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke references on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantProcedure(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant execute on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeProcedure(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke execute on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantAlterEncryptionKey(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant alter encryption key on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeAlterEncryptionKey(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke alter encryption key on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantDecrypt(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant decrypt on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeDecrypt(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke decrypt on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void grantTransfer(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("grant transfer table on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void revokeTransfer(String string, String string2, String string3) throws SQLException {
        this.useDB(string2);
        String string4 = SQLs.getString("revoke transfer table on {2}.{0} to {1} ", string, this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void copyHashtable() {
        this._oldContents = (Hashtable)this._contents.clone();
    }

    public String getOldRoleStatus(String string) {
        String string2 = (String)this._oldContents.get(string);
        return string2;
    }

    public Vector rowByName(String string) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(new JLabel(string, LoginBO.LOGIN_ICON, 0));
        vector.addElement(this.getRoleStatus(string));
        return vector;
    }

    public Vector rowByName(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement(string2);
        return vector;
    }

    public String getMappedAgentRoles() {
        return this._mappedAgentRoles;
    }

    @Override
    public Object[] getAttributes() {
        ServerSO serverSO = this._rolesCtrSO.getServer();
        String string = ASEUtils.getString(ASEUtils.decryptPassword(this._encryptPassword));
        if (serverSO.isUAFMonitored()) {
            return new Object[]{this.getName(), string, this.getMappedAgentRoles()};
        }
        return new String[]{this.getName(), string};
    }

    public Vector getVectorSelections(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector3 = new Vector();
            vector3.addElement(vector.elementAt(i));
            vector3.addElement(this.getRoleStatus((String)vector.elementAt(i)));
            vector2.addElement(vector3);
        }
        return vector2;
    }

    public RoleSO getRole(String string) throws Exception {
        Vector vector = (Vector)this._rolesCtrSO.open(1, null);
        for (int i = 0; i < vector.size(); ++i) {
            if (!((RoleSO)vector.elementAt(i)).getName().equals(string)) continue;
            return (RoleSO)vector.elementAt(i);
        }
        return null;
    }

    public int getConfigMinPasswordLength() throws SQLException {
        return this.getConnection().getSPConfigRunValue("minimum password length");
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_ROLE_TYPE");
    }

    public Enumeration getTableList(String string) throws SQLException {
        this._tableHT.clear();
        String string2 = SQLs.getString("select o.name, o.id, u.name from {0}.dbo.sysobjects o, {0}.dbo.sysusers u where o.type in (''S'',''U'') and u.uid=o.uid order by 1", string);
        this.getRSet().open(string2);
        while (this.getRSet().getNextRow()) {
            this._tableHT.put(this.getRSet().getColumnString(3) + "." + this.getRSet().getColumnString(1), this.getRSet().getColumnString(2));
        }
        this.getRSet().close();
        return this._tableHT.keys();
    }

    public ServerBO getServerBO() {
        return ContainerViewBO.getServerBO(this.getConnection());
    }

    public DatabaseBO getDatabaseBO(String string) {
        return ContainerViewBO.getDatabaseBO(this.getServerBO(), string);
    }

    public void setPermissionLists(String string, String string2, String string3, int n) throws SQLException {
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        int n6 = 4;
        int n7 = 5;
        int n8 = 6;
        this._columnRolePermissionList = new Vector();
        this._columnPublicPermissionList = new Vector();
        Vector vector = Utility.getColsPermission(this._conn, string, string3 + "." + string2, this.getName());
        String string4 = SQLs.getString("select name from {0}.dbo.syscolumns where id=object_id(''{1}'')", string, string + "." + string3 + "." + string2);
        this.getRSet().open(string4);
        Vector<String> vector2 = new Vector<String>();
        while (this.getRSet().getNextRow()) {
            vector2.add(this.getRSet().getColumnString(1));
        }
        this.getRSet().close();
        for (int i = 0; i < vector2.size(); ++i) {
            Object object;
            String string5 = (String)vector2.elementAt(i);
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            for (int j = 0; j < vector.size(); ++j) {
                object = (Vector)vector.elementAt(j);
                String string6 = (String)((Vector)object).elementAt(n3);
                String string7 = (String)((Vector)object).elementAt(n7);
                String string8 = (String)((Vector)object).elementAt(n2);
                String string9 = (String)((Vector)object).elementAt(n4);
                boolean bl9 = Boolean.valueOf((String)((Vector)object).elementAt(n8));
                String string10 = (String)((Vector)object).elementAt(n5);
                if (!string7.equals(string5) && !string7.equalsIgnoreCase("all")) continue;
                if (string6.equals(this.getName())) {
                    if (string10.equals("select")) {
                        if (string9.equals("grant")) {
                            n9 |= 1;
                            if (bl9) {
                                n10 |= 1;
                            }
                        } else if (string9.equals("revoke")) {
                            bl = false;
                        }
                    } else if (string10.equals("update")) {
                        if (string9.equals("grant")) {
                            n9 |= 8;
                            if (bl9) {
                                n10 |= 8;
                            }
                        } else if (string9.equals("revoke")) {
                            bl2 = false;
                        }
                    } else if (string10.equals("references")) {
                        if (string9.equals("grant")) {
                            n9 |= 0x20;
                            if (bl9) {
                                n10 |= 0x20;
                            }
                        } else if (string9.equals("revoke")) {
                            bl3 = false;
                        }
                    } else if (string10.equals("decrypt")) {
                        if (string9.equals("grant")) {
                            n9 |= 0x80;
                            if (bl9) {
                                n10 |= 0x80;
                            }
                        } else if (string9.equals("revoke")) {
                            bl4 = false;
                        }
                    }
                }
                if (!string6.equals("public")) continue;
                if (string10.equals("select")) {
                    if (string9.equals("grant")) {
                        n11 |= 1;
                        if (!bl9) continue;
                        n12 |= 1;
                        continue;
                    }
                    if (!string9.equals("revoke")) continue;
                    bl5 = false;
                    continue;
                }
                if (string10.equals("update")) {
                    if (string9.equals("grant")) {
                        n11 |= 8;
                        if (!bl9) continue;
                        n12 |= 8;
                        continue;
                    }
                    if (!string9.equals("revoke")) continue;
                    bl6 = false;
                    continue;
                }
                if (string10.equals("references")) {
                    if (string9.equals("grant")) {
                        n11 |= 0x20;
                        if (!bl9) continue;
                        n12 |= 0x20;
                        continue;
                    }
                    if (!string9.equals("revoke")) continue;
                    bl7 = false;
                    continue;
                }
                if (!string10.equals("decrypt")) continue;
                if (string9.equals("grant")) {
                    n11 |= 0x80;
                    if (!bl9) continue;
                    n12 |= 0x80;
                    continue;
                }
                if (!string9.equals("revoke")) continue;
                bl8 = false;
            }
            ColumnPermission columnPermission = new ColumnPermission(n9, false, n10);
            columnPermission.setIdentity(string5, string2, string3);
            columnPermission.initializeSelectRevoke(bl);
            columnPermission.initializeUpdateRevoke(bl2);
            columnPermission.initializeReferenceRevoke(bl3);
            columnPermission.initializeDeleteRevoke(bl4);
            this._columnRolePermissionList.addElement(columnPermission);
            object = new ColumnPermission(n11, false, n12);
            ((ColumnPermission)object).setIdentity(string5, string2, string3);
            ((SyPermission)object).initializeSelectRevoke(bl5);
            ((SyPermission)object).initializeUpdateRevoke(bl6);
            ((SyPermission)object).initializeReferenceRevoke(bl7);
            ((SyPermission)object).initializeDeleteRevoke(bl8);
            this._columnPublicPermissionList.addElement(object);
        }
    }

    public Vector getColumnRolePermissionList() {
        return this._columnRolePermissionList;
    }

    public Vector getColumnPublicPermissionList() {
        return this._columnPublicPermissionList;
    }

    @Override
    public SOItemInterface duplicate() {
        RoleSO roleSO = new RoleSO(this.getConnection(), this.getName(), this._rolesCtrSO);
        roleSO._encryptPassword = this._encryptPassword;
        roleSO._roleID = this._roleID;
        roleSO._mappedAgentRoles = this._mappedAgentRoles;
        return roleSO;
    }

    public boolean isSystemObject() {
        String string = this.getName();
        boolean bl = string.equals(DTM_TM_ROLE) || string.equals(HA_ROLE) || string.equals(NAVIGATOR_ROLE) || string.equals(OPER_ROLE) || string.equals(REPLICATION_ROLE) || string.equals(SA_ROLE) || string.equals(SSO_ROLE) || string.equals(SYBASE_TS_ROLE);
        return bl;
    }

    public boolean isNativeSystemObject() {
        String string = this.getName();
        boolean bl = this.isSystemObject() || string.equals(MON_ROLE) || string.equals(WEBSERVICES_ROLE) || string.equals(JS_ADMIN_ROLE) || string.equals(JS_CLIENT_ROLE) || string.equals(JS_USER_ROLE) || string.equals(MESSAGING_ROLE);
        return bl;
    }

    @Override
    public boolean includeDelete() {
        return !this.isNativeSystemObject();
    }

    @Override
    public boolean enableDelete() {
        return this.getConnection().hasSSORole();
    }

    public boolean isPasswordExpired() {
        if (this._status.length() == 0) {
            return false;
        }
        return (Integer.parseInt(this._status) & this.SY_ROLE_PASSWORD_EXPIRED) != 0;
    }

    public void expireRolePassword() throws SQLException {
        String string = SQLs.getString("exec sp_passwordpolicy ''expire role passwords'', ''{0}''", this.getName());
        this._conn.executeCommand(string);
    }

    public boolean canGenerateDDL() {
        return this._conn.hasSARole() || this._conn.hasSSORole();
    }
}

