/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.DBSizeUtil;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AuthenticationException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.JMXException;
import com.sybase.ua.LoginModuleNotFoundException;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.util.MessageListener;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jdom.JDOMException;

public class SDCClusterSO
extends ServerSO {
    private ICluster _cluster;
    private Map _discoveredAgents = new TreeMap();
    private Map _specifiedAgents = new TreeMap();
    private Map _participatingAgents = new TreeMap();
    private Map _discoveredPorts = new HashMap();
    private boolean _isMultiBackupServersActive;
    private boolean _isXPServerActive;
    private boolean _isMonitorServerActive;
    private int _discoveredPortSizeEachInst;
    private Map _cachedAgents = new TreeMap();
    private String agentUsername;
    private String agentEncryptedPassword = "";
    private String primaryProtocol = "udp";
    private String secondaryProtocol;
    private int startingPort = 49152;
    private String clusterPlatform = "";
    private String clusterOS = "";
    private int clusterArchType = 0;
    private boolean hasSecondaryNetwork = false;
    private boolean isPrivateNetwork = true;
    public static final int UNKNOWN_ARCH_TYPE = -1;
    public static final int AMD64_ARCH_TYPE = 0;
    public static final int SUN_ARCH_TYPE = 1;
    public static final int IA64_ARCH_TYPE = 2;
    public static final int PPC64_ARCH_TYPE = 3;
    public static int DROP_CLUSTER_OPTION_QUORUM_DEVICE = 1;
    public static int DROP_CLUSTER_OPTION_DB_DEVICES = 2;
    public static int DROP_CLUSTER_OPTION_LOGS = 4;
    public static int DROP_CLUSTER_OPTION_INTERFACES_ENTRIES = 8;
    public static int DROP_CLUSTER_OPTION_SERVER_CONFIG = 16;
    public static String INVALID_DEVICE_NAME = "temp";
    private Integer dropClusterFlags = new Integer(31);
    private Map devices = new TreeMap();
    private Map deviceAvailableSizeMap = new HashMap(3);
    private boolean autoStartCluster;
    private Map _localAddressesMap = new HashMap(1);
    private Map _lltAddressesMap = new HashMap(1);
    private String _ldpaServer = null;
    private boolean _isVCSMode = false;

    public SDCClusterSO(String string) {
        super(string);
    }

    public SDCClusterSO(ASEConnectionInfo aSEConnectionInfo, ServerGroupSO serverGroupSO, SyUAFASEEntry syUAFASEEntry) {
        super(aSEConnectionInfo, serverGroupSO, syUAFASEEntry);
        try {
            this.setClusterPlatform(syUAFASEEntry.getAgentPlatform());
            this.setClusterOS(syUAFASEEntry.getAgentOperatingSystem());
        }
        catch (ClusterConfigException clusterConfigException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.releaseResources();
        super.finalize();
    }

    public void releaseResources() {
        for (Map.Entry entry : this._cachedAgents.entrySet()) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            if (!sDCClusterAgentProxy.isConnected()) continue;
            sDCClusterAgentProxy.disconnect();
        }
        this._discoveredAgents.clear();
        this._specifiedAgents.clear();
        this._cachedAgents.clear();
        this._participatingAgents.clear();
        this._localAddressesMap.clear();
        this._lltAddressesMap.clear();
        this._discoveredPorts.clear();
    }

    private String getConnectedStatus() {
        String string = ASEUtils.getString("MSG_YES");
        String string2 = ASEUtils.getString("MSG_NO");
        return this.getConnection() == null ? string2 : string;
    }

    public IServer getFirstServer() {
        IServer iServer = null;
        IServer[] iServerArray = this.getCluster().getServersArray();
        if (iServerArray != null && iServerArray.length > 0) {
            iServer = iServerArray[0];
        }
        return iServer;
    }

    public ASEConnectionInfo createClusterConnectionInfo() {
        ASEConnectionInfo aSEConnectionInfo = null;
        IServer iServer = this.getCluster().getServer(new Integer(1));
        if (iServer != null) {
            aSEConnectionInfo = new ASEConnectionInfo();
            aSEConnectionInfo.host = iServer.getNode();
            aSEConnectionInfo.port = Integer.parseInt(iServer.getQueryPort());
            aSEConnectionInfo.setUserName("sa");
            aSEConnectionInfo.setPassword("");
            aSEConnectionInfo.setRMIPort(iServer.getAgentPort());
        }
        return aSEConnectionInfo;
    }

    public ASConnection getASConnection(ASEConnectionInfo aSEConnectionInfo) throws Exception {
        ASConnection aSConnection = new ASConnection(aSEConnectionInfo, 0);
        return aSConnection;
    }

    @Override
    public ICluster getCluster() {
        return this._cluster;
    }

    public void setCluster(ICluster iCluster) {
        this._cluster = iCluster;
    }

    public void initAuxServers(ServerSO serverSO) {
        int n = 1;
        try {
            if (serverSO.getNumberOfBackupServersDefined(this.getCluster()) == 2) {
                this._isMultiBackupServersActive = serverSO.isBackupServerActive(this.getCluster());
                if (this._isMultiBackupServersActive) {
                    ++n;
                }
            }
            this._isMonitorServerActive = serverSO.isMonitorServerActive(this.getCluster())[0];
            if (this._isMonitorServerActive) {
                ++n;
            }
            this._isXPServerActive = serverSO.isXPServerActive(this.getCluster())[0];
            if (this._isXPServerActive) {
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDiscoveredPortSizeEachInst(n);
    }

    @Override
    public String getClusterName() {
        if (this._cluster == null) {
            return null;
        }
        return this._cluster.getName().trim();
    }

    public int getNumberOfInstances() {
        if (this._cluster == null) {
            return 0;
        }
        int n = this._cluster.getServersArray().length;
        return n;
    }

    public int getMaxInstances() {
        int n = 0;
        if (this._cluster != null) {
            n = this._cluster.getMaxInstances();
        }
        return n;
    }

    public void setMaxInstances(int n) {
        if (this._cluster != null) {
            this._cluster.setMaxInstances(new Integer(n));
        }
    }

    public int getNextInstanceId() {
        int n = 0;
        if (this._cluster != null) {
            n = this._cluster.getNextId();
        }
        return n;
    }

    public boolean containsServer(String string) {
        boolean bl = false;
        if (this._cluster != null) {
            bl = this._cluster.containsServer(string);
        }
        return bl;
    }

    public void addServer(int n, IServer iServer) throws ClusterConfigException {
        if (this._cluster != null) {
            this._cluster.addServer(new Integer(n), iServer);
        }
    }

    public Map getSpecifiedAgents() {
        return this._specifiedAgents;
    }

    public void addSpecifiedAgent(String string, SyUAFEntry syUAFEntry) {
        this._specifiedAgents.put(string, syUAFEntry);
    }

    public Map getDiscoveredAgents() {
        return this._discoveredAgents;
    }

    public void addDiscoveredAgent(String string, SyUAFEntry syUAFEntry) {
        this._discoveredAgents.put(string, syUAFEntry);
    }

    public void addDiscoveredAgent(String string, String string2, SyUAFEntry syUAFEntry) {
        String string3 = SDCClusterSO.getMapKey(string, string2);
        this.addDiscoveredAgent(string3, syUAFEntry);
    }

    public void clearDiscoveredAgents() {
        this._discoveredAgents.clear();
    }

    public void cacheAgent(SDCClusterAgentProxy sDCClusterAgentProxy) {
        String string = SDCClusterSO.getMapKey(sDCClusterAgentProxy.getHost(), sDCClusterAgentProxy.getPort());
        this._cachedAgents.put(string, sDCClusterAgentProxy);
    }

    public Map getCachedAgents() {
        return this._cachedAgents;
    }

    public Map getParticipatingAgents() {
        return this._participatingAgents;
    }

    public void addParticipatingAgent(String string, String string2, String string3, String string4) throws Exception {
        SyUAFEntry syUAFEntry;
        String string5 = SDCClusterSO.getMapKey(string, string2);
        SDCClusterAgentProxy sDCClusterAgentProxy = this.getCachedAgent(string, string2);
        if (sDCClusterAgentProxy == null && (syUAFEntry = (SyUAFEntry)this._discoveredAgents.get(string5)) != null) {
            sDCClusterAgentProxy = new SDCClusterAgentProxy(syUAFEntry, string3, string4);
            this.cacheAgent(sDCClusterAgentProxy);
        }
        this._participatingAgents.put(string5, sDCClusterAgentProxy);
    }

    public void removeParticipatingAgent(String string, String string2) {
        String string3 = SDCClusterSO.getMapKey(string, string2);
        if (this._participatingAgents.get(string3) != null) {
            this._participatingAgents.remove(string3);
        }
    }

    public void removeAllParticipatingAgents() {
        if (this._participatingAgents != null) {
            this._participatingAgents.clear();
        }
    }

    public boolean isMultiBackupServersActive() {
        return this._isMultiBackupServersActive;
    }

    public boolean isXPServerActive() {
        return this._isXPServerActive;
    }

    public boolean isMonitorServerActive() {
        return this._isMonitorServerActive;
    }

    public void setDiscoveredPortSizeEachInst(int n) {
        this._discoveredPortSizeEachInst = n;
    }

    public int getDiscoveredPortSizeEachInst() {
        return this._discoveredPortSizeEachInst;
    }

    public void setDiscoveredPorts(Hashtable<String, Integer[]> hashtable) {
        this._discoveredPorts = hashtable;
    }

    public void removeDiscoveredPorts(String string) {
        this._discoveredPorts.remove(string);
    }

    public void clearDiscoveredPorts() {
        this._discoveredPorts.clear();
    }

    private boolean isPortDispatched(String string, IServer iServer) {
        IServer[] iServerArray = this.getCluster().getServersArray();
        ArrayList<IServer> arrayList = new ArrayList<IServer>();
        for (IServer iServer2 : iServerArray) {
            if (!iServer2.getNode().equals(this.getNodeName(iServer))) continue;
            arrayList.add(iServer2);
        }
        arrayList.add(iServer);
        for (IServer iServer3 : arrayList) {
            String[] stringArray;
            for (String string2 : stringArray = new String[]{iServer3.getQueryPort(), iServer3.getBackupServerPort(), iServer3.getMonitorServerPort(), iServer3.getXpServerPort()}) {
                if (ASEUtils.isNullOrEmpty(string2) || !string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private Integer dispatchAnPort(IServer iServer) {
        String string = this.getNodeName(iServer);
        if (ASEUtils.isNullOrEmpty(string)) {
            return null;
        }
        Integer[] integerArray = (Integer[])this._discoveredPorts.get(string);
        if (null == integerArray) {
            return null;
        }
        for (Integer n : integerArray) {
            if (this.isPortDispatched(n.toString(), iServer)) continue;
            return n;
        }
        return null;
    }

    public void dispatchDiscoveredPorts(IServer iServer) {
        if (this._discoveredPorts.size() == 0) {
            return;
        }
        Integer n = this.dispatchAnPort(iServer);
        if (n != null) {
            iServer.setQueryPort(n.toString());
        }
        if (this.isMultiBackupServersActive() && (n = this.dispatchAnPort(iServer)) != null) {
            iServer.setBackupServerPort(n.toString());
        }
        if (this.isXPServerActive() && (n = this.dispatchAnPort(iServer)) != null) {
            iServer.setXpServerPort(n.toString());
        }
        if (this.isMonitorServerActive() && (n = this.dispatchAnPort(iServer)) != null) {
            iServer.setMonitorServerPort(n.toString());
        }
    }

    private String getNodeName(IServer iServer) {
        String string = iServer.getNode();
        if (string != null && string.indexOf(":") >= 0) {
            string = string.substring(0, string.indexOf(":")).trim();
        }
        return string;
    }

    public static String getMapKey(String string, String string2) {
        return new String(string + ":" + string2);
    }

    public static String[] parseMapKey(String string) {
        String[] stringArray = new String[]{string.substring(0, string.indexOf(":")), string.substring(string.indexOf(":") + 1)};
        return stringArray;
    }

    public String getAgentPassword() {
        return ASEUtils.decryptPassword(this.agentEncryptedPassword);
    }

    public String getAgentUsername() {
        return this.agentUsername;
    }

    public int getStartingPort() {
        return this.startingPort;
    }

    public int getNumberOfNetworks() {
        return this.hasSecondaryNetwork() ? 2 : 1;
    }

    public boolean hasSecondaryNetwork() {
        String string = this._cluster.getSecondaryInterconnect();
        return string != null && string.trim().length() != 0;
    }

    public void setHasSecondaryNetwork(boolean bl) {
        this.hasSecondaryNetwork = bl;
    }

    public boolean isPrivateNetwork() {
        return this.isPrivateNetwork;
    }

    public void setIsPrivateNetwork(boolean bl) {
        this.isPrivateNetwork = bl;
    }

    public String getPrimaryProtocol() {
        return this.primaryProtocol;
    }

    public String getSecondaryProtocol() {
        return this.secondaryProtocol;
    }

    public void setAgentUsername(String string) {
        this.agentUsername = string;
    }

    public void setAgentPassword(String string) {
        this.agentEncryptedPassword = ASEUtils.encryptPassword(string);
    }

    public void setStartingPort(int n) {
        this.startingPort = n;
    }

    public void setPrimaryProtocol(String string) {
        this.primaryProtocol = string;
    }

    public void setSecondaryProtocol(String string) {
        this.secondaryProtocol = string;
    }

    public void setAutoStartCluster(boolean bl) {
        this.autoStartCluster = bl;
    }

    public void setDeviceAvailableSizeMap(Map map) {
        this.deviceAvailableSizeMap = map;
    }

    public String getClusterPlatform() {
        return this.clusterPlatform;
    }

    public void setClusterPlatform(String string) throws ClusterConfigException {
        IServer[] iServerArray;
        if (string.equals(this.clusterPlatform)) {
            return;
        }
        this.removeAllParticipatingAgents();
        this.clusterPlatform = string;
        String string2 = "";
        this.clusterArchType = string == null || string.trim().length() == 0 ? -1 : ((string2 = this.clusterPlatform.toLowerCase()).indexOf("amd64") >= 0 ? 0 : (string2.indexOf("sparc") >= 0 || string2.indexOf("sun") >= 0 ? 1 : (string2.indexOf("ia64") >= 0 ? 2 : (string2.indexOf("ppc64") >= 0 ? 3 : -1))));
        if (this._cluster != null && (iServerArray = this._cluster.getServersArray()).length > 0) {
            for (int i = 0; i < iServerArray.length; ++i) {
                this._cluster.dropServer(iServerArray[i].getName());
            }
        }
    }

    public int getClusterArchType() {
        return this.clusterArchType;
    }

    public boolean isMatchingArchitecture(String string, String string2) {
        int n = -1;
        if (string.toLowerCase().indexOf("amd") >= 0) {
            n = 0;
        } else if (string.toLowerCase().indexOf("sparc") >= 0 || string.toLowerCase().indexOf("sun") >= 0) {
            n = 1;
        } else if (string.toLowerCase().indexOf("ia64") >= 0) {
            n = 2;
        } else if (string.toLowerCase().indexOf("ppc64") >= 0) {
            n = 3;
        }
        if (n == 0 && this.clusterOS.length() > 0) {
            return n == this.clusterArchType && this.clusterOS.equalsIgnoreCase(string2);
        }
        return n == this.clusterArchType;
    }

    public List getParticipatingNodeNames4Display() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Map.Entry entry : this._participatingAgents.entrySet()) {
            String string2 = (String)entry.getKey();
            string = string2.substring(0, string2.indexOf(":"));
            if (!hashSet.contains(string)) {
                hashSet.add(string);
            } else if (!hashSet2.contains(string)) {
                hashSet2.add(string);
            }
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        hashSet.removeAll(hashSet2);
        ArrayList arrayList2 = new ArrayList();
        if (!hashSet.isEmpty()) {
            for (String string2 : arrayList) {
                string = string2.substring(0, string2.indexOf(":"));
                if (hashSet.contains(string)) {
                    arrayList2.add(string);
                    continue;
                }
                arrayList2.add(string2);
            }
        }
        Collections.sort(arrayList2);
        return arrayList2;
    }

    public List getParticipatingNodeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : this._participatingAgents.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = SDCClusterSO.parseMapKey(string);
            arrayList.add(SDCClusterAgentUtils.getNodeAddress(stringArray[0], stringArray[1]));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public SDCClusterAgentProxy getCachedAgent(String string, String string2) {
        String string3 = SDCClusterSO.getMapKey(string, string2);
        SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)this._cachedAgents.get(string3);
        return sDCClusterAgentProxy;
    }

    public SDCClusterAgentProxy getAgent(String string, String string2, String string3, String string4) throws Exception {
        String string5 = SDCClusterSO.getMapKey(string, string2);
        SDCClusterAgentProxy sDCClusterAgentProxy = this.getCachedAgent(string, string2);
        if (sDCClusterAgentProxy != null) {
            sDCClusterAgentProxy.setUsername(string3);
            sDCClusterAgentProxy.setPassword(string4);
        } else {
            SyUAFEntry syUAFEntry = (SyUAFEntry)this._discoveredAgents.get(string5);
            sDCClusterAgentProxy = syUAFEntry != null ? new SDCClusterAgentProxy(syUAFEntry, string3, string4) : new SDCClusterAgentProxy(string, string2, string3, string4);
            this.cacheAgent(sDCClusterAgentProxy);
        }
        return sDCClusterAgentProxy;
    }

    public SDCClusterAgentProxy getAnyParticipatingAgent() throws Exception {
        Set set = this._participatingAgents.entrySet();
        Iterator iterator = set.iterator();
        Map.Entry entry = iterator.next();
        SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
        return sDCClusterAgentProxy;
    }

    public SDCClusterAgentProxy getParticipatingAgent(String string) throws Exception {
        return (SDCClusterAgentProxy)this._participatingAgents.get(string);
    }

    public SyUAFASEEntry getFirstUAFEntry() throws Exception {
        Set set;
        Iterator iterator;
        Map.Entry entry;
        SDCClusterAgentProxy sDCClusterAgentProxy;
        SyUAFASEEntry syUAFASEEntry = null;
        if (!this._participatingAgents.isEmpty() && (sDCClusterAgentProxy = (SDCClusterAgentProxy)(entry = (iterator = (set = this._participatingAgents.entrySet()).iterator()).next()).getValue()).getUafEntry() instanceof SyUAFASEEntry) {
            syUAFASEEntry = (SyUAFASEEntry)sDCClusterAgentProxy.getUafEntry();
        }
        return syUAFASEEntry;
    }

    public Map getDevices() {
        return this.devices;
    }

    public List getExtraUserDevices() {
        ArrayList<DatabaseDeviceSO> arrayList = new ArrayList<DatabaseDeviceSO>(1);
        for (Map.Entry entry : this.devices.entrySet()) {
            String string = (String)entry.getKey();
            DatabaseDeviceSO databaseDeviceSO = (DatabaseDeviceSO)entry.getValue();
            if (string.equals("master") || string.equals("sysprocsdev") || string.equals("systemdbdev")) continue;
            arrayList.add(databaseDeviceSO);
        }
        return arrayList;
    }

    public boolean isAutoStartCluster() {
        return this.autoStartCluster;
    }

    public Map getDeviceAvailableSizeMap() {
        return this.deviceAvailableSizeMap;
    }

    public Collection getDevicesAsCollection() {
        Collection collection = this.devices.values();
        return collection;
    }

    public DatabaseDeviceSO getDevice(String string) {
        return (DatabaseDeviceSO)this.devices.get(string);
    }

    public void addDevice(DatabaseDeviceSO databaseDeviceSO) {
        this.devices.put(databaseDeviceSO.getName(), databaseDeviceSO);
    }

    public boolean hasDevice(String string) {
        return this.devices.containsKey(string);
    }

    public void removeDevice(String string) {
        this.devices.remove(string);
    }

    public int getDeviceSizeAvailable(String string) {
        Integer n = (Integer)this.deviceAvailableSizeMap.get(string);
        if (n != null) {
            return n;
        }
        DatabaseDeviceSO databaseDeviceSO = this.getDevice(string = string.trim());
        if (databaseDeviceSO == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = DBSizeUtil.toIntMB(databaseDeviceSO.getDatabaseDeviceSize());
        if (string.equals("master")) {
            n2 = DBSizeUtil.toIntMB(this._cluster.getMasterDatabaseSize());
        } else if (string.equals("sysprocsdev")) {
            n2 = DBSizeUtil.toIntMB(this._cluster.getSystemProcedureDatabaseSize());
        } else if (string.equals("systemdbdev")) {
            n2 = DBSizeUtil.toIntMB(this._cluster.getSystemDatabaseSize());
        }
        int n4 = n3 - n2;
        this.deviceAvailableSizeMap.put(string, new Integer(n4));
        return n4;
    }

    public void setDeviceSizeAvailable(String string, int n) {
        this.deviceAvailableSizeMap.put(string, new Integer(n));
    }

    public static boolean validateIdentifier(String string) {
        boolean bl = true;
        if (string == null || string.length() <= 0) {
            bl = false;
        } else if (string.length() > 27) {
            bl = false;
        } else {
            String string2 = "^[a-zA-Z]\\w*";
            bl = Pattern.matches(string2, string);
        }
        return bl;
    }

    public Map getLocalAddressesMap() {
        return this._localAddressesMap;
    }

    public void addLocalAddressesMap(String string, String[] stringArray) {
        this._localAddressesMap.put(string, stringArray);
    }

    public Map getLLTAddressesMap() {
        return this._lltAddressesMap;
    }

    public void addLLTAddressesMap(String string, List list) {
        this._lltAddressesMap.put(string, list);
    }

    public void setDropClusterFlags(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n = 0;
        if (bl) {
            n += DROP_CLUSTER_OPTION_QUORUM_DEVICE;
        }
        if (bl2) {
            n += DROP_CLUSTER_OPTION_DB_DEVICES;
        }
        if (bl3) {
            n += DROP_CLUSTER_OPTION_LOGS;
        }
        if (bl4) {
            n += DROP_CLUSTER_OPTION_INTERFACES_ENTRIES;
        }
        if (bl5) {
            n += DROP_CLUSTER_OPTION_SERVER_CONFIG;
        }
        this.dropClusterFlags = new Integer(n);
    }

    public Integer getDropClusterFlags() {
        return this.dropClusterFlags;
    }

    public void dropCluster(String string, MessageListener messageListener) throws RemoteException, SQLException {
        this.dropCluster(string, this.dropClusterFlags, messageListener);
    }

    private void dropCluster(String string, Integer n, MessageListener messageListener) throws RemoteException, SQLException {
        Object[] objectArray = new Object[]{string, new Integer(n), SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), messageListener};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
        this.invokeAgentPluginMethod("dropCluster", objectArray, stringArray);
        this.remove();
    }

    public static Vector getDropClusterOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add(ASEUtils.getString("MSG_SDC_DROP_CLUSTER_OPTION_QUORUM"));
        vector.add(ASEUtils.getString("MSG_SDC_DROP_CLUSTER_OPTION_DB_DEVICES"));
        vector.add(ASEUtils.getString("MSG_SDC_DROP_CLUSTER_OPTION_LOGS"));
        vector.add(ASEUtils.getString("MSG_SDC_DROP_CLUSTER_OPTION_INTERFACES_ENTRIES"));
        vector.add(ASEUtils.getString("MSG_SDC_DROP_CLUSTER_OPTION_SERVER_CONFIG"));
        return vector;
    }

    public void dropClusterAgentPlugins() throws JDOMException, IOException, Exception {
        ArrayList arrayList = new ArrayList();
        this.unregisterClusterAgentPlugins(arrayList);
        this.deleteClusterAgentPluginHomes(arrayList);
    }

    public void unregisterClusterAgentPlugins(ArrayList arrayList) throws RemoteException {
        String string = this.getUAFInfo().getName();
        Set set = this._participatingAgents.entrySet();
        for (Map.Entry entry : set) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            if (!sDCClusterAgentProxy.isConnected()) {
                sDCClusterAgentProxy.connect();
            }
            PluginInfo pluginInfo = sDCClusterAgentProxy.getASEClustAgentPlugin(string);
            arrayList.add(pluginInfo.getPluginHome());
            sDCClusterAgentProxy.unregisterClusterAgent(pluginInfo);
            sDCClusterAgentProxy.disconnect();
        }
    }

    public void deleteClusterAgentPluginHomes(ArrayList arrayList) throws AgentConnectionException {
        Set set = this._participatingAgents.entrySet();
        boolean bl = set.size() > 1;
        for (Map.Entry entry : set) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl2;
                String string = (String)arrayList.get(i);
                if (!bl) {
                    sDCClusterAgentProxy.deleteDirectoryRecursively(string);
                    continue;
                }
                String string2 = sDCClusterAgentProxy.getAgentHome();
                boolean bl3 = bl2 = string.startsWith(string2) && string.charAt(string2.length()) == sDCClusterAgentProxy.getServerFileSeparator().charAt(0);
                if (bl2) continue;
                sDCClusterAgentProxy.deleteDirectoryRecursively(string);
            }
            sDCClusterAgentProxy.disconnect();
        }
    }

    public void cacheParticipatingClusterAgents(String string, String string2) throws IOException, JDOMException, RemoteException, Exception {
        SyUAFASEEntry syUAFASEEntry = this.getUAFInfo();
        String string3 = syUAFASEEntry.getRMIPort();
        List list = null;
        list = this.getSDCInstances();
        for (String[] stringArray : list) {
            String string4 = stringArray[2];
            SDCClusterAgentProxy sDCClusterAgentProxy = new SDCClusterAgentProxy(string4, string3, string, string2);
            this.cacheAgent(sDCClusterAgentProxy);
            this.addParticipatingAgent(string4, string3, string, string2);
        }
    }

    private void undeployClusterAgent(SDCClusterAgentProxy sDCClusterAgentProxy) throws JMXException, AuthorizationException, AuthenticationException, LoginModuleNotFoundException, AgentConnectionException {
        AgentConnection agentConnection;
        if (!sDCClusterAgentProxy.isConnected()) {
            sDCClusterAgentProxy.connect();
        }
        if ((agentConnection = sDCClusterAgentProxy.getAgentConnection()).isAgentServiceMethodAvailable("DeploymentService", "removePlugin")) {
            PluginInfo pluginInfo = sDCClusterAgentProxy.getASEClustAgentPlugin(this.getUAFInfo().getName());
            Object[] objectArray = new Object[]{pluginInfo.getId(), pluginInfo.getVersion(), new Integer(pluginInfo.getInstanceNumber())};
            String[] stringArray = new String[]{String.class.getName(), String.class.getName(), Integer.class.getName()};
            agentConnection.invokeAgentServiceMethod("DeploymentService", "removePlugin", objectArray, stringArray);
        }
    }

    public String validatePortRangeAvailability(IServer iServer, String string) throws Exception {
        Integer[] integerArray = new Integer[]{};
        int n = Integer.parseInt(iServer.getPrimaryPortStart());
        int n2 = PortUtil.getPortsRequiredPerInstancePerInterconnect((ICluster)this._cluster);
        int n3 = n + n2 - 1;
        String string2 = null;
        String string3 = this._cluster.getPrimaryInterconnect().toUpperCase();
        SDCClusterAgentProxy sDCClusterAgentProxy = this.getParticipatingAgent(string);
        integerArray = string3.equals("UDP") ? sDCClusterAgentProxy.getUDPPortsInUse(n, n3) : (string3.equals(ASEUtils.getString("SDC_CLUSTER_PROTOCOL_TCP")) ? sDCClusterAgentProxy.getTCPPortsInUse(n, n3) : sDCClusterAgentProxy.getPortsInUse(n, n3));
        if (integerArray != null && integerArray.length > 0) {
            int n4;
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = integerArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                if (n4 % 7 == 0) {
                    stringBuffer.append("\n   " + integerArray[n4].toString() + ", ");
                    continue;
                }
                stringBuffer.append(integerArray[n4].toString() + ", ");
            }
            if (n5 > 1) {
                n4 = stringBuffer.length() - 1;
                stringBuffer.delete(n4 - 1, n4);
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public int getPortsNeededPerInstance() {
        int n = 0;
        int n2 = PortUtil.getPortsRequiredPerInstancePerInterconnect((ICluster)this._cluster);
        n = this.hasSecondaryNetwork() ? n2 * 2 : n2;
        return n;
    }

    public void setInstallationMode(String string) {
        if (this._cluster != null) {
            this._cluster.setInstallationMode(string);
        }
    }

    public String getLDAPServer() {
        return this._ldpaServer;
    }

    public void setLDAPServer(String string) {
        this._ldpaServer = string;
    }

    public boolean isLDAPConfigured() {
        return this._cluster.isLDAPconfigured();
    }

    @Override
    public boolean isVCSMode() {
        return this._isVCSMode;
    }

    public void setVCSMode(boolean bl) {
        this._isVCSMode = bl;
    }

    public boolean isVCSEnabledForAllNodes(SDCClusterAgentProxy[] sDCClusterAgentProxyArray) {
        for (int i = 0; i < sDCClusterAgentProxyArray.length; ++i) {
            SDCClusterAgentProxy sDCClusterAgentProxy = sDCClusterAgentProxyArray[i];
            if (sDCClusterAgentProxy.isVCSEnabled()) continue;
            return false;
        }
        return true;
    }

    public SDCClusterAgentProxy[] getParticipatingAgentsAsArray() {
        return this.getParticipatingAgents().values().toArray(new SDCClusterAgentProxy[1]);
    }

    public void setAllAgentsInterfacePath(SDCClusterAgentProxy[] sDCClusterAgentProxyArray) throws AgentConnectionException, RemoteException {
        for (int i = 0; i < sDCClusterAgentProxyArray.length; ++i) {
            SDCClusterAgentProxy sDCClusterAgentProxy = sDCClusterAgentProxyArray[i];
            sDCClusterAgentProxy.setPluginInterfacePath();
        }
    }

    public void setAllAgentsLDAP(SDCClusterAgentProxy[] sDCClusterAgentProxyArray, String string) throws Exception {
        for (int i = 0; i < sDCClusterAgentProxyArray.length; ++i) {
            SDCClusterAgentProxy sDCClusterAgentProxy = sDCClusterAgentProxyArray[i];
            sDCClusterAgentProxy.setPluginLDAP(string);
        }
    }

    public String getLDAPServerFromAllNodes(SDCClusterAgentProxy[] sDCClusterAgentProxyArray) throws Exception {
        String string = null;
        String string2 = null;
        for (int i = 0; i < sDCClusterAgentProxyArray.length; ++i) {
            SDCClusterAgentProxy sDCClusterAgentProxy = sDCClusterAgentProxyArray[i];
            string2 = sDCClusterAgentProxy.getLDAPSever();
            if (string2 == null) {
                return "";
            }
            if (string != null && !string.equalsIgnoreCase(string2)) {
                return "";
            }
            string = string2;
        }
        return string;
    }

    public int getClusterPageSize() {
        int n = 2;
        if (null == this._cluster) {
            return n;
        }
        try {
            n = Integer.parseInt(this._cluster.getPageSize());
        }
        catch (Exception exception) {
            n = 2;
        }
        return n;
    }

    public String getClusterOS() {
        return this.clusterOS;
    }

    public void setClusterOS(String string) {
        this.clusterOS = string;
    }
}

