/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ArgList;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.security.crypto.SecureObject;
import com.sybase.ua.util.MessageListener;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SDCInstanceSO
extends ServerSO {
    private Object[] _attrs;
    private boolean _isLogical = false;
    private String _failoverGroup;
    private boolean _authenticated = false;
    private AgentConnection _agentConn;
    private static Hashtable _cachedInstanceAgentConns = new Hashtable();

    public SDCInstanceSO(ASEConnectionInfo aSEConnectionInfo, ServerGroupSO serverGroupSO, SyUAFASEEntry syUAFASEEntry) {
        super(aSEConnectionInfo, serverGroupSO, syUAFASEEntry);
    }

    public SDCInstanceSO(ASConnection aSConnection, ASEConnectionInfo aSEConnectionInfo, String string, ServerGroupSO serverGroupSO, SyUAFASEEntry syUAFASEEntry) {
        super(aSConnection, aSEConnectionInfo, string, serverGroupSO, syUAFASEEntry);
    }

    @Override
    public AgentConnection getAgentConnection() {
        if (this._agentConn != null) {
            return this._agentConn;
        }
        try {
            return super.getAgentConnection();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void setAgentConnection(AgentConnection agentConnection) {
        this._agentConn = agentConnection;
        try {
            this._agentInfo = agentConnection.getAgentInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load(Object[] objectArray) {
        if (objectArray.length == 5) {
            this._isLogical = true;
            this.setName((String)objectArray[0]);
            String string = (String)objectArray[1];
            String string2 = (String)objectArray[2];
            String string3 = (String)objectArray[3];
            this._failoverGroup = (String)objectArray[4];
            this._attrs = new Object[]{this.getName(), string, string2, string3, this._failoverGroup};
            return;
        }
        this.setName((String)objectArray[0]);
        this._attrs = new Object[]{this.getName(), objectArray[1], objectArray[2], objectArray[8], objectArray[4], "", objectArray[5], objectArray[6]};
        this._failoverGroup = "";
    }

    public void setDisplayName(String string) {
        if (this._attrs != null && this._attrs.length > 0) {
            this._attrs[0] = string;
        }
    }

    public void reloadFromDB() {
        if (this._isLogical) {
            return;
        }
        try {
            Object[] objectArray;
            String string;
            ASConnection aSConnection = this.getConnection();
            aSConnection.executeCommand("set system_view cluster");
            if (aSConnection.hasRole("sa_role")) {
                string = SQLs.getString("select name, id, state, hostname, starttime, connections_active, engines_online, net_type, address_info, spare from master.dbo.sysinstances left join master.dbo.syslisteners on master.dbo.sysinstances.id = master.dbo.syslisteners.instanceid where name = ''{0}''", this.getName());
            } else {
                objectArray = ASEUtils.getString("DISP_NOT_AVAILABLE");
                string = SQLs.getString("select name, id, state, hostname=''{0}'', starttime, connections_active, engines_online, net_type=''{1}'', address_info=''{2}'', spare from master.dbo.sysinstances left join master.dbo.syslisteners on master.dbo.sysinstances.id = master.dbo.syslisteners.instanceid where name = ''{3}''", objectArray, (String)objectArray + "       ", objectArray, this.getName());
            }
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                objectArray = new Object[11];
                objectArray[0] = this.getRSet().getColumnString(1);
                objectArray[1] = this.getRSet().getColumnString(2);
                objectArray[2] = this.getRSet().getColumnString(3);
                objectArray[3] = this.getRSet().getColumnString(4);
                objectArray[4] = this.getRSet().getColumnDate(5);
                objectArray[5] = this.getRSet().getColumnString(6);
                objectArray[6] = this.getRSet().getColumnString(7);
                objectArray[7] = this.getRSet().getColumnString(8);
                objectArray[8] = this.getRSet().getColumnString(9);
                objectArray[9] = this.getRSet().getColumnString(10);
                this.load(objectArray);
            }
            this._conn.executeCommand("set system_view instance");
            this.getRSet().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reloadLogicalFromDB(String string) {
        if (!this._isLogical) {
            return;
        }
        try {
            this.getConnection().executeCommand("set system_view cluster");
            String string2 = SQLs.getString("select InstanceName, InstanceID, State, Type, FailoverGroup from master.dbo.monLogicalClusterInstance where LCID = {0} and InstanceName = ''{1}''", string, this.getName());
            this.getRSet().open(string2);
            while (this.getRSet().getNextRow()) {
                Object[] objectArray = new Object[]{this.getRSet().getColumnString(1), this.getRSet().getColumnString(2), this.getRSet().getColumnString(3), this.getRSet().getColumnString(4), this.getRSet().getColumnString(5)};
                this.load(objectArray);
            }
            this.getConnection().executeCommand("set system_view instance");
            this.getRSet().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSDCInstancesCount(String string, List list) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        String[] stringArray = null;
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            stringArray = (String[])list.get(i);
            if (!stringArray[2].equals(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void remove() {
        String string = this.getUAFInfo().getHostName();
        String string2 = this.getUAFInfo().getPortNumber();
        List list = null;
        try {
            list = this.getSDCInstances();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dropLocalSystemTempDB();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
        }
        try {
            this.invokeAgentPluginMethod(3080);
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (AgentConnectionException agentConnectionException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), exception.toString());
        }
        if (list != null && list.size() > 0 && this.getSDCInstancesCount(string, list) < 2) {
            ServerSO.removeDiscoveredServer(string, string2);
            SDCClusterAgentProxy sDCClusterAgentProxy = new SDCClusterAgentProxy(this.getAgentConnection());
            String string3 = "";
            try {
                string3 = this.getPluginInfo().getPluginHome();
                sDCClusterAgentProxy.unregisterClusterAgent(this.getPluginInfo());
                sDCClusterAgentProxy.deleteDirectoryRecursively(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sDCClusterAgentProxy.deleteDirectoryRecursively(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.getCachedInstanceAgentConn(string, string2).disconnect();
                this.removeCachedInstanceAgentConn(string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = null;
            for (int i = 0; i < list.size(); ++i) {
                AgentConnection agentConnection;
                stringArray = (String[])list.get(i);
                if (stringArray[2].equals(string) || (agentConnection = this.getCachedInstanceAgentConn(stringArray[2], stringArray[3])) == null) continue;
                try {
                    sDCClusterAgentProxy = new SDCClusterAgentProxy(agentConnection);
                    if (!sDCClusterAgentProxy.isConnected()) {
                        sDCClusterAgentProxy.connect();
                    }
                    sDCClusterAgentProxy.deleteDirectoryRecursively(string3);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Object[] getAttributes() {
        return this._attrs;
    }

    public boolean isOnline() {
        return this.getState().trim().equalsIgnoreCase("ONLINE");
    }

    @Override
    public boolean ping() {
        return this.isOnline();
    }

    public String getId() {
        return (String)this._attrs[1];
    }

    public String getState() {
        return (String)this._attrs[2];
    }

    public String getFailoverGroup() {
        return this._failoverGroup;
    }

    public void setFailoverGroup(String string) {
        if (Integer.parseInt(string) > 0 && Integer.parseInt(string) < 32) {
            this._failoverGroup = string;
            if (this._isLogical) {
                this._attrs[4] = string;
            }
        }
    }

    public void dropLocalSystemTempDB() throws SQLException {
        String string = null;
        ArgList argList = ArgList.getDefault(1);
        argList.add(new Integer(1));
        argList.add(DatabasesCtrSO.SPT_VALUE_LOCAL_SYSTEM_TEMP_DB);
        argList.add(this.getId());
        String string2 = "select DBName = d.name, Owner = l.name, DBID = d.dbid, CreateDate = convert(datetime, d.crdate), Status = d.status, Status2 = d.status2, Status3 = isnull(d.status3,0), Size = sum(convert(int,round(v.low * (convert(float, u.size)/1048576), 0))), remDB_location = d.def_remote_loc from master.dbo.sysdatabases d, master.dbo.sysusages u, master.dbo.spt_values v, master.dbo.sysdevices e, master.dbo.syslogins l where d.suid = l.suid and (d.status3 & {2} = {2} or d.name = ''tempdb'') and d.dbid = u.dbid and e.vdevno = u.vdevno and e.status & 2 = 2 and v.type = ''E'' and v.number = 1 and d.name like ''{0}'' and d.instanceid = {3} group by d.name, l.name order by {1}";
        string2 = SQLs.getString(string2, argList.toArray());
        new SDCInstancesCtrSO(this.getConnection()).initLocalConnections();
        ASConnection aSConnection = SDCInstancesCtrSO.getLocalConnection(null, null);
        if (aSConnection == null) {
            return;
        }
        ASResultSet aSResultSet = aSConnection.getRSet();
        aSResultSet.open(string2);
        while (aSResultSet.getNextRow()) {
            string = aSResultSet.getColumnString(1);
            aSResultSet.close();
        }
        if (string != null) {
            aSConnection.executeCommand(SQLs.getString("USE {0}", "master"));
            aSConnection.executeCommand(SQLs.getString("drop database {0} ", string));
        }
    }

    @Override
    public Object invokeAgentPluginMethod(int n) throws AgentConnectionException, RemoteException, IOException {
        if (n == 3075) {
            return this.invokeAgentPluginMethod("restartInstance");
        }
        if (n == 3078) {
            String string = this.getUAFInfo().getName();
            Integer n2 = new Integer(0);
            Date date = new Date();
            Object[] objectArray = new Object[]{string, this.getName(), n2, date, null};
            String[] stringArray = new String[]{String.class.getName(), String.class.getName(), Integer.class.getName(), Date.class.getName(), MessageListener.class.getName()};
            Object object = this.invokeAgentPluginMethod("stopInstance", objectArray, stringArray);
            return object;
        }
        if (n == 3080) {
            String string = this.getUAFInfo().getName();
            String string2 = this.getName();
            try {
                this.dropInstance(string, string2);
                this.refreshClusterConfiguration();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return super.invokeAgentPluginMethod(n);
    }

    public boolean isPortAvailable(int n, String string, Integer n2) throws AgentConnectionException, RemoteException {
        Boolean bl = Boolean.TRUE;
        String string2 = "isPortAvailable";
        if (n == 1) {
            string2 = "isTCPPortAvailable";
        } else if (n == 0) {
            string2 = "isUDPPortAvailable";
        }
        Object[] objectArray = new Object[]{string, n2};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Integer"};
        bl = (Boolean)this.invokeAgentServiceMethod("EnvironmentDiscoveryService", string2, objectArray, stringArray);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public boolean arePortsAvailable(int n, String string, int n2, int n3) throws AgentConnectionException, RemoteException {
        for (int i = n2; i <= n3; ++i) {
            if (!this.isPortAvailable(n, string, new Integer(i))) continue;
            return true;
        }
        return false;
    }

    public int getStartIndex(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return n * (n2 - 1) + 1;
    }

    public int getUnusedPortIndex(ICluster iCluster, IServer iServer, int n) {
        if (n == 0) {
            return 0;
        }
        Object[] objectArray = this.getInstancesofHost(iCluster, iServer.getNode());
        return this.getStartIndex(objectArray.length, n) + this.getInstanceIndexofHost(iCluster, iServer);
    }

    public int getInstanceIndexofHost(ICluster iCluster, IServer iServer) {
        Object[] objectArray = this.getInstancesofHost(iCluster, iServer.getNode());
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((IServer)objectArray[i]).getName().equals(iServer.getName())) continue;
            return i;
        }
        return -1;
    }

    public int getInstancesCount(ICluster iCluster, String string) {
        int n = 0;
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!iServerArray[i].getNode().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public String getAgentConnectionKey(String string, String string2) {
        String string3 = this.getUserName();
        string3 = (string3 == null ? "" : string3) + "@";
        return string3 + this.getIPAndPort(string, string2);
    }

    public String getIPAndPort(String string, String string2) {
        return Utils.getIPAndPort((String)string, (String)string2);
    }

    public AgentConnection getCachedInstanceAgentConn(String string, String string2) {
        String string3 = this.getAgentConnectionKey(string, string2);
        if (!_cachedInstanceAgentConns.containsKey(string3)) {
            return null;
        }
        return (AgentConnection)_cachedInstanceAgentConns.get(string3);
    }

    public void addCachedInstanceAgentConn(String string, String string2, AgentConnection agentConnection) {
        String string3 = this.getAgentConnectionKey(string, string2);
        _cachedInstanceAgentConns.put(string3, agentConnection);
    }

    public void removeCachedInstanceAgentConn(String string, String string2) {
        String string3 = this.getAgentConnectionKey(string, string2);
        _cachedInstanceAgentConns.remove(string3);
    }

    public Object[] getInstancesofHost(ICluster iCluster, String string) {
        ArrayList<IServer> arrayList = new ArrayList<IServer>();
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!iServerArray[i].getNode().equals(string)) continue;
            arrayList.add(iServerArray[i]);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                IServer iServer = (IServer)object;
                IServer iServer2 = (IServer)object2;
                return iServer.getId().compareTo(iServer2.getId());
            }
        });
        return arrayList.toArray();
    }

    public String getDefaultPort(ICluster iCluster, IServer iServer, int n) {
        int n2 = this.getUnusedPortIndex(iCluster, iServer, n);
        return String.valueOf(5000 + this.getInstancesCount(iCluster, iServer.getNode()) + n2);
    }

    @Override
    public boolean isExpansionEnabled() throws SQLException {
        return true;
    }

    @Override
    public void shutdownNoWait() throws SQLException {
        if (this._conn.isCluster()) {
            String string = SQLs.getString("shutdown {0} with nowait", this.getName());
            try {
                this._conn.executeCommand(string, false);
            }
            catch (SQLException sQLException) {
                Support.addLogEntry(2, this._conn, this.getClass(), sQLException.getMessage(), ASEMessageText.toString(sQLException));
                SDCInstancesCtrSO.removeLocalConnection(this.getConnection().getServerServerName(), this.getName());
            }
        } else {
            this._conn.executeCommand("shutdown with nowait", false);
        }
    }

    @Override
    public void shutdown() throws SQLException {
        if (this._conn.isCluster()) {
            try {
                String string = SQLs.getString("shutdown {0}", this.getName());
                this._conn.executeCommand(string, false);
            }
            catch (SQLException sQLException) {
                Support.addLogEntry(2, null, this.getClass(), sQLException.getMessage(), ASEMessageText.toString(sQLException));
                SDCInstancesCtrSO.removeLocalConnection(this.getConnection().getServerServerName(), this.getName());
            }
        } else {
            this._conn.executeCommand("shutdown ", false);
        }
    }

    public Vector getLCWorkloadInfo() throws SQLException {
        Vector vector = new Vector();
        if (this._conn.isCluster()) {
            String string = SQLs.getString("select mlci.LogicalClusterName, mlci.State, mlci.Type, mlc.LoadProfile from master.dbo.monLogicalClusterInstance mlci, master.dbo.sysinstances si, master.dbo.monLogicalCluster mlc where si.id = {0} and convert(int, si.id) = mlci.InstanceID and mlc.Name = mlci.LogicalClusterName", this._attrs[1]);
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                String[] stringArray = this.getRSet().getColumnsAsArray();
                Vector<String> vector2 = new Vector<String>();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    vector2.add(stringArray[i]);
                }
                vector.add(vector2);
            }
            this.getRSet().close();
        }
        return vector;
    }

    @Override
    public void authenticateASE() throws RemoteException {
        if (!this._authenticated && this.isUAFMonitored()) {
            super.authenticateASE();
            this._authenticated = true;
        }
    }

    @Override
    public String[] getLogFiltered(Integer n, Integer n2, Integer n3, Date date, Date date2, String string, Vector vector, Integer n4, Integer n5, String string2) throws AgentConnectionException, RemoteException {
        this.authenticateASE();
        new SDCInstancesCtrSO(this.getConnection()).initLocalConnections();
        ASConnection aSConnection = SDCInstancesCtrSO.getLocalConnection(this.getConnection().getServerServerName(), null);
        String string3 = aSConnection.getServerServerName();
        Integer n6 = Integer.valueOf(this.getId());
        Object object = this.invokeAgentPluginMethod("getInstanceLogFiltered", new Object[]{string3, n6, n, n2, n3, date, date2, string, vector, n4, n5, string2}, new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Date.class.getName(), Date.class.getName(), String.class.getName(), Vector.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName()});
        if (object != null) {
            return (String[])object;
        }
        return null;
    }

    public Object dropInstance(String string, String string2) throws AgentConnectionException, RemoteException, ClusterConfigException, IOException {
        if (this.isLocalInstallation()) {
            ICluster iCluster = this.getCluster();
            this.setClusterAgentPort(iCluster, this.getUAFInfo().getRMIPort());
            String string3 = XMLCluster.getXMLClusterString((ICluster)iCluster);
            Object[] objectArray = new Object[]{string, string2, string3, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), null};
            String[] stringArray = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), SecureObject.class.getName(), MessageListener.class.getName()};
            return this.invokeAgentPluginMethod("dropInstance", objectArray, stringArray);
        }
        Object[] objectArray = new Object[]{string, string2, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), null};
        String[] stringArray = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), SecureObject.class.getName(), MessageListener.class.getName()};
        return this.invokeAgentPluginMethod("dropInstance", objectArray, stringArray);
    }
}

