/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SDCInstancesCtrSO
extends ASEBaseCtrSO {
    public static final int INSTANCE_NAME = 0;
    public static final int INSTANCE_ID = 1;
    public static final int INSTANCE_STARTTIME = 2;
    public static final int INSTANCE_STATE = 3;
    public static final int INSTANCE_ADDRESS = 4;
    public static final int INSTANCE_CONNECTIONS = 5;
    public static final int INSTANCE_ENGINES = 6;
    public static final int PHYSICAL_CLUSTER_INSTANCE = 1;
    public static final int LOGICAL_CLUSTER_INSTANCE = 2;
    public static final int INSTANCE_STATE_UNKNOWN = -1;
    public static final int INSTANCE_STATE_OFFLINE = 0;
    public static final int INSTANCE_STATE_OFFLINING_CONNECTED = 1;
    public static final int INSTANCE_STATE_OFFLINING_DISCONNECTED = 2;
    private static Hashtable _localConnections = new Hashtable();
    private Hashtable _sdcLocalDatabases;
    private int _instType = 1;
    private ServerSO _serverso;
    private List _sdcInstances = null;
    private String _clusterName = "";
    private static List _shutdownInstances = new Vector();

    public SDCInstancesCtrSO(ASConnection aSConnection, ServerSO serverSO) {
        super(aSConnection, serverSO);
        this._serverso = serverSO;
    }

    public SDCInstancesCtrSO(ASConnection aSConnection) {
        super(aSConnection);
    }

    public void initLocalConnections() {
        try {
            if (_localConnections.isEmpty()) {
                this.open(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addShutdownInstance(String string, String string2) {
        SDCInstancesCtrSO.removeShutdownInstance(string, string2);
        _shutdownInstances.add(SDCInstancesCtrSO.getLocalConnectionKey(string, string2));
    }

    public static void removeShutdownInstance(String string, String string2) {
        _shutdownInstances.remove(SDCInstancesCtrSO.getLocalConnectionKey(string, string2));
    }

    private static void removeShutdownInstance(String string) {
        _shutdownInstances.remove(string);
    }

    public static boolean isShuttingdown(String string, String string2) {
        return _shutdownInstances.contains(SDCInstancesCtrSO.getLocalConnectionKey(string, string2));
    }

    private void loadSDCLocalDatabases() throws SQLException {
        if (this._sdcLocalDatabases == null) {
            this._sdcLocalDatabases = new Hashtable();
        }
        String string = "select DBName = d.name, Owner = l.name, DBID = d.dbid, InstanceId = d.instanceid, InstanceName = i.name from master.dbo.sysdatabases d, master.dbo.sysinstances i, master.dbo.syslogins l where \td.suid = l.suid and d.instanceid = i.id";
        Object[] objectArray = new String[]{};
        string = SQLs.getString(string, objectArray);
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1);
            String string3 = this.getRSet().getColumnString(2);
            String string4 = this.getRSet().getColumnString(5);
            String string5 = string2 + string3;
            this._sdcLocalDatabases.put(string5, string4);
        }
    }

    public String getClusterName() {
        if (this._clusterName.equals("")) {
            try {
                this._clusterName = this._serverso.getClusterName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._clusterName;
    }

    public void refreshSDCInstances() {
        try {
            this._sdcInstances = this._serverso.getSDCInstances(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getSDCInstances() {
        if (this._sdcInstances != null) {
            return this._sdcInstances;
        }
        try {
            this._sdcInstances = this._serverso.getSDCInstances();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._sdcInstances;
    }

    public String getHostName(String string) {
        List list = this.getSDCInstances();
        for (int i = 0; list != null && i < list.size(); ++i) {
            String[] stringArray = (String[])list.get(i);
            if (!stringArray[1].equals(string)) continue;
            return stringArray[2];
        }
        return "";
    }

    public static String getLocalConnectionKey(String string, String string2) {
        return string + ":" + string2;
    }

    public static void removeLocalConnection(String string, String string2) {
        String string3 = SDCInstancesCtrSO.getLocalConnectionKey(string, string2);
        ASConnection aSConnection = (ASConnection)_localConnections.get(string3);
        try {
            if (aSConnection != null) {
                aSConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        _localConnections.remove(string3);
    }

    public static ASConnection getLocalConnection(String string, String string2) {
        if (string2 == null) {
            _localConnections.keys();
            Enumeration enumeration = _localConnections.keys();
            String string3 = (String)enumeration.nextElement();
            return (ASConnection)_localConnections.get(string3);
        }
        return (ASConnection)_localConnections.get(SDCInstancesCtrSO.getLocalConnectionKey(string, string2));
    }

    public List open(int n) throws SQLException {
        return this.open(n, null);
    }

    public String getInstanceState(String string) throws SQLException {
        ASConnection aSConnection = this.getConnection();
        String string2 = null;
        aSConnection.executeCommand("set system_view cluster");
        String string3 = SQLs.getString("select state from master..sysinstances where name = ''{0}''", string);
        this.getRSet().open(string3);
        while (this.getRSet().getNextRow()) {
            string2 = this.getRSet().getColumnString(1);
        }
        this.getRSet().close();
        aSConnection.executeCommand("set system_view instance");
        return string2;
    }

    @Override
    public List open(int n, Object[] objectArray) throws SQLException {
        ArrayList<SDCInstanceSO> arrayList = new ArrayList<SDCInstanceSO>();
        ASConnection aSConnection = this.getConnection();
        aSConnection.executeCommand("set system_view cluster");
        String string = aSConnection.hasRole("sa_role") ? "select name, id, state, hostname, starttime, connections_active, engines_online, net_type, address_info, spare from master.dbo.sysinstances left join master.dbo.syslisteners on master.dbo.sysinstances.id = master.dbo.syslisteners.instanceid " : SQLs.getString("select name, id, state, hostname=''{0}'', starttime, connections_active, engines_online, net_type=''{1}'', address_info = ''{2}'', spare from master.dbo.sysinstances left join master.dbo.syslisteners on master.dbo.sysinstances.id = master.dbo.syslisteners.instanceid ", "", "", "");
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Object object;
            Object[] objectArray2 = new Object[11];
            objectArray2[0] = this.getRSet().getColumnString(1).trim();
            objectArray2[1] = this.getRSet().getColumnString(2).trim();
            objectArray2[2] = this.getRSet().getColumnString(3).trim();
            objectArray2[3] = this.getRSet().getColumnString(4).trim();
            objectArray2[4] = this.getRSet().getColumnDate(5);
            objectArray2[5] = this.getRSet().getColumnString(6).trim();
            objectArray2[6] = this.getRSet().getColumnString(7).trim();
            objectArray2[7] = this.getRSet().getColumnString(8).trim();
            objectArray2[8] = this.getRSet().getColumnString(9).trim();
            objectArray2[9] = this.getRSet().getColumnString(10).trim();
            if (!aSConnection.hasSARole()) {
                objectArray2[3] = object = ASEUtils.getString("DISP_NOT_AVAILABLE");
                objectArray2[7] = object;
                objectArray2[8] = object;
            }
            object = null;
            SyUAFASEEntry syUAFASEEntry = null;
            String string2 = (String)objectArray2[0];
            String string3 = (String)objectArray2[3];
            if (this._serverso != null) {
                object = this._serverso.getServerGroup();
                if (this._serverso.isUAFMonitored()) {
                    syUAFASEEntry = ServerSO.getDiscoveredSDCNode(this.getClusterName(), string3.equals("") ? this.getHostName(string2) : string3);
                }
            }
            String string4 = (String)objectArray2[8];
            String string5 = (String)objectArray2[2];
            SDCInstanceSO sDCInstanceSO = null;
            String string6 = this.getConnection().getServerServerName();
            ASConnection aSConnection2 = (ASConnection)_localConnections.get(SDCInstancesCtrSO.getLocalConnectionKey(string6, string2));
            if (string5.equalsIgnoreCase("online")) {
                if (!string4.equals(ASEUtils.getString("DISP_NOT_AVAILABLE"))) {
                    if (aSConnection2 == null || aSConnection2.isDead()) {
                        aSConnection2 = this.createLocalConnection(string2, string4);
                        if (aSConnection2 != null && !aSConnection2.isDead()) {
                            _localConnections.put(SDCInstancesCtrSO.getLocalConnectionKey(string6, string2), aSConnection2);
                        } else {
                            aSConnection2 = null;
                            if (_localConnections.get(SDCInstancesCtrSO.getLocalConnectionKey(string6, string2)) != null) {
                                _localConnections.remove(SDCInstancesCtrSO.getLocalConnectionKey(string6, string2));
                            }
                        }
                    }
                    if (SDCInstancesCtrSO.isShuttingdown(this.getConnection().getServerServerName(), string2)) {
                        if (aSConnection2 == null) {
                            objectArray2[2] = "offline";
                            objectArray2[4] = "";
                            objectArray2[5] = "0";
                            objectArray2[6] = "0";
                        }
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("OPERATION_IN_PROGESS"), ASEUtils.getString("MSG_SHUTDOWN"));
                        objectArray2[0] = objectArray2[0] + "(" + aSEMessageText.toString() + ")";
                    }
                    sDCInstanceSO = new SDCInstanceSO(aSConnection2, (aSConnection2 == null ? this._conn : aSConnection2).getConnectionInfo(null, null), "", (ServerGroupSO)object, syUAFASEEntry);
                } else {
                    if (SDCInstancesCtrSO.isShuttingdown(this.getConnection().getServerServerName(), string2)) {
                        objectArray2[2] = "offline";
                        objectArray2[4] = "";
                        objectArray2[5] = "0";
                        objectArray2[6] = "0";
                    }
                    sDCInstanceSO = new SDCInstanceSO(this._conn, this._conn.getConnectionInfo(null, null), "", (ServerGroupSO)object, syUAFASEEntry);
                }
            } else {
                sDCInstanceSO = new SDCInstanceSO(null, this._conn.getConnectionInfo(null, null), "", (ServerGroupSO)object, syUAFASEEntry);
                if (_localConnections.get(SDCInstancesCtrSO.getLocalConnectionKey(string6, string2)) != null) {
                    _localConnections.remove(SDCInstancesCtrSO.getLocalConnectionKey(string6, string2));
                }
                SDCInstancesCtrSO.removeShutdownInstance(string2);
            }
            sDCInstanceSO.load(objectArray2);
            arrayList.add(sDCInstanceSO);
        }
        this._conn.executeCommand("set system_view instance");
        this.getRSet().close();
        return arrayList;
    }

    private ASConnection createLocalConnection(String string, String string2) throws SQLException {
        ASConnection aSConnection = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                ASEConnectionInfo aSEConnectionInfo = this._conn.getConnectionInfo();
                aSEConnectionInfo.setServerName(string);
                aSEConnectionInfo.host = string3;
                aSEConnectionInfo.port = Integer.valueOf(string4);
                aSConnection = new ASConnection(aSEConnectionInfo, this._conn.getId());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return aSConnection;
    }

    public static boolean isConnectionSDCLocal(String string, String string2, ASConnection aSConnection) {
        ASConnection aSConnection2 = (ASConnection)_localConnections.get(SDCInstancesCtrSO.getLocalConnectionKey(string, string2));
        return aSConnection2 != null && aSConnection2.equals(aSConnection);
    }

    public void setInstanceCtrType(int n) {
        this._instType = n;
    }

    public int getInstanceCtrType() {
        return this._instType;
    }

    public List getSDCNormalDBList(int n) throws SQLException {
        this.open(n);
        this.loadSDCLocalDatabases();
        DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
        List<DatabaseSO> list = databasesCtrSO.getNormalDBList(1);
        for (DatabaseSO databaseSO : list) {
            ASConnection aSConnection;
            String string = (String)this._sdcLocalDatabases.get(databaseSO.getName() + databaseSO.getOwner());
            if (string == null) continue;
            databaseSO.setSDCInstanceName(string);
            if (!databaseSO.getConnection().hasRole("sa_role") || (aSConnection = (ASConnection)_localConnections.get(SDCInstancesCtrSO.getLocalConnectionKey(this.getConnection().getServerServerName(), string))) == null) continue;
            databaseSO.setConnection(aSConnection);
        }
        return list;
    }
}

