/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.LoadProfileSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SDCLogicalClusterSO
extends ServerSO {
    public static final String SDC_LC_BINDING_TYPE_APPLICATION = "application";
    public static final String SDC_LC_BINDING_TYPE_LOGIN = "login";
    public static final String SDC_LC_BINDING_TYPE_ALIAS = "alias";
    public static final String SDC_LC_FAILOVER_TYPE_INSTANCE = "instance";
    public static final String SDC_LC_FAILOVER_TYPE_GROUP = "group";
    public static final String SDC_LC_STATE_FREE = "free";
    public static final String SDC_LC_STATE_INIT = "init";
    public static final String SDC_LC_STATE_ONLINE = "online";
    public static final String SDC_LC_STATE_OFFLINE = "offline";
    public static final String SDC_LC_STATE_FAILED = "failed";
    public static final String SDC_LC_STATE_TIMEDWAIT = "timedwait";
    public static final String SDC_LC_STATE_INACTIVE = "inactive";
    public static final String SDC_LC_SYSTEM_VIEW_INSTANCE = "instance";
    public static final String SDC_LC_SYSTEM_VIEW_CLUSTER = "cluster";
    public static final String SDC_LC_STARTUP_MODE_AUTOMATIC = "automatic";
    public static final String SDC_LC_STARTUP_MODE_MANUAL = "manual";
    public static final String SDC_LC_FAILOVER_MODE_INSTANCE = "instance";
    public static final String SDC_LC_FAILOVER_MODE_GROUP = "group";
    public static final String SDC_LC_FAILOVER_MODE_FAILTOANY = "with fail_to_any";
    public static final String SDC_LC_DOWNROUTING_MODE_SYSTEM = "system";
    public static final String SDC_LC_DOWNROUTING_MODE_OPEN = "open";
    public static final String SDC_LC_DOWNROUTING_MODE_DISCONNECT = "disconnect";
    public static final String SDC_LC_LOGINDISTRIBUTION_MODE_AFFINITY = "affinity";
    public static final String SDC_LC_LOGINDISTRIBUTION_MODE_ROUND_ROBIN = "round-robin";
    public static final String SDC_LC_ROLE_SYSTEM = "system";
    public static final String SDC_LC_ROLE_OPEN = "open";
    public static final String SDC_LC_INSTANCE_TYPE_BASE = "base";
    public static final String SDC_LC_INSTANCE_TYPE_FAILOVER = "failover";
    private Object[] _attrs;
    private Hashtable _instanceHash = new Hashtable();
    private List _instances = new ArrayList();
    private List _failovers = new ArrayList();
    private List _routes = new ArrayList();
    private String _failoverType = "";
    private boolean _failToAny = true;
    private boolean _hasSystemRole = false;
    private boolean _hasOpenRole = false;
    private boolean _isDuplicate = false;
    private boolean _isCreated = true;

    public SDCLogicalClusterSO(ASEConnectionInfo aSEConnectionInfo, ServerGroupSO serverGroupSO, SyUAFASEEntry syUAFASEEntry) {
        super(aSEConnectionInfo, serverGroupSO, syUAFASEEntry);
        this.load();
    }

    public SDCLogicalClusterSO(ASConnection aSConnection, ASEConnectionInfo aSEConnectionInfo, String string, ServerGroupSO serverGroupSO, SyUAFASEEntry syUAFASEEntry) {
        super(aSConnection, aSEConnectionInfo, string, serverGroupSO, syUAFASEEntry);
        if (string.length() == 0) {
            this._isCreated = false;
        }
        this._attrs = new Object[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        this.load();
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_SDC_LOGICAL_CLUSTER_TEXT");
    }

    public String getID() {
        return (String)this._attrs[1];
    }

    public void load(Object[] objectArray) {
        this.setName((String)objectArray[0]);
        this._attrs = new Object[]{this.getName(), objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], objectArray[8], objectArray[9], objectArray[10], objectArray[11], objectArray[12], objectArray[13], objectArray[14]};
        this._failoverType = ((String)objectArray[9]).indexOf("group") > -1 ? "group" : "instance";
        this._failToAny = ((String)objectArray[9]).indexOf(SDC_LC_FAILOVER_MODE_FAILTOANY) > -1;
        if (this.getRoles().indexOf("system") > -1) {
            this._hasSystemRole = true;
        }
        if (this.getRoles().indexOf("open") > -1) {
            this._hasOpenRole = true;
        }
        try {
            this.loadInstances();
            this.loadRoutes();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
        }
    }

    @Override
    public void load() {
        try {
            this.loadInstanceHash();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
        }
    }

    private void loadInstanceHash() throws SQLException {
        this._instanceHash = new Hashtable();
        ASConnection aSConnection = this.getConnection();
        aSConnection.executeCommand("set system_view cluster");
        String string = aSConnection.hasRole("sa_role") ? "select name, id, state, hostname, starttime, connections_active, engines_online, net_type, address_info, spare from master.dbo.sysinstances left join master.dbo.syslisteners on master.dbo.sysinstances.id = master.dbo.syslisteners.instanceid " : SQLs.getString("select name, id, state, hostname=''{0}'', starttime, connections_active, engines_online, net_type=''{1}'', address_info = ''{2}'', spare from master.dbo.sysinstances left join master.dbo.syslisteners on master.dbo.sysinstances.id = master.dbo.syslisteners.instanceid ", "", "", "");
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Object object;
            Object[] objectArray = new Object[11];
            objectArray[0] = this.getRSet().getColumnString(1);
            objectArray[1] = this.getRSet().getColumnString(2);
            objectArray[2] = this.getRSet().getColumnString(3);
            objectArray[3] = this.getRSet().getColumnString(4);
            objectArray[4] = this.getRSet().getColumnDate(5);
            objectArray[5] = this.getRSet().getColumnString(6);
            objectArray[6] = this.getRSet().getColumnString(7);
            objectArray[7] = this.getRSet().getColumnString(8);
            objectArray[8] = this.getRSet().getColumnString(9);
            objectArray[9] = this.getRSet().getColumnString(10);
            if (!aSConnection.hasSARole()) {
                objectArray[3] = object = ASEUtils.getString("DISP_NOT_AVAILABLE");
                objectArray[7] = object;
                objectArray[8] = object;
            }
            object = this.getServerGroup();
            SyUAFASEEntry syUAFASEEntry = this.getUAFInfo();
            SDCInstanceSO sDCInstanceSO = new SDCInstanceSO(this._conn, this.getConnectionInfo(), (String)objectArray[0], (ServerGroupSO)object, syUAFASEEntry);
            sDCInstanceSO.load(objectArray);
            this._instanceHash.put(objectArray[0], sDCInstanceSO);
        }
        this.getConnection().executeCommand("set system_view instance");
        this.getRSet().close();
    }

    public void loadInstances() throws SQLException {
        this._instances.clear();
        this._failovers.clear();
        this.getConnection().executeCommand("set system_view cluster");
        String string = SQLs.getString("select InstanceName, InstanceID, State, Type, FailoverGroup from master.dbo.monLogicalClusterInstance where LCID = {0}", this.getID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Object[] objectArray = new Object[]{this.getRSet().getColumnString(1), this.getRSet().getColumnString(2), this.getRSet().getColumnString(3), this.getRSet().getColumnString(4), this.getRSet().getColumnString(5)};
            ServerGroupSO serverGroupSO = this.getServerGroup();
            SyUAFASEEntry syUAFASEEntry = this.getUAFInfo();
            SDCInstanceSO sDCInstanceSO = new SDCInstanceSO(this._conn, this.getConnectionInfo(), "", serverGroupSO, syUAFASEEntry);
            sDCInstanceSO.load(objectArray);
            String string2 = (String)objectArray[3];
            if (string2.equalsIgnoreCase(SDC_LC_INSTANCE_TYPE_BASE)) {
                this._instances.add(sDCInstanceSO);
                continue;
            }
            if (!string2.equalsIgnoreCase(SDC_LC_INSTANCE_TYPE_FAILOVER)) continue;
            this._failovers.add(sDCInstanceSO);
        }
        this.getConnection().executeCommand("set system_view instance");
        this.getRSet().close();
    }

    private void loadRoutes() throws SQLException {
        this._routes.clear();
        this.getConnection().executeCommand("set system_view cluster");
        String string = SQLs.getString("select LogicalClusterName, LCID, RouteType, RouteKey from master.dbo.monLogicalClusterRoute where LCID = {0}", this.getID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(3);
            String string3 = this.getRSet().getColumnString(4);
            String[] stringArray = new String[]{string3, string2};
            this._routes.add(stringArray);
        }
        this.getConnection().executeCommand("set system_view instance");
        this.getRSet().close();
    }

    @Override
    public Object[] getAttributes() {
        return this._attrs;
    }

    public String getState() {
        return (String)this._attrs[2];
    }

    private String getAttributeValue(int n) {
        if (this._attrs.length > n) {
            return (String)this._attrs[n];
        }
        return null;
    }

    public String getDownRoutingMode() {
        return this.getAttributeValue(8);
    }

    public String getLoginDistributionMode() {
        return this.getAttributeValue(14);
    }

    public String getFailoverType() {
        return this._failoverType;
    }

    public String getFailoverMode() {
        return this.getAttributeValue(9);
    }

    public String getStartupMode() {
        return this.getAttributeValue(10);
    }

    public String getSystemView() {
        return this.getAttributeValue(11);
    }

    public String getRoles() {
        return this.getAttributeValue(12);
    }

    public String getLoadProfiles() {
        return this.getAttributeValue(13);
    }

    public void setDuplicate(boolean bl) {
        this._isDuplicate = bl;
    }

    public boolean isDuplicate() {
        return this._isDuplicate;
    }

    @Override
    public SOItemInterface duplicate() {
        SDCLogicalClusterSO sDCLogicalClusterSO = new SDCLogicalClusterSO(this.getConnection(), this.getConnectionInfo(), this.getName(), this.getServerGroup(), this.getUAFInfo());
        sDCLogicalClusterSO.setDuplicate(true);
        for (String[] stringArray : this._instances) {
            sDCLogicalClusterSO.addInstance(stringArray.getName());
        }
        for (String[] stringArray : this._failovers) {
            try {
                int n = Integer.parseInt(stringArray.getFailoverGroup());
                sDCLogicalClusterSO.addFailover(stringArray.getName(), n);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        sDCLogicalClusterSO.setFailoverMode(this._failoverType, this._failToAny);
        for (String[] stringArray : this._routes) {
            if (stringArray[1].equals(SDC_LC_BINDING_TYPE_APPLICATION)) {
                sDCLogicalClusterSO.addApplicationRoute(stringArray[0]);
            } else if (stringArray[1].equals(SDC_LC_BINDING_TYPE_ALIAS)) {
                sDCLogicalClusterSO.addAliasRoute(stringArray[0]);
            }
            if (!stringArray[1].equals(SDC_LC_BINDING_TYPE_LOGIN)) continue;
            sDCLogicalClusterSO.addLoginRoute(stringArray[0]);
        }
        return sDCLogicalClusterSO;
    }

    public List getInstances() {
        return this._instances;
    }

    public SDCInstanceSO getInstance(String string) {
        for (SDCInstanceSO sDCInstanceSO : this._instances) {
            if (!string.equals(sDCInstanceSO.getName())) continue;
            return sDCInstanceSO;
        }
        return null;
    }

    public SDCInstanceSO getFailover(String string) {
        for (SDCInstanceSO sDCInstanceSO : this._failovers) {
            if (!string.equals(sDCInstanceSO.getName())) continue;
            return sDCInstanceSO;
        }
        return null;
    }

    @Override
    public boolean hasValidName() {
        String string = this.getName();
        return string != null && string.length() > 0 && string.length() <= 30;
    }

    public List getAvailableInstances() {
        ArrayList<SDCInstanceSO> arrayList = new ArrayList<SDCInstanceSO>();
        Collection collection = this._instanceHash.values();
        block0: for (SDCInstanceSO sDCInstanceSO : collection) {
            boolean bl = true;
            for (SDCInstanceSO sDCInstanceSO2 : this._instances) {
                if (!sDCInstanceSO2.getName().equals(sDCInstanceSO.getName())) continue;
                bl = false;
                continue block0;
            }
            for (SDCInstanceSO sDCInstanceSO2 : this._failovers) {
                if (!sDCInstanceSO2.getName().equals(sDCInstanceSO.getName())) continue;
                bl = false;
                continue block0;
            }
            if (!bl) continue;
            arrayList.add(sDCInstanceSO);
        }
        return arrayList;
    }

    public void setSystemView(String string) {
        if (!this.getSystemView().equals(string)) {
            if (!this._isDuplicate && this._isCreated) {
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "system_view", string);
                    this._conn.executeCommand(string2);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                }
            }
            this._attrs[11] = string;
        }
    }

    public void setStartupMode(String string) {
        if (!this.getStartupMode().equals(string)) {
            if (!this._isDuplicate && this._isCreated) {
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "startup", string);
                    this._conn.executeCommand(string2);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                }
            }
            this._attrs[10] = string;
        }
    }

    public boolean setFailoverMode(String string, boolean bl) {
        String string2;
        if (!this._failoverType.equals(string) && !this._isDuplicate && this._isCreated) {
            try {
                string2 = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), SDC_LC_INSTANCE_TYPE_FAILOVER, string);
                this._conn.executeCommand(string2);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        if (this._failToAny ^ bl && !this._isDuplicate && this._isCreated) {
            try {
                string2 = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "fail_to_any", Boolean.toString(bl));
                this._conn.executeCommand(string2);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        this._failoverType = string;
        this._failToAny = bl;
        this._attrs[9] = this._failToAny ? this._failoverType + " with fail_to_any" : this._failoverType;
        return true;
    }

    public void setDownRoutingMode(String string) {
        if (!this.getDownRoutingMode().equals(string)) {
            if (!this._isDuplicate && this._isCreated) {
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "down_routing", string);
                    this._conn.executeCommand(string2);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                }
            }
            this._attrs[8] = string;
        }
    }

    public void setLoginDistributionMode(String string) {
        if (!this.getLoginDistributionMode().equals(string)) {
            if (!this._isDuplicate && this._isCreated) {
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "login_distribution", string);
                    this._conn.executeCommand(string2);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                }
            }
            this._attrs[14] = string;
        }
    }

    public void setRoleOpen() {
        if (!this._isDuplicate && this._isCreated) {
            try {
                String string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}''", this.getName(), "open");
                this._conn.executeCommand(string);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        this._hasOpenRole = true;
    }

    @Override
    public void create() throws SQLException {
        Object object2;
        String string = SQLs.getString("exec sp_cluster ''logical'', ''create'', ''{0}''", this.getName());
        this._conn.executeCommand(string);
        this._isCreated = true;
        String string2 = this.getLoadProfileName();
        if (string2 == null || string2.equals("")) {
            Iterator iterator = this.retrieveLoadProfile(null);
            this.setLoadProfileName(((LoadProfileSO)((Object)iterator)).getLPName());
        }
        this.updateLoadProfile(this.getLoadProfileName());
        for (Object object2 : this._instances) {
            string = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''instance'', ''{1}''", this.getName(), object2.getName());
            this._conn.executeCommand(string);
        }
        for (Object object2 : this._failovers) {
            string = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''failover'', ''{1}'', ''{2}''", this.getName(), object2.getName(), object2.getFailoverGroup());
            this._conn.executeCommand(string);
        }
        for (Object object2 : this._routes) {
            String string3 = object2[0];
            String string4 = object2[1];
            string = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getName(), string4, string3);
            this._conn.executeCommand(string);
        }
        string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "system_view", this.getSystemView());
        this._conn.executeCommand(string);
        string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "startup", this.getStartupMode());
        this._conn.executeCommand(string);
        if (this._failoverType == null) {
            this._failoverType = "instance";
        }
        string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), SDC_LC_INSTANCE_TYPE_FAILOVER, this.getFailoverType());
        this._conn.executeCommand(string);
        string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "fail_to_any", Boolean.toString(this.isFailToAny()));
        this._conn.executeCommand(string);
        object2 = this.getDownRoutingMode();
        if (object2 == null) {
            this._attrs[8] = "system";
        }
        string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "down_routing", this.getDownRoutingMode());
        this._conn.executeCommand(string);
        if (this.getLoginDistributionMode() == null) {
            this._attrs[14] = SDC_LC_LOGINDISTRIBUTION_MODE_AFFINITY;
        }
        string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", this.getName(), "login_distribution", this.getLoginDistributionMode());
        this._conn.executeCommand(string);
        if (this.hasOpenRole()) {
            string = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}''", this.getName(), "open");
            this._conn.executeCommand(string);
        }
    }

    @Override
    public void remove() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''cluster'' ", this.getName());
        this._conn.executeCommand(string);
    }

    public boolean addInstance(String string) {
        SDCInstanceSO sDCInstanceSO2;
        for (SDCInstanceSO sDCInstanceSO2 : this._instances) {
            if (!sDCInstanceSO2.getName().equals(string)) continue;
            return false;
        }
        sDCInstanceSO2 = (SDCInstanceSO)this._instanceHash.get(string);
        if (sDCInstanceSO2 != null) {
            this._instances.add(sDCInstanceSO2);
            if (!this.isDuplicate() && this._isCreated) {
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''instance'', ''{1}''", this.getName(), sDCInstanceSO2.getName());
                    this._conn.executeCommand(string2);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeInstance(String string) {
        SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)this._instanceHash.get(string);
        if (sDCInstanceSO != null) {
            for (int i = this._instances.size() - 1; i > -1; --i) {
                SDCInstanceSO sDCInstanceSO2 = (SDCInstanceSO)this._instances.get(i);
                if (!sDCInstanceSO2.getName().equals(sDCInstanceSO.getName()) || !sDCInstanceSO2.getHostAndPortNumber().equals(sDCInstanceSO.getHostAndPortNumber())) continue;
                this._instances.remove(i);
                if (this.isDuplicate() || !this._isCreated) continue;
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''instance'', ''{1}''", this.getName(), sDCInstanceSO.getName());
                    this._conn.executeCommand(string2);
                    continue;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public void removeAllInstances() {
        this._instances.clear();
    }

    public List getFailovers() {
        return this._failovers;
    }

    public boolean addFailover(String string, int n) {
        SDCInstanceSO sDCInstanceSO2;
        for (SDCInstanceSO sDCInstanceSO2 : this._failovers) {
            if (!sDCInstanceSO2.getName().equals(string)) continue;
            return false;
        }
        if (n < 1 || n > 31) {
            return false;
        }
        sDCInstanceSO2 = (SDCInstanceSO)this._instanceHash.get(string);
        if (sDCInstanceSO2 != null) {
            sDCInstanceSO2.setFailoverGroup(String.valueOf(n));
            this._failovers.add(sDCInstanceSO2);
            if (!this.isDuplicate() && this._isCreated) {
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''failover'', ''{1}'', ''{2}''", this.getName(), sDCInstanceSO2.getName(), String.valueOf(n));
                    this._conn.executeCommand(string2);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeFailover(String string) {
        SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)this._instanceHash.get(string);
        if (sDCInstanceSO != null) {
            for (int i = this._failovers.size() - 1; i > -1; --i) {
                SDCInstanceSO sDCInstanceSO2 = (SDCInstanceSO)this._failovers.get(i);
                if (!sDCInstanceSO2.getName().equals(sDCInstanceSO.getName()) || !sDCInstanceSO2.getHostAndPortNumber().equals(sDCInstanceSO.getHostAndPortNumber())) continue;
                this._failovers.remove(i);
                if (this.isDuplicate() || !this._isCreated) continue;
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''failover'', ''{1}''", this.getName(), sDCInstanceSO.getName());
                    this._conn.executeCommand(string2);
                    continue;
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    public void removeAllFailovers() {
        this._failovers.clear();
    }

    public boolean isFailToAny() {
        return this._failToAny;
    }

    public boolean hasSystemRole() {
        return this._hasSystemRole;
    }

    public boolean hasOpenRole() {
        return this._hasOpenRole;
    }

    public Vector getLoginNameList() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open(SQLs.getString("select suid, dbname, fullname, name, status, language, totcpu, totio, accdate, pwdate from master.dbo.syslogins where name like ''{0}''", "%"));
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[3].trim());
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getExistingRoutes(String string) throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getConnection().executeCommand("set system_view cluster");
        String string2 = SQLs.getString("select LogicalClusterName, LCID, RouteType, RouteKey from master.dbo.monLogicalClusterRoute where RouteType = ''{0}''", string);
        this.getRSet().open(string2);
        while (this.getRSet().getNextRow()) {
            String string3 = this.getRSet().getColumnString(4);
            vector.add(string3);
        }
        this.getConnection().executeCommand("set system_view instance");
        this.getRSet().close();
        return vector;
    }

    public List getRoutes() {
        return this._routes;
    }

    public void dropAllRoutes() {
        this._routes.clear();
    }

    public boolean addApplicationRoute(String string) {
        Object object2;
        for (Object object2 : this._routes) {
            if (!object2[0].equals(string) || !object2[1].equals(SDC_LC_BINDING_TYPE_APPLICATION)) continue;
            return false;
        }
        if (!this.isDuplicate() && this._isCreated) {
            try {
                object2 = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getName(), SDC_LC_BINDING_TYPE_APPLICATION, string);
                this._conn.executeCommand((String)object2);
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                return false;
            }
        }
        object2 = new String[]{string, SDC_LC_BINDING_TYPE_APPLICATION};
        this._routes.add(object2);
        return true;
    }

    public boolean dropApplicationRoute(String string) {
        for (String[] stringArray : this._routes) {
            if (!stringArray[0].equals(string) || !stringArray[1].equals(SDC_LC_BINDING_TYPE_APPLICATION)) continue;
            try {
                String string2 = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getName(), SDC_LC_BINDING_TYPE_APPLICATION, string);
                this._conn.executeCommand(string2);
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                return false;
            }
            for (int i = 0; i < this._routes.size(); ++i) {
                String[] stringArray2 = (String[])this._routes.get(i);
                if (!stringArray2[0].equals(string) || !stringArray2[1].equals(SDC_LC_BINDING_TYPE_APPLICATION)) continue;
                this._routes.remove(i);
            }
            return true;
        }
        return false;
    }

    public boolean addAliasRoute(String string) {
        Object object2;
        for (Object object2 : this._routes) {
            if (!object2[0].equals(string) || !object2[1].equals(SDC_LC_BINDING_TYPE_ALIAS)) continue;
            return false;
        }
        if (!this.isDuplicate() && this._isCreated) {
            try {
                object2 = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getName(), SDC_LC_BINDING_TYPE_ALIAS, string);
                this._conn.executeCommand((String)object2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return false;
            }
        }
        object2 = new String[]{string, SDC_LC_BINDING_TYPE_ALIAS};
        this._routes.add(object2);
        return true;
    }

    public boolean dropAliasRoute(String string) {
        for (String[] stringArray : this._routes) {
            if (!stringArray[0].equals(string) || !stringArray[1].equals(SDC_LC_BINDING_TYPE_ALIAS)) continue;
            try {
                String string2 = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getName(), SDC_LC_BINDING_TYPE_ALIAS, string);
                this._conn.executeCommand(string2);
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                return false;
            }
            for (int i = 0; i < this._routes.size(); ++i) {
                String[] stringArray2 = (String[])this._routes.get(i);
                if (!stringArray2[0].equals(string) || !stringArray2[1].equals(SDC_LC_BINDING_TYPE_ALIAS)) continue;
                this._routes.remove(i);
            }
            return true;
        }
        return false;
    }

    public boolean addLoginRoute(String string) {
        Object object2;
        for (Object object2 : this._routes) {
            if (!object2[0].equals(string) || !object2[1].equals(SDC_LC_BINDING_TYPE_LOGIN)) continue;
            return false;
        }
        if (!this.isDuplicate() && this._isCreated) {
            try {
                object2 = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getName(), SDC_LC_BINDING_TYPE_LOGIN, string);
                this._conn.executeCommand((String)object2);
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                return false;
            }
        }
        object2 = new String[]{string, SDC_LC_BINDING_TYPE_LOGIN};
        this._routes.add(object2);
        return true;
    }

    public boolean dropLoginRoute(String string) {
        for (String[] stringArray : this._routes) {
            if (!stringArray[0].equals(string) || !stringArray[1].equals(SDC_LC_BINDING_TYPE_LOGIN)) continue;
            if (!this.isDuplicate() && this._isCreated) {
                try {
                    String string2 = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getName(), SDC_LC_BINDING_TYPE_LOGIN, string);
                    this._conn.executeCommand(string2);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    Support.addLogEntry(0, this.getClass().getName(), sQLException.toString(), sQLException.getMessage());
                    return false;
                }
            }
            for (int i = 0; i < this._routes.size(); ++i) {
                String[] stringArray2 = (String[])this._routes.get(i);
                if (!stringArray2[0].equals(string) || !stringArray2[1].equals(SDC_LC_BINDING_TYPE_LOGIN)) continue;
                this._routes.remove(i);
            }
            return true;
        }
        return false;
    }

    public boolean isFailedOver() {
        String string = (String)this._attrs[7];
        int n = Integer.parseInt(string);
        return n > 0;
    }

    public void deactivate() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''deactivate'', ''{0}'', ''cluster''", this.getName());
        this._conn.executeCommand(string);
    }

    public void deactivate(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''deactivate'', ''{0}'', ''instance'', ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void failOver() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''failover'', ''{0}'', ''cluster''", this.getName());
        this._conn.executeCommand(string);
    }

    public void failOver(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''failover'', ''{0}'', ''instance'', ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void failBack() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''failback'', ''{0}'', ''cluster''", this.getName());
        this._conn.executeCommand(string);
    }

    public void failBack(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''failback'', ''{0}'', ''instance'', ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public boolean isOnline() {
        return ((String)this._attrs[2]).equals(SDC_LC_STATE_ONLINE);
    }

    public void online() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''online'', ''{0}''", this.getName());
        this._conn.executeCommand(string);
    }

    public void online(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''online'', ''{0}'', ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void offline() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''offline'', ''{0}'', ''cluster''", this.getName());
        this._conn.executeCommand(string);
    }

    public void offline(int n) throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''offline'', ''{0}'', ''cluster'', ''{1}'', ''{2}''", this.getName(), "wait", "00:" + String.valueOf(n) + ":00");
        this._conn.executeCommand(string);
    }

    public void offline(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''offline'', ''{0}'', ''instance'', ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void offline(String string, int n) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''offline'', ''{0}'', ''instance'', ''{1}'', ''{2}'', ''{3}''", this.getName(), string, "wait", "00:" + String.valueOf(n) + ":00");
        this._conn.executeCommand(string2);
    }

    public String getLoadProfileName() {
        String string = "";
        if (this._attrs != null && this._attrs.length >= 14 && this._attrs[13] != null) {
            string = (String)this._attrs[13];
        }
        return string;
    }

    public void setLoadProfileName(String string) {
        if (string != null && string.trim().length() > 0) {
            this._attrs[13] = string;
        }
    }

    public void updateLoadProfile(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''set'', ''{0}'', ''load_profile'', ''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public LoadProfileSO retrieveLoadProfile(String string) throws SQLException {
        String[] stringArray = null;
        LoadProfileSO loadProfileSO = null;
        String string2 = string == null || Integer.parseInt(string.trim()) < 1 ? "select ProfileID, Name, Description='test description', Type, ConnectionsWeight, CpuWeight, RunQueueWeight, IoLoadWeight, EngineWeight, UserWeight, LoginThreshold, DynamicThreshold, Hysteresis from master.dbo.monWorkloadProfile where ProfileID=(select min(ProfileID) from master.dbo.monWorkloadProfile)" : SQLs.getString("select mwp.ProfileID, mwp.Name, Description=''test description'', mwp.Type, mwp.ConnectionsWeight, mwp.CpuWeight, mwp.RunQueueWeight, mwp.IoLoadWeight, mwp.EngineWeight, mwp.UserWeight, mwp.LoginThreshold, mwp.DynamicThreshold, mwp.Hysteresis from master.dbo.monWorkloadProfile mwp, master.dbo.monLogicalCluster mlc where mlc.LCID={0} and mlc.LoadProfile=mwp.Name", string);
        this.getRSet().open(string2);
        while (this.getRSet().getNextRow()) {
            stringArray = this.getRSet().getColumnsAsArray();
        }
        if (stringArray != null) {
            loadProfileSO = new LoadProfileSO(this.getConnection(), stringArray);
        }
        this.getRSet().close();
        return loadProfileSO;
    }

    public void updateLCState() throws SQLException {
        if (this._attrs != null) {
            return;
        }
        this.getConnection().executeCommand("set system_view cluster");
        String string = SQLs.getString("select m.Name, m.LCID, m.State, m.ActiveConnections, m.BaseInstances, m.ActiveBaseInstances, m.FailoverInstances, m.ActiveFailoverInstances, m.DownRoutingMode, m.FailoverMode, m.StartupMode, m.SystemView, m.Roles, m.LoadProfile, LoginDistributionMode = s.name from master.dbo.monLogicalCluster m, master.dbo.spt_values s where s.type=''W2'' and s.number = 8 and (m.Attributes & s.low) = s.low and m.LCID={0}", this.getID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Object[] objectArray = new Object[]{this.getRSet().getColumnString(1), this.getRSet().getColumnString(2), this.getRSet().getColumnString(3), this.getRSet().getColumnString(4), this.getRSet().getColumnString(5), this.getRSet().getColumnString(6), this.getRSet().getColumnString(7), this.getRSet().getColumnString(8), this.getRSet().getColumnString(9), this.getRSet().getColumnString(10), this.getRSet().getColumnString(11), this.getRSet().getColumnString(12), this.getRSet().getColumnString(13), this.getRSet().getColumnString(14), this.getRSet().getColumnString(15)};
            this.load(objectArray);
        }
        this.getConnection().executeCommand("set system_view instance");
        this.getRSet().close();
    }
}

