/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEException;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.JSUtils;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.so.SchedulesCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class ScheduleSO
extends JSBaseSO
implements DateSorter {
    private int[] _days;
    private int[] _dates;

    public ScheduleSO(ASConnection aSConnection) {
        this(aSConnection, "");
    }

    public ScheduleSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
        this.init(null);
    }

    public ScheduleSO(ASConnection aSConnection, String[] stringArray) {
        super(aSConnection, "");
        this.init(stringArray);
        super.setName(this.getColumn(1));
    }

    public ScheduleSO(ASConnection aSConnection, SchedulesCtrSO schedulesCtrSO, String[] stringArray) {
        super(aSConnection, schedulesCtrSO);
        this.detailedTraceThis("Constructor For JobSO(conn, parent)");
        this.init(stringArray);
        super.setName(this.getColumn(1));
    }

    private String[] getDefaultColumns() {
        return new String[]{"0", "", "", "", "", "", "", "0", "", "", "", "", "", null, null, "false", "false", "false", "false"};
    }

    public void init(String[] stringArray) {
        this.setType("JS_SCHEDULE");
        if (stringArray == null) {
            this.setColumns(this.getDefaultColumns());
            this.setNew(true);
        } else {
            this.initColumns(stringArray);
            if (Integer.parseInt(this.getColumn(0)) != 0) {
                this.setNew(true);
            }
        }
    }

    private void initColumns(String[] stringArray) {
        this.setColumns(this.getDefaultColumns());
        for (int i = 0; i < stringArray.length && i < 18; ++i) {
            this.setColumn(i, stringArray[i]);
        }
        this.setDays(stringArray[13], true);
        this.setDates(stringArray[14], true);
        this.setRepeatable(!this.getColumn(12).equals(""));
        boolean bl = false;
        bl = this.getPropValue("shared", this.getColumn(6));
        this.setColumn(15, Boolean.toString(bl));
    }

    @Override
    public void convertListToProperties(String string) {
        this.setShared(this.checkList(string, "run_as_owner"));
    }

    @Override
    public String convertPropertiesToPropList() {
        String string = "shared=" + this.getColumn(15);
        return string;
    }

    @Override
    public void create() throws SQLException {
        this.setColumn(6, this.convertPropertiesToPropList());
        StringBuffer stringBuffer = new StringBuffer("exec sybmgmtdb..sp_createschedule ");
        this.addColumnValuetoSQL(stringBuffer, 1, this.getColumn(1));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 2, this.getColumn(2));
        stringBuffer.append(",");
        String string = this.getConnection().getVersion();
        if (string.compareTo("15") < 0) {
            stringBuffer.append("@properties=" + ScheduleSO.argString(this.getColumn(6)));
        } else {
            this.addColumnValuetoSQL(stringBuffer, 6, this.getColumn(6));
        }
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 9, this.getColumn(9));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 10, this.getColumn(10));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 11, this.getColumn(11));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 12, this.getColumn(12));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 7, this.getColumn(7));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 8, this.getColumn(8));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 13, this.getColumn(13));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 14, this.getColumn(14));
        this._conn.executeCommand(stringBuffer.toString());
    }

    public void update() throws SQLException {
        Vector vector = this.getUpdateFlags();
        if (vector == null || vector.size() == 0) {
            return;
        }
        this.setColumn(6, this.convertPropertiesToPropList());
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("exec sybmgmtdb..sp_modifyschedule @sname_id=''{0}'',", this.getID(0)));
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.addColumnValuetoSQL(stringBuffer, n, this.getColumn(n));
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this._conn.executeCommand(stringBuffer.toString());
        this.clearUpdateFlags();
    }

    public void update(int n) throws SQLException {
        if (n == 6) {
            this.setColumn(6, this.convertPropertiesToPropList());
        }
        this.update(n, this.getColumn(n));
    }

    public void update(int n, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("exec sybmgmtdb..sp_modifyschedule @sname_id=''{0}'',", this.getID(0)));
        this.addColumnValuetoSQL(stringBuffer, n, string);
        this._conn.executeCommand(stringBuffer.toString());
    }

    @Override
    public void addColumnValuetoSQL(StringBuffer stringBuffer, int n, String string) {
        if (string == null) {
            string = this.getColumn(n);
        }
        switch (n) {
            case 1: {
                stringBuffer.append("@sname=" + ScheduleSO.argString(string));
                break;
            }
            case 2: {
                stringBuffer.append("@sdesc=" + ScheduleSO.argString(string));
                break;
            }
            case 3: {
                stringBuffer.append("@sowner=" + ScheduleSO.argString(string));
                break;
            }
            case 6: {
                stringBuffer.append("@sproperties=" + ScheduleSO.argString(string));
                break;
            }
            case 7: {
                stringBuffer.append("@repeats=" + string);
                break;
            }
            case 8: {
                stringBuffer.append("@units=" + ScheduleSO.argString(string));
                break;
            }
            case 9: {
                stringBuffer.append("@startdate=" + ScheduleSO.argString(string));
                break;
            }
            case 10: {
                stringBuffer.append("@starttime=" + ScheduleSO.argString(string));
                break;
            }
            case 11: {
                stringBuffer.append("@enddate=" + ScheduleSO.argString(string));
                break;
            }
            case 12: {
                stringBuffer.append("@endtime=" + ScheduleSO.argString(string));
                break;
            }
            case 13: {
                stringBuffer.append("@days=" + this.argDaysDates(string));
                break;
            }
            case 14: {
                stringBuffer.append("@dates=" + this.argDaysDates(string));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void validateTimes(Date date, Date date2, Date date3, Date date4) throws ASEException {
        if (date4 == null) {
            return;
        }
        if (date3.getYear() > date4.getYear()) {
            throw new ASEException(ASEUtils.getString("ERR_END_DATE_LT_START_DATE"));
        }
        if (date3.getYear() == date4.getYear()) {
            if (date3.getMonth() > date4.getMonth()) {
                throw new ASEException(ASEUtils.getString("ERR_END_DATE_LT_START_DATE"));
            }
            if (date3.getMonth() == date4.getMonth()) {
                if (date3.getDate() > date4.getDate()) {
                    throw new ASEException(ASEUtils.getString("ERR_END_DATE_LT_START_DATE"));
                }
                if (date3.getDate() == date4.getDate()) {
                    if (date.getHours() > date2.getHours()) {
                        throw new ASEException(ASEUtils.getString("ERR_END_TIME_LT_START_TIME"));
                    }
                    if (date.getHours() == date2.getHours() && date.getMinutes() > date2.getMinutes()) {
                        throw new ASEException(ASEUtils.getString("ERR_END_TIME_LT_START_TIME"));
                    }
                }
            }
        }
    }

    @Override
    public void remove() throws SQLException {
        String string = this.getAllUsers() ? SQLs.getString("exec sybmgmtdb..sp_dropschedule @sname_id=''{0}'', @option=''all_users''", this.getID(0)) : SQLs.getString("exec sybmgmtdb..sp_dropschedule @sname_id=''{0}''", this.getID(0));
        this._conn.executeCommand(string);
    }

    @Override
    public boolean exists() {
        boolean bl;
        try {
            this.getRSet().open(SQLs.getString("exec sybmgmtdb..sp_listschedule @option=''sname={0}''", this.getName()));
            bl = this.getRSet().getNextRow();
            this.getRSet().close();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void copy(String string) throws SQLException {
        String string2 = SQLs.getString("exec sybmgmtdb..sp_copyschedule @sname_id=''{0}'',@newsname=''{1}''", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void setComment(String string) {
        this.setColumn(2, string);
    }

    public void setShared(boolean bl) {
        this.setColumn(15, Boolean.toString(bl));
    }

    public void setProperties(String string) {
        this.convertListToProperties(string);
    }

    public void setRepeatable(boolean bl) {
        this.setColumn(18, Boolean.toString(bl));
    }

    public void setStartTime(Date date) {
        this.setColumn(10, ScheduleSO.getASEDateTime(date));
    }

    public void setStartTime(String string) {
        Date date = null;
        try {
            date = JSBaseSO.aseDateTimeFormat.parse(string);
            this.setColumn(10, string);
        }
        catch (ParseException parseException) {
            this.setStartTime(new Date());
        }
    }

    public void setEndTime(Date date) {
        this.setColumn(12, ScheduleSO.getASEDateTime(date));
    }

    public void setEndTime(String string) {
        Date date = null;
        try {
            date = JSBaseSO.aseDateTimeFormat.parse(string);
            this.setColumn(12, string);
        }
        catch (ParseException parseException) {
            this.setEndTime(new Date());
        }
    }

    public void setStartDate(Date date) {
        this.setColumn(9, ScheduleSO.getASEDateTime(date));
    }

    public void setStartDate(String string) {
        Date date = null;
        try {
            date = JSBaseSO.aseDateFormat.parse(string);
            this.setColumn(9, string);
        }
        catch (ParseException parseException) {
            this.setColumn(9, null);
        }
    }

    public void setEndDate(Date date) {
        this.setColumn(11, ScheduleSO.getASEDateTime(date));
    }

    public void setEndDate(String string) {
        Date date = null;
        try {
            date = JSBaseSO.aseDateFormat.parse(string);
            this.setColumn(11, string);
        }
        catch (ParseException parseException) {
            this.setColumn(11, null);
        }
    }

    public void setInterval(int n) {
        this.setColumn(7, n + "");
    }

    public void setInterval(String string) {
        try {
            int n = Integer.parseInt(string);
            this.setColumn(7, string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setColumn(7, "0");
        }
    }

    public void setUnits(String string) {
        if (string.length() == 0) {
            this.setColumn(8, "");
            return;
        }
        if (string == null || string.equals("")) {
            string = "h";
        }
        char c = string.charAt(0);
        switch (c) {
            case 'd': 
            case 'h': 
            case 'm': {
                this.setColumn(8, string);
                break;
            }
            default: {
                this.setColumn(8, "");
            }
        }
    }

    public void setIsFilteringDays(boolean bl) {
        this.setColumn(16, Boolean.toString(bl));
    }

    public void setIsFilteringDays(String string) {
        this.setColumn(16, Boolean.valueOf(string).toString());
    }

    public void setIsFilteringDates(boolean bl) {
        this.setColumn(17, Boolean.toString(bl));
    }

    public void setIsFilteringDates(String string) {
        this.setColumn(17, Boolean.valueOf(string).toString());
    }

    public void setDays(String string, boolean bl) {
        this.setColumn(13, string);
        if (string == null || string.equals("0")) {
            this.setIsFilteringDays(false);
        } else {
            this.setIsFilteringDays(true);
        }
        if (bl) {
            this.setDaysArray(string, false);
        }
    }

    private void setDaysArray(String string, boolean bl) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setDays((int[])null, bl);
            return;
        }
        if (n == 0) {
            this.setDays((int[])null, bl);
            return;
        }
        this._days = JSUtils.DayBitmapToArray(n);
    }

    public void setDays(int[] nArray, boolean bl) {
        this._days = nArray;
        if (bl) {
            this.setDays(String.valueOf(ScheduleSO.DayArrayToBitmap(nArray)), false);
        }
    }

    public void setDates(String string, boolean bl) {
        this.setColumn(14, string);
        if (string == null || string.equals("0")) {
            this.setIsFilteringDates(false);
        } else {
            this.setIsFilteringDates(true);
        }
        if (bl) {
            this.setDatesArray(string, false);
        }
    }

    private void setDatesArray(String string, boolean bl) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setDates((int[])null, bl);
            return;
        }
        if (n == 0) {
            this.setDates((int[])null, bl);
            return;
        }
        this._dates = JSUtils.DateBitmapToArray(n);
    }

    public void setDates(int[] nArray, boolean bl) {
        this._dates = nArray;
        if (bl) {
            this.setDates(String.valueOf(ScheduleSO.DateArrayToBitmap(nArray)), false);
        }
    }

    public void setOwner(String string) {
        this.setColumn(3, string);
    }

    public void setCreated(Date date) {
        if (date != null) {
            this.setColumn(4, date.toString());
        } else {
            this.setColumn(4, "");
        }
    }

    public void setCreated(String string) {
        Date date = null;
        if (string == null) {
            string = "";
        }
        try {
            date = aseDateTimeFormatEN.parse(string);
            this.setColumn(4, date.toString());
        }
        catch (ParseException parseException) {
            this.setColumn(4, null);
        }
    }

    public String getComment() {
        return this.getColumn(2);
    }

    public String getDescription() {
        return this.getColumn(2);
    }

    public String getOwner() {
        return this.getColumn(3);
    }

    public boolean getShared() {
        return this.getColumn(15).equals("true");
    }

    public Date getCreated() throws ASEException {
        Date date = null;
        try {
            date = this.getAsLocalizedDate(4);
        }
        catch (ParseException parseException) {
            throw new ASEException(ASEUtils.getString("MSG_DB_CREATED_INVALID"));
        }
        return date;
    }

    public Date getStartTime() throws ASEException {
        Date date = null;
        try {
            date = this.getAsLocalizedDate(10);
        }
        catch (ParseException parseException) {
            throw new ASEException(ASEUtils.getString("MSG_DB_START_INVALID"));
        }
        return date;
    }

    public Date getEndTime() throws ASEException {
        Date date = null;
        try {
            date = this.getAsLocalizedDate(12);
        }
        catch (ParseException parseException) {
            throw new ASEException(ASEUtils.getString("MSG_DB_END_INVALID"));
        }
        return date;
    }

    public Date getStartDate() {
        return this.ColumnToDate(9);
    }

    public Date getEndDate() {
        return this.ColumnToDate(11);
    }

    public int getInterval() {
        return this.ColumnToInt(7, 0);
    }

    public String getUnits() {
        return this.getColumn(8);
    }

    public boolean isFilteringDays() {
        return this.ColumnToBoolean(16);
    }

    public boolean isFilteringDates() {
        return this.ColumnToBoolean(17);
    }

    public String getDays() {
        return this.getColumn(13);
    }

    public String getDates() {
        return this.getColumn(14);
    }

    public int getID() {
        return super.getID(0);
    }

    public int[] getDaysArray() {
        return this._days;
    }

    public int[] getDatesArray() {
        return this._dates;
    }

    private String getProperties() {
        return this.convertPropertiesToPropList();
    }

    private String getDateForDisplay(Date date) {
        return date == null ? "null" : JSBaseSO.aseDateTimeFormat.format(date);
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getColumn(0), this.getColumn(3).trim(), this.getColumn(4).trim(), this.getColumn(2)};
    }

    @Override
    public Date getDate(int n) {
        try {
            return this.getCreated();
        }
        catch (ASEException aSEException) {
            return null;
        }
    }

    public String getServerTime() throws SQLException {
        String[] stringArray;
        Vector<String[]> vector = Utility.openQuery2("select convert(datetime, getdate())", this._conn);
        String string = null;
        if (vector != null && (stringArray = vector.elementAt(0)) != null) {
            string = stringArray[0];
        }
        return string;
    }

    public boolean startTimeLessThanStopTime(Date date, Date date2) throws ASEException {
        if (date.after(date2)) {
            throw new ASEException(ASEUtils.getString("ERR_END_TIME_LT_START_TIME"));
        }
        return true;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_SCHEDULE_TYPE");
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getOwner() + "." + this.getName();
    }
}

