/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.JSBaseInterface;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.so.JobSO;
import com.sybase.aseplugin.so.ScheduleSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;

public class ScheduledJobSO
extends JSBaseSO
implements DateSorter,
JSBaseInterface {
    private static String[] EXECUTING_STATES = new String[]{"Q", "R1", "R2", "X1", "C1", "T1", "B"};
    private static String[] NON_EXECUTING_STATES = new String[]{"W", "X2", "C2", "T2", "M"};
    private JobSO _jobSO;
    private ScheduleSO _schedSO;

    public ScheduledJobSO(ASConnection aSConnection, String[] stringArray) {
        super(aSConnection, stringArray[11] + ":" + stringArray[12]);
        this.init(stringArray);
    }

    public ScheduledJobSO(ASConnection aSConnection) {
        super(aSConnection, "");
        this.init(null);
        this._schedSO = new ScheduleSO(aSConnection, "");
        this._jobSO = new JobSO(aSConnection, "");
    }

    public ScheduledJobSO(ASConnection aSConnection, String string, JobSO jobSO) {
        super(aSConnection, string);
        this.init(null);
        this._schedSO = new ScheduleSO(aSConnection, string);
        this._jobSO = jobSO;
    }

    private String[] getDefaultColumns() {
        return new String[]{"0", "0", "0", "true", "0", "", "", "", "JDEF_TIMEOUT_VALUE_DEFAULT", "", "", "", "", "", "", "", "", "", "false", "false", "false", "false"};
    }

    public void init(String[] stringArray) {
        this.setType("JS_SJ");
        if (stringArray == null) {
            this.setColumns(this.getDefaultColumns());
        } else {
            String[] stringArray2 = this.addPropColumns(stringArray);
            this.setColumns(stringArray2);
            this.setID(stringArray[0]);
            this.setJobID(stringArray[1]);
            this.setScheduleID(stringArray[2]);
            this.setEnabled(stringArray[3]);
            this.setOwner(stringArray[5]);
            this.setCreated(stringArray[6]);
            this.setServer(stringArray[7]);
            this.setTimeout(stringArray[8]);
            this.setDefaultTimeout(stringArray[10]);
            this.setJobName(stringArray[11]);
            this.setScheduleName(stringArray[12]);
            this.setNextExec(stringArray[13]);
            this.setLastExec(stringArray[14]);
            this.setState(stringArray[15]);
            this.setLastExecCode(stringArray[16]);
            this.setLastExecError(stringArray[17]);
        }
    }

    private String[] addPropColumns(String[] stringArray) {
        String[] stringArray2 = this.getDefaultColumns();
        for (int i = 0; i < stringArray.length && i < 22; ++i) {
            stringArray2[i] = stringArray[i];
        }
        if (this.getPropValue("no_output_log", stringArray2[4])) {
            stringArray2[18] = "true";
        }
        if (this.getPropValue("shared_run", stringArray2[4])) {
            stringArray2[19] = "true";
        }
        if (this.getPropValue("disable_on_failure", stringArray2[4])) {
            stringArray2[20] = "true";
        }
        if (this.getPropValue("delete_on_completion", stringArray2[4])) {
            stringArray2[21] = "true";
        }
        return stringArray2;
    }

    @Override
    public void convertListToProperties(String string) {
        this.setOutputLogging(this.checkList(string, "no_output_log"));
        this.setShared(this.checkList(string, "shared_run"));
        this.setDisableOnFailure(this.checkList(string, "disable_on_failure"));
        this.setDeleteOnCompletion(this.checkList(string, "delete_on_completion"));
    }

    @Override
    public String convertPropertiesToPropList() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("no_output_log=" + this.getColumn(18) + ",");
        stringBuffer.append("shared_run=" + this.getColumn(19) + ",");
        stringBuffer.append("disable_on_failure=" + this.getColumn(20) + ",");
        stringBuffer.append("delete_on_completion=" + this.getColumn(21));
        return stringBuffer.toString();
    }

    @Override
    public void copy(String string) throws SQLException {
    }

    public void pre_15_create() throws SQLException {
        if (this.ColumnToInt(1, 0) <= 0) {
            this._jobSO.create();
            this.setColumn(11, this._jobSO.getColumn(1));
        } else {
            this.setColumn(1, this._jobSO.getColumn(0));
        }
        if (this.ColumnToInt(2, 0) <= 0) {
            this._schedSO.create();
            this.setColumn(12, this._schedSO.getColumn(1));
        } else {
            this.setColumn(2, this._schedSO.getColumn(0));
        }
        ASResultSet aSResultSet = this.getRSet();
        aSResultSet.open(SQLs.getString("declare @sjid int exec @sjid = sybmgmtdb..sp_bindscheduledjob @jname_id=''{0}'', @sname_id=''{1}'' select id=@sjid", this.getJobName(), this.getScheduleName()));
        if (!aSResultSet.getNextRow()) {
            aSResultSet.close();
            throw new SQLException(ASEUtils.getString("ERR_NO_SCHED_ID"));
        }
        this.setID(0, aSResultSet.getColumnInt(1));
        aSResultSet.close();
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("exec sybmgmtdb..sp_modifyscheduledjob @sjname_id=''{0}'',", this.getID()));
        this.addColumnValuetoSQL(stringBuffer, 7, this.getColumn(7));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 8, this.getColumn(8));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 4, this.getColumn(4));
        this._conn.executeCommand(stringBuffer.toString());
    }

    @Override
    public void create() throws SQLException {
        this.setColumn(4, this.convertPropertiesToPropList());
        String string = this.getConnection().getVersion();
        if (string.compareTo("15") < 0) {
            this.pre_15_create();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("exec sybmgmtdb..sp_createscheduledjob ");
        if (this.ColumnToInt(1, 0) <= 0) {
            this._jobSO.create();
            this.setColumn(11, this._jobSO.getColumn(1));
            this.addColumnValuetoSQL(stringBuffer, 11, this.getColumn(11));
            stringBuffer.append(",");
        } else {
            this.setColumn(1, this._jobSO.getColumn(0));
            this.addColumnValuetoSQL(stringBuffer, 1, this.getColumn(1));
            stringBuffer.append(",");
        }
        if (this.ColumnToInt(2, 0) <= 0) {
            this._schedSO.create();
            this.setColumn(12, this._schedSO.getColumn(1));
            this.addColumnValuetoSQL(stringBuffer, 12, this.getColumn(12));
            stringBuffer.append(",");
        } else {
            this.setColumn(2, this._schedSO.getColumn(0));
            this.addColumnValuetoSQL(stringBuffer, 2, this.getColumn(2));
            stringBuffer.append(",");
        }
        this.addColumnValuetoSQL(stringBuffer, 7, this.getColumn(7));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 8, this.getColumn(8));
        stringBuffer.append(",");
        this.addColumnValuetoSQL(stringBuffer, 4, this.getColumn(4));
        this._conn.executeCommand(stringBuffer.toString());
    }

    public void update(int n) throws SQLException {
        if (n == 4) {
            this.setColumn(4, this.convertPropertiesToPropList());
        }
        this.update(n, this.getColumn(n));
    }

    public void update(int n, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("exec sybmgmtdb..sp_modifyscheduledjob @sjname_id=''{0}'',", this.getID()));
        this.addColumnValuetoSQL(stringBuffer, n, string);
        this._conn.executeCommand(stringBuffer.toString());
    }

    @Override
    public void addColumnValuetoSQL(StringBuffer stringBuffer, int n, String string) {
        if (string == null) {
            string = this.getColumn(n);
        }
        switch (n) {
            case 0: {
                stringBuffer.append("@id=" + ScheduledJobSO.argString(string));
                break;
            }
            case 1: {
                if (this.getID() <= 0) {
                    stringBuffer.append("@jobid=" + ScheduledJobSO.argInt(string));
                    break;
                }
                stringBuffer.append("@jname_id=" + ScheduledJobSO.argString(string));
                break;
            }
            case 2: {
                stringBuffer.append("@schedid=" + ScheduledJobSO.argInt(string));
                break;
            }
            case 11: {
                stringBuffer.append("@jname=" + ScheduledJobSO.argString(string));
                break;
            }
            case 12: {
                stringBuffer.append("@sname =" + ScheduledJobSO.argString(string));
                break;
            }
            case 5: {
                stringBuffer.append("@sjowner=" + ScheduledJobSO.argString(string));
                break;
            }
            case 4: {
                stringBuffer.append("@sjproperties=" + ScheduledJobSO.argString(string));
                break;
            }
            case 7: {
                stringBuffer.append("@server=" + ScheduledJobSO.argString(string));
                break;
            }
            case 8: {
                stringBuffer.append("@timeout=" + ScheduledJobSO.argInt(string));
                break;
            }
            default: {
                return;
            }
        }
    }

    private void addScheduleValuestoSQL(StringBuffer stringBuffer) {
        this._schedSO.setColumn(6, this._schedSO.convertPropertiesToPropList());
        this.addSchedColumnValuestoSQL(stringBuffer, 1, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 2, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 6, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 9, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 10, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 11, null);
        this.addSchedColumnValuestoSQL(stringBuffer, 12, null);
        this.addSchedColumnValuestoSQL(stringBuffer, 7, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 8, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 13, null);
        stringBuffer.append(",");
        this.addSchedColumnValuestoSQL(stringBuffer, 14, null);
    }

    public void addSchedColumnValuestoSQL(StringBuffer stringBuffer, int n, String string) {
        if (string == null) {
            string = this._schedSO.getColumn(n);
        }
        switch (n) {
            case 1: {
                stringBuffer.append("@sname=" + ScheduledJobSO.argString(string));
                break;
            }
            case 2: {
                stringBuffer.append("@sdesc=" + ScheduledJobSO.argString(string));
                break;
            }
            case 6: {
                stringBuffer.append("@schedproperties=" + ScheduledJobSO.argString(string));
                break;
            }
            case 9: {
                stringBuffer.append("@startdate=" + ScheduledJobSO.argString(string));
                break;
            }
            case 10: {
                stringBuffer.append("@starttime=" + ScheduledJobSO.argString(string));
                break;
            }
            case 11: {
                if (string.equals("")) break;
                stringBuffer.append("@enddate=" + ScheduledJobSO.argString(string) + ",");
                break;
            }
            case 12: {
                if (string.equals("")) break;
                stringBuffer.append("@endtime=" + ScheduledJobSO.argString(string) + ",");
                break;
            }
            case 7: {
                stringBuffer.append("@repeats=" + string);
                break;
            }
            case 8: {
                stringBuffer.append("@units=" + ScheduledJobSO.argString(string));
                break;
            }
            case 13: {
                stringBuffer.append("@days=" + this.argDaysDates(string));
                break;
            }
            case 14: {
                stringBuffer.append("@dates=" + this.argDaysDates(string));
                break;
            }
            default: {
                return;
            }
        }
    }

    private void addJobValuestoSQL(StringBuffer stringBuffer) {
        this._jobSO.setColumn(6, this._jobSO.convertPropertiesToPropList());
        this.addJobColumnValuestoSQL(stringBuffer, 1, null);
        stringBuffer.append(",");
        this.addJobColumnValuestoSQL(stringBuffer, 2, null);
        stringBuffer.append(",");
        this.addJobColumnValuestoSQL(stringBuffer, 6, null);
        stringBuffer.append(",");
        this.addJobColumnValuestoSQL(stringBuffer, 9, null);
        stringBuffer.append(",");
        this.addJobColumnValuestoSQL(stringBuffer, 7, null);
    }

    public void addJobColumnValuestoSQL(StringBuffer stringBuffer, int n, String string) {
        if (string == null) {
            string = this._jobSO.getColumn(n);
        }
        switch (n) {
            case 1: {
                stringBuffer.append("@jname=" + ScheduledJobSO.argString(string));
                break;
            }
            case 2: {
                stringBuffer.append("@jdesc=" + ScheduledJobSO.argString(string));
                break;
            }
            case 6: {
                stringBuffer.append("@jobproperties=" + ScheduledJobSO.argString(string));
                break;
            }
            case 7: {
                stringBuffer.append("@jtimeout=" + ScheduledJobSO.argInt(string));
                break;
            }
            case 9: {
                stringBuffer.append("@jcmd=" + ScheduledJobSO.argString(string));
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void remove() throws SQLException {
        String string = this.getAllUsers() ? SQLs.getString("exec sybmgmtdb..sp_dropscheduledjob @sjname_id=''{0}'', @option=''all_users''", this.getID()) : SQLs.getString("exec sybmgmtdb..sp_dropscheduledjob @sjname_id=''{0}''", this.getID());
        this._conn.executeCommand(string);
    }

    public void enable(boolean bl) throws SQLException {
        String string = bl ? SQLs.getString("exec sybmgmtdb..sp_controljob @sjname_id=''{0}'', @option=''{1}''", new Integer(this.getID()), "enable") : SQLs.getString("exec sybmgmtdb..sp_controljob @sjname_id=''{0}'', @option=''{1}''", new Integer(this.getID()), "disable");
        this._conn.executeCommand(string);
    }

    public void runnow() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_controljob @sjname_id=''{0}'', @option=''{1}''", new Integer(this.getID()), "run_now");
        this._conn.executeCommand(string);
    }

    public void terminate() throws SQLException {
        String string = SQLs.getString("exec sybmgmtdb..sp_controljob @sjname_id=''{0}'', @option=''{1}''", new Integer(this.getID()), "terminate");
        this._conn.executeCommand(string);
    }

    public void setJobSO(JobSO jobSO) {
        this._jobSO = jobSO;
    }

    public void setJobCommand(String string) {
        this.setSQLText(string);
        this._jobSO.setJobSQLText(string);
        this._jobSO.setSQLText(string);
    }

    public void setSchedSO(ScheduleSO scheduleSO) {
        this._schedSO = scheduleSO;
    }

    public void setID(String string) {
        super.setID(0, string);
    }

    public void setJobID(String string) {
        this.setID(1, string);
    }

    public void setScheduleID(String string) {
        this.setID(2, string);
    }

    public void setEnabled(String string) {
        if (string.equalsIgnoreCase("1")) {
            this.setColumn(3, "true");
        } else {
            this.setColumn(3, "false");
        }
    }

    public void setProperties(String string) {
        this.convertListToProperties(string);
    }

    public void setOwner(String string) {
        this.setColumn(5, string);
    }

    public void setJobName(String string) {
        this.setColumn(11, string);
    }

    public void setScheduleName(String string) {
        this.setColumn(12, string);
    }

    public void setServer(String string) {
        if (string == null || string.equals("null") || string.equals(" ") || string.length() == 0) {
            this.setColumn(7, null);
        } else {
            this.setColumn(7, string);
        }
    }

    public void setState(String string) {
        this.setColumn(15, string);
    }

    public void setLastExecCode(String string) {
        try {
            int n = Integer.parseInt(string);
            this.setColumn(16, string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setColumn(16, "0");
        }
    }

    public void setLastExecError(String string) {
        try {
            int n = Integer.parseInt(string);
            this.setColumn(17, string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setColumn(17, "0");
        }
    }

    public void setTimeout(String string) {
        try {
            int n = Integer.parseInt(string);
            this.setColumn(8, string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setColumn(8, "0");
        }
    }

    public void setTimeout(int n) {
        this.setColumn(8, n + "");
    }

    public void setDefaultTimeout(String string) {
        try {
            int n = Integer.parseInt(string);
            this.setColumn(10, string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setColumn(10, "0");
        }
    }

    public void setCreated(String string) {
        Date date = null;
        try {
            date = JSBaseSO.aseDateTimeFormat.parse(string);
            this.setColumn(6, string);
        }
        catch (ParseException parseException) {
            this.setColumn(6, null);
        }
    }

    public void setNextExec(String string) {
        try {
            Date date = JSBaseSO.aseDateTimeFormat.parse(string);
            this.setColumn(13, string);
        }
        catch (ParseException parseException) {
            this.setColumn(13, null);
        }
    }

    public void setLastExec(String string) {
        try {
            Date date = JSBaseSO.aseDateTimeFormat.parse(string);
            this.setColumn(14, string);
        }
        catch (ParseException parseException) {
            this.setColumn(14, null);
        }
    }

    public void setOutputLogging(boolean bl) {
        this.setColumn(18, Boolean.toString(bl));
    }

    public void setShared(boolean bl) {
        this.setColumn(19, Boolean.toString(bl));
    }

    public void setDisableOnFailure(boolean bl) {
        this.setColumn(20, Boolean.toString(bl));
    }

    public void setDeleteOnCompletion(boolean bl) {
        this.setColumn(21, Boolean.toString(bl));
    }

    public JobSO getJobSO() {
        return this._jobSO;
    }

    public ScheduleSO getScheduleSO() {
        return this._schedSO;
    }

    public int getID() {
        return this.ColumnToInt(0, -1);
    }

    public int getJobID() {
        return this.ColumnToInt(1, -1);
    }

    public int getScheduleID() {
        return this.ColumnToInt(2, -1);
    }

    public int getLastExecError() {
        return this.ColumnToInt(17, 0);
    }

    public int getLastExecCode() {
        return this.ColumnToInt(16, 0);
    }

    public int getTimeout() {
        return this.ColumnToInt(8, 0);
    }

    public String getJobName() {
        return this.getColumn(11);
    }

    public String getScheduleName() {
        return this.getColumn(12);
    }

    public String getServer() {
        return this.getColumn(7);
    }

    public String getOwner() {
        return this.getColumn(5);
    }

    public String getState() {
        return this.getColumn(15);
    }

    public Date getCreated() {
        return this.ColumnToDate(6);
    }

    public Date getLastExec() {
        return this.ColumnToDate(14);
    }

    public Date getNextExec() {
        return this.ColumnToDate(13);
    }

    public boolean getEnabled() {
        return this.ColumnToBoolean(3);
    }

    public boolean getOutputLogging() {
        return this.ColumnToBoolean(18);
    }

    public boolean getShared() {
        return this.ColumnToBoolean(19);
    }

    public boolean getDisableOnFailure() {
        return this.ColumnToBoolean(20);
    }

    public boolean getDeleteOnCompletion() {
        return this.ColumnToBoolean(21);
    }

    private String getProperties() {
        return this.convertPropertiesToPropList();
    }

    @Override
    public Object[] getAttributes() {
        if (this.getColumns() != null) {
            return new String[]{"" + this.getID(0), this.getJobName(), this.getScheduleName(), this.getServerForDisplay(), this.getOwner(), this.getDateForDisplay(this.getCreated()), this.getEnabledForDisplay(), this.getStateForDisplay(), this.getDateForDisplay(this.getLastExec()), this.getLastResultForDisplay(), this.getDateForDisplay(this.getNextExec())};
        }
        return null;
    }

    @Override
    public Date getDate(int n) {
        Date date;
        switch (n) {
            case 6: {
                date = new Date(this.getColumn(6));
                break;
            }
            case 14: {
                date = new Date(this.getColumn(14));
                break;
            }
            case 13: {
                date = new Date(this.getColumn(13));
                break;
            }
            default: {
                date = null;
            }
        }
        return date;
    }

    public boolean canRunNow() {
        return true;
    }

    public boolean canTerminate() {
        String string = this.getColumn(15);
        for (int i = 0; i < EXECUTING_STATES.length; ++i) {
            if (!string.equals(EXECUTING_STATES[i])) continue;
            return true;
        }
        return false;
    }

    public String getServerForDisplay() {
        String string = this.getServer();
        if (string == null) {
            return "null";
        }
        return string;
    }

    private String getEnabledForDisplay() {
        if (this.ColumnToBoolean(3)) {
            return ASEUtils.getString("DISP_ENABLED_TEXT");
        }
        return ASEUtils.getString("DISP_DISABLED_TEXT");
    }

    private String getStateForDisplay() {
        int n;
        String string = null;
        String string2 = this.getColumn(15);
        for (n = 0; n < EXECUTING_STATES.length; ++n) {
            if (!string2.equals(EXECUTING_STATES[n])) continue;
            string = ASEUtils.getString("MSG_RUNNING");
        }
        if (string == null) {
            for (n = 0; n < NON_EXECUTING_STATES.length; ++n) {
                if (!string2.equals(NON_EXECUTING_STATES[n])) continue;
                string = ASEUtils.getString("MSG_IDLE");
            }
        }
        if (string == null) {
            string = ASEUtils.getString("MSG_UNKNOWN");
        }
        return string;
    }

    private String getLastResultForDisplay() {
        String string = null;
        int n = this.getLastExecCode();
        int n2 = this.getLastExecError();
        if (n == 0 && n2 == 0) {
            string = ASEUtils.getString("MSG_NO_ERRORS");
        } else {
            if (n != 0) {
                string = ASEUtils.getString("LABC_EXIT_CODE") + n;
            }
            if (n2 != 0) {
                string = string == null ? ASEUtils.getString("LABC_ATAT_ERROR") + n2 : string + " " + ASEUtils.getString("LABC_ATAT_ERROR") + n2;
            }
        }
        return string;
    }

    private String getDateForDisplay(Date date) {
        return date == null ? "null" : JSBaseSO.aseDateTimeFormat.format(date);
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_SCHEDULEDJOB_TYPE");
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getOwner() + "." + this.getName();
    }
}

