/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.JSBaseInterface;
import com.sybase.aseplugin.so.ASEBaseCtrSO;
import com.sybase.aseplugin.so.ScheduledJobSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class ScheduledJobsCtrSO
extends ASEBaseCtrSO
implements JSBaseInterface {
    private boolean _showAllUsers = false;

    public ScheduledJobsCtrSO(ASConnection aSConnection) {
        super(aSConnection);
    }

    public void setShowAllUsers(boolean bl) {
        this._showAllUsers = bl;
    }

    @Override
    public List open(int n, Object[] objectArray) throws SQLException {
        Vector<ScheduledJobSO> vector = new Vector<ScheduledJobSO>();
        String string = this._showAllUsers ? "exec sybmgmtdb..sp_listscheduledjob 'list=scheduled_short,all_users'" : "exec sybmgmtdb..sp_listscheduledjob 'list=scheduled_short'";
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            ScheduledJobSO scheduledJobSO = new ScheduledJobSO(this._conn, stringArray);
            scheduledJobSO.setAllUsers(this._showAllUsers);
            vector.addElement(scheduledJobSO);
        }
        this.getRSet().close();
        return vector;
    }

    public boolean isSchedulerInstalled() throws SQLException {
        this.getRSet().open("select count(name) from master..sysdatabases where name='sybmgmtdb'");
        int n = this.getRSet().getNextRow() ? this.getRSet().getColumnInt(1) : 0;
        this.getRSet().close();
        return n > 0;
    }

    public boolean isJSAuthorized() throws SQLException {
        boolean bl;
        try {
            bl = this.isAdministrator() || this.isUser() || this.isSA();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 589) {
                throw new SQLException(ASEUtils.getString("ERR_JS_ROLES_NOT_INSTALLED"));
            }
            throw sQLException;
        }
        return bl;
    }

    public boolean isAdministrator() throws SQLException {
        return this.getConnection().hasRole("js_admin_role");
    }

    public boolean isUser() throws SQLException {
        return this.getConnection().hasRole("js_user_role");
    }

    public boolean isClient() throws SQLException {
        return this.getConnection().hasRole("js_client_role");
    }

    public boolean isSA() throws SQLException {
        return this.getConnection().hasRole("sa_role");
    }

    public String getMaxAuthorization() throws SQLException {
        if (this.isAdministrator()) {
            return "js_admin_role";
        }
        if (this.isUser()) {
            return "js_user_role";
        }
        if (this.isClient()) {
            return "js_client_role";
        }
        if (this.isSA()) {
            return "sa_role";
        }
        return null;
    }

    public boolean isSybmgmtdbUser() throws SQLException {
        ASResultSet aSResultSet = this.getRSet();
        try {
            aSResultSet.open("select suid from sybmgmtdb..sysusers where suid = suser_id()");
            if (!aSResultSet.getNextRow()) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_NOT_SYBMGMTDB_USER"), this.getConnection().getCurrentUser());
                throw new SQLException(aSEMessageText.toString());
            }
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            aSResultSet.close();
            if (sQLException.getErrorCode() == 619 || sQLException.getErrorCode() == 10351) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_NOT_SYBMGMTDB_USER"), this.getConnection().getCurrentUser());
                throw new SQLException(aSEMessageText.toString());
            }
            throw sQLException;
        }
        return true;
    }
}

