/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseDBItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SegmentsCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class SegmentSO
extends ASEBaseDBItemSO {
    public static final String LOG_SEGMENT = "logsegment";
    public static final String DEFAULT_SEGMENT = "default";
    public static final int COL_NAME = 0;
    public static final int COL_LAST_CHANCE = 1;
    public static final int COL_SIZE = 2;
    public static final int COL_USED = 3;
    public static final int COL_FREE = 4;
    public static final int COL_HYST = 5;
    private Object[] _attrs;
    private String _dbDeviceName;
    private String _growBySize = "";
    private String _maxSize = "";
    private String _autoThresholdSpace = "";

    public SegmentSO(ASConnection aSConnection, DatabaseSO databaseSO) {
        super(aSConnection, null, databaseSO);
    }

    public SegmentSO(ASConnection aSConnection, DatabaseSO databaseSO, String string, String string2, int n, int n2, int n3) {
        super(aSConnection, string, databaseSO);
        String string3 = string2.endsWith("1") ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
        int n4 = n - n2;
        this._attrs = new Object[]{this.getName(), string3, new Integer(n), new Integer(n2), new Integer(n4), new Integer(n3)};
    }

    public final String getLastChance() {
        return (String)this._attrs[1];
    }

    public final int getSize() {
        Integer n = (Integer)this._attrs[2];
        return n;
    }

    public final String getSegSize() {
        Integer n = (Integer)this._attrs[2];
        return n.toString();
    }

    public final int getUsed() {
        Integer n = (Integer)this._attrs[3];
        return n;
    }

    public final String getSegUsed() {
        Integer n = (Integer)this._attrs[3];
        return n.toString();
    }

    public final int getFree() {
        return this.getSize() - this.getUsed();
    }

    public final String getSegFree() {
        return String.valueOf(this.getFree());
    }

    public final int getHysteresis() {
        Integer n = (Integer)this._attrs[5];
        return n;
    }

    public final String getSegHysteresis() {
        Integer n = (Integer)this._attrs[5];
        return n.toString();
    }

    @Override
    public Object[] getAttributes() {
        return this._attrs;
    }

    @Override
    public void create() throws SQLException {
        this.useDB();
        String string = SQLs.getString("exec sp_addsegment ''{0}'', ''{1}'', ''{2}'' ", this.getName(), this.getDatabaseName(), this.getDBDeviceName());
        this._conn.executeCommand(string);
        if (!this._autoThresholdSpace.equals("")) {
            this.setAutoExpansionThreshold(this._autoThresholdSpace);
        }
        if (!this._maxSize.equals("") || !this._growBySize.equals("")) {
            this.setAutoExpansionAttributes(this._maxSize, this._growBySize);
        }
    }

    @Override
    public void remove() throws SQLException {
        this.useDB();
        String string = SQLs.getString("exec sp_dropsegment ''{0}'', {1} ", this.getName(), this.getDatabaseName());
        this._conn.executeCommand(string);
    }

    @Override
    public SegmentSO findObject() throws SQLException {
        SegmentsCtrSO segmentsCtrSO = new SegmentsCtrSO(this.getConnection(), this.getDatabaseSO());
        Object[] objectArray = new Object[]{this.getName()};
        List list = segmentsCtrSO.open(1, objectArray);
        return list.isEmpty() ? null : (SegmentSO)list.get(0);
    }

    public List getDevicesInSegment() throws SQLException {
        Vector<String[]> vector = new Vector<String[]>();
        String string = "";
        string = this.getConnection().getVersion().compareTo("15") >= 0 ? "select v.name, sum(u.size)/{2} from master.dbo.sysusages u, {0}.dbo.syssegments s, master.dbo.sysdatabases d, master.dbo.sysdevices v where u.dbid=d.dbid and d.name=''{0}'' and s.name=''{1}'' and (v.status&2=2 or v.status2&8=8) and v.vdevno = u.vdevno and ((u.segmap/((s.segment&1)+1))/power(2,(s.segment&30)))&1=1 and v.cntrltype=0 group by v.name" : "select v.name, sum(u.size)/{2} from master.dbo.sysusages u, {0}.dbo.syssegments s, master.dbo.sysdatabases d, master.dbo.sysdevices v where u.dbid=d.dbid and d.name=''{0}'' and s.name=''{1}'' and v.status & 2 = 2 and v.low <= u.vstart and v.high >= u.vstart + (u.size - 1) and ((u.segmap/((s.segment&1)+1))/power(2,(s.segment&30)))&1=1 and v.cntrltype=0 group by v.name";
        String string2 = SQLs.getString(string, this.getDatabaseName(), this.getName(), Integer.toString((int)Utility.getMBToPageSize(this.getConnection())));
        this.getRSet().open(string2);
        while (this.getRSet().getNextRow()) {
            String[] stringArray = new String[]{this.getRSet().getColumnString(1), this.getRSet().getColumnString(2)};
            vector.addElement(stringArray);
        }
        this.getRSet().close();
        return vector;
    }

    public List getContainedObjects() throws SQLException {
        String string = SQLs.getString("select o.name, u.name, i.name, i.indid, o.sysstat2, o.type from {0}.dbo.sysindexes i, {0}.dbo.syssegments s, {0}.dbo.sysobjects o, {0}.dbo.sysusers u where o.id = i.id and u.uid = o.uid and s.name = ''{1}'' and s.segment = i.segment and i.indid != 255 order by 1, 2 ", this.getDatabaseName(), this.getName());
        this.getRSet().open(string);
        Vector<String[]> vector = new Vector<String[]>();
        while (this.getRSet().getNextRow()) {
            Object object;
            String string2;
            String string3;
            String string4;
            int n;
            String string5 = "U";
            int n2 = this.getRSet().getColumnInt(5);
            String string6 = this.getRSet().getColumnString(6);
            if ((n2 & 0x400) == 1024) {
                string5 = "P";
            }
            if (string6.equals("S")) {
                string5 = string6;
            }
            if ((n = this.getRSet().getColumnInt(4)) == 0 || n == 1) {
                string4 = this.getRSet().getColumnString(1);
                string3 = this.getRSet().getColumnString(2);
                string2 = ASEUtils.getString("MSG_TABLE_TYPE");
                object = new String[]{string4, string3, string2, string4, string5};
                vector.add((String[])object);
            }
            if (n < 1) continue;
            string4 = this.getRSet().getColumnString(3);
            string3 = this.getRSet().getColumnString(2);
            string2 = this.getRSet().getColumnString(1);
            object = ASEUtils.getString("MSG_INDEX_TYPE");
            String[] stringArray = new String[]{string4, string3, object, string2, string5};
            vector.add(stringArray);
        }
        this.getRSet().close();
        return vector;
    }

    public String[] getDBDevices() throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = "";
        string = this.getConnection().getVersion().compareTo("15") >= 0 ? "select v.name from master.dbo.sysdevices v, master.dbo.sysusages u, master.dbo.sysdatabases d where v.vdevno = u.vdevno and v.cntrltype=0 and u.dbid=d.dbid and d.name=''{0}'' group by v.name" : "select v.name from master.dbo.sysdevices v, master.dbo.sysusages u, master.dbo.sysdatabases d where v.low<=u.vstart and v.high>=u.vstart and v.cntrltype=0 and u.dbid=d.dbid and d.name=''{0}'' group by v.name";
        String string2 = SQLs.getString(string, this.getDatabaseName());
        this.getRSet().open(string2);
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[0].trim());
        }
        this.getRSet().close();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public void setDBDeviceName(String string) {
        this._dbDeviceName = string;
    }

    public String getDBDeviceName() {
        return this._dbDeviceName;
    }

    public List getDevicesInDatabase() throws SQLException {
        String string = "";
        string = this.getConnection().getVersion().compareTo("15") >= 0 ? "select v.name, (v.high-v.low+1)/{2} from master.dbo.sysusages u, {0}.dbo.syssegments s, master.dbo.sysdatabases d, master.dbo.sysdevices v where u.dbid=d.dbid and d.name=''{0}'' and s.name=''{1}'' and v.vdevno = u.vdevno and ((u.segmap/((s.segment&1)+1))/power(2,(s.segment&30)))&1 <> 1 and v.cntrltype=0 group by v.name" : "select v.name, (v.high-v.low+1)/{2} from master.dbo.sysusages u, {0}.dbo.syssegments s, master.dbo.sysdatabases d, master.dbo.sysdevices v where u.dbid=d.dbid and d.name=''{0}'' and s.name=''{1}'' and u.vstart between v.low and v.high and ((u.segmap/((s.segment&1)+1))/power(2,(s.segment&30)))&1 <> 1 and v.cntrltype=0 group by v.name";
        String string2 = SQLs.getString(string, this.getDatabaseName(), this.getName(), Integer.toString((int)Utility.getMBToPageSize(this.getConnection())));
        this.getRSet().open(string2);
        Vector<String[]> vector = new Vector<String[]>();
        while (this.getRSet().getNextRow()) {
            String[] stringArray = new String[]{this.getRSet().getColumnString(1), "N/A"};
            vector.addElement(stringArray);
        }
        this.getRSet().close();
        return vector;
    }

    public void addDDtoSegment(String string) throws SQLException {
        this.useDB();
        String string2 = SQLs.getString("exec sp_extendsegment ''{0}'', {1}, {2} ", this.getName(), this.getDatabaseName(), string);
        this._conn.executeCommand(string2);
    }

    public void deleteDDfromSegment(String string) throws SQLException {
        this.useDB();
        String string2 = SQLs.getString("exec sp_dropsegment ''{0}'', {1} ", this.getName(), this.getDatabaseName()) + ", " + string;
        this._conn.executeCommand(string2);
    }

    public void addThresholdToSegment(String string, String string2) throws SQLException {
        this.useDB();
        Object[] objectArray = new Object[]{this.getDatabaseName(), this.getName(), string2, string};
        String string3 = SQLs.getString("exec sp_addthreshold {0}, ''{1}'', {2}, {3} ", objectArray);
        this._conn.executeCommand(string3);
    }

    public void dropThresholdFromSegment(String string) throws SQLException {
        this.useDB();
        String string2 = SQLs.getString("exec sp_dropthreshold {0}, ''{1}'', {2} ", this.getDatabaseName(), this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public Vector SegmentTableInit() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getStoredProcedureSmallImage());
        String string = SQLs.getString("select ltrim(str(t.free_space)), t.proc_name, convert(bit,t.status&1), user_name(t.suid) from {0}.dbo.syssegments s, {0}.dbo.systhresholds t where s.segment=t.segment and s.name=''{1}'' ", this.getDatabaseName(), this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            String string2 = this.getRSet().getColumnString(1);
            double d = new Double(string2);
            String string3 = String.valueOf(Utility.getPrecision(Utility.getPageSizeToMB(this.getConnection(), d), 4));
            int n = Integer.parseInt(this.getRSet().getColumnString(3));
            String string4 = this.getRSet().getColumnString(2);
            String string5 = this.getRSet().getColumnString(4);
            if (n == 0) {
                vector2.addElement(new JLabel(string4, imageIcon, 0));
            } else {
                vector2.addElement(new JLabel(string4 + "(Last Chance)", imageIcon, 0));
            }
            vector2.addElement(string5);
            vector2.addElement(string3);
            vector2.addElement(new Integer(this.getRSet().getColumnString(3)));
            vector2.addElement(string2);
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector initDialog() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getStoredProcedureSmallImage());
        String string = SQLs.getString("select o.name, u.name from {0}.dbo.sysobjects o, {0}.dbo.sysusers u where o.type=''P'' and o.uid = u.uid ", this.getDatabaseName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public double KBToGB(double d) {
        return Utility.getKBToGB(d);
    }

    public double pageToKB(double d) {
        return Utility.getPageSizeToKB(this.getConnection(), d);
    }

    public double KBToPage(double d) {
        return Utility.getKBToPageSize(this.getConnection(), d);
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getDatabaseName() + "." + this.getName();
    }

    public String getDefaultGrowBySize() throws SQLException {
        return this.getDatabaseSO().getDefaultGrowBySize();
    }

    public void setAutoExpansionAttributes(String string, String string2) throws SQLException {
        String string3 = "";
        string3 = string2.equals("") ? "null ,'" + string + "'" : (string.equals("") ? "'" + string2 + "'" : "'" + string2 + "'" + ",'" + string + "'");
        String string4 = SQLs.getString("exec sp_dbextend ''set'', ''database'',''{0}'',''{1}'',{2}", this.getDatabaseName(), this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void modifyAutoExpansionAttributes(String string, String string2) throws SQLException {
        String string3;
        if (!string2.equals("")) {
            string3 = SQLs.getString("exec sp_dbextend ''modify'', ''database'',''{0}'',''{1}'',{2}", this.getDatabaseName(), this.getName(), "'growby', '" + string2 + "'");
            this._conn.executeCommand(string3);
        }
        if (!string.equals("")) {
            string3 = SQLs.getString("exec sp_dbextend ''modify'', ''database'',''{0}'',''{1}'',{2}", this.getDatabaseName(), this.getName(), "'maxSize', '" + string + "'");
            this._conn.executeCommand(string3);
        }
    }

    public void setMaxSize(String string) {
        this._maxSize = string;
    }

    public void setGrowBySize(String string) {
        this._growBySize = string;
    }

    public void setAutoExpansionThresholdSpace(String string) {
        this._autoThresholdSpace = string;
    }

    public void setAutoExpansionThreshold(String string) throws SQLException {
        this.useDB();
        String string2 = SQLs.getString("exec sp_dbextend ''set'', ''threshold'',''{0}'',''{1}'',''{2}''", this.getDatabaseName(), this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public void clearAutoExpansionThreshold() throws SQLException {
        this.useDB();
        String string = SQLs.getString("exec sp_dbextend ''clear'', ''threshold'',''{0}'',''{1}''", this.getDatabaseName(), this.getName());
        this._conn.executeCommand(string);
    }

    public String checkExpansion() throws SQLException {
        String string = SQLs.getString("exec sp_dbextend ''check'', ''database'', ''{0}'',''{1}''", this.getDatabaseName(), this.getName());
        String string2 = this._conn.executeReturnWarningMsg(this.getDatabaseName(), string);
        if (string2.equals("")) {
            return "";
        }
        String string3 = this.getBanner(1);
        return string3 + string2;
    }

    public String simulateExpansion() throws SQLException {
        String string = SQLs.getString("exec sp_dbextend ''simulate'',  ''{0}'',''{1}''", this.getDatabaseName(), this.getName());
        String string2 = this.getBanner(2);
        return string2 + this._conn.executeReturnResultWarningMsg(this.getDatabaseName(), string);
    }

    public String expand() throws SQLException {
        String string = SQLs.getString("exec sp_dbextend ''execute'',  ''{0}'',''{1}''", this.getDatabaseName(), this.getName());
        String string2 = this.getBanner(3);
        return string2 + this._conn.executeReturnResultWarningMsg(this.getDatabaseName(), string);
    }

    private String getBanner(int n) {
        StringBuffer stringBuffer = new StringBuffer("\n\n");
        stringBuffer.append("/***********************************************************************/").append("\n\n    ");
        switch (n) {
            case 1: {
                stringBuffer.append(new ASEMessageText(ASEUtils.getString("AUTO_EXPAND_CHECK"), this.getName()));
                break;
            }
            case 2: {
                stringBuffer.append(new ASEMessageText(ASEUtils.getString("AUTO_EXPAND_SIMULATE"), this.getName()));
                break;
            }
            case 3: {
                stringBuffer.append(new ASEMessageText(ASEUtils.getString("AUTO_EXPAND"), this.getName()));
            }
        }
        stringBuffer.append("\n\n").append("/***********************************************************************/").append("\n\n");
        return stringBuffer.toString();
    }

    public Vector getPolicies() throws SQLException {
        Vector<String[]> vector = new Vector<String[]>();
        boolean bl = true;
        this.useDB();
        String string = SQLs.getString("exec sp_dbextend ''list'', ''database'', ''{0}'', ''{1}'' ", this.getDatabaseName(), this.getName());
        ResultSet resultSet = this.getRSet().open(string);
        Statement statement = resultSet.getStatement();
        while (resultSet.next()) {
            if (!resultSet.getString("segment").equals(this.getName())) continue;
            if (resultSet.getString("item").equals("growby")) {
                vector.add(new String[]{"g", resultSet.getString("value"), resultSet.getString("status")});
                bl = false;
            }
            if (!resultSet.getString("item").equals("maxsize")) continue;
            vector.add(new String[]{"m", resultSet.getString("value"), resultSet.getString("status")});
        }
        if (bl) {
            vector.add(new String[]{"d", this.getDefaultGrowBySize(), "enabled"});
        }
        while (!statement.getMoreResults()) {
        }
        resultSet = statement.getResultSet();
        while (resultSet.next()) {
            if (!resultSet.getString("threshold procedure").equals("sp_dbxt_extend_db")) continue;
            vector.add(new String[]{"t", resultSet.getString("free pages"), resultSet.getString("status")});
        }
        return vector;
    }

    public void clearSegmentPolicy() throws SQLException {
        this.useDB();
        String string = SQLs.getString("exec sp_dbextend ''clear'', ''database'',''{0}'',''{1}''", this.getDatabaseName(), this.getName());
        this._conn.executeCommand(string);
    }

    public void enableSegmentPolicy() throws SQLException {
        this.useDB();
        String string = SQLs.getString("exec sp_dbextend ''enable'', ''database'',''{0}'',''{1}''", this.getDatabaseName(), this.getName());
        this._conn.executeCommand(string);
    }

    public void disableSegmentPolicy() throws SQLException {
        this.useDB();
        String string = SQLs.getString("exec sp_dbextend ''disable'', ''database'',''{0}'',''{1}''", this.getDatabaseName(), this.getName());
        this._conn.executeCommand(string);
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_SEGMENT_TYPE");
    }
}

