/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.OptGoal;
import com.sybase.aseplugin.so.QPTuneRule;
import com.sybase.aseplugin.so.QPTuneSO;
import com.sybase.aseplugin.so.RegExpression;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ConnectionProps;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class ServerGroupSO
extends ASEBaseItemSO
implements Comparable {
    public static final String DEFAULT_SERVER_GROUP = ASEUtils.getString("RADB_DEFAULT");
    public static final String DEFAULT_PASSWORD = "enternewpassword";
    public static final String FILTER_NONE = "None";
    public static final String FILTER_LINES = "Lines";
    public static final int DEFAULT_FILTER_LINES = 1000;
    public static final String FILTER_TIME = "Time";
    public static final int DEFAULT_FILTER_TIME = 5;
    public static final String FILTER_TIME_DAYS = "Days";
    public static final String FILTER_TIME_HOURS = "Hours";
    public static final String FILTER_TIME_MINUTES = "Minutes";
    public static final String DEFAULT_FILTER_TIME_UNIT = "Days";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_COMMENT = "Comment";
    private static final String KEY_DATE = "Date";
    private static final String KEY_DEFAULT = "Default";
    private static final String KEY_CONNECTION_STRING = "ConnectionString";
    private static final String KEY_SERVER_LOGS_FILTER = "ServerLogsFilter";
    private static final String KEY_SERVER_LOGS_LINES = "ServerLogsLines";
    private static final String KEY_SERVER_LOGS_TIME = "ServerLogsTime";
    private static final String KEY_SERVER_LOGS_TIME_UNIT = "ServerLogsTimeUnit";
    private static final String KEY_SERVER_LOGS_REGEX = "ServerLogsRegex";
    private static final String KEY_SERVER_LOGS_EXPS = "ServerLogsExpressions";
    private static final String KEY_SERVER_LOGS_AGENT_EXPS = "ServerLogsAgentExpressions";
    private static final String KEY_SERVER_LOGS_EXPRESSION = "Expression";
    private static final String KEY_ENABLED = "ENABLED";
    private static final String KEY_SERVER_LOGS_IGNORE_CASE = "IgnoreCase";
    private static final String KEY_TUNING_TASKS = "TuningTasks";
    private static final String KEY_CONFIG_FILE = "ConfigFile";
    private static final String KEY_DB_NAME = "DBName";
    private static final String KEY_START_CONFIG = "StartConfig";
    private static final String KEY_END_CONFIG = "EndConfig";
    private static final String KEY_FIX_CONFIG = "FixConfig";
    private static final String KEY_START_STAT_CONFIG = "StartStatConfig";
    private static final String KEY_OPT_GOALS = "OptGoals";
    private static final String KEY_APP_FILE = "AppFile";
    private static final String KEY_SCRIPT_FILE = "ScriptFile";
    private static final String KEY_APP_ENABLED = "AppEnabled";
    private static final String KEY_SCRIPT_ENABLED = "ScriptEnabled";
    private static final String KEY_COLLECT_OPTION = "CollectOption";
    private static final String KEY_COLLECT_DELAY = "CollectDelay";
    private static final String KEY_EVAL_FIELD = "EvalField";
    private static final String KEY_THRESHOLD_PERCENT = "ThresholdPercent";
    private static final String KEY_THRESHOLD_VALUE = "ThresholdValue";
    private static final String KEY_SORT_BY_SIZE = "SortBySize";
    private static final String KEY_RESULT_FILE = "ResultFile";
    private static final String KEY_LAST_PAGE_TITLE = "LastPageTitle";
    private static final String KEY_INDEX = "Index";
    private static final String KEY_RULES = "Rules";
    private static final String KEY_NUMBER = "Number";
    private static final String KEY_OUTPUT = "Output";
    private static final String KEY = "user preferences";
    private static final String TYPE_GROUP = "Group";
    private static final String TYPE_SERVER = "Server";
    private static final int REMEMBER_NUMBER_EXPS = 7;
    private static final String KEY_CONNECT_STARTUP = "ConnectStartUp";
    private static final String KEY_LAST_FOLDER = "LastFolder";
    private static final String KEY_LAST_CONFIG = "LastConfig";
    private static final String KEY_STATE = "State";
    private static final String STATE_CUT = "Cut";
    private static Preferences SERVER_GROUP = Preferences.userRoot().node("/com/sybase/aseplugin/so/ServerGroupSO6");
    private static SecretKeySpec _skeySpec = null;
    private static Cipher _cipher = null;
    private Object[] _attrs;
    private String _comment;
    private Date _date;
    private boolean _isDefault = false;
    private ArrayList _servers = null;

    public ServerGroupSO() {
        this.init("", "");
    }

    public ServerGroupSO(String string) {
        this.init(string, "");
    }

    public ServerGroupSO(String string, String string2, boolean bl) {
        this.init(string, string2);
        this._isDefault = bl;
    }

    private ServerGroupSO(String string, String string2, boolean bl, Date date) {
        this.init(string, string2);
        this._isDefault = bl;
        this._date = date;
    }

    private void init(String string, String string2) {
        this.setName(string == null ? "" : string);
        this.setComment(string2 == null ? "" : string2);
        this._attrs = new Object[]{this.getName(), this.getComment()};
    }

    public void setComment(String string) {
        this._comment = string != null ? string : "";
    }

    public String getComment() {
        return this._comment;
    }

    public String getDate() {
        return this._date.toString();
    }

    public void clearNewServers() {
        if (this._servers == null) {
            return;
        }
        this._servers.clear();
    }

    public void addNewServer(Object object) {
        if (this._servers == null) {
            this._servers = new ArrayList();
        }
        this._servers.add(object);
    }

    public void removeNewServer(Object object) {
        if (this._servers == null) {
            return;
        }
        this._servers.remove(object);
    }

    public List getNewServers() {
        return this._servers;
    }

    public String getNewServersString() {
        String string = "";
        if (this._servers != null) {
            String string2 = "";
            for (int i = 0; i < this._servers.size(); ++i) {
                ServerSO serverSO = (ServerSO)this._servers.get(i);
                string = string + string2 + serverSO.getDisplayName();
                string2 = ", ";
            }
        }
        return string;
    }

    private static String[] getChildrenNames() {
        return ServerGroupSO.getChildrenNames(SERVER_GROUP);
    }

    private static String[] getChildrenNames(Preferences preferences) {
        String[] stringArray = null;
        try {
            stringArray = preferences.childrenNames();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return stringArray;
    }

    private static void removeNode(Preferences preferences) {
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static List getGroups() {
        ArrayList<ServerGroupSO> arrayList = new ArrayList<ServerGroupSO>();
        String[] stringArray = ServerGroupSO.getChildrenNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Preferences preferences = SERVER_GROUP.node(string);
                String string2 = preferences.get(KEY_COMMENT, "");
                long l = preferences.getLong(KEY_DATE, -1L);
                Date date = l == -1L ? new Date() : new Date(l);
                boolean bl = preferences.getBoolean(KEY_DEFAULT, false);
                ServerGroupSO serverGroupSO = new ServerGroupSO(string, string2, bl, date);
                arrayList.add(serverGroupSO);
            }
        }
        return arrayList;
    }

    @Override
    public boolean exists() {
        return this.nodeExists(SERVER_GROUP, this.getName());
    }

    private boolean nodeExists(Preferences preferences, String string) {
        try {
            return preferences.nodeExists(string);
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    @Override
    public Object[] getAttributes() {
        return this._attrs;
    }

    private Preferences getGroupNode() {
        return SERVER_GROUP.node(this.getName());
    }

    private Preferences getServerNode(ServerSO serverSO) {
        return this.getServerNode(serverSO.getName(), serverSO.getUserName());
    }

    private Preferences getServerNode(String string, String string2) {
        Preferences preferences = this.getGroupNode().node(this.getConnectionName(string, string2));
        return preferences;
    }

    private Preferences getServerExpsNode(ServerSO serverSO) {
        return this.getServerNode(serverSO).node(KEY_SERVER_LOGS_EXPS);
    }

    private Preferences getAgentExpsNode(ServerSO serverSO) {
        return this.getServerNode(serverSO).node(KEY_SERVER_LOGS_AGENT_EXPS);
    }

    public boolean serverExists(ServerSO serverSO) {
        String string = this.getConnectionName(serverSO.getName(), serverSO.getUserName());
        Preferences preferences = this.getGroupNode();
        return this.nodeExists(preferences, string);
    }

    private Preferences getTuningTasksNode(ServerSO serverSO) {
        return this.getServerNode(serverSO).node(KEY_TUNING_TASKS);
    }

    public void addTuningTask(ServerSO serverSO, QPTuneSO qPTuneSO) {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Preferences preferences = this.getTuningTasksNode(serverSO);
        Preferences preferences2 = preferences.node(qPTuneSO.getName());
        String string8 = qPTuneSO.getConfigFile();
        if (string8 != null) {
            preferences2.put(KEY_CONFIG_FILE, string8);
        }
        if ((string7 = qPTuneSO.getDBName()) != null) {
            preferences2.put(KEY_DB_NAME, string7);
        }
        if ((string6 = qPTuneSO.getStartConfig()) != null) {
            preferences2.put(KEY_START_CONFIG, string6);
        }
        if ((string5 = qPTuneSO.getEndConfig()) != null) {
            preferences2.put(KEY_END_CONFIG, string5);
        }
        if ((string4 = qPTuneSO.getFixConfig()) != null) {
            preferences2.put(KEY_FIX_CONFIG, string4);
        }
        if ((string3 = qPTuneSO.getStartStatConfig()) != null) {
            preferences2.put(KEY_START_STAT_CONFIG, string3);
        }
        if ((string2 = qPTuneSO.getAppPath()) != null) {
            preferences2.put(KEY_APP_FILE, string2);
        }
        preferences2.putBoolean(KEY_APP_ENABLED, qPTuneSO.getAppEnabled());
        String string9 = qPTuneSO.getScriptPath();
        if (string9 != null) {
            preferences2.put(KEY_SCRIPT_FILE, string9);
        }
        preferences2.putBoolean(KEY_SCRIPT_ENABLED, qPTuneSO.getScriptEnabled());
        ArrayList<OptGoal> arrayList = qPTuneSO.getOptGoals();
        Preferences preferences3 = preferences2.node(KEY_OPT_GOALS);
        ServerGroupSO.removeNode(preferences3);
        preferences3 = preferences2.node(KEY_OPT_GOALS);
        for (int i = 0; i < arrayList.size(); ++i) {
            object3 = arrayList.get(i);
            object2 = preferences3.node(((OptGoal)object3).getModeName());
            ((Preferences)object2).putBoolean(KEY_ENABLED, ((OptGoal)object3).getEnabled());
            ((Preferences)object2).putInt(KEY_INDEX, i);
            ((Preferences)object2).put(KEY_TYPE, ((OptGoal)object3).getOptGoalName());
            if (((OptGoal)object3).isPredefined()) continue;
            string = ((OptGoal)object3).getInputFileName();
            if (string != null) {
                ((Preferences)object2).put(KEY_CONFIG_FILE, string);
            }
            ((Preferences)object2).putInt(KEY_NUMBER, ((OptGoal)object3).getQueryNumber());
            if (((OptGoal)object3).isBasic()) continue;
            object = ((OptGoal)object3).getRules();
            Preferences preferences4 = ((Preferences)object2).node(KEY_RULES);
            ServerGroupSO.removeNode(preferences4);
            preferences4 = ((Preferences)object2).node(KEY_RULES);
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                QPTuneRule qPTuneRule = (QPTuneRule)((ArrayList)object).get(j);
                Preferences preferences5 = preferences4.node(qPTuneRule.sql);
                preferences5.putBoolean(KEY_ENABLED, qPTuneRule.enabled);
                preferences5.putInt(KEY_INDEX, j);
            }
        }
        String string10 = qPTuneSO.getCollectOption();
        if (string10 != null) {
            preferences2.put(KEY_COLLECT_OPTION, string10);
        }
        preferences2.putInt(KEY_COLLECT_DELAY, qPTuneSO.getCollectDelay());
        object3 = qPTuneSO.getEvalField();
        if (object3 != null) {
            preferences2.put(KEY_EVAL_FIELD, (String)object3);
        }
        preferences2.putInt(KEY_THRESHOLD_PERCENT, qPTuneSO.getThresholdPercent());
        preferences2.putInt(KEY_THRESHOLD_VALUE, qPTuneSO.getThresholdValue());
        preferences2.putBoolean(KEY_SORT_BY_SIZE, qPTuneSO.getSortBySize());
        object2 = qPTuneSO.getResultFile();
        if (object2 != null) {
            preferences2.put(KEY_RESULT_FILE, (String)object2);
        }
        if ((string = qPTuneSO.getCompareOutput()).length() > 8192) {
            string = string.substring(string.length() - 8192);
        }
        if (string != null) {
            preferences2.put(KEY_OUTPUT, string);
        }
        preferences2.putBoolean(KEY_COMMENT, qPTuneSO.getVerbose());
        preferences2.putBoolean(KEY_DEFAULT, qPTuneSO.getDefaultOptGoals());
        object = qPTuneSO.getLastPageTitle();
        if (object != null) {
            preferences2.put(KEY_LAST_PAGE_TITLE, (String)object);
        }
    }

    public void removeTuningTask(ServerSO serverSO, QPTuneSO qPTuneSO) {
        Preferences preferences = this.getTuningTasksNode(serverSO);
        Preferences preferences2 = preferences.node(qPTuneSO.getName());
        ServerGroupSO.removeNode(preferences2);
    }

    public ArrayList<QPTuneSO> getTuningTasks(ServerSO serverSO) {
        return this.getTuningTasks(serverSO, null);
    }

    public ArrayList<QPTuneSO> getTuningTasks(ServerSO serverSO, Object[] objectArray) {
        ArrayList<QPTuneSO> arrayList = new ArrayList<QPTuneSO>();
        Preferences preferences = this.getTuningTasksNode(serverSO);
        String[] stringArray = ServerGroupSO.getChildrenNames(preferences);
        Object object = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            QPTuneSO qPTuneSO = new QPTuneSO(serverSO);
            String string = stringArray[i];
            qPTuneSO.setName(string);
            Preferences preferences2 = preferences.node(string);
            qPTuneSO.setConfigFile(preferences2.get(KEY_CONFIG_FILE, ""));
            qPTuneSO.setDBName(preferences2.get(KEY_DB_NAME, "master"));
            qPTuneSO.setStartConfig(preferences2.get(KEY_START_CONFIG, null));
            qPTuneSO.setEndConfig(preferences2.get(KEY_END_CONFIG, null));
            qPTuneSO.setFixConfig(preferences2.get(KEY_FIX_CONFIG, null));
            qPTuneSO.setStartStatConfig(preferences2.get(KEY_START_STAT_CONFIG, null));
            qPTuneSO.setAppPath(preferences2.get(KEY_APP_FILE, null));
            qPTuneSO.setAppEnabled(preferences2.getBoolean(KEY_APP_ENABLED, false));
            qPTuneSO.setScriptPath(preferences2.get(KEY_SCRIPT_FILE, null));
            qPTuneSO.setScriptEnabled(preferences2.getBoolean(KEY_SCRIPT_ENABLED, false));
            qPTuneSO.setCollectOption(preferences2.get(KEY_COLLECT_OPTION, "collect"));
            qPTuneSO.setCollectDelay(preferences2.getInt(KEY_COLLECT_DELAY, 0));
            qPTuneSO.setEvalField(preferences2.get(KEY_EVAL_FIELD, null));
            qPTuneSO.setThresholdPercent(preferences2.getInt(KEY_THRESHOLD_PERCENT, 5));
            qPTuneSO.setThresholdValue(preferences2.getInt(KEY_THRESHOLD_VALUE, 5));
            qPTuneSO.setSortBySize(preferences2.getBoolean(KEY_SORT_BY_SIZE, false));
            qPTuneSO.setResultFile(preferences2.get(KEY_RESULT_FILE, ""));
            qPTuneSO.setVerbose(preferences2.getBoolean(KEY_COMMENT, false));
            qPTuneSO.setDefaultOptGoals(preferences2.getBoolean(KEY_DEFAULT, false));
            qPTuneSO.setLastPageTitle(preferences2.get(KEY_LAST_PAGE_TITLE, null));
            qPTuneSO.setCompareOutput(preferences2.get(KEY_OUTPUT, ""));
            Preferences preferences3 = preferences2.node(KEY_OPT_GOALS);
            String[] stringArray2 = ServerGroupSO.getChildrenNames(preferences3);
            ArrayList<OptGoal> arrayList2 = new ArrayList<OptGoal>();
            for (n = 0; n < stringArray2.length; ++n) {
                arrayList2.add(new OptGoal());
            }
            for (n = 0; n < stringArray2.length; ++n) {
                int n2;
                String string2 = stringArray2[n];
                Preferences preferences4 = preferences3.node(string2);
                int n3 = preferences4.getInt(KEY_INDEX, n);
                arrayList2.get(n3).setModeName(string2);
                arrayList2.get(n3).setEnabled(preferences4.getBoolean(KEY_ENABLED, true));
                arrayList2.get(n3).setOptGoaName(preferences4.get(KEY_TYPE, ""));
                arrayList2.get(n3).setQueryNumber(preferences4.getInt(KEY_NUMBER, 10));
                arrayList2.get(n3).setInputFileName(preferences4.get(KEY_CONFIG_FILE, ""));
                Preferences preferences5 = preferences4.node(KEY_RULES);
                String[] stringArray3 = ServerGroupSO.getChildrenNames(preferences5);
                ArrayList<QPTuneRule> arrayList3 = new ArrayList<QPTuneRule>();
                for (n2 = 0; n2 < stringArray3.length; ++n2) {
                    arrayList3.add(new QPTuneRule());
                }
                for (n2 = 0; n2 < stringArray3.length; ++n2) {
                    String string3 = stringArray3[n2];
                    Preferences preferences6 = preferences5.node(string3);
                    int n4 = preferences6.getInt(KEY_INDEX, n2);
                    arrayList3.get((int)n4).sql = string3;
                    arrayList3.get((int)n4).enabled = preferences6.getBoolean(KEY_ENABLED, true);
                }
                arrayList2.get(n3).setRules(arrayList3);
            }
            qPTuneSO.setOptGoals(arrayList2);
            if (object == null) {
                arrayList.add(qPTuneSO);
                continue;
            }
            if (!qPTuneSO.getName().equals(object)) continue;
            arrayList.add(qPTuneSO);
            break;
        }
        return arrayList;
    }

    @Override
    public void create() {
        Preferences preferences = this.getGroupNode();
        preferences.put(KEY_TYPE, TYPE_GROUP);
        preferences.put(KEY_COMMENT, this._comment);
        this._date = new Date();
        preferences.putLong(KEY_DATE, this._date.getTime());
        preferences.putBoolean(KEY_DEFAULT, this._isDefault);
    }

    public boolean copyServer(ServerSO serverSO, ServerGroupSO serverGroupSO) {
        Preferences preferences = this.getServerNode(serverSO);
        return this.copyServer(preferences, serverGroupSO.getGroupNode());
    }

    private boolean copyServer(Preferences preferences, Preferences preferences2) {
        String string = preferences.name();
        Preferences preferences3 = preferences2.node(string);
        try {
            String[] stringArray = preferences.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                preferences3.put(string2, preferences.get(string2, null));
            }
            String[] stringArray2 = preferences.childrenNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = stringArray2[i];
                Preferences preferences4 = preferences.node(string3);
                this.copyServer(preferences4, preferences3);
            }
            preferences3.remove(KEY_STATE);
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println(backingStoreException);
            Support.addLogEntry(0, this.getClass().getName(), backingStoreException.toString(), backingStoreException.getMessage());
            return false;
        }
    }

    @Override
    public void remove() {
        ServerGroupSO.removeNode(this.getGroupNode());
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public List getServers() {
        ArrayList<ServerSO> arrayList = new ArrayList<ServerSO>();
        Preferences preferences = this.getGroupNode();
        if (preferences == null) {
            return arrayList;
        }
        String[] stringArray = ServerGroupSO.getChildrenNames(preferences);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                byte[] byArray;
                String string2 = stringArray[i];
                Preferences preferences2 = preferences.node(string2);
                String string3 = preferences2.get(KEY_STATE, null);
                if (string3 != null && string3.equals(STATE_CUT) || (byArray = preferences2.getByteArray(KEY_CONNECTION_STRING, null)) == null || (string = ServerGroupSO.getDecrypted(byArray)) == null) continue;
                ASEConnectionInfo aSEConnectionInfo = ConnectionProps.getNewConnectionInfo(string);
                ServerSO serverSO = new ServerSO(aSEConnectionInfo, this, null);
                arrayList.add(serverSO);
            }
        }
        return arrayList;
    }

    private String getConnectionName(String string, String string2) {
        String string3 = string + ":" + string2;
        return string3;
    }

    private void addServer(ServerSO serverSO) {
        this.addServer(ServerSO.getServerName(serverSO.getConnectionInfo()), serverSO.getConnectionInfo());
    }

    public synchronized void addServer(String string, ASEConnectionInfo aSEConnectionInfo) {
        Preferences preferences = this.getServerNode(string, aSEConnectionInfo.getUserName());
        ASEConnectionInfo aSEConnectionInfo2 = new ASEConnectionInfo(aSEConnectionInfo);
        if (!ProfileHelper.getRememberPassword()) {
            aSEConnectionInfo2.setPassword(DEFAULT_PASSWORD);
        }
        String string2 = aSEConnectionInfo2.getConnectionString();
        preferences.put(KEY_TYPE, TYPE_SERVER);
        preferences.putByteArray(KEY_CONNECTION_STRING, ServerGroupSO.getEncrypted(string2));
        preferences.putLong(KEY_DATE, new Date().getTime());
        preferences.remove(KEY_STATE);
    }

    public void deleteServer(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        ServerGroupSO.removeNode(preferences);
    }

    public static void removeCutServers() {
        String[] stringArray = ServerGroupSO.getChildrenNames();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Preferences preferences = SERVER_GROUP.node(string);
            String[] stringArray2 = ServerGroupSO.getChildrenNames(preferences);
            if (stringArray2 == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j];
                Preferences preferences2 = preferences.node(string2);
                String string3 = preferences2.get(KEY_STATE, null);
                if (string3 == null || !string3.equals(STATE_CUT)) continue;
                ServerGroupSO.removeNode(preferences2);
            }
        }
    }

    public void cutServer(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        preferences.put(KEY_STATE, STATE_CUT);
    }

    public ASEConnectionInfo getServerInfo(String string, String string2) {
        Preferences preferences = this.getServerNode(string, string2);
        byte[] byArray = preferences.getByteArray(KEY_CONNECTION_STRING, null);
        if (byArray == null) {
            return null;
        }
        String string3 = ServerGroupSO.getDecrypted(byArray);
        ASEConnectionInfo aSEConnectionInfo = string3 == null ? null : ConnectionProps.getNewConnectionInfo(string3);
        return aSEConnectionInfo;
    }

    public boolean getConnectAtStartup(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        return preferences.getBoolean(KEY_CONNECT_STARTUP, false);
    }

    public void setConnectAtStartup(ServerSO serverSO, boolean bl) {
        Preferences preferences = this.getServerNode(serverSO);
        preferences.putBoolean(KEY_CONNECT_STARTUP, bl);
    }

    public String getServerLastFolder(String string, String string2) {
        Preferences preferences = this.getServerNode(string, string2);
        return preferences.get(KEY_LAST_FOLDER, null);
    }

    public int getServerLastConfig(String string, String string2) {
        Preferences preferences = this.getServerNode(string, string2);
        return preferences.getInt(KEY_LAST_CONFIG, 0);
    }

    public void setServerLastFolder(ServerSO serverSO, String string) {
        Preferences preferences = this.getServerNode(serverSO);
        String string2 = "/";
        String[] stringArray = string.split(string2);
        String string3 = "";
        String string4 = "";
        for (int i = 3; i < stringArray.length; ++i) {
            string3 = string3 + string4 + stringArray[i];
            string4 = string2;
        }
        preferences.put(KEY_LAST_FOLDER, string3);
    }

    public void setServerLastConfig(ServerSO serverSO, int n) {
        Preferences preferences = this.getServerNode(serverSO);
        preferences.putInt(KEY_LAST_CONFIG, n);
    }

    public String getServerLogsFilter(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        return preferences.get(KEY_SERVER_LOGS_FILTER, FILTER_LINES);
    }

    public void setServerLogsFilter(ServerSO serverSO, String string) {
        Preferences preferences = this.getServerNode(serverSO);
        preferences.put(KEY_SERVER_LOGS_FILTER, string);
    }

    public int getServerLogsLines(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        return preferences.getInt(KEY_SERVER_LOGS_LINES, 1000);
    }

    public void setServerLogsLines(ServerSO serverSO, int n) {
        Preferences preferences = this.getServerNode(serverSO);
        preferences.putInt(KEY_SERVER_LOGS_LINES, n);
    }

    public int getServerLogsTime(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        return preferences.getInt(KEY_SERVER_LOGS_TIME, 5);
    }

    public void setServerLogsTime(ServerSO serverSO, int n) {
        Preferences preferences = this.getServerNode(serverSO);
        preferences.putInt(KEY_SERVER_LOGS_TIME, n);
    }

    public String getServerLogsTimeUnit(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        return preferences.get(KEY_SERVER_LOGS_TIME_UNIT, "Days");
    }

    public void setServerLogsTimeUnit(ServerSO serverSO, String string) {
        Preferences preferences = this.getServerNode(serverSO);
        preferences.put(KEY_SERVER_LOGS_TIME_UNIT, string);
    }

    public ArrayList getServerLogsAgentExps(ServerSO serverSO) {
        ArrayList<RegExpression> arrayList = new ArrayList<RegExpression>();
        Preferences preferences = this.getAgentExpsNode(serverSO);
        String[] stringArray = ServerGroupSO.getChildrenNames(preferences);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Preferences preferences2 = preferences.node(string);
            String string2 = preferences2.get(KEY_SERVER_LOGS_EXPRESSION, null);
            boolean bl = preferences2.getBoolean(KEY_ENABLED, true);
            boolean bl2 = preferences2.getBoolean(KEY_SERVER_LOGS_IGNORE_CASE, false);
            if (string2 == null) continue;
            arrayList.add(new RegExpression(string, string2, bl, bl2));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void addServerLogsAgentExp(ServerSO serverSO, RegExpression regExpression) {
        RegExpression regExpression2;
        int n;
        ArrayList arrayList = this.getServerLogsAgentExps(serverSO);
        Preferences preferences = this.getAgentExpsNode(serverSO);
        ServerGroupSO.removeNode(preferences);
        preferences = this.getAgentExpsNode(serverSO);
        int n2 = -1;
        for (n = 0; n < arrayList.size(); ++n) {
            regExpression2 = (RegExpression)arrayList.get(n);
            if (!regExpression2.expression.equals(regExpression.expression) || regExpression2.ignoreCase != regExpression.ignoreCase) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            arrayList.remove(n2);
        }
        if (arrayList.size() == 7) {
            arrayList.remove(arrayList.size() - 1);
        }
        this.addExpression(preferences, regExpression);
        for (n = 0; n < arrayList.size(); ++n) {
            regExpression2 = (RegExpression)arrayList.get(n);
            this.addExpression(preferences, regExpression2);
        }
    }

    public String getServerLogsRegex(ServerSO serverSO) {
        Preferences preferences = this.getServerNode(serverSO);
        return preferences.get(KEY_SERVER_LOGS_REGEX, null);
    }

    public void setServerLogsRegex(ServerSO serverSO, String string) {
        Preferences preferences = this.getServerNode(serverSO);
        if (string == null) {
            preferences.remove(KEY_SERVER_LOGS_REGEX);
        } else {
            preferences.put(KEY_SERVER_LOGS_REGEX, string);
        }
    }

    public ArrayList getServerLogsExps(ServerSO serverSO) {
        Object object;
        ArrayList<RegExpression> arrayList = new ArrayList<RegExpression>();
        boolean bl = this.nodeExists(this.getServerNode(serverSO), KEY_SERVER_LOGS_EXPS);
        if (!bl) {
            object = new ArrayList();
            ((ArrayList)object).add(new RegExpression("Stacktrace", "pcstkwalk", true, false));
            ((ArrayList)object).add(new RegExpression("Error", "Error:", true, false));
            ((ArrayList)object).add(new RegExpression("Warning", "warning", true, true));
            ((ArrayList)object).add(new RegExpression("Deadlock", "deadlock", true, true));
            ((ArrayList)object).add(new RegExpression("Recovering Database", "recovering database '.*'", true, true));
            ((ArrayList)object).add(new RegExpression("Bypass Recovery", "bypass recovery", true, true));
            ((ArrayList)object).add(new RegExpression("DBCC TRACEON", "DBCC TRACEON [0-9]*", true, false));
            ((ArrayList)object).add(new RegExpression("Engine Online", "engine online", true, true));
            ((ArrayList)object).add(new RegExpression("Threshold", "threshold", true, true));
            ((ArrayList)object).add(new RegExpression("Rep Agent Terminated", "Rep Agent Thread .*terminated abnormally", false, false));
            ((ArrayList)object).add(new RegExpression("Truncation Point Invalid", "The Secondary Truncation Point is not valid", false, false));
            this.setServerLogsExps(serverSO, (ArrayList)object);
        }
        object = this.getServerExpsNode(serverSO);
        String[] stringArray = ServerGroupSO.getChildrenNames((Preferences)object);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Preferences preferences = ((Preferences)object).node(string);
            String string2 = preferences.get(KEY_SERVER_LOGS_EXPRESSION, null);
            boolean bl2 = preferences.getBoolean(KEY_ENABLED, true);
            boolean bl3 = preferences.getBoolean(KEY_SERVER_LOGS_IGNORE_CASE, false);
            if (string2 == null) continue;
            arrayList.add(new RegExpression(string, string2, bl2, bl3));
        }
        return arrayList;
    }

    public void setServerLogsExps(ServerSO serverSO, ArrayList arrayList) {
        Preferences preferences = this.getServerExpsNode(serverSO);
        ServerGroupSO.removeNode(preferences);
        preferences = this.getServerExpsNode(serverSO);
        for (RegExpression regExpression : arrayList) {
            this.addExpression(preferences, regExpression);
        }
    }

    private void addExpression(Preferences preferences, RegExpression regExpression) {
        Preferences preferences2 = preferences.node(regExpression.description);
        preferences2.put(KEY_SERVER_LOGS_EXPRESSION, regExpression.expression);
        preferences2.putBoolean(KEY_ENABLED, regExpression.enabled);
        preferences2.putBoolean(KEY_SERVER_LOGS_IGNORE_CASE, regExpression.ignoreCase);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public boolean hasValidName() {
        String string = this.getName();
        return string != null && string.length() > 0 && string.length() <= 30;
    }

    public void reName(ServerGroupSO serverGroupSO) {
        serverGroupSO.create();
        List list = this.getServers();
        for (ServerSO serverSO : list) {
            serverGroupSO.addServer(serverSO);
        }
        this.remove();
    }

    public void reComment(String string) {
        this.setComment(string);
        Preferences preferences = this.getGroupNode();
        preferences.put(KEY_COMMENT, this.getComment());
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    private static void initCipher() throws Exception {
        byte[] byArray = KEY.getBytes();
        _skeySpec = new SecretKeySpec(byArray, "AES");
        _cipher = Cipher.getInstance("AES");
    }

    private static byte[] getEncrypted(String string) {
        try {
            if (_cipher == null) {
                ServerGroupSO.initCipher();
            }
            _cipher.init(1, _skeySpec);
            byte[] byArray = _cipher.doFinal(string.getBytes());
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getDecrypted(byte[] byArray) {
        try {
            if (_cipher == null) {
                ServerGroupSO.initCipher();
            }
            _cipher.init(2, _skeySpec);
            byte[] byArray2 = _cipher.doFinal(byArray);
            return new String(byArray2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void export(String string) throws IOException, BackingStoreException {
        ServerGroupSO.export(string, null);
    }

    public static void export(String string, ServerGroupSO serverGroupSO) throws IOException, BackingStoreException {
        Preferences preferences = serverGroupSO == null ? SERVER_GROUP : serverGroupSO.getGroupNode();
        preferences.exportSubtree(new FileOutputStream(string));
    }

    public static void safeExport(String string) throws IOException, BackingStoreException {
        ServerGroupSO.safeExport(string, null);
    }

    public static void removeExistingPasswords() {
        String[] stringArray = ServerGroupSO.getChildrenNames();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Preferences preferences = SERVER_GROUP.node(string);
            String[] stringArray2 = ServerGroupSO.getChildrenNames(preferences);
            if (stringArray2 == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2;
                String string3 = stringArray2[j];
                Preferences preferences2 = preferences.node(string3);
                byte[] byArray = preferences2.getByteArray(KEY_CONNECTION_STRING, null);
                if (byArray == null || (string2 = ServerGroupSO.getDecrypted(byArray)) == null) continue;
                ASEConnectionInfo aSEConnectionInfo = ConnectionProps.getNewConnectionInfo(string2);
                aSEConnectionInfo.setPassword(DEFAULT_PASSWORD);
                String string4 = aSEConnectionInfo.getConnectionString();
                preferences2.putByteArray(KEY_CONNECTION_STRING, ServerGroupSO.getEncrypted(string4));
            }
        }
    }

    public static void safeExport(String string, ServerGroupSO serverGroupSO) throws IOException, BackingStoreException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String[] stringArray = ServerGroupSO.getChildrenNames();
        if (stringArray != null) {
            String string2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                object4 = SERVER_GROUP.node(string3);
                object3 = ServerGroupSO.getChildrenNames((Preferences)object4);
                if (object3 == null) continue;
                for (int j = 0; j < ((String[])object3).length; ++j) {
                    String string4 = object3[j];
                    object2 = ((Preferences)object4).node(string4);
                    object = ((Preferences)object2).getByteArray(KEY_CONNECTION_STRING, null);
                    if (object == null || (string2 = ServerGroupSO.getDecrypted(object)) == null) continue;
                    ASEConnectionInfo aSEConnectionInfo = ConnectionProps.getNewConnectionInfo(string2);
                    treeMap.put(string3 + string4, string2);
                    aSEConnectionInfo.setPassword(DEFAULT_PASSWORD);
                    String string5 = aSEConnectionInfo.getConnectionString();
                    ((Preferences)object2).putByteArray(KEY_CONNECTION_STRING, ServerGroupSO.getEncrypted(string5));
                }
            }
            Preferences preferences = serverGroupSO == null ? SERVER_GROUP : serverGroupSO.getGroupNode();
            preferences.exportSubtree(new FileOutputStream(string));
            for (int i = 0; i < stringArray.length; ++i) {
                object4 = stringArray[i];
                object3 = SERVER_GROUP.node((String)object4);
                String[] stringArray2 = ServerGroupSO.getChildrenNames((Preferences)object3);
                if (stringArray2 == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    object2 = stringArray2[j];
                    object = ((Preferences)object3).node((String)object2);
                    string2 = (String)treeMap.get((String)object4 + (String)object2);
                    object.putByteArray(KEY_CONNECTION_STRING, ServerGroupSO.getEncrypted(string2));
                }
            }
        }
    }

    public static void importGroups(String string) throws IOException, InvalidPreferencesFormatException {
        Preferences.importPreferences(new FileInputStream(string));
    }
}

