/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.MBeanSO;
import com.sybase.aseplugin.so.RegExpression;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCMessageListener;
import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.AuthenticationException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.ConnectionListener;
import com.sybase.ua.JMXException;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.plugin.AgentPluginException;
import com.sybase.ua.security.ResourceURL;
import com.sybase.ua.security.ac.ARL;
import com.sybase.ua.security.ac.RoleMapping;
import com.sybase.ua.security.ac.RolesMap;
import com.sybase.ua.security.crypto.SecureObject;
import com.sybase.ua.util.MessageListener;
import com.sybase.ua.util.ProcessInfo;
import com.sybase.ua.util.jdom.JDomUtil;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.ObjectName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ServerSO
extends ASEBaseItemSO
implements Comparable,
ConnectionListener {
    public static final String PROF_MONITOR_NAME = "Monitor.Name";
    public static final String PROF_MONITOR_INCLUDE = "Monitor.Include";
    public static final String EDITION_ENTERPRISE_15 = "ASE_EE";
    public static final String EDITION_SMALL_BUSINESS_15 = "ASE_SE";
    public static final String EDITION_DEVELOPER_15 = "ASE_DE";
    public static final String EDITION_EXPRESS_15 = "ASE_XE";
    public static final String EDITION_ENTERPRISE = "ASE_SERVER";
    public static final String EDITION_SMALL_BUSINESS = "ASE_SBE";
    public static final String EDITION_DEVELOPER = "ASE_DEV";
    public static final String EDITION_EXPRESS = "ASE_EXPRESS";
    public static final String EDITION_CORE = "ASE_CORE";
    public static final String FEATURE_ASE_HA = "ASE_HA";
    public static final String FEATURE_ASE_DTM = "ASE_DTM";
    public static final String FEATURE_ASE_JAVA = "ASE_JAVA";
    public static final String FEATURE_ASE_ASM = "ASE_ASM";
    public static final String FEATURE_ASE_EJB = "ASE_EJB";
    public static final String FEATURE_ASE_EFTS = "ASE_EFTS";
    public static final String FEATURE_ASE_XFS = "ASE_XFS";
    public static final String FEATURE_ASE_DIRS = "ASE_DIRS";
    public static final String FEATURE_ASE_XRAY = "ASE_XRAY";
    public static final String FEATURE_ASE_XML = "ASE_XML";
    public static final String FEATURE_ASE_WEBSERVICES = "ASE_WEBSERVICES";
    public static final String FEATURE_ASE_MESSAGING = "ASE_MESSAGING";
    public static final String FEATURE_ASE_DA = "ASE_DA";
    public static final String FEATURE_ASE_ENCRYPTION = "ASE_ENCRYPTION";
    public static final String FEATURE_ASE_PARTITIONS = "ASE_PARTITIONS";
    public static final String FEATURE_ASE_SXP = "ASE_SXP";
    public static final String FEATURE_ASE_SECDIR = "ASE_SECDIR";
    public static final String FEATURE_ASE_CONTMGT = "ASE_CONTMGT";
    public static final String FEATURE_ASE_EBIZ = "ASE_EBIZ";
    public static final String FEATURE_ASE_DRECOVERY = "ASE_DRECOVERY";
    public static final String FEATURE_ASE_XMLMGMT = "ASE_XMLMGMT";
    public static final String FEATURE_ASE_RESOURCE_LIMITS = "allow resource limits";
    public static final String FEATURE_ASE_MESSAGING_CONFIG = "enable real time messaging";
    public static final String FEATURE_ASE_SEMANTIC_PARTITIONING_CONFIG = "enable semantic partitioning";
    public static final String ANONYMOUS_USER_NAME = "(anonymous)";
    public static final String STATUS_SDC_ONLINE = "ONLINE";
    public static final String STATUS_SDC_OFFLINE = "OFFLINE";
    public static final String CLUSTERMODE_SDC = "SHARED DISK CLUSTER";
    public static final String CLUSTERMODE_SMP = "SMP";
    public static final int CMD_RESTART = 3075;
    public static final int CMD_START = 3076;
    public static final int CMD_STOP = 3078;
    public static final int CMD_PING = 3079;
    public static final int CMD_DELETE = 3080;
    private ServerGroupSO _serverGroupSO = null;
    private ASEConnectionInfo _info;
    private SyUAFASEEntry _uafInfo = null;
    protected AgentInfo _agentInfo = null;
    private PluginInfo _pluginInfo = null;
    private MBeanSO _mbean = null;
    private String _agentServerName = null;
    private long _pinged = -1L;
    private Boolean _hasAdminAccess = null;
    private String _aseHome = null;
    protected String _clusterCfgXML = null;
    private Object[] _attrs;
    private Boolean _isAutoExpansionApplicable;
    private Boolean _isECEnabled;
    private String _clusterName = "";
    private static String _defaultAgentPort = "9999";
    private static Hashtable _agentConnections = new Hashtable();
    private static Hashtable _authenticated = new Hashtable();
    private static Hashtable _discoveredServers = new Hashtable();
    private static TreeSet _discoveredHosts = new TreeSet();
    private ICluster _cluster;
    private int _isBackupServerActive = -1;
    private Properties _backupServerProps;
    private int _areMultipleBackupServerSPresent = -1;
    private String _multipleBackupServersProps;
    private int _numberOfBackupServerDefined = -1;
    private Boolean[] _isXPServerActive;
    private List _xpServerProps;
    private Boolean[] _isMonitorServerActive;
    private List _monitorServerProps;

    public ServerSO(ASEConnectionInfo aSEConnectionInfo, ServerGroupSO serverGroupSO, SyUAFASEEntry syUAFASEEntry) {
        super(null, aSEConnectionInfo.getServerName() == null ? aSEConnectionInfo.host + ":" + aSEConnectionInfo.port : aSEConnectionInfo.getServerName());
        this._info = aSEConnectionInfo;
        this._serverGroupSO = serverGroupSO;
        this._uafInfo = syUAFASEEntry;
        this.load();
    }

    public ServerSO(ASConnection aSConnection, ASEConnectionInfo aSEConnectionInfo, String string, ServerGroupSO serverGroupSO, SyUAFASEEntry syUAFASEEntry) {
        super(aSConnection, string);
        this._info = aSEConnectionInfo;
        this._serverGroupSO = serverGroupSO;
        this._uafInfo = syUAFASEEntry;
        this.load();
    }

    public ServerSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
        this._attrs = new Object[]{this.getDisplayName(), aSConnection.getHostNameAndPortNumber()};
    }

    public ServerSO(String string) {
        this.setName(string);
    }

    public synchronized void setUAFInfo(SyUAFASEEntry syUAFASEEntry) {
        this._uafInfo = syUAFASEEntry;
        this.load();
    }

    public SyUAFASEEntry getUAFInfo() {
        return this._uafInfo;
    }

    public ASEConnectionInfo getConnectionInfo() {
        ASConnection aSConnection = this.getConnection();
        return aSConnection != null ? aSConnection.getConnectionInfo(this._info) : this._info;
    }

    public boolean isSSL() {
        ASEConnectionInfo aSEConnectionInfo = this.getConnectionInfo();
        if (aSEConnectionInfo != null) {
            return aSEConnectionInfo.getServiceFilter() != null && aSEConnectionInfo.getServiceFilter().equals("ssl");
        }
        return false;
    }

    public void setConnectionInfo(ASEConnectionInfo aSEConnectionInfo) {
        this._info = aSEConnectionInfo;
    }

    public void load() {
        this._attrs = new Object[]{this.getDisplayName(), this.getVersion(), this.getAgentPlatformAndOS(), this.getHostAndPortNumber(), this.getStatus(), this.getConnected()};
    }

    public void addAuthenticated(String string, String string2) {
        TreeMap treeMap = this.getAuthenticated();
        treeMap.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap getAuthenticated() {
        String string = this.getAgentConnectionKey();
        Hashtable hashtable = _authenticated;
        synchronized (hashtable) {
            Object v = _authenticated.get(string);
            if (v == null) {
                _authenticated.put(string, new TreeMap());
                return (TreeMap)_authenticated.get(string);
            }
            return (TreeMap)v;
        }
    }

    private boolean isAuthenticated(String string) {
        TreeMap treeMap = this.getAuthenticated();
        return treeMap.containsKey(string);
    }

    public boolean hasUAFPluginAdminAccess() {
        if (!this.isUAFMonitored()) {
            return false;
        }
        if (this._hasAdminAccess == null) {
            if (this.isCluster()) {
                String string = String.class.getName() + "," + String.class.getName();
                string = string + "," + MessageListener.class.getName();
                String string2 = String.class.getName() + "," + Integer.class.getName() + "," + "java.util.Date";
                string2 = string2 + "," + MessageListener.class.getName();
                this._hasAdminAccess = new Boolean(this.hasAccess("startCluster", string, "execute") && this.hasAccess("startInstance", string, "execute") && this.hasAccess("stopCluster", string2, "execute"));
            } else {
                this._hasAdminAccess = new Boolean(this.hasAccess("start", "", "execute") && this.hasAccess("restart", "", "execute") && this.hasAccess("stop", "", "execute"));
            }
        }
        return this._hasAdminAccess;
    }

    public boolean hasAccess(String string, String string2) {
        AgentConnection agentConnection = null;
        try {
            agentConnection = this.getAgentConnection();
            this.getPluginInfo(agentConnection);
            ResourceURL resourceURL = ResourceURL.createPluginAttributeResourceURL((String)this._pluginInfo.getId(), (String)this._pluginInfo.getVersion(), (int)this._pluginInfo.getInstanceNumber(), (String)string);
            return agentConnection.hasAccess(resourceURL.getURL(), string2);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean hasAccess(String string, String string2, String string3) {
        AgentConnection agentConnection = null;
        try {
            agentConnection = this.getAgentConnection();
            this.getPluginInfo(agentConnection);
            ResourceURL resourceURL = ResourceURL.createPluginOperationResourceURL((String)this._pluginInfo.getId(), (String)this._pluginInfo.getVersion(), (int)this._pluginInfo.getInstanceNumber(), (String)string, (String)string2);
            return agentConnection.hasAccess(resourceURL.getURL(), string3);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public String getAuthenticatedUsers() {
        String string = "";
        TreeMap treeMap = this.getAuthenticated();
        String string2 = "";
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            string = string + string2 + iterator.next();
            string2 = ", ";
        }
        return string;
    }

    public void authenticate(String string, String string2) throws AuthenticationException, RemoteException {
        AgentConnection agentConnection = this.getAgentConnection();
        agentConnection.login(string, string2.toCharArray());
        this.addAuthenticated(string, string2);
        this._hasAdminAccess = null;
    }

    private String getAgentConnectionKey() {
        String string = this.getUserName();
        string = (string == null ? "" : string) + "@";
        return string + this.getIPAndPort();
    }

    public void removeAgentConnections() {
        Enumeration enumeration = _agentConnections.keys();
        String string = this.getIPAndPort();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.endsWith(string)) continue;
            this.removeAgentConnection(string2);
        }
        this.setUAFInfo(null);
    }

    private void removeAgentConnection(String string) {
        Object v = _agentConnections.get(string);
        if (v != null && v instanceof AgentConnection) {
            AgentConnection agentConnection = (AgentConnection)v;
            agentConnection.removeConnectionListener((ConnectionListener)this);
            try {
                agentConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _agentConnections.remove(string);
        this._pinged = -1L;
    }

    public void onConnectionTimedOut(AgentConnection agentConnection) {
        agentConnection.removeConnectionListener((ConnectionListener)this);
        agentConnection = null;
        this._pinged = -1L;
    }

    public AgentConnection getAgentConnection() throws RemoteException {
        return this.getAgentConnection(null);
    }

    public AgentConnection getAgentConnection(String string) throws RemoteException {
        String string2 = this.getAgentConnectionKey();
        Object v = _agentConnections.get(string2);
        while (v != null && v.toString().equals("connecting")) {
            try {
                Thread.sleep((long)(Math.random() * 10000.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            v = _agentConnections.get(string2);
        }
        AgentConnection agentConnection = null;
        boolean bl = false;
        if (v == null) {
            agentConnection = this.createAgentConnection(string2, string);
            bl = true;
        } else {
            agentConnection = (AgentConnection)v;
            boolean bl2 = agentConnection.isTimedOut();
            boolean bl3 = agentConnection.isConnected();
            if (bl2 || !bl3) {
                this.removeAgentConnection(string2);
                agentConnection = this.createAgentConnection(string2, string);
                bl = true;
            }
        }
        if (this._pinged == -1L && bl) {
            this.reAuthenticate(agentConnection);
        }
        this._agentInfo = agentConnection.getAgentInfo();
        if (this._info.getUserName() != null) {
            this._info.setRMIPort(this._agentInfo.getRMIPort());
            if (this._serverGroupSO.serverExists(this)) {
                try {
                    this.create();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return agentConnection;
    }

    private AgentConnection createAgentConnection(String string, String string2) throws RemoteException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        AgentConnection agentConnection = null;
        String string3 = String.valueOf(-1);
        try {
            String string4;
            if (string2 == null) {
                string4 = _defaultAgentPort;
                if (this._info.getRMIPort() != null && !this._info.getRMIPort().equals(string3) && !this._info.getRMIPort().equals("0")) {
                    string4 = this._info.getRMIPort();
                } else {
                    SyUAFASEEntry syUAFASEEntry = ServerSO.getDiscoveredServer(this.getHostName(), this.getPortNumber());
                    if (syUAFASEEntry != null) {
                        string4 = syUAFASEEntry.getRMIPort();
                    }
                }
            } else {
                string4 = string2;
            }
            _agentConnections.put(string, "connecting");
            agentConnection = AgentConnectionFactory.createAgentConnection((String)"rmi", (String)this.getHostName(), (String)string4);
            agentConnection.connect();
            agentConnection.addConnectionListener((ConnectionListener)this);
        }
        catch (Exception exception) {
            this.removeAgentConnection(string);
            this._info.setRMIPort(string3);
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw new RemoteException(exception.getMessage());
        }
        this.addAuthenticated(ANONYMOUS_USER_NAME, "");
        Thread.currentThread().setContextClassLoader(classLoader);
        _agentConnections.put(string, agentConnection);
        return agentConnection;
    }

    public List getUAFEntries() throws RemoteException {
        AgentConnection agentConnection = this.getAgentConnection();
        ArrayList<SyUAFASEEntry> arrayList = new ArrayList<SyUAFASEEntry>();
        AgentInfo agentInfo = agentConnection.getAgentInfo();
        List list = agentInfo.getPluginInfos();
        for (PluginInfo pluginInfo : list) {
            String string = pluginInfo.getId();
            String string2 = pluginInfo.getVersion();
            int n = pluginInfo.getInstanceNumber();
            Map map = pluginInfo.getDiscoveryProperties();
            arrayList.add(new SyUAFASEEntry(map, string, string2, n, agentInfo));
        }
        return arrayList;
    }

    public String getClusterConfigXML() throws RemoteException, IOException {
        return this.getClusterConfigXML(true);
    }

    public String getClusterConfigXML(boolean bl) throws RemoteException, IOException {
        if (!bl && this._clusterCfgXML != null && this._clusterCfgXML.trim().length() > 0) {
            return this._clusterCfgXML;
        }
        Object[] objectArray = new Object[]{this.getName(), new Integer(0)};
        String[] stringArray = new String[]{String.class.getName(), Integer.class.getName()};
        this._clusterCfgXML = (String)this.invokeAgentPluginMethod("getClusterConfiguration", objectArray, stringArray);
        return this._clusterCfgXML;
    }

    public String getClusterName() throws SQLException {
        if (this._clusterName.equals("")) {
            this.getRSet().open("select @@clustername");
            if (this.getRSet().getNextRow()) {
                this._clusterName = this.getRSet().getColumnString(1);
            }
        }
        this.getRSet().close();
        return this._clusterName;
    }

    public ICluster getClusterConfiguration() throws RemoteException, JDOMException, IOException, SQLException, ClusterConfigException {
        if (this._cluster == null) {
            this.refreshClusterConfiguration();
        }
        return this._cluster;
    }

    public void refreshClusterConfiguration() throws RemoteException, IOException, SQLException, ClusterConfigException {
        String string = this.getClusterConfigXML(true);
        if (string != null && !string.equals("")) {
            Element element = JDomUtil.getDocument((String)string).getRootElement();
            this._cluster = ClusterConfigFactory.createCluster((String)this.getClusterName());
            if (this._cluster != null) {
                this._cluster = XMLCluster.getCluster((ICluster)this._cluster, (Element)element);
            }
        }
    }

    public String getFileSeparator() throws RemoteException, AgentConnectionException {
        return (String)this.getAgentServiceProperty("fileSeparator");
    }

    public ProcessInfo executeRemoteShell(Object[] objectArray, String[] stringArray) throws RemoteException, AgentConnectionException {
        return (ProcessInfo)this.invokeAgentServiceMethod("RemoteShellService", "executeWait", objectArray, stringArray);
    }

    public boolean doesHostPortExistInInterface(ICluster iCluster, String string, int n) throws AgentConnectionException, RemoteException {
        Boolean bl = null;
        String string2 = iCluster.getInterfacesPath();
        Object[] objectArray = new Object[]{string2, string, String.valueOf(n)};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        bl = (Boolean)this.invokeAgentPluginMethod("doesHostPortExistInInterface", objectArray, stringArray);
        return bl == null ? false : bl;
    }

    public boolean isSupportMBS() {
        ASConnection aSConnection = this.getConnection();
        return aSConnection.getVersion().compareTo("15.0.3") >= 0 && ContainerViewBO.getServerBO(aSConnection).isCluster();
    }

    public void refreshBackupServer() {
        this.refreshBackupServer(true);
    }

    public void refreshBackupServer(boolean bl) {
        this._isBackupServerActive = -1;
        this._backupServerProps = null;
        this._multipleBackupServersProps = null;
        this._numberOfBackupServerDefined = -1;
        this._areMultipleBackupServerSPresent = -1;
        try {
            if (bl) {
                this.refreshClusterConfiguration();
            }
            this.isBackupServerActive(this.getClusterConfiguration());
            if (this.isSupportMBS()) {
                this.getMultipleBackupServerProperties();
                this.getNumberOfBackupServersDefined();
                this.areMultipleBackupServersPresent();
            } else {
                this.getBackupServerProperties();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createBackupServer(ICluster iCluster) throws AgentPluginException, ClusterConfigException, IOException {
        String string = iCluster.getName();
        if (this.isLocalInstallation()) {
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        }
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (this.isSupportMBS()) {
            String string3 = SDCClusterAgentProxy.getCLAPAdmin();
            SecureObject secureObject = SDCClusterAgentProxy.getCLAPCryptPass();
            Object[] objectArray = new Object[]{string, string2, string3, secureObject, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("createBackupServer", objectArray, stringArray);
        } else {
            Object[] objectArray = new Object[]{string, string2, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("createBackupServer", objectArray, stringArray);
        }
        this.refreshBackupServer();
    }

    public void dropBackupServer(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException {
        String string = iCluster.getName();
        this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (this.isSupportMBS()) {
            String string3 = SDCClusterAgentProxy.getCLAPAdmin();
            SecureObject secureObject = SDCClusterAgentProxy.getCLAPCryptPass();
            Object[] objectArray = new Object[]{string, string2, string3, secureObject, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("dropBackupServer", objectArray, stringArray);
        } else {
            Object[] objectArray = new Object[]{string, string2, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("dropBackupServer", objectArray, stringArray);
        }
        this.refreshBackupServer();
    }

    public boolean isBackupServerActive(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException {
        String[] stringArray;
        String string;
        if (this._isBackupServerActive > -1) {
            return this._isBackupServerActive > 0;
        }
        String string2 = iCluster.getName();
        Object[] objectArray = new Object[]{string2, string = XMLCluster.getXMLClusterString((ICluster)iCluster), null};
        Boolean bl = (Boolean)this.invokeAgentPluginMethod("isBackupServerActive", objectArray, stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"});
        if (bl == null) {
            throw new ClusterConfigException("command.error.backupserver.active");
        }
        this._isBackupServerActive = bl != false ? 1 : 0;
        return bl;
    }

    public int getNumberOfBackupServersDefined(ICluster iCluster) throws SQLException, AgentConnectionException, RemoteException, ClusterConfigException {
        if (this._numberOfBackupServerDefined > 0) {
            return this._numberOfBackupServerDefined;
        }
        String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        this._numberOfBackupServerDefined = (Integer)this.invokeAgentPluginMethod("getNumberOfBackupServersDefined", objectArray, stringArray);
        return this._numberOfBackupServerDefined;
    }

    public Properties getBackupServerProperties() throws SQLException, AgentConnectionException, RemoteException {
        if (this._backupServerProps != null) {
            return this._backupServerProps;
        }
        String string = this.getClusterName();
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        this._backupServerProps = (Properties)this.invokeAgentPluginMethod("getBackupServerProperties", objectArray, stringArray);
        return this._backupServerProps;
    }

    public String getMultipleBackupServerProperties() throws SQLException, AgentConnectionException, RemoteException {
        if (this._multipleBackupServersProps != null) {
            return this._multipleBackupServersProps;
        }
        String string = this.getClusterName();
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        this._multipleBackupServersProps = (String)this.invokeAgentPluginMethod("getMultipleBackupServerProperties", objectArray, stringArray);
        return this._multipleBackupServersProps;
    }

    public int getNumberOfBackupServersDefined() throws SQLException, AgentConnectionException, RemoteException {
        if (this._numberOfBackupServerDefined > 0) {
            return this._numberOfBackupServerDefined;
        }
        String string = this.getMultipleBackupServerProperties();
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        this._numberOfBackupServerDefined = (Integer)this.invokeAgentPluginMethod("getNumberOfBackupServersDefined", objectArray, stringArray);
        return this._numberOfBackupServerDefined;
    }

    public boolean areMultipleBackupServersPresent() throws RemoteException, IOException, SQLException, ClusterConfigException {
        boolean bl;
        if (this._areMultipleBackupServerSPresent > -1) {
            return this._areMultipleBackupServerSPresent > 0;
        }
        String string = this.getMultipleBackupServerProperties();
        if (string != null && !string.equals("")) {
            Element element = JDomUtil.getDocument((String)string).getRootElement();
            this._cluster = ClusterConfigFactory.createCluster((String)this.getClusterName());
            if (this._cluster != null) {
                this._cluster = XMLCluster.getCluster((ICluster)this._cluster, (Element)element);
            }
        }
        this._areMultipleBackupServerSPresent = (bl = this._cluster.areMultipleBackupServersPresent()) ? 1 : 0;
        return bl;
    }

    public void setMultipleBackupServerProperties(ICluster iCluster) throws AgentConnectionException, RemoteException, ClusterConfigException, AgentPluginException, IOException {
        if (this.isLocalInstallation()) {
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        }
        String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
        String string2 = SDCClusterAgentProxy.getCLAPAdmin();
        SecureObject secureObject = SDCClusterAgentProxy.getCLAPCryptPass();
        Object[] objectArray = new Object[]{string, string2, secureObject, null};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
        this.invokeAgentPluginMethod("setMultipleBackupServerProperties", objectArray, stringArray);
        this.refreshBackupServer();
    }

    public void setBackupServerProperties(Properties properties) throws ClusterConfigException, JDOMException, IOException, SQLException {
        ICluster iCluster = this.getClusterConfiguration();
        if (this.isSupportMBS()) {
            if (this.isLocalInstallation()) {
                this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
            }
            String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
            String string2 = SDCClusterAgentProxy.getCLAPAdmin();
            SecureObject secureObject = SDCClusterAgentProxy.getCLAPCryptPass();
            Object[] objectArray = new Object[]{properties, string, string2, secureObject, null};
            String[] stringArray = new String[]{"java.util.Properties", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("setBackupServerProperties", objectArray, stringArray);
        } else {
            Object[] objectArray = new Object[]{properties, null};
            String[] stringArray = new String[]{"java.util.Properties", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("setBackupServerProperties", objectArray, stringArray);
        }
        this.refreshBackupServer();
    }

    public void addBackupServerToNodes(HashMap hashMap) throws SQLException, JDOMException, IOException, ClusterConfigException {
        ICluster iCluster = this.getClusterConfiguration();
        if (this.isSupportMBS()) {
            if (this.isLocalInstallation()) {
                this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
            }
            String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
            String string2 = SDCClusterAgentProxy.getCLAPAdmin();
            SecureObject secureObject = SDCClusterAgentProxy.getCLAPCryptPass();
            Object[] objectArray = new Object[]{string, hashMap, string2, secureObject, null};
            String[] stringArray = new String[]{"java.lang.String", "java.util.HashMap", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("addBackupServerToNodes", objectArray, stringArray);
        } else {
            String string = this.getClusterName();
            Object[] objectArray = new Object[]{string, hashMap, null};
            String[] stringArray = new String[]{"java.lang.String", "java.util.HashMap", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("addBackupServerToNodes", objectArray, stringArray);
        }
        this.refreshBackupServer();
    }

    public void removeBackupServerFromNodes(List list) throws ClusterConfigException, SQLException, JDOMException, IOException {
        ICluster iCluster = this.getClusterConfiguration();
        if (this.isSupportMBS()) {
            if (this.isLocalInstallation()) {
                this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
            }
            String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
            String string2 = SDCClusterAgentProxy.getCLAPAdmin();
            SecureObject secureObject = SDCClusterAgentProxy.getCLAPCryptPass();
            Object[] objectArray = new Object[]{string, list, string2, secureObject, null};
            String[] stringArray = new String[]{"java.lang.String", "java.util.List", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("removeBackupServerFromNodes", objectArray, stringArray);
        } else {
            String string = this.getClusterName();
            Object[] objectArray = new Object[]{string, list, null};
            String[] stringArray = new String[]{"java.lang.String", "java.util.List", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("removeBackupServerFromNodes", objectArray, stringArray);
        }
        this.refreshBackupServer();
    }

    public void refreshMonitorServer() {
        this.refreshMonitorServer(true);
    }

    public void refreshMonitorServer(boolean bl) {
        this._isMonitorServerActive = null;
        this._monitorServerProps = null;
        try {
            if (bl) {
                this.refreshClusterConfiguration();
            }
            this.isMonitorServerActive(this.getClusterConfiguration());
            this.getMonitorServerProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createMonitorServer(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException, IOException {
        String string = iCluster.getName();
        if (this.isLocalInstallation()) {
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        }
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (this.isSupportMBS()) {
            Object[] objectArray = new Object[]{string, string2, null, this.getUserName(), this.getPassword(), SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass()};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener", "java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject"};
            this.invokeAgentPluginMethod("createMonitorServer", objectArray, stringArray);
        } else {
            Object[] objectArray = new Object[]{string, string2, null, this.getUserName(), this.getPassword()};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener", "java.lang.String", "java.lang.String"};
            this.invokeAgentPluginMethod("createMonitorServer", objectArray, stringArray);
        }
        this.refreshMonitorServer();
    }

    public void dropMonitorServer(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException, IOException {
        String string = iCluster.getName();
        if (this.isLocalInstallation()) {
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        }
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (this.isSupportMBS()) {
            Object[] objectArray = new Object[]{string, string2, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("dropMonitorServer", objectArray, stringArray);
        } else {
            Object[] objectArray = new Object[]{string, string2, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("dropMonitorServer", objectArray, stringArray);
        }
        this.refreshMonitorServer();
    }

    public List getMonitorServerProperties() throws SQLException, AgentConnectionException, RemoteException {
        if (this._monitorServerProps != null) {
            return this._monitorServerProps;
        }
        String string = this.getClusterName();
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        this._monitorServerProps = (List)this.invokeAgentPluginMethod("getMonitorServerProperties", objectArray, stringArray);
        return this._monitorServerProps;
    }

    public void setMonitorServerProperties(List list) throws AgentPluginException, ClusterConfigException, RemoteException, SQLException {
        String string = this.getClusterName();
        Object[] objectArray = new Object[]{string, list, null};
        String[] stringArray = new String[]{"java.lang.String", "java.util.List", "com.sybase.ua.util.MessageListener"};
        this.invokeAgentPluginMethod("setMonitorServerProperties", objectArray, stringArray);
        this.refreshMonitorServer();
    }

    public void setMonitorServerProperties(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException, SQLException {
        this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
        Object[] objectArray = new Object[]{string, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), null};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
        this.invokeAgentPluginMethod("setMonitorServerProperties", objectArray, stringArray);
        this.refreshMonitorServer();
    }

    public Boolean[] isMonitorServerActive(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException {
        if (this._isMonitorServerActive != null) {
            return this._isMonitorServerActive;
        }
        String string = iCluster.getName();
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        Object[] objectArray = new Object[]{string, string2, null};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
        Boolean[] booleanArray = (Boolean[])this.invokeAgentPluginMethod("isMonitorServerActive", objectArray, stringArray);
        this._isMonitorServerActive = booleanArray;
        return booleanArray;
    }

    public void refreshXPServer() {
        this.refreshXPServer(true);
    }

    public void refreshXPServer(boolean bl) {
        this._isXPServerActive = null;
        this._xpServerProps = null;
        try {
            if (bl) {
                this.refreshClusterConfiguration();
            }
            this.isXPServerActive(this.getClusterConfiguration());
            this.getXPServerProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXPServerProperties(List list) throws AgentPluginException, ClusterConfigException, RemoteException, SQLException {
        String string = this.getClusterName();
        Object[] objectArray = new Object[]{string, list, null};
        String[] stringArray = new String[]{"java.lang.String", "java.util.List", "com.sybase.ua.util.MessageListener"};
        this.invokeAgentPluginMethod("setXPServerProperties", objectArray, stringArray);
        this.refreshXPServer();
    }

    public void setXPServerProperties(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException, SQLException {
        this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
        Object[] objectArray = new Object[]{string, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), null};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
        this.invokeAgentPluginMethod("setXPServerProperties", objectArray, stringArray);
        this.refreshXPServer();
    }

    public void createXPServer(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException, IOException {
        String string = iCluster.getName();
        if (this.isLocalInstallation()) {
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        }
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (this.isSupportMBS()) {
            Object[] objectArray = new Object[]{string, string2, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("createXPServer", objectArray, stringArray);
        } else {
            Object[] objectArray = new Object[]{string, string2, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("createXPServer", objectArray, stringArray);
        }
        this.refreshXPServer();
    }

    public void dropXPServer(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException, IOException {
        String string = iCluster.getName();
        if (this.isLocalInstallation()) {
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        }
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (this.isSupportMBS()) {
            Object[] objectArray = new Object[]{string, string2, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("dropXPServer", objectArray, stringArray);
        } else {
            Object[] objectArray = new Object[]{string, string2, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
            this.invokeAgentPluginMethod("dropXPServer", objectArray, stringArray);
        }
        this.refreshXPServer();
    }

    public List getXPServerProperties() throws SQLException, AgentConnectionException, RemoteException {
        if (this._xpServerProps != null) {
            return this._xpServerProps;
        }
        String string = this.getClusterName();
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        this._xpServerProps = (List)this.invokeAgentPluginMethod("getXPServerProperties", objectArray, stringArray);
        return this._xpServerProps;
    }

    public Boolean[] isXPServerActive(ICluster iCluster) throws AgentPluginException, ClusterConfigException, RemoteException {
        if (this._isXPServerActive != null) {
            return this._isXPServerActive;
        }
        String string = iCluster.getName();
        String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        Object[] objectArray = new Object[]{string, string2, null};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
        Boolean[] booleanArray = (Boolean[])this.invokeAgentPluginMethod("isXPServerActive", objectArray, stringArray);
        this._isXPServerActive = booleanArray;
        return booleanArray;
    }

    public List getSDCInstances() throws RemoteException, JDOMException, IOException {
        return this.getSDCInstances(false);
    }

    public List getSDCInstances(boolean bl) throws RemoteException, JDOMException, IOException {
        if (!this.isCluster()) {
            return null;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = this.getClusterConfigXML(bl);
        String string2 = "ase_sdc";
        String string3 = "cluster";
        String string4 = "nodes";
        String string5 = "node";
        String string6 = "name";
        String string7 = "instance";
        String string8 = "id";
        String string9 = "name";
        String string10 = "interface";
        String string11 = "port";
        SAXBuilder sAXBuilder = null;
        Document document = null;
        sAXBuilder = JDomUtil.getJDOMParser((boolean)false);
        StringReader stringReader = new StringReader(string);
        document = sAXBuilder.build((Reader)stringReader);
        Element element = document.getRootElement();
        Element element2 = element.getChild(string2);
        Element element3 = element2.getChild(string3);
        Element element4 = element3.getChild(string4);
        List list = element4.getChildren(string5);
        for (Element element5 : list) {
            String string12 = element5.getAttributeValue(string6);
            List list2 = element5.getChildren(string7);
            for (Element element6 : list2) {
                String string13 = element6.getAttributeValue(string8);
                String string14 = element6.getAttributeValue(string9);
                Element element7 = element6.getChild(string10);
                String string15 = element7.getAttributeValue(string11);
                String[] stringArray = new String[]{string13, string14, string12, string15};
                arrayList.add(stringArray);
            }
        }
        return arrayList;
    }

    public AgentInfo getAgentInfo() {
        return this._agentInfo;
    }

    public PluginInfo getPluginInfo() throws RemoteException {
        return this.getPluginInfo(this.getAgentConnection());
    }

    public String getDiscoveryProperty(String string) throws RemoteException {
        PluginInfo pluginInfo = this.getPluginInfo();
        if (pluginInfo != null) {
            return (String)pluginInfo.getDiscoveryProperty(string);
        }
        return null;
    }

    private PluginInfo getPluginInfo(AgentConnection agentConnection) {
        if (this._pluginInfo == null) {
            List list = this._agentInfo.getPluginInfos();
            for (PluginInfo pluginInfo : list) {
                int n = pluginInfo.getInstanceNumber();
                String string = pluginInfo.getVersion();
                if (n != this._uafInfo.getInstanceNumber() || !string.equals(this._uafInfo.getPluginVersion())) continue;
                this._pluginInfo = pluginInfo;
                break;
            }
        }
        return this._pluginInfo;
    }

    public MBeanSO getMBean() throws Exception {
        return this.getMBean(this.getAgentConnection());
    }

    private MBeanSO getMBean(AgentConnection agentConnection) throws Exception {
        if (this._mbean == null) {
            PluginInfo pluginInfo = this.getPluginInfo(agentConnection);
            String string = pluginInfo.getName();
            String string2 = pluginInfo.getId();
            String string3 = pluginInfo.getVersion();
            Integer n = new Integer(pluginInfo.getInstanceNumber());
            boolean bl = pluginInfo.isLoaded();
            ObjectName objectName = new ObjectName("AgentPlugin:name=" + string2 + "_" + string3 + "_" + n.toString());
            ARL aRL = (ARL)agentConnection.getMBeanAttribute(objectName, "Arl");
            this._mbean = new MBeanSO(this, objectName, string, string2, string3, n, bl, aRL, agentConnection);
        }
        return this._mbean;
    }

    public String[] getActiveSecurityModules() throws RemoteException {
        AgentConnection agentConnection = this.getAgentConnection();
        String[] stringArray = (String[])agentConnection.getAgentServiceProperty("SecurityService", "securityModules");
        return stringArray;
    }

    public String[] getMappedRoles(RolesMap rolesMap) throws RemoteException {
        String[] stringArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray2 = this.getActiveSecurityModules();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray = this.getUARoles(rolesMap, stringArray2[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                hashtable.put(stringArray[j], stringArray[j]);
            }
        }
        Collection collection = hashtable.values();
        stringArray = new String[collection.size()];
        collection.toArray(stringArray);
        return stringArray;
    }

    public String[] getUARoles(RolesMap rolesMap, String string) {
        Object object;
        String[] stringArray2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        List list = rolesMap.getSecurityModules();
        for (String[] stringArray2 : list) {
            object = stringArray2.getName();
            if (!((String)object).equals(string)) continue;
            List list2 = stringArray2.getRoleMappings();
            for (RoleMapping roleMapping : list2) {
                String string2 = roleMapping.getUafRole();
                hashtable.put(string2, string2);
            }
        }
        stringArray2 = new String[hashtable.size()];
        object = hashtable.values();
        object.toArray(stringArray2);
        return stringArray2;
    }

    public RolesMap getRolesMap() throws RemoteException {
        AgentConnection agentConnection = this.getAgentConnection();
        try {
            return (RolesMap)agentConnection.getAgentServiceProperty("SecurityService", "RolesMap");
        }
        catch (AgentConnectionException agentConnectionException) {
            return new RolesMap();
        }
    }

    public String getAgentPluginProperty(String string) throws RemoteException {
        try {
            AgentConnection agentConnection = this.getAgentConnection();
            SyUAFASEEntry syUAFASEEntry = ServerSO.getDiscoveredServer(this.getHostName(), this.getPortNumber());
            if (syUAFASEEntry != null) {
                String string2 = syUAFASEEntry.getPluginVersion();
                int n = syUAFASEEntry.getInstanceNumber();
                String string3 = this.isCluster() ? SyUAF.SDC_PLUGIN_ID : SyUAF.ASE_PLUGIN_ID;
                Object object = agentConnection.getAgentPluginProperty(string3, string2, n, string);
                return object == null ? null : object.toString();
            }
            return "";
        }
        catch (AuthorizationException authorizationException) {
            return ASEUtils.getString("MSG_NO_AUTHORIZATION_FOR_PROP");
        }
    }

    public boolean ping() throws AgentConnectionException, RemoteException {
        return this.ping(null);
    }

    public boolean ping(String string) throws AgentConnectionException, RemoteException {
        boolean bl = false;
        try {
            Object object = this.invokeAgentPluginMethod("ping", null, null, string);
            Boolean bl2 = object != null ? (Boolean)object : new Boolean(false);
            bl = bl2;
            this.setStatus(bl ? "RUNNING" : "STOPPED");
            if (bl) {
                this.authenticateASE();
            }
            this._pinged = new Date().getTime();
        }
        catch (JMXException jMXException) {
            this.removeAgentConnections();
            this._pinged = -1L;
            this.setStatus("UNKNOWN");
            throw jMXException;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAuthenticate(AgentConnection agentConnection) throws RemoteException {
        TreeMap treeMap = this.getAuthenticated();
        Hashtable hashtable = _authenticated;
        synchronized (hashtable) {
            for (String string : treeMap.keySet()) {
                if (string.equals(ANONYMOUS_USER_NAME)) continue;
                String string2 = (String)treeMap.get(string);
                try {
                    agentConnection.login(string, string2.toCharArray());
                }
                catch (AuthenticationException authenticationException) {}
            }
        }
    }

    protected void authenticateASE() throws RemoteException {
        Object object;
        ASEConnectionInfo aSEConnectionInfo;
        AgentConnection agentConnection = this.getAgentConnection();
        if (this._agentServerName == null) {
            aSEConnectionInfo = this.getPluginInfo(agentConnection);
            object = aSEConnectionInfo.getDiscoveryProperties();
            Object v = object.get("serverName");
            if (v == null) {
                v = object.get("clusterName");
            }
            String string = this._agentServerName = v != null ? v.toString() : "";
        }
        if ((aSEConnectionInfo = this.getConnectionInfo()) != null && aSEConnectionInfo.canAttemptConnection() && !this.isAuthenticated((String)(object = aSEConnectionInfo.getUserName() + "@" + this._agentServerName))) {
            try {
                agentConnection.login((String)object, aSEConnectionInfo.getPassword().toCharArray());
                this.addAuthenticated((String)object, aSEConnectionInfo.getPassword());
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
        }
    }

    public boolean pinged() {
        return this._pinged != -1L;
    }

    public String getLog() throws AgentConnectionException, RemoteException {
        Object object = this.invokeAgentPluginMethod("retrieveServerLog");
        if (object != null) {
            return (String)object;
        }
        return null;
    }

    public String[] getLogFiltered(Integer n, Integer n2, Integer n3, Date date, Date date2, String string, Vector vector, Integer n4, Integer n5, String string2) throws AgentConnectionException, RemoteException {
        if (this.isCluster()) {
            String string3 = this._uafInfo.getName();
            String string4 = "getClusterLogFiltered";
            Object object = this.invokeAgentPluginMethod(string4, new Object[]{string3, null, n, n2, n3, date, date2, string, vector, n4, n5, string2}, new String[]{String.class.getName(), Vector.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Date.class.getName(), Date.class.getName(), String.class.getName(), Vector.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName()});
            if (object != null) {
                return (String[])object;
            }
        } else {
            String string5 = "getASELogFiltered";
            Object object = this.invokeAgentPluginMethod(string5, new Object[]{n, n2, n3, date, date2, string, vector, n4, n5, string2}, new String[]{Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Date.class.getName(), Date.class.getName(), String.class.getName(), Vector.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName()});
            if (object != null) {
                return (String[])object;
            }
        }
        return null;
    }

    public String getServerLogsFilterTimeUnitMessage(String string) {
        if (string.equals("Days")) {
            return ASEUtils.getString("MSG_DAYS");
        }
        if (string.equals("Hours")) {
            return ASEUtils.getString("MSG_HOURS");
        }
        if (string.equals("Minutes")) {
            return ASEUtils.getString("MSG_MINUTES");
        }
        return "";
    }

    public String getServerLogsFilterMessage() {
        Object object;
        String string = "";
        String string2 = this.getServerLogsFilter();
        if (string2.equals("None")) {
            string = ASEUtils.getString("SERVER_PROP_RADB_GET_ALL_LOGS");
        } else if (string2.equals("Lines")) {
            object = new ASEMessageText(ASEUtils.getString("MSG_LAST"), String.valueOf(this.getServerLogsLines()), ASEUtils.getString("SERVER_PROP_LABC_GET_LINES_LOGS"));
            string = ((ASEMessageText)object).toString();
        } else if (string2.equals("Time")) {
            object = new ASEMessageText(ASEUtils.getString("MSG_LAST"), String.valueOf(this.getServerLogsTime()), this.getServerLogsFilterTimeUnitMessage(this.getServerLogsTimeUnit()));
            string = ((ASEMessageText)object).toString();
        }
        object = this.getServerLogsRegex();
        if (object != null && ((String)object).length() > 0) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_REGULAR_EXPRESSION"), object);
            string = string + " " + aSEMessageText.toString();
        }
        return string;
    }

    public String[] getLogEntries() throws AgentConnectionException, RemoteException {
        String string = this.getServerLogsFilter();
        String string2 = this.getServerLogsRegex();
        if (string.equals("None")) {
            return this.getLogFiltered(null, null, null, null, null, null, null, null, null, string2);
        }
        if (string.equals("Lines")) {
            Integer n = new Integer(this.getServerLogsLines());
            return this.getLogFiltered(null, null, null, null, null, null, null, null, n, string2);
        }
        int n = this.getServerLogsTime();
        String string3 = this.getServerLogsTimeUnit();
        long l = 86400000L;
        if (string3.equals("Minutes")) {
            l = 60000L;
        } else if (string3.equals("Hours")) {
            l = 3600000L;
        } else if (string3.equals("Days")) {
            l = 86400000L;
        }
        l = (long)n * l;
        Date date = new Date();
        long l2 = date.getTime();
        Date date2 = new Date(l2 - l);
        return this.getLogFiltered(null, null, null, date2, null, null, null, null, null, string2);
    }

    public String getServerServerName() {
        return this._conn.getServerServerName();
    }

    public String[] getServerServerNames() throws RemoteException, AgentConnectionException {
        return (String[])this.invokeAgentPluginMethod("discoverInterfacesServerNames");
    }

    public String getServerServerName(String string, String string2) throws RemoteException, AgentConnectionException {
        return (String)this.invokeAgentPluginMethod("discoverInterfacesServer", new Object[]{string, string2}, new String[]{String.class.getName(), String.class.getName()});
    }

    public String getServerServerHostPort(String string) throws RemoteException, AgentConnectionException {
        return (String)this.invokeAgentPluginMethod("discoverInterfacesHostPort", new Object[]{string}, new String[]{String.class.getName()});
    }

    private Object getAgentServiceProperty(String string) throws RemoteException, AgentConnectionException {
        return this.getAgentServiceProperty(string, null);
    }

    private Object getAgentServiceProperty(String string, String string2) throws RemoteException, AgentConnectionException {
        AgentConnection agentConnection = this.getAgentConnection(string2);
        Object object = null;
        if (agentConnection != null && agentConnection.isConnected() && this._uafInfo != null) {
            object = agentConnection.getAgentServiceProperty("EnvironmentDiscoveryService", string);
        }
        return object;
    }

    public Object invokeAgentServiceMethod(String string, String string2, Object[] objectArray, String[] stringArray) throws RemoteException, AgentConnectionException {
        AgentConnection agentConnection = this.getAgentConnection();
        Object object = null;
        if (agentConnection != null && agentConnection.isConnected()) {
            object = agentConnection.invokeAgentServiceMethod(string, string2, objectArray, stringArray);
        }
        return object;
    }

    public Object invokeAgentPluginMethod(int n) throws AgentConnectionException, RemoteException, IOException {
        if (this.isCluster()) {
            if (n == 3075) {
                return this.invokeAgentPluginMethod("restart");
            }
            if (n == 3076) {
                String string = this.getUAFInfo().getName();
                String string2 = "";
                if (this.isLocalInstallation()) {
                    String string3 = "";
                    try {
                        string3 = this.getClusterConfigXML();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Object[] objectArray = new Object[]{string, string2, new Boolean(false), string3, null};
                    String[] stringArray = new String[]{String.class.getName(), String.class.getName(), Boolean.class.getName(), String.class.getName(), MessageListener.class.getName()};
                    return this.invokeAgentPluginMethod("startCluster", objectArray, stringArray);
                }
                Object[] objectArray = new Object[]{string, string2, null};
                String[] stringArray = new String[]{String.class.getName(), String.class.getName(), MessageListener.class.getName()};
                return this.invokeAgentPluginMethod("startCluster", objectArray, stringArray);
            }
            if (n == 3078) {
                String string = this.getUAFInfo().getName();
                Integer n2 = new Integer(0);
                Date date = new Date();
                Object[] objectArray = new Object[]{string, n2, date, null};
                String[] stringArray = new String[]{String.class.getName(), Integer.class.getName(), Date.class.getName(), MessageListener.class.getName()};
                Object object = this.invokeAgentPluginMethod("stopCluster", objectArray, stringArray);
                return object;
            }
            if (n == 3079) {
                return this.invokeAgentPluginMethod("ping");
            }
            return null;
        }
        if (n == 3075) {
            return this.invokeAgentPluginMethod("restart");
        }
        if (n == 3076) {
            return this.invokeAgentPluginMethod("start");
        }
        if (n == 3078) {
            return this.invokeAgentPluginMethod("stop");
        }
        if (n == 3079) {
            return this.invokeAgentPluginMethod("ping");
        }
        return null;
    }

    public Object invokeAgentPluginMethod(String string, Object[] objectArray, String[] stringArray) throws RemoteException, AgentConnectionException {
        return this.invokeAgentPluginMethod(string, objectArray, stringArray, null);
    }

    private Object invokeAgentPluginMethod(String string, Object[] objectArray, String[] stringArray, String string2) throws RemoteException, AgentConnectionException {
        AgentConnection agentConnection = this.getAgentConnection(string2);
        Object object = null;
        if (agentConnection != null && agentConnection.isConnected() && this._uafInfo != null) {
            String string3 = this.isCluster() ? SyUAF.SDC_PLUGIN_ID : SyUAF.ASE_PLUGIN_ID;
            object = agentConnection.invokeAgentPluginMethod(string3, this._uafInfo.getPluginVersion(), this._uafInfo.getInstanceNumber(), string, objectArray, stringArray);
        }
        return object;
    }

    protected Object invokeAgentPluginMethod(String string) throws RemoteException, AgentConnectionException {
        return this.invokeAgentPluginMethod(string, null, null);
    }

    private void setStatus(String string) {
        if (this.isUAFMonitored()) {
            this._uafInfo.setStatus(string);
            this.load();
        }
    }

    private String getConnected() {
        String string = ASEUtils.getString("MSG_YES");
        String string2 = ASEUtils.getString("MSG_NO");
        return this.getConnection() == null ? string2 : string;
    }

    public String getStatus() {
        String string = ASEUtils.getString("MSG_NOT_APPLICABLE");
        if (this.isUAFMonitored() && this._uafInfo.getStatus() != null && this._uafInfo.getStatus().length() > 0) {
            String string2 = this._uafInfo.getStatus();
            string = ASEUtils.getString("MSG_UNKNOWN");
            if (string2.equalsIgnoreCase("RUNNING")) {
                string = ASEUtils.getString("MSG_RUNNING");
            } else if (string2.equalsIgnoreCase("STOPPED")) {
                string = ASEUtils.getString("MSG_STOPPED");
            }
        } else if (this._conn != null) {
            string = ASEUtils.getString("MSG_RUNNING");
        }
        return string;
    }

    public String getVersion() {
        if (this.getConnection() == null) {
            if (this.isUAFMonitored() && this._uafInfo.getVersionNumber().length() > 0) {
                return this._uafInfo.getVersionNumber();
            }
            return ASEUtils.getString("MSG_NOT_APPLICABLE");
        }
        return this.getConnection().getVersion();
    }

    public String getAgentPlatformAndOS() {
        String string = this.getPlatform();
        String string2 = this.getOperatingSystem();
        return string.length() > 0 && string2.length() > 0 ? string + "/" + string2 : ASEUtils.getString("MSG_NOT_APPLICABLE");
    }

    public String getPlatform() {
        if (this.isUAFMonitored() && this._uafInfo.getHostPlatform().length() > 0) {
            return this._uafInfo.getHostPlatform();
        }
        if (this.getConnection() != null) {
            return this.getConnection().getPlatform();
        }
        return "";
    }

    public String getAgentPlatform() {
        return this.isUAFMonitored() ? this._uafInfo.getAgentPlatform() : "";
    }

    public String getBuildPlatform() {
        if (this.isUAFMonitored() && this._uafInfo.getBuildPlatform().length() > 0) {
            return this._uafInfo.getBuildPlatform();
        }
        if (this.getConnection() != null) {
            return this.getConnection().getPlatform();
        }
        return "";
    }

    public String getHostPlatform() {
        return this.isUAFMonitored() ? this._uafInfo.getHostPlatform() : "";
    }

    public String getHostOperatingSystem() {
        return this.isUAFMonitored() ? this._uafInfo.getHostOperatingSystem() : "";
    }

    public String getReleaseType() {
        if (this.getConnection() == null) {
            return this.isUAFMonitored() ? this._uafInfo.getReleaseType() : "";
        }
        return this.getConnection().getReleaseType();
    }

    public String getServerType() {
        if (this.getConnection() == null) {
            return this.isUAFMonitored() ? this._uafInfo.getServerType() : "";
        }
        return this.getConnection().getServerType();
    }

    public String getOperatingSystem() {
        if (this.isUAFMonitored() && this._uafInfo.getHostOperatingSystem().length() > 0) {
            return this._uafInfo.getHostOperatingSystem();
        }
        if (this.getConnection() != null) {
            return this.getConnection().getOperatingSystem();
        }
        return "";
    }

    public String getBuildOperatingSystem() {
        if (this.isUAFMonitored() && this._uafInfo.getBuildOperatingSystem().length() > 0) {
            return this._uafInfo.getBuildOperatingSystem();
        }
        if (this.getConnection() != null) {
            return this.getConnection().getOperatingSystem();
        }
        return "";
    }

    public String getBuild1() {
        if (this.getConnection() == null) {
            return this.isUAFMonitored() ? this._uafInfo.getBuild1() : "";
        }
        return this.getConnection().getBuild1();
    }

    public String getBuild2() {
        if (this.getConnection() == null) {
            return this.isUAFMonitored() ? this._uafInfo.getBuild2() : "";
        }
        return this.getConnection().getBuild2();
    }

    public String getBuildDate() {
        if (this.getConnection() == null) {
            return this.isUAFMonitored() ? this._uafInfo.getBuildDate() : "";
        }
        return this.getConnection().getBuildDate();
    }

    public String getHostName() {
        if (this.getConnection() == null) {
            return this._info.host;
        }
        return this.getConnection().getHostName();
    }

    public boolean isLocal() {
        return ASConnection.isServerLocal(this.getHostName());
    }

    public String getHostAndPortNumber() {
        String string = this.getConnection() == null ? Utils.getHostAndPort((String)this._info.host, (int)this._info.port) : this.getConnection().getHostNameAndPortNumber();
        if (this.isSSL()) {
            string = string + ",ssl";
        }
        return string;
    }

    public String getPortNumber() {
        if (this.getConnection() == null) {
            if (this._info.port == -1) {
                return null;
            }
            return String.valueOf(this._info.port);
        }
        return this.getConnection().getPortNumber();
    }

    public String updateActiveHostPort() {
        return null;
    }

    @Override
    public void remove() throws SQLException {
        if (this._serverGroupSO != null) {
            this._serverGroupSO.deleteServer(this);
        }
    }

    public void cut() {
        if (this._serverGroupSO != null) {
            this._serverGroupSO.cutServer(this);
        }
    }

    @Override
    public synchronized void create() throws SQLException {
        if (this._serverGroupSO != null) {
            this._serverGroupSO.addServer(this.getName(), this.getConnectionInfo());
        }
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public void setConnInfoServerName(String string) {
        this._info.setServerName(string);
    }

    @Override
    public String getDisplayName() {
        String string;
        if (this._conn != null) {
            return this._conn.getDisplayName();
        }
        boolean bl = this._info != null && this._info.getUserName() != null && this._info.getUserName().length() > 0;
        boolean bl2 = this._info != null && this._info.getServerName() != null;
        String string2 = string = bl2 ? this._info.getServerName() : this.getName();
        if (bl) {
            string = string + " (" + this._info.getUserName() + ")";
        }
        return string;
    }

    @Override
    public String getFullyQualifiedName() {
        String string = this.getDisplayName();
        if (this.getServerGroup() != null) {
            string = this.getServerGroup().getName() + "." + string;
        }
        return string;
    }

    public ServerGroupSO getServerGroup() {
        return this._serverGroupSO;
    }

    public boolean copyToServerGroup(ServerGroupSO serverGroupSO) {
        boolean bl = this._serverGroupSO.copyServer(this, serverGroupSO);
        if (bl) {
            this._serverGroupSO = serverGroupSO;
        }
        return bl;
    }

    public void moveToServerGroup(ServerGroupSO serverGroupSO) {
        boolean bl = this._serverGroupSO.copyServer(this, serverGroupSO);
        if (bl) {
            try {
                this.remove();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._serverGroupSO = serverGroupSO;
        }
    }

    public void addToServerGroup(ServerGroupSO serverGroupSO) {
        this._serverGroupSO = serverGroupSO;
        try {
            this.create();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean isUAFMonitored() {
        return this._uafInfo != null;
    }

    public boolean isCluster() {
        ASConnection aSConnection = this.getConnection();
        if (this._uafInfo != null) {
            return this._uafInfo.isCluster();
        }
        if (aSConnection != null) {
            return aSConnection.isCluster();
        }
        return false;
    }

    public boolean isRunning() {
        boolean bl;
        boolean bl2 = bl = this.isUAFMonitored() && this._uafInfo.isRunning();
        if (this.isVCSMode() && !bl) {
            try {
                if (null != this._uafInfo && (bl = this.getClusterStatusFromQuorum(this._uafInfo.getName()).equalsIgnoreCase("up"))) {
                    this._uafInfo.setStatus("RUNNING");
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public String getUserName() {
        return this._conn != null ? this._conn.getUser() : this._info.getUserName();
    }

    public String getPassword() {
        return this._conn != null ? this._conn.getPassword() : this._info.getPassword();
    }

    public void shutdownNoWait() throws SQLException {
        if (this._conn.isCluster()) {
            String string = SQLs.getString("shutdown {0} with nowait", "cluster");
            this._conn.executeCommand(string, false);
        } else {
            this._conn.executeCommand("shutdown with nowait", false);
        }
    }

    public void shutdown() throws SQLException {
        if (this._conn.isCluster()) {
            String string = SQLs.getString("shutdown {0}", "cluster");
            this._conn.executeCommand(string, false);
        } else {
            this._conn.executeCommand("shutdown ", false);
        }
    }

    @Override
    public Object[] getAttributes() {
        return this._attrs;
    }

    public void setCISRPCHandler(String string) throws SQLException {
        this._conn.executeCommand(SQLs.getString("set cis_rpc_handling {0}", string));
    }

    public void applyDefaultExpansionPolicy() throws SQLException {
        this.useMasterDB();
        this._conn.executeCommand("exec sp_dbextend 'reload defaults'");
    }

    public void disableServerExpansion() throws SQLException {
        this._conn.executeCommand("exec sp_dbextend 'disable','database','server-wide'");
    }

    public void enableServerExpansion() throws SQLException {
        this._conn.executeCommand("exec sp_dbextend 'enable','database','server-wide'");
    }

    public void expansionTraceOn() throws SQLException {
        this._conn.executeCommand("exec sp_dbextend 'trace','on'");
    }

    public void expansionTraceOff() throws SQLException {
        this._conn.executeCommand("exec sp_dbextend 'trace','off'");
    }

    public boolean isExpansionEnabled() throws SQLException {
        this.getRSet().open("exec sp_dbextend 'list','database','server-wide'");
        while (this.getRSet().getNextRow()) {
            if (!this.getRSet().getColumnString("name").equals("server-wide") || !this.getRSet().getColumnString("status").equals("enabled")) continue;
            return true;
        }
        return false;
    }

    public boolean isExpansionTraceOn() throws SQLException {
        this.getRSet().open("select low from master.dbo.spt_values where type = 'XT' and name = 'tracelevel' ");
        while (this.getRSet().getNextRow()) {
            if (!this.getRSet().getColumnString(1).equals("1")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_SERVER_TEXT");
    }

    public boolean isMsgProcsInstalled() throws SQLException {
        this.getRSet().open("select name from sybsystemprocs..sysobjects where name = 'sp_msgadmin' and type = 'P'");
        boolean bl = this.getRSet().getNextRow();
        this.getRSet().close();
        return bl;
    }

    public int compareTo(Object object) {
        int n = this.toString().compareTo(object.toString());
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public String getIPAndPort() {
        return Utils.getIPAndPort((String)this.getHostName(), (String)this.getPortNumber());
    }

    public String getIP() {
        return Utils.getIP((String)this.getHostName());
    }

    public static String getServerName(ASEConnectionInfo aSEConnectionInfo) {
        return ServerSO.getServerName(aSEConnectionInfo.getServerName(), aSEConnectionInfo.host, String.valueOf(aSEConnectionInfo.port));
    }

    public static String getServerName(String string, String string2, String string3) {
        String string4 = string == null ? Utils.getHostAndPort((String)string2, (String)string3) : string;
        return string4;
    }

    public static SyUAFASEEntry getDiscoveredServer(String string, String string2) {
        Object v = _discoveredServers.get(Utils.getIPAndPort((String)string, (String)string2));
        return v == null ? null : (SyUAFASEEntry)v;
    }

    public static SyUAFASEEntry getDiscoveredSDCNode(String string, String string2) {
        String string3 = Utils.getIP((String)string2);
        Enumeration enumeration = _discoveredServers.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string4.indexOf(string3) != 0) continue;
            SyUAFASEEntry syUAFASEEntry = (SyUAFASEEntry)_discoveredServers.get(string4);
            AgentInfo agentInfo = syUAFASEEntry.getAgentInfo();
            try {
                List list = agentInfo.getPluginInfos("com.sybase.ase.cluster");
                for (PluginInfo pluginInfo : list) {
                    String string5 = (String)pluginInfo.getDiscoveryProperty("clusterName");
                    String string6 = (String)pluginInfo.getDiscoveryProperty("hostPorts");
                    if (!string.equals(string5) && string6.indexOf(string) <= -1) continue;
                    return syUAFASEEntry;
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static boolean containsDiscoveredHost(String string) {
        return _discoveredHosts.contains(Utils.getIP((String)string));
    }

    public static boolean containsDiscoveredServers(String string, String string2) {
        String string3 = Utils.getIPAndPort((String)string, (String)string2);
        return _discoveredServers.containsKey(string3);
    }

    public static void addDiscoveredServer(String string, String string2, SyUAFASEEntry syUAFASEEntry) {
        _discoveredHosts.add(Utils.getIP((String)string));
        _discoveredServers.put(Utils.getIPAndPort((String)string, (String)string2), syUAFASEEntry);
    }

    public static void removeDiscoveredServer(String string, String string2) {
        _discoveredHosts.remove(Utils.getIP((String)string));
        _discoveredServers.remove(Utils.getIPAndPort((String)string, (String)string2));
    }

    public static Collection getDiscoveredServers() {
        return _discoveredServers.values();
    }

    public static void setDefaultAgentPort(String string) {
        _defaultAgentPort = string == null || string.equals("0") ? "9999" : string;
    }

    @Override
    public SOItemInterface duplicate() {
        ServerSO serverSO = new ServerSO(this._info, this._serverGroupSO, this._uafInfo);
        return serverSO;
    }

    public boolean getConnectAtStartup() {
        return this._serverGroupSO.getConnectAtStartup(this);
    }

    public void setConnectAtStartup(boolean bl) {
        this._serverGroupSO.setConnectAtStartup(this, bl);
    }

    public String getLastServerFolder() {
        return this._serverGroupSO.getServerLastFolder(this.getName(), this.getUserName());
    }

    public void setLastServerFolder(String string) {
        if (string != null) {
            this._serverGroupSO.setServerLastFolder(this, string);
        }
    }

    public String getServerLogsFilter() {
        return this._serverGroupSO.getServerLogsFilter(this);
    }

    public void setServerLogsFilter(String string) {
        this._serverGroupSO.setServerLogsFilter(this, string);
    }

    public int getServerLogsLines() {
        return this._serverGroupSO.getServerLogsLines(this);
    }

    public void setServerLogsLines(int n) {
        this._serverGroupSO.setServerLogsLines(this, n);
    }

    public int getServerLogsTime() {
        return this._serverGroupSO.getServerLogsTime(this);
    }

    public void setServerLogsTime(int n) {
        this._serverGroupSO.setServerLogsTime(this, n);
    }

    public String getServerLogsTimeUnit() {
        return this._serverGroupSO.getServerLogsTimeUnit(this);
    }

    public void setServerLogsTimeUnit(String string) {
        this._serverGroupSO.setServerLogsTimeUnit(this, string);
    }

    public String getServerLogsRegex() {
        return this._serverGroupSO.getServerLogsRegex(this);
    }

    public void setServerLogsRegex(String string) {
        this._serverGroupSO.setServerLogsRegex(this, string);
    }

    public ArrayList getServerLogsExps() {
        return this._serverGroupSO.getServerLogsExps(this);
    }

    public void setServerLogsExps(ArrayList arrayList) {
        this._serverGroupSO.setServerLogsExps(this, arrayList);
    }

    public ArrayList getServerLogsAgentExps() {
        return this._serverGroupSO.getServerLogsAgentExps(this);
    }

    public void addServerLogsAgentExp(RegExpression regExpression) {
        this._serverGroupSO.addServerLogsAgentExp(this, regExpression);
    }

    public Object[] getIOFencingCheckResult(AgentConnection agentConnection, String string, String string2) throws RemoteException, JMXException {
        String[] stringArray;
        String string3;
        Object[] objectArray;
        Integer n;
        Object[] objectArray2 = new Object[]{null, ASEUtils.getString("MSG_NOT_APPLICABLE")};
        if (string == null || string.length() == 0) {
            string = this.getASEHome();
        }
        if (null != (n = this.validateDeviceForIOFencing(agentConnection, objectArray = new Object[]{(string3 = string + "/bin/" + "iofenceutil") + " " + string2}, stringArray = new String[]{"java.lang.String"}))) {
            if (n == 1) {
                objectArray2[0] = new Boolean(true);
                objectArray2[1] = ASEUtils.getString("SDC_MSG_DEVICE_NOT_SUPPORT_IOFENCING");
            } else if (n != 0) {
                objectArray2[0] = new Boolean(true);
                objectArray2[1] = ASEUtils.getString("SDC_MSG_IOFENCING_OPERATION_FAILED");
            }
        }
        return objectArray2;
    }

    public Object[] getIOFencingCheckResult(String string) throws RemoteException, JMXException {
        return this.getIOFencingCheckResult(null, null, string);
    }

    public String getASEHome() throws RemoteException {
        PluginInfo pluginInfo;
        if (null == this._aseHome && (pluginInfo = this.getPluginInfo()) != null) {
            this._aseHome = (String)pluginInfo.getDiscoveryProperty("ASEHome");
            if (this._aseHome == null || this._aseHome.length() == 0) {
                this._aseHome = (String)pluginInfo.getDiscoveryProperty("aseHome");
            }
        }
        return this._aseHome;
    }

    private Integer validateDeviceForIOFencing(AgentConnection agentConnection, Object[] objectArray, String[] stringArray) throws RemoteException, JMXException {
        ProcessInfo processInfo = null;
        Integer n = null;
        processInfo = agentConnection != null ? (ProcessInfo)agentConnection.invokeAgentServiceMethod("RemoteShellService", "executeWait", objectArray, stringArray) : (ProcessInfo)this.invokeAgentServiceMethod("RemoteShellService", "executeWait", objectArray, stringArray);
        if (null != processInfo) {
            n = new Integer(processInfo.getExitValue());
        }
        return n;
    }

    public Properties getDefaultLocalization(MessageListener messageListener) throws AgentConnectionException, RemoteException {
        Object[] objectArray = new Object[]{messageListener};
        String[] stringArray = new String[]{"com.sybase.ua.util.MessageListener"};
        return (Properties)this.invokeAgentPluginMethod("getDefaultLocalization", objectArray, stringArray);
    }

    public HashMap getAllLocaleInformation(MessageListener messageListener) throws AgentConnectionException, RemoteException {
        Object[] objectArray = new Object[]{messageListener};
        String[] stringArray = new String[]{"com.sybase.ua.util.MessageListener"};
        return (HashMap)this.invokeAgentPluginMethod("getAllLocaleInformation", objectArray, stringArray);
    }

    public int configureLocale(String string, String string2, String string3, List list, List list2, MessageListener messageListener) throws JDOMException, IOException, SQLException, ClusterConfigException {
        ICluster iCluster = this.getClusterConfiguration();
        if (this.isLocalInstallation()) {
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
        }
        String string4 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        Object[] objectArray = new Object[]{string4, string, string2, string3, list, list2, messageListener};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.List", "java.util.List", "com.sybase.ua.util.MessageListener"};
        Integer n = (Integer)this.invokeAgentPluginMethod("configureLocale", objectArray, stringArray);
        return n;
    }

    public int getEventBuffers() throws SQLException {
        String string = SQLs.getString("exec sp_configure ''{0}''", "event buffers per engine");
        this.getRSet().open(string);
        this.getRSet().getNextRow();
        int n = this.getRSet().getColumnInt(4);
        this.getRSet().close();
        return n;
    }

    public void setEventBuffers(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_configure ''{0}'', {1}", "event buffers per engine", string);
        this._conn.executeCommand(string2);
    }

    public int getMaxMemory() throws SQLException {
        String string = SQLs.getString("exec sp_configure ''{0}''", "max memory");
        this.getRSet().open(string);
        this.getRSet().getNextRow();
        int n = this.getRSet().getColumnInt(4);
        this.getRSet().close();
        return n;
    }

    public void setMaxMemory(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_configure ''{0}'', {1}", "max memory", string);
        this._conn.executeCommand(string2);
    }

    public Vector getActivationRoles() throws SQLException {
        Vector vector = new Vector();
        try {
            String string = SQLs.getString("select sr.name, proc_role(sr.name), lr.status, sr.password from master.dbo.sysloginroles lr, master.dbo.syslogins l, master.dbo.syssrvroles sr where lr.suid = l.suid and role_name(lr.srid)=sr.name and l.name = ''{0}''", this.getConnection().getCurrentUser());
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement(this.getRSet().getColumnString(1));
                if (this.getRSet().getColumnInt(2) > 0) {
                    vector2.addElement(ASEUtils.getString("MSG_YES"));
                } else {
                    vector2.addElement(ASEUtils.getString("MSG_NO"));
                }
                if (this.getRSet().getColumnInt(3) == 1) {
                    vector2.addElement(ASEUtils.getString("MSG_YES"));
                } else {
                    vector2.addElement(ASEUtils.getString("MSG_NO"));
                }
                String string2 = this.getRSet().getColumnString(4);
                if (string2 == null || string2.trim().length() == 0) {
                    vector2.addElement(ASEUtils.getString("MSG_NO"));
                } else {
                    vector2.addElement(ASEUtils.getString("MSG_YES"));
                }
                vector.addElement(vector2);
            }
        }
        catch (SQLException sQLException) {
            Vector<String> vector3 = new Vector<String>();
            this.getRSet().open("exec sp_displayroles");
            while (this.getRSet().getNextRow()) {
                String string = this.getRSet().getColumnString(1);
                vector3.addElement(string);
            }
            this.getRSet().close();
            for (int i = 0; i < vector3.size(); ++i) {
                Vector<String> vector4 = new Vector<String>();
                String string = (String)vector3.elementAt(i);
                vector4.addElement(string);
                String string3 = SQLs.getString("select proc_role(''{0}'')", string);
                this.getRSet().open(string3);
                this.getRSet().getNextRow();
                int n = this.getRSet().getColumnInt(1);
                this.getRSet().close();
                if (n > 0) {
                    vector4.addElement(ASEUtils.getString("MSG_YES"));
                } else {
                    vector4.addElement(ASEUtils.getString("MSG_NO"));
                }
                vector.addElement(vector4);
            }
        }
        return vector;
    }

    public String getInstallationMode() throws RemoteException, IOException {
        ICluster iCluster = this.getCluster();
        if (null != iCluster) {
            return iCluster.getInstallationMode();
        }
        return "shared";
    }

    public boolean isLocalInstallation() throws RemoteException, IOException {
        return this.getInstallationMode().equalsIgnoreCase("private");
    }

    public IServer getServerByInstanceName(String string) throws RemoteException, IOException {
        ICluster iCluster = this.getCluster();
        if (null != iCluster) {
            return iCluster.getServer(string);
        }
        return null;
    }

    public String getServerSybaseHome() throws RemoteException, IOException {
        IServer iServer = this.getServerByInstanceName(this.getName());
        if (null != iServer) {
            return iServer.getSybaseHome();
        }
        return "";
    }

    public String getServerASEHome() throws RemoteException, IOException {
        IServer iServer = this.getServerByInstanceName(this.getName());
        if (null != iServer) {
            return iServer.getAseHome();
        }
        return "";
    }

    public String getServerEnvShellPath() throws RemoteException, IOException {
        IServer iServer = this.getServerByInstanceName(this.getName());
        if (null != iServer) {
            return iServer.getEnvShellPath();
        }
        return "";
    }

    public String getServerConfigFile() throws RemoteException, IOException {
        IServer iServer = this.getServerByInstanceName(this.getName());
        if (null != iServer) {
            return iServer.getConfigFile();
        }
        return "";
    }

    public String getServerInterfacesPath() throws RemoteException, IOException {
        IServer iServer = this.getServerByInstanceName(this.getName());
        if (null != iServer) {
            return iServer.getInterfacesPath();
        }
        return "";
    }

    public boolean hasAuthToGetClusterCfg() {
        String string = String.class.getName() + "," + Integer.class.getName();
        return new Boolean(this.hasAccess("getClusterConfiguration", string, "execute"));
    }

    public boolean hasAuthToGetMembershipMode() {
        String string = "";
        return new Boolean(this.hasAccess("getMembershipMode", "", "execute"));
    }

    public Object startCluster(SDCMessageListener sDCMessageListener) throws AgentConnectionException, RemoteException, ClusterConfigException, IOException {
        String string = this.getUAFInfo().getName();
        if (this.isLocalInstallation()) {
            ICluster iCluster = this.getCluster();
            this.setClusterAgentPort(iCluster, this._uafInfo.getRMIPort());
            String string2 = XMLCluster.getXMLClusterString((ICluster)iCluster);
            Object[] objectArray = new Object[]{string, new Boolean(false), string2, sDCMessageListener};
            String[] stringArray = new String[]{String.class.getName(), Boolean.class.getName(), String.class.getName(), MessageListener.class.getName()};
            return this.invokeAgentPluginMethod("startCluster", objectArray, stringArray);
        }
        Object[] objectArray = new Object[]{string, sDCMessageListener};
        String[] stringArray = new String[]{String.class.getName(), MessageListener.class.getName()};
        return this.invokeAgentPluginMethod("startCluster", objectArray, stringArray);
    }

    public ICluster getCluster() throws RemoteException, IOException {
        if (this._cluster == null) {
            this._cluster = XMLCluster.getICluster((String)this.getClusterConfigXML(true));
        }
        return this._cluster;
    }

    public void setClusterAgentPort(ICluster iCluster, String string) {
        IServer[] iServerArray = iCluster.getServersArray();
        String string2 = iCluster.getName();
        for (int i = 0; i < iServerArray.length; ++i) {
            iServerArray[i].setAgentPort(string);
        }
    }

    public String getLDAPSever() throws AgentConnectionException, RemoteException {
        Object var1_1 = null;
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        return (String)this.invokeAgentPluginMethod("getLDAPServer", objectArray, stringArray);
    }

    private String getMembershipModeFromAgent() throws Exception {
        return (String)this.invokeAgentPluginMethod("getMembershipMode", null, null);
    }

    private String getMembershipModeFromDB() throws SQLException {
        this.getRSet().open("select @@membershipmode");
        this.getRSet().getNextRow();
        String string = this.getRSet().getColumnString(1);
        this.getRSet().close();
        return string;
    }

    public String getMembershipMode() {
        String string = null;
        try {
            if (this.isCluster()) {
                if (this.getConnection() != null) {
                    string = this.getMembershipModeFromDB();
                } else if (this.isUAFMonitored()) {
                    string = this.getMembershipModeFromAgent();
                }
            }
            if (null == string || string.length() == 0) {
                string = "native";
            }
        }
        catch (Exception exception) {
            string = "native";
        }
        return string;
    }

    public boolean isVCSMode() {
        String string = this.getMembershipMode();
        return string.equalsIgnoreCase("vcs");
    }

    public boolean isManagedByVCS(String string) throws RemoteException, JMXException {
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        return (Boolean)this.invokeAgentPluginMethod("isManagedByVCS", objectArray, stringArray);
    }

    public String[] getEachInstancesName(ICluster iCluster) {
        IServer[] iServerArray = iCluster.getServersArray();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < iServerArray.length; ++i) {
            vector.addElement(iServerArray[i].getName().trim());
        }
        return this.getVectorToArray(vector);
    }

    public Properties getInstanceProperties(String string, String string2) throws AgentPluginException, RemoteException {
        Object[] objectArray = new Object[]{string, string2};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        return (Properties)this.invokeAgentPluginMethod("getInstanceProperties", objectArray, stringArray);
    }

    public String[] getVectorToArray(Vector vector) {
        return Utility.getVectorToArray(vector);
    }

    public String getClusterStatusFromQuorum(String string) throws AgentConnectionException, RemoteException {
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        return (String)this.invokeAgentPluginMethod("getClusterStatusFromQuorum", objectArray, stringArray);
    }
}

