/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.RepArticleSO;
import com.sybase.aseplugin.so.ReplicationStatusSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SubscriptionSO
extends ReplicationStatusSO {
    ConnectionSO _connSO = null;
    protected String _ds = null;
    protected String _db = null;
    protected String _name;
    protected String _publication = null;
    protected boolean _allArticles = false;
    protected boolean _materializeAll = false;
    protected boolean _validateAll = false;

    public SubscriptionSO(ASConnection aSConnection, String string, ConnectionSO connectionSO) {
        super(aSConnection);
        Debug.wassert(aSConnection != null, this, "Null network connection parameter");
        this._connSO = connectionSO;
    }

    public ConnectionSO getConnectionSO() {
        return this._connSO;
    }

    public synchronized String getDDB() {
        return this.getConnectionSO().getDDB();
    }

    @Override
    public String getDisplayName() {
        return this._name;
    }

    public String getLongName() {
        return this.getDisplayName();
    }

    public void load(ASResultSet aSResultSet) throws SQLException {
        Debug.wassert(aSResultSet != null, this, "Null result set");
        this._ds = aSResultSet.getColumnString(1);
        if (this._ds == null || this._ds.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_SUB_DS_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._db = aSResultSet.getColumnString(2);
        if (this._db == null || this._db.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_SUB_DB_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._name = aSResultSet.getColumnString(3);
        if (this._name == null || this._name.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_SUB_NAME_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._publication = aSResultSet.getColumnString(6);
        if (this._publication == null || this._publication.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_SUB_PUB_NAME_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        int n = aSResultSet.getColumnInt(4);
        if (n != 1 && n != 0 && n != -1 && n != 3) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_SUB_STATUS_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this.setState(n);
        this.setReasonCode(aSResultSet.getColumnString(5));
    }

    @Override
    public void create() throws SQLException {
        String string = this.getServer();
        Debug.wassert(string != null && string.length() > 0, this, "Server name is null or blank");
        String string2 = this.getDatabase();
        Debug.wassert(string2 != null && string2.length() > 0, this, "Database name is null or blank");
        Object[] objectArray = new String[]{this.getDDB(), string, string2, this.getPublication(), this.getDisplayName()};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string3 = rLSQLResourceBundle.getString("CREATE_SUBSCRIPTION", objectArray);
        this.getConnection().executeCommand(string3);
    }

    @Override
    public void remove() throws SQLException {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("DROP_SUBSCRIPTION", this.getDDB(), this.getDisplayName());
        this.getConnection().executeCommand(string);
    }

    public void setSubName(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty subscription name");
        this._name = string;
    }

    public String getServer() {
        return this._ds;
    }

    public void setServer(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty data server name");
        this._ds = string;
    }

    public String getDatabase() {
        return this._db;
    }

    public void setDatabase(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty database name");
        this._db = string;
    }

    public void setPublication(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty publication name");
        this._publication = string;
    }

    public String getPublication() {
        return this._publication;
    }

    public void setAllArticles(boolean bl) {
        this._allArticles = bl;
    }

    public boolean isAllArticles() {
        return this._allArticles;
    }

    public void setMaterializeAll(boolean bl) {
        this._materializeAll = bl;
    }

    public boolean isMaterializeAll() {
        return this._materializeAll;
    }

    public void setValidateAll(boolean bl) {
        this._validateAll = bl;
    }

    public boolean isValidateAll() {
        return this._validateAll;
    }

    public String resume() {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("RESUME_SUB", this.getDDB(), this.getDisplayName());
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        return string;
    }

    public String suspend() {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("SUSPEND_SUB", this.getDDB(), this.getDisplayName());
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        return string;
    }

    public void doMaterialize() throws Exception {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("MATERIALIZE_SUB", this.getDDB(), this.getDisplayName());
        Support.getViewerSupport().startWait();
        this.getConnection().executeCommand(string);
        Support.getViewerSupport().endWait();
    }

    public void doValidate() throws Exception {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("VALIDATE_SUB", this.getDDB(), this.getDisplayName());
        Support.getViewerSupport().startWait();
        this.getConnection().executeCommand(string);
        Support.getViewerSupport().endWait();
    }

    public void submitCmds(Vector vector) throws Exception {
        Debug.wassert(vector != null && vector.size() > 0, "Null or empty command list parameter");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Support.getViewerSupport().startWait();
            this.getConnection().executeCommand(string);
            Support.getViewerSupport().endWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getSubscriptions(ASConnection aSConnection, String string, String string2, String string3, ConnectionSO connectionSO) throws SQLException {
        Debug.wassert(aSConnection != null, "Null connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty ddb parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter");
        Vector<SubscriptionSO> vector = new Vector<SubscriptionSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_SUBSCRIPTIONS", string, string2, string3));
            while (aSResultSet.getNextRow()) {
                SubscriptionSO subscriptionSO = new SubscriptionSO(aSConnection, string, connectionSO);
                subscriptionSO.load(aSResultSet);
                vector.addElement(subscriptionSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List open(int n, Object[] objectArray) throws SQLException {
        Debug.trace(this, "Open Subscription - " + this.getDisplayName());
        Vector<RepArticleSO> vector = new Vector<RepArticleSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("QUERY_REP_ARTICLES", this.getDDB(), this.getName());
        try {
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                String string2 = RepArticleSO.formatName(this.getRSet().getColumnString(4), this.getRSet().getColumnString(5));
                Debug.wassert(string2 != null && string2.length() > 0, "Invalid Rep Article Name from DDB");
                RepArticleSO repArticleSO = new RepArticleSO(this.getConnection(), this.getDDB());
                repArticleSO.load(this.getRSet());
                vector.addElement(repArticleSO);
            }
        }
        finally {
            try {
                this.getRSet().close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("SUB_PROP_DISP_TYPE");
    }
}

