/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAUtils;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.DefaultBO;
import com.sybase.aseplugin.bo.IndexBO;
import com.sybase.aseplugin.bo.RuleBO;
import com.sybase.aseplugin.bo.SegmentBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.UniqueConstraintBO;
import com.sybase.aseplugin.bo.UserTypeBO;
import com.sybase.aseplugin.so.ASEBaseDBItemSO;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.DomainDatatypes;
import com.sybase.aseplugin.so.IndexSO;
import com.sybase.aseplugin.so.PartitionSO;
import com.sybase.aseplugin.so.SOOwnedItemInterface;
import com.sybase.aseplugin.so.SegmentSO;
import com.sybase.aseplugin.so.SegmentsCtrSO;
import com.sybase.aseplugin.so.UniqueConstraintSO;
import com.sybase.aseplugin.so.UniqueConstraintsCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.perm.GroupPermission;
import com.sybase.aseplugin.util.perm.PublicPermission;
import com.sybase.aseplugin.util.perm.RolePermission;
import com.sybase.aseplugin.util.perm.UserPermission;
import com.sybase.util.ds.Utils;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class TableSO
extends ASEBaseDBItemSO
implements DateSorter,
SOOwnedItemInterface {
    public static final int LOCK_ALL_PAGES = 0;
    public static final int LOCK_DATA_PAGES = 1;
    public static final int LOCK_DATA_ROWS = 2;
    public static final int LOCK_SCHEME_FLAG = 8192;
    public static final int PROXY_TABLE_FLAG = 1024;
    public static final int DML_LOGGING_FULL_SYSSTAT3 = 1;
    public static final int DML_LOGGING_MINIMAL_SYSSTAT3 = 2;
    public static final String PROXYTABLE_SYSSTAT2 = "1024";
    public static final String USERTABLE_SYSSTAT2 = "0";
    public static final String TABLE = "table";
    public static final String VIEW = "view";
    public static final String RPC = "rpc";
    private static final String FILE = "file";
    private static final String DIRECTORY = "directory";
    private static final String DMLLOGGING = "dml_logging";
    private static final String FULL = "full";
    private static final String MINIMAL = "minimal";
    private boolean _tbIsProxyTableOnXFS;
    private Boolean _tbIsWebMethodProxyTable;
    private String _boundCache = "";
    private int _lockScheme = -1;
    private int _maxRowsPerPage;
    private int _reservePageGap;
    private int _expectedRowSize;
    private int _fillFactor;
    private String _identityGap = "";
    private String _rowCount = "";
    private String _reservedSpace = "";
    private String _spaceUsedByData = "";
    private String _spaceUsedByIndex = "";
    private String _unusedSpace = "";
    private String _segmentindex = "";
    private boolean _incrementalTransferEnabled = false;
    private Vector _userPermissionList = new Vector();
    private Vector _groupPermissionList = new Vector();
    private Vector _rolePermissionList = new Vector();
    private Vector _grouplistPermissionList = new Vector();
    private Vector _publiclistPermissionList = new Vector();
    private Vector _primaryKeyColumns;
    private Vector _workingColumnSOs;
    private boolean _blnPrimaryKeyModified;
    private String _sPrimaryKeyConstraintName;
    private Vector _tmpAddPrimaryKeys;
    private Vector _tmpDeletePrimaryKeys;
    private Object[] _attrib = new Object[11];
    private String _remSrvName;
    private String _remDBName;
    private Boolean _isComputedColApplicable;
    private String _updateStatSampling = null;
    private String _updateStatSteps = null;
    private boolean _updateStatAllColumns;
    private int _updateStatConsumers = 0;
    private String[] _partitionColumns;
    private String _partitionStrategy;
    private String _partitionSpec;
    private int _noPartitions;
    private int _tempNoPartitions;
    private Vector _partitionSegments;
    boolean _useDataChange = false;
    String _datachangePartition = "";
    int _datachangeThreshold = 0;
    private int _updateStatPartitionType = 1;
    public static final String UPDATE_STATISTICS = "update statistics";
    public static final String UPDATE_INDEX_STATISTICS = "update index statistics";
    public static final String UPDATE_ALL_STATISTICS = "update all statistics";
    public static final String UPDATE_TABLE_STATISTICS = "update table statistics";
    private static final String PARTITION = "partition";
    private String _updateStatType;
    String[] dataFormats = new String[]{"ASE", "BCP", "CSV", "IQ"};
    String[] commandOptions = new String[]{"id", "offset", "name", "name_utf8"};
    String _previousTransferPathname = "";
    String _previousTransferDataFormat = this.dataFormats[0];
    String _previousTransferColumnOrder = this.commandOptions[0];
    String _previousColSeparator = ASEUtils.getString("SEPARATOR_DEFAULT");
    String _previousRowSeparator = ASEUtils.getString("SEPARATOR_DEFAULT");
    String _transferPathname = "";
    String _transferDataFormat = "";
    String _transferColumnOrder = "";
    String _transferDecryption = "";
    String _transferColSeparator = "";
    String _transferRowSeparator = "";
    long _transferTrackingID = -1L;
    long _transferSequenceID = -1L;
    String _transferInPathname = "";

    public TableSO(ASConnection aSConnection, String string, DatabaseSO databaseSO) {
        super(aSConnection, string, databaseSO);
    }

    @Override
    public Date getDate(int n) {
        return (Date)this._attrib[3];
    }

    public String getCreationDate() {
        Date date = (Date)this._attrib[3];
        return DateFormat.getDateTimeInstance(2, 3).format(date);
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getDatabaseName() + "." + this.getOwner() + "." + this.getName();
    }

    public void load(Object[] objectArray) {
        this._attrib = objectArray;
        this._tbIsProxyTableOnXFS = this.isProxyTable() && (this.getRemoteObjectType().equals(FILE) || this.getRemoteObjectType().equals(DIRECTORY));
    }

    public void createProxyTableOnRPC() throws SQLException {
        String string = "create existing table " + this._databaseSO.getName() + "." + this.getOwner() + "." + this.getName() + " " + this.getCreateTableStatementChunk() + "external procedure at '" + this.getRemoteObjectName() + "'";
        this._conn.executeCommand(string);
    }

    public void createExistingProxyTable(String string, String string2) throws SQLException {
        this._conn.executeCommand(SQLs.getString("create proxy_table {0} external table at ''{1}''", string, string2));
    }

    public void createLocalAndRemoteProxyTable() throws SQLException {
        String string = "create table " + this._databaseSO.getName() + "." + this.getOwner() + "." + this.getName() + " " + this.getCreateTableStatementChunk() + "external table at '";
        String string2 = "";
        string2 = this.getRemoteObjectType().equals("gwl") ? this.getRemoteServerName() + "..." + this.getName() + ";" + this.getRemoteDBName() + "'" : this.getRemoteServerName() + "." + this.getRemoteDBName() + "." + this.getRemoteOwnerName() + "." + this.getName() + "'";
        string = string + string2;
        this._conn.executeCommand(string);
        this.setRemoteObjectType(TABLE);
        this.setRemoteObjectName(string2);
    }

    public void setPrimaryKeysRulesDefaults() throws SQLException {
        int n;
        try {
            n = 0;
            for (int i = 0; i < this._workingColumnSOs.size(); ++i) {
                ColumnSO columnSO = (ColumnSO)this._workingColumnSOs.elementAt(i);
                if (columnSO.getTmpPrimaryKey()) {
                    n = 1;
                    columnSO.setPrimaryKey();
                }
                if (columnSO.getTmpRuleName() != null) {
                    columnSO.bindRule(columnSO.getTmpRuleName(), columnSO.getTmpRuleOwner());
                }
                if (columnSO.getTmpDefaultSelection() != 1) continue;
                columnSO.bindDefault(columnSO.getTmpDefaultName(), columnSO.getTmpDefaultOwner());
            }
            if (n != 0) {
                this.alterPrimaryKey();
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            this.remove();
        }
        for (n = 0; n < this._workingColumnSOs.size(); ++n) {
            ColumnSO columnSO = (ColumnSO)this._workingColumnSOs.elementAt(n);
            columnSO.setColumnState(2);
        }
    }

    @Override
    public void create() throws SQLException {
        String string = "create table " + this._databaseSO.getName() + "." + this.getOwner() + "." + this.getName() + " " + this.getCreateTableStatementChunk();
        this._conn.executeCommand(string);
        this.setPrimaryKeysRulesDefaults();
    }

    private String getCreateTableStatementChunk() {
        String string = "( ";
        for (int i = 0; i < this._workingColumnSOs.size(); ++i) {
            ColumnSO columnSO = (ColumnSO)this._workingColumnSOs.elementAt(i);
            if (i != 0 && !string.equals("")) {
                string = string + ", ";
            }
            string = string + columnSO.getTmpColumnName() + " ";
            if (columnSO.getTmpComputedKey()) {
                string = string + "AS " + columnSO.getTmpComputedExpression() + " ";
                if (columnSO.getTmpMaterialized()) {
                    string = string + "MATERIALIZED ";
                }
                if (columnSO.getTmpXStatus() == 0) {
                    string = string + "in row ";
                } else if (columnSO.getTmpXStatus() == 1) {
                    string = string + "off row ";
                }
            } else {
                DomainDatatypes domainDatatypes = this._conn.getDomainDatatypes();
                string = domainDatatypes.hasWidthType(columnSO.getTmpDataType()) ? string + columnSO.getTmpDataType() + "(" + columnSO.getTmpLength() + ")" + " " : (domainDatatypes.hasScaleType(columnSO.getTmpDataType()) ? string + columnSO.getTmpDataType() + "(" + columnSO.getTmpPrecision() + "," + columnSO.getTmpScale() + ")" + " " : string + columnSO.getTmpDataType() + " ");
                if (columnSO.getTmpDefaultSelection() == 2) {
                    string = columnSO.getTmpInlineDefaultText().length() == 0 ? string + "default null " : string + "default " + columnSO.getTmpInlineDefaultText() + " ";
                }
                string = columnSO.getTmpIdentity() ? string + "identity " : (columnSO.getTmpAllowNulls().equals(ColumnSO.YES) ? string + "null " : string + "not null ");
                if (columnSO.getTmpXStatus() == 0) {
                    string = string + "in row ";
                } else if (columnSO.getTmpXStatus() == 1) {
                    string = string + "off row ";
                }
            }
            if (!this.getConnection().isEncryptedKeyEnabled() || !columnSO.getTmpEncrypt()) continue;
            string = string + "encrypt ";
            if (columnSO.getTmpKey().equals(columnSO.defaultKey)) continue;
            string = string + "with " + columnSO.getTmpKey();
        }
        return string + ") ";
    }

    @Override
    public void remove() throws SQLException {
        this._conn.executeCommand(SQLs.getString("drop table {0}.{1}.{2}", this.getDatabaseName(), this.getOwner(), this.getName()));
    }

    public void remove(String[] stringArray) throws SQLException {
        this.useDB();
        String string = Utility.stringArrayToString((Object[])stringArray, false);
        this._conn.executeCommand(SQLs.getString("drop table {0}", string));
    }

    public void alterPrimaryKey() throws SQLException {
        Vector vector = this.getPrimaryKeyColumns();
        Vector vector2 = (Vector)vector.clone();
        if (this._sPrimaryKeyConstraintName != null) {
            Object[] objectArray = new String[]{this.getDatabaseName(), this.getOwner(), this.getName(), this._sPrimaryKeyConstraintName};
            this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} drop constraint {3}", objectArray));
        }
        if (this._tmpAddPrimaryKeys != null) {
            vector.addAll(this._tmpAddPrimaryKeys);
        }
        if (this._tmpDeletePrimaryKeys != null) {
            vector.removeAll(this._tmpDeletePrimaryKeys);
        }
        try {
            this.createPrimaryKey(vector);
        }
        catch (SQLException sQLException) {
            this.createPrimaryKey(vector2);
            this._tmpAddPrimaryKeys = null;
            this._tmpDeletePrimaryKeys = null;
            throw sQLException;
        }
    }

    private void createPrimaryKey(Vector vector) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this._sPrimaryKeyConstraintName;
        if (string == null) {
            string = "";
        }
        stringBuffer.append("alter table").append(" ").append(this.getDatabaseName()).append(".").append(this.getOwner()).append(".").append(this.getName()).append(" ");
        if (this._sPrimaryKeyConstraintName == null) {
            stringBuffer.append("add");
        } else {
            stringBuffer.append("add constraint");
        }
        stringBuffer.append(" ").append(string).append(" ").append("primary key clustered").append(" (");
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append((String)vector.elementAt(i)).append(", ");
            }
            stringBuffer.setCharAt(stringBuffer.length() - 2, ')');
            this._conn.executeCommand(stringBuffer.toString());
            this.getPrimaryKeyColumns();
        } else {
            this._sPrimaryKeyConstraintName = null;
        }
        this._tmpAddPrimaryKeys = null;
        this._tmpDeletePrimaryKeys = null;
    }

    private String getRemoteOwnerName() {
        return "";
    }

    @Override
    public String getOwner() {
        String string = (String)this._attrib[2];
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void setAttribute(int n, Object object) {
        this._attrib[n] = object.toString();
    }

    @Override
    public void setOwner(String string) {
        this._attrib[2] = string;
    }

    public String getTableObjectID() {
        String string = (String)this._attrib[4];
        if (string == null) {
            string = "object_id('" + this.getFullyQualifiedName() + "')";
        }
        return string;
    }

    private int getSysStat2() {
        String string = (String)this._attrib[5];
        int n = Integer.valueOf(string);
        return n;
    }

    public boolean isSystemTable() {
        String string = (String)this._attrib[6];
        return string.equals("S");
    }

    public boolean isEditable() {
        return !this.isSystemTable();
    }

    public boolean isProxyTable() {
        return (this.getSysStat2() & 0x400) == 1024;
    }

    public void setIsProxyTable() {
        this.setAttribute(5, new Integer(1024));
    }

    public void setIsUserTable() {
        this.setAttribute(6, "U");
        this.setAttribute(5, new Integer(USERTABLE_SYSSTAT2));
    }

    public boolean isProxyTableOnXFS() {
        return this._tbIsProxyTableOnXFS;
    }

    public boolean isWebMethodProxyTable() throws SQLException {
        if (this._tbIsWebMethodProxyTable != null) {
            return this._tbIsWebMethodProxyTable;
        }
        String string = SQLs.getString("select 1 from {0}.dbo.sysattributes sa1, {0}.dbo.sysattributes sa2 where sa1.class=18 and sa1.char_value!= null and sa1.object_cinfo = sa2.object_cinfo and sa1.object_type=''P'' and sa2.object_type=''WF'' and sa1.object={1}", this.getDatabaseName(), this.getTableObjectID());
        Vector<String[]> vector = Utility.openQuery2(string, this.getConnection());
        this._tbIsWebMethodProxyTable = vector.size() > 0 ? new Boolean(true) : new Boolean(false);
        return this._tbIsWebMethodProxyTable;
    }

    public boolean hasIdentityColumn() {
        try {
            String string = SQLs.getString("select id from syscolumns where status = 128 and id=object_id(''{0}'')", this.getName());
            ASResultSet aSResultSet = new ASResultSet(this._conn);
            this.useDB();
            aSResultSet.open(string);
            return aSResultSet.getNextRow();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public void refresh() throws SQLException {
        String[] stringArray;
        String string = SQLs.getString("select table_name = A.name, table_owner = B.name, A.crdate, table_type = A.type, lock_scheme = A.sysstat2 & 57344, cache_name = (select char_value from {0}..sysattributes b, {0}..sysobjects c where c.id = b.object and c.id = A.id and object_type = ''T''), segment_name = (select s.name from {0}..syssegments s, {0}..sysindexes i where i.segment = s.segment and i.id = A.id and i.indid < 2), maxrowsperpage = (select i.maxrowsperpage from {0}..syssegments s, {0}..sysindexes i where i.segment = s.segment and i.id = A.id and i.indid < 2) from {0}..sysobjects A, {0}..sysusers B where A.uid = B.uid and type in (''S'', ''U'') and A.id = {1}", this.getDatabaseName(), this.getTableObjectID());
        Vector<String[]> vector = Utility.openQuery2(string, this.getConnection());
        if (vector.size() > 0) {
            stringArray = vector.elementAt(0);
            this._boundCache = stringArray[5];
            this._lockScheme = Integer.parseInt(stringArray[4]) / 8192;
            this._maxRowsPerPage = Integer.parseInt(stringArray[7]);
            this._lockScheme = this._lockScheme == 4 ? 2 : (this._lockScheme == 2 ? 1 : 0);
        }
        if (this.getTableObjectID() != null) {
            string = SQLs.getString("select i.res_page_gap, i.exp_rowsize, isnull(i.fill_factor,0), isnull(i.identitygap,0) from {0}..sysindexes i, {0}..syssegments s, {0}..sysobjects A, {0}..sysusers B where A.uid = B.uid and type in (''S'', ''U'') and A.id = {1} and i.segment = s.segment and i.id = A.id and i.indid < 2", this.getDatabaseName(), this.getTableObjectID());
            vector = Utility.openQuery2(string, this.getConnection());
            if (vector.size() == 0) {
                return;
            }
            stringArray = vector.elementAt(0);
            this._reservePageGap = Integer.parseInt(stringArray[0]);
            this._expectedRowSize = Integer.parseInt(stringArray[1]);
            this._fillFactor = Integer.parseInt(stringArray[2]);
            this._identityGap = this.getConnection().getVersion().compareTo("12.0") < 0 ? "-1" : stringArray[3];
        }
        this.checkIfIncrementalTransferEnabled();
    }

    public void checkIfIncrementalTransferEnabled() throws SQLException {
        if (!this.getConnection().hasIncrementalTransferFeature()) {
            this._incrementalTransferEnabled = false;
            return;
        }
        this.useDB();
        String string = SQLs.getString("select (sysstat3 & 32768) from sysobjects where id={0}", this.getTableObjectID());
        Vector<String[]> vector = Utility.openQuery2(string, this.getConnection());
        if (vector.size() > 0) {
            String[] stringArray = vector.elementAt(0);
            this._incrementalTransferEnabled = Integer.parseInt(stringArray[0]) == 32768;
            return;
        }
        this._incrementalTransferEnabled = false;
    }

    public int getMaxRowsPerPage() {
        return this._maxRowsPerPage;
    }

    public void setMaxRowsPerPage(int n) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_chgattribute ''{0}'', ''max_rows_per_page'', {1}", this.getName(), String.valueOf(n)));
    }

    public int getExpectedRowSize() {
        return this._expectedRowSize;
    }

    public void setExpectedRowSize(int n) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_chgattribute ''{0}'', ''exp_row_size'', {1}", this.getName(), String.valueOf(n)));
    }

    public int getReservePageGap() {
        return this._reservePageGap;
    }

    public void setReservePageGap(int n) throws SQLException {
        this.useDB();
        this.setUser();
        String string = SQLs.getString("exec sp_chgattribute ''{0}'', ''reservepagegap'', {1}", this.getName(), String.valueOf(n));
        this._conn.executeCommand(string);
    }

    public int getFillFactor() {
        return this._fillFactor;
    }

    public void setFillFactor(int n) throws SQLException {
        this.useDB();
        this.setUser();
        String string = SQLs.getString("exec sp_chgattribute ''{0}'', ''fillfactor'', {1}", this.getName(), String.valueOf(n));
        this._conn.executeCommand(string);
    }

    public int getLockScheme() {
        return this._lockScheme;
    }

    public String getIdentityGap() {
        return this._identityGap;
    }

    public void setIdentityGap(String string) throws SQLException {
        if (this._conn.getVersion().compareTo("12.5") >= 0) {
            this.useDB();
            this.setUser();
            String string2 = SQLs.getString("exec sp_chgattribute ''{0}'', ''identity_gap'', {1}", this.getName(), string);
            this._conn.executeCommand(string2);
        }
    }

    public String getCacheName() {
        return this._boundCache;
    }

    public void setRemoteServerName(String string) {
        this._remSrvName = string;
    }

    public String getRemoteServerName() {
        return this._remSrvName;
    }

    public void setRemoteDBName(String string) {
        this._remDBName = string;
    }

    public String getRemoteDBName() {
        return this._remDBName;
    }

    public String getRemoteObjectName() {
        return (String)this._attrib[7];
    }

    public void setRemoteObjectName(String string) {
        this._attrib[7] = string;
    }

    public String getRemoteObjectType() {
        return (String)this._attrib[8];
    }

    public void setRemoteObjectType(String string) {
        this._attrib[8] = string;
    }

    public boolean reName(String string, String string2) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_rename ''{0}'', ''{1}''", string, string2));
        return true;
    }

    public void setCache(int n, String string) throws SQLException {
        this.useDB();
        this.setUser();
        String string2 = this.getDatabaseName();
        String string3 = this.getOwner() + "." + this.getName();
        if (n == 0) {
            this._conn.executeCommand("exec sp_unbindcache  '" + string2 + "', '" + string3 + "' ");
        } else {
            this._conn.executeCommand("exec sp_bindcache  '" + string + "', '" + string2 + "', '" + string3 + "' ");
        }
    }

    public void setUser() throws SQLException {
        Utility.setUser(this.getConnection(), this.getOwner());
    }

    public int getOrigSelection(String string, JComboBox jComboBox) {
        return Utility.getOrigSelection(string, jComboBox);
    }

    public void setLockScheme(int n) throws SQLException {
        this.useDB();
        this.setUser();
        switch (n) {
            case 0: {
                this._conn.executeCommand(SQLs.getString("alter table {0} lock {1}", this.getName(), "ALLPAGES"));
                break;
            }
            case 1: {
                this._conn.executeCommand(SQLs.getString("alter table {0} lock {1}", this.getName(), "DATAPAGES"));
                break;
            }
            case 2: {
                this._conn.executeCommand(SQLs.getString("alter table {0} lock {1}", this.getName(), "DATAROWS"));
            }
        }
    }

    public void refreshAllocations() throws SQLException {
        this.useDB();
        String string = this._conn.getVersion().compareTo("15") < 0 ? "select segment from {1}.dbo.sysindexes where id = {0}" : "select segment from {1}.dbo.syspartitions  where id = {0} order by indid";
        String string2 = SQLs.getString(string, this.getTableObjectID(), this.getDatabaseName());
        this.getRSet().open(string2);
        if (this.getRSet().getNextRow()) {
            this._segmentindex = this.getRSet().getColumnString(1);
        }
        this.getRSet().close();
        if (this.getConnection().getVersion().compareTo("15") < 0) {
            String string3 = this.getOwner().length() > 0 ? this.getOwner() + "." + this.getName() : this.getName();
            ResultSet resultSet = this.getRSet().open("exec sp_spaceused '" + string3 + "'");
            Statement statement = resultSet.getStatement();
            resultSet = statement.getResultSet();
            while (resultSet.next()) {
                this._rowCount = resultSet.getString("rowtotal");
                this._reservedSpace = resultSet.getString("reserved");
                this._spaceUsedByData = resultSet.getString("data");
                this._spaceUsedByIndex = resultSet.getString("index_size");
                this._unusedSpace = resultSet.getString("unused");
            }
            this.getRSet().close();
        }
    }

    public String getReserveSpace() {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            String string = this._attrib[10].toString();
            if (string.length() == 0) {
                return "";
            }
            int n = Integer.parseInt(string);
            return String.valueOf(Utility.getPageSizeToKB(this._conn, n));
        }
        return this._reservedSpace.substring(0, this._reservedSpace.length() - 3);
    }

    public String getSpaceUsedByData() {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            String string = this._attrib[12].toString();
            if (string.length() == 0) {
                return "";
            }
            int n = Integer.parseInt(string);
            return String.valueOf(Utility.getPageSizeToKB(this._conn, n));
        }
        return this._spaceUsedByData.substring(0, this._spaceUsedByData.length() - 3);
    }

    public String getSpaceUsedByIndex() {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            String string = this._attrib[11].toString();
            if (string.length() == 0) {
                return "";
            }
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt((String)this._attrib[12]);
            return String.valueOf(Utility.getPageSizeToKB(this._conn, n - n2));
        }
        return this._spaceUsedByIndex.substring(0, this._spaceUsedByIndex.length() - 3);
    }

    public String getUnusedSpace() {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            String string = this._attrib[10].toString();
            if (string.length() == 0) {
                return "";
            }
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt((String)this._attrib[11]);
            return String.valueOf(Utility.getPageSizeToKB(this._conn, n - n2));
        }
        return this._unusedSpace.substring(0, this._unusedSpace.length() - 3);
    }

    public String getRowCount() {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            return (String)this._attrib[9];
        }
        return this._rowCount;
    }

    public String getSegmentName() throws SQLException {
        String string = SQLs.getString("select name from {1}.dbo.syssegments where segment = {0}", this._segmentindex, this.getDatabaseName());
        this.getRSet().open(string);
        this.getRSet().getNextRow();
        return this.getRSet().getColumnString(1);
    }

    public List getAvailableSegments() throws SQLException {
        SegmentsCtrSO segmentsCtrSO = new SegmentsCtrSO(this.getConnection(), this.getDatabaseSO());
        List list = segmentsCtrSO.open(1);
        return list;
    }

    public String bindToSegment(String string) throws SQLException {
        this.useDB();
        this.setUser();
        String string2 = SQLs.getString("exec sp_placeobject ''{0}'', ''{1}''", string, this.getDisplayName());
        String string3 = this._conn.executeCommand(string2);
        return string3;
    }

    public Vector referByProcedure() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getStoredProcedureSmallImage());
        this.getRSet().open(SQLs.getString("select O.name, U.name from {0}.dbo.sysdepends D, {0}.dbo.sysobjects O, {0}.dbo.sysusers U where O.uid = U.uid and O.type = ''{2}'' and O.id = D.id and D.depid = {1}", this.getDatabaseName(), this.getTableObjectID(), "P"));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referByTrigger() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getTriggerSmallImage());
        this.getRSet().open(SQLs.getString("select O.name, U.name from {0}.dbo.sysdepends D, {0}.dbo.sysobjects O, {0}.dbo.sysusers U where O.uid = U.uid and O.type = ''{2}'' and O.id = D.id and D.depid = {1}", this.getDatabaseName(), this.getTableObjectID(), "TR"));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referByView() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getViewSmallImage());
        this.getRSet().open(SQLs.getString("select O.name, U.name from {0}.dbo.sysdepends D, {0}.dbo.sysobjects O, {0}.dbo.sysusers U where O.uid = U.uid and O.type = ''{2}'' and O.id = D.id and D.depid = {1}", this.getDatabaseName(), this.getTableObjectID(), "V"));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referByTable() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getTableSmallImage());
        this.getRSet().open(SQLs.getString("select frgndbname, tableid from {0}.dbo.sysreferences where reftabid = {1} and constrid not in ( select constrid from {0}.dbo.sysreferences where reftabid = {1} and tableid = {1} and frgndbname = null)", this.getDatabaseName(), this.getTableObjectID()));
        while (this.getRSet().getNextRow()) {
            String string = this.getRSet().getColumnString(2);
            ASResultSet aSResultSet = new ASResultSet(this._conn);
            aSResultSet.open(SQLs.getString("select A.name, B.name, A.crdate, A.type, A.sysstat2 & 57344, (select char_value from {0}.dbo.sysattributes b, {0}.dbo.sysobjects c where c.id = b.object and c.id = A.id and object_type = ''T''), (select s.name from {0}.dbo.syssegments s, {0}.dbo.sysindexes i where i.segment = s.segment and i.id = A.id and i.indid < 2), (select i.maxrowsperpage from {0}.dbo.syssegments s, {0}.dbo.sysindexes i where i.segment = s.segment and i.id = A.id and i.indid < 2) from {0}.dbo.sysobjects A, {0}.dbo.sysusers B where A.uid = B.uid and type in (''S'', ''U'') and A.id = {1}", this.getDatabaseName(), string));
            while (aSResultSet.getNextRow()) {
                Vector<Object> vector2 = new Vector<Object>();
                vector2.addElement(new JLabel(aSResultSet.getColumnString(1), imageIcon, 0));
                vector2.addElement(aSResultSet.getColumnString(2));
                vector.addElement(vector2);
            }
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referDefault() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = DefaultBO.DEFAULT_ICON;
        this.getRSet().open(SQLs.getString("select distinct O.name, U.name from {0}.dbo.sysobjects O, {0}.dbo.sysusers U, {0}.dbo.syscolumns C, {0}.dbo.sysprocedures P where O.uid = U.uid and O.type = ''D'' and O.id = C.cdefault and O.id = P.id and P.sequence = 0 and P.status & 4096 != 4096 and C.id = {1}", this.getDatabaseName(), this.getTableObjectID()));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referRule() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = RuleBO.RULE_ICON;
        this.getRSet().open(SQLs.getString("select distinct O.name, U.name from {0}.dbo.sysobjects O, {0}.dbo.sysusers U, {0}.dbo.syscolumns C, {0}.dbo.sysprocedures P where O.uid = U.uid and O.id = P.id and O.id = C.domain and P.sequence = 0 and P.status & 4096 != 4096 and O.type = ''R'' and C.id = {1}", this.getDatabaseName(), this.getTableObjectID()));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referUserType() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = UserTypeBO.UDT_ICON;
        this.getRSet().open(SQLs.getString("select T.name, U.name from {0}.dbo.systypes T, {0}.dbo.sysusers U, {0}.dbo.syscolumns C, {0}.dbo.systypes P where T.uid = U.uid and T.usertype = C.usertype and T.usertype >= 100 and T.type = P.type and P.usertype = (select min(usertype) from {0}.dbo.systypes where type = T.type ) and C.id = {1}", this.getDatabaseName(), this.getTableObjectID()));
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 0));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public Vector referTable() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = TableBO.TABLE_ICON;
        this.useDB();
        this.getRSet().open(SQLs.getString("select O.name, U.name, R.pmrydbname, R.reftabid, object_name(R.reftabid), O.crdate from {0}.dbo.sysobjects O, {0}.dbo.sysreferences R, {0}.dbo.sysusers U where O.type = ''RI'' and O.uid = U.uid  and O.id = R.constrid  and R.tableid = {1} order by O.name", this.getDatabaseName(), this.getTableObjectID()));
        while (this.getRSet().getNextRow()) {
            String string = this.getRSet().getColumnString(4);
            ASResultSet aSResultSet = new ASResultSet(this._conn);
            aSResultSet.open(SQLs.getString("select A.name, B.name, A.crdate, A.type, A.sysstat2 & 57344, (select char_value from {0}.dbo.sysattributes b, {0}.dbo.sysobjects c where c.id = b.object and c.id = A.id and object_type = ''T''), (select s.name from {0}.dbo.syssegments s, {0}.dbo.sysindexes i where i.segment = s.segment and i.id = A.id and i.indid < 2), (select i.maxrowsperpage from {0}.dbo.syssegments s, {0}.dbo.sysindexes i where i.segment = s.segment and i.id = A.id and i.indid < 2) from {0}.dbo.sysobjects A, {0}.dbo.sysusers B where A.uid = B.uid and type in (''S'', ''U'') and A.id = {1}", this.getDatabaseName(), string));
            while (aSResultSet.getNextRow()) {
                Vector<Object> vector2 = new Vector<Object>();
                vector2.addElement(new JLabel(aSResultSet.getColumnString(1), imageIcon, 0));
                vector2.addElement(aSResultSet.getColumnString(2));
                vector.addElement(vector2);
            }
        }
        this.getRSet().close();
        return vector;
    }

    public void setUserPermissionList() throws SQLException {
        this._userPermissionList = new Vector();
        int n = 47;
        if (this.getConnection().isEncryptedKeyEnabled()) {
            n |= 0x80;
        }
        if (this.getConnection().hasIncrementalTransferFeature()) {
            n |= 0x100;
        }
        String string = SQLs.getString("select u.name, u.gid", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=193 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=195 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=196 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=197 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=224 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=151 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=(select number from master..spt_values where name = ''Decrypt'' and type = ''T'') and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=368 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString("  from {0}.dbo.sysusers u, {0}.dbo.sysusers g where u.gid!=u.uid and u.gid=g.uid and u.gid=g.gid order by 1 ", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            int n2 = 0;
            int n3 = 0;
            String string2 = this.getRSet().getColumnString(1);
            int n4 = Integer.parseInt(this.getRSet().getColumnString(2));
            boolean bl = false;
            if (this.getRSet().getColumnString(3).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(3)) == 1) {
                    n2 |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 0) {
                    n2 |= 1;
                    n3 |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 2) {
                    bl = true;
                }
            }
            boolean bl2 = false;
            if (this.getRSet().getColumnString(4).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(4)) == 1) {
                    n2 |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 0) {
                    n2 |= 2;
                    n3 |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 2) {
                    bl2 = true;
                }
            }
            boolean bl3 = false;
            if (this.getRSet().getColumnString(5).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(5)) == 1) {
                    n2 |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 0) {
                    n2 |= 4;
                    n3 |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 2) {
                    bl3 = true;
                }
            }
            boolean bl4 = false;
            if (this.getRSet().getColumnString(6).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(6)) == 1) {
                    n2 |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 0) {
                    n2 |= 8;
                    n3 |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 2) {
                    bl4 = true;
                }
            }
            boolean bl5 = false;
            if (this.getRSet().getColumnString(8).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(8)) == 1) {
                    n2 |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 0) {
                    n2 |= 0x20;
                    n3 |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 2) {
                    bl5 = true;
                }
            }
            boolean bl6 = false;
            if (this.getRSet().getColumnString(9).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(9)) == 1) {
                    n2 |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 0) {
                    n2 |= 0x80;
                    n3 |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 2) {
                    bl6 = true;
                }
            }
            boolean bl7 = false;
            if (this.getRSet().getColumnString(10).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(10)) == 1) {
                    n2 |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(10)) == 0) {
                    n2 |= 0x100;
                    n3 |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(10)) == 2) {
                    bl7 = true;
                }
            }
            UserPermission userPermission = new UserPermission(n2, true, n3);
            userPermission.setIdentity(string2, n4);
            userPermission.initializeSelectRevoke(bl);
            userPermission.initializeInsertRevoke(bl2);
            userPermission.initializeDeleteRevoke(bl3);
            userPermission.initializeUpdateRevoke(bl4);
            userPermission.initializeReferenceRevoke(bl5);
            userPermission.initializeDecryptRevoke(bl6);
            userPermission.initializeTransferRevoke(bl7);
            userPermission.setChoiceOfCol(n);
            this._userPermissionList.addElement(userPermission);
        }
        this.getRSet().close();
    }

    public void setGroupListPermissionList() throws SQLException {
        this._grouplistPermissionList = new Vector();
        String string = SQLs.getString("select u.name, g.uid", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=193 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=195 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=196 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=197 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=224 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=151 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=(select number from master..spt_values where name = ''Decrypt'' and type = ''T'') and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=368 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(" from {0}.dbo.sysusers u, {0}.dbo.sysusers g where u.gid=u.uid and u.gid=g.uid and u.gid=g.gid and u.gid not in (select lrid from {0}.dbo.sysroles) order by 1", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            int n = 0;
            int n2 = 0;
            String string2 = this.getRSet().getColumnString(1);
            int n3 = Integer.parseInt(this.getRSet().getColumnString(2));
            boolean bl = false;
            if (this.getRSet().getColumnString(3).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(3)) == 1) {
                    n |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 0) {
                    n |= 1;
                    n2 |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 2) {
                    bl = true;
                }
            }
            boolean bl2 = false;
            if (this.getRSet().getColumnString(4).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(4)) == 1) {
                    n |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 0) {
                    n |= 2;
                    n2 |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 2) {
                    bl2 = true;
                }
            }
            boolean bl3 = false;
            if (this.getRSet().getColumnString(5).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(5)) == 1) {
                    n |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 0) {
                    n |= 4;
                    n2 |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 2) {
                    bl3 = true;
                }
            }
            boolean bl4 = false;
            if (this.getRSet().getColumnString(6).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(6)) == 1) {
                    n |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 0) {
                    n |= 8;
                    n2 |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 2) {
                    bl4 = true;
                }
            }
            boolean bl5 = false;
            if (this.getRSet().getColumnString(8).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(8)) == 1) {
                    n |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 0) {
                    n |= 0x20;
                    n2 |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 2) {
                    bl5 = true;
                }
            }
            boolean bl6 = false;
            if (this.getRSet().getColumnString(9).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(9)) == 1) {
                    n |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 0) {
                    n |= 0x80;
                    n2 |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 2) {
                    bl6 = true;
                }
            }
            boolean bl7 = false;
            if (this.getRSet().getColumnString(10).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(10)) == 1) {
                    n |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(10)) == 0) {
                    n |= 0x100;
                    n2 |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(10)) == 2) {
                    bl7 = true;
                }
            }
            GroupPermission groupPermission = new GroupPermission(n, true, n2);
            groupPermission.setIdentity(string2, n3);
            groupPermission.initializeSelectRevoke(bl);
            groupPermission.initializeInsertRevoke(bl2);
            groupPermission.initializeDeleteRevoke(bl3);
            groupPermission.initializeUpdateRevoke(bl4);
            groupPermission.initializeReferenceRevoke(bl5);
            groupPermission.initializeDecryptRevoke(bl6);
            groupPermission.initializeTransferRevoke(bl7);
            this._grouplistPermissionList.addElement(groupPermission);
        }
        this.getRSet().close();
    }

    public void setPublicListPermissionList() throws SQLException {
        this._publiclistPermissionList = new Vector();
        String string = SQLs.getString("select u.name, g.uid", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=193 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=195 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=196 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=197 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=224 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=151 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=(select number from master..spt_values where name = ''Decrypt'' and type = ''T'') and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=368 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(" from {0}.dbo.sysusers u, {0}.dbo.sysusers g where u.gid=u.uid and u.gid=g.uid and u.gid=g.gid and u.gid not in (select lrid from {0}.dbo.sysroles) and u.name = ''public'' order by 1 ", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            int n = 0;
            int n2 = 0;
            String string2 = this.getRSet().getColumnString(1);
            int n3 = Integer.parseInt(this.getRSet().getColumnString(2));
            boolean bl = false;
            if (this.getRSet().getColumnString(3).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(3)) == 1) {
                    n |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 0) {
                    n |= 1;
                    n2 |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 2) {
                    bl = true;
                }
            }
            boolean bl2 = false;
            if (this.getRSet().getColumnString(4).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(4)) == 1) {
                    n |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 0) {
                    n |= 2;
                    n2 |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 2) {
                    bl2 = true;
                }
            }
            boolean bl3 = false;
            if (this.getRSet().getColumnString(5).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(5)) == 1) {
                    n |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 0) {
                    n |= 4;
                    n2 |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 2) {
                    bl3 = true;
                }
            }
            boolean bl4 = false;
            if (this.getRSet().getColumnString(6).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(6)) == 1) {
                    n |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 0) {
                    n |= 8;
                    n2 |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 2) {
                    bl4 = true;
                }
            }
            boolean bl5 = false;
            if (this.getRSet().getColumnString(8).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(8)) == 1) {
                    n |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 0) {
                    n |= 0x20;
                    n2 |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 2) {
                    bl5 = true;
                }
            }
            boolean bl6 = false;
            if (this.getRSet().getColumnString(9).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(9)) == 1) {
                    n |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 0) {
                    n |= 0x80;
                    n2 |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 2) {
                    bl6 = true;
                }
            }
            boolean bl7 = false;
            if (this.getRSet().getColumnString(9).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(9)) == 1) {
                    n |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 0) {
                    n |= 0x100;
                    n2 |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 2) {
                    bl7 = true;
                }
            }
            PublicPermission publicPermission = new PublicPermission(n, true, n2);
            publicPermission.setIdentity(string2, n3);
            publicPermission.initializeSelectRevoke(bl);
            publicPermission.initializeInsertRevoke(bl2);
            publicPermission.initializeDeleteRevoke(bl3);
            publicPermission.initializeUpdateRevoke(bl4);
            publicPermission.initializeReferenceRevoke(bl5);
            publicPermission.initializeDecryptRevoke(bl6);
            publicPermission.initializeTransferRevoke(bl7);
            this._publiclistPermissionList.addElement(publicPermission);
        }
        this.getRSet().close();
    }

    public void setRolePermissionList() throws SQLException {
        this._rolePermissionList = new Vector();
        int n = 47;
        if (this.getConnection().isEncryptedKeyEnabled()) {
            n |= 0x80;
        }
        if (this.getConnection().hasIncrementalTransferFeature()) {
            n |= 0x100;
        }
        for (Object e : Utility.getRoleInServer(this.getConnection())) {
            String string = e.toString();
            String string2 = SQLs.getString("select ''{0}'', role_id(''{0}'')", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=193 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=195 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=196 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=197 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=224 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=151 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=(select number from master..spt_values where name = ''Decrypt'' and type = ''T'') and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            string2 = string2 + SQLs.getString(", (select min(protecttype) from {1}.dbo.sysprotects p where p.uid=(select r.lrid from {1}.dbo.sysroles r where r.id = role_id(''{0}'')) and p.id={2} and p.action=368 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", string, this.getDatabaseName(), this.getTableObjectID());
            this.getRSet().open(string2);
            while (this.getRSet().getNextRow()) {
                int n2 = 0;
                int n3 = 0;
                int n4 = -1;
                String string3 = this.getRSet().getColumnString(1);
                boolean bl = false;
                if (this.getRSet().getColumnString(3).length() != 0) {
                    try {
                        n4 = Integer.parseInt(this.getRSet().getColumnString(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 == 1) {
                        n2 |= 1;
                    } else if (n4 == 0) {
                        n2 |= 1;
                        n3 |= 1;
                    } else if (n4 == 2) {
                        bl = true;
                    }
                }
                boolean bl2 = false;
                if (this.getRSet().getColumnString(4).length() != 0) {
                    try {
                        n4 = Integer.parseInt(this.getRSet().getColumnString(4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 == 1) {
                        n2 |= 2;
                    } else if (n4 == 0) {
                        n2 |= 2;
                        n3 |= 2;
                    } else if (n4 == 2) {
                        bl2 = true;
                    }
                }
                boolean bl3 = false;
                if (this.getRSet().getColumnString(5).length() != 0) {
                    try {
                        n4 = Integer.parseInt(this.getRSet().getColumnString(5));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 == 1) {
                        n2 |= 4;
                    } else if (n4 == 0) {
                        n2 |= 4;
                        n3 |= 4;
                    } else if (n4 == 2) {
                        bl3 = true;
                    }
                }
                boolean bl4 = false;
                if (this.getRSet().getColumnString(6).length() != 0) {
                    try {
                        n4 = Integer.parseInt(this.getRSet().getColumnString(6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 == 1) {
                        n2 |= 8;
                    } else if (n4 == 0) {
                        n2 |= 8;
                        n3 |= 8;
                    } else if (n4 == 2) {
                        bl4 = true;
                    }
                }
                boolean bl5 = false;
                if (this.getRSet().getColumnString(8).length() != 0) {
                    try {
                        n4 = Integer.parseInt(this.getRSet().getColumnString(8));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 == 1) {
                        n2 |= 0x20;
                    } else if (n4 == 0) {
                        n2 |= 0x20;
                        n3 |= 0x20;
                    } else if (n4 == 2) {
                        bl5 = true;
                    }
                }
                boolean bl6 = false;
                if (this.getRSet().getColumnString(9).length() != 0) {
                    try {
                        n4 = Integer.parseInt(this.getRSet().getColumnString(9));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 == 1) {
                        n2 |= 0x80;
                    } else if (n4 == 0) {
                        n2 |= 0x80;
                        n3 |= 0x80;
                    } else if (n4 == 2) {
                        bl6 = true;
                    }
                }
                boolean bl7 = false;
                if (this.getRSet().getColumnString(10).length() != 0) {
                    try {
                        n4 = Integer.parseInt(this.getRSet().getColumnString(10));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n4 == 1) {
                        n2 |= 0x100;
                    } else if (n4 == 0) {
                        n2 |= 0x100;
                        n3 |= 0x100;
                    } else if (n4 == 2) {
                        bl6 = true;
                    }
                }
                RolePermission rolePermission = new RolePermission(n2, false, n3);
                try {
                    int n5 = Integer.parseInt(this.getRSet().getColumnString(2));
                    rolePermission.setIdentity(string3, n5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                rolePermission.initializeSelectRevoke(bl);
                rolePermission.initializeInsertRevoke(bl2);
                rolePermission.initializeDeleteRevoke(bl3);
                rolePermission.initializeUpdateRevoke(bl4);
                rolePermission.initializeReferenceRevoke(bl5);
                rolePermission.initializeDecryptRevoke(bl6);
                rolePermission.initializeTransferRevoke(bl7);
                rolePermission.setChoiceOfCol(n);
                this._rolePermissionList.addElement(rolePermission);
            }
            this.getRSet().close();
        }
    }

    public void editName(String string) throws SQLException {
        this.reName(this.getDisplayName(), string);
    }

    public void setGroupPermissionList() throws SQLException {
        this._groupPermissionList = new Vector();
        int n = 47;
        if (this.getConnection().isEncryptedKeyEnabled()) {
            n |= 0x80;
        }
        if (this.getConnection().hasIncrementalTransferFeature()) {
            n |= 0x100;
        }
        String string = SQLs.getString("select u.name, u.gid", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=193 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=195 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=196 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=197 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=224 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=151 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=(select number from master..spt_values where name = ''Decrypt'' and type = ''T'') and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString(", (select min(protecttype) from {0}.dbo.sysprotects p where p.uid=u.uid and p.id={1} and p.action=368 and (convert(tinyint,substring(isnull(columns,0x1), 1, 1)) & 1) = 1)", this.getDatabaseName(), this.getTableObjectID());
        string = string + SQLs.getString("  from {0}.dbo.sysusers u, {0}.dbo.sysusers g where u.gid=u.uid and u.gid=g.uid and u.gid=g.gid and u.gid not in (select lrid from {0}.dbo.sysroles) order by 1 ", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            int n2 = 0;
            int n3 = 0;
            String string2 = this.getRSet().getColumnString(1);
            int n4 = Integer.parseInt(this.getRSet().getColumnString(2));
            boolean bl = false;
            if (this.getRSet().getColumnString(3).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(3)) == 1) {
                    n2 |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 0) {
                    n2 |= 1;
                    n3 |= 1;
                } else if (Integer.parseInt(this.getRSet().getColumnString(3)) == 2) {
                    bl = true;
                }
            }
            boolean bl2 = false;
            if (this.getRSet().getColumnString(4).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(4)) == 1) {
                    n2 |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 0) {
                    n2 |= 2;
                    n3 |= 2;
                } else if (Integer.parseInt(this.getRSet().getColumnString(4)) == 2) {
                    bl2 = true;
                }
            }
            boolean bl3 = false;
            if (this.getRSet().getColumnString(5).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(5)) == 1) {
                    n2 |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 0) {
                    n2 |= 4;
                    n3 |= 4;
                } else if (Integer.parseInt(this.getRSet().getColumnString(5)) == 2) {
                    bl3 = true;
                }
            }
            boolean bl4 = false;
            if (this.getRSet().getColumnString(6).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(6)) == 1) {
                    n2 |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 0) {
                    n2 |= 8;
                    n3 |= 8;
                } else if (Integer.parseInt(this.getRSet().getColumnString(6)) == 2) {
                    bl4 = true;
                }
            }
            boolean bl5 = false;
            if (this.getRSet().getColumnString(8).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(8)) == 1) {
                    n2 |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 0) {
                    n2 |= 0x20;
                    n3 |= 0x20;
                } else if (Integer.parseInt(this.getRSet().getColumnString(8)) == 2) {
                    bl5 = true;
                }
            }
            boolean bl6 = false;
            if (this.getRSet().getColumnString(9).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(9)) == 1) {
                    n2 |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 0) {
                    n2 |= 0x80;
                    n3 |= 0x80;
                } else if (Integer.parseInt(this.getRSet().getColumnString(9)) == 2) {
                    bl6 = true;
                }
            }
            boolean bl7 = false;
            if (this.getRSet().getColumnString(10).length() != 0) {
                if (Integer.parseInt(this.getRSet().getColumnString(10)) == 1) {
                    n2 |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(10)) == 0) {
                    n2 |= 0x100;
                    n3 |= 0x100;
                } else if (Integer.parseInt(this.getRSet().getColumnString(10)) == 2) {
                    bl7 = true;
                }
            }
            GroupPermission groupPermission = new GroupPermission(n2, true, n3);
            groupPermission.setIdentity(string2, n4);
            groupPermission.initializeSelectRevoke(bl);
            groupPermission.initializeInsertRevoke(bl2);
            groupPermission.initializeDeleteRevoke(bl3);
            groupPermission.initializeUpdateRevoke(bl4);
            groupPermission.initializeReferenceRevoke(bl5);
            groupPermission.initializeDecryptRevoke(bl6);
            groupPermission.initializeDecryptRevoke(bl7);
            groupPermission.setChoiceOfCol(n);
            this._groupPermissionList.addElement(groupPermission);
        }
        this.getRSet().close();
    }

    public Vector getUserPermissionList() {
        return this._userPermissionList;
    }

    public Vector getGroupPermissionList() {
        return this._groupPermissionList;
    }

    public Vector getRolePermissionList() {
        return this._rolePermissionList;
    }

    public Vector getGroupListPermissionList() {
        return this._grouplistPermissionList;
    }

    public Vector getPublicListPermissionList() {
        return this._publiclistPermissionList;
    }

    public boolean isPrimaryKeyModified() {
        return this._blnPrimaryKeyModified;
    }

    public Vector getPrimaryKeyColumns() throws SQLException {
        this._primaryKeyColumns = new Vector();
        this._sPrimaryKeyConstraintName = null;
        UniqueConstraintsCtrSO uniqueConstraintsCtrSO = new UniqueConstraintsCtrSO(this._conn, this);
        Vector vector = (Vector)uniqueConstraintsCtrSO.open(1);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                UniqueConstraintSO uniqueConstraintSO = (UniqueConstraintSO)vector.elementAt(i);
                if (!uniqueConstraintSO.IsOnPrimaryKey()) continue;
                Vector vector2 = uniqueConstraintSO.getIndexedColumnNameList();
                for (int j = 0; j < vector2.size(); ++j) {
                    Vector vector3 = (Vector)vector2.elementAt(j);
                    this._primaryKeyColumns.add(vector3.elementAt(0));
                }
                this._sPrimaryKeyConstraintName = uniqueConstraintSO.getName();
                return this._primaryKeyColumns;
            }
        }
        return this._primaryKeyColumns;
    }

    public Vector getCachedPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    public void addTmpPrimaryKeys(String string) {
        if (this._tmpAddPrimaryKeys == null) {
            this._tmpAddPrimaryKeys = new Vector();
        }
        if (!this._tmpAddPrimaryKeys.contains(string)) {
            this._tmpAddPrimaryKeys.add(string);
        }
    }

    public void deleteTmpPrimaryKeys(String string) {
        if (this._tmpDeletePrimaryKeys == null) {
            this._tmpDeletePrimaryKeys = new Vector();
        }
        if (!this._tmpDeletePrimaryKeys.contains(string)) {
            this._tmpDeletePrimaryKeys.add(string);
        }
    }

    public void setWorkingColumns(Vector vector) {
        this._workingColumnSOs = vector;
    }

    public Vector getWorkingColumns() {
        return this._workingColumnSOs;
    }

    public Vector getWebMethodColumns() throws SQLException {
        Vector vector = new Vector();
        this.getRSet().open(SQLs.getString("select column_name=C.name, column_type=isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), allows_null=case when status&8=8 then \"Y\" else \"N\" end, length=C.length, C.prec, scale=C.scale, rule_id=C.domain, default_id=C.cdefault, status=C.status, user_type=T.usertype, table_id=C.id, column_id=C.colid, char_size=isnull(@@ncharsize,1), xstatus=C.xstatus, status2 = isnull(C.status2,0), status3 = isnull(C.status3,0) from {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X where C.id = {1} and C.usertype *= T.usertype and C.xtype *= X.xtid and C.name like ''{2}'' ", this.getDatabaseName(), this.getTableObjectID(), "[_]%", new Integer("1")));
        while (this.getRSet().getNextRow()) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(this.getRSet().getColumnString(1));
            vector2.addElement(this.getRSet().getColumnString(2));
            vector2.addElement("");
            vector.addElement(vector2);
        }
        return vector;
    }

    public void setTableName(String string) {
        this._attrib[1] = string;
    }

    public boolean defaultAllowNull() {
        return this._databaseSO.getOption("DB_OP_ALLOW_NULLS");
    }

    @Override
    public Object[] getAttributes() {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            if (this.isProxyTable()) {
                return new Object[]{null, this.getName(), this.getOwner(), this.getCreationDate(), this.getRemoteObjectName(), this.getRemoteObjectType(), this.getRowCount(), this.getReserveSpace(), this.getSpaceUsedByData(), this.getSpaceUsedByIndex(), this.getUnusedSpace()};
            }
            return new Object[]{null, this.getName(), this.getOwner(), this.getCreationDate(), this.getRowCount(), this.getReserveSpace(), this.getSpaceUsedByData(), this.getSpaceUsedByIndex(), this.getUnusedSpace()};
        }
        if (this.isProxyTable()) {
            return new Object[]{null, this.getName(), this.getOwner(), this.getCreationDate(), this.getRemoteObjectName(), this.getRemoteObjectType()};
        }
        return new Object[]{null, this.getName(), this.getOwner(), this.getCreationDate()};
    }

    public void alterEnableTrigger(boolean bl, String string) throws SQLException {
        String string2 = bl ? "ENABLE" : "DISABLE";
        String string3 = string == null ? " " : string;
        Object[] objectArray = new String[]{this.getDatabaseName(), this.getOwner(), this.getName(), string2, string3};
        String string4 = SQLs.getString("alter table {0}.{1}.{2} {3} trigger {4}", objectArray);
        this._conn.executeCommand(string4);
    }

    public boolean hasPartition() throws SQLException {
        boolean bl = false;
        String string = SQLs.getString("select count(*) from {0}.dbo.syspartitions where id = {1}", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            int n = this.getRSet().getColumnInt(1);
            bl = n > 0;
        }
        this.getRSet().close();
        return bl;
    }

    public Vector getPartitionNames() throws SQLException {
        Vector<String> vector = new Vector<String>();
        if (this.hasPartition()) {
            this.getRSet().open(SQLs.getString("select case when indid = 1 then cdataptnname else name end from {0}.dbo.syspartitions where id = {1} and indid < 2 order by 1", this.getDatabaseName(), this.getTableObjectID()));
            while (this.getRSet().getNextRow()) {
                vector.addElement(this.getRSet().getColumnString(1));
            }
        }
        return vector;
    }

    public List getPartitionInfo() throws SQLException {
        Vector<String[]> vector = new Vector<String[]>();
        this.useDB();
        String string = SQLs.getString("select partitionid, firstpage, controlpage, ptn_data_pages = ptn_data_pgs({0}, partitionid) from syspartitions where id = {0}", this.getTableObjectID());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1);
            String string3 = this.getRSet().getColumnString(2);
            String string4 = this.getRSet().getColumnString(3);
            String string5 = this.getRSet().getColumnString(4);
            vector.add(new String[]{string2, string3, string4, string5});
        }
        this.getRSet().close();
        return vector;
    }

    public String[] getPartitionSummary() throws SQLException {
        this.useDB();
        String string = SQLs.getString("select num_partitions = count(*), avg_pages = avg(ptn_data_pgs({0}, partitionid)), max_pages = max(ptn_data_pgs({0}, partitionid)), min_pages = min(ptn_data_pgs({0}, partitionid)), ratio = convert(float,max(ptn_data_pgs({0}, partitionid)))/avg(ptn_data_pgs({0}, partitionid)) from syspartitions where id = {0}", this.getTableObjectID());
        this.getRSet().open(string);
        String[] stringArray = new String[5];
        if (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1);
            String string3 = this.getRSet().getColumnString(2);
            String string4 = this.getRSet().getColumnString(3);
            String string5 = this.getRSet().getColumnString(4);
            String string6 = this.getRSet().getColumnString(5);
            stringArray[0] = string2;
            stringArray[1] = string3;
            stringArray[2] = string4;
            stringArray[3] = string5;
            stringArray[4] = string6;
        }
        this.getRSet().close();
        return stringArray;
    }

    public void partition(int n) throws SQLException {
        this.useDB();
        String string = SQLs.getString("alter table {0}.{1}.{2} partition {3}", this.getDatabaseName(), this.getOwner(), this.getName(), new Integer(n));
        this._conn.executeCommand(string);
    }

    public void unpartition() throws SQLException {
        this.useDB();
        String string = SQLs.getString("alter table {0}.{1}.{2} unpartition", this.getDatabaseName(), this.getOwner(), this.getName());
        this._conn.executeCommand(string);
    }

    public boolean clusteredIndexExists() throws SQLException {
        String string = SQLs.getString("select I.status from {0}.dbo.sysobjects O, {0}.dbo.sysindexes I, {0}.dbo.sysusers U where I.id = O.id and U.uid = O.uid and I.id = {1}  and I.indid between 1 and 254", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            int n = 16;
            String string2 = this.getRSet().getColumnString(1);
            if (string2 == null) {
                string2 = USERTABLE_SYSSTAT2;
            } else if (string2.trim().equals("")) {
                string2 = USERTABLE_SYSSTAT2;
            }
            this.getRSet().close();
            return 0 != (Integer.parseInt(string2) & n);
        }
        return false;
    }

    public String checkDatabaseConsistency(String string) throws SQLException {
        return Utility.checkDatabaseConsistency(this.getConnection(), this.getDatabaseSO(), string);
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_TABLE_TYPE");
    }

    public boolean isComputedColApplicable() {
        if (this._isComputedColApplicable == null) {
            this._isComputedColApplicable = this._conn.getVersion().compareTo("15") >= 0 ? new Boolean(true) : new Boolean(false);
        }
        return this._isComputedColApplicable;
    }

    public void setUpdateStatAllColumns(boolean bl) {
        this._updateStatAllColumns = bl;
    }

    public boolean getUpdateStatAllColumns() {
        return this._updateStatAllColumns;
    }

    public void setUpdateStatSampling(String string) {
        this._updateStatSampling = string;
    }

    public String getUpdateStatSampling() {
        return this._updateStatSampling;
    }

    public void setUpdateStatSteps(String string) {
        this._updateStatSteps = string;
    }

    public String getUpdateStatSteps() {
        return this._updateStatSteps;
    }

    public int getMaxOnlineEngines() throws SQLException {
        return this.getConnection().getSPConfigRunValue("max online engines");
    }

    public boolean updateStatCanUseConsumers() throws SQLException {
        if (!this.hasPartition()) {
            return false;
        }
        int n = this.getMaxOnlineEngines();
        return n > 1;
    }

    public void setUpdateStatConsumers(int n) {
        this._updateStatConsumers = n;
    }

    public int getUpdateStatConsumers() {
        return this._updateStatConsumers;
    }

    public void deleteStat(TableSO tableSO, ArrayList arrayList) throws SQLException {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = "delete statistics " + arrayList.get(i);
            this.getConnection().executeCommand(string);
        }
    }

    public void deleteStat(ColumnSO columnSO, ArrayList arrayList) throws SQLException {
        String string = "delete statistics ";
        string = string + columnSO.getTableSO().getFullyQualifiedName();
        String string2 = ASAUtils.buildStringList((Collection)arrayList, (String)", ", (char)'\u0000', (char)'\u0000', (boolean)false, (boolean)false);
        string = string + " (" + string2 + ")";
        this.getConnection().executeCommand(string);
    }

    public void deleteStat(PartitionSO partitionSO, ArrayList arrayList) throws SQLException {
        for (int i = 0; i < arrayList.size(); ++i) {
            StringBuffer stringBuffer = new StringBuffer("delete statistics ");
            stringBuffer.append(this.getFullyQualifiedName()).append(" ").append(PARTITION).append(" ").append(arrayList.get(i));
            this.getConnection().executeCommand(stringBuffer.toString());
        }
    }

    public void updateStat(TableSO tableSO) throws SQLException {
        String string = "";
        string = string + this.addBeginConditions(tableSO, null, null, null);
        string = string + (this._updateStatAllColumns ? "update index statistics " : "update statistics ");
        string = string + tableSO.getFullyQualifiedName();
        string = string + this.getUpdateStatOptions();
        string = string + this.addEndConditions();
        this.getConnection().executeCommand(string);
    }

    public void updateStat(ColumnSO columnSO, ArrayList arrayList) throws SQLException {
        String string = "";
        string = string + this.addBeginConditions(null, columnSO, null, arrayList);
        string = string + "update statistics ";
        string = string + columnSO.getTableSO().getFullyQualifiedName();
        String string2 = ASAUtils.buildStringList((Collection)arrayList, (String)", ", (char)'\u0000', (char)'\u0000', (boolean)false, (boolean)false);
        string = string + " (" + string2 + ")";
        string = string + this.getUpdateStatOptions();
        string = string + this.addEndConditions();
        this.getConnection().executeCommand(string);
    }

    public void updateStat(IndexSO indexSO, ArrayList arrayList) throws SQLException {
        String string = "";
        string = string + this.addBeginConditions(null, null, indexSO, arrayList);
        ArrayList arrayList2 = Support.getItemNames(arrayList, false, false);
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (i != 0) {
                string = string + "\n";
            }
            string = string + "update statistics ";
            string = string + indexSO.getTableSO().getFullyQualifiedName();
            String string2 = (String)arrayList2.get(i);
            string = string + " " + string2 + this.getUpdateStatOptions();
        }
        string = string + this.addEndConditions();
        this.getConnection().executeCommand(string);
    }

    public void updateStat(PartitionSO partitionSO, ArrayList arrayList) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList2 = Support.getItemNames(arrayList, false, false);
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (i != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getUpdateStatType()).append(" ");
            stringBuffer.append(this.getFullyQualifiedName());
            if (partitionSO.getPartitionType() == 2) {
                stringBuffer.append(" ").append(partitionSO.getIndexSO().getName());
            }
            String string = "partition " + (String)arrayList2.get(i);
            stringBuffer.append(" ").append(string).append(this.getUpdateStatOptions());
        }
        stringBuffer.append(this.addEndConditions());
        this.getConnection().executeCommand(stringBuffer.toString());
    }

    public void setUpdateStatPartitionType(int n) {
        this._updateStatPartitionType = n;
    }

    private int getUpdateStatPartitionType() {
        return this._updateStatPartitionType;
    }

    public void setUpdateStatType(String string) {
        this._updateStatType = string;
    }

    private String getUpdateStatType() {
        return this._updateStatType;
    }

    public String addBeginConditions(TableSO tableSO, ColumnSO columnSO, IndexSO indexSO, ArrayList arrayList) throws SQLException {
        String string = "";
        String string2 = "({0} <= (select datachange(''{1}'', ''{2}'', null)))";
        String string3 = "({0} <= (select datachange(''{1}'', ''{2}'', ''{3}'')))";
        if (this.getUseDataChange()) {
            this.useDB();
            string = "if (";
            if (tableSO != null) {
                string = string + SQLs.getString(string2, String.valueOf(tableSO.getDatachangeThreshold()), tableSO.getName(), tableSO.getDatachangePartition());
            } else if (columnSO != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i != 0) {
                        string = string + " and ";
                    }
                    string = string + SQLs.getString(string3, String.valueOf(columnSO.getTableSO().getDatachangeThreshold()), columnSO.getTableSO().getName(), columnSO.getTableSO().getDatachangePartition(), arrayList.get(i));
                }
            } else if (indexSO != null) {
                Object object;
                int n;
                TreeSet treeSet = new TreeSet();
                for (n = 0; n < arrayList.size(); ++n) {
                    Object object2;
                    object = new Vector();
                    if (arrayList.get(n) instanceof UniqueConstraintBO) {
                        UniqueConstraintBO uniqueConstraintBO = (UniqueConstraintBO)arrayList.get(n);
                        object2 = (UniqueConstraintSO)uniqueConstraintBO.getSO();
                        object = ((UniqueConstraintSO)object2).getIndexedColumnNameList();
                    } else if (arrayList.get(n) instanceof IndexBO) {
                        IndexBO indexBO = (IndexBO)arrayList.get(n);
                        object2 = (IndexSO)indexBO.getSO();
                        object = ((IndexSO)object2).getColumnNameOrderList();
                    }
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        object2 = (Vector)((Vector)object).elementAt(i);
                        treeSet.add(((Vector)object2).elementAt(0));
                    }
                }
                n = 0;
                object = treeSet.iterator();
                while (object.hasNext()) {
                    if (n != 0) {
                        string = string + " and ";
                    }
                    ++n;
                    string = string + SQLs.getString(string3, String.valueOf(indexSO.getTableSO().getDatachangeThreshold()), indexSO.getTableSO().getName(), indexSO.getTableSO().getDatachangePartition(), object.next());
                }
            }
            string = string + ")\nbegin\n";
        }
        return string;
    }

    public String addEndConditions() {
        String string = "";
        if (this.getUseDataChange()) {
            string = string + "\nend";
        }
        return string;
    }

    public static String getBCPCommand() {
        String string = ASEUtils.OS_WINDOWS ? "bcp.exe" : "bcp";
        return string;
    }

    public static String getBCPPath() {
        String string = ASEProvider.getSybasePath();
        String string2 = ASEProvider.findDirName(string, new String[]{"OCS-15_0", "OCS-"}, "OCS*");
        String string3 = string + File.separator + string2 + File.separator + "bin" + File.separator + TableSO.getBCPCommand();
        return string3;
    }

    private String getUpdateStatOptions() {
        String string = "";
        if (this._updateStatSteps != null) {
            string = string + " using " + this._updateStatSteps + " values";
        }
        if (this._updateStatSampling != null) {
            string = string + " with sampling = " + this._updateStatSampling;
        }
        if (this._updateStatConsumers > 1) {
            string = string + " with consumers = " + this._updateStatConsumers;
        }
        return string;
    }

    public static String getOptdiagCommand() {
        String string = ASEUtils.OS_WINDOWS ? "optdiag.exe" : "optdiag";
        return string;
    }

    public static String getOptdiagPath() {
        String[] stringArray;
        String string = "";
        String string2 = ASEProvider.getSybasePath();
        String string3 = Utils.getEnVariable((String)"SYBASE_ASE");
        if (string3 != null && string3.length() > 0) {
            string = ASEProvider.findDirName(string2, string3, string3) + File.separator + "bin";
            if (ASEUtils.utilExists(string2, string, TableSO.getOptdiagCommand())) {
                return ASEUtils.utilPath(string2, string, TableSO.getOptdiagCommand());
            }
        } else {
            stringArray = new ASEMessageText(ASEUtils.getString("ERR_ENV_VARIABLE_NOT_DEFINED"), "SYBASE_ASE");
            Support.addLogEntry(1, null, TableSO.class, stringArray.toString(), stringArray.toString());
        }
        stringArray = new String[]{"ASE-15", "ASE-12"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            string = ASEProvider.findDirName(string2, string4, string4) + File.separator + "bin";
            if (!ASEUtils.utilExists(string2, string, TableSO.getOptdiagCommand())) continue;
            return ASEUtils.utilPath(string2, string, TableSO.getOptdiagCommand());
        }
        return string;
    }

    public static String getDisplayStatCommand(String string, ASConnection aSConnection, String string2, boolean bl, String string3) {
        String string4 = (string == null || string.length() == 0 ? TableSO.getOptdiagPath() : string) + " statistics " + string2 + " -U " + aSConnection.getCurrentUser() + " -P " + (bl ? "<password>" : aSConnection.getPassword()) + " -S " + (string3 == null ? aSConnection.getServerServerName() : string3);
        return string4;
    }

    public static String getOptdiagVersion(String string) throws IOException {
        int n;
        int n2;
        Runtime runtime = Runtime.getRuntime();
        String string2 = string == null || string.length() == 0 ? TableSO.getOptdiagPath() : string;
        String[] stringArray = new String[]{string2, "-version"};
        Process process = null;
        String[] stringArray2 = ASEUtils.validCommandIsRoutine(stringArray, null);
        if (stringArray2.length <= 0) {
            return ASEUtils.getString("INVALID_COMMAND");
        }
        process = runtime.exec(stringArray2);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        ASEUtils.handleProcess(process, stringBuffer, stringBuffer2);
        String string3 = stringBuffer2.toString();
        if (string3.length() > 0) {
            throw new IOException(string3);
        }
        String string4 = stringBuffer.toString();
        if (string4.length() > 0 && (n2 = string4.indexOf("/")) >= 0 && (n = string4.indexOf("/", n2 + 1)) > n2) {
            return string4.substring(n2 + 1, n);
        }
        throw new IOException();
    }

    public static Process displayStat(String string, ASConnection aSConnection, String string2) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string == null || string.length() == 0 ? TableSO.getOptdiagPath() : string);
        arrayList.add("statistics");
        arrayList.add(string2);
        arrayList.add("-U");
        arrayList.add(aSConnection.getCurrentUser());
        arrayList.add("-P");
        arrayList.add(aSConnection.getPassword());
        arrayList.add("-S");
        arrayList.add(aSConnection.getServerName());
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        process = runtime.exec(stringArray);
        return process;
    }

    public void setPartitionColumns(String[] stringArray) {
        this._partitionColumns = stringArray;
    }

    public String[] getPartitionColumns() throws SQLException {
        if (this._partitionColumns != null) {
            return this._partitionColumns;
        }
        String string = SQLs.getString("select distinct column_name = c.name, column_type = isnull(x.xtname, isnull(get_xtypename(c.xtype,c.xdbid), t.name)) from {0}.dbo.syscolumns c, {0}.dbo.sysxtypes x, {0}.dbo.systypes t, {0}.dbo.syspartitionkeys p where c.id = {1} and c.xtype *= x.xtid and c.usertype *= t.usertype and p.id = {1} and c.colid = p.colid order by p.position", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        Vector<String> vector = new Vector<String>();
        while (this.getRSet().getNextRow()) {
            vector.add(this.getRSet().getColumnString(1) + "(" + this.getRSet().getColumnString(2) + ")");
        }
        this._partitionColumns = new String[vector.size()];
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                this._partitionColumns[i] = (String)vector.elementAt(i);
            }
        }
        return this._partitionColumns;
    }

    public String getPartitionKey() throws SQLException {
        if (this.getPartitionStrategy().equals("roundrobin")) {
            return "";
        }
        String[] stringArray = this.getPartitionColumns();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(", ");
        }
        if (!stringBuffer.equals("")) {
            stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.lastIndexOf(",")));
        }
        return stringBuffer.toString();
    }

    public void setPartitionStrategy(String string) {
        this._partitionStrategy = string;
    }

    public String getPartitionStrategy() throws SQLException {
        if (this._partitionStrategy != null) {
            return this._partitionStrategy;
        }
        String string = SQLs.getString("select number = (select count(*) from {0}.dbo.syspartitions p  where p.id = o.id and p.indid < 2 ), partition_type = (select v.name from master.dbo.spt_values v where v.type = ''PN'' and v.number = i.partitiontype) from {0}.dbo.sysobjects o, {0}.dbo.sysindexes i where  o.id = {1} and i.id = o.id and i.indid <2 ", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            this._partitionStrategy = this.getRSet().getColumnString("partition_type");
            this._noPartitions = Integer.parseInt(this.getRSet().getColumnString("number"));
        }
        return this._partitionStrategy;
    }

    public int getNumberPartitions() throws SQLException {
        String string = SQLs.getString("select number = (select count(*) from {0}.dbo.syspartitions p  where p.id = o.id and p.indid < 2 ), partition_type = (select v.name from master.dbo.spt_values v where v.type = ''PN'' and v.number = i.partitiontype) from {0}.dbo.sysobjects o, {0}.dbo.sysindexes i where  o.id = {1} and i.id = o.id and i.indid <2 ", this.getDatabaseName(), this.getTableObjectID());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            this._partitionStrategy = this.getRSet().getColumnString("partition_type");
            this._noPartitions = Integer.parseInt(this.getRSet().getColumnString("number"));
        }
        return this._noPartitions;
    }

    public void setPartitionSpec(String string) {
        this._partitionSpec = string;
    }

    private String getPartitionSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (!this._partitionStrategy.equals("roundrobin")) {
            for (int i = 0; i < this._partitionColumns.length; ++i) {
                string = string + this._partitionColumns[i].substring(0, this._partitionColumns[i].lastIndexOf("(")) + ",";
            }
            string = string.substring(0, string.lastIndexOf(","));
        }
        stringBuffer.append("alter table").append(" ").append(this.getDatabaseName()).append(".").append(this.getOwner()).append(".").append(this.getName()).append(" ");
        stringBuffer.append("partition by ").append(this._partitionStrategy);
        if (!string.equals("")) {
            stringBuffer.append("(").append(string).append(")");
        }
        stringBuffer.append(" ").append(this._partitionSpec);
        return stringBuffer.toString();
    }

    private String getAddPartitionSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("alter table").append(" ").append(this.getDatabaseName()).append(".").append(this.getOwner()).append(".").append(this.getName()).append(" ");
        stringBuffer.append("add partition ");
        stringBuffer.append(" ").append(this._partitionSpec);
        return stringBuffer.toString();
    }

    public void createPartition() throws SQLException {
        this.useDB();
        this._conn.executeCommand(this.getPartitionSQL());
    }

    public void addPartition() throws SQLException {
        this.useDB();
        this._conn.executeCommand(this.getAddPartitionSQL());
    }

    public void setTempNumberPartitions(int n) {
        this._tempNoPartitions = n;
    }

    public int getTempNumberPartitions() {
        return this._tempNoPartitions;
    }

    public Vector getSegmentsForPartition() throws SQLException {
        if (this._partitionSegments != null) {
            return this._partitionSegments;
        }
        this._partitionSegments = new Vector();
        List list = this.getAvailableSegments();
        this._partitionSegments.add("");
        for (SegmentSO segmentSO : list) {
            String string = segmentSO.getName();
            ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)SegmentBO.SEGMENT_ICON, string);
            this._partitionSegments.add(aSAIconTextData);
        }
        return this._partitionSegments;
    }

    public void setUseDataChange(boolean bl) {
        this._useDataChange = bl;
    }

    public boolean getUseDataChange() {
        return this._useDataChange;
    }

    public void setDatachangePartition(String string) {
        this._datachangePartition = string;
    }

    public String getDatachangePartition() {
        return this._datachangePartition;
    }

    public void setDatachangeThreshold(int n) {
        this._datachangeThreshold = n;
    }

    public int getDatachangeThreshold() {
        return this._datachangeThreshold;
    }

    public String getPrimaryKeyConstraintName() {
        return this._sPrimaryKeyConstraintName;
    }

    public boolean hasIndex() throws SQLException {
        try {
            String string = SQLs.getString("select count(*) from {0}..sysindexes where id = {1} and indid > 0", this._databaseSO.getName(), this.getTableObjectID());
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                if (this.getRSet().getColumnString(1).equals(USERTABLE_SYSSTAT2)) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public boolean includeRestore() {
        return !this._databaseSO.isProxyDB() && !this._databaseSO.isArchiveDB() && !this._databaseSO.isTempDB() && !this.isProxyTable();
    }

    public boolean isRangeOrListPartitioned() throws SQLException {
        return this.getPartitionStrategy().equals("list") || this.getPartitionStrategy().equals("range");
    }

    public int getNumberOfRows() throws SQLException {
        String string = SQLs.getString("select count(*) from {0}", this.getFullyQualifiedName());
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            return new Integer(this.getRSet().getColumnString(1));
        }
        return 0;
    }

    public boolean getIncrementalTransferEnabled() {
        return this._incrementalTransferEnabled;
    }

    public void setIncrementalTransfer(boolean bl) throws SQLException {
        this.useDB();
        String string = bl ? "on" : "off";
        String string2 = SQLs.getString("Alter table {0}.{1}.{2} set transfer table {3}", this.getDatabaseName(), this.getOwner(), this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public String getPreviousTransferPathname() {
        return this._previousTransferPathname;
    }

    public String getPreviousTransferDataFormat() {
        return this._previousTransferDataFormat;
    }

    public String getPreviousTransferColumnOrder() {
        return this._previousTransferColumnOrder;
    }

    public String getPreviousColSeparator() {
        return this._previousColSeparator;
    }

    public String getPreviousRowSeparator() {
        return this._previousRowSeparator;
    }

    public void setTransferPathname(String string) {
        this._transferPathname = string;
    }

    public String getTransferPathname() {
        return this._transferPathname;
    }

    public void setTransferDataFormat(String string) {
        this._transferDataFormat = string;
    }

    public String getTransferDataFormat() {
        return this._transferDataFormat;
    }

    public void setTransferColumnOrder(String string) {
        this._transferColumnOrder = string;
    }

    public String getTransferColumnOrder() {
        return this._transferColumnOrder;
    }

    public void setTransferDecryption(String string) {
        this._transferDecryption = string;
    }

    public String getTransferDecryption() {
        return this._transferDecryption;
    }

    public void setTransferColSeparator(String string) {
        this._transferColSeparator = string;
    }

    public String getTransferColSeparator() {
        return this._transferColSeparator;
    }

    public void setTransferRowSeparator(String string) {
        this._transferRowSeparator = string;
    }

    public String getTransferRowSeparator() {
        return this._transferRowSeparator;
    }

    public void setTransferTrackingID(long l) {
        this._transferTrackingID = l;
    }

    public long getTransferTrackingID() {
        return this._transferTrackingID;
    }

    public void setTransferSequenceID(long l) {
        this._transferSequenceID = l;
    }

    public long getTransferSequenceID() {
        return this._transferSequenceID;
    }

    public boolean hasFileBeenTransferred() {
        boolean bl = false;
        try {
            this.useDB();
            String string = SQLs.getString("select pathname, output_to, col_order, col_sep, row_sep from spt_TableTransfer where id = {0} and time_end = (select max(time_end) from spt_TableTransfer where id = {0} and  pathname != null)", this.getTableObjectID());
            this.getRSet().open(string);
            if (this.getRSet().getNextRow()) {
                bl = true;
                this._previousTransferPathname = this.getRSet().getColumnString(1);
                this._previousTransferDataFormat = this.dataFormats[this.getRSet().getColumnInt(2) - 1];
                this._previousTransferColumnOrder = this.commandOptions[this.getRSet().getColumnInt(3) - 1];
                this._previousColSeparator = this.getRSet().getColumnString(4);
                if (this._previousColSeparator == null || this._previousColSeparator.length() == 0) {
                    this._previousColSeparator = ASEUtils.getString("SEPARATOR_DEFAULT");
                }
                this._previousRowSeparator = this.getRSet().getColumnString(5);
                if (this._previousRowSeparator == null || this._previousRowSeparator.length() == 0) {
                    this._previousRowSeparator = ASEUtils.getString("SEPARATOR_DEFAULT");
                }
                this._transferDataFormat = this._previousTransferDataFormat;
                this._transferColumnOrder = this._previousTransferColumnOrder;
                this._transferColSeparator = this._previousColSeparator;
                this._transferRowSeparator = this._previousRowSeparator;
            }
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public String getServerTimeStamp() throws SQLException {
        String string = "";
        String string2 = "select datepart(yy, getdate()), datepart(mm, getdate()), datepart(dd, getdate()), datepart(hh, getdate()), datepart(mi, getdate())";
        this.getRSet().open(string2);
        if (this.getRSet().getNextRow()) {
            string = this.getRSet().getColumnString(1);
            String string3 = this.getRSet().getColumnString(2);
            if (string3.length() == 1) {
                string = string + USERTABLE_SYSSTAT2;
            }
            string = string + string3;
            String string4 = this.getRSet().getColumnString(3);
            if (string4.length() == 1) {
                string = string + USERTABLE_SYSSTAT2;
            }
            string = string + string4;
            String string5 = this.getRSet().getColumnString(4);
            if (string5.length() == 1) {
                string = string + USERTABLE_SYSSTAT2;
            }
            string = string + string5;
            String string6 = this.getRSet().getColumnString(5);
            if (string6.length() == 1) {
                string = string + USERTABLE_SYSSTAT2;
            }
            string = string + string6;
        }
        return string;
    }

    public int getTrackingID() throws SQLException {
        int n = 1;
        try {
            this.useDB();
            String string = SQLs.getString("select max(tracking_id) from spt_TableTransfer where id = {0}", this.getTableObjectID());
            this.getRSet().open(string);
            if (this.getRSet().getNextRow()) {
                int n2 = this.getRSet().getColumnInt(1);
                n = n2 + 1;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return n;
    }

    public Vector getSuccessfulTransfers() throws SQLException {
        Vector vector = new Vector();
        try {
            String string = SQLs.getString("select sequence_id, tracking_id, pathname, time_end from spt_TableTransfer where id = {0} order by time_end desc", this.getTableObjectID());
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                Vector<Object> vector2 = new Vector<Object>();
                vector2.addElement(this.getRSet().getColumnInt(1));
                vector2.addElement(this.getRSet().getColumnInt(2));
                vector2.addElement(this.getRSet().getColumnString(3));
                vector2.addElement(this.getRSet().getColumnDate(4));
                vector.addElement(vector2);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }

    public void executeIncrementalTransferOut(ASConnection aSConnection) throws SQLException {
        if (this.getTransferDataFormat().length() > 0) {
            if (this.getTransferDataFormat().equals("ASE")) {
                this.setTransferColumnOrder("offset");
            } else if (this.getTransferDataFormat().equals("BCP")) {
                this.setTransferColumnOrder("id");
            }
        }
        boolean bl = false;
        String string = "transfer table " + this.getFullyQualifiedName() + " to " + "'" + this.getTransferPathname() + "'" + " ";
        if (this.getTransferDataFormat().length() > 0) {
            string = string + "for " + this.getTransferDataFormat() + " ";
        }
        if (this.getTransferColumnOrder().length() > 0) {
            bl = true;
            string = string + "with column_order = '" + this.getTransferColumnOrder() + "'" + ", ";
        }
        if (this.getTransferDecryption().length() > 0) {
            string = string + "encryption = '" + this.getTransferDecryption() + "'" + ", ";
        }
        if (this.getTransferDataFormat().equals("CSV")) {
            if (this.getTransferColSeparator().length() > 0 && !this.getTransferColSeparator().equals(ASEUtils.getString("SEPARATOR_DEFAULT"))) {
                string = string + "column_separator = '" + this.getTransferColSeparator() + "'" + ", ";
            }
            if (this.getTransferRowSeparator().length() > 0 && !this.getTransferColSeparator().equals(ASEUtils.getString("SEPARATOR_DEFAULT"))) {
                string = string + "row_separator = '" + this.getTransferRowSeparator().toString() + "'" + ", ";
            }
        }
        if (this.getTransferTrackingID() != -1L) {
            string = string + "tracking_id = " + this.getTransferTrackingID() + ", ";
        }
        if (this.getTransferSequenceID() != -1L) {
            string = string + "resend = " + this.getTransferSequenceID() + ", ";
        }
        string = string.replaceAll("\b", "<bs>");
        string = string.replaceAll("\n", "<lf>");
        string = string.replaceAll("\r", "<cr>");
        string = string.replaceAll("\t", "<tab>");
        if (bl) {
            string = string.substring(0, string.length() - 2);
        }
        this.useDB();
        aSConnection.executeCommand(string);
    }

    public String[] getIncrementalTransferStatus(ASConnection aSConnection) throws SQLException {
        String[] stringArray = new String[3];
        String string = "";
        if (this.getTransferTrackingID() != -1L) {
            string = string + "and TrackingID = " + this.getTransferTrackingID() + " ";
        }
        if (this.getTransferSequenceID() != -1L) {
            string = string + "and SequenceID = " + this.getTransferSequenceID() + " ";
        }
        String string2 = SQLs.getString("select PercentDone, BytesSent, RowsSent from master..monTableTransfer where DBID = {0} and TableID = {1} {2} and BeginTime = (select max(BeginTime) from master..monTableTransfer)", this.getDatabaseSO().getID(), this.getTableObjectID(), string);
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        aSResultSet.open(string2);
        if (aSResultSet.getNextRow()) {
            stringArray[0] = aSResultSet.getColumnString(1);
            stringArray[1] = aSResultSet.getColumnString(2);
            stringArray[2] = aSResultSet.getColumnString(3);
        } else {
            stringArray[0] = "100";
            stringArray[1] = "-1";
            stringArray[2] = "-1";
        }
        return stringArray;
    }

    public void setTransferInPathname(String string) {
        this._transferInPathname = string;
    }

    public String getTransferInPathname() {
        return this._transferInPathname;
    }

    public void executeIncrementalTransferIn(ASConnection aSConnection) throws SQLException {
        boolean bl = false;
        String string = "transfer table " + this.getFullyQualifiedName() + " from " + "'" + this.getTransferInPathname() + "'" + " ";
        string = string + "for ase";
        this.useDB();
        aSConnection.executeCommand(string);
    }

    public boolean getSettingForDMLLOGGING() throws SQLException {
        boolean bl = false;
        String string = SQLs.getString("select sysstat3 from sysobjects where id = object_id(''{0}'')", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1);
            if ((Integer.parseInt(string2) & 1) == 1) {
                bl = true;
                continue;
            }
            if ((Integer.parseInt(string2) & 2) == 2) {
                bl = false;
                continue;
            }
            bl = this.getDefaultSettingForDMLLOGGING();
        }
        this.getRSet().close();
        return bl;
    }

    public boolean getDefaultSettingForDMLLOGGING() throws SQLException {
        boolean bl = false;
        String string = SQLs.getString("select object_attr(''{0}'', ''{1}'')", this.getName(), DMLLOGGING);
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1).trim();
            if (string2.toString().toLowerCase().equals(FULL)) {
                bl = true;
                continue;
            }
            bl = false;
        }
        this.getRSet().close();
        return bl;
    }

    public void setDMLLOGGINGSQL(boolean bl) throws SQLException {
        if (bl) {
            String string = SQLs.getString("alter table {0} set dml_logging = {1}", this.getName(), FULL);
            this._conn.executeCommand(string);
        } else {
            String string = SQLs.getString("alter table {0} set dml_logging = {1}", this.getName(), MINIMAL);
            this._conn.executeCommand(string);
        }
    }
}

