/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class TimeRangeSO
extends ASEBaseItemSO {
    public static final String[] WEEKDAYS = new String[]{"", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    public static final int COL_NAME = 0;
    public static final int COL_ID = 1;
    public static final int COL_STARTDAY = 2;
    public static final int COL_ENDDAY = 3;
    public static final int COL_STARTTIME = 4;
    public static final int COL_ENDTIME = 5;
    private String _id;
    private String _startday;
    private String _endday;
    private String _starttime;
    private String _endtime;

    public TimeRangeSO(ASConnection aSConnection) {
        this(aSConnection, "");
    }

    public TimeRangeSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
    }

    public void load(String[] stringArray) {
        this.setName(stringArray[0]);
        this.setID(stringArray[1]);
        this.setStartday(WEEKDAYS[Integer.valueOf(stringArray[2])]);
        this.setEndday(WEEKDAYS[Integer.valueOf(stringArray[3])]);
        this.setStarttime(stringArray[4]);
        this.setEndtime(stringArray[5]);
    }

    @Override
    public void create() throws SQLException {
        Object[] objectArray = new String[]{this.getName(), this.getStartday(), this.getEndday(), this.getStarttime(), this.getEndtime()};
        String string = SQLs.getString("exec sp_add_time_range ''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}''", objectArray);
        this._conn.executeCommand(string);
    }

    public void update() throws SQLException {
        Object[] objectArray = new String[]{this.getName(), this.getStartday(), this.getEndday(), this.getStarttime(), this.getEndtime()};
        String string = SQLs.getString("exec sp_modify_time_range ''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}''", objectArray);
        this._conn.executeCommand(string);
    }

    @Override
    public void remove() throws SQLException {
        String string = SQLs.getString("exec sp_drop_time_range ''{0}''", this.getName());
        this._conn.executeCommand(string);
    }

    @Override
    public boolean exists() {
        boolean bl = false;
        try {
            this.getRSet().open(SQLs.getString("select * from master.dbo.systimeranges s WHERE s.name =''{0}''", this.getName()));
            bl = this.getRSet().getNextRow();
            this.getRSet().close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    public void copy(String string) throws SQLException {
        Object[] objectArray = new String[]{string, this.getStartday(), this.getEndday(), this.getStarttime(), this.getEndtime()};
        String string2 = SQLs.getString("exec sp_add_time_range ''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}''", objectArray);
        this._conn.executeCommand(string2);
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getID(), this.getStartday().trim(), this.getEndday().trim(), this.getStarttime().trim(), this.getEndtime().trim()};
    }

    public String getEndday() {
        return this._endday;
    }

    public void setEndday(String string) {
        this._endday = string;
    }

    public String getEndtime() {
        return this._endtime;
    }

    public void setEndtime(String string) {
        this._endtime = string;
    }

    public String getStartday() {
        return this._startday;
    }

    public void setStartday(String string) {
        this._startday = string;
    }

    public String getStarttime() {
        return this._starttime;
    }

    public void setStarttime(String string) {
        this._starttime = string;
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public String[] validateTimes(String string, String string2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        simpleDateFormat.setLenient(false);
        try {
            gregorianCalendar.setTime(simpleDateFormat.parse(string));
        }
        catch (ParseException parseException) {
            return new String[]{ASEUtils.getString("ERR_INVALID_TIME") + string, "0"};
        }
        try {
            gregorianCalendar2.setTime(simpleDateFormat.parse(string2));
        }
        catch (ParseException parseException) {
            return new String[]{ASEUtils.getString("ERR_INVALID_TIME") + string2, "1"};
        }
        try {
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
            gregorianCalendar3.setTime(simpleDateFormat.parse("00:00"));
            if (!gregorianCalendar2.equals(gregorianCalendar3) && gregorianCalendar.after(gregorianCalendar2)) {
                return new String[]{ASEUtils.getString("ERR_END_TIME_LT_START_TIME"), "2"};
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_TIMERANGE_TYPE");
    }

    @Override
    public boolean includeDelete() {
        return this.getName() != null && !this.getName().equals("at all times");
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSARole();
    }
}

