/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.IndexSO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.UniqueConstraintsCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class UniqueConstraintSO
extends IndexSO {
    public static final String INDEX_ID_CLUSTERED = "1";
    protected static String UNIQUECONSTRAINTSCTR_OPEN_QUERY;
    protected static int ATTR_COL_UNIQUECONSTRAINT_NAME;
    protected static int ATTR_COL_UNIQUECONSTRAINT_CREATOR;
    protected static int ATTR_COL_UNIQUECONSTRAINT_ID;
    protected static String COLUMNSCTR_OPEN_QUERY;
    protected int ATTR_COL_COLUMN_NAME;
    protected static String SEGMENT_QUERY;
    protected static int ATTR_COL_SEGMENT_NAME;
    private static int IDX_STATUS_CLUSTERED;
    private static int IDX_STATUS2_CLUSTERED;
    private static int IDX_STATUS_ONPKEY;
    private Vector _columns;
    private Vector _columnsOrder;
    private Vector _vIndexedColumns = new Vector();
    private boolean _blnWizParamClustered;
    private boolean _bIsConstraintPrimary;
    private String _indexedColumnNamesString = "";
    private String[] _attrib = new String[11];

    public UniqueConstraintSO(ASConnection aSConnection, String string, TableSO tableSO) {
        super(aSConnection, tableSO, string);
        this.setType("KC");
    }

    public void load(String[] stringArray) {
        this._attrib = stringArray;
        this._indexedColumnNamesString = this.getIndexedColumnNames();
    }

    @Override
    public void create() throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("alter table").append(" ").append(this.getDatabaseName()).append(".").append(this.getTableOwner()).append(".").append(this.getTableName()).append(" ").append("add constraint").append(" ").append(this.getName()).append(" ");
        if (this.isConstraintPrimary()) {
            stringBuffer.append("primary key");
        } else {
            stringBuffer.append("unique");
        }
        stringBuffer.append(" ");
        if (this.getWizardParameterClustered()) {
            stringBuffer.append("clustered");
        } else {
            stringBuffer.append("nonclustered");
        }
        stringBuffer.append(" (");
        for (n = 0; n < this._columns.size(); ++n) {
            stringBuffer.append(this._columns.elementAt(n));
            stringBuffer.append(" " + this._columnsOrder.elementAt(n));
            stringBuffer.append(", ");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 2, ')');
        if (this.getFillFactor() != 0 || this.getMaxRowsPerPage() != 0 || this.getReservePageGap() != 0) {
            stringBuffer.append("with").append(" ");
        }
        n = 0;
        if (this.getFillFactor() != 0) {
            stringBuffer.append("fillfactor").append("=");
            stringBuffer.append(this.getFillFactor()).append(" ");
            n = 1;
        }
        if (this.getMaxRowsPerPage() != 0) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("max_rows_per_page").append("=").append(this.getMaxRowsPerPage()).append(" ");
            n = 1;
        }
        if (this.getReservePageGap() != 0) {
            if (n != 0) {
                stringBuffer.append(" , ");
            }
            stringBuffer.append("reservepagegap").append("=").append(this.getReservePageGap()).append(" ");
        }
        if (!this.getSegmentName().equals("default")) {
            stringBuffer.append("on").append(" ").append(this.getSegmentName());
        }
        this._databaseSO.useDB();
        this._conn.executeCommand(stringBuffer.toString());
        if (this.getFillFactor() != 0) {
            this.setOwner(this.getTableOwner());
            this.modifyFillFactor(this.getFillFactor() + "");
        }
    }

    @Override
    public void remove() throws SQLException {
        Object[] objectArray = new String[]{this.getDatabaseName(), this.getOwner(), this.getTableName(), this.getName()};
        this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} drop constraint {3}", objectArray));
    }

    public Vector getAllColumnsOfTable() throws SQLException {
        UniqueConstraintsCtrSO uniqueConstraintsCtrSO = new UniqueConstraintsCtrSO(this.getConnection(), this._tableSO);
        return uniqueConstraintsCtrSO.getAllColumnsOfTable();
    }

    @Override
    public void setColumns(Vector vector) {
        this._columns = vector;
    }

    @Override
    public Object[] getColumns() {
        return this._columns.toArray();
    }

    @Override
    public void setColumnsOrder(Vector vector) {
        this._columnsOrder = vector;
    }

    @Override
    public void setOwner(String string) {
        this._attrib[1] = string;
    }

    @Override
    public String getOwner() {
        return this._attrib[1];
    }

    @Override
    public String getIndexID() {
        return this._attrib[2];
    }

    @Override
    public int getFillFactor() {
        if (this._attrib == null || this._attrib[7] == null) {
            return 0;
        }
        return new Integer(this._attrib[7]);
    }

    @Override
    public void setFillFactor(String string) {
        this._attrib[7] = string;
    }

    @Override
    public int getMaxRowsPerPage() {
        if (this._attrib == null || this._attrib[6] == null) {
            return 0;
        }
        return new Integer(this._attrib[6]);
    }

    @Override
    public void setMaxRowsPerPage(String string) {
        this._attrib[6] = string;
    }

    @Override
    public String getSegmentName() {
        if (this._attrib == null || this._attrib[9] == null) {
            return "default";
        }
        return this._attrib[9];
    }

    @Override
    public void setSegmentName(String string) {
        this._attrib[9] = string;
    }

    @Override
    public int getReservePageGap() {
        if (this._attrib == null || this._attrib[8] == null) {
            return 0;
        }
        return new Integer(this._attrib[8]);
    }

    @Override
    public void setReservePageGap(String string) {
        this._attrib[8] = string;
    }

    public int getColumnCount() {
        return new Integer(this._attrib[3]);
    }

    @Override
    public boolean isClustered() {
        if (this._attrib[5] == null) {
            this._attrib[5] = "0";
        }
        if (this._attrib[4] == null) {
            this._attrib[4] = "0";
        }
        int n = new Integer(this._attrib[5]);
        int n2 = new Integer(this._attrib[4]);
        return (n & IDX_STATUS2_CLUSTERED) == IDX_STATUS2_CLUSTERED || (n2 & IDX_STATUS_CLUSTERED) == IDX_STATUS_CLUSTERED;
    }

    @Override
    public String clusteredText() {
        return this.isClustered() ? ASEUtils.getString("MSG_CLUSTERED_TYPE") : ASEUtils.getString("MSG_NOT_CLUSTERED_TYPE");
    }

    @Override
    public String clusteredYesNoText() {
        return this.isClustered() ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
    }

    public boolean getWizardParameterClustered() {
        return this._blnWizParamClustered;
    }

    public void setWizardParameterClustered(boolean bl) {
        this._blnWizParamClustered = bl;
    }

    public boolean isConstraintPrimary() {
        return this._bIsConstraintPrimary;
    }

    public void setConstraintPrimary(boolean bl) {
        this._bIsConstraintPrimary = bl;
    }

    public String getPrimaryKeyConstraintName() throws SQLException {
        this._tableSO.getPrimaryKeyColumns();
        return this._tableSO.getPrimaryKeyConstraintName();
    }

    @Override
    public boolean clusteredIndexExists() throws SQLException {
        return this._tableSO.clusteredIndexExists();
    }

    public boolean IsOnPrimaryKey() {
        return (Integer.parseInt(this._attrib[4]) & IDX_STATUS_ONPKEY) != 0;
    }

    public String uniqueTypeText() {
        return this.IsOnPrimaryKey() ? ASEUtils.getString("DNAME_PRIMARYCONSTRAINT") : ASEUtils.getString("MSG_UNI_CONSTRAINT");
    }

    @Override
    public String uniqueYesNoText() {
        return ASEUtils.getString("MSG_YES");
    }

    public boolean reName(String string) throws SQLException {
        this.useDB();
        this.setUser();
        String string2 = this.getTableName() + "." + this.getName();
        this._conn.executeCommand(SQLs.getString("exec sp_rename ''{0}'', ''{1}''", string2, string));
        return true;
    }

    private void setUser() throws SQLException {
        Utility.setUser(this.getConnection(), this.getOwner());
    }

    public void bindSegment(String string) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_placeobject ''{0}'', ''{1}''", string, this.getOwner() + "." + this.getTableName() + "." + this.getName()));
    }

    public void modifyMaxRowsPerPage(String string) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_chgattribute ''{0}'', ''max_rows_per_page'', {1}", this.getTableName() + "." + this.getName(), string));
    }

    public void modifyReservePageGap(String string) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_chgattribute ''{0}'', ''reservepagegap'', {1}", this.getTableName() + "." + this.getName(), string));
    }

    public void modifyFillFactor(String string) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_chgattribute ''{0}'', ''fillfactor'', {1}", this.getTableName() + "." + this.getName(), string));
    }

    @Override
    public Object[] getAttributes() {
        return new Object[]{this.getName(), this.uniqueTypeText(), this.clusteredYesNoText(), this.uniqueYesNoText(), this.getIndexedColumnNamesString()};
    }

    public List getIndexedColumns() throws SQLException {
        Vector<ColumnSO> vector = new Vector<ColumnSO>();
        int n = this.getColumnCount();
        if (this.getIndexID().equals(INDEX_ID_CLUSTERED)) {
            ++n;
        }
        for (int i = 1; i < n; ++i) {
            String string = "'" + this.getTableSO().getFullyQualifiedName() + "'," + this.getIndexID() + "," + String.valueOf(i);
            Object[] objectArray = new String[]{string, this.getDatabaseName(), this._tableSO.getTableObjectID()};
            String string2 = SQLs.getString("select COL_NAME=index_col({0}), TYPE=isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), ALLOWS_NULL=case when status&8=8 then \"Y\" else \"N\" end, LEN=C.length, PREC=C.prec, SCALE=C.scale, RULE_ID=C.domain, DEFAULT_ID=C.cdefault, STATUS=C.status, USER_TYPE=T.usertype, TABLE_ID=C.id, ID=C.colid, CHAR_SIZE=isnull(@@ncharsize,1), xstatus=C.xstatus, blankplaceholder1 = 0, blankplaceholder2 = 0,INDEX_COL_ORDER=index_colorder({0}) from {1}.dbo.syscolumns C, {1}.dbo.systypes T, {1}.dbo.sysxtypes X where C.id = {2} and C.name = index_col({0}) and C.usertype *= T.usertype and C.xtype *= X.xtid order by colid", objectArray);
            this.getRSet().open(string2);
            this.getRSet().getNextRow();
            String[] stringArray = this.getRSet().getColumnsAsArray();
            ColumnSO columnSO = new ColumnSO(this.getConnection(), stringArray[0], this._tableSO);
            columnSO.load(stringArray);
            vector.add(columnSO);
        }
        return vector;
    }

    public Vector getIndexedColumnNameList() throws SQLException {
        if (this._vIndexedColumns.size() == 0) {
            int n = this.getColumnCount();
            if (this.getIndexID().equals(INDEX_ID_CLUSTERED)) {
                ++n;
            }
            for (int i = 1; i < n; ++i) {
                this.getRSet().open(SQLs.getString("select COL_NAME=index_col(''{0}'', {1}, {2} ), SORT_ORDER=index_colorder(''{0}'', {1}, {2})", this.getTableSO().getFullyQualifiedName(), this.getIndexID(), String.valueOf(i)));
                this.getRSet().getNextRow();
                Vector<String> vector = new Vector<String>();
                vector.addElement(this.getRSet().getColumnString(1));
                this._vIndexedColumns.addElement(vector);
            }
        }
        return this._vIndexedColumns;
    }

    @Override
    public String getIndexedColumnNamesString() {
        return this._indexedColumnNamesString;
    }

    @Override
    public String getIndexedColumnNames() {
        Vector vector = null;
        try {
            vector = this.getIndexedColumnNameList();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            stringBuffer.append(vector2.elementAt(0)).append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_UNI_CONSTRAINT");
    }

    static {
        IDX_STATUS_CLUSTERED = 16;
        IDX_STATUS2_CLUSTERED = 512;
        IDX_STATUS_ONPKEY = 2048;
    }
}

