/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class Utility {
    public static Vector openQuery(String string, ASConnection aSConnection) {
        Vector<String[]> vector = new Vector<String[]>();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open(string);
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                vector.addElement(stringArray);
            }
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(new JFrame(), sQLException.getMessage(), ASEUtils.getString("MSG_ERROR"), 2);
        }
        return vector;
    }

    public static Vector<String[]> openQuery2(String string, ASConnection aSConnection) throws SQLException {
        Vector<String[]> vector = new Vector<String[]>();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        aSResultSet.open(string);
        while (aSResultSet.getNextRow()) {
            String[] stringArray = aSResultSet.getColumnsAsArray();
            vector.addElement(stringArray);
        }
        aSResultSet.close();
        return vector;
    }

    public static double getPrecision(double d, int n) {
        double d2 = 0.5;
        if (d == 0.0) {
            return d;
        }
        if (n != 0) {
            d2 /= Math.pow(10.0, n);
        }
        double d3 = d + d2;
        String string = String.valueOf(d3);
        int n2 = string.indexOf(".");
        int n3 = string.indexOf("E");
        if (n2 != -1 && n3 == -1) {
            return Double.valueOf(string.substring(0, n2 + n + 1));
        }
        if (n2 != -1 && n3 != -1) {
            String string2 = string.substring(0, n2 + n + 1) + string.substring(n3, string.length());
            return Double.valueOf(string2);
        }
        return Double.valueOf(string);
    }

    public static boolean hasValidName(ASConnection aSConnection, String string, boolean bl) throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        String string2 = "";
        string2 = bl ? SQLs.getString("select valid_name( ''{0}'' )", string.trim()) : SQLs.getString("select valid_name( ''{0}'', {1} )", string.trim(), "255");
        aSResultSet.open(string2);
        aSResultSet.getNextRow();
        int n = aSResultSet.getColumnInt(1);
        aSResultSet.close();
        return n > 0;
    }

    public static void reName(ASConnection aSConnection, String string, String string2, String string3) throws SQLException {
        String string4 = SQLs.getString("USE {0}", string3);
        aSConnection.executeCommand(string4);
        String string5 = SQLs.getString("exec sp_rename ''{0}'', ''{1}''", string, string2);
        aSConnection.executeCommand(string5);
    }

    public static void setUser(ASConnection aSConnection, String string) throws SQLException {
        String string2 = SQLs.getString("setuser ''{0}''", string);
        aSConnection.executeCommand(string2);
    }

    public static void unSetUser(ASConnection aSConnection) throws SQLException {
        String string = "setuser ";
        aSConnection.executeCommand(string);
    }

    public static double getMBToPageSize(ASConnection aSConnection) {
        double d = aSConnection.getPageSize();
        double d2 = 1048576.0 / d;
        return d2;
    }

    public static double getMBToPageSize(ASConnection aSConnection, double d) {
        double d2 = aSConnection.getPageSize();
        double d3 = 1048576.0 / d2 * d;
        return d3;
    }

    public static double getGBToPageSize(ASConnection aSConnection, double d) {
        double d2 = aSConnection.getPageSize();
        double d3 = 1.073741824E9 / d2 * d;
        return d3;
    }

    public static double getKBToPageSize(ASConnection aSConnection, double d) {
        double d2 = aSConnection.getPageSize();
        double d3 = 1024.0 / d2 * d;
        return d3;
    }

    public static double getPageSizeToMB(ASConnection aSConnection, double d) {
        double d2 = aSConnection.getPageSize();
        double d3 = d2 / 1048576.0 * d;
        return d3;
    }

    public static double getPageSizeToGB(ASConnection aSConnection, double d) {
        double d2 = aSConnection.getPageSize();
        double d3 = d2 / 1.073741824E9 * d;
        return d3;
    }

    public static double getPageSizeToKB(ASConnection aSConnection, double d) {
        double d2 = aSConnection.getPageSize();
        double d3 = d2 / 1024.0 * d;
        return d3;
    }

    public static double getKBToMB(double d) {
        return d / 1024.0;
    }

    public static double getKBToGB(double d) {
        return d / 1048576.0;
    }

    public static double getMBToKB(double d) {
        return d * 1024.0;
    }

    public static double getMBToGB(double d) {
        return d / 1024.0;
    }

    public static double getGBToKB(double d) {
        return d * 1024.0 * 1024.0;
    }

    public static int getOrigSelection(String string, JComboBox jComboBox) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            String string2;
            Object e = jComboBox.getItemAt(i);
            if (!(e instanceof JLabel ? (string2 = ((JLabel)e).getText()).compareTo(string) == 0 : (string2 = (String)e).compareTo(string) == 0)) continue;
            return i;
        }
        return 0;
    }

    public static String[] getVectorToArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String stringArrayToString(Object[] objectArray, boolean bl) {
        return Utility.stringArrayToString(objectArray, ",", bl ? "'" : null);
    }

    public static String stringArrayToString(Object[] objectArray, String string) {
        return Utility.stringArrayToString(objectArray, string, "");
    }

    public static String stringArrayToString(Object[] objectArray, String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = string2 != null ? string2 : "";
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object != null) {
                object = string5 + object.toString() + string5;
                string3 = string3 + string4 + object;
            }
            string4 = string;
        }
        return string3;
    }

    public static String getCurrentUser(ASConnection aSConnection) {
        Vector vector = Utility.openQuery("select user_name()", aSConnection);
        String[] stringArray = (String[])vector.elementAt(0);
        return stringArray[0];
    }

    public static String getCode(ASConnection aSConnection, String string, String string2) throws SQLException {
        String string3 = SQLs.getString("select text from {0}.dbo.syscomments where id = {1} order by colid2, colid", string, string2);
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        String string4 = "";
        aSResultSet.open(string3);
        while (aSResultSet.getNextRow()) {
            string4 = string4 + aSResultSet.getColumnString(1);
        }
        aSResultSet.close();
        return string4.trim();
    }

    public static String getUserName(ASConnection aSConnection, String string) throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        String string2 = "";
        aSResultSet.open(SQLs.getString("select user_name({0})", string));
        while (aSResultSet.getNextRow()) {
            string2 = aSResultSet.getColumnString(1);
        }
        return string2;
    }

    public static String getUserID(ASConnection aSConnection, String string, String string2) throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        String string3 = "";
        aSConnection.executeCommand(SQLs.getString("USE {0}", string));
        aSResultSet.open(SQLs.getString("select user_id(''{0}'')", string2));
        while (aSResultSet.getNextRow()) {
            string3 = aSResultSet.getColumnString(1);
        }
        return string3;
    }

    public static String[] getTriggerTable(ASConnection aSConnection, String string, String string2, String string3) throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        String[] stringArray = new String[2];
        String string4 = SQLs.getString("select name, id , uid from {0}.dbo.sysobjects where deltrig in (select id from {0}.dbo.sysobjects where name = ''{1}'' and type =''TR'' and uid = {2} ) or seltrig in (select id from {0}.dbo.sysobjects where name = ''{1}'' and type =''TR'' and uid = {2}) ", string, string2, string3);
        string4 = string4 + SQLs.getString(" or updtrig in (select id from {0}.dbo.sysobjects where name = ''{1}'' and type =''TR'' and uid = {2}) or instrig in (select id from {0}.dbo.sysobjects where name = ''{1}'' and type =''TR'' and uid = {2})", string, string2, string3);
        aSResultSet.open(string4);
        while (aSResultSet.getNextRow()) {
            stringArray[0] = aSResultSet.getColumnString(1);
            stringArray[1] = aSResultSet.getColumnString(3);
        }
        return stringArray;
    }

    private static Vector refer(ASConnection aSConnection, String string, ImageIcon imageIcon) throws SQLException {
        Vector vector = new Vector();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        aSResultSet.open(string);
        while (aSResultSet.getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(aSResultSet.getColumnString(1), imageIcon, 0));
            vector2.addElement(aSResultSet.getColumnString(2));
            vector.addElement(vector2);
        }
        aSResultSet.close();
        return vector;
    }

    public static Vector referESP(ASConnection aSConnection, String string) throws SQLException {
        return Utility.refer(aSConnection, string, new ImageIcon(ASEImages.getEspSmallImage()));
    }

    public static Vector referProcedure(ASConnection aSConnection, String string) throws SQLException {
        return Utility.refer(aSConnection, string, new ImageIcon(ASEImages.getStoredProcedureSmallImage()));
    }

    public static Vector referTable(ASConnection aSConnection, String string) throws SQLException {
        return Utility.refer(aSConnection, string, new ImageIcon(ASEImages.getTableSmallImage()));
    }

    public static Vector referView(ASConnection aSConnection, String string) throws SQLException {
        return Utility.refer(aSConnection, string, new ImageIcon(ASEImages.getViewSmallImage()));
    }

    public static String getOwnerName(ASConnection aSConnection, String string, String string2) throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        aSConnection.executeCommand(SQLs.getString("USE {0}", string));
        String string3 = "";
        String string4 = SQLs.getString("select ''{0}'', u.name, o.name from {0}.dbo.sysusers u, {0}.dbo.sysobjects o where u.uid=o.uid and u.name like ''{1}'' and o.id={2}", string, "%", string2);
        aSResultSet.open(string4);
        while (aSResultSet.getNextRow()) {
            string3 = aSResultSet.getColumnString(2);
        }
        return string3;
    }

    public static List<String[]> getOwners(ASConnection aSConnection, String string) throws SQLException {
        String string2 = SQLs.getString("select u.name, g.name from {0}.dbo.sysusers u, {0}.dbo.sysusers g, master.dbo.syslogins m where u.suid *= m.suid and u.gid *= g.uid and u.uid <= 16383 and u.uid > 0 order by 1", string);
        return Utility.openQuery2(string2, aSConnection);
    }

    public static String getExpression(String string) {
        String string2 = string.trim();
        String string3 = string.trim().toUpperCase();
        int n = -1;
        if (string3.indexOf("/*") != -1) {
            return string;
        }
        while ((n = string3.indexOf("AS")) != -1) {
            char c = string3.charAt(n - 1);
            char c2 = string3.charAt(n + 2);
            if (Utility.hasToken(c) && Utility.hasToken(c2)) {
                return string2.substring(n + 3).trim();
            }
            string3 = string3.substring(n + 2);
            string2 = string2.substring(n + 2);
        }
        return string;
    }

    private static boolean hasToken(char c) {
        char[] cArray = new char[]{' ', '\t', '\n'};
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return true;
        }
        return false;
    }

    public static String checkDatabaseConsistency(ASConnection aSConnection, DatabaseSO databaseSO, String string) throws SQLException {
        String string2;
        block4: {
            string2 = "";
            boolean bl = string.indexOf(", fix") > 0;
            try {
                databaseSO.useDB();
                if (bl) {
                    databaseSO.setOption("DB_OP_SINGLE_USER", true);
                }
                string2 = aSConnection.executeReturnWarningMsg(databaseSO.getDisplayName(), string);
                if (bl) {
                    bl = false;
                    databaseSO.setOption("DB_OP_SINGLE_USER", false);
                }
            }
            catch (SQLException sQLException) {
                if (!bl) break block4;
                databaseSO.setOption("DB_OP_SINGLE_USER", false);
                throw sQLException;
            }
        }
        return string2;
    }

    public static String convertArrayType(String string) {
        if (string.startsWith("[L") && string.indexOf(";") > 0) {
            string = string.substring(2, string.indexOf(";")) + "[]";
        } else if (string.equals("[B")) {
            string = "byte[]";
        } else if (string.equals("[C")) {
            string = "char[]";
        } else if (string.equals("[D")) {
            string = "double[]";
        } else if (string.equals("[F")) {
            string = "float[]";
        } else if (string.equals("[I")) {
            string = "int[]";
        } else if (string.equals("[J")) {
            string = "long[]";
        } else if (string.equals("[S")) {
            string = "short[]";
        } else if (string.equals("[Z")) {
            string = "boolean[]";
        }
        return string;
    }

    public static Vector getColsPermission(ASConnection aSConnection, String string, String string2, String string3) {
        int n = 1;
        int n2 = 2;
        int n3 = 3;
        int n4 = 4;
        int n5 = 5;
        int n6 = 6;
        int n7 = 7;
        Vector vector = new Vector();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSConnection.executeCommand(SQLs.getString("USE {0}", string));
            aSResultSet.open(SQLs.getString("exec sp_helprotect ''{0}'',''{1}''", string2, string3));
            while (aSResultSet.getNextRow()) {
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement(aSResultSet.getColumnString(n));
                vector2.addElement(aSResultSet.getColumnString(n2));
                vector2.addElement(aSResultSet.getColumnString(n3).toLowerCase());
                vector2.addElement(aSResultSet.getColumnString(n4).toLowerCase());
                vector2.addElement(aSResultSet.getColumnString(n5));
                vector2.addElement(aSResultSet.getColumnString(n6));
                vector2.addElement(aSResultSet.getColumnString(n7));
                vector.addElement(vector2);
            }
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }

    public static Set getRoleInServer(ASConnection aSConnection) throws SQLException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(aSConnection);
        List<DatabaseSO> list = databasesCtrSO.getNormalDBList(1);
        for (DatabaseSO databaseSO : list) {
            String string = SQLs.getString("select S.name from {0}.dbo.sysroles R, {0}.dbo.sysusers S where R.lrid=S.uid and R.id>=0", databaseSO.getName());
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            try {
                aSResultSet.open(string);
            }
            catch (SQLException sQLException) {
                continue;
            }
            while (aSResultSet.getNextRow()) {
                treeMap.put(aSResultSet.getColumnString(1), "");
            }
            aSResultSet.close();
        }
        return treeMap.keySet();
    }

    public static String resizeString(String string, int n) {
        if (string == null) {
            return "NULL";
        }
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(0, n);
        }
        for (int i = n - n2; i > 0; --i) {
            string = string + " ";
        }
        return string;
    }
}

