/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.WSConsumerConfigData;
import com.sybase.aseplugin.so.WSProducerConfigData;
import com.sybase.aseplugin.so.WebServicesConfigurationSO;
import com.sybase.util.ds.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

class WSConfigData {
    private String _sWSInterfacesFile;
    private String _sWSLDAPFile;
    private WSProducerConfigData _wsProducerConfigData = new WSProducerConfigData(this);
    private WSConsumerConfigData _wsConsumerConfigData = new WSConsumerConfigData(this);

    public WSConfigData() throws IOException {
        this.initDefaults();
    }

    public void initDefaults() {
        String string = WebServicesConfigurationSO._sSYBASE;
        this._sWSInterfacesFile = Utils.OS_WINDOWS ? string + File.separator + "ini" + File.separator + "sql.ini" : string + File.separator + "interfaces";
        this._sWSLDAPFile = Utils.OS_WINDOWS ? string + File.separator + "OCS-15_0" + File.separator + "ini" + File.separator + "libtcl.cfg" : string + File.separator + "OCS-15_0" + File.separator + "config" + File.separator + "libtcl.cfg";
    }

    public void loadFromPropFile() throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = Utils.getFileInputStream((String)WebServicesConfigurationSO._sWSPropFileURL);
        properties.load(fileInputStream);
        fileInputStream.close();
        String string = properties.getProperty("com.sybase.ase.ws.interfaces");
        if (string != null) {
            this.setInterfacesFile(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.libtcl")) != null) {
            this.setLDAPFile(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.producer.httpport")) != null) {
            this.setProducerPort(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.producer.logfilename")) != null) {
            this.setProducerLog(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.producer.jettylogfile")) != null) {
            this.setProducerHTTPLog(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.producer.ssl.password")) != null) {
            this.setCertificatePassword(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.producer.ssl.httpsport")) != null) {
            this.setSSLPort(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.producer.ssl.keystore")) != null) {
            this.setKeystoreLocation(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.producer.ssl.keypassword")) != null) {
            this.setKeystorePassword(string);
        }
        if ((string = properties.getProperty("com.sybase.ase.ws.consumer.logfilename")) != null) {
            this.setConsumerLog(string);
        }
    }

    public String getInterfacesFile() {
        return this._sWSInterfacesFile == null ? "" : this._sWSInterfacesFile;
    }

    public void setInterfacesFile(String string) {
        this._sWSInterfacesFile = string;
    }

    public String getLDAPFile() {
        return this._sWSLDAPFile == null ? "" : this._sWSLDAPFile;
    }

    public void setLDAPFile(String string) {
        this._sWSLDAPFile = string;
    }

    public String getProducerPort() {
        return this._wsProducerConfigData.getProducerPort();
    }

    public void setProducerPort(String string) {
        this._wsProducerConfigData.setProducerPort(string);
    }

    public String getProducerLog() {
        return this._wsProducerConfigData.getProducerLog();
    }

    public void setProducerLog(String string) {
        this._wsProducerConfigData.setProducerLog(string);
    }

    public String getProducerHTTPLog() {
        return this._wsProducerConfigData.getProducerHTTPLog();
    }

    public void setProducerHTTPLog(String string) {
        this._wsProducerConfigData.setProducerHTTPLog(string);
    }

    public String getCertificateHost() {
        return this._wsProducerConfigData.getCertificateHost();
    }

    public void setCertificateHost(String string) {
        this._wsProducerConfigData.setCertificateHost(string);
    }

    public String getSSLPort() {
        return this._wsProducerConfigData.getSSLPort();
    }

    public void setSSLPort(String string) {
        this._wsProducerConfigData.setSSLPort(string);
    }

    public String getKeystoreLocation() {
        return this._wsProducerConfigData.getKeystoreLocation();
    }

    public void setKeystoreLocation(String string) {
        this._wsProducerConfigData.setKeystoreLocation(string);
    }

    public String getCertificatePassword() {
        return this._wsProducerConfigData.getCertificatePassword();
    }

    public void setCertificatePassword(String string) {
        this._wsProducerConfigData.setCertificatePassword(string);
    }

    public String getKeystorePassword() {
        return this._wsProducerConfigData.getKeystorePassword();
    }

    public void setKeystorePassword(String string) {
        this._wsProducerConfigData.setKeystorePassword(string);
    }

    public String getConsumerName() {
        return this._wsConsumerConfigData.getConsumerName();
    }

    public void setConsumerName(String string) {
        this._wsConsumerConfigData.setConsumerName(string);
    }

    public String getConsumerHostName() {
        return this._wsConsumerConfigData.getConsumerHostName();
    }

    public void setConsumerHostName(String string) {
        this._wsConsumerConfigData.setConsumerHostName(string);
    }

    public String getConsumerPort() {
        return this._wsConsumerConfigData.getConsumerPort();
    }

    public void setConsumerPort(String string) {
        this._wsConsumerConfigData.setConsumerPort(string);
    }

    public String getConsumerLog() {
        return this._wsConsumerConfigData.getConsumerLog();
    }

    public void setConsumerLog(String string) {
        this._wsConsumerConfigData.setConsumerLog(string);
    }
}

