/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.WSConfigData;
import com.sybase.aseplugin.so.WebServicesConfigurationSO;
import java.io.File;

class WSSSLConfigData {
    private String _sSSLCertificateHostName;
    private String _encryptedSSLPort;
    private String _encryptedSSLKeystoreLocation;
    private String _sSSLCertPwd;
    private String _sSSLKestorePwd;
    private WSConfigData _parent;

    public WSSSLConfigData(WSConfigData wSConfigData) {
        this._parent = wSConfigData;
        this.initDefaults();
    }

    public void initDefaults() {
        this._sSSLCertificateHostName = WebServicesConfigurationSO._sLocalHostName;
        this._encryptedSSLPort = "8182";
        this._encryptedSSLKeystoreLocation = WebServicesConfigurationSO._sSYBASE + File.separator + "WS-15_0" + File.separator + "keystore";
        this._sSSLCertPwd = "";
        this._sSSLKestorePwd = "";
    }

    public String getCertificateHost() {
        return this._sSSLCertificateHostName == null ? "" : this._sSSLCertificateHostName;
    }

    public void setCertificateHost(String string) {
        this._sSSLCertificateHostName = string;
    }

    public String getSSLPort() {
        return this._encryptedSSLPort == null ? "" : ASEUtils.decryptPassword(this._encryptedSSLPort);
    }

    public void setSSLPort(String string) {
        this._encryptedSSLPort = ASEUtils.encryptPassword(string);
    }

    public String getKeystoreLocation() {
        return this._encryptedSSLKeystoreLocation == null ? "" : ASEUtils.decryptPassword(this._encryptedSSLKeystoreLocation);
    }

    public void setKeystoreLocation(String string) {
        this._encryptedSSLKeystoreLocation = ASEUtils.encryptPassword(string);
    }

    public String getCertificatePassword() {
        return this._sSSLCertPwd == null ? "" : this._sSSLCertPwd;
    }

    public void setCertificatePassword(String string) {
        this._sSSLCertPwd = string;
    }

    public String getKeystorePassword() {
        return this._sSSLKestorePwd == null ? "" : this._sSSLKestorePwd;
    }

    public void setKeystorePassword(String string) {
        this._sSSLKestorePwd = string;
    }
}

