/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.WSConfigData;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.util.ds.DirectoryServiceHelper;
import com.sybase.util.ds.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class WebServicesConfigurationSO
extends ASEBaseItemSO {
    public static String _sSYBASE;
    public static String _sWSPropFileURL;
    public static String _sLocalHostName;
    public static final String _sWSRoot = "WS-15_0";
    public static WSConfigData _defaultWSConfigValues;
    private WSConfigData _savedWSConfigValues;
    private WSConfigData _currentWSConfigValues;
    public static final long MAX_PORT_NO = 65535L;
    public static final long MIN_PORT_NO = 1025L;
    private int _iProgressPercentage = 0;
    private String _sLogFileName;
    private String _sServerName;
    private String _sHostName;
    private String _sPortNumber;
    private String _sLoginName;
    private String _encryptedPassword;
    private Connection _con;
    public static final String Q;
    public static final String Y;
    public static final String N;
    private char _cMode = (char)71;
    private String _sStdErr = null;
    private String _sStdOut = null;

    public WebServicesConfigurationSO() {
    }

    public WebServicesConfigurationSO(char c) {
        this._cMode = c;
    }

    public void init() throws IOException, Exception {
        _sSYBASE = this.getSybase();
        _sWSPropFileURL = _sSYBASE + File.separator + _sWSRoot + File.separator + "props" + File.separator + "ws.properties";
        this.getLocalHostName();
        _defaultWSConfigValues = new WSConfigData();
    }

    public void reInit(String string) throws IOException {
        _sSYBASE = string;
        _sWSPropFileURL = _sSYBASE + File.separator + _sWSRoot + File.separator + "props" + File.separator + "ws.properties";
        _defaultWSConfigValues = new WSConfigData();
    }

    public String getLogFileName() {
        return this._sLogFileName;
    }

    public void setLogFileName(String string) {
        this._sLogFileName = string;
    }

    public void loadFromPropFile() throws Exception {
        this._savedWSConfigValues = new WSConfigData();
        this._savedWSConfigValues.loadFromPropFile();
        this._currentWSConfigValues = new WSConfigData();
        this._currentWSConfigValues.loadFromPropFile();
    }

    @Override
    public Object[] getAttributes() {
        return null;
    }

    public String getServerName() {
        return this._sServerName;
    }

    public void setServerName(String string) {
        this._sServerName = string;
    }

    public String getHostName() {
        return this._sHostName;
    }

    public void setHostName(String string) {
        this._sHostName = string;
    }

    public String getPortNumber() {
        return this._sPortNumber;
    }

    public void setPortNumber(String string) {
        this._sPortNumber = string;
    }

    public String getLoginName() {
        return this._sLoginName;
    }

    public void setLoginName(String string) {
        this._sLoginName = string;
    }

    public String getPassword() {
        return ASEUtils.decryptPassword(this._encryptedPassword);
    }

    public void setPassword(String string) {
        this._encryptedPassword = ASEUtils.encryptPassword(string);
    }

    public int getProgressPercentage() {
        return this._iProgressPercentage;
    }

    public void setProgressPercentage(int n) {
        this._iProgressPercentage = n;
    }

    public void setMode(char c) {
        this._cMode = c;
    }

    public char getMode() {
        return this._cMode;
    }

    public String getSybaseDir() {
        return _sSYBASE;
    }

    public void setSybaseDir(String string) {
        _sSYBASE = string;
    }

    public String getWSPropFileURL() {
        return _sWSPropFileURL;
    }

    public String getLocalHostName() {
        if (_sLocalHostName.equals("")) {
            try {
                _sLocalHostName = InetAddress.getLocalHost().getHostName();
                int n = _sLocalHostName.indexOf(46);
                if (n != -1) {
                    _sLocalHostName = _sLocalHostName.substring(0, n);
                }
            }
            catch (Exception exception) {
                _sLocalHostName = "";
            }
        }
        return _sLocalHostName;
    }

    public boolean isWSPropFileWritable() {
        return ASEUtils.isWritableFile(this.getWSPropFileURL());
    }

    public String getDefaultInterfacesFile() {
        return _defaultWSConfigValues.getInterfacesFile();
    }

    public String getSavedInterfacesFile() {
        return this._savedWSConfigValues.getInterfacesFile();
    }

    public String getCurrentInterfacesFile() {
        return this._currentWSConfigValues.getInterfacesFile();
    }

    public void setCurrentInterfacesFile(String string) {
        this._currentWSConfigValues.setInterfacesFile(string);
    }

    public String getDefaultLDAPFile() {
        return _defaultWSConfigValues.getLDAPFile();
    }

    public String getSavedLDAPFile() {
        return this._savedWSConfigValues.getLDAPFile();
    }

    public String getCurrentLDAPFile() {
        return this._currentWSConfigValues.getLDAPFile();
    }

    public void setCurrentLDAPFile(String string) {
        this._currentWSConfigValues.setLDAPFile(string);
    }

    public String getDefaultProducerPort() {
        return _defaultWSConfigValues.getProducerPort();
    }

    public String getSavedProducerPort() {
        return this._savedWSConfigValues.getProducerPort();
    }

    public String getCurrentProducerPort() {
        return this._currentWSConfigValues.getProducerPort();
    }

    public void setCurrentProducerPort(String string) {
        this._currentWSConfigValues.setProducerPort(string);
    }

    public String getDefaultProducerLog() {
        return _defaultWSConfigValues.getProducerLog();
    }

    public String getSavedProducerLog() {
        return this._savedWSConfigValues.getProducerLog();
    }

    public String getCurrentProducerLog() {
        return this._currentWSConfigValues.getProducerLog();
    }

    public void setCurrentProducerLog(String string) {
        this._currentWSConfigValues.setProducerLog(string);
    }

    public String getDefaultProducerHTTPLog() {
        return _defaultWSConfigValues.getProducerHTTPLog();
    }

    public String getSavedProducerHTTPLog() {
        return this._savedWSConfigValues.getProducerHTTPLog();
    }

    public String getCurrentProducerHTTPLog() {
        return this._currentWSConfigValues.getProducerHTTPLog();
    }

    public void setCurrentProducerHTTPLog(String string) {
        this._currentWSConfigValues.setProducerHTTPLog(string);
    }

    public String getDefaultCertificateHost() {
        return _defaultWSConfigValues.getCertificateHost();
    }

    public String getSavedCertificateHost() {
        return this._savedWSConfigValues.getCertificateHost();
    }

    public String getCurrentCertificateHost() {
        return this._currentWSConfigValues.getCertificateHost();
    }

    public void setCurrentCertificateHost(String string) {
        this._currentWSConfigValues.setCertificateHost(string);
    }

    public String getDefaultSSLPort() {
        return _defaultWSConfigValues.getSSLPort();
    }

    public String getSavedSSLPort() {
        return this._savedWSConfigValues.getSSLPort();
    }

    public String getCurrentSSLPort() {
        return this._currentWSConfigValues.getSSLPort();
    }

    public void setCurrentSSLPort(String string) {
        this._currentWSConfigValues.setSSLPort(string);
    }

    public String getDefaultKeystoreLocation() {
        return _defaultWSConfigValues.getKeystoreLocation();
    }

    public String getSavedKeystoreLocation() {
        return this._savedWSConfigValues.getKeystoreLocation();
    }

    public String getCurrentKeystoreLocation() {
        return this._currentWSConfigValues.getKeystoreLocation();
    }

    public void setCurrentKeystoreLocation(String string) {
        this._currentWSConfigValues.setKeystoreLocation(string);
    }

    public String getDefaultCertificatePassword() {
        return _defaultWSConfigValues.getCertificatePassword();
    }

    public String getSavedCertificatePassword() {
        return this._savedWSConfigValues.getCertificatePassword();
    }

    public String getCurrentCertificatePassword() {
        return this._currentWSConfigValues.getCertificatePassword();
    }

    public void setCurrentCertificatePassword(String string) {
        this._currentWSConfigValues.setCertificatePassword(string);
    }

    public String getDefaultKeystorePassword() {
        return _defaultWSConfigValues.getKeystorePassword();
    }

    public String getSavedKeystorePassword() {
        return this._savedWSConfigValues.getKeystorePassword();
    }

    public String getCurrentKeystorePassword() {
        return this._currentWSConfigValues.getKeystorePassword();
    }

    public void setCurrentKeystorePassword(String string) {
        this._currentWSConfigValues.setKeystorePassword(string);
    }

    public String getDefaultConsumerName() {
        return _defaultWSConfigValues.getConsumerName();
    }

    public String getSavedConsumerName() {
        return this._savedWSConfigValues.getConsumerName();
    }

    public String getCurrentConsumerName() {
        return this._currentWSConfigValues.getConsumerName();
    }

    public void setCurrentConsumerName(String string) {
        this._currentWSConfigValues.setConsumerName(string);
    }

    public String getDefaultConsumerHostName() {
        return _defaultWSConfigValues.getConsumerHostName();
    }

    public String getSavedConsumerHostName() {
        return this._savedWSConfigValues.getConsumerHostName();
    }

    public String getCurrentConsumerHostName() {
        return this._currentWSConfigValues.getConsumerHostName();
    }

    public void setCurrentConsumerHostName(String string) {
        this._currentWSConfigValues.setConsumerHostName(string);
    }

    public String getDefaultConsumerPort() {
        return _defaultWSConfigValues.getConsumerPort();
    }

    public String getSavedConsumerPort() {
        return this._savedWSConfigValues.getConsumerPort();
    }

    public String getCurrentConsumerPort() {
        return this._currentWSConfigValues.getConsumerPort();
    }

    public void setCurrentConsumerPort(String string) {
        this._currentWSConfigValues.setConsumerPort(string);
    }

    public String getDefaultConsumerLog() {
        return _defaultWSConfigValues.getConsumerLog();
    }

    public String getSavedConsumerLog() {
        return this._savedWSConfigValues.getConsumerLog();
    }

    public String getCurrentConsumerLog() {
        return this._currentWSConfigValues.getConsumerLog();
    }

    public void setCurrentConsumerLog(String string) {
        this._currentWSConfigValues.setConsumerLog(string);
    }

    public static void main(String[] stringArray) {
        WebServicesConfigurationSO webServicesConfigurationSO = new WebServicesConfigurationSO();
        if (stringArray.length > 0) {
            String string = stringArray[0];
            int n = 63;
            n = string.length() >= 2 ? (int)string.charAt(1) : 72;
            switch (n) {
                case 73: 
                case 105: {
                    webServicesConfigurationSO.setMode('I');
                    if (stringArray.length == 2) {
                        webServicesConfigurationSO.setLogFileName(stringArray[1]);
                    }
                    webServicesConfigurationSO.showProgressHeader(stringArray);
                    webServicesConfigurationSO.openInteractiveConsole();
                    webServicesConfigurationSO.showProgressFooter();
                    break;
                }
                case 83: 
                case 115: {
                    webServicesConfigurationSO.setMode('S');
                    webServicesConfigurationSO.showProgressHeader(stringArray);
                    if (stringArray.length == 3) {
                        webServicesConfigurationSO.setLogFileName(stringArray[2]);
                    }
                    webServicesConfigurationSO.openSilentMode(stringArray[1]);
                    webServicesConfigurationSO.showProgressFooter();
                    break;
                }
                default: {
                    System.out.println(ASEUtils.getString("WS_CONFIG_NON_GUI_MODE_SYNTAX_ERROR"));
                    webServicesConfigurationSO.exitApplication();
                }
            }
        }
        webServicesConfigurationSO.closeConnection();
    }

    public void deploy() throws Exception {
        if (this.updateInterfacesFile()) {
            this.showInfoMessage("");
            this.showInfoMessage(ASEUtils.getString("WS_CONFIG_NON_GUI_MODE_SUMMARY_INI_UPDATED"));
            this.showInfoMessage("");
        }
        if (this.defaultsChanged() && this.updatePropFile()) {
            this.showInfoMessage("");
            this.showInfoMessage(ASEUtils.getString("WS_CONFIG_NON_GUI_MODE_SUMMARY_PROP_UPDATED"));
        }
        if (this.isSSLConfigChanged()) {
            this.showInfoMessage(this.execConfigSSL());
        }
        this.showInfoMessage(this.installWSScript());
    }

    public String installWSScript() {
        String string = "";
        if (this._conn != null && !this._conn.isDead() && this.getRSet() != null) {
            this._con = this._conn.getConnection();
        }
        if (this._con == null) {
            return string;
        }
        try {
            String string2;
            Statement statement = this._con.createStatement();
            ResultSet resultSet = statement.executeQuery("select 1 from sybsystemprocs.dbo.sysobjects where type='P' and name='sp_webservices'");
            resultSet = statement.getResultSet();
            if (!resultSet.next()) {
                string2 = this.getSybaseDir() + File.separator + _sWSRoot + File.separator + "bin" + File.separator + "installws";
                string = this.executeScript(string2);
            }
            if (this.isConsumerNameChanged() && (string2 = this.getCurrentConsumerName()) != null && string2.length() < 31 && string2.indexOf(32) == -1) {
                if (!ASEUtils.validateQuery(SQLs.getString("select 1 from master.dbo.sysservers where srvname=''{0}''", string2))) {
                    return "";
                }
                resultSet = statement.executeQuery(SQLs.getString("select 1 from master.dbo.sysservers where srvname=''{0}''", string2));
                resultSet = statement.getResultSet();
                if (!resultSet.next()) {
                    String string3 = SQLs.getString("exec sp_addserver ''{0}'', {1}, ''{2}''", string2, "sds", string2);
                    string = string + "\n" + this.executeReturnResultWarningMsg(string3);
                }
            }
        }
        catch (Exception exception) {
            return exception.getLocalizedMessage();
        }
        return string;
    }

    public String executeScript(String string) {
        try {
            String string2 = "";
            if (ASEUtils.isExistingFile(string)) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                String string3 = "";
                String string4 = "";
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (!string3.toLowerCase().trim().equals("go")) {
                        string4 = string4 + string3 + "\n";
                        continue;
                    }
                    string2 = string2 + "\n" + this.executeReturnResultWarningMsg(string4);
                    string4 = "";
                }
                bufferedReader.close();
            } else {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), string);
                string2 = aSEMessageText.toString();
            }
            return string2;
        }
        catch (Exception exception) {
            return exception.getLocalizedMessage();
        }
    }

    public synchronized String executeReturnResultWarningMsg(String string) throws SQLException {
        String string2 = "";
        Statement statement = null;
        try {
            statement = this._con.createStatement();
            boolean bl = false;
            if (!ASEUtils.validateQuery(string)) {
                return "";
            }
            statement.execute(string);
            int n = 0;
            ResultSet resultSet = null;
            do {
                if (bl) {
                    int n2;
                    resultSet = statement.getResultSet();
                    string2 = string2 + ASEMessageText.getSQLExceptionMessage(statement.getWarnings());
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n3 = resultSetMetaData.getColumnCount();
                    for (n2 = 1; n2 <= n3; ++n2) {
                        if (n2 > 1) {
                            string2 = string2 + "\t";
                        }
                        string2 = string2 + resultSetMetaData.getColumnLabel(n2);
                    }
                    while (resultSet.next()) {
                        string2 = string2 + "\n";
                        for (n2 = 1; n2 <= n3; ++n2) {
                            if (n2 > 1) {
                                string2 = string2 + "\t";
                            }
                            string2 = string2 + resultSet.getString(n2);
                            if (!resultSet.wasNull()) continue;
                            string2 = string2 + "NULL";
                        }
                    }
                } else {
                    try {
                        string2 = string2 + ASEMessageText.getSQLExceptionMessage(statement.getWarnings());
                    }
                    catch (SQLException sQLException) {
                        if (!this._con.isClosed()) {
                            string2 = string2 + ASEMessageText.getSQLExceptionMessage(sQLException);
                            break;
                        }
                        throw sQLException;
                    }
                }
                statement.clearWarnings();
                bl = statement.getMoreResults();
                n = statement.getUpdateCount();
            } while (bl || n != -1);
        }
        catch (SQLException sQLException) {
            if (!this._con.isClosed()) {
                string2 = string2 + ASEMessageText.getSQLExceptionMessage(sQLException);
            }
            throw sQLException;
        }
        return string2;
    }

    public String execConfigSSL() throws Exception {
        String string;
        String[] stringArray = new String[13];
        int n = 0;
        String string2 = System.getProperty("SYBASE_JRE6");
        if (string2 == null || string2.trim().length() == 0) {
            string2 = Utils.getEnVariable((String)"SYBASE_JRE6");
        }
        if ((string = System.getProperty("SYBASE_WS")) == null || string.trim().length() == 0) {
            string = _sWSRoot;
        }
        String[] stringArray2 = new String[]{"SYBASE=" + this.getSybaseDir(), "SYBASE_WS=" + string, "SYBASE_JRE6=" + string2};
        stringArray2 = Utils.OS_WINDOWS ? null : stringArray2;
        stringArray[n++] = this.getSybaseDir() + File.separator + _sWSRoot + File.separator + "bin" + File.separator + (Utils.OS_WINDOWS ? "configssl.bat" : "configssl");
        String string3 = this.getCurrentCertificateHost();
        if (string3 == null || string3.trim().equals("")) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("WS_EXEC_SSL_ERROR_MISSING_INFO"), ASEUtils.getString("WS_CONFIG_WIZ_SSL_HOST_PAGE_LABC_CERT_HOST_NAME"));
            string3 = aSEMessageText.toString();
            string3 = string3.substring(0, string3.length() - 1);
            return string3;
        }
        stringArray[n++] = "-d";
        stringArray[n++] = string3;
        string3 = this.getCurrentCertificatePassword();
        if (string3 == null || string3.trim().equals("")) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("WS_EXEC_SSL_ERROR_MISSING_INFO"), ASEUtils.getString("WS_CONFIG_WIZ_SSL_KEYSTORE_PAGE_LABC_CERT_PWD"));
            string3 = aSEMessageText.toString();
            string3 = string3.substring(0, string3.length() - 1);
            return string3;
        }
        stringArray[n++] = "-c";
        stringArray[n++] = string3;
        string3 = this.getCurrentKeystorePassword();
        if (string3 == null || string3.trim().equals("")) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("WS_EXEC_SSL_ERROR_MISSING_INFO"), ASEUtils.getString("WS_CONFIG_WIZ_SSL_KEYSTORE_PAGE_LABC_KEY_PWD"));
            string3 = aSEMessageText.toString();
            string3 = string3.substring(0, string3.length() - 1);
            return string3;
        }
        stringArray[n++] = "-s";
        stringArray[n++] = string3;
        string3 = this.getCurrentKeystoreLocation();
        if (string3 != null && !string3.trim().equals("")) {
            stringArray[n++] = "-k";
            stringArray[n++] = string3;
        }
        if ((string3 = this.getCurrentSSLPort()) != null && !string3.trim().equals("")) {
            stringArray[n++] = "-h";
            stringArray[n++] = string3;
        }
        if ((string3 = this.getWSPropFileURL()) != null && !string3.trim().equals("")) {
            stringArray[n++] = "-f";
            stringArray[n++] = string3;
        }
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = stringArray[i];
        }
        String[] stringArray4 = this.execProcess(stringArray3, stringArray2);
        if (stringArray4[1] != null) {
            return stringArray4[1];
        }
        return stringArray4[0];
    }

    public boolean defaultsChanged() {
        return this.isProducerPortChanged() || this.isConsumerNameChanged() || this.isConsumerPortChanged() || this.isProducerLogFileChanged() || this.isProducerHTTPLogFileChanged() || this.isInterfacesFileChanged() || this.isLDAPConfigFileChanged() || this.isConsumerLogFileChanged();
    }

    public boolean isSSLConfigChanged() {
        return this.isSSLCertificateHostChanged() || this.isSSLPortChanged() || this.isKeystoreLocationChanged() || this.isCertificatePasswordChanged() || this.isKeystorePasswordChanged();
    }

    public boolean isSSLCertificateHostChanged() {
        return !this.getCurrentCertificateHost().equals(this.getSavedCertificateHost());
    }

    public boolean isSSLPortChanged() {
        return !this.getCurrentSSLPort().equals(this.getSavedSSLPort());
    }

    public boolean isKeystoreLocationChanged() {
        return !this.getCurrentKeystoreLocation().equals(this.getSavedKeystoreLocation());
    }

    public boolean isCertificatePasswordChanged() {
        return !this.getCurrentCertificatePassword().equals(this.getSavedCertificatePassword());
    }

    public boolean isKeystorePasswordChanged() {
        return !this.getCurrentKeystorePassword().equals(this.getSavedKeystorePassword());
    }

    public boolean isProducerPortChanged() {
        return !this.getCurrentProducerPort().equals(this.getSavedProducerPort());
    }

    public boolean isConsumerNameChanged() {
        return !this.getCurrentConsumerName().equals(this.getSavedConsumerName());
    }

    public boolean isConsumerPortChanged() {
        return !this.getCurrentConsumerPort().equals(this.getSavedConsumerPort());
    }

    public boolean isProducerLogFileChanged() {
        return !this.getCurrentProducerLog().equals(this.getSavedProducerLog());
    }

    public boolean isProducerHTTPLogFileChanged() {
        return !this.getCurrentProducerHTTPLog().equals(this.getSavedProducerHTTPLog());
    }

    public boolean isInterfacesFileChanged() {
        return !this.getCurrentInterfacesFile().equals(this.getSavedInterfacesFile());
    }

    public boolean isLDAPConfigFileChanged() {
        return !this.getCurrentLDAPFile().equals(this.getSavedLDAPFile());
    }

    public boolean isConsumerLogFileChanged() {
        return !this.getCurrentConsumerLog().equals(this.getSavedConsumerLog());
    }

    public boolean isConsumerHostNameChanged() {
        return !this.getCurrentConsumerHostName().equals(this.getSavedConsumerHostName());
    }

    private String cannonicalize(String string) {
        if (!Utils.OS_WINDOWS) {
            return string;
        }
        if (string.indexOf("\\\\") != -1) {
            return string;
        }
        return string.replaceAll("\\", "\\\\");
    }

    public void saveTemplate(String string) throws IOException {
        if (string == null || string.equals("")) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        printWriter.println("ws.SYBASE=" + this.cannonicalize(this.getSybaseDir()));
        if (this.isInterfacesFileChanged()) {
            printWriter.println("ws.ini=" + this.cannonicalize(this.getCurrentInterfacesFile()));
        }
        if (this.isLDAPConfigFileChanged()) {
            printWriter.println("ws.libtcl=" + this.cannonicalize(this.getCurrentLDAPFile()));
        }
        if (this.isProducerPortChanged()) {
            printWriter.println("ws.producer.port=" + this.getCurrentProducerPort());
        }
        if (this.isProducerLogFileChanged()) {
            printWriter.println("ws.producer.log=" + this.cannonicalize(this.getCurrentProducerLog()));
        }
        if (this.isProducerHTTPLogFileChanged()) {
            printWriter.println("ws.producer.jettylogfile=" + this.cannonicalize(this.getCurrentProducerHTTPLog()));
        }
        if (this.isSSLCertificateHostChanged()) {
            printWriter.println("ws.ssl.host=" + this.getCurrentCertificateHost());
        }
        if (this.isKeystoreLocationChanged()) {
            printWriter.println("ws.ssl.keystorelocation=" + this.cannonicalize(this.getCurrentKeystoreLocation()));
        }
        if (this.isCertificatePasswordChanged()) {
            printWriter.println("ws.ssl.certificatepassword=" + this.getCurrentCertificatePassword());
        }
        if (this.isKeystorePasswordChanged()) {
            printWriter.println("ws.ssl.keystorepassword=" + this.getCurrentKeystorePassword());
        }
        if (this._conn != null) {
            printWriter.println("ws.sqlsrv.server_name=" + this._conn.getServerName());
            printWriter.println("ws.sqlsrv.sa_login=" + this._conn.getUser());
            printWriter.println("ws.sqlsrv.sa_password=" + this._conn.getPassword());
        }
        if (this.isConsumerNameChanged()) {
            printWriter.println("ws.consumer.name=" + this.getCurrentConsumerName());
        }
        if (this.isConsumerHostNameChanged()) {
            printWriter.println("ws.consumer.host=" + this.getCurrentConsumerHostName());
        }
        if (this.isConsumerPortChanged()) {
            printWriter.println("ws.consumer.port=" + this.getCurrentConsumerPort());
        }
        if (this.isConsumerLogFileChanged()) {
            printWriter.println("ws.consumer.log=" + this.cannonicalize(this.getCurrentConsumerLog()));
        }
        printWriter.close();
        printWriter = null;
    }

    public boolean updatePropFile() {
        try {
            if (ASEUtils.isExistingFile(this.getWSPropFileURL())) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getWSPropFileURL()));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string).append("\n");
                }
                bufferedReader.close();
                ASEUtils.deleteFile(this.getWSPropFileURL());
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.getWSPropFileURL())));
                StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    printWriter.println(this.checkChangedData(stringTokenizer.nextToken()));
                }
                printWriter.close();
                ASEUtils.setFilePermission(this.getWSPropFileURL(), "600");
                stringBuffer = null;
                return true;
            }
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), this.getWSPropFileURL());
            this.showErrorMessage(aSEMessageText.toString());
            return false;
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getMessage());
            return false;
        }
    }

    private String checkChangedData(String string) {
        if ((string = string.trim()).startsWith("com.sybase.ase.ws.producer.httpport")) {
            return this.isProducerPortChanged() ? "com.sybase.ase.ws.producer.httpport = " + this.getCurrentProducerPort() : string;
        }
        if (string.startsWith("com.sybase.ase.ws.producer.logfilename")) {
            return this.isProducerLogFileChanged() ? "com.sybase.ase.ws.producer.logfilename = " + this.getCurrentProducerLog() : string;
        }
        if (string.startsWith("com.sybase.ase.ws.consumer.logfilename")) {
            return this.isConsumerLogFileChanged() ? "com.sybase.ase.ws.consumer.logfilename = " + this.getCurrentConsumerLog() : string;
        }
        if (string.startsWith("com.sybase.ase.ws.producer.jettylogfile")) {
            return this.isProducerHTTPLogFileChanged() ? "com.sybase.ase.ws.producer.jettylogfile = " + this.getCurrentProducerHTTPLog() : string;
        }
        if (string.startsWith("#com.sybase.ase.ws.interfaces") || string.startsWith("com.sybase.ase.ws.interfaces")) {
            return this.isInterfacesFileChanged() ? "com.sybase.ase.ws.interfaces = " + this.getCurrentInterfacesFile() : string;
        }
        if (string.startsWith("#com.sybase.ase.ws.libtcl") || string.startsWith("com.sybase.ase.ws.libtcl")) {
            return this.isLDAPConfigFileChanged() ? "com.sybase.ase.ws.libtcl = " + this.getCurrentLDAPFile() : string;
        }
        return string;
    }

    public boolean updateInterfacesFile() {
        try {
            String string = this.getCurrentConsumerName();
            String string2 = this.getCurrentConsumerPort();
            String string3 = this.getCurrentConsumerHostName();
            string3 = string3.equals("") ? this.getLocalHostName() : string3;
            System.setProperty("interfaces.file", this.getDefaultInterfacesFile());
            DirectoryServiceHelper directoryServiceHelper = new DirectoryServiceHelper(true, false);
            String[] stringArray = directoryServiceHelper.doesServerEntryExistInInterfaces(string);
            if (stringArray != null) {
                if (!stringArray[0].equals(_sLocalHostName) || !stringArray[1].equals(string2)) {
                    directoryServiceHelper.addEntryToInterfaces(string, string3, string2);
                    return true;
                }
                return false;
            }
            directoryServiceHelper.addEntryToInterfaces(string, string3, string2);
            return true;
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getMessage());
            return false;
        }
    }

    private String[] execProcess(String[] stringArray, String[] stringArray2) throws Exception {
        String[] stringArray3 = new String[]{"", ""};
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray4 = ASEUtils.validCommandIsRoutine(stringArray, null);
        if (stringArray4.length > 0) {
            Process process = runtime.exec(stringArray4, stringArray2);
            final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            Thread thread = new Thread(){

                @Override
                public void run() {
                    String string = null;
                    WebServicesConfigurationSO.this._sStdOut = "";
                    try {
                        while ((string = bufferedReader.readLine()) != null) {
                            WebServicesConfigurationSO.this._sStdOut = WebServicesConfigurationSO.this._sStdOut + (string + "\n");
                        }
                    }
                    catch (Exception exception) {
                        WebServicesConfigurationSO.this._sStdOut = WebServicesConfigurationSO.this._sStdOut + exception.getLocalizedMessage();
                    }
                }
            };
            Thread thread2 = new Thread(){

                @Override
                public void run() {
                    String string = null;
                    WebServicesConfigurationSO.this._sStdErr = "";
                    try {
                        while ((string = bufferedReader2.readLine()) != null) {
                            WebServicesConfigurationSO.this._sStdErr = WebServicesConfigurationSO.this._sStdErr + (string + "\n");
                        }
                    }
                    catch (Exception exception) {
                        WebServicesConfigurationSO.this._sStdErr = WebServicesConfigurationSO.this._sStdErr + exception.getLocalizedMessage();
                    }
                }
            };
            thread.start();
            thread2.start();
            Thread.currentThread();
            Thread.sleep(1000L);
            process.waitFor();
            stringArray3[0] = this._sStdOut.trim();
            stringArray3[1] = this._sStdErr.trim();
            stringArray3[0] = stringArray3[0].equals("") ? null : stringArray3[0].trim();
            stringArray3[1] = stringArray3[1].equals("") ? null : stringArray3[1].trim();
            bufferedReader2.close();
            bufferedReader.close();
            thread = null;
            thread2 = null;
            process.getInputStream().close();
            process.getErrorStream().close();
            process.destroy();
        } else {
            stringArray3[0] = ASEUtils.getString("INVALID_COMMAND");
        }
        return stringArray3;
    }

    public String[] getEnvVar(String string) throws Exception {
        String[] stringArray = new String[]{null, null};
        stringArray[0] = System.getProperty(string);
        if (stringArray[0] != null) {
            return stringArray;
        }
        String[] stringArray2 = Utils.OS_WINDOWS ? (System.getProperty("os.name").toLowerCase().indexOf("9") != -1 ? new String[]{"command", "/c", "echo %" + string + "%"} : new String[]{"cmd", "/c", "echo %" + string + "%"}) : new String[]{"sh", "-c", "echo $" + string};
        return this.execProcess(stringArray2, null);
    }

    public String getSybase() throws Exception {
        String[] stringArray = this.getEnvVar("SYBASE");
        if (stringArray[1] != null) {
            this.showErrorMessage(new ASEMessageText(ASEUtils.getString("ERR_ENV_VARIABLE_NOT_DEFINED"), "SYBASE").toString());
            System.out.println(stringArray[1]);
            this.exitApplication();
            return "";
        }
        return stringArray[0];
    }

    private void openSilentMode(String string) {
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = Utils.getFileInputStream((String)string);
            properties.load(fileInputStream);
            fileInputStream.close();
            String string2 = properties.getProperty("ws.SYBASE");
            if (string2 == null) {
                string2 = this.getSybase();
            }
            if (string2 == null) {
                this.showErrorMessage(new ASEMessageText(ASEUtils.getString("ERR_ENV_VARIABLE_NOT_DEFINED"), "SYBASE").toString());
                this.exitApplication();
            }
            if (ASEUtils.isExistingDirectory(string2)) {
                this.reInit(string2);
                if (!this.isWSPropFileWritable()) {
                    this.showErrorMessage(new ASEMessageText(ASEUtils.getString("ERR_WS_PROP_FILE"), this.getWSPropFileURL()).toString());
                    this.exitApplication();
                }
                this.loadFromPropFile();
            } else {
                this.showErrorMessage(new ASEMessageText(ASEUtils.getString("ERR_INVALID_DIRECTORY"), string2).toString());
                this.exitApplication();
            }
            string2 = properties.getProperty("ws.ini");
            if (string2 != null) {
                this.setCurrentInterfacesFile(string2);
            }
            if ((string2 = properties.getProperty("ws.libtcl")) != null) {
                this.setCurrentLDAPFile(string2);
            }
            if ((string2 = properties.getProperty("ws.producer.port")) != null) {
                this.setCurrentProducerPort(string2);
            }
            if ((string2 = properties.getProperty("ws.producer.jettylogfile")) != null) {
                this.setCurrentProducerHTTPLog(string2);
            }
            if ((string2 = properties.getProperty("ws.ssl.host")) != null) {
                this.setCurrentCertificateHost(string2);
            }
            if ((string2 = properties.getProperty("ws.ssl.keystorelocation")) != null) {
                this.setCurrentKeystoreLocation(string2);
            }
            if ((string2 = properties.getProperty("ws.ssl.certificatepassword")) != null) {
                this.setCurrentCertificatePassword(string2);
            }
            if ((string2 = properties.getProperty("ws.ssl.keystorepassword")) != null) {
                this.setCurrentKeystorePassword(string2);
            }
            if ((string2 = properties.getProperty("ws.consumer.name")) != null) {
                this.setCurrentConsumerName(string2);
            }
            if ((string2 = properties.getProperty("ws.consumer.host")) != null) {
                this.setCurrentConsumerHostName(string2);
            }
            if ((string2 = properties.getProperty("ws.consumer.port")) != null) {
                this.setCurrentConsumerPort(string2);
            }
            if ((string2 = properties.getProperty("ws.consumer.log")) != null) {
                this.setCurrentConsumerLog(string2);
            }
            String string3 = properties.getProperty("ws.sqlsrv.server_name");
            String string4 = properties.getProperty("ws.sqlsrv.sa_login");
            String string5 = properties.getProperty("ws.sqlsrv.sa_password");
            if (string3 != null && string4 != null && string5 != null) {
                this.setServerName(string3);
                this.setLoginName(string4);
                this.setPassword(string5);
                DirectoryServiceHelper directoryServiceHelper = new DirectoryServiceHelper(true, false);
                String[] stringArray = directoryServiceHelper.doesServerEntryExistInInterfaces(string3);
                if (stringArray == null) {
                    this.showErrorMessage(ASEUtils.getString("WS_CONFIG_IC_ERR_SERVER_NOT_FOUND"));
                } else {
                    this.setServerName(string2);
                    this.setHostName(stringArray[0]);
                    this.setPortNumber(stringArray[1]);
                }
                try {
                    this.openConnection();
                }
                catch (Exception exception) {
                    this.showErrorMessage(ASEUtils.getString("ERR_CONNECTION_FAILED"));
                }
            }
            this.deploy();
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getLocalizedMessage());
            this.exitApplication();
        }
    }

    private void openConnection() throws Exception {
        ASEConnectionInfo aSEConnectionInfo = new ASEConnectionInfo();
        aSEConnectionInfo.setUserName(this.getLoginName());
        aSEConnectionInfo.setPassword(this.getPassword());
        aSEConnectionInfo.host = this.getHostName();
        aSEConnectionInfo.port = Integer.valueOf(this.getPortNumber());
        if (ASEUtils.OS_NAME.startsWith("HP")) {
            aSEConnectionInfo.setCharSet("iso_1");
        }
        this._con = JDBCDrivers.connect((ASEConnectionInfo)aSEConnectionInfo);
        this._con.createStatement().execute("set quoted_identifier off");
    }

    private void closeConnection() {
        if (this._con != null) {
            try {
                this._con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean isPortNumberValid(String string) {
        try {
            long l = new Long(string);
            return l >= 1025L && l <= 65535L;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void exitApplication() {
        this.showProgressFooter();
        System.exit(0);
    }

    public void openInteractiveConsole() {
        try {
            while (true) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.println();
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_INTRO_PAGE_LABC_WELCOME"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_LABC_INTRO"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_QUES_CONTINUE_WS_CONFIG"));
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_SHOW_OPTIONS"));
                String string = bufferedReader.readLine().toUpperCase();
                if (string.equals(Q)) {
                    this.exitApplication();
                    continue;
                }
                if (string.equals(Y) || string.equals("")) {
                    while (true) {
                        String string2;
                        String string3 = this.getSybase();
                        string = ASEUtils.getString("WS_CONFIG_WIZ_LABC_SYBASE_ROOT_DIR_LOCATION") + " [" + string3 + "]: ";
                        System.out.println(string);
                        string = bufferedReader.readLine();
                        if (string.equals("")) {
                            string = string3;
                        }
                        if (ASEUtils.isExistingDirectory(string)) {
                            try {
                                this.reInit(string);
                                if (!this.isWSPropFileWritable()) {
                                    string2 = this.getWSPropFileURL();
                                    String string4 = new ASEMessageText(ASEUtils.getString("ERR_WS_PROP_FILE"), string2).toString();
                                    this.showErrorMessage(string4);
                                    continue;
                                }
                                this.loadFromPropFile();
                                break;
                            }
                            catch (Exception exception) {
                                this.showErrorMessage(exception.getLocalizedMessage());
                                continue;
                            }
                        }
                        string2 = new ASEMessageText(ASEUtils.getString("ERR_INVALID_DIRECTORY"), string).toString();
                        this.showErrorMessage(string2);
                    }
                    string = ASEUtils.getString("WS_CONFIG_WIZ_LABC_INI_FILE_LOCATION") + " [" + this.getCurrentInterfacesFile() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentInterfacesFile(string);
                    }
                    string = ASEUtils.getString("WS_CONFIG_WIZ_LABC_LIBTCL_FILE_LOCATION") + " [" + this.getCurrentLDAPFile() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentLDAPFile(string);
                    }
                    this.openInteractiveProducerConfiguration(bufferedReader);
                    break;
                }
                if (string.equals(N)) {
                    this.openInteractiveProducerConfiguration(bufferedReader);
                    break;
                }
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_KEY_PRESSED") + " : " + string);
            }
            this.deploy();
            this.exitApplication();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
        }
    }

    public void openInteractiveProducerConfiguration(BufferedReader bufferedReader) throws Exception {
        try {
            while (true) {
                System.out.println();
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_WELCOME"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_INTRO1"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_INTRO2"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_INTRO3"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_INTRO4"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_INTRO5"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_QUES_CONTINUE_WS_PRODUCER_CONFIG"));
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_SHOW_OPTIONS"));
                String string = bufferedReader.readLine().toUpperCase();
                if (string.equals(Q)) {
                    this.exitApplication();
                    continue;
                }
                if (string.equals(Y) || string.equals("")) {
                    System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_PAGE_LABC_WELCOME"));
                    System.out.println();
                    while (true) {
                        string = ASEUtils.getString("LABC_PORT_NUMBER") + " [" + this.getCurrentProducerPort() + "]: ";
                        System.out.println(string);
                        string = bufferedReader.readLine();
                        if (string.equals("")) {
                            string = this.getCurrentProducerPort();
                        }
                        if (this.isPortNumberValid(string)) break;
                        this.showErrorMessage(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_PORT"));
                    }
                    this.setCurrentProducerPort(string);
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_LABC_LOG_FILE_LOCATION") + " [" + this.getCurrentProducerLog() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentProducerLog(string);
                    }
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_LABC_HTTP_LOG_FILE_LOCATION") + " [" + this.getCurrentProducerHTTPLog() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentProducerHTTPLog(string);
                    }
                    this.openInteractiveSSLConfiguration(bufferedReader);
                    break;
                }
                if (string.equals(N)) {
                    this.openInteractiveConsumerConfiguration(bufferedReader);
                    break;
                }
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_KEY_PRESSED") + " : " + string);
            }
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getLocalizedMessage());
        }
    }

    private void openInteractiveSSLConfiguration(BufferedReader bufferedReader) throws Exception {
        try {
            while (true) {
                System.out.println();
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_SSL_INTRO_PAGE_LABC_WELCOME"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_SSL_INTRO_PAGE_LABC_INTRO1"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_INTRO2"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_SSL_INTRO_PAGE_LABC_INTRO3"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_SSL_INTRO_PAGE_LABC_INTRO4"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_SSL_INTRO_PAGE_LABC_INTRO5"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_SSL_INTRO_PAGE_LABC_INTRO6"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_QUES_CONTINUE_WS_SSL_CONFIG"));
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_SHOW_OPTIONS"));
                String string = bufferedReader.readLine().toUpperCase();
                if (string.equals(Q)) {
                    this.exitApplication();
                    continue;
                }
                if (string.equals(Y) || string.equals("")) {
                    System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_SSL_HOST_PAGE_LABC_WELCOME"));
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_SSL_HOST_PAGE_LABC_CERT_HOST_NAME") + " [" + this.getCurrentCertificateHost() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentCertificateHost(string);
                    }
                    while (true) {
                        System.out.println();
                        string = ASEUtils.getString("LABC_PORT_NUMBER") + " [" + this.getCurrentSSLPort() + "]: ";
                        System.out.println(string);
                        string = bufferedReader.readLine();
                        if (string.equals("")) {
                            string = this.getCurrentSSLPort();
                        }
                        if (this.isPortNumberValid(string)) break;
                        this.showErrorMessage(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_PORT"));
                    }
                    this.setCurrentSSLPort(string);
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_SSL_KEYSTORE_PAGE_LABC_KEY_LOC") + " [" + this.getCurrentKeystoreLocation() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentKeystoreLocation(string);
                    }
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_SSL_KEYSTORE_PAGE_LABC_CERT_PWD") + " [" + this.getCurrentCertificatePassword() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentCertificatePassword(string);
                    }
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_SSL_KEYSTORE_PAGE_LABC_KEY_PWD") + " [" + this.getCurrentKeystorePassword() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentKeystorePassword(string);
                    }
                    this.openInteractiveConsumerConfiguration(bufferedReader);
                    break;
                }
                if (string.equals(N)) {
                    this.openInteractiveConsumerConfiguration(bufferedReader);
                    break;
                }
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_KEY_PRESSED") + " : " + string);
            }
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getLocalizedMessage());
        }
    }

    private void openInteractiveConsumerConfiguration(BufferedReader bufferedReader) throws Exception {
        try {
            while (true) {
                System.out.println();
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_INTRO_PAGE_LABC_WELCOME"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_INTRO_PAGE_LABC_INTRO1"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_INTRO_PAGE_LABC_INTRO2"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_INTRO_PAGE_LABC_INTRO3"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_INTRO_PAGE_LABC_INTRO4"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_INTRO_PAGE_LABC_INTRO5"));
                System.out.println();
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_QUES_CONTINUE_WS_CONSUMER_CONFIG"));
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_SHOW_OPTIONS"));
                String string = bufferedReader.readLine().toUpperCase();
                if (string.equals(Q)) {
                    this.exitApplication();
                    continue;
                }
                if (string.equals(Y) || string.equals("")) {
                    String[] stringArray;
                    System.out.println();
                    System.out.println(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_ASE_PAGE_LABC_WELCOME"));
                    while (true) {
                        System.out.println();
                        string = ASEUtils.getString("LABC_SERVER_NAME");
                        System.out.print(string);
                        string = bufferedReader.readLine();
                        if (string.equals("")) continue;
                        DirectoryServiceHelper directoryServiceHelper = new DirectoryServiceHelper(true, false);
                        stringArray = directoryServiceHelper.doesServerEntryExistInInterfaces(string);
                        if (stringArray != null) break;
                        this.showErrorMessage(ASEUtils.getString("WS_CONFIG_IC_ERR_SERVER_NOT_FOUND"));
                    }
                    this.setServerName(string);
                    this.setHostName(stringArray[0]);
                    this.setPortNumber(stringArray[1]);
                    System.out.println();
                    string = ASEUtils.getString("LABC_USER_NAME");
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setLoginName(string);
                    }
                    System.out.println();
                    string = ASEUtils.getString("LABC_PASSWORD");
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    this.setPassword(string);
                    this.openConnection();
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_PAGE_LABC_WELCOME");
                    System.out.print(string);
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_PAGE_LABC_SERVER_NAME") + " [" + this.getCurrentConsumerName() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentConsumerName(string);
                    }
                    System.out.println();
                    string = ASEUtils.getString("LABC_HOST_NAME") + " [" + this.getCurrentConsumerHostName() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentConsumerHostName(string);
                    }
                    while (true) {
                        System.out.println();
                        string = ASEUtils.getString("LABC_PORT_NUMBER") + " [" + this.getCurrentConsumerPort() + "]: ";
                        System.out.println(string);
                        string = bufferedReader.readLine();
                        if (string.equals("")) {
                            string = this.getCurrentConsumerPort();
                        }
                        if (this.isPortNumberValid(string)) break;
                        this.showErrorMessage(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_PORT"));
                    }
                    this.setCurrentConsumerPort(string);
                    System.out.println();
                    string = ASEUtils.getString("WS_CONFIG_WIZ_LABC_LOG_FILE_LOCATION") + " [" + this.getCurrentConsumerLog() + "]: ";
                    System.out.print(string);
                    string = bufferedReader.readLine();
                    if (!string.equals("")) {
                        this.setCurrentConsumerLog(string);
                    }
                    this.showSummaryAndFinishTask(bufferedReader);
                    break;
                }
                if (string.equals(N)) {
                    this.showSummaryAndFinishTask(bufferedReader);
                    break;
                }
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_KEY_PRESSED") + " : " + string);
            }
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getLocalizedMessage());
        }
    }

    public void showSummaryAndFinishTask(BufferedReader bufferedReader) throws Exception {
        System.out.println();
        System.out.println(ASEUtils.getString("SUMMARY_WIZ_SENT_SUMMARY"));
        System.out.println();
        System.out.println(this.composeSummary());
        System.out.println();
        System.out.println(ASEUtils.getString("WS_CONFIG_IC_QUES_FINISH"));
        System.out.println(ASEUtils.getString("WS_CONFIG_IC_SHOW_OPTIONS"));
        try {
            while (true) {
                String string;
                if ((string = bufferedReader.readLine().toUpperCase()).equals(Q)) {
                    this.exitApplication();
                    continue;
                }
                if (string.equals(Y) || string.equals("")) break;
                if (string.equals(N)) {
                    this.exitApplication();
                    break;
                }
                System.out.println(ASEUtils.getString("WS_CONFIG_IC_ERR_INVALID_KEY_PRESSED") + " : " + string);
            }
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getLocalizedMessage());
        }
    }

    public String composeSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isInterfacesFileChanged()) {
            stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_SUMMARY_INTERFACES_FILE")).append(this.getCurrentInterfacesFile()).append("\n");
        }
        if (this.isLDAPConfigFileChanged()) {
            stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_SUMMARY_LDAP_FILE")).append(this.getCurrentLDAPFile()).append("\n");
        }
        boolean bl = false;
        if (this.isProducerPortChanged()) {
            bl = true;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_PAGE_TITLE")).append("\n========\n").append(ASEUtils.getString("MSG_PORT_NUMBER")).append(": ").append(this.getCurrentProducerPort()).append("\n");
        }
        if (this.isProducerLogFileChanged()) {
            if (!bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_PAGE_TITLE")).append("\n========\n");
            }
            stringBuffer.append(ASEUtils.getString("LABC_LOG_FILE")).append(this.getCurrentProducerLog()).append("\n");
            bl = true;
        }
        if (this.isProducerHTTPLogFileChanged()) {
            if (!bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_PRODUCER_PAGE_TITLE")).append("\n========\n");
            }
            stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_SUMMARY_HTTP_LOG_FILE")).append(this.getCurrentProducerHTTPLog()).append("\n");
            bl = true;
        }
        bl = false;
        if (this.isSSLCertificateHostChanged()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_SUMMARY_SSL")).append("\n===\n").append(ASEUtils.getString("WS_CONFIG_WIZ_SSL_HOST_PAGE_LABC_CERT_HOST_NAME")).append(this.getCurrentCertificateHost()).append("\n");
            bl = true;
        }
        if (this.isSSLPortChanged()) {
            if (!bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_SUMMARY_SSL")).append("\n===\n");
            }
            stringBuffer.append(ASEUtils.getString("MSG_PORT_NUMBER")).append(": ").append(this.getCurrentSSLPort()).append("\n");
            bl = true;
        }
        if (this.isKeystoreLocationChanged()) {
            if (!bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_SUMMARY_SSL")).append("\n===\n");
            }
            stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_SUMMARY_KEYSTORE_FILE")).append(this.getCurrentKeystoreLocation()).append("\n");
            bl = true;
        }
        bl = false;
        if (this.isConsumerNameChanged()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_PAGE_TITLE")).append("\n========\n").append(ASEUtils.getString("LABC_NAME")).append(this.getCurrentConsumerName()).append("\n");
            bl = true;
        }
        if (this.isConsumerHostNameChanged()) {
            if (!bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_PAGE_TITLE")).append("\n========\n");
            }
            stringBuffer.append(ASEUtils.getString("LABC_HOST_NAME")).append(this.getCurrentConsumerHostName()).append("\n");
            bl = true;
        }
        if (this.isConsumerPortChanged()) {
            if (!bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_PAGE_TITLE")).append("\n========\n");
            }
            stringBuffer.append(ASEUtils.getString("MSG_PORT_NUMBER")).append(this.getCurrentConsumerPort()).append("\n");
            bl = true;
        }
        if (this.isConsumerLogFileChanged()) {
            if (!bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(ASEUtils.getString("WS_CONFIG_WIZ_CONSUMER_PAGE_TITLE")).append("\n========\n");
            }
            stringBuffer.append(ASEUtils.getString("LABC_LOG_FILE")).append(this.getCurrentConsumerLog()).append("\n");
            bl = true;
        }
        return stringBuffer.toString();
    }

    public void showProgressHeader(String[] stringArray) {
        this.showInfoMessage(ASEUtils.getString("WS_CONFIG_NON_GUI_MODE_SUMMARY_HDR"));
        String string = "** ";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + " ";
        }
        this.showInfoMessage(string);
        string = "** " + ASEUtils.getString("SCHED_PROP_RADB_AT");
        string = string + " " + this.getCurrentTime();
        this.showInfoMessage(string);
        this.showInfoMessage("");
    }

    public void showProgressFooter() {
        this.showInfoMessage("");
        this.showInfoMessage("");
        this.showInfoMessage(ASEUtils.getString("WS_CONFIG_NON_GUI_MODE_SUMMARY_FOOTER"));
        String string = "** " + ASEUtils.getString("SCHED_PROP_RADB_AT");
        string = string + " " + this.getCurrentTime();
        this.showInfoMessage(string);
    }

    public String getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy k:mm:ss z", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }

    public void showInfoMessage(String string) {
        if (this._cMode == 'G') {
            Support.showInfo(this.getConnection(), this.getClass(), string);
        } else {
            System.out.println(string);
        }
    }

    public void showErrorMessage(String string) {
        if (this._cMode == 'G' || this._cMode == 'U') {
            Support.showError(this.getConnection(), this.getClass(), string);
        } else {
            System.out.println(string);
        }
    }

    static {
        _sLocalHostName = "";
        Q = ASEUtils.getString("MNEM_QUIT");
        Y = ASEUtils.getString("MNEM_YES");
        N = ASEUtils.getString("MNEM_NO");
    }
}

