/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.WrkldMgmtUtilities;

public class WorkloadMetricsSO
extends ServerSO {
    private String[] _columns;
    private static int ndx = 0;
    public static final int WLM_INST_NAME_NDX = ndx++;
    public static final int WLM_CONN_SCORE_NDX = ndx++;
    public static final int WLM_CPU_SCORE_NDX = ndx++;
    public static final int WLM_RUNQ_SCORE_NDX = ndx++;
    public static final int WLM_IO_LOAD_SCORE_NDX = ndx++;
    public static final int WLM_ENG_DEF_SCORE_NDX = ndx++;
    public static final int WLM_USER_SCORE_NDX = ndx++;
    public static final int WLM_USER_METRIC_NAME_NDX = ndx;
    public static final int MAX_WLM_COLUMNS = ndx;

    public WorkloadMetricsSO(ASConnection aSConnection) {
        this(aSConnection, "");
    }

    public WorkloadMetricsSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
        this.init(null);
    }

    public WorkloadMetricsSO(ASConnection aSConnection, String[] stringArray) {
        super(aSConnection, "");
        this.init(stringArray);
    }

    private String[] getDefaultValues() {
        return new String[]{"", "0", "0", "0", "0", "0", "0"};
    }

    public void init(String[] stringArray) {
        this.setType("WRKLD_METRICS");
        this._columns = new String[MAX_WLM_COLUMNS];
        if (stringArray == null) {
            this.initColumns(this.getDefaultValues());
        } else {
            this.initColumns(stringArray);
            super.setName(this.getColumn(WLM_INST_NAME_NDX));
        }
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_WORKLOAD_METRICS_TEXT");
    }

    private void initColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length && i < MAX_WLM_COLUMNS; ++i) {
            stringArray[i] = WrkldMgmtUtilities.formatDecimalPlaces(stringArray[i], 2);
            this.setColumn(i, stringArray[i]);
        }
    }

    private void setColumn(int n, String string) {
        this._columns[n] = string;
    }

    public String[] getColumns() {
        return this._columns;
    }

    public String getColumn(int n) {
        String string = "";
        if (n >= 0 && n < MAX_WLM_COLUMNS) {
            string = this._columns[n];
        } else {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_INVALID_COL_NDX"), n + "");
            Support.addLogEntry(1, null, this.getClass(), aSEMessageText.toString(), aSEMessageText.toString());
        }
        return string;
    }

    @Override
    public Object[] getAttributes() {
        return this._columns;
    }
}

