/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.WrkldMgmtUtilities;

public class WorkloadScoresSO
extends ServerSO {
    private String[] _columns;
    private static int ndx = 0;
    public static final int WLS_INST_NAME_NDX = ndx++;
    public static final int WLS_LC_NAME_NDX = ndx++;
    public static final int WLS_LP_NAME_NDX = ndx++;
    public static final int WLS_LOAD_SCORE_NDX = ndx++;
    public static final int WLS_CONN_SCORE_NDX = ndx++;
    public static final int WLS_CPU_SCORE_NDX = ndx++;
    public static final int WLS_RUNQ_SCORE_NDX = ndx++;
    public static final int WLS_IO_LOAD_SCORE_NDX = ndx++;
    public static final int WLS_ENG_DEF_SCORE_NDX = ndx++;
    public static final int WLS_USER_SCORE_NDX = ndx++;
    public static final int WLS_USER_METRIC_NAME_NDX = ndx;
    public static final int MAX_WLS_COLUMNS = ndx;
    public static final int MAX_WLS_DECIMAL_PLACES = 2;

    public WorkloadScoresSO(ASConnection aSConnection) {
        this(aSConnection, "");
    }

    public WorkloadScoresSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
        this.init(null);
    }

    public WorkloadScoresSO(ASConnection aSConnection, String[] stringArray) {
        super(aSConnection, "");
        this.init(stringArray);
    }

    private String[] getDefaultValues() {
        return new String[]{"", "", "", "", "", "", "", "", "", ""};
    }

    public void init(String[] stringArray) {
        this.setType("WRKLD_LOADSCORE");
        this._columns = new String[MAX_WLS_COLUMNS];
        if (stringArray == null) {
            this.initColumns(this.getDefaultValues());
        } else {
            this.initColumns(stringArray);
            super.setName(this.getColumn(WLS_INST_NAME_NDX));
        }
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_WORKLOAD_SCORES_TEXT");
    }

    private void initColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length && i < MAX_WLS_COLUMNS; ++i) {
            stringArray[i] = WrkldMgmtUtilities.formatDecimalPlaces(stringArray[i], 2);
            this.setColumn(i, stringArray[i]);
        }
    }

    private void setColumn(int n, String string) {
        this._columns[n] = string;
    }

    public String[] getColumns() {
        return this._columns;
    }

    public String getColumn(int n) {
        String string = "";
        if (n >= 0 && n < MAX_WLS_COLUMNS) {
            string = this._columns[n];
        } else {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_INVALID_COL_NDX"), n + "");
            Support.addLogEntry(1, null, this.getClass(), aSEMessageText.toString(), aSEMessageText.toString());
        }
        return string;
    }

    @Override
    public Object[] getAttributes() {
        return this._columns;
    }
}

