/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.so.WrkldRoutesCtrSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class WrkldRouteSO
extends ASEBaseItemSO {
    private String[] columns;
    private static int colNdx = 0;
    private static final int WRKLD_ROUTE_NAME_NDX = colNdx++;
    private static final int WRKLD_ROUTE_LC_NAME_NDX = colNdx++;
    private static final int WRKLD_ROUTE_LC_ID_NDX = colNdx++;
    private static final int WRKLD_ROUTE_TYPE_NDX = colNdx;
    private static final int MAX_ROUTE_COLUMNS = colNdx + 1;
    private String saved_name;
    private String saved_lc_name;
    private String saved_type;
    private Vector availableLCs;
    private static final int IDS_OF_AVAILABLE_LC_NDX = 0;
    private static final int NAMES_OF_AVAILABLE_LC_NXD = 1;
    public static final String APPLICATION_ROUTE = "application";
    public static final String ALIAS_ROUTE = "alias";
    public static final String LOGIN_ROUTE = "login";

    public WrkldRouteSO(ASConnection aSConnection, WrkldRoutesCtrSO wrkldRoutesCtrSO) {
        this(aSConnection, wrkldRoutesCtrSO, (String[])null);
    }

    public WrkldRouteSO(ASConnection aSConnection, WrkldRoutesCtrSO wrkldRoutesCtrSO, String[] stringArray) {
        super(aSConnection, wrkldRoutesCtrSO);
        this.init(stringArray);
        super.setName(this.getColumn(WRKLD_ROUTE_NAME_NDX));
    }

    private String[] getDefaultValues() {
        return new String[]{"", "", "0", ""};
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_ROUTE_TEXT");
    }

    public void init(String[] stringArray) {
        this.setType("WRKLD_ROUTE");
        this.columns = new String[MAX_ROUTE_COLUMNS];
        if (stringArray == null) {
            this.setColumns(this.getDefaultValues());
        } else {
            this.setColumns(stringArray);
        }
        this.saveCopy();
    }

    private void saveCopy() {
        this.saved_name = this.getRouteName();
        this.saved_lc_name = this.getLogicalClusterName();
        this.saved_type = this.getRouteType();
    }

    private void setColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length && i < MAX_ROUTE_COLUMNS; ++i) {
            this.setColumn(i, stringArray[i]);
        }
    }

    public void setColumn(int n, String string) {
        if (n < MAX_ROUTE_COLUMNS) {
            this.columns[n] = string;
        }
    }

    public String getColumn(int n) {
        String string = "";
        if (n >= 0 && n < MAX_ROUTE_COLUMNS) {
            string = this.columns[n];
        }
        return string;
    }

    public boolean isValidName(String string) throws SQLException {
        boolean bl = false;
        if (string == null || string.trim().length() == 0) {
            throw new SQLException(ASEUtils.getString("WRKLD_ROUTE_ERROR_MISSING_NAME"));
        }
        bl = Utility.hasValidName(this._conn, string, true);
        if (!bl) {
            throw new SQLException(ASEUtils.getString("WRKLD_ROUTE_ERROR_INVALID_NAME"));
        }
        return bl;
    }

    public void duplicate(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getLogicalClusterName(), this.getRouteType(), string);
        String string3 = this._conn.executeCommand(string2);
        if (string3.indexOf("cannot create route") > 0) {
            throw new SQLException(ASEUtils.getString("LOAD_PROFILE_WIZ_CREATE_DUPLICATE_ERROR"));
        }
    }

    @Override
    public void remove() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getLogicalClusterName(), this.getRouteType(), this.getRouteName());
        this._conn.executeCommand(string);
    }

    @Override
    public boolean exists() {
        boolean bl;
        try {
            String string = "select count(*) from monLogicalClusterRoute where RouteKey = " + JSBaseSO.argString(this.getRouteName()) + " LogicalClusterName = " + JSBaseSO.argString(this.getLogicalClusterName()) + " LClusterID = " + JSBaseSO.argInt(this.getLogicalClusterID()) + " RouteType " + JSBaseSO.argString(this.getRouteType());
            this.getRSet().open(string);
            bl = this.getRSet().getNextRow();
            this.getRSet().close();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void create() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getLogicalClusterName(), this.getRouteType(), this.getRouteName());
        this._conn.executeCommand(string);
        this.saveCopy();
    }

    public void update() throws SQLException {
        String string = SQLs.getString("exec sp_cluster ''logical'', ''drop'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.saved_lc_name, this.saved_type, this.saved_name);
        this._conn.executeCommand(string);
        string = SQLs.getString("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", this.getLogicalClusterName(), this.getRouteType(), this.getRouteName());
        this._conn.executeCommand(string);
        this.saveCopy();
    }

    public Vector getAvailableLogicalClusters() throws SQLException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string = "select LCID, Name from master.dbo.monLogicalCluster order by Name";
        this.availableLCs = new Vector();
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector2.add(stringArray[0]);
            vector.add(stringArray[1]);
        }
        this.getRSet().close();
        this.availableLCs.add(0, vector2);
        this.availableLCs.add(1, vector);
        return this.availableLCs;
    }

    public List getAvailableLCNames() throws SQLException {
        if (this.availableLCs == null) {
            this.getAvailableLogicalClusters();
        }
        return (List)this.availableLCs.get(1);
    }

    public List getAvailableLogins() throws SQLException {
        String string = "select name from master.dbo.syslogins order by name";
        Vector<String> vector = new Vector<String>();
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.add(stringArray[0]);
        }
        this.getRSet().close();
        return vector;
    }

    public List getUnRoutedLogins() throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = "select name from master.dbo.syslogins where name not in ( select RouteKey from master.dbo.monLogicalClusterRoute mlcr where RouteType = 'login')";
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1);
            vector.add(string2);
        }
        this.getRSet().close();
        return vector;
    }

    public String getRouteName() {
        String string = this.getColumn(WRKLD_ROUTE_NAME_NDX);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getLogicalClusterName() {
        String string = this.getColumn(WRKLD_ROUTE_LC_NAME_NDX);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getLogicalClusterID() {
        String string = this.getColumn(WRKLD_ROUTE_LC_ID_NDX);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getIDForLogicalClusterName(String string) {
        Vector vector = (Vector)this.availableLCs.get(1);
        Vector vector2 = (Vector)this.availableLCs.get(0);
        int n = vector.indexOf(string);
        String string2 = (String)vector2.get(n);
        return string2;
    }

    public String getRouteType() {
        String string = this.getColumn(WRKLD_ROUTE_TYPE_NDX);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setRouteName(String string) {
        this.setColumn(WRKLD_ROUTE_NAME_NDX, string != null ? string : "");
    }

    public void setLogicalClusterName(String string) {
        this.setColumn(WRKLD_ROUTE_LC_NAME_NDX, string != null ? string : "");
    }

    public void setLogicalClusterNameID(String string) {
        this.setColumn(WRKLD_ROUTE_LC_ID_NDX, string != null ? string : "0");
    }

    public void setLogicalClusterNameID(int n) {
        this.setColumn(WRKLD_ROUTE_LC_ID_NDX, n != 0 ? n + "" : "0");
    }

    public void setRouteType(String string) {
        this.setColumn(WRKLD_ROUTE_TYPE_NDX, string != null ? string : "");
    }

    public void displayReceivedColumns() {
        System.out.println("------------------------------");
        System.out.println("BEGIN DISPLAY COLUMNS");
        System.out.println("WRKLD_ROUTE_NAME = " + this.getColumn(WRKLD_ROUTE_NAME_NDX));
        System.out.println("WRKLD_ROUTE_LC_NAME = " + this.getColumn(WRKLD_ROUTE_LC_NAME_NDX));
        System.out.println("WRKLD_ROUTE_LC_ID = " + this.getColumn(WRKLD_ROUTE_LC_ID_NDX));
        System.out.println("WRKLD_ROUTE_TYPE = " + this.getColumn(WRKLD_ROUTE_TYPE_NDX));
        System.out.println(" END DISPLAY COLUMNS");
        System.out.println("------------------------------");
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getColumn(WRKLD_ROUTE_NAME_NDX), this.getColumn(WRKLD_ROUTE_LC_NAME_NDX), this.getColumn(WRKLD_ROUTE_TYPE_NDX)};
    }
}

