/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.sql;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.logon.ServiceProxy;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEPlugin;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ResultSetDetailsPanel;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.DomainDatatypes;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.DirectoryService;
import com.sybase.aseplugin.sql.SQLListener;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.jdbc4.jdbc.SybDataSource;
import com.sybase.util.ds.ASEVersionHelper;
import com.sybase.util.ds.Settings;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.ui.NewPasswordDialog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class ASConnection {
    public static final String JCONNECT_DRIVER_CLASS = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String SQL_STATE_LOGIN_FAILED = "JZ00L";
    public static final String SQL_STATE_CONNECTION_FAILED = "JZ006";
    public static final String SQL_STATE_OUTPUT_PARAM_IGNORED = "010P4";
    public static final String SQL_STATE_CHARSET_UNMATCH = "JZ0IB";
    public static final String SQL_STATE_CONNECTION_ALREADY_CLOSED = "JZ0C0";
    public static final String SQL_STATE_CONNECTION_CLOSED = "JZ0C1";
    public static final String SQL_STATE_NO_RESULT_SET = "JZ0R2";
    public static final String SQL_STATE_CONNECTION_DEAD = "CONNDEAD";
    public static final String VERSION_1192 = "11.9.2";
    public static final String VERSION_1193 = "11.9.3";
    public static final String VERSION_120 = "12.0";
    public static final String VERSION_125 = "12.5";
    public static final String VERSION_1251 = "12.5.1";
    public static final String VERSION_1252 = "12.5.2";
    public static final String VERSION_1253 = "12.5.3";
    public static final String VERSION_1254 = "12.5.4";
    public static final String VERSION_12503 = "12.5.0.3";
    public static final String VERSION_12501 = "12.5.0.1";
    public static final String VERSION_15 = "15";
    public static final String VERSION_150 = "15.0";
    public static final String VERSION_1501 = "15.0.1";
    public static final String VERSION_1502 = "15.0.2";
    public static final String VERSION_1503 = "15.0.3";
    public static final String VERSION_157 = "15.7";
    static final int CONNECTION_CLOSED = 0;
    static final int CONNECTION_OPENED = 1;
    private static final String APPLICATION_NAME = "SC_ASE_Plugin";
    public static final String JDBC_PROP_REQUEST_HA_SESSION = "REQUEST_HA_SESSION";
    public static final String FEATURE_ASE_RESOURCE_LIMITS = "allow resource limits";
    public static final String FEATURE_ASE_SEMANTIC_PARTITIONING_CONFIG = "enable semantic partitioning";
    public static final String FEATURE_ASE_MESSAGING_CONFIG = "enable real time messaging";
    public static final String FEATURE_ASE_JAVA_CONFIG = "enable java";
    public static final String LOCAL_HOST_IP = "127.0.0.1";
    public static final String COMMAND_DBCREATE = "203";
    private static HashSet _shutdownServers = null;
    private static InetAddress _localHost = null;
    private static String _localHostName = null;
    private static final int SQL_PREVIEW = 1;
    private static final int REMOTE_SCHEDULING = 2;
    private static final int MAX_OUTPUT_COL_WIDTH = 255;
    private static final String CLUSTERMODE_SMP = "smp";
    private static final String CLUSTERMODE_SDC = "shared disk cluster";
    public static final String SDC_VIEW_CLUSTER = "cluster";
    public static final String SDC_VIEW_INSTANCE = "instance";
    private Hashtable _roles;
    private HashMap<String, Boolean> _permissions;
    private Connection _conn;
    private Properties _props;
    private String _portNum;
    private String _databaseName;
    private ASEConnectionInfo _connInfo;
    private int _pageSize;
    private int _maxPageSize;
    private boolean _isLocal = false;
    private String _clusterMode;
    private String _currentUser;
    private DomainDatatypes _datatypeList;
    private int _id;
    private String _serverServerName;
    private String _versionString;
    private String _language;
    private String _charSetDescription;
    private String _sortOrderDescription;
    private ASEVersionHelper _versionHelper;
    private SQLListener _sqlListener = null;
    private Vector _sqlPreviewListeners = null;
    private Vector _sqlSchedulingListeners = null;
    private boolean _isDead = false;
    private ASResultSet _rset = null;
    public String _lastFolderPath;
    private Boolean _isArchiveDBApplicable;
    private Boolean _isPwdComplexityApplicable;
    private Boolean _isAutoExpansionApplicable;
    private Boolean _isECEnabled;
    private Boolean _isJavaEnabled;
    private Boolean _isCISEnabled;
    private Boolean _isWSEnabled;
    private Boolean _hasIncrementalTransferFeature;

    public ASConnection(ASEConnectionInfo aSEConnectionInfo, int n) throws ClassNotFoundException, SQLException {
        this._props = (Properties)aSEConnectionInfo.getProperties().clone();
        this._props.put("PASSWORD", ASEUtils.encryptPassword(aSEConnectionInfo.getPassword() == null ? "" : aSEConnectionInfo.getPassword()));
        this._props.put("JCONNECT_VERSION", Integer.toString(0));
        if (n == 0) {
            this._props.put("APPLICATIONNAME", APPLICATION_NAME);
        } else {
            this._props.put("APPLICATIONNAME", "SC_ASE_Plugin: " + String.valueOf(n));
        }
        this._props.put("HOSTNAME", ASConnection.getLocalHostName());
        this._isLocal = ASConnection.isServerLocal(aSEConnectionInfo.host);
        this._connInfo = new ASEConnectionInfo(aSEConnectionInfo);
        this._portNum = String.valueOf(this._connInfo.port);
        this._id = n;
        this.sqlInit();
        this.open();
    }

    public static String getLocalHostName() {
        if (_localHost == null) {
            try {
                _localHost = InetAddress.getLocalHost();
                _localHostName = _localHost.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                _localHostName = "";
            }
        }
        return _localHostName;
    }

    public static boolean isEncryptedPassword(ASEConnectionInfo aSEConnectionInfo) {
        Properties properties = aSEConnectionInfo.getProperties();
        return Boolean.valueOf(properties.getProperty("ENCRYPT_PASSWORD"));
    }

    public static boolean isServerLocal(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (_localHostName == null) {
                ASConnection.getLocalHostName();
            }
            bl = string.toLowerCase().equals("localhost") || string.equals(LOCAL_HOST_IP) || inetAddress.equals(_localHost);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return bl;
    }

    public String getSystemView() throws SQLException {
        String string = "";
        if (this.isCluster()) {
            this.getRSet().open("select @@system_view");
            if (this.getRSet().getNextRow()) {
                string = this.getRSet().getColumnString(1);
            }
            this.getRSet().close();
        }
        return string;
    }

    public boolean isCluster() {
        if (this._clusterMode == null) {
            try {
                this.getRSet().open("select @@clustermode");
                this.getRSet().getNextRow();
                this._clusterMode = this.getRSet().getColumnString(1);
            }
            catch (SQLException sQLException) {
                this._clusterMode = "";
            }
        }
        return this._clusterMode.toLowerCase().indexOf(CLUSTERMODE_SDC) > -1;
    }

    public boolean setSDCView(String string) throws SQLException {
        if (this.isCluster()) {
            if (string.equalsIgnoreCase(SDC_VIEW_CLUSTER)) {
                this.executeCommand("set system_view cluster");
                return true;
            }
            if (string.equalsIgnoreCase(SDC_VIEW_INSTANCE)) {
                this.executeCommand("set system_view instance");
                return true;
            }
            return false;
        }
        return false;
    }

    public ASConnection duplicate() throws ClassNotFoundException, SQLException {
        return new ASConnection(new ASEConnectionInfo(this._connInfo), ASEPlugin.getProvider().getConnectionId(this.getServerName(), this.getUser()));
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    protected void sqlInit() {
        this._datatypeList = new DomainDatatypes(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() throws ClassNotFoundException, SQLException {
        Service service;
        if (this._conn != null && !this._conn.isClosed()) {
            this._conn.close();
        }
        Class.forName(JCONNECT_DRIVER_CLASS);
        Properties properties = null;
        ArrayList<Service> arrayList = new ArrayList<Service>();
        String string = "tcp," + this._connInfo.host + "," + this.getPortNumber();
        if (this._connInfo.getServiceFilter() != null) {
            string = string + "," + this._connInfo.getServiceFilter();
        }
        arrayList.add(new Service(1, string));
        String string2 = this._connInfo.getProperty("CONNECTION_FAILOVER");
        if (string2 == null || Boolean.valueOf(string2).booleanValue()) {
            List list = this._connInfo.getOtherServices();
            for (int i = 0; i < list.size(); ++i) {
                service = (ServiceProxy)list.get(i);
                arrayList.add((Service)service.getObject());
            }
        }
        int n = 0;
        SQLException sQLException = new SQLException();
        do {
            Object object;
            SQLException sQLException2;
            Object object2;
            service = (Service)arrayList.get(n);
            String string3 = this._connInfo.getURL(service.getHost(), service.getPort(), this._databaseName);
            try {
                if (Settings.getEnableLoginTimeout()) {
                    DriverManager.setLoginTimeout(Settings.getLoginTimeout());
                }
                properties = (Properties)this._props.clone();
                properties.put("PASSWORD", this.getPassword());
                if (n > 0 && service.isSSL()) {
                    properties.setProperty("SYBSOCKET_FACTORY", "com.sybase.util.ds.ssl.SSLSocketFactoryASE");
                }
                properties.setProperty("DELETE_WARNINGS_FROM_EXCEPTION_CHAIN", "false");
                String string4 = this._connInfo.getServerName();
                object2 = properties.get(JDBC_PROP_REQUEST_HA_SESSION);
                if (string4 != null && DirectoryService.getQueryServiceNum(string4) > 1 && object2 != null && Boolean.valueOf(object2.toString()).booleanValue()) {
                    sQLException2 = new SybDataSource();
                    sQLException2.setServerName(this.getHostName());
                    sQLException2.setPortNumber(Integer.valueOf(this.getPortNumber()));
                    object = DirectoryService.getQueryAddresses(string4);
                    properties.put(JDBC_PROP_REQUEST_HA_SESSION, (Object)true);
                    sQLException2.setAddressList((String)object);
                    sQLException2.setConnectionProperties(properties);
                    if (this._databaseName != null && this._databaseName.length() > 0) {
                        sQLException2.setDatabaseName(this._databaseName);
                    }
                    this._conn = sQLException2.getConnection();
                } else {
                    this._conn = DriverManager.getConnection(string3, properties);
                }
                properties = null;
                sQLException = null;
                if (n <= 0) continue;
                this._connInfo.host = service.getHost();
                this._connInfo.port = Integer.valueOf(service.getPort());
                this._connInfo.setServiceFilter(service.getFilter());
            }
            catch (SQLException sQLException3) {
                block25: {
                    object2 = sQLException3.getSQLState();
                    sQLException2 = sQLException3.getNextException();
                    object = this._props.get("CHARSET");
                    if ((object == null || !object.equals("iso_1")) && (object2 != null && ((String)object2).equals(SQL_STATE_CHARSET_UNMATCH) || sQLException2 != null && sQLException2.getSQLState() != null && sQLException2.getSQLState().equals(SQL_STATE_CHARSET_UNMATCH))) {
                        this._props.put("CHARSET", "iso_1");
                        this._connInfo.setCharSet("iso_1");
                        this.open();
                        sQLException = null;
                    } else {
                        if (object2 != null && ((String)object2).equals("01ZZZ")) {
                            String string5 = null;
                            while (true) {
                                String string6;
                                NewPasswordDialog newPasswordDialog = new NewPasswordDialog(Support.getViewerFrame(), ASEUtils.decryptPassword(this._props.getProperty("PASSWORD")));
                                if (string5 != null) {
                                    newPasswordDialog.setNewPassword(ASEUtils.decryptPassword(string5));
                                }
                                String string7 = string5 = (string6 = newPasswordDialog.create()) == null ? null : ASEUtils.encryptPassword(string6);
                                if (string5 == null) {
                                    this.close();
                                    throw sQLException3;
                                }
                                try {
                                    this._conn = DriverManager.getConnection(string3 + "?NEWPASSWORD=" + ASEUtils.decryptPassword(string5), properties);
                                    this._connInfo.setPassword(ASEUtils.decryptPassword(string5));
                                    this._props.put("PASSWORD", string5);
                                    properties = null;
                                    sQLException = null;
                                    break block25;
                                }
                                catch (SQLException sQLException4) {
                                    Support.showDetailsError(this, this.getClass(), sQLException4.getMessage(), sQLException4);
                                    continue;
                                }
                                break;
                            }
                        }
                        sQLException3.setNextException(sQLException);
                        sQLException = sQLException3;
                    }
                }
                if (!this.isConnectionDead(sQLException3)) continue;
                throw this.checkConnectionDead(sQLException3);
            }
            finally {
                if (this._conn != null) {
                    this.printSQLWarnings();
                    this._conn.clearWarnings();
                    this.processVersionString();
                    this._isDead = false;
                    this._conn.createStatement().execute("set quoted_identifier off");
                }
            }
        } while (++n < arrayList.size() && properties != null);
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public synchronized void close() throws SQLException {
        if (this._conn != null) {
            this._conn.close();
        }
    }

    private void getMessage(SQLException sQLException, StringBuffer stringBuffer) {
        String string = ASEMessageText.getSQLExceptionMessage(sQLException, true);
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
            if (Support.getViewerSupport() != null) {
                Support.addLogEntry(2, this, this.getClass(), string, string);
            }
        }
    }

    private String formatSQLStatement(String string) {
        return string.replaceAll("\\x20+", " ").replaceAll("\\x20*=\\x20*", "=").replaceAll("\\x20*,\\x20*", ", ");
    }

    public String executeCommand(String string) throws SQLException {
        String string2 = null;
        string = this.formatSQLStatement(string);
        string2 = Support.getEnableRemoteJS() ? this.executeCommand(string, 2) : (Support.getEnableSQLPreview() && !Support.isSQLPreviewDlgShowing() ? this.executeCommand(string, 1) : this.executeCommand(string, false));
        return string2;
    }

    public synchronized String executeCommand(String string, int n) throws SQLException {
        StringBuffer stringBuffer = null;
        switch (n) {
            case 1: {
                stringBuffer = new StringBuffer(this.executeCommand(string, true));
                break;
            }
            case 2: {
                this.notifySQLSchedulingListeners(string);
                stringBuffer = new StringBuffer();
                break;
            }
            default: {
                stringBuffer = new StringBuffer(this.executeCommand(string, false));
            }
        }
        return stringBuffer.toString();
    }

    public synchronized String executeCommand(String string, boolean bl) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            this.notifySQLPreviewListeners(string);
            return stringBuffer.toString();
        }
        try {
            boolean bl2 = false;
            if (this.hasSQLListener()) {
                bl2 = this.getSQLListener().needRowNumbers();
            }
            boolean bl3 = this.notifySQLListenerForQuery(string);
            String string2 = this.executeQuery(string, stringBuffer, bl2);
            if (this.hasSQLListener() && bl3) {
                this.getSQLListener().traceElapsedTime();
                if (this.getSQLListener().needOutput()) {
                    this.getSQLListener().traceOutput(string2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionDead(sQLException);
        }
        return stringBuffer.toString();
    }

    public SQLException checkConnectionDead(SQLException sQLException) {
        if (this.isConnectionDead(sQLException)) {
            SQLException sQLException2 = new SQLException(this.getServerName(), SQL_STATE_CONNECTION_DEAD);
            sQLException.setNextException(sQLException2);
            return sQLException;
        }
        return sQLException;
    }

    public static boolean isDeadConnectionException(SQLException sQLException) {
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            String string = sQLException2.getSQLState();
            if (string == null || !string.equals(SQL_STATE_CONNECTION_DEAD) && !string.equals(SQL_STATE_CONNECTION_CLOSED) && !string.equals(SQL_STATE_CONNECTION_ALREADY_CLOSED)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectionDead(SQLException sQLException) {
        this.setDead(ASConnection.isDeadConnectionException(sQLException));
        return this.isDead();
    }

    public boolean isDead() {
        return this._isDead;
    }

    private void setDead(boolean bl) {
        this._isDead = bl;
    }

    private String executeQuery(String string, StringBuffer stringBuffer, boolean bl) throws SQLException {
        String string2 = "";
        int n = 0;
        Statement statement = this._conn.createStatement();
        statement.setEscapeProcessing(true);
        boolean bl2 = statement.execute(string);
        do {
            this.getMessage(statement.getWarnings(), stringBuffer);
            statement.clearWarnings();
            if (bl2) {
                string2 = string2 + this.getResults(statement, stringBuffer, bl);
                Support.addLogEntry(2, this, this.getClass(), string, string2);
                continue;
            }
            n = statement.getUpdateCount();
            this.getMessage(statement.getWarnings(), stringBuffer);
            statement.clearWarnings();
        } while ((bl2 = statement.getMoreResults()) || n != -1);
        return string2 + "\n" + stringBuffer.toString();
    }

    private String getResults(Statement statement, StringBuffer stringBuffer, boolean bl) throws SQLException {
        Vector vector = new Vector();
        this.getTextOutput(statement, stringBuffer, vector, bl);
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + vector.elementAt(i);
        }
        return string;
    }

    public int getTextOutput(Statement statement, StringBuffer stringBuffer, Vector vector, boolean bl) throws SQLException {
        int n;
        int n2;
        int n3 = -1;
        ResultSet resultSet = statement.getResultSet();
        this.getMessage(resultSet.getWarnings(), stringBuffer);
        resultSet.clearWarnings();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n4];
        String[] stringArray = new String[n4];
        int n5 = 0;
        if (bl) {
            n5 = 1;
            nArray = new int[n4 + n5];
            stringArray = new String[n4 + n5];
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (bl) {
            String string = ASEUtils.getString("DISP_EDIT_ROW");
            stringBuffer3.append(string + " ");
            stringArray[0] = string;
            nArray[0] = string.length();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            stringArray[n2 + n5] = resultSetMetaData.getColumnLabel(n2 + 1);
            nArray[n2 + n5] = resultSetMetaData.getColumnType(n2 + 1) == 2000 ? 255 : Math.max(stringArray[n2 + n5].length(), Math.min(resultSetMetaData.getColumnDisplaySize(n2 + 1), 255));
            stringBuffer3.append(Utility.resizeString(stringArray[n2 + n5], nArray[n2 + n5]) + " ");
        }
        stringBuffer3.append("\n");
        for (n2 = 1; n2 <= n4 + n5; ++n2) {
            for (n = 0; n < nArray[n2 - 1]; ++n) {
                stringBuffer3.append("-");
            }
            stringBuffer3.append(" ");
        }
        stringBuffer3.append("\n");
        stringBuffer2.append(stringBuffer3);
        StringBuffer stringBuffer4 = new StringBuffer();
        n = 1;
        while (resultSet.next()) {
            if (bl) {
                stringBuffer4.append(Utility.resizeString(String.valueOf(n++), nArray[0]) + " ");
            }
            for (int i = 1; i <= n4; ++i) {
                this.getMessage(resultSet.getWarnings(), stringBuffer);
                resultSet.clearWarnings();
                String string = "";
                Object object = resultSet.getObject(i);
                string = resultSetMetaData.getColumnType(i) == 2000 ? object.toString() : (object != null ? object.toString() : ResultSetDetailsPanel.getProfNullDisplay());
                stringBuffer4.append(Utility.resizeString(string, nArray[i - 1 + n5]) + " ");
            }
            stringBuffer4.append("\n");
        }
        stringBuffer4.append("\n");
        stringBuffer2.append(stringBuffer4);
        n3 = statement.getUpdateCount();
        if (n3 >= 0) {
            String string = n3 == 1 ? ASEUtils.getString("MSG_ONE_ROW_AFFECTED") : new ASEMessageText(ASEUtils.getString("MSG_ROWS_AFFECTED"), new Integer(n3)).toString();
            stringBuffer2.append(string + "\n");
        }
        if (vector != null) {
            vector.add(stringBuffer2.toString());
        }
        return n3;
    }

    public synchronized String executeReturnWarningMsg(String string, String string2) throws SQLException {
        this.executeCommand(SQLs.getString("USE {0}", string), false);
        this.notifySQLListenerForQuery(string2);
        String string3 = "";
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            boolean bl = statement.execute(string2);
            int n = 0;
            do {
                try {
                    if (statement.getWarnings() != null) {
                        string3 = string3 + ASEMessageText.getSQLExceptionMessage(statement.getWarnings());
                    }
                }
                catch (SQLException sQLException) {
                    if (!this.isConnectionDead(sQLException)) {
                        string3 = string3 + ASEMessageText.getSQLExceptionMessage(sQLException);
                        break;
                    }
                    throw this.checkConnectionDead(sQLException);
                }
                statement.clearWarnings();
                n = statement.getUpdateCount();
            } while ((bl = statement.getMoreResults()) || n != -1);
        }
        catch (SQLException sQLException) {
            if (!this.isConnectionDead(sQLException)) {
                string3 = string3 + ASEMessageText.getSQLExceptionMessage(sQLException);
            }
            throw this.checkConnectionDead(sQLException);
        }
        this.notifySQLListenerForElapsedTime();
        Support.addLogEntry(2, this, this.getClass(), string2, string3);
        return string3;
    }

    public boolean notifySQLListenerForQuery(String string) {
        if (!this.hasSQLListener()) {
            return false;
        }
        return this._sqlListener.traceSQL(string);
    }

    public void notifySQLListenerForElapsedTime() {
        if (this.hasSQLListener()) {
            this._sqlListener.traceElapsedTime();
        }
    }

    public void notifySQLListenerForOutput(Statement statement, StringBuffer stringBuffer) throws SQLException {
        if (!this.hasSQLListener()) {
            return;
        }
        if (this._sqlListener.needOutput()) {
            String string = this.getResults(statement, stringBuffer, this._sqlListener.needRowNumbers());
            this._sqlListener.traceOutput(string);
        }
    }

    protected void notifySQLPreviewListeners(String string) {
        if (!this.hasSQLPreviewListeners()) {
            return;
        }
        for (int i = 0; i < this._sqlPreviewListeners.size(); ++i) {
            SQLListener sQLListener = (SQLListener)this._sqlPreviewListeners.elementAt(i);
            sQLListener.traceSQL(string);
        }
    }

    protected void notifySQLSchedulingListeners(String string) {
        if (this._sqlSchedulingListeners != null) {
            for (SQLListener sQLListener : this._sqlSchedulingListeners) {
                sQLListener.traceSQL(string);
            }
        }
    }

    public synchronized String executeReturnResultWarningMsg(String string, String string2) throws SQLException {
        this.executeCommand(SQLs.getString("USE {0}", string), false);
        this.notifySQLListenerForQuery(string2);
        String string3 = "";
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            boolean bl = false;
            statement.execute(string2);
            int n = 0;
            ResultSet resultSet = null;
            do {
                if (bl) {
                    int n2;
                    resultSet = statement.getResultSet();
                    string3 = string3 + ASEMessageText.getSQLExceptionMessage(statement.getWarnings());
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n3 = resultSetMetaData.getColumnCount();
                    for (n2 = 1; n2 <= n3; ++n2) {
                        if (n2 > 1) {
                            string3 = string3 + "\t";
                        }
                        string3 = string3 + resultSetMetaData.getColumnLabel(n2);
                    }
                    while (resultSet.next()) {
                        string3 = string3 + "\n";
                        for (n2 = 1; n2 <= n3; ++n2) {
                            if (n2 > 1) {
                                string3 = string3 + "\t";
                            }
                            string3 = string3 + resultSet.getString(n2);
                            if (!resultSet.wasNull()) continue;
                            string3 = string3 + "NULL";
                        }
                    }
                } else {
                    try {
                        string3 = string3 + ASEMessageText.getSQLExceptionMessage(statement.getWarnings());
                    }
                    catch (SQLException sQLException) {
                        if (!this.isConnectionDead(sQLException)) {
                            string3 = string3 + ASEMessageText.getSQLExceptionMessage(sQLException);
                            break;
                        }
                        throw this.checkConnectionDead(sQLException);
                    }
                }
                statement.clearWarnings();
                bl = statement.getMoreResults();
                n = statement.getUpdateCount();
            } while (bl || n != -1);
        }
        catch (SQLException sQLException) {
            if (!this.isConnectionDead(sQLException)) {
                string3 = string3 + ASEMessageText.getSQLExceptionMessage(sQLException);
            }
            throw this.checkConnectionDead(sQLException);
        }
        this.notifySQLListenerForElapsedTime();
        Support.addLogEntry(2, this, this.getClass(), string2, string3);
        return string3;
    }

    public final String getServerServerName() {
        return this._serverServerName;
    }

    public final String getServerName() {
        if (this._connInfo.getServerName() != null) {
            return this._connInfo.getServerName();
        }
        return this.getHostNameAndPortNumber();
    }

    public boolean hasAdHocServerName() {
        return this.getServerName().indexOf(":") != -1;
    }

    public final int getId() {
        return this._id;
    }

    public final String getPortNumber() {
        return this._portNum;
    }

    public final String getDatabaseName() {
        return this._databaseName;
    }

    public final int getPageSize() {
        return this._pageSize;
    }

    public final int getMaxPageSize() {
        return this._maxPageSize;
    }

    public final String getHostNameAndPortNumber() {
        return this._connInfo.host + ":" + this.getPortNumber();
    }

    public final Connection getConnection() {
        return this._conn;
    }

    public final String getCurrentUser() {
        return this._currentUser;
    }

    public final String getUser() {
        return (String)this._props.get("USER");
    }

    public final String getPassword() {
        return ASEUtils.decryptPassword((String)this._props.get("PASSWORD"));
    }

    public final String getCharacterSet() {
        return (String)this._props.get("CHARSET");
    }

    public final String getLanguageChoice() {
        return (String)this._props.get("LANGUAGE");
    }

    public DomainDatatypes getDomainDatatypes() {
        return this._datatypeList;
    }

    private void printSQLWarnings() throws SQLException {
        String string = "";
        for (SQLWarning sQLWarning = this._conn.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
            String string2 = sQLWarning.getMessage();
            string = string + string2;
            string2 = null;
        }
        if (string.length() != 0) {
            Support.addLogEntry(1, this, this.getClass(), string, string);
        }
    }

    public String getNextDatabase(String string) throws Exception {
        if (string.length() == 0) {
            string = "NULL";
        }
        ASEMessageText aSEMessageText = new ASEMessageText("SELECT next_database({0})", string);
        ASResultSet aSResultSet = new ASResultSet(this);
        String string2 = "";
        aSResultSet.open(aSEMessageText.toString());
        if (aSResultSet.getNextRow()) {
            string2 = aSResultSet.getColumnString(1);
        }
        aSResultSet.close();
        return string2;
    }

    public String getDatabaseAlias(String string) throws Exception {
        String string2 = "";
        if (string.length() == 0) {
            return string2;
        }
        ASEMessageText aSEMessageText = new ASEMessageText("SELECT db_property( 'Alias', {0} )", string);
        ASResultSet aSResultSet = new ASResultSet(this);
        aSResultSet.open(aSEMessageText.toString());
        if (aSResultSet.getNextRow()) {
            string2 = aSResultSet.getColumnString(1);
        }
        aSResultSet.close();
        return string2;
    }

    private void processVersionString() throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(this);
        aSResultSet.open("select @@servername, @@version, @@language, db_name(), suser_name(), low from master.dbo.spt_values where number = 1 and type = 'E'");
        aSResultSet.getNextRow();
        int n = 1;
        this._serverServerName = aSResultSet.getColumnString(n++);
        this._versionString = aSResultSet.getColumnString(n++);
        this._language = aSResultSet.getColumnString(n++);
        this._databaseName = aSResultSet.getColumnString(n++);
        this._currentUser = aSResultSet.getColumnString(n++);
        this._pageSize = aSResultSet.getColumnInt(n++);
        aSResultSet.close();
        this.setSDCView(SDC_VIEW_INSTANCE);
        try {
            aSResultSet.open("select charset_description = a.description, sort_order_description = b.description from master.dbo.syscharsets a, master.dbo.syscharsets b where a.id = (select value from master.dbo.syscurconfigs where config = 131) and b.id = (select value from master.dbo.syscurconfigs where config = 123) and b.csid = (select value from master.dbo.syscurconfigs where config = 131)");
            aSResultSet.getNextRow();
            n = 1;
            this._charSetDescription = aSResultSet.getColumnString(n++);
            this._sortOrderDescription = aSResultSet.getColumnString(n++);
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._versionHelper = new ASEVersionHelper(this._versionString);
        if (this.getVersion().compareTo(VERSION_125) >= 0) {
            aSResultSet.open("select @@maxpagesize");
            aSResultSet.getNextRow();
            this._maxPageSize = aSResultSet.getColumnInt(1);
        } else {
            this._maxPageSize = this._pageSize;
        }
    }

    public final String getVersionString() {
        return this._versionString;
    }

    public final String getServerBuild1() {
        return this._versionHelper.getBuild1();
    }

    public final String getHostName() {
        return this._connInfo.host;
    }

    public final String getServiceFilter() {
        return this._connInfo.getProperty("SERVICEFILTER");
    }

    public final String getLanguage() {
        return this._language;
    }

    public final String getCharSetDescription() {
        return this._charSetDescription;
    }

    public final String getSortOrderDescription() {
        return this._sortOrderDescription;
    }

    public final String getServerType() {
        return this._versionHelper.getType();
    }

    public final String getReleaseType() {
        return this._versionHelper.getReleaseType();
    }

    public final String getPlatform() {
        return this._versionHelper.getPlatform();
    }

    public final String getOperatingSystem() {
        return this._versionHelper.getOperatingSystem();
    }

    public final String getBuild1() {
        return this._versionHelper.getBuild1();
    }

    public final String getBuild2() {
        return this._versionHelper.getBuild2();
    }

    public final String getBuildDate() {
        return this._versionHelper.getBuildDate();
    }

    public final String getVersion() {
        return this._versionHelper.getVersion();
    }

    public final String getDisplayName() {
        return ASConnection.getConnectionDisplayName(this.getServerName(), this.getCurrentUser(), this._id);
    }

    public static String getConnectionDisplayName(String string, String string2, int n) {
        String string3 = string2 != null && string2.length() > 0 ? string + " (" + string2 + ")" : string;
        String string4 = n == 0 ? string3 : string3 + ": " + String.valueOf(n);
        if (ASConnection.isShutdownServer(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("OPERATION_IN_PROGESS"), ASEUtils.getString("MSG_SHUTDOWN"));
            string4 = string4 + " (" + aSEMessageText.toString() + ")";
        }
        return string4;
    }

    public void setSQLListener(SQLListener sQLListener) {
        this._sqlListener = sQLListener;
    }

    public void setSQLListener(Object object) {
        this.setSQLListener((SQLListener)object);
    }

    public void unsetSQLListener() {
        this._sqlListener = null;
    }

    public boolean hasSQLListener() {
        return this._sqlListener != null;
    }

    public SQLListener getSQLListener() {
        return this._sqlListener;
    }

    public void addSQLPreviewListener(SQLListener sQLListener) {
        if (this._sqlPreviewListeners == null) {
            this._sqlPreviewListeners = new Vector();
        }
        this._sqlPreviewListeners.addElement(sQLListener);
    }

    public void removeSQLPreviewListener(SQLListener sQLListener) {
        this._sqlPreviewListeners.removeElement(sQLListener);
    }

    public boolean hasSQLPreviewListeners() {
        return this._sqlPreviewListeners != null && this._sqlPreviewListeners.size() > 0;
    }

    public Enumeration getSQLPreviewListeners() {
        return this._sqlPreviewListeners.elements();
    }

    public void addSQLSchedulingListener(SQLListener sQLListener) {
        if (this._sqlSchedulingListeners == null) {
            this._sqlSchedulingListeners = new Vector();
        }
        this._sqlSchedulingListeners.add(sQLListener);
    }

    public void removeSQLSchedulingListener(SQLListener sQLListener) {
        this._sqlSchedulingListeners.remove(sQLListener);
    }

    public boolean hasSQLSchedulingListeners() {
        return this._sqlSchedulingListeners != null && this._sqlSchedulingListeners.size() > 0;
    }

    public Enumeration getSQLSchedulingListeners() {
        return this._sqlSchedulingListeners.elements();
    }

    private static void initShutdownServers() {
        if (_shutdownServers == null) {
            _shutdownServers = new HashSet();
        }
    }

    public static void addShutdownServer(String string) {
        ASConnection.initShutdownServers();
        _shutdownServers.add(string);
    }

    public static void removeShutdownServer(String string) {
        ASConnection.initShutdownServers();
        _shutdownServers.remove(string);
    }

    public static boolean isShutdownServer(String string) {
        ASConnection.initShutdownServers();
        boolean bl = _shutdownServers.contains(string);
        return bl;
    }

    public boolean checkRole(String string) throws SQLException {
        String string2 = SQLs.getString("select proc_role(''{0}'')", string);
        this.getRSet().open(string2);
        this.getRSet().getNextRow();
        int n = this.getRSet().getColumnInt(1);
        this.getRSet().close();
        return n > 0;
    }

    private boolean checkCommand(String string) throws SQLException {
        this.executeCommand(SQLs.getString("USE {0}", "master"));
        this.getRSet().open(SQLs.getString("select count(action) from sysprotects where uid = user_id() and action = {0}", string));
        int n = 0;
        if (this.getRSet().getNextRow()) {
            n = this.getRSet().getColumnInt(1);
        }
        this.getRSet().close();
        return n > 0;
    }

    public boolean hasRole(String string) {
        Object v;
        boolean bl = false;
        if (this._roles == null) {
            this._roles = new Hashtable();
        }
        if ((v = this._roles.get(string)) == null) {
            try {
                bl = this.checkRole(string);
                this._roles.put(string, bl);
            }
            catch (SQLException sQLException) {}
        } else {
            bl = (Boolean)v;
        }
        return bl;
    }

    public boolean hasCommandPermission(String string) {
        Boolean bl = false;
        if (this._permissions == null) {
            this._permissions = new HashMap();
        }
        if ((bl = this._permissions.get(string)) == null) {
            try {
                bl = this.checkCommand(string);
                this._permissions.put(string, bl);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return bl;
    }

    public void resetCommandPermission(String string) {
        if (this._permissions == null) {
            return;
        }
        this._permissions.remove(string);
    }

    public int getSPConfigConfigValue(String string) throws SQLException {
        return this.getSPConfigValue(string, 4);
    }

    public int getSPConfigRunValue(String string) throws SQLException {
        return this.getSPConfigValue(string, 5);
    }

    private int getSPConfigValue(String string, int n) throws SQLException {
        String string2 = SQLs.getString("exec sp_configure ''{0}''", string);
        this.getRSet().open(string2);
        this.getRSet().getNextRow();
        int n2 = this.getRSet().getColumnInt(n);
        this.getRSet().close();
        return n2;
    }

    public boolean hasLicense(Object object) throws SQLException {
        this.getRSet().open(SQLs.getString("select isnull(license_enabled(''{0}''),0)", object));
        this.getRSet().getNextRow();
        return this.getRSet().getColumnInt(1) == 1;
    }

    public final ASResultSet getRSet() {
        if (this._rset == null) {
            this._rset = new ASResultSet(this);
        }
        return this._rset;
    }

    public boolean isExpansionProcedureInstalled() throws SQLException {
        this.getRSet().open("select 'yes' from sybsystemprocs.dbo.sysobjects where type = 'P' and name = 'sp_dbextend' ");
        return this.getRSet().getNextRow();
    }

    public boolean isPartitionsApplicable() {
        return this.getVersion().compareTo(VERSION_15) >= 0;
    }

    public boolean isPwdComplexityApplicable() {
        if (this._isPwdComplexityApplicable != null) {
            return this._isPwdComplexityApplicable;
        }
        this._isPwdComplexityApplicable = this.getVersion().compareTo(VERSION_1254) >= 0 && this.getVersion().compareTo(VERSION_150) < 0 || this.getVersion().compareTo(VERSION_1502) >= 0;
        return this._isPwdComplexityApplicable;
    }

    public boolean isArchiveDBApplicable() {
        if (this._isArchiveDBApplicable != null) {
            return this._isArchiveDBApplicable;
        }
        this._isArchiveDBApplicable = this.getVersion().compareTo(VERSION_1254) >= 0 && this.getVersion().compareTo(VERSION_15) < 0 || this.getVersion().compareTo(VERSION_1502) >= 0;
        return this._isArchiveDBApplicable;
    }

    public boolean isFeatureEnabled(String string) {
        try {
            return this.getSPConfigRunValue(string) == 1;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean isAutoExpansionApplicable() throws SQLException {
        if (this._isAutoExpansionApplicable != null) {
            return this._isAutoExpansionApplicable;
        }
        this._isAutoExpansionApplicable = this.getVersion().compareTo(VERSION_1251) >= 0 && this.hasSARole() && this.isExpansionProcedureInstalled();
        return this._isAutoExpansionApplicable;
    }

    public boolean isEncryptedKeyEnabled() {
        if (this.getVersion().compareTo(VERSION_1253) >= 0) {
            if (this._isECEnabled == null) {
                this._isECEnabled = this.isFeatureEnabled("enable encrypted columns");
            }
        } else {
            this._isECEnabled = false;
        }
        return this._isECEnabled;
    }

    public void refreshFeatureStatus() {
        this._isAutoExpansionApplicable = null;
        this._isECEnabled = null;
        this._isJavaEnabled = null;
        this._isCISEnabled = null;
        this._hasIncrementalTransferFeature = null;
    }

    public boolean isCISEnabled() throws SQLException {
        if (this._isCISEnabled == null) {
            this._isCISEnabled = false;
            this.getRSet().open("select value from master.dbo.sysconfigures where comment='enable cis'");
            if (this.getRSet().getNextRow()) {
                this._isCISEnabled = this.getRSet().getColumnString(1).equals("1");
            }
        }
        return this._isCISEnabled;
    }

    public boolean isWSEnabled() throws SQLException {
        if (this._isWSEnabled == null) {
            this._isWSEnabled = false;
            this.getRSet().open("select value from master.dbo.sysconfigures where comment='enable webservices'");
            if (this.getRSet().getNextRow()) {
                this._isWSEnabled = this.getRSet().getColumnString(1).equals("1");
            }
        }
        return this._isWSEnabled;
    }

    public boolean isResourceLimitsEnabled() {
        return this.isFeatureEnabled(FEATURE_ASE_RESOURCE_LIMITS);
    }

    public boolean isRTMSEnabled() {
        String string = this.getVersion();
        if (string.compareTo(VERSION_1252) < 0) {
            return false;
        }
        return this.isFeatureEnabled(FEATURE_ASE_MESSAGING_CONFIG);
    }

    public boolean isPartitionsEnabled() {
        return this.isFeatureEnabled(FEATURE_ASE_SEMANTIC_PARTITIONING_CONFIG);
    }

    public void setCISRPCHandler(boolean bl) throws SQLException {
        this.executeCommand(SQLs.getString("set cis_rpc_handling {0}", bl ? "on" : "off"));
    }

    public boolean isHAEnabled() throws SQLException {
        this.getRSet().open("select state = @@cmpstate");
        boolean bl = true;
        int n = -1;
        while (this.getRSet().getNextRow()) {
            try {
                n = this.getRSet().getColumnInt(1);
            }
            catch (SQLException sQLException) {
                break;
            }
            if (n != -2) continue;
            bl = false;
        }
        this.getRSet().close();
        return bl;
    }

    public boolean isJavaEnabled() {
        if (this._isJavaEnabled == null) {
            this._isJavaEnabled = this.isFeatureEnabled(FEATURE_ASE_JAVA_CONFIG);
        }
        return this._isJavaEnabled;
    }

    public boolean hasIncrementalTransferFeature() {
        if (this._hasIncrementalTransferFeature == null) {
            this._hasIncrementalTransferFeature = false;
            if (this.getVersion().compareTo(VERSION_15) >= 0 && !this.isCluster()) {
                try {
                    this.getRSet().open("select name from master..sysobjects where name = 'monTableTransfer'");
                    if (this.getRSet().getNextRow()) {
                        this._hasIncrementalTransferFeature = this.getRSet().getColumnString(1).equals("monTableTransfer");
                    }
                }
                catch (SQLException sQLException) {
                    this._hasIncrementalTransferFeature = false;
                    Support.showDetailsError(this, this.getClass(), sQLException.getMessage(), sQLException);
                }
            }
        }
        return this._hasIncrementalTransferFeature;
    }

    public final ASEConnectionInfo getConnectionInfo() {
        return this.getConnectionInfo(null, APPLICATION_NAME);
    }

    public final ASEConnectionInfo getConnectionInfo(ASEConnectionInfo aSEConnectionInfo) {
        ASEConnectionInfo aSEConnectionInfo2 = this.getConnectionInfo(null, null);
        aSEConnectionInfo2.merge(aSEConnectionInfo);
        return aSEConnectionInfo2;
    }

    public final ASEConnectionInfo getConnectionInfo(String string, String string2) {
        ASEConnectionInfo aSEConnectionInfo = new ASEConnectionInfo(this._connInfo);
        if (string2 != null) {
            aSEConnectionInfo.setApplicationName(string2);
        }
        if (string != null && string.length() > 0) {
            aSEConnectionInfo.setDatabaseName(string);
        }
        return aSEConnectionInfo;
    }

    public void setLastFolderPath(String string) {
        this._lastFolderPath = string;
    }

    public String getLastFolderPath() {
        return this._lastFolderPath;
    }

    public boolean hasSSORole() {
        return this.hasRole("sso_role");
    }

    public boolean hasSARole() {
        return this.hasRole("sa_role");
    }

    public boolean hasKeyCustodianRole() {
        if (this.getVersion().compareTo(VERSION_1502) >= 0) {
            return this.hasRole("keycustodian_role");
        }
        return false;
    }

    public boolean isRolePasswordConfigurable() throws SQLException {
        String string = "select count( name ) as role_number from master.dbo.syssrvroles where password != null and ( status = 0 or status & 4 = 0 )";
        this.getRSet().open(string);
        this.getRSet().getNextRow();
        int n = this.getRSet().getColumnInt(1);
        this.getRSet().close();
        return n > 0;
    }

    public boolean isESD(int n) {
        return this._versionHelper.isESD(n);
    }

    public boolean isQPTuneApplicable() {
        String string = this.getVersion();
        try {
            if (string.compareTo(VERSION_1503) > 0) {
                return true;
            }
            if (string.compareTo(VERSION_1502) == 0) {
                return this.isESD(6);
            }
            if (string.compareTo(VERSION_1503) == 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public boolean isIMDBApplicable() {
        String string = this.getVersion();
        if (this.isCluster()) {
            return false;
        }
        return string.compareTo(VERSION_1503) > 0;
    }

    public boolean isDMLLoggingApplicable() {
        String string = this.getVersion();
        return string.compareTo(VERSION_1503) > 0;
    }
}

