/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.sql;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.sql.ASConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;

public class ASResultSet {
    private ASConnection _asConn;
    private ResultSet _rSet;
    private PreparedStatement _sqlStatement;
    private int _nColumns;
    private boolean _isClosed;
    private boolean _moreResults;
    private boolean _isResultSet;
    private boolean _firstTime;
    private ResultSetMetaData _metaData;

    public ASResultSet(ASConnection aSConnection) {
        this._asConn = aSConnection;
        this._isClosed = true;
        this._rSet = null;
        this._metaData = null;
    }

    protected void finalize() throws SQLException {
        if (!this._isClosed) {
            this.close();
        }
    }

    public int getColumnCount() {
        return this._nColumns;
    }

    public ResultSet open(String string) throws SQLException {
        return this.open(string, true, true);
    }

    public ResultSet open(String string, boolean bl) throws SQLException {
        return this.open(string, bl, true);
    }

    public ResultSet open(String string, boolean bl, boolean bl2) throws SQLException {
        Connection connection = this._asConn.getConnection();
        if (connection != null) {
            this._asConn.notifySQLListenerForQuery(string);
            try {
                if (ASEUtils.validateQuery(string)) {
                    this._sqlStatement = bl2 ? connection.prepareStatement(string, 1005, 1007) : connection.prepareStatement(string);
                    this._rSet = this._sqlStatement.executeQuery();
                }
                if (this._asConn.hasSQLListener() && bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    this._asConn.notifySQLListenerForOutput(this._sqlStatement, stringBuffer);
                    this._rSet.beforeFirst();
                }
                this._metaData = this._rSet.getMetaData();
                this._nColumns = this._metaData.getColumnCount();
                this._firstTime = false;
                this._isClosed = false;
            }
            catch (SQLException sQLException) {
                throw this._asConn.checkConnectionDead(sQLException);
            }
            this._asConn.notifySQLListenerForElapsedTime();
        }
        return this._rSet;
    }

    public synchronized ResultSet executeRPC(String string) throws SQLException {
        String string2 = "{call " + string + "()}";
        this._asConn.notifySQLListenerForQuery(string2);
        Connection connection = this._asConn.getConnection();
        if (connection != null) {
            try {
                this._sqlStatement = connection.prepareCall(string2);
                this._rSet = this._sqlStatement.executeQuery();
                this._metaData = this._rSet.getMetaData();
                this._nColumns = this._metaData.getColumnCount();
                this._firstTime = false;
                this._isClosed = false;
            }
            catch (SQLException sQLException) {
                throw this._asConn.checkConnectionDead(sQLException);
            }
        }
        this._asConn.notifySQLListenerForElapsedTime();
        return this._rSet;
    }

    public void close() throws SQLException {
        if (this._sqlStatement != null) {
            try {
                this._sqlStatement.close();
                this._sqlStatement = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this._rSet != null) {
            this._rSet.close();
            this._rSet = null;
            this._metaData = null;
        }
        this._isClosed = true;
    }

    public boolean getNextRow() throws SQLException {
        if (this._firstTime) {
            this.getNextResultSet(true);
        }
        if (this._rSet != null) {
            return this._rSet.next();
        }
        return false;
    }

    public ResultSetMetaData getResultSetMetaData() throws SQLException {
        if (this._firstTime) {
            this.getNextResultSet(true);
        }
        return this._metaData;
    }

    public boolean getNextResultSet(boolean bl) throws SQLException {
        if (this._isClosed) {
            return false;
        }
        if (this._firstTime) {
            this._firstTime = false;
        } else {
            this._isResultSet = this._sqlStatement.getMoreResults();
        }
        if (!this.getResultsAndMetadata() && bl) {
            this._isResultSet = this._sqlStatement.getMoreResults();
            this.getResultsAndMetadata();
        }
        return this._moreResults;
    }

    public String[] getColumnsAsArray() throws SQLException {
        String[] stringArray = new String[this._nColumns];
        for (int i = 0; i < this._nColumns; ++i) {
            stringArray[i] = this.getColumnString(i + 1);
        }
        return stringArray;
    }

    public String getColumnString(String string) throws SQLException {
        int n = this._metaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string2 = this._metaData.getColumnLabel(i);
            if (!string2.equals(string)) continue;
            return this.getColumnString(i);
        }
        return "";
    }

    public String getColumnString(int n) throws SQLException {
        String string;
        Object object;
        if (this._metaData.getColumnType(n) == 2000) {
            object = this._rSet.getObject(n);
            string = object.toString();
        } else {
            string = this._rSet.getString(n);
        }
        if (!this._rSet.wasNull()) {
            switch (this._metaData.getColumnType(n)) {
                case 1: {
                    string = string.trim();
                    break;
                }
                case 93: {
                    object = this._rSet.getTimestamp(n);
                    string = DateFormat.getDateTimeInstance(2, 3).format((Date)object);
                    break;
                }
                case 91: {
                    object = this._rSet.getDate(n);
                    string = DateFormat.getDateInstance(2).format((Date)object);
                    break;
                }
                case 92: {
                    object = this._rSet.getDate(n);
                    string = DateFormat.getTimeInstance(3).format((Date)object);
                    break;
                }
            }
        } else {
            string = "";
        }
        return string;
    }

    public int getColumnInt(int n) throws SQLException {
        return this._rSet.getInt(n);
    }

    public int getColumnInt(String string) throws SQLException {
        return this._rSet.getInt(string);
    }

    public long getColumnLong(int n) throws SQLException {
        return this._rSet.getLong(n);
    }

    public Date getColumnDate(int n) throws SQLException {
        return this._rSet.getTimestamp(n);
    }

    private boolean getResultsAndMetadata() throws SQLException {
        this._metaData = null;
        this._moreResults = false;
        if (this._isResultSet) {
            this._rSet = this._sqlStatement.getResultSet();
            if (this._rSet != null) {
                this._metaData = this._rSet.getMetaData();
                this._nColumns = this._metaData.getColumnCount();
                this._moreResults = true;
            }
        } else {
            int n = this._sqlStatement.getUpdateCount();
            if (n != -1) {
                this._moreResults = true;
                return false;
            }
        }
        return true;
    }

    public ASConnection getConnection() {
        return this._asConn;
    }

    public void beforeFirst() throws SQLException {
        this._rSet.beforeFirst();
    }

    public void first() throws SQLException {
        this._rSet.first();
    }

    public void last() throws SQLException {
        this._rSet.last();
    }

    public int getRow() throws SQLException {
        return this._rSet.getRow();
    }
}

