/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.sql;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.util.Debug;
import com.sybase.util.ds.DirectoryServiceHelper;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.LDAPSetting;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class DirectoryService {
    private static long _interfaceFilelastModified = -1L;
    private static long _LDAP32FilelastModified = -1L;
    private static long _LDAP64FilelastModified = -1L;
    private static boolean _LDAPOption = true;
    private static int _LDAPTimeout = -1;
    private static Hashtable _ASEs;
    private static Hashtable _lookupASEfromInterfaces;
    private static Hashtable _lookupASEfromLDAP;
    private static int _ldapTimeout;
    private static boolean _includeLDAP;
    private static String _interfaceFileName;
    private static LibctlDriver _libtcldriver;
    private static DirectoryServiceHelper _dsHelper;

    private static SyInterfacesDriver getInterfacesDriver(boolean bl) throws Exception {
        if (_dsHelper == null) {
            _dsHelper = new DirectoryServiceHelper();
        }
        return _dsHelper.getInterfacesDriver(new Boolean(bl));
    }

    private static void initLDAPValues() {
        LDAPSetting lDAPSetting = LDAPSetting.getLDAPSetting();
        _includeLDAP = lDAPSetting.includeLDAP;
        _ldapTimeout = lDAPSetting.timeout;
    }

    private static boolean isInterfacesFileModified() {
        Object object;
        String string = null;
        String string2 = System.getProperty("interface.file");
        if (string2 != null) {
            string = string2;
        } else {
            object = System.getProperty("file.separator");
            String string3 = ASEProvider.getSybasePath();
            string = ASEUtils.OS_WINDOWS ? string3 + (String)object + "ini" + (String)object + "sql.ini" : string3 + (String)object + "interfaces";
        }
        _interfaceFileName = string;
        object = new File(string);
        if (((File)object).exists() && ((File)object).lastModified() != _interfaceFilelastModified) {
            _interfaceFilelastModified = ((File)object).lastModified();
            return true;
        }
        return false;
    }

    private static boolean isLDAPFileModified() throws LDAPException, FileNotFoundException, IOException {
        _libtcldriver = new LibctlDriver();
        File file = new File(_libtcldriver.getLDAP32FileName());
        if (file.exists() && file.lastModified() != _LDAP32FilelastModified) {
            _LDAP32FilelastModified = file.lastModified();
            return true;
        }
        File file2 = new File(_libtcldriver.getLDAP64FileName());
        if (file2.exists() && file2.lastModified() != _LDAP64FilelastModified) {
            _LDAP64FilelastModified = file2.lastModified();
            return true;
        }
        return false;
    }

    public static boolean initServerEntries() {
        Object object;
        Enumeration enumeration;
        boolean bl;
        block19: {
            bl = false;
            try {
                bl = DirectoryService.isInterfacesFileModified();
                if (bl) {
                    _lookupASEfromInterfaces = new Hashtable();
                    SyInterfacesDriver syInterfacesDriver = DirectoryService.getInterfacesDriver(true);
                    enumeration = syInterfacesDriver.entries();
                    while (enumeration.hasMoreElements()) {
                        object = (SyInterfacesEntry)enumeration.nextElement();
                        try {
                            _lookupASEfromInterfaces.put(object.getName(), new SyASEServer(object));
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                }
            }
            catch (Exception exception) {
                if (!Debug.isOn()) break block19;
                System.out.println(exception);
            }
        }
        DirectoryService.initLDAPValues();
        boolean bl2 = false;
        try {
            if (_includeLDAP && ((bl2 = DirectoryService.isLDAPFileModified()) || _LDAPOption != _includeLDAP || _LDAPTimeout != _ldapTimeout)) {
                DirectoryService.getASEntriesfromLDAP();
            }
        }
        catch (LDAPException lDAPException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (_LDAPTimeout == -1) {
            _LDAPOption = _includeLDAP;
            _LDAPTimeout = _ldapTimeout;
        }
        bl = DirectoryService.checkinterfacesFileExist(bl);
        bl2 = DirectoryService.checkLDAPFileExist(bl2);
        if (_LDAPOption != _includeLDAP || _LDAPTimeout != _ldapTimeout || bl || bl2) {
            _ASEs = null;
            _LDAPOption = _includeLDAP;
            _LDAPTimeout = _ldapTimeout;
            if (_lookupASEfromInterfaces != null) {
                _ASEs = (Hashtable)_lookupASEfromInterfaces.clone();
            }
            if (_includeLDAP && _lookupASEfromLDAP != null) {
                if (_ASEs == null) {
                    _ASEs = (Hashtable)_lookupASEfromLDAP.clone();
                } else {
                    enumeration = _lookupASEfromLDAP.keys();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        if (_ASEs.containsKey(object)) {
                            SyASEServer syASEServer = (SyASEServer)_lookupASEfromLDAP.get(object);
                            _ASEs.put((String)object + " [" + syASEServer.getHost() + ":" + syASEServer.getPort() + "]", syASEServer);
                            continue;
                        }
                        _ASEs.put(object, _lookupASEfromLDAP.get(object));
                    }
                }
            }
        }
        return _ASEs != null;
    }

    private static boolean checkinterfacesFileExist(boolean bl) {
        if (bl) {
            return bl;
        }
        if (_interfaceFileName != null) {
            File file = new File(_interfaceFileName);
            if (!file.exists() && _lookupASEfromInterfaces != null) {
                _lookupASEfromInterfaces = null;
                _interfaceFilelastModified = -1L;
                return true;
            }
        } else {
            _lookupASEfromInterfaces = null;
            _interfaceFilelastModified = -1L;
            return true;
        }
        return bl;
    }

    private static boolean checkLDAPFileExist(boolean bl) {
        if (bl) {
            return bl;
        }
        if (_libtcldriver == null && _lookupASEfromLDAP != null) {
            _lookupASEfromLDAP = null;
            _LDAP32FilelastModified = -1L;
            _LDAP64FilelastModified = -1L;
            return true;
        }
        return bl;
    }

    private static String[] getNames(Collection collection) {
        String[] stringArray = new String[]{};
        if (null == collection) {
            return stringArray;
        }
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    public static String[] getASEServerNamesFromInterfaces() {
        if (_lookupASEfromInterfaces == null) {
            return null;
        }
        return DirectoryService.getNames(_lookupASEfromInterfaces.keySet());
    }

    public static String[] getAllASEServerNames() {
        return _ASEs == null ? new String[]{} : DirectoryService.getNames(_ASEs.keySet());
    }

    private static void getASEntriesfromLDAP() {
        Vector vector = _libtcldriver.getLDAPServers();
        for (int i = 0; i < vector.size(); ++i) {
            SyLDAPServer syLDAPServer = (SyLDAPServer)vector.elementAt(i);
            try {
                _lookupASEfromLDAP = null;
                if (!syLDAPServer.connectLDAP(_ldapTimeout)) continue;
                syLDAPServer.initASEEntries();
                _lookupASEfromLDAP = (Hashtable)syLDAPServer.getLookup().clone();
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getQueryServiceNum(String string) {
        if (_ASEs == null) {
            DirectoryService.initServerEntries();
        }
        if (_ASEs == null) {
            return 0;
        }
        SyASEServer syASEServer = (SyASEServer)_ASEs.get(string);
        if (syASEServer == null) {
            return 0;
        }
        return syASEServer.getInterfacesEntry().getServices("query").size();
    }

    public static String getQueryAddresses(String string) {
        if (_ASEs == null) {
            DirectoryService.initServerEntries();
        }
        if (_ASEs == null) {
            return null;
        }
        String string2 = null;
        SyASEServer syASEServer = (SyASEServer)_ASEs.get(string);
        List list = syASEServer.getInterfacesEntry().getServices("query");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Service service = (Service)list.get(i);
            String string3 = service.getHost();
            String string4 = service.getPort();
            String string5 = string3 + ":" + string4;
            string2 = string2 == null ? string5 : string2 + "," + string5;
        }
        return string2;
    }

    public static String getHostName(Object object) {
        if (_ASEs == null) {
            return null;
        }
        SyASEServer syASEServer = (SyASEServer)_ASEs.get(object);
        String string = null;
        if (syASEServer != null) {
            string = syASEServer.getHost();
        }
        return string;
    }

    public static boolean isSSL(Object object) {
        if (_ASEs == null) {
            return false;
        }
        SyASEServer syASEServer = (SyASEServer)_ASEs.get(object);
        SyInterfacesEntry syInterfacesEntry = syASEServer.getInterfacesEntry();
        return syInterfacesEntry.isSSL();
    }

    public static String getPortNumber(Object object) {
        if (_ASEs == null) {
            return null;
        }
        String string = null;
        SyASEServer syASEServer = (SyASEServer)_ASEs.get(object);
        if (syASEServer != null) {
            string = syASEServer.getPort();
        }
        return string;
    }

    public static void setServerAndHost(ASEConnectionInfo aSEConnectionInfo) {
        if (aSEConnectionInfo.getServerName() != null) {
            if (aSEConnectionInfo.host == null || aSEConnectionInfo.host.length() == 0) {
                aSEConnectionInfo.host = DirectoryService.getHostName(aSEConnectionInfo.getServerName());
            }
            if (aSEConnectionInfo.port < 0) {
                aSEConnectionInfo.port = Integer.valueOf(DirectoryService.getPortNumber(aSEConnectionInfo.getServerName()));
            }
        }
    }

    public static boolean interfacesFileExists() {
        if (_interfaceFileName == null) {
            DirectoryService.initServerEntries();
        }
        return _lookupASEfromInterfaces != null;
    }

    static {
        _includeLDAP = true;
        _dsHelper = null;
    }
}

