/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.sql;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class RLMetaData {
    public static final int TABLE_NAME_COL = 0;
    public static final int TABLE_OWNER_COL = 1;
    public static final int REMOTE_TABLE_NAME = 0;
    public static final int REMOTE_TABLE_OWNER = 1;
    public static final int REMOTE_PROC_NAME = 0;
    public static final int REMOTE_PROC_OWNER = 1;
    public static final int LOCATOR_TXID_PAGE = 0;
    public static final int LOCATOR_TXID_ROW = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDatabases(ASConnection aSConnection) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Vector<String> vector = new Vector<String>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("DBS_OPEN_QUERY"));
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                vector.addElement(stringArray[0]);
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && !sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getRemoteDatabases(ASConnection aSConnection, String string) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null, "NULL remoteSrv parameter");
        Debug.wassert(string.length() > 0, "Empty remoteSrv parameter");
        Vector<String> vector = new Vector<String>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REMOTE_DATABASES", string));
            while (aSResultSet.getNextRow()) {
                String string2 = aSResultSet.getColumnString(1);
                if (string2 == null || string2.length() == 0) {
                    String string3 = ASEUtils.getString("ERR_INVALID_SQL_DB_FLD");
                    SQLException sQLException = new SQLException(string3);
                    throw sQLException;
                }
                vector.addElement(string2);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getRemoteServers(ASConnection aSConnection) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Vector<String> vector = new Vector<String>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REMOTE_SERVERS"));
            while (aSResultSet.getNextRow()) {
                String string = aSResultSet.getColumnString(1);
                if (string == null || string.length() == 0) {
                    String string2 = ASEUtils.getString("ERR_INVALID_SQL_SERVER_FLD");
                    SQLException sQLException = new SQLException(string2);
                    throw sQLException;
                }
                vector.addElement(string);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getLocalServers(ASConnection aSConnection) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Vector<String> vector = new Vector<String>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_LOCAL_SERVERS"));
            while (aSResultSet.getNextRow()) {
                String string = aSResultSet.getColumnString(1);
                if (string == null || string.length() == 0) {
                    String string2 = ASEUtils.getString("ERR_INVALID_SQL_SERVER_FLD");
                    SQLException sQLException = new SQLException(string2);
                    throw sQLException;
                }
                vector.addElement(string);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getLogins(ASConnection aSConnection, String string) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty database parameter");
        Vector<String> vector = new Vector<String>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_LOGIN", string));
            while (aSResultSet.getNextRow()) {
                String string2 = aSResultSet.getColumnString(1);
                if (string2 == null || string2.length() == 0) {
                    String string3 = ASEUtils.getString("ERR_INVALID_SQL_LOGIN_FLD");
                    SQLException sQLException = new SQLException(string3);
                    throw sQLException;
                }
                vector.addElement(string2);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getRemoteLogins(ASConnection aSConnection, String string) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null, "NULL remoteSrv parameter");
        Debug.wassert(string.length() > 0, "Empty remoteSrv parameter");
        Vector<String> vector = new Vector<String>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REMOTE_LOGIN", string));
            while (aSResultSet.getNextRow()) {
                String string2 = aSResultSet.getColumnString(3);
                if (string2 == null || string2.length() == 0) {
                    String string3 = ASEUtils.getString("ERR_INVALID_SQL_LOGIN_FLD");
                    SQLException sQLException = new SQLException(string3);
                    throw sQLException;
                }
                if (RLMetaData.findString(vector, string2)) continue;
                vector.addElement(string2);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetLoginID(ASConnection aSConnection, String string) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null, "NULL user parameter");
        Debug.wassert(string.length() > 0, "Empty user parameter");
        int n = 0;
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_LOGIN_ID", string));
            if (aSResultSet.getNextRow()) {
                n = aSResultSet.getColumnInt(1);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getTables(ASConnection aSConnection, String string) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null, "NULL database parameter");
        Debug.wassert(string.length() > 0, "Empty database parameter");
        Vector vector = new Vector();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("USERTABLESCTR_OPEN_QUERY", string));
            while (aSResultSet.getNextRow()) {
                Vector<String> vector2;
                String string2;
                String string3 = aSResultSet.getColumnString(1);
                if (string3 == null || string3.length() == 0) {
                    string2 = ASEUtils.getString("ERR_INVALID_SQL_TABLE_FLD");
                    vector2 = new SQLException(string2);
                    throw vector2;
                }
                string2 = aSResultSet.getColumnString(2);
                if (string2 == null || string2.length() == 0) {
                    vector2 = ASEUtils.getString("ERR_INVALID_SQL_OWNER_FLD");
                    SQLException sQLException = new SQLException((String)((Object)vector2));
                    throw sQLException;
                }
                vector2 = new Vector<String>();
                vector2.addElement(string3);
                vector2.addElement(string2);
                vector.addElement(vector2);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getProcedures(ASConnection aSConnection, String string) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null, "NULL database parameter");
        Debug.wassert(string.length() > 0, "Empty database parameter");
        Vector vector = new Vector();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("STOREDPROCEDURESCTR_OPEN_QUERY", string));
            while (aSResultSet.getNextRow()) {
                Vector<String> vector2;
                String string2;
                String string3 = aSResultSet.getColumnString(1);
                if (string3 == null || string3.length() == 0) {
                    string2 = ASEUtils.getString("ERR_INVALID_SQL_TABLE_FLD");
                    vector2 = new SQLException(string2);
                    throw vector2;
                }
                if (string3.equals("sp_repmarker")) continue;
                string2 = aSResultSet.getColumnString(2);
                if (string2 == null || string2.length() == 0) {
                    vector2 = ASEUtils.getString("ERR_INVALID_SQL_OWNER_FLD");
                    SQLException sQLException = new SQLException((String)((Object)vector2));
                    throw sQLException;
                }
                vector2 = new Vector<String>();
                vector2.addElement(string3);
                vector2.addElement(string2);
                vector.addElement(vector2);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getFieldData(ASConnection aSConnection, String string, String string2, String string3) throws SQLException {
        Vector vector = new Vector();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_FIELDS", string, string2, string3));
            while (aSResultSet.getNextRow()) {
                String string4;
                Vector<Object> vector2 = new Vector<Object>();
                String string5 = aSResultSet.getColumnString(1);
                if (string5 == null || string5.length() == 0) {
                    string4 = ASEUtils.getString("ERR_INVALID_SQL_COL_NAME_FLD");
                    SQLException sQLException = new SQLException(string4);
                    throw sQLException;
                }
                vector2.addElement(string5);
                string4 = aSResultSet.getColumnString(2);
                if (string4 == null || string4.length() == 0) {
                    String string6 = ASEUtils.getString("ERR_INVALID_SQL_COL_DT_FLD");
                    SQLException sQLException = new SQLException(string6);
                    throw sQLException;
                }
                int n = aSResultSet.getColumnInt(3);
                int n2 = aSResultSet.getColumnInt(4);
                int n3 = aSResultSet.getColumnInt(5);
                vector2.addElement(RLMetaData.FormatDatatype(aSConnection, string4, n, n2, n3));
                int n4 = aSResultSet.getColumnInt(6);
                vector2.addElement(new Integer(n4));
                vector.addElement(vector2);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getKeyFields(ASConnection aSConnection, String string, String string2, String string3) throws SQLException {
        Vector<String> vector = new Vector<String>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_KEY_FIELDS", string, string2, string3));
            while (aSResultSet.getNextRow()) {
                String string4 = aSResultSet.getColumnString(2);
                if (string4 == null || string4.length() == 0) {
                    String string5 = ASEUtils.getString("ERR_INVALID_SQL_COL_NAME_FLD");
                    SQLException sQLException = new SQLException(string5);
                    throw sQLException;
                }
                vector.addElement(string4);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getRemoteTables(ASConnection aSConnection, String string, String string2) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null && string.length() > 0, "NULL or empty server parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "NULL or empty database parameter");
        Vector vector = new Vector();
        RLMetaData.useRemoteDatabase(aSConnection, string, string2);
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            String string3 = rLSQLResourceBundle.getString("QUERY_REMOTE_TABLES", string);
            aSResultSet.open(string3);
            while (aSResultSet.getNextRow()) {
                Vector<String> vector2;
                String string4;
                String string5 = aSResultSet.getColumnString(3);
                if (string5 == null || string5.length() == 0) {
                    string4 = ASEUtils.getString("ERR_INVALID_SQL_TABLE_FLD");
                    vector2 = new SQLException(string4);
                    throw vector2;
                }
                string4 = aSResultSet.getColumnString(2);
                if (string4 == null || string4.length() == 0) {
                    vector2 = ASEUtils.getString("ERR_INVALID_SQL_OWNER_FLD");
                    SQLException sQLException = new SQLException((String)((Object)vector2));
                    throw sQLException;
                }
                vector2 = new Vector<String>();
                vector2.addElement(string5);
                vector2.addElement(string4);
                vector.addElement(vector2);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getRemoteProcedures(ASConnection aSConnection, String string, String string2) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null && string.length() > 0, "NULL or empty server parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "NULL or empty database parameter");
        Vector<Object> vector = new Vector<Object>();
        RLMetaData.useRemoteDatabase(aSConnection, string, string2);
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REMOTE_PROCS", string, string2));
            while (aSResultSet.getNextRow()) {
                Object object;
                Object object2;
                Object object3;
                String string3;
                String string4 = aSResultSet.getColumnString(3);
                if (string4 == null || string4.length() == 0) {
                    string3 = ASEUtils.getString("ERR_INVALID_SQL_TABLE_FLD");
                    object3 = new SQLException(string3);
                    throw object3;
                }
                string3 = aSResultSet.getColumnString(2);
                if (string3 == null || string3.length() == 0) {
                    object3 = ASEUtils.getString("ERR_INVALID_SQL_OWNER_FLD");
                    object2 = new SQLException((String)object3);
                    throw object2;
                }
                object3 = new String("0123456789");
                object2 = string4;
                Integer n = new Integer(1);
                int n2 = string4.lastIndexOf(";");
                if (n2 != -1 && string4.length() > n2 + 1) {
                    object = string4.substring(n2 + 1);
                    boolean bl = true;
                    for (int i = 0; i < ((String)object).length() && bl; ++i) {
                        if (((String)object3).indexOf(((String)object).charAt(i)) != -1) continue;
                        bl = false;
                    }
                    if (bl) {
                        object2 = string4.substring(0, n2);
                        n = new Integer((String)object);
                    }
                }
                object = new Vector<Object>();
                ((Vector)object).addElement(object2);
                ((Vector)object).addElement(string3);
                vector.addElement(object);
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    public static void useRemoteDatabase(ASConnection aSConnection, String string, String string2) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null && string.length() > 0, "NULL or empty server parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "NULL or empty database parameter");
        try {
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            aSConnection.executeCommand(rLSQLResourceBundle.getString("USE_REMOTE_DATABASE", string, string2));
        }
        catch (SQLException sQLException) {
            Support.addLogEntry(1, aSConnection, RLMetaData.class, sQLException.getMessage(), ASEMessageText.toString(sQLException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector parseLocator(ASConnection aSConnection, String string, String string2) throws SQLException {
        Debug.wassert(aSConnection != null, "NULL ASConnection parameter");
        Debug.wassert(string != null && string.length() > 0, "NULL or empty distribution database parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "NULL or empty locator parameter");
        Vector<Integer> vector = new Vector<Integer>(1);
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("PARSE_LOCATOR", string, string2));
            aSResultSet.getNextRow();
            aSResultSet.getNextRow();
            int n = aSResultSet.getColumnInt(3);
            vector.addElement(new Integer(n));
            aSResultSet.getNextRow();
            int n2 = aSResultSet.getColumnInt(3);
            vector.addElement(new Integer(n2));
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    public static String FormatDatatype(ASConnection aSConnection, String string, int n, int n2, int n3) {
        Debug.wassert(aSConnection != null, "Null connection");
        Debug.wassert(aSConnection.getDomainDatatypes() != null, "Null Domain Datatype object");
        Debug.wassert(string != null && string.length() > 0, "Null or empty datatype parameter");
        String string2 = aSConnection.getDomainDatatypes().hasScaleType(string) ? string.trim() + "(" + String.valueOf(n2) + ", " + String.valueOf(n3) + ")" : (aSConnection.getDomainDatatypes().hasWidthType(string) ? string.trim() + "(" + String.valueOf(n) + ")" : (string.equals("float") ? string.trim() + "(" + String.valueOf(n2) + ")" : string.trim()));
        return string2;
    }

    protected static boolean findString(Vector vector, String string) {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Object e = enumeration.nextElement();
            if (!(e instanceof String) || !string.equals((String)e)) continue;
            bl = true;
        }
        return bl;
    }
}

