/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.table;

import com.sybase.asa.ASAButton;
import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAMultiList;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ColumnBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.SupplyEncryptionKeyPasswordDialog;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.KeySO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.table.ComboBoxEditorPanel;
import com.sybase.aseplugin.table.JTETable;
import com.sybase.aseplugin.table.JTETextField;
import com.sybase.aseplugin.table.JTableEditorUI_13;
import com.sybase.aseplugin.table.TableEditBOPage;
import com.sybase.aseplugin.table.TableEditor;
import com.sybase.aseplugin.table.TableEditorSpinBox;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCProfile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class JTableEditor
extends JScrollPane
implements ActionListener {
    public static int KEY_COLUMN = 0;
    public static int NAME_COLUMN = 1;
    public static int DATATYPE_COLUMN = 2;
    public static int SIZE_COLUMN = 3;
    public static int SCALE_COLUMN = 4;
    public static int ALLOWNULLS_COLUMN = 5;
    public static int COMPUTED_COLUMN = -1;
    public static int ENCRYPTION_COLUMN = -1;
    public static int ENCRYPTION_KEY_COLUMN = -1;
    boolean enableComputedColumn = false;
    boolean enableEncryptionKey = false;
    static int NUM_COLS;
    private String defaultColWidths = "27;200;150;65;65;80;100;80;150";
    private static final String PROF_TE_WIDTHS = "TableEditorWidths";
    static Font defaultFont;
    private JTETable _table = new JTETable();
    private JTableEditorUI_13 _ui = null;
    private JTableEditorModel _tableModel = null;
    private ComboBoxModel _comboModel = null;
    ComboBoxEditor _comboBoxEditor = null;
    private ASAComboBox _editorComboBox = null;
    private SpinBoxEditor _spinBoxEditor = null;
    private TextFieldEditor _cellEditor = null;
    private TreeSet _datatypesHSV = null;
    private boolean _javaClassesLoaded = false;
    private boolean _addDataToComboModel = true;
    private TableEditor _tableEditor = null;
    private SCProfile _profile = null;
    private ActionListener _javaAction = null;
    private JPopupMenu _popupMenu = null;
    public JMenuItem _deleteMenu = null;
    private JMenuItem _propertiesMenu = null;
    private MouseAdapter _tablePopUpMenuMouseListener = null;
    private TableEditBOPage _tableEditBOPage = null;
    private ComboBoxModel _ekComboModel = null;
    EKComboBoxEditor _ekComboBoxEditor = null;

    static void setupComponent(JComponent jComponent, int n, int n2) {
        if (n == 0 && n2 == 0) {
            jComponent.setPreferredSize(null);
        } else {
            jComponent.setPreferredSize(new Dimension(n, n2));
        }
    }

    JTableEditor(TableEditor tableEditor, TableEditBOPage tableEditBOPage) {
        this._tableEditBOPage = tableEditBOPage;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JTableEditor.this.saveColumnWidths();
            }
        };
        this._table.getTableHeader().addMouseListener(mouseAdapter);
        this._table.getSelectionModel().addListSelectionListener(new TableSelectionListener(){

            @Override
            public void deSelectAction() {
                JTableEditor.this._tableEditBOPage.fireTableSelectionChanged(false);
            }

            @Override
            public void selectAction() {
                JTableEditor.this._tableEditBOPage.fireTableSelectionChanged(true);
            }
        });
        this.getViewport().setView(this._table);
        this._tableEditor = tableEditor;
        this._profile = ProfileHelper.getProfile();
        this._tablePopUpMenuMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (JTableEditor.this._table.isEditing()) {
                    int n = JTableEditor.this._table.getEditingRow();
                    if (n >= 0) {
                        JTableEditor.this._table.setRowSelectionInterval(n, n);
                    }
                    JTableEditor.this._table.getCellEditor().stopCellEditing();
                }
                if (mouseEvent.getClickCount() == 2) {
                    JTableEditor.this._tableEditor.getTableEditBOPage().showAdvColProp();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                if (SwingUtilities.isRightMouseButton(mouseEvent) && JTableEditor.this._table.getSelectedRowCount() == 1 && (n = JTableEditor.this._table.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                    JTableEditor.this._popupMenu.show(JTableEditor.this._table, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (JTableEditor.this._table.isEditing()) {
                        int n = JTableEditor.this._table.getEditingRow();
                        if (n >= 0) {
                            JTableEditor.this._table.setRowSelectionInterval(n, n);
                        }
                        JTableEditor.this._table.getCellEditor().stopCellEditing();
                    } else {
                        int n = JTableEditor.this._table.rowAtPoint(mouseEvent.getPoint());
                        if (n >= 0) {
                            JTableEditor.this._table.setRowSelectionInterval(n, n);
                        }
                    }
                }
            }
        };
        this._comboBoxEditor = new ComboBoxEditor();
        this._spinBoxEditor = new SpinBoxEditor();
        this._cellEditor = new TextFieldEditor(this._tablePopUpMenuMouseListener);
        this._ekComboBoxEditor = new EKComboBoxEditor();
        NUM_COLS = 6;
        int n = ALLOWNULLS_COLUMN;
        TableSO tableSO = this._tableEditBOPage.getTableSO();
        if (tableSO.isComputedColApplicable()) {
            COMPUTED_COLUMN = ++n;
            ++NUM_COLS;
            this.enableComputedColumn = true;
        } else {
            COMPUTED_COLUMN = -1;
        }
        if (tableSO.getConnection().isEncryptedKeyEnabled()) {
            NUM_COLS += 2;
            ++n;
            ENCRYPTION_COLUMN = n++;
            ENCRYPTION_KEY_COLUMN = n;
            this.enableEncryptionKey = true;
        } else {
            ENCRYPTION_COLUMN = -1;
            ENCRYPTION_KEY_COLUMN = -1;
        }
        this.setupTable();
    }

    void releaseResources() {
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        for (int i = 0; i < NUM_COLS; ++i) {
            ((JTableEditorRenderer)tableColumnModel.getColumn(i).getCellRenderer()).releaseResources();
            tableColumnModel.getColumn(i).setCellRenderer(null);
        }
        tableColumnModel.getColumn(DATATYPE_COLUMN).setCellEditor(null);
        tableColumnModel.getColumn(SIZE_COLUMN).setCellEditor(null);
        tableColumnModel.getColumn(SCALE_COLUMN).setCellEditor(null);
        tableColumnModel.getColumn(NAME_COLUMN).setCellEditor(null);
        this._table.releaseResources();
        this._table = null;
        this._ui = null;
        this._tableModel = null;
        this._comboModel = null;
        this._comboBoxEditor.releaseResources();
        this._comboBoxEditor = null;
        this._ekComboBoxEditor.releaseResources();
        this._ekComboBoxEditor = null;
        this._editorComboBox = null;
        this._spinBoxEditor.releaseResources();
        this._spinBoxEditor = null;
        this._cellEditor = null;
        this._datatypesHSV = null;
        this._tableEditor = null;
        this._profile = null;
        this._javaAction = null;
        this._popupMenu = null;
        this._deleteMenu = null;
        this._propertiesMenu = null;
        this._tablePopUpMenuMouseListener = null;
    }

    private void setupTable() {
        this._tableModel = new JTableEditorModel();
        this._table.setModel(this._tableModel);
        this._table.setCellSelectionEnabled(true);
        this._table.setSelectionMode(0);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.setAutoResizeMode(0);
        this._table.setRowHeight(20);
        Object[] objectArray = new String[NUM_COLS];
        objectArray[JTableEditor.KEY_COLUMN] = ASEUtils.getString("TBLH_KEY");
        objectArray[JTableEditor.NAME_COLUMN] = ASEUtils.getString("TBLH_COLUMN_NAME");
        objectArray[JTableEditor.DATATYPE_COLUMN] = ASEUtils.getString("TBLH_DATA_TYPE");
        objectArray[JTableEditor.SIZE_COLUMN] = ASEUtils.getString("TBLH_SIZE");
        objectArray[JTableEditor.SCALE_COLUMN] = ASEUtils.getString("TBLH_SCALE");
        objectArray[JTableEditor.ALLOWNULLS_COLUMN] = ASEUtils.getString("TBLH_ALLOW_NULLS");
        if (this.enableComputedColumn) {
            objectArray[JTableEditor.COMPUTED_COLUMN] = ASEUtils.getString("TBLH_COMPUTED_COL");
        }
        if (this.enableEncryptionKey) {
            objectArray[JTableEditor.ENCRYPTION_COLUMN] = ASEUtils.getString("TBLH_ENCRYPTED");
            objectArray[JTableEditor.ENCRYPTION_KEY_COLUMN] = ASEUtils.getString("TBLH_KEY");
        }
        this._tableModel.setColumnIdentifiers(objectArray);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        this.setColumnWidths();
        this.initPopupMenus();
        this._table.addMouseListener(this._tablePopUpMenuMouseListener);
        TableCellRenderer tableCellRenderer = this._table.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setHorizontalAlignment(2);
        }
        for (int i = 0; i < NUM_COLS; ++i) {
            tableColumnModel.getColumn(i).setCellRenderer(new JTableEditorRenderer());
        }
        this._editorComboBox = this._comboBoxEditor.getComboBox();
        tableColumnModel.getColumn(DATATYPE_COLUMN).setCellEditor(this._comboBoxEditor);
        tableColumnModel.getColumn(SIZE_COLUMN).setCellEditor(this._spinBoxEditor);
        tableColumnModel.getColumn(SCALE_COLUMN).setCellEditor(this._spinBoxEditor);
        tableColumnModel.getColumn(NAME_COLUMN).setCellEditor(this._cellEditor);
        if (this.enableEncryptionKey) {
            tableColumnModel.getColumn(ENCRYPTION_KEY_COLUMN).setCellEditor(this._ekComboBoxEditor);
        }
        this._ui = new JTableEditorUI_13();
        this._table.setUI(this._ui);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._deleteMenu) {
            this._tableEditor.getTableEditBOPage().delColumnInGrid();
        }
        if (actionEvent.getSource() == this._propertiesMenu) {
            this._tableEditor.getTableEditBOPage().showAdvColProp();
        }
    }

    public void initPopupMenus() {
        this._popupMenu = new JPopupMenu();
        this._deleteMenu = new JMenuItem(ASEUtils.getString("CONTEXT_MENU_DELETE_TEXT"), ASEMenuItem.DELETE_ICON);
        this._deleteMenu.addActionListener(this);
        this._popupMenu.add(this._deleteMenu);
        this._popupMenu.addSeparator();
        this._propertiesMenu = new JMenuItem(ASEUtils.getString("CONTEXT_MENU_PROPERTIES_TEXT"), ASEMenuItem.PROPERTIES_ICON);
        this._propertiesMenu.addActionListener(this);
        this._popupMenu.add(this._propertiesMenu);
    }

    void setDatatypeVector(TreeSet treeSet) {
        this._datatypesHSV = treeSet;
    }

    void setDataTypeComboModel(ComboBoxModel comboBoxModel) {
        this._comboModel = comboBoxModel;
    }

    void setEncryptionKeyComboModel(ComboBoxModel comboBoxModel) {
        this._ekComboModel = comboBoxModel;
    }

    void setJavaClassesLoaded(boolean bl) {
        this._javaClassesLoaded = bl;
    }

    boolean isJavaLoaded() {
        return this._javaClassesLoaded;
    }

    boolean isJavaInstalled() {
        return this._tableEditor._tableSO.getConnection().isJavaEnabled();
    }

    void setAddToDropDown(boolean bl) {
        this._addDataToComboModel = bl;
    }

    public void setValueAt(Object object, int n, int n2) {
        this._table.setValueAt(object, n, n2);
    }

    Object getValueAt(int n, int n2) {
        return this._table.getValueAt(n, n2);
    }

    void addRow(Object[] objectArray) {
        this._tableModel.addRow(objectArray);
    }

    void clear() {
        this._tableModel.setNumRows(0);
    }

    JTETable getTable() {
        return this._table;
    }

    public boolean editCellAt(int n, int n2) {
        return this._table.editCellAt(n, n2);
    }

    ASAComboBox getEditorComboBox() {
        return this._editorComboBox;
    }

    void removeRow(int n) {
        if (this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        ((DefaultTableModel)this._table.getModel()).removeRow(n);
    }

    void setCellTraversable(int n, int n2, boolean bl) {
        this._table.setCellTraversable(n, n2, bl);
    }

    void setJavaButtonAction(ActionListener actionListener) {
        this._javaAction = actionListener;
    }

    void saveColumnWidths() {
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        int[] nArray = new int[NUM_COLS];
        for (int i = 0; i < NUM_COLS; ++i) {
            nArray[i] = tableColumnModel.getColumn(i).getWidth();
        }
        this._profile.writeString(PROF_TE_WIDTHS, Support.intsToTokenString(nArray));
    }

    private void setColumnWidths() {
        int[] nArray = Support.untokenizeInts(this._profile.readString(PROF_TE_WIDTHS), NUM_COLS);
        if (nArray == null || nArray.length != NUM_COLS) {
            nArray = Support.untokenizeInts(this.defaultColWidths, NUM_COLS);
        }
        if (nArray != null) {
            TableColumnModel tableColumnModel = this._table.getColumnModel();
            for (int i = 0; i < NUM_COLS; ++i) {
                tableColumnModel.getColumn(i).setPreferredWidth(nArray[i]);
            }
        }
    }

    void restoreDefaults() {
        this._profile.deleteString(PROF_TE_WIDTHS);
    }

    void loadJava() {
        this._tableEditor.loadJava();
    }

    static {
        defaultFont = new Font("dialog", 0, 12);
    }

    private class JTableEditorModel
    extends DefaultTableModel {
        JTableEditorModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != KEY_COLUMN && n2 != ALLOWNULLS_COLUMN && JTableEditor.this._table.isCellTraversable(n, n2) && n2 != COMPUTED_COLUMN && n2 != ENCRYPTION_COLUMN;
        }
    }

    private class DataTypeChooserDialog
    extends JDialog
    implements ActionListener,
    ListSelectionListener,
    ItemListener {
        JPanel buttonPanel;
        ASAMultiList list;
        JLabel dataLabel;
        JScrollPane scrollPane;
        JCheckBox baseCheckBox;
        JCheckBox userCheckBox;
        JCheckBox javaCheckBox;
        JButton okButton;
        JButton cancelButton;
        JButton javaButton;
        String typeString;
        private ComboBoxEditor _parent;

        public DataTypeChooserDialog(JFrame jFrame, ComboBoxEditor comboBoxEditor) {
            super((Frame)jFrame, true);
            this.buttonPanel = new JPanel();
            this.list = new ASAMultiList((Object[])new String[]{ASEUtils.getString("DISP_DATA_TYPE_TEXT"), ASEUtils.getString("DISP_TYPE_TEXT")});
            this.dataLabel = new JLabel();
            this.scrollPane = new JScrollPane();
            this.baseCheckBox = new JCheckBox();
            this.userCheckBox = new JCheckBox();
            this.javaCheckBox = new JCheckBox();
            this.okButton = new JButton();
            this.cancelButton = new JButton();
            this.javaButton = new JButton();
            this.setTitle(ASEUtils.getString("DISP_DATATYPE_CHOOSER"));
            this.setSize(510, 300);
            this._parent = comboBoxEditor;
            this.setLocationRelativeTo(jFrame);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            this.list.setDefaultRenderer(new JLabel().getClass(), (TableCellRenderer)new MyCellRenderer());
            this.initText();
            this.initComponents();
            this.installMouseActions();
            this.installKeyboardActions();
            this.installWindowActions();
        }

        private void initComponents() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Dimension dimension = new Dimension(85, 26);
            this.okButton.setMinimumSize(dimension);
            this.okButton.setMaximumSize(dimension);
            this.cancelButton.setMinimumSize(dimension);
            this.cancelButton.setMaximumSize(dimension);
            this.buttonPanel.setMinimumSize(new Dimension(184, 120));
            Container container = this.getContentPane();
            container.setLayout(gridBagLayout);
            this.okButton.setActionCommand("OK");
            JTableEditor.setupComponent(this.okButton, 85, 26);
            this.makeConstraints(gridBagConstraints, 1, 3, 1, 1, 1, 0, new Insets(0, 0, 10, 0), 0);
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
            this.okButton.setEnabled(false);
            this.cancelButton.setActionCommand("Cancel");
            JTableEditor.setupComponent(this.cancelButton, 85, 26);
            this.makeConstraints(gridBagConstraints, 2, 3, 1, 1, 1, 0, new Insets(0, 0, 10, 0), 0);
            gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
            JTableEditor.setupComponent(this.javaButton, 0, 0);
            this.makeConstraints(gridBagConstraints, 1, 2, 2, 1, 1, 50, new Insets(0, 0, 0, 0), 0);
            gridBagConstraints.anchor = 11;
            gridBagLayout.setConstraints(this.javaButton, gridBagConstraints);
            this.javaButton.addActionListener(this);
            this.javaButton.setActionCommand("5");
            JTableEditor.setupComponent(this.dataLabel, 0, 0);
            this.makeConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 0, new Insets(5, 10, 0, 0), 2);
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.dataLabel, gridBagConstraints);
            JTableEditor.setupComponent(this.baseCheckBox, 0, 0);
            this.baseCheckBox.setBounds(15, 25, 140, 20);
            this.baseCheckBox.setSelected(true);
            this.baseCheckBox.addItemListener(this);
            JTableEditor.setupComponent(this.userCheckBox, 0, 0);
            this.userCheckBox.setBounds(15, 55, 140, 20);
            this.userCheckBox.setSelected(true);
            this.userCheckBox.addItemListener(this);
            JTableEditor.setupComponent(this.javaCheckBox, 0, 0);
            this.javaCheckBox.setBounds(15, 85, 140, 20);
            this.javaCheckBox.setSelected(false);
            this.javaCheckBox.addItemListener(this);
            this.makeConstraints(gridBagConstraints, 0, 1, 1, 3, 100, 100, new Insets(5, 10, 10, 10), 1);
            gridBagLayout.setConstraints(this.scrollPane, gridBagConstraints);
            JTableEditor.setupComponent(this.buttonPanel, 184, 120);
            this.makeConstraints(gridBagConstraints, 1, 0, 2, 2, 0, 50, new Insets(10, 10, 10, 10), 0);
            gridBagConstraints.anchor = 15;
            gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
            this.buttonPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.typeString, 1, 2, defaultFont, SystemColor.windowText));
            this.buttonPanel.setLayout(null);
            this.list.addListSelectionListener((ListSelectionListener)this);
            this.list.setSelectionMode(0);
            this.scrollPane.getViewport().setView((Component)this.list);
            this.buttonPanel.add(this.baseCheckBox);
            this.buttonPanel.add(this.userCheckBox);
            this.buttonPanel.add(this.javaCheckBox);
            container.add(this.javaButton);
            container.add(this.buttonPanel);
            container.add(this.scrollPane);
            container.add(this.okButton);
            container.add(this.cancelButton);
            this.setupList();
        }

        private void makeConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, Insets insets, int n7) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            gridBagConstraints.weightx = n5;
            gridBagConstraints.weighty = n6;
            if (insets != null) {
                gridBagConstraints.insets = insets;
            }
            gridBagConstraints.fill = n7;
        }

        private void initText() {
            this.okButton.setText(ASEUtils.getString("BTTN_OK"));
            this.cancelButton.setText(ASEUtils.getString("BTTN_CANCEL"));
            this.javaButton.setText(ASEUtils.getString("DISP_LOAD_JAVA_CLASSES"));
            this.javaButton.setToolTipText(ASEUtils.getString("DISP_INC_JAVA_DTYPES"));
            this.baseCheckBox.setText(ASEUtils.getString("DISP_BASE_DATA_TYPES"));
            this.userCheckBox.setText(ASEUtils.getString("DISP_USER_DATA_TYPES"));
            this.javaCheckBox.setText(ASEUtils.getString("DISP_JAVA_CLASSES"));
            this.dataLabel.setText(ASEUtils.getString("DISP_CHOOSE_DATA_TYPE"));
            this.typeString = ASEUtils.getString("DISP_DISPLAY_TYPES");
            this.javaButton.setVisible(false);
        }

        private void installMouseActions() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = DataTypeChooserDialog.this.list.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0) {
                        return;
                    }
                    if (mouseEvent.getClickCount() == 2) {
                        DataTypeChooserDialog.this._parent.setDataTypeValue(DataTypeChooserDialog.this.getValue());
                        DataTypeChooserDialog.this.dispose();
                        mouseEvent.consume();
                    }
                }
            };
            this.list.addMouseListener((MouseListener)mouseAdapter);
        }

        private void installKeyboardActions() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataTypeChooserDialog.this.dispose();
                }
            };
            this.list.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
        }

        private void installWindowActions() {
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                }

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    DataTypeChooserDialog.this.list.requestFocus();
                    int n = DataTypeChooserDialog.this.list.findRow(DataTypeChooserDialog.this._parent.getDataTypeValue(), 0);
                    if (n > 0) {
                        DataTypeChooserDialog.this.list.setRowSelectionInterval(n, n);
                    }
                    DataTypeChooserDialog.this.validateButtons();
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                }
            };
            this.addWindowListener(windowAdapter);
        }

        private void setupList() {
            if (JTableEditor.this._datatypesHSV == null) {
                return;
            }
            this.list.clear();
            boolean bl = this.baseCheckBox.isSelected();
            boolean bl2 = this.userCheckBox.isSelected();
            boolean bl3 = this.javaCheckBox.isSelected();
            for (String[] stringArray : JTableEditor.this._datatypesHSV) {
                if (stringArray[1].equals("0") && bl) {
                    this.list.addRow(new Object[]{stringArray[0], ASEUtils.getString("MSG_BASE")});
                    continue;
                }
                if (stringArray[1].equals("1") && bl2) {
                    this.list.addRow(new Object[]{stringArray[0], ASEUtils.getString("MSG_USER_TYPE")});
                    continue;
                }
                if (!stringArray[1].equals("2") || !bl3) continue;
                this.list.addRow(new Object[]{stringArray[0], ASEUtils.getString("MSG_JAVA")});
            }
            int n = this.list.findRow(this._parent.getDataTypeValue(), 0);
            if (n > 0) {
                this.list.setRowSelectionInterval(n, n);
            }
            this.okButton.setEnabled(false);
        }

        private void validateButtons() {
            if (!JTableEditor.this._javaClassesLoaded) {
                this.javaCheckBox.setEnabled(false);
                this.javaCheckBox.setSelected(false);
                this.javaButton.setEnabled(true);
            } else {
                this.javaCheckBox.setEnabled(true);
                this.javaButton.setEnabled(false);
            }
        }

        public String getValue() {
            return this.list.getStringAt(this.list.getSelectedRow(), 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.okButton) {
                this._parent.setDataTypeValue(this.getValue());
                this.dispose();
            } else if (actionEvent.getSource() == this.cancelButton) {
                this.dispose();
            } else {
                Support.getViewerSupport().startWait();
                JTableEditor.this._javaAction.actionPerformed(actionEvent);
                this.javaCheckBox.setSelected(true);
                this.validateButtons();
                Support.getViewerSupport().endWait();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.setupList();
            this.list.requestFocus();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.list.getSelectedRow() != -1) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    class EKComboBoxEditor
    extends FocusCellEditor {
        private String KeyValue;
        private ComboBoxEditorPanel editorPanel;
        private ASAComboBox comboBox;
        private ActionListener _action;
        private ASAButton button;
        private ColumnSO _colSO;
        private int _row;

        EKComboBoxEditor() {
            super(new ASAComboBox());
            this.editorPanel = null;
            this.comboBox = null;
            this._action = null;
            this.button = null;
            this._colSO = null;
            this._row = 0;
            this.editorComponent = null;
            this.editorPanel = new ComboBoxEditorPanel(JTableEditor.this._tablePopUpMenuMouseListener);
            this.comboBox = this.editorPanel.getComboBox();
            this.setClickCountToStart(0);
            this.button = this.editorPanel.getButton();
            this.installActions();
            this.button.setToolTipText(ASEUtils.getString("HINT_SUPPLY_PASSWORD_FOR_COLUMN"));
        }

        void releaseResources() {
            this.uninstallActions();
            this.editorPanel.releaseResources();
            this.editorPanel = null;
            this.comboBox = null;
            this._action = null;
            this.button = null;
            this._colSO = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (JTableEditor.this._ekComboModel != null && this.comboBox.getModel() != JTableEditor.this._ekComboModel) {
                this.comboBox.setModel(JTableEditor.this._ekComboModel);
            }
            this.comboBox.getEditor().setItem(object);
            this.comboBox.setSelectedItem(object);
            this.setKeyValue((String)object);
            this._colSO = JTableEditor.this._tableEditBOPage.getColumnSOFromGridRow(n);
            this._row = n;
            if (this._colSO.getTmpEncrypt() && KeySO.getPhase(this._colSO.getConnection()) == 2.0f) {
                if (this._colSO.getColumnState() == 2) {
                    this.button.setEnabled(true);
                    return this.editorPanel;
                }
            }
            this.button.setEnabled(false);
            return this.editorPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.KeyValue;
        }

        public void setKeyValue(String string) {
            this.KeyValue = string;
        }

        public String getKeyValue() {
            return this.KeyValue;
        }

        private void stopTableEditing() {
            this.KeyValue = (String)this.editorPanel.getComboBox().getEditor().getItem();
            try {
                JTableEditor.this.getTable().getCellEditor().stopCellEditing();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public boolean stopCellEditing() {
            this.KeyValue = (String)this.editorPanel.getComboBox().getEditor().getItem();
            this.fireEditingStopped();
            if (this._colSO != null) {
                this._colSO.setTmpKey(this.KeyValue);
                JTableEditor.this._tableEditBOPage.toggleEC(this._row);
            }
            return true;
        }

        ASAComboBox getComboBox() {
            return this.comboBox;
        }

        private void installActions() {
            this._action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EKComboBoxEditor.this.supplyPasswordDialog();
                }
            };
            this.button.addActionListener(this._action);
        }

        private void uninstallActions() {
            this.button.removeActionListener(this._action);
        }

        public void supplyPasswordDialog() {
            this.stopTableEditing();
            ColumnBO columnBO = ContainerViewBO.getColumnBO(JTableEditor.this._tableEditBOPage.getTableBO(), this._colSO.getName());
            ArrayList<ColumnBO> arrayList = new ArrayList<ColumnBO>();
            arrayList.add(columnBO);
            SupplyEncryptionKeyPasswordDialog supplyEncryptionKeyPasswordDialog = new SupplyEncryptionKeyPasswordDialog(Support.createDialogSupport(JTableEditor.this._tableEditor.getJFrame()), arrayList);
            supplyEncryptionKeyPasswordDialog.start(columnBO);
        }
    }

    class ComboBoxEditor
    extends FocusCellEditor {
        private String dataTypeValue;
        private ComboBoxEditorPanel editorPanel;
        private ASAComboBox comboBox;
        private ActionListener _action;
        private ASAButton button;
        private ColumnSO _colSO;

        ComboBoxEditor() {
            super(new ASAComboBox());
            this.editorPanel = null;
            this.comboBox = null;
            this._action = null;
            this.button = null;
            this._colSO = null;
            this.editorComponent = null;
            this.editorPanel = new ComboBoxEditorPanel(JTableEditor.this._tablePopUpMenuMouseListener);
            this.comboBox = this.editorPanel.getComboBox();
            this.setDataTypeValue(TableEditBOPage._defaultDatatype);
            this.setClickCountToStart(0);
            this.button = this.editorPanel.getButton();
            this.installActions();
            this.button.setToolTipText(ASEUtils.getString("TABLE_EDITOR_TTIP_SHOW_ALL_DATA_TYPES"));
        }

        void releaseResources() {
            this.uninstallActions();
            this.editorPanel.releaseResources();
            this.editorPanel = null;
            this.comboBox = null;
            this._action = null;
            this.button = null;
            this._colSO = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (JTableEditor.this._comboModel != null && this.comboBox.getModel() != JTableEditor.this._comboModel) {
                this.comboBox.setModel(JTableEditor.this._comboModel);
            }
            this.comboBox.getEditor().setItem(object);
            this.comboBox.setSelectedItem(object);
            this.setDataTypeValue((String)object);
            this._colSO = JTableEditor.this._tableEditBOPage.getColumnSOFromGridRow(n);
            return this.editorPanel;
        }

        private void stopTableEditing() {
            try {
                JTableEditor.this.getTable().getCellEditor().stopCellEditing();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.dataTypeValue;
        }

        public void setDataTypeValue(String string) {
            this.dataTypeValue = string;
        }

        public String getDataTypeValue() {
            return this.dataTypeValue;
        }

        @Override
        public boolean stopCellEditing() {
            this.dataTypeValue = (String)this.editorPanel.getComboBox().getEditor().getItem();
            this.fireEditingStopped();
            if (this._colSO != null) {
                this._colSO.setTmpDataType(this.dataTypeValue);
            }
            return true;
        }

        ASAComboBox getComboBox() {
            return this.comboBox;
        }

        private void installActions() {
            this._action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ComboBoxEditor.this.showDialog();
                }
            };
            this.button.addActionListener(this._action);
        }

        private void uninstallActions() {
            this.button.removeActionListener(this._action);
        }

        void addToComboModel(String string) {
            if (JTableEditor.this._addDataToComboModel) {
                if (!(JTableEditor.this._comboModel instanceof DefaultComboBoxModel)) {
                    return;
                }
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)JTableEditor.this._comboModel;
                for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                    int n = string.toLowerCase().compareTo(((String)defaultComboBoxModel.getElementAt(i)).toLowerCase());
                    if (n == 0) {
                        return;
                    }
                    if (n >= 0) continue;
                    defaultComboBoxModel.insertElementAt(string, i);
                    return;
                }
                defaultComboBoxModel.addElement(this.dataTypeValue);
            }
        }

        public void showDialog() {
            this.stopTableEditing();
            DataTypeChooserDialog dataTypeChooserDialog = new DataTypeChooserDialog(JTableEditor.this._tableEditor.getJFrame(), this);
            dataTypeChooserDialog.show();
            if (this.dataTypeValue != null) {
                JTableEditor.this.setValueAt(this.dataTypeValue, JTableEditor.this.getTable().getSelectedRow(), DATATYPE_COLUMN);
            }
        }
    }

    private class SpinBoxEditor
    extends FocusCellEditor {
        TableEditorSpinBox spinBox;
        Integer cellData;
        JTextField textField;
        private ColumnSO _colSO;
        private int _column;

        SpinBoxEditor() {
            super(new JTextField());
            this.spinBox = new TableEditorSpinBox(JTableEditor.this._table);
            this.cellData = null;
            this.textField = null;
            this._colSO = null;
            this._column = 0;
            this.editorComponent = null;
            this.textField = this.spinBox.getTextField();
            this.spinBox.setCommitOnFocusLost(true);
            this.textField.addMouseListener(JTableEditor.this._tablePopUpMenuMouseListener);
            this.spinBox.setBorder(null);
            JTableEditor.setupComponent(this.spinBox, 0, 0);
        }

        void releaseResources() {
            this.spinBox.releaseResources();
            this.spinBox = null;
            this.textField = null;
            this._colSO = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cellData = (Integer)object;
            if (object == null) {
                this.cellData = new Integer(0);
            }
            this.spinBox.setValue(this.cellData);
            this._colSO = JTableEditor.this._tableEditBOPage.getColumnSOFromGridRow(n);
            this._column = n2;
            return this.spinBox;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.cellData = new Integer(this.spinBox.getValue());
            this.fireEditingStopped();
            if (this._colSO != null) {
                if (this._column == SIZE_COLUMN) {
                    this._colSO.setTmpLength(this.cellData.toString());
                    this._colSO.setTmpPrecision(this.cellData.toString());
                } else if (this._column == SCALE_COLUMN) {
                    this._colSO.setTmpScale(this.cellData.toString());
                }
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellData;
        }
    }

    class TextFieldEditor
    extends FocusCellEditor {
        private ColumnSO _colSO;

        TextFieldEditor(MouseAdapter mouseAdapter) {
            super(new JTETextField(mouseAdapter));
            this._colSO = null;
            this.setClickCountToStart(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JTETextField)this.getComponent()).setText((String)object);
            this._colSO = JTableEditor.this._tableEditBOPage.getColumnSOFromGridRow(n);
            return this.getComponent();
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            if (this._colSO != null) {
                this._colSO.setTmpColumnName(((JTextField)this.getComponent()).getText());
            }
            return true;
        }

        void releaseResources() {
            this._colSO = null;
        }
    }

    class FocusCellEditor
    extends DefaultCellEditor {
        Component c;

        public FocusCellEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.addFocusListener(jCheckBox);
        }

        public FocusCellEditor(ASAComboBox aSAComboBox) {
            super((JComboBox<?>)aSAComboBox);
            this.addFocusListener((Component)aSAComboBox);
        }

        public FocusCellEditor(JTextField jTextField) {
            super(jTextField);
        }

        private void addFocusListener(Component component) {
            super.getComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    FocusCellEditor.this.lostFocus();
                }
            });
        }

        public void lostFocus() {
            this.stopCellEditing();
        }
    }

    private static class GreyCrossIcon
    implements Icon {
        private GreyCrossIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(SystemColor.GRAY);
            graphics.drawLine(n + 9, n2 + 4, n + 5, n2 + 8);
            graphics.drawLine(n + 5, n2 + 4, n + 9, n2 + 8);
            graphics.drawLine(n + 9, n2 + 3, n + 5, n2 + 7);
            graphics.drawLine(n + 5, n2 + 3, n + 9, n2 + 7);
        }

        @Override
        public int getIconHeight() {
            return 13;
        }

        @Override
        public int getIconWidth() {
            return 13;
        }
    }

    private static class GreyCheckBoxIcon
    implements Icon {
        private GreyCheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(SystemColor.GRAY);
            graphics.fillRect(n + 3, n2 + 5, 2, 5);
            graphics.drawLine(n + 9, n2 + 3, n + 5, n2 + 7);
            graphics.drawLine(n + 9, n2 + 4, n + 5, n2 + 8);
        }

        @Override
        public int getIconHeight() {
            return 13;
        }

        @Override
        public int getIconWidth() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon {
        private CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(SystemColor.windowText);
            graphics.fillRect(n + 3, n2 + 5, 2, 5);
            graphics.drawLine(n + 9, n2 + 3, n + 5, n2 + 7);
            graphics.drawLine(n + 9, n2 + 4, n + 5, n2 + 8);
        }

        @Override
        public int getIconHeight() {
            return 13;
        }

        @Override
        public int getIconWidth() {
            return 13;
        }
    }

    private class JTableEditorRenderer
    extends JLabel
    implements TableCellRenderer {
        private CheckBoxIcon _checkBoxIcon = new CheckBoxIcon();
        private GreyCheckBoxIcon _greyCheckBoxIcon = new GreyCheckBoxIcon();
        private GreyCrossIcon _greyCrossIcon = new GreyCrossIcon();

        private JTableEditorRenderer() {
        }

        void releaseResources() {
            this._checkBoxIcon = null;
            this._greyCheckBoxIcon = null;
            this._greyCrossIcon = null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(0);
            if (!JTableEditor.this._table.isCellTraversable(n, n2)) {
                this.setOpaque(true);
                this.setEnabled(false);
            } else {
                this.setOpaque(false);
                this.setEnabled(true);
            }
            ColumnSO columnSO = JTableEditor.this._tableEditBOPage.getColumnSOFromGridRow(n);
            if (object == null) {
                this.setText("");
            } else if (object instanceof Boolean) {
                if (n2 == ALLOWNULLS_COLUMN) {
                    if (((Boolean)object).equals(Boolean.TRUE)) {
                        this.setIcon(this._checkBoxIcon);
                        columnSO.setTmpAllowNulls(ColumnSO.YES);
                    } else {
                        this.setIcon(null);
                        columnSO.setTmpAllowNulls(ColumnSO.NO);
                    }
                } else if (n2 == COMPUTED_COLUMN) {
                    if (columnSO.getColumnState() == 2) {
                        if (((Boolean)object).equals(Boolean.TRUE)) {
                            this.setIcon(this._greyCheckBoxIcon);
                        } else {
                            this.setIcon(this._greyCrossIcon);
                        }
                    } else if (((Boolean)object).equals(Boolean.TRUE)) {
                        this.setIcon(this._checkBoxIcon);
                        columnSO.setTmpComputedKey(true);
                    } else {
                        this.setIcon(null);
                        columnSO.setTmpComputedKey(false);
                    }
                } else if (n2 == ENCRYPTION_COLUMN) {
                    if (((Boolean)object).equals(Boolean.TRUE)) {
                        this.setIcon(this._checkBoxIcon);
                        columnSO.setTmpEncrypt(true);
                    } else {
                        this.setIcon(null);
                        columnSO.setTmpEncrypt(false);
                    }
                }
            } else if (object instanceof String) {
                this.setHorizontalAlignment(2);
                this.setText((String)object);
                if (n2 == NAME_COLUMN) {
                    columnSO.setTmpColumnName((String)object);
                } else if (n2 == DATATYPE_COLUMN) {
                    columnSO.setTmpDataType((String)object);
                } else if (n2 == ENCRYPTION_KEY_COLUMN) {
                    columnSO.setTmpKey((String)object);
                }
            } else if (object instanceof Icon) {
                this.setIcon((Icon)object);
                if ((Icon)object == TableEditBOPage._pKeyImage) {
                    columnSO.setTmpPrimaryKey(true);
                } else {
                    columnSO.setTmpPrimaryKey(false);
                }
            } else {
                this.setHorizontalAlignment(2);
                this.setText(object.toString());
                if (n2 == SIZE_COLUMN) {
                    columnSO.setTmpLength(object.toString());
                    columnSO.setTmpPrecision(object.toString());
                } else if (n2 == SCALE_COLUMN) {
                    columnSO.setTmpScale(object.toString());
                }
            }
            this.setBorder(bl2 ? BorderFactory.createLineBorder(Color.yellow, 1) : new EmptyBorder(1, 1, 1, 1));
            return this;
        }
    }
}

