/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.table;

import com.sybase.aseplugin.table.JTETable;
import com.sybase.aseplugin.table.JTETableListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class JTableEditorUI_13
extends TableUI
implements JTETableListener {
    protected JTETable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;

    JTableEditorUI_13() {
    }

    @Override
    public void anchorCellChanged(int n, int n2) {
        this.table.scrollRectToVisible(this.table.getCellRect(n, n2, false));
        this.table.changeSelection(n, n2, false, false);
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new JTableEditorUI_13();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.table = (JTETable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        Font font = this.table.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.table.getFontMetrics(font);
            int n = fontMetrics.getHeight() + 8;
            this.table.setRowHeight(n);
        }
    }

    protected void installDefaults() {
        Container container;
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((container = this.table.getParent()) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addJTETableListener(this);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.table, actionMap);
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("Table.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("JTableEditor.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("JTableEditor.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectNextColumnCell", new NavigationalAction(1, 0, true, false, true));
        return actionMapUIResource;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removeJTETableListener(this);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    private Dimension createTableSize(long l) {
        long l2;
        int n = 0;
        int n2 = this.table.getRowCount();
        if (n2 > 0 && this.table.getColumnCount() > 0) {
            Rectangle rectangle = this.table.getCellRect(n2 - 1, 0, true);
            n = rectangle.y + rectangle.height;
        }
        if ((l2 = Math.abs(l)) > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, n);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.columnAtPoint(point);
        int n4 = this.table.columnAtPoint(point2);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n, n2, n3, n4);
        this.paintCells(graphics, n, n2, n3, n4);
    }

    private void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.table.getCellRect(n, n3, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
        if (this.table.getShowHorizontalLines()) {
            int n7 = rectangle2.x + rectangle2.width;
            n6 = rectangle.y;
            for (n5 = n; n5 <= n2; ++n5) {
                graphics.drawLine(0, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle2.y + rectangle2.height;
            n5 = rectangle.x;
            for (int i = n3; i <= n4; ++i) {
                graphics.drawLine((n5 += tableColumnModel.getColumn(i).getWidth()) - 1, 0, n5 - 1, n6 - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        for (int i = n; i <= n2; ++i) {
            Rectangle rectangle = this.table.getCellRect(i, n3, false);
            for (int j = n3; j <= n4; ++j) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                int n6 = tableColumn2.getWidth();
                rectangle.width = n6 - n5;
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle, i, j);
                }
                rectangle.x += n6;
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
            graphics.drawLine(n8, n7, n8, n4);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, n5, n6);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
            rectangle5.x += n3;
            n4 = rectangle5.x;
            int n9 = rectangle5.y;
            int n10 = n4 + rectangle5.width - 1;
            int n11 = n9 + rectangle5.height - 1;
            graphics.drawLine(n4, n11, n10, n11);
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = JTableEditorUI_13.this.table.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(JTableEditorUI_13.this.table, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            try {
                if (this.dispatchComponent == null) {
                    return false;
                }
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(JTableEditorUI_13.this.table, mouseEvent, this.dispatchComponent);
                this.dispatchComponent.dispatchEvent(mouseEvent2);
                return true;
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                return false;
            }
        }

        private void setValueIsAdjusting(boolean bl) {
            JTableEditorUI_13.this.table.getSelectionModel().setValueIsAdjusting(bl);
            JTableEditorUI_13.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return !SwingUtilities.isLeftMouseButton(mouseEvent) || !JTableEditorUI_13.this.table.isEnabled();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = JTableEditorUI_13.this.table.rowAtPoint(point);
            int n2 = JTableEditorUI_13.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            if (JTableEditorUI_13.this.table.editCellAt(n, n2, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else {
                JTableEditorUI_13.this.table.requestFocus();
            }
            TableCellEditor tableCellEditor = JTableEditorUI_13.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                this.setValueIsAdjusting(true);
                JTableEditorUI_13.this.table.changeSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            TableCellEditor tableCellEditor = JTableEditorUI_13.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                int n = JTableEditorUI_13.this.table.rowAtPoint(point);
                int n2 = JTableEditorUI_13.this.table.columnAtPoint(point);
                if (n2 == -1 || n == -1) {
                    return;
                }
                JTableEditorUI_13.this.table.changeSelection(n, n2, false, true);
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        private void repaintAnchorCell() {
            int n = JTableEditorUI_13.this.table.getRowCount();
            int n2 = JTableEditorUI_13.this.table.getColumnCount();
            int n3 = JTableEditorUI_13.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n4 = JTableEditorUI_13.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
                return;
            }
            Rectangle rectangle = JTableEditorUI_13.this.table.getCellRect(n3, n4, false);
            JTableEditorUI_13.this.table.repaint(rectangle);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }
    }

    public class KeyHandler
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
            InputMap inputMap = JTableEditorUI_13.this.table.getInputMap(0);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            inputMap = JTableEditorUI_13.this.table.getInputMap(1);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (keyEvent.getKeyChar() == '\r') {
                return;
            }
            int n = JTableEditorUI_13.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n2 = JTableEditorUI_13.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n != -1 && n2 != -1 && !JTableEditorUI_13.this.table.isEditing() && !JTableEditorUI_13.this.table.editCellAt(n, n2)) {
                return;
            }
            Component component = JTableEditorUI_13.this.table.getEditorComponent();
            if (JTableEditorUI_13.this.table.isEditing() && component != null && component instanceof JComponent) {
                Object object;
                JComponent jComponent = (JComponent)component;
                inputMap = jComponent.getInputMap(0);
                Object object2 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                if (object == null) {
                    inputMap = jComponent.getInputMap(1);
                    Object object3 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                }
                if (object != null) {
                    Action action;
                    ActionMap actionMap = jComponent.getActionMap();
                    Action action2 = action = actionMap != null ? actionMap.get(object) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers())) {
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        protected NavigationalAction(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.dx = n;
            this.dy = n2;
            this.toggle = bl;
            this.extend = bl2;
            this.inSelection = bl3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTETable jTETable = (JTETable)actionEvent.getSource();
            ListSelectionModel listSelectionModel = jTETable.getSelectionModel();
            this.anchorRow = listSelectionModel.getAnchorSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTETable.getColumnModel().getSelectionModel();
            this.anchorColumn = listSelectionModel2.getAnchorSelectionIndex();
            int n = this.anchorRow;
            int n2 = this.anchorColumn;
            this.anchorRow += this.dy;
            this.anchorColumn += this.dx;
            while (!jTETable.isCellTraversable(this.anchorRow, this.anchorColumn)) {
                this.anchorRow += this.dy;
                this.anchorColumn += this.dx;
                this.wrapSelection(jTETable);
            }
            if (this.inTableRange(jTETable, this.anchorRow, this.anchorColumn)) {
                jTETable.scrollRectToVisible(jTETable.getCellRect(this.anchorRow, this.anchorColumn, false));
                jTETable.changeSelection(this.anchorRow, this.anchorColumn, false, false);
                jTETable.editCellAt(this.anchorRow, this.anchorColumn);
            }
        }

        private boolean inRange(int n, int n2, int n3) {
            return n >= n2 && n < n3;
        }

        private boolean inTableRange(JTETable jTETable, int n, int n2) {
            return this.inRange(n, 0, jTETable.getRowCount()) && this.inRange(n2, 0, jTETable.getColumnCount());
        }

        private void wrapSelection(JTETable jTETable) {
            int n = jTETable.getRowCount();
            int n2 = jTETable.getColumnCount();
            if (this.anchorRow >= n) {
                if (this.dx == 0 && this.dy == 1) {
                    this.anchorRow = 0;
                    this.anchorColumn = 1;
                } else {
                    this.anchorRow = 0;
                    ++this.anchorColumn;
                }
                if (this.anchorColumn >= n2) {
                    this.anchorColumn = 0;
                }
            } else if (this.anchorRow < 0) {
                this.anchorRow = n - 1;
                --this.anchorColumn;
                if (this.anchorColumn < 0) {
                    this.anchorColumn = n2 - 1;
                }
            } else if (this.anchorColumn >= n2) {
                this.anchorColumn = 0;
                ++this.anchorRow;
                if (this.anchorRow >= n) {
                    this.anchorRow = 0;
                }
            } else if (this.anchorColumn < 0) {
                this.anchorColumn = n2 - 1;
                --this.anchorRow;
                if (this.anchorRow < 0) {
                    this.anchorRow = n - 1;
                }
            }
        }
    }
}

