/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.table;

import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAPanel;
import com.sybase.asa.ASAToolBarButton;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ColumnBO;
import com.sybase.aseplugin.bo.ColumnsCtrBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.JavaClassBO;
import com.sybase.aseplugin.bo.JavaClassesCtrBO;
import com.sybase.aseplugin.bo.JavaObjectsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.TablesCtrBO;
import com.sybase.aseplugin.bo.UniqueConstraintBO;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.UsersCtrBO;
import com.sybase.aseplugin.bo.prop.ColumnProperties;
import com.sybase.aseplugin.go.ASETextField;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.ColumnsCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DomainDatatypes;
import com.sybase.aseplugin.so.JavaClassSO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.UserSO;
import com.sybase.aseplugin.table.DatatypeCompare;
import com.sybase.aseplugin.table.JTETextField;
import com.sybase.aseplugin.table.JTableEditor;
import com.sybase.aseplugin.table.TableEditGOPage;
import com.sybase.aseplugin.table.TableEditor;
import com.sybase.central.SCContainer2;
import com.sybase.resultSetTable.ResultSetTableImages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class TableEditBOPage
implements DocumentListener,
KeyListener {
    protected static int _numColumnsCreated = 0;
    protected static final String PROF_TE_POSITION = "TableEditorPosition";
    protected static final String PROF_TE_OPTIONS = "TableEditorOptions";
    static final int MAXIMUM_KEYS = 31;
    protected static String _defaultDatatype = "int";
    TreeSet _datatypeHSV;
    JTableEditor _jcolumnDataGrid;
    protected TableEditor _tableEditor;
    protected ASAPanel _panel = null;
    protected int _tableEditType;
    protected TableSO _tableSO;
    protected ColumnsCtrBO _columnsCtrBO;
    protected DatabaseSO _databaseSO;
    protected Vector _vColumnSOs;
    protected Vector _vWorkingColumnSOs = new Vector();
    protected DefaultComboBoxModel _dataTypeComboModel;
    protected String _typedText = "";
    protected boolean _javaClassesLoaded = false;
    protected boolean _showWarnings;
    protected boolean _datatypeCompletion;
    protected boolean _addToDropDown;
    protected boolean _defaultAllowNulls = true;
    protected ActionListener _buttonAction = null;
    protected MouseAdapter _mouse = null;
    protected KeyStroke[] _keyStrokes = null;
    protected MouseAdapter _mouseToggle = null;
    protected DatabaseBO _databaseBO;
    protected ASAComboBox _tableCreatorCombo;
    protected ASAComboBox _editorCombo;
    protected JTextField _editorTextField;
    protected ASETextField _tableNameTextField;
    protected ASAPanel _toolbar;
    protected ASAToolBarButton[] _toolbarButtons;
    protected static final int ADD_BTN = 0;
    protected static final int DELETE_BTN = 1;
    protected static final int COL_PROP_BTN = 2;
    protected static final int SAVE_BTN = 3;
    protected static final int SAVE_CLOSE_BTN = 4;
    protected static final int TOTAL_BTNS = 5;
    public static final Icon _pKeyImage = ColumnBO.ICON_PRIMARY_KEY_COLUMN;
    public static final Icon _uKeyImage = UniqueConstraintBO.ICON_UNIQUE_KEY;
    public static final Icon _columnImage = ColumnBO.ICON_COLUMN;
    public static final Icon _newColumnImage = ColumnBO.NEW_COLUMN_ICON;
    protected int _totalGridRows = 0;
    protected int _totalRows = 0;
    protected int _totalGridRowKeys = 0;
    protected DefaultComboBoxModel _encryptionKeyComboModel;
    protected static String _defaultEncryptionKey = ASEUtils.getString("DISP_DEFAULT_TEXT");
    boolean _enableComputedColumn = false;
    boolean _enableEncryptionKey = false;
    protected DomainDatatypes _baseTypes;
    boolean _modified = false;
    boolean _keyPressed = false;
    protected TableBO _tableBO;
    String totErrorMsg = "";
    protected static Insets BTN_MARGIN = new Insets(2, 2, 2, 2);

    TableEditBOPage(TableEditGOPage tableEditGOPage, int n, TableEditor tableEditor, TableBO tableBO) throws SQLException {
        this._tableEditor = tableEditor;
        this._tableBO = tableBO;
        this._tableEditType = n;
        this._tableSO = this._tableEditor.getTableSO();
        this._databaseSO = this._tableSO.getDatabaseSO();
        TablesCtrBO tablesCtrBO = (TablesCtrBO)this._tableBO.getParent();
        this._databaseBO = (DatabaseBO)tablesCtrBO.getParent();
        this.onInitDialog();
        if (n != 1) {
            this._tableBO.getItems(0);
            this._columnsCtrBO = this._tableBO.getColumnsCtrBO();
        } else {
            this._columnsCtrBO = new ColumnsCtrBO(this._tableBO);
        }
        this._jcolumnDataGrid = new JTableEditor(this._tableEditor, this);
        this._tableNameTextField = tableEditGOPage.nameTextField;
        this._tableCreatorCombo = tableEditGOPage.ownerComboBox;
        this._toolbar = tableEditGOPage.toolbarPanel;
        this._panel = tableEditGOPage.tablePanel;
        this._tableNameTextField.setNextFocusableComponent((Component)this._tableCreatorCombo);
        this._tableCreatorCombo.setNextFocusableComponent((Component)this._jcolumnDataGrid.getTable());
        this._editorCombo = this._jcolumnDataGrid.getEditorComboBox();
        this._editorTextField = (JTextField)this._editorCombo.getEditor().getEditorComponent();
        this._editorTextField.getDocument().addDocumentListener(this);
        this._editorTextField.addKeyListener(this);
        ((JTETextField)((DefaultCellEditor)this._jcolumnDataGrid.getTable().getColumnModel().getColumn(JTableEditor.NAME_COLUMN).getCellEditor()).getComponent()).getDocument().addDocumentListener(this);
        this._mouse = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TableEditBOPage.this._typedText = "";
            }
        };
        this._jcolumnDataGrid.getTable().addMouseListener(this._mouse);
        this.initToolbar();
        this._panel.add((Component)this._jcolumnDataGrid);
        this._defaultAllowNulls = this._databaseSO.getOption("DB_OP_ALLOW_NULLS");
        this._baseTypes = this._databaseSO.getConnection().getDomainDatatypes();
        this.loadDatatypeChoice();
        if (this._enableEncryptionKey) {
            this.loadEncryptonKeys();
        }
        this.initializeGOPage();
        this.installToggleActions();
        this.refreshTableData();
        this._jcolumnDataGrid.setJavaButtonAction(this._buttonAction);
    }

    void releaseResources() {
        ((JTETextField)((DefaultCellEditor)this._jcolumnDataGrid.getTable().getColumnModel().getColumn(JTableEditor.NAME_COLUMN).getCellEditor()).getComponent()).getDocument().removeDocumentListener(this);
        this._editorTextField.getDocument().removeDocumentListener(this);
        this._editorTextField.removeKeyListener(this);
        this._jcolumnDataGrid.getTable().removeMouseListener(this._mouse);
        this._panel.remove((Component)this._jcolumnDataGrid);
        this.uninstallToggleActions();
        for (int i = 0; i < this._toolbarButtons.length; ++i) {
            this._toolbarButtons[i].unregisterKeyboardAction(this._keyStrokes[i]);
            this._keyStrokes[i] = null;
            this._toolbarButtons[i].removeActionListener(this._buttonAction);
            this._toolbarButtons[i] = null;
        }
        this._keyStrokes = null;
        this._mouseToggle = null;
        this._panel = null;
        this._mouse = null;
        this._tableEditor = null;
        this._tableSO = null;
        this._databaseSO = null;
        this._vColumnSOs.clear();
        this._vColumnSOs = null;
        this._vWorkingColumnSOs.clear();
        this._vWorkingColumnSOs = null;
        this._dataTypeComboModel = null;
        this._datatypeHSV.clear();
        this._datatypeHSV = null;
        this._buttonAction = null;
        this._tableCreatorCombo = null;
        this._editorCombo = null;
        this._editorTextField = null;
        this._tableNameTextField = null;
        this._jcolumnDataGrid.releaseResources();
        this._jcolumnDataGrid = null;
        this._toolbar = null;
        this._toolbarButtons = null;
        this._baseTypes = null;
        this._tableBO = null;
    }

    void onInitDialog() {
        this._tableEditor.getJFrame().setResizable(true);
        Support.setWindowPosition(PROF_TE_POSITION, this._tableEditor.getJFrame());
        if (this._tableSO.getConnection().isEncryptedKeyEnabled()) {
            this._enableEncryptionKey = true;
        }
        if (this._tableSO.isComputedColApplicable()) {
            this._enableComputedColumn = true;
        }
    }

    void onSetActive() {
        this.addColumnToGrid(this._tableEditType == 3);
        if (this._tableEditType == 3) {
            this._tableEditType = 2;
        } else {
            this.selectNameField();
        }
    }

    public TableBO getTableBO() {
        return this._tableBO;
    }

    void selectNameField() {
        this._tableNameTextField.selectAll();
        this._tableNameTextField.requestFocus();
    }

    void editNewColumn() {
        this._jcolumnDataGrid.editCellAt(this._totalGridRows - 1, JTableEditor.NAME_COLUMN);
    }

    private void initializeGOPage() {
        try {
            UsersCtrBO usersCtrBO = this._databaseBO.getUsersCtrBO();
            Vector vector = usersCtrBO.getItems(0);
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (e == null) continue;
                UserBO userBO = (UserBO)e;
                UserSO userSO = (UserSO)userBO.getSO();
                this._tableCreatorCombo.addItem((Object)userSO.getName());
            }
            if (this._tableEditType == 1) {
                this._tableCreatorCombo.setSelectedItem(this._databaseSO.getCurrentUser());
            } else {
                this._tableCreatorCombo.setSelectedItem(this._tableSO.getOwner());
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), exception.getMessage(), exception);
            this.returnFocus();
        }
    }

    private void loadEncryptonKeys() throws SQLException {
        ColumnSO columnSO = new ColumnSO(this._tableSO.getConnection(), new String(), this._tableSO);
        columnSO.setupEKList();
        Collection collection = columnSO.getEncryptionKeysList();
        this._encryptionKeyComboModel = new DefaultComboBoxModel();
        this._encryptionKeyComboModel.addElement(_defaultEncryptionKey);
        for (String string : collection) {
            this._encryptionKeyComboModel.addElement(string);
        }
        this._jcolumnDataGrid.setEncryptionKeyComboModel(this._encryptionKeyComboModel);
    }

    private void loadDatatypeChoice() throws SQLException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this._datatypeHSV = new TreeSet(new DatatypeCompare());
        this._dataTypeComboModel = new DefaultComboBoxModel();
        ColumnSO columnSO = new ColumnSO(this._tableSO.getConnection(), new String(), this._tableSO);
        vector = columnSO.getSysUserDataType(this._databaseBO);
        this._datatypeHSV.addAll(vector);
        vector2 = columnSO.getJavaDataType(this._databaseBO);
        this._datatypeHSV.addAll(vector2);
        this._javaClassesLoaded = true;
        this._jcolumnDataGrid.setJavaClassesLoaded(true);
        Iterator iterator = this._datatypeHSV.iterator();
        while (iterator.hasNext()) {
            this._dataTypeComboModel.addElement(((String[])iterator.next())[0]);
        }
        this._jcolumnDataGrid.setDatatypeVector(this._datatypeHSV);
        this._jcolumnDataGrid.setDataTypeComboModel(this._dataTypeComboModel);
    }

    void loadJavaClasses() {
        try {
            String string = this._databaseSO.getConnection().getVersion();
            if (string.compareTo("12.0") >= 0) {
                JavaObjectsCtrBO javaObjectsCtrBO = this._databaseBO.getJavaObjectsCtrBO();
                if (javaObjectsCtrBO == null) {
                    return;
                }
                javaObjectsCtrBO.getItems(0);
                JavaClassesCtrBO javaClassesCtrBO = javaObjectsCtrBO.getJavaClassesCtrBO();
                Vector vector = javaClassesCtrBO.getItems(0);
                if (vector != null && vector.size() > 0) {
                    for (int i = 0; i < vector.size(); ++i) {
                        JavaClassBO javaClassBO = (JavaClassBO)vector.elementAt(i);
                        JavaClassSO javaClassSO = (JavaClassSO)javaClassBO.getSO();
                        String string2 = javaClassSO.getName();
                        this._datatypeHSV.add(new String[]{string2, "2"});
                    }
                }
            }
            this._javaClassesLoaded = true;
            this._jcolumnDataGrid.setJavaClassesLoaded(true);
        }
        catch (Exception exception) {
            Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), exception.getMessage(), exception);
            this.returnFocus();
        }
    }

    protected void refreshTableData() throws SQLException {
        if (this._tableEditType == 1) {
            String string = ASEUtils.getString("TABLE_EDITOR_SUBT_TABLE_NAME");
            this._tableNameTextField.setText(string);
            this._tableCreatorCombo.setEnabled(true);
            this._tableEditor.getJFrame().setTitle(this._tableEditor.getTitle(false, true));
            this._tableCreatorCombo.setSelectedItem(this._databaseSO.getCurrentUser());
        } else {
            this._tableNameTextField.setText(this._tableSO.getName());
            this._tableCreatorCombo.setEnabled(false);
            this._tableEditor.getJFrame().setTitle(this._tableEditor.getTitle(false, false));
            this._tableCreatorCombo.setSelectedItem(this._tableSO.getOwner());
        }
        this.refreshColumnSOs();
        this.refreshGrid();
    }

    private void refreshColumnSOs() throws SQLException {
        if (this._vColumnSOs != null) {
            ColumnsCtrSO columnsCtrSO = (ColumnsCtrSO)this._columnsCtrBO.getCtrSO();
            this._vColumnSOs = (Vector)columnsCtrSO.open(1, null);
            Vector<ColumnSO> vector = new Vector<ColumnSO>();
            block0: for (int i = 0; i < this._vWorkingColumnSOs.size(); ++i) {
                ColumnSO columnSO = (ColumnSO)this._vWorkingColumnSOs.elementAt(i);
                if (columnSO.getColumnState() == 1 || columnSO.getColumnState() == 5 || columnSO.getColumnState() == 4) {
                    if (columnSO.getTmpColumnName().trim().length() > 0) {
                        vector.addElement(columnSO);
                    }
                    if (columnSO.getColumnState() != 5) continue;
                    columnSO.setColumnState(2);
                    continue;
                }
                if (columnSO.getColumnState() == 3) continue;
                for (int j = 0; j < this._vColumnSOs.size(); ++j) {
                    ColumnSO columnSO2 = (ColumnSO)this._vColumnSOs.elementAt(j);
                    if (!columnSO2.getTmpColumnName().equals(columnSO.getTmpColumnName().trim())) continue;
                    vector.addElement(columnSO2);
                    continue block0;
                }
            }
            this._vWorkingColumnSOs.clear();
            this._vWorkingColumnSOs = vector;
        } else {
            ColumnsCtrSO columnsCtrSO = (ColumnsCtrSO)this._columnsCtrBO.getCtrSO();
            this._vWorkingColumnSOs = this._vColumnSOs = (Vector)columnsCtrSO.open(1, null);
        }
    }

    private void refreshGrid() {
        this._jcolumnDataGrid.clear();
        if (!this._vWorkingColumnSOs.isEmpty()) {
            int n;
            this._totalGridRows = n = this._vWorkingColumnSOs.size();
            this._totalRows = n;
            this._totalGridRowKeys = 0;
            for (int i = 0; i < n; ++i) {
                this._jcolumnDataGrid.addRow(new Object[0]);
                ColumnSO columnSO = (ColumnSO)this._vWorkingColumnSOs.elementAt(i);
                try {
                    if (columnSO.getTmpPrimaryKey()) {
                        this._jcolumnDataGrid.setValueAt(_pKeyImage, i, JTableEditor.KEY_COLUMN);
                        ++this._totalGridRowKeys;
                    } else if (columnSO.getColumnState() == 2 || columnSO.getColumnState() == 4) {
                        this._jcolumnDataGrid.setValueAt(_columnImage, i, JTableEditor.KEY_COLUMN);
                    } else {
                        this._jcolumnDataGrid.setValueAt(_newColumnImage, i, JTableEditor.KEY_COLUMN);
                    }
                    this._jcolumnDataGrid.setValueAt(columnSO.getTmpColumnName(), i, JTableEditor.NAME_COLUMN);
                    String string = columnSO.getTmpDataType();
                    this._jcolumnDataGrid.setValueAt(string, i, JTableEditor.DATATYPE_COLUMN);
                    String string2 = "1";
                    String string3 = "0";
                    if (this._baseTypes.hasWidthType(string)) {
                        string2 = columnSO.getTmpLength();
                        if (string2 == null || string2.equals("")) {
                            string2 = "1";
                        }
                    } else if (this._baseTypes.hasScaleType(string)) {
                        string2 = columnSO.getTmpPrecision();
                        if (string2 == null || string2.equals("")) {
                            string2 = "1";
                        }
                        if ((string3 = columnSO.getTmpScale()) == null || string3.equals("")) {
                            string3 = "0";
                        }
                    }
                    Integer n2 = new Integer(string2);
                    Integer n3 = new Integer(string3);
                    this.setupDatatypeInputs(string, n2, n3, i);
                    if (columnSO.getTmpAllowNulls().equals(ColumnSO.YES)) {
                        this._jcolumnDataGrid.setValueAt(new Boolean(true), i, JTableEditor.ALLOWNULLS_COLUMN);
                    } else {
                        this._jcolumnDataGrid.setValueAt(new Boolean(false), i, JTableEditor.ALLOWNULLS_COLUMN);
                    }
                    this.setupComputedCols(columnSO.isComputedColumn() || columnSO.getTmpComputedKey(), columnSO.getColumnState(), i);
                    this.setupEncryptionKey(!this._baseTypes.cannotEncrypt(string), columnSO.getTmpEncrypt(), columnSO.getTmpKey(), i);
                    continue;
                }
                catch (Exception exception) {
                    Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), exception.getMessage(), exception);
                    this.returnFocus();
                }
            }
        }
    }

    public void setupComputedCols(boolean bl, int n, int n2) {
        if (this._enableComputedColumn && n2 >= 0) {
            if (bl) {
                this._jcolumnDataGrid.setValueAt(new Boolean(bl), n2, JTableEditor.COMPUTED_COLUMN);
                this._jcolumnDataGrid.setValueAt(new Boolean(false), n2, JTableEditor.ALLOWNULLS_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.ALLOWNULLS_COLUMN, false);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.DATATYPE_COLUMN, false);
                this._panel.repaint();
            } else {
                this._jcolumnDataGrid.setValueAt(new Boolean(bl), n2, JTableEditor.COMPUTED_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.ALLOWNULLS_COLUMN, true);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.DATATYPE_COLUMN, true);
                this._panel.repaint();
            }
        }
    }

    public void setupEncryptionKey(boolean bl, int n) {
        if (this._enableEncryptionKey) {
            ColumnSO columnSO = (ColumnSO)this._vWorkingColumnSOs.elementAt(n);
            if (bl && !columnSO.isComputedColumn()) {
                this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_COLUMN, true);
                this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_KEY_COLUMN, true);
            } else {
                this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_COLUMN, false);
                this._jcolumnDataGrid.setValueAt(new Boolean(false), n, JTableEditor.ENCRYPTION_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_KEY_COLUMN, false);
                this._jcolumnDataGrid.setValueAt(null, n, JTableEditor.ENCRYPTION_KEY_COLUMN);
            }
        }
    }

    public void setupEncryptionKey(boolean bl, boolean bl2, String string, int n) {
        if (this._enableEncryptionKey) {
            ColumnSO columnSO = (ColumnSO)this._vWorkingColumnSOs.elementAt(n);
            if (bl && !columnSO.isComputedColumn()) {
                if (bl2) {
                    this._jcolumnDataGrid.setValueAt(new Boolean(bl2), n, JTableEditor.ENCRYPTION_COLUMN);
                    this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_KEY_COLUMN, bl2);
                    this._jcolumnDataGrid.setValueAt(string, n, JTableEditor.ENCRYPTION_KEY_COLUMN);
                } else {
                    this._jcolumnDataGrid.setValueAt(new Boolean(bl2), n, JTableEditor.ENCRYPTION_COLUMN);
                    this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_KEY_COLUMN, bl2);
                    this._jcolumnDataGrid.setValueAt(null, n, JTableEditor.ENCRYPTION_KEY_COLUMN);
                }
            } else {
                this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_COLUMN, false);
                this._jcolumnDataGrid.setValueAt(new Boolean(false), n, JTableEditor.ENCRYPTION_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n, JTableEditor.ENCRYPTION_KEY_COLUMN, false);
                this._jcolumnDataGrid.setValueAt(null, n, JTableEditor.ENCRYPTION_KEY_COLUMN);
            }
        }
    }

    public void setupDatatypeInputs(String string, Integer n, Object object, int n2) {
        if (this._baseTypes.isDomainDatatype(string)) {
            if (this._baseTypes.hasWidthType(string)) {
                this._jcolumnDataGrid.setValueAt(n, n2, JTableEditor.SIZE_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.SIZE_COLUMN, true);
            } else {
                this._jcolumnDataGrid.setValueAt(null, n2, JTableEditor.SIZE_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.SIZE_COLUMN, false);
            }
            if (this._baseTypes.hasScaleType(string)) {
                this._jcolumnDataGrid.setValueAt(n, n2, JTableEditor.SIZE_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.SIZE_COLUMN, true);
                this._jcolumnDataGrid.setValueAt(object, n2, JTableEditor.SCALE_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.SCALE_COLUMN, true);
            } else {
                this._jcolumnDataGrid.setValueAt(null, n2, JTableEditor.SCALE_COLUMN);
                this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.SCALE_COLUMN, false);
            }
        } else {
            this._jcolumnDataGrid.setValueAt(null, n2, JTableEditor.SIZE_COLUMN);
            this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.SIZE_COLUMN, false);
            this._jcolumnDataGrid.setValueAt(null, n2, JTableEditor.SCALE_COLUMN);
            this._jcolumnDataGrid.setCellTraversable(n2, JTableEditor.SCALE_COLUMN, false);
        }
        if (this._enableEncryptionKey) {
            if (this._baseTypes.cannotEncrypt(string)) {
                this.setupEncryptionKey(false, n2);
            } else {
                this.setupEncryptionKey(true, n2);
            }
        }
    }

    void addColumnToGrid(boolean bl) {
        this._jcolumnDataGrid.addRow(new Object[0]);
        String string = new String();
        ColumnSO columnSO = new ColumnSO(this._tableSO.getConnection(), string, this._tableSO);
        try {
            this._columnsCtrBO.addColumnSO(columnSO, false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._vWorkingColumnSOs.addElement(columnSO);
        int n = this._jcolumnDataGrid.getTable().getRowCount() - 1;
        ++this._totalGridRows;
        this._jcolumnDataGrid.setValueAt(_newColumnImage, n, JTableEditor.KEY_COLUMN);
        this._jcolumnDataGrid.setValueAt(string, n, JTableEditor.NAME_COLUMN);
        this._jcolumnDataGrid.setValueAt(_defaultDatatype, n, JTableEditor.DATATYPE_COLUMN);
        this.setupDatatypeInputs(_defaultDatatype, new Integer("1"), new Integer("0"), n);
        if (this._tableEditType == 1 && !this._defaultAllowNulls) {
            this._jcolumnDataGrid.setValueAt(new Boolean(false), n, JTableEditor.ALLOWNULLS_COLUMN);
        } else {
            this._jcolumnDataGrid.setValueAt(new Boolean(true), n, JTableEditor.ALLOWNULLS_COLUMN);
        }
        if (this._enableComputedColumn) {
            this._jcolumnDataGrid.setValueAt(new Boolean(false), n, JTableEditor.COMPUTED_COLUMN);
        }
        this.setupEncryptionKey(true, false, _defaultEncryptionKey, n);
        if (bl) {
            this._jcolumnDataGrid.editCellAt(this._totalGridRows - 1, JTableEditor.NAME_COLUMN);
        }
    }

    void delColumnInGrid() {
        Serializable serializable;
        Object object;
        int n;
        if (this._totalGridRows == 1) {
            Support.showError(this._tableSO.getConnection(), this.getClass(), this._tableEditor.getJFrame(), ASEUtils.getString("MSG_DEL_LAST_COLUMN") + " " + this._tableNameTextField.getText());
            return;
        }
        int n2 = -1;
        if (this._totalGridRows > 1) {
            int n3;
            n = this._jcolumnDataGrid.getTable().getSelectedRow();
            int n4 = this._jcolumnDataGrid.getTable().getRowCount();
            n2 = n == -1 || n >= n4 ? n4 - 1 : n;
            if (this.isGridRowNewColumn(n2)) {
                object = this.getColumnSOFromGridRow(n2);
                if (((String)this._jcolumnDataGrid.getValueAt(n2, JTableEditor.NAME_COLUMN)).trim().length() > 0) {
                    serializable = new ASEMessageText(ASEUtils.getString("CONFIRM_DELETE_ROW_FROM_TABLE_EDITOR"), ((ColumnSO)object).getTmpColumnName());
                    n3 = Support.showQuestionYesNo(this._tableEditor.getJFrame(), ((ASEMessageText)serializable).toString());
                    if (n3 == 0) {
                        this._vWorkingColumnSOs.removeElement(object);
                        try {
                            this._columnsCtrBO.removeColumnSO((ColumnSO)object, false);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this._jcolumnDataGrid.removeRow(n2);
                        --this._totalGridRows;
                    }
                } else {
                    this._vWorkingColumnSOs.removeElement(object);
                    try {
                        this._columnsCtrBO.removeColumnSO((ColumnSO)object, false);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this._jcolumnDataGrid.removeRow(n2);
                    --this._totalGridRows;
                }
            } else {
                object = this.getColumnSOFromGridRow(n2);
                serializable = new ASEMessageText(ASEUtils.getString("CONFIRM_DELETE_ROW_FROM_TABLE_EDITOR"), ((ColumnSO)object).getTmpColumnName());
                n3 = Support.showQuestionYesNo(this._tableEditor.getJFrame(), ((ASEMessageText)serializable).toString());
                if (n3 == 0) {
                    try {
                        this._columnsCtrBO.removeColumnSO((ColumnSO)object, false);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this._jcolumnDataGrid.removeRow(n2);
                    ((ColumnSO)object).setColumnState(5);
                    --this._totalGridRows;
                }
            }
        }
        if (n2 < this._totalGridRows) {
            for (n = n2; n < this._totalGridRows; ++n) {
                String string = (String)this._jcolumnDataGrid.getValueAt(n, JTableEditor.DATATYPE_COLUMN);
                object = (Integer)this._jcolumnDataGrid.getValueAt(n, JTableEditor.SIZE_COLUMN);
                serializable = (Integer)this._jcolumnDataGrid.getValueAt(n, JTableEditor.SCALE_COLUMN);
                this.setupDatatypeInputs(string, (Integer)object, serializable, n);
                if (this._enableComputedColumn) {
                    ColumnSO columnSO = this.getColumnSOFromGridRow(n);
                    this.setupComputedCols(columnSO.isComputedColumn() || columnSO.getTmpComputedKey(), columnSO.getColumnState(), n);
                }
                if (!this._enableEncryptionKey) continue;
                boolean bl = (Boolean)this._jcolumnDataGrid.getValueAt(n, JTableEditor.ENCRYPTION_COLUMN);
                String string2 = (String)this._jcolumnDataGrid.getValueAt(n, JTableEditor.ENCRYPTION_KEY_COLUMN);
                this.setupEncryptionKey(!this._baseTypes.cannotEncrypt(string), bl, string2, n);
            }
        }
        this._toolbarButtons[1].requestFocus();
    }

    private int findWorkingListRowFromGridRow(int n) {
        int n2 = -1;
        for (int i = 0; i < this._vWorkingColumnSOs.size(); ++i) {
            ColumnSO columnSO = (ColumnSO)this._vWorkingColumnSOs.elementAt(i);
            if (columnSO.getColumnState() == 5 || columnSO.getColumnState() == 3 || ++n2 != n) continue;
            return i;
        }
        return 0;
    }

    private boolean isGridRowNewColumn(int n) {
        ColumnSO columnSO = this.getColumnSOFromGridRow(n);
        return columnSO.getColumnState() == 1;
    }

    public ColumnSO getColumnSOFromGridRow(int n) {
        int n2 = this.findWorkingListRowFromGridRow(n);
        return (ColumnSO)this._vWorkingColumnSOs.elementAt(n2);
    }

    public void showTableEditOptions() {
    }

    void showAdvColProp() {
        this.showAdvColProp(null);
    }

    private void showAdvColProp(String string) {
        this.stopEditing();
        int n = this._jcolumnDataGrid.getTable().getSelectedRow();
        if (n < 0) {
            n = 0;
        } else if (n >= this._jcolumnDataGrid.getTable().getRowCount()) {
            n = this._jcolumnDataGrid.getTable().getRowCount() - 1;
        }
        ColumnSO columnSO = this.getColumnSOFromGridRow(n);
        ColumnBO columnBO = new ColumnBO(columnSO, (ASEBaseContainer2)this._columnsCtrBO);
        ColumnProperties columnProperties = new ColumnProperties((ColumnSO)columnBO.getSO(), (SCContainer2)this._columnsCtrBO, false, string);
        this._modified = true;
        columnProperties.setGridAndRow(this._jcolumnDataGrid, n, this._tableNameTextField, this);
        ASEBaseDialog2.showDialog(this._tableEditor.getJFrame(), columnProperties, false);
        String string2 = (String)this._jcolumnDataGrid.getValueAt(n, JTableEditor.DATATYPE_COLUMN);
        Integer n2 = (Integer)this._jcolumnDataGrid.getValueAt(n, JTableEditor.SIZE_COLUMN);
        Integer n3 = (Integer)this._jcolumnDataGrid.getValueAt(n, JTableEditor.SCALE_COLUMN);
        this.setupDatatypeInputs(string2, n2, n3, n);
        this.returnFocus();
    }

    void showAdvTblProp() {
        this.returnFocus();
    }

    private boolean tableNameValid() {
        String string = this._tableNameTextField.getText().trim();
        String string2 = (String)this._tableCreatorCombo.getSelectedItem();
        if (string.equals("")) {
            Support.showError(this._tableSO.getConnection(), this.getClass(), this._tableEditor.getJFrame(), ASEUtils.getString("TABLE_EDITOR_ERRM_TABLE_NAME_EMPTY"));
            this._tableEditor.getJFrame().requestFocus();
            this._tableNameTextField.requestFocus();
            this._tableNameTextField.selectAll();
            return false;
        }
        try {
            TableSO tableSO = new TableSO(this._tableSO.getConnection(), string, this._tableSO.getDatabaseSO());
            tableSO.setOwner(string2);
            boolean bl = Support.verifyObjectName(tableSO, this._tableEditor.getJFrame(), (JTextComponent)((Object)this._tableNameTextField));
            return bl;
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), sQLException.getMessage(), sQLException);
            this.returnFocus();
            return false;
        }
    }

    private boolean validWorkingColumnSO() {
        ColumnSO columnSO = null;
        for (int i = 0; i < this._totalGridRows; ++i) {
            columnSO = this.getColumnSOFromGridRow(i);
            if (columnSO.getColumnState() == 1 && ((String)this._jcolumnDataGrid.getValueAt(i, JTableEditor.NAME_COLUMN)).trim().length() > 0) {
                return true;
            }
            if (columnSO.getColumnState() != 2 && columnSO.getColumnState() != 4) continue;
            return true;
        }
        return false;
    }

    private int updateWorkingSOsFromGrid() {
        int n = this._totalGridRows;
        int n2 = 0;
        try {
            this.stopEditing();
            for (int i = 0; i < n; ++i) {
                int n3;
                ColumnSO columnSO = this.getColumnSOFromGridRow(i);
                if (columnSO.getColumnState() == 1 && ((String)this._jcolumnDataGrid.getValueAt(i, JTableEditor.NAME_COLUMN)).equals("")) {
                    this._vWorkingColumnSOs.removeElement(columnSO);
                    this._jcolumnDataGrid.removeRow(i);
                    --this._totalGridRows;
                    continue;
                }
                if (this._baseTypes.hasScaleType(columnSO.getTmpDataType())) {
                    n3 = new Integer(columnSO.getTmpPrecision());
                    if (n3 == 0) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_ERRM_ZERO_SIZE"), columnSO.getTmpDataType());
                        Support.showError(this._tableSO.getConnection(), this.getClass(), this._tableEditor.getJFrame(), aSEMessageText.toString());
                        return n2 |= 1;
                    }
                    int n4 = new Integer(columnSO.getTmpScale());
                    if (n3 < n4) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_ERRM_SIZE_LESS_THAN_SCALE"), columnSO.getTmpDataType());
                        Support.showError(this._tableSO.getConnection(), this.getClass(), this._tableEditor.getJFrame(), aSEMessageText.toString());
                        return n2 |= 2;
                    }
                }
                if (!this._baseTypes.hasWidthType(columnSO.getTmpDataType()) || (n3 = new Integer(columnSO.getTmpLength()).intValue()) != 0) continue;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_ERRM_ZERO_SIZE"), columnSO.getTmpDataType());
                Support.showError(this._tableSO.getConnection(), this.getClass(), this._tableEditor.getJFrame(), aSEMessageText.toString());
                return n2 |= 1;
            }
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.updateWorkingSOsFromGrid();
            return n2;
        }
        catch (Exception exception) {
            Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), exception.getMessage(), exception);
            this.returnFocus();
            return 4;
        }
    }

    protected boolean createNewTable() {
        String string = null;
        String string2 = null;
        Vector vector = null;
        try {
            string = this._tableSO.getName();
            string2 = this._tableSO.getOwner();
            vector = this._tableSO.getWorkingColumns();
            this._tableSO.setName(this._tableNameTextField.getText().trim());
            this._tableSO.setOwner((String)this._tableCreatorCombo.getSelectedItem());
            this._tableSO.setWorkingColumns(this._vWorkingColumnSOs);
            this._tableSO.create();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), sQLException.getMessage(), sQLException);
            this.returnFocus();
            this._tableSO.setName(string);
            this._tableSO.setOwner(string2);
            this._tableSO.setWorkingColumns(vector);
            return false;
        }
        return true;
    }

    private boolean tableDeletion() {
        String string = ASEUtils.getString("TABLE_EDITOR_QUES_DELETING_ALL_COLUMNS");
        int n = Support.showQuestionYesNo(this._tableEditor.getJFrame(), string);
        if (n == 0) {
            try {
                this._tableSO.remove();
                return true;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), sQLException.getMessage(), sQLException);
                this.returnFocus();
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int saveTable(boolean bl) {
        Object object;
        boolean bl2 = bl;
        boolean bl3 = false;
        this.stopEditing();
        Support.saveWindowPosition(PROF_TE_POSITION, this._tableEditor.getJFrame());
        int n = this.updateWorkingSOsFromGrid();
        if (n != 0) {
            if ((n & 1) != 0) {
                this.returnFocus();
            }
            if ((n & 2) == 0) return 6;
            this.returnFocus();
            return 6;
        }
        if (!this.validWorkingColumnSO()) {
            if (this._tableEditType == 2) {
                bl3 = this.tableDeletion();
                if (bl3) {
                    this._tableEditType = 4;
                } else {
                    object = (Vector)this._columnsCtrBO.getDeletedColumns().clone();
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        ColumnSO columnSO = (ColumnSO)((Vector)object).elementAt(i);
                        columnSO.setColumnState(2);
                    }
                    this._columnsCtrBO.clearDeletedColumnList();
                }
            } else if (this._tableEditType == 1) {
                return 5;
            }
        }
        if (this._tableEditType == 1) {
            if (!this.tableNameValid() || !this.createNewTable()) return 6;
            this._tableEditType = 2;
            bl3 = true;
        } else if (this._tableEditType == 2) {
            try {
                bl3 = this.doAlter();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), sQLException.getMessage(), sQLException);
                this.returnFocus();
                return 6;
            }
        }
        if (bl3) {
            object = (TablesCtrBO)this._tableBO.getParent();
            ((ASEBaseContainer2)object).refresh();
            if (this._tableEditType != 4) {
                TableBO tableBO = (TableBO)((ASEBaseContainer2)object).getItembyFullName(this._tableSO.getFullyQualifiedName());
                if (tableBO != null) {
                    this._tableBO = tableBO;
                }
                this._tableSO = (TableSO)this._tableBO.getSO();
                this._tableBO.open(1);
                this._columnsCtrBO = this._tableBO.getColumnsCtrBO();
            }
        }
        if (this._tableEditType == 4) {
            this.windowExit();
            return 5;
        }
        if (bl2) {
            try {
                this.refreshTableData();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)this._tableEditor.getJFrame(), sQLException.getMessage(), sQLException);
                this.returnFocus();
                return 6;
            }
        }
        this._modified = false;
        this._jcolumnDataGrid.getTable()._modified = false;
        return 5;
    }

    public void windowExit() {
        if (this._tableEditor == null) {
            return;
        }
        this.removeOpenWindow();
        this._tableEditor.getJFrame().dispose();
        TablesCtrBO tablesCtrBO = (TablesCtrBO)this._tableBO.getParent();
        tablesCtrBO.refresh();
        this._tableEditor.releaseResources();
    }

    protected void removeOpenWindow() {
        String string = this._tableEditType == 1 ? this._tableEditor.generateID(false, true) : this._tableEditor.generateID(false, false);
        Support.removeOpenWindow(string);
    }

    private void saveAndClose() {
        int n = this.saveTable(false);
        if (n == 5 && this.totErrorMsg.trim().length() == 0) {
            this.windowExit();
        }
    }

    public boolean closeWindow() {
        boolean bl = true;
        this.stopEditing();
        Support.saveWindowPosition(PROF_TE_POSITION, this._tableEditor.getJFrame());
        String string = this._tableNameTextField.getText().trim();
        String string2 = ASEUtils.getString("TABLE_EDITOR_SUBT_TABLE_NAME");
        if (this._modified || this._jcolumnDataGrid.getTable()._modified || !string.equals(this._tableSO.getName()) && !string.equals(string2)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_QUES_CONFIRM_SAVE"), string);
            int n = Support.showQuestionYesNoCancel(this._tableEditor.getJFrame(), aSEMessageText.toString());
            if (n == 0) {
                int n2 = this.saveTable(false);
                if (n2 == 5) {
                    return true;
                }
                bl = false;
            } else {
                if (n == 1) {
                    this._columnsCtrBO.clearDeletedColumnList();
                    this._columnsCtrBO.clearNewColumnList();
                    return true;
                }
                return false;
            }
        }
        this._columnsCtrBO.clearDeletedColumnList();
        this._columnsCtrBO.clearNewColumnList();
        return true;
    }

    private boolean isGridRowKeyColumn(int n) {
        return (Icon)this._jcolumnDataGrid.getValueAt(n, JTableEditor.KEY_COLUMN) == _pKeyImage;
    }

    private boolean toggleKey(int n) {
        if (this.isGridRowKeyColumn(n)) {
            --this._totalGridRowKeys;
            if (this.isGridRowNewColumn(n)) {
                this._jcolumnDataGrid.setValueAt(_newColumnImage, n, JTableEditor.KEY_COLUMN);
            } else {
                this._jcolumnDataGrid.setValueAt(_columnImage, n, JTableEditor.KEY_COLUMN);
            }
        } else if (this._totalGridRowKeys < 31) {
            Boolean bl = (Boolean)this._jcolumnDataGrid.getValueAt(n, JTableEditor.ALLOWNULLS_COLUMN);
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            if (bl.equals(Boolean.TRUE)) {
                this._jcolumnDataGrid.setValueAt(new Boolean(false), n, JTableEditor.ALLOWNULLS_COLUMN);
            }
            if (this.condToPriKey(n)) {
                this._jcolumnDataGrid.setValueAt(_pKeyImage, n, JTableEditor.KEY_COLUMN);
                ++this._totalGridRowKeys;
            }
        }
        return true;
    }

    private boolean toggleKeyfromEC(int n) {
        if (this.isGridRowKeyColumn(n)) {
            if (!this.condToPriKey(n)) {
                --this._totalGridRowKeys;
                if (this.isGridRowNewColumn(n)) {
                    this._jcolumnDataGrid.setValueAt(_newColumnImage, n, JTableEditor.KEY_COLUMN);
                } else {
                    this._jcolumnDataGrid.setValueAt(_columnImage, n, JTableEditor.KEY_COLUMN);
                }
            }
        } else if (this._totalGridRowKeys < 31 && this.condToPriKey(n)) {
            this._jcolumnDataGrid.setValueAt(_pKeyImage, n, JTableEditor.KEY_COLUMN);
            ++this._totalGridRowKeys;
        }
        return true;
    }

    private boolean condToPriKey(int n) {
        ColumnSO columnSO = this.getColumnSOFromGridRow(n);
        return (!this._enableComputedColumn || columnSO.getColumnState() == 2 && (columnSO.isColumnMaterialized() || columnSO.getTmpMaterialized() || !columnSO.isComputedColumn()) || columnSO.getColumnState() == 1 && (columnSO.getTmpMaterialized() || !columnSO.getTmpComputedKey())) && (!this._enableEncryptionKey || !columnSO.getTmpEncrypt() || columnSO.getTmpEncrypt() && columnSO.getTmpKey().equals(columnSO.defaultKey) || columnSO.getTmpEncrypt() && columnSO.isPlainKey(columnSO.getTmpKey()));
    }

    private void toggleColumns(int n, int n2) {
        if (n >= 0) {
            if (((Boolean)this._jcolumnDataGrid.getValueAt(n, n2)).equals(Boolean.TRUE)) {
                this._jcolumnDataGrid.setValueAt(new Boolean(false), n, n2);
            } else if (n2 == JTableEditor.ALLOWNULLS_COLUMN) {
                this.allowNullsInColumn(n);
            } else {
                this._jcolumnDataGrid.setValueAt(new Boolean(true), n, n2);
            }
        }
    }

    private void allowNullsInColumn(int n) {
        if (this.isGridRowKeyColumn(n)) {
            if (this.toggleKey(n)) {
                this._jcolumnDataGrid.setValueAt(new Boolean(true), n, JTableEditor.ALLOWNULLS_COLUMN);
            }
        } else {
            this._jcolumnDataGrid.setValueAt(new Boolean(true), n, JTableEditor.ALLOWNULLS_COLUMN);
        }
    }

    private void toggleComputedCols(int n) {
        ColumnSO columnSO = this.getColumnSOFromGridRow(n);
        if (this._enableComputedColumn && columnSO.getColumnState() == 2) {
            return;
        }
        if (this._enableComputedColumn && n >= 0) {
            if (((Boolean)this._jcolumnDataGrid.getValueAt(n, JTableEditor.COMPUTED_COLUMN)).equals(Boolean.TRUE)) {
                columnSO.setTmpComputedKey(false);
                this.setupComputedCols(false, columnSO.getColumnState(), n);
            } else {
                columnSO.setTmpComputedKey(true);
                this.setupComputedCols(true, columnSO.getColumnState(), n);
                this.showAdvColProp(ASEUtils.getString("DNAME_COMPUTED_COLUMNS"));
                if (this.isGridRowKeyColumn(n)) {
                    this.toggleKey(n);
                }
                if (this._enableEncryptionKey && ((Boolean)this._jcolumnDataGrid.getValueAt(n, JTableEditor.ENCRYPTION_COLUMN)).equals(Boolean.TRUE)) {
                    this.toggleEncryptedKey(n);
                }
            }
        }
    }

    private void toggleEncryptedKey(int n) {
        if (this._jcolumnDataGrid.getTable().isCellTraversable(n, JTableEditor.ENCRYPTION_COLUMN) && this._enableEncryptionKey && n >= 0) {
            if (((Boolean)this._jcolumnDataGrid.getValueAt(n, JTableEditor.ENCRYPTION_COLUMN)).equals(Boolean.TRUE)) {
                this.setupEncryptionKey(true, false, _defaultEncryptionKey, n);
            } else {
                this.setupEncryptionKey(true, true, _defaultEncryptionKey, n);
                if (this.isGridRowKeyColumn(n)) {
                    this.toggleKeyfromEC(n);
                }
                if (this._enableComputedColumn && ((Boolean)this._jcolumnDataGrid.getValueAt(n, JTableEditor.COMPUTED_COLUMN)).equals(Boolean.TRUE)) {
                    this.toggleComputedCols(n);
                }
            }
        }
    }

    private void stopEditing() {
        try {
            this._jcolumnDataGrid.getTable().getCellEditor().stopCellEditing();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void returnFocus() {
        if (this._tableEditor != null && this._tableEditor.getJFrame() != null) {
            this._tableEditor.getJFrame().requestFocus();
        }
    }

    private void installToggleActions() {
        this._mouseToggle = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                int n = TableEditBOPage.this._jcolumnDataGrid.getTable().rowAtPoint(mouseEvent.getPoint());
                int n2 = TableEditBOPage.this._jcolumnDataGrid.getTable().columnAtPoint(mouseEvent.getPoint());
                if (n2 != JTableEditor.KEY_COLUMN && n2 != JTableEditor.ALLOWNULLS_COLUMN && n2 != JTableEditor.COMPUTED_COLUMN && n2 != JTableEditor.ENCRYPTION_COLUMN) {
                    return;
                }
                if (n2 == JTableEditor.KEY_COLUMN) {
                    TableEditBOPage.this.toggleKey(n);
                } else if (n2 == JTableEditor.ALLOWNULLS_COLUMN) {
                    TableEditBOPage.this.toggleColumns(n, JTableEditor.ALLOWNULLS_COLUMN);
                } else if (n2 == JTableEditor.COMPUTED_COLUMN) {
                    TableEditBOPage.this.toggleComputedCols(n);
                } else if (n2 == JTableEditor.ENCRYPTION_COLUMN) {
                    TableEditBOPage.this.toggleEncryptedKey(n);
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TableEditBOPage.this._jcolumnDataGrid.getTable().getSelectedRow();
                int n2 = TableEditBOPage.this._jcolumnDataGrid.getTable().getSelectedColumn();
                if (n2 != JTableEditor.KEY_COLUMN && n2 != JTableEditor.ALLOWNULLS_COLUMN && n2 != JTableEditor.COMPUTED_COLUMN && n2 != JTableEditor.ENCRYPTION_COLUMN) {
                    return;
                }
                if (n2 == JTableEditor.KEY_COLUMN) {
                    TableEditBOPage.this.toggleKey(n);
                } else if (n2 == JTableEditor.ALLOWNULLS_COLUMN) {
                    TableEditBOPage.this.toggleColumns(n, JTableEditor.ALLOWNULLS_COLUMN);
                } else if (n2 == JTableEditor.COMPUTED_COLUMN) {
                    TableEditBOPage.this.toggleComputedCols(n);
                } else if (n2 == JTableEditor.ENCRYPTION_COLUMN) {
                    TableEditBOPage.this.toggleEncryptedKey(n);
                }
            }
        };
        this._jcolumnDataGrid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
        this._jcolumnDataGrid.getTable().addMouseListener(this._mouseToggle);
    }

    public void toggleEC(int n) {
        if (this.isGridRowKeyColumn(n)) {
            this.toggleKeyfromEC(n);
        }
    }

    private void uninstallToggleActions() {
        this._jcolumnDataGrid.getTable().unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this._jcolumnDataGrid.getTable().removeMouseListener(this._mouseToggle);
    }

    boolean onCancel() {
        boolean bl = this.closeWindow();
        if (bl) {
            this.removeOpenWindow();
        }
        return bl;
    }

    public boolean doAlter() throws SQLException {
        Object object;
        int n;
        this.totErrorMsg = "";
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        bl2 = this._databaseSO.getOption("DB_OP_ALLOW_BULK");
        if (!bl2 && !this._databaseSO.isMaster()) {
            this._databaseSO.setOption("DB_OP_ALLOW_BULK", true);
        }
        ColumnSO columnSO = null;
        Vector vector = (Vector)this._columnsCtrBO.getDeletedColumns().clone();
        for (n = 0; n < vector.size(); ++n) {
            try {
                columnSO = (ColumnSO)vector.elementAt(n);
                if (columnSO.getTmpPrimaryKey()) {
                    columnSO.unSetPrimaryKey();
                    this._tableSO.alterPrimaryKey();
                }
                this._columnsCtrBO.removeColumnSO(columnSO, true);
            }
            catch (SQLException sQLException) {
                object = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_ERRM_DELETION"), columnSO.getTmpColumnName());
                string2 = string2 + ((ASEMessageText)object).toString() + "\n" + sQLException.getMessage() + "\n";
            }
            this._columnsCtrBO.deduceDeleteColumnSO(columnSO);
        }
        for (n = 0; n < this._vWorkingColumnSOs.size(); ++n) {
            try {
                String string4;
                columnSO = (ColumnSO)this._vWorkingColumnSOs.elementAt(n);
                if (columnSO.getColumnState() != 2 && columnSO.getColumnState() != 4) continue;
                if (!columnSO.getName().equals(columnSO.getTmpColumnName())) {
                    columnSO.reName(columnSO.getTmpColumnName());
                }
                if (columnSO.getTmpAllowNulls().equals(ColumnSO.YES)) {
                    this.updatePK(columnSO);
                    this.updateDatatypeNullOrNotNull(columnSO);
                } else {
                    this.updateDatatypeNullOrNotNull(columnSO);
                    this.updatePK(columnSO);
                }
                if (this._enableComputedColumn) {
                    columnSO.updateComputedCol();
                }
                if (!(string4 = columnSO.getRuleName() + " ( " + columnSO.getRuleOwner() + " )").equals(object = columnSO.getTmpRuleName() + " ( " + columnSO.getTmpRuleOwner() + " )")) {
                    if (columnSO.getRuleName() != null) {
                        columnSO.unbindRule();
                    }
                    if (columnSO.getTmpRuleName() != null) {
                        columnSO.bindRule(columnSO.getTmpRuleName(), columnSO.getTmpRuleOwner());
                    }
                }
                if (columnSO.getDefaultName() != null) {
                    if (columnSO.getTmpDefaultSelection() == 0) {
                        columnSO.unbindDefault();
                    } else if (columnSO.getTmpDefaultSelection() == 2) {
                        columnSO.unbindDefault();
                        if (columnSO.getTmpInlineDefaultText().trim().length() == 0) {
                            columnSO.addInlineDefault("null");
                        } else {
                            columnSO.addInlineDefault(columnSO.getTmpInlineDefaultText());
                        }
                    } else if (columnSO.getTmpDefaultSelection() == 1 && (columnSO.getDefaultName() != columnSO.getTmpDefaultName() || columnSO.getDefaultOwner() != columnSO.getTmpDefaultOwner())) {
                        columnSO.unbindDefault();
                        columnSO.bindDefault(columnSO.getTmpDefaultName(), columnSO.getTmpDefaultOwner());
                    }
                } else if (columnSO.getInlineDefaultText() != null) {
                    if (columnSO.getTmpDefaultSelection() == 0) {
                        columnSO.removeInlineDefault();
                    } else if (columnSO.getTmpDefaultSelection() == 1) {
                        columnSO.removeInlineDefault();
                        columnSO.bindDefault(columnSO.getTmpDefaultName(), columnSO.getTmpDefaultOwner());
                    } else if (columnSO.getTmpDefaultSelection() == 2 && columnSO.getInlineDefaultText() != columnSO.getTmpInlineDefaultText().trim()) {
                        if (columnSO.getTmpInlineDefaultText().trim().length() == 0) {
                            columnSO.addInlineDefault("null");
                        } else {
                            columnSO.addInlineDefault(columnSO.getTmpInlineDefaultText().trim());
                        }
                    }
                } else if (columnSO.getTmpDefaultSelection() == 1) {
                    columnSO.bindDefault(columnSO.getTmpDefaultName(), columnSO.getTmpDefaultOwner());
                } else if (columnSO.getTmpDefaultSelection() == 2) {
                    if (columnSO.getTmpInlineDefaultText().trim().length() == 0) {
                        columnSO.addInlineDefault("null");
                    } else {
                        columnSO.addInlineDefault(columnSO.getTmpInlineDefaultText().trim());
                    }
                }
                if (!this._enableEncryptionKey) continue;
                if (columnSO.getTmpEncrypt() != columnSO.getEncrypt() || !columnSO.getTmpKey().equals(columnSO.getKey())) {
                    boolean bl3 = false;
                    if (!columnSO.getTmpKey().equals(columnSO.defaultKey)) {
                        bl3 = true;
                    }
                    columnSO.alterEncryptionKey(columnSO.getTmpEncrypt(), bl3, columnSO.getTmpKey());
                }
                if (!columnSO.getTmpEncrypt() || columnSO.getTmpDecryptDefault() == columnSO.getDecryptDefault() && (!columnSO.getTmpDecryptDefault() || columnSO.getTmpDecryptDefaultText().equals(columnSO.getDecryptDefaultText()))) continue;
                columnSO.alterDecryptDefault(columnSO.getTmpDecryptDefault(), columnSO.getTmpDecryptDefaultText());
                continue;
            }
            catch (SQLException sQLException) {
                object = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_ERRM_MODIFICATION"), columnSO.getTmpColumnName());
                string3 = string3 + ((ASEMessageText)object).toString() + "\n" + sQLException.getMessage() + "\n";
                columnSO.setColumnState(4);
            }
        }
        Vector vector2 = (Vector)this._columnsCtrBO.getNewColumns().clone();
        for (int i = 0; i < vector2.size(); ++i) {
            try {
                columnSO = (ColumnSO)vector2.elementAt(i);
                if (columnSO.getTmpColumnName().equals("")) continue;
                this._columnsCtrBO.addColumnSO(columnSO, true);
                this._columnsCtrBO.deduceAddColumnSO(columnSO);
                if (!columnSO.getTmpPrimaryKey()) continue;
                columnSO.setPrimaryKey();
                this._tableSO.alterPrimaryKey();
                continue;
            }
            catch (SQLException sQLException) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_ERRM_CREATION"), columnSO.getTmpColumnName());
                string = string + aSEMessageText.toString() + "\n" + sQLException.getMessage() + "\n";
            }
        }
        String string5 = this._tableNameTextField.getText().trim();
        if (!string5.equals(this._tableSO.getName())) {
            try {
                this._tableSO.reName(this._tableSO.getName(), string5);
                this._tableSO.setName(string5);
                bl = true;
            }
            catch (SQLException sQLException) {
                this.totErrorMsg = sQLException.getMessage() + "\n";
            }
        }
        if (!bl2 && !this._databaseSO.isMaster()) {
            this._databaseSO.setOption("DB_OP_ALLOW_BULK", bl2);
        }
        this.totErrorMsg = this.totErrorMsg + string + string3 + string2;
        if (this.totErrorMsg.trim().length() > 0) {
            Support.showError(this._tableSO.getConnection(), this.getClass(), this._tableEditor.getJFrame(), this.totErrorMsg);
        }
        return bl;
    }

    public void updatePK(ColumnSO columnSO) throws SQLException {
        if (columnSO.getTmpPrimaryKey() != columnSO.isInPrimaryKey()) {
            if (columnSO.getTmpPrimaryKey()) {
                columnSO.setPrimaryKey();
            } else {
                columnSO.unSetPrimaryKey();
            }
            this._tableSO.alterPrimaryKey();
        }
    }

    public void updateDatatypeNullOrNotNull(ColumnSO columnSO) throws SQLException {
        if (columnSO.isComputedColumn()) {
            return;
        }
        if (columnSO.getTmpAllowNulls().equals(ColumnSO.YES) != columnSO.allowsNulls().equals(ColumnSO.YES) || !columnSO.getTmpDataType().equals(columnSO.getDatatype())) {
            if (this._baseTypes.hasWidthType(columnSO.getTmpDataType())) {
                columnSO.alterDatatypeNullOrNotNull(columnSO.getTmpAllowNulls().equals(ColumnSO.YES), columnSO.getTmpDataType(), columnSO.getTmpLength(), columnSO.getTmpScale());
            } else {
                columnSO.alterDatatypeNullOrNotNull(columnSO.getTmpAllowNulls().equals(ColumnSO.YES), columnSO.getTmpDataType(), columnSO.getTmpPrecision(), columnSO.getTmpScale());
            }
        } else if (this._baseTypes.hasWidthType(columnSO.getTmpDataType())) {
            if (!columnSO.getTmpLength().equals(columnSO.getLength())) {
                columnSO.alterDatatypeNullOrNotNull(columnSO.getTmpAllowNulls().equals(ColumnSO.YES), columnSO.getTmpDataType(), columnSO.getTmpLength(), columnSO.getTmpScale());
            }
        } else if (!(!this._baseTypes.hasScaleType(columnSO.getTmpDataType()) || columnSO.getTmpPrecision().equals(columnSO.getPrecision()) && columnSO.getTmpScale().equals(columnSO.getNumericScale()))) {
            columnSO.alterDatatypeNullOrNotNull(columnSO.getTmpAllowNulls().equals(ColumnSO.YES), columnSO.getTmpDataType(), columnSO.getTmpPrecision(), columnSO.getTmpScale());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        int n;
        int n2 = this._jcolumnDataGrid.getTable().getSelectedRow();
        if (n2 != (n = this._jcolumnDataGrid.getTable().getEditingRow())) {
            return;
        }
        if (documentEvent.getDocument() == this._editorTextField.getDocument()) {
            String string = this._editorTextField.getText();
            if (string.trim().length() == 0) {
                return;
            }
            this._jcolumnDataGrid.setValueAt(string, n2, JTableEditor.DATATYPE_COLUMN);
            Integer n3 = new Integer("1");
            Integer n4 = new Integer("0");
            if (this._jcolumnDataGrid.getTable().isCellTraversable(n2, JTableEditor.SIZE_COLUMN)) {
                n3 = (Integer)this._jcolumnDataGrid.getValueAt(n2, JTableEditor.SIZE_COLUMN);
            }
            if (this._jcolumnDataGrid.getTable().isCellTraversable(n2, JTableEditor.SCALE_COLUMN)) {
                n4 = (Integer)this._jcolumnDataGrid.getValueAt(n2, JTableEditor.SCALE_COLUMN);
            }
            this.setupDatatypeInputs(string, n3, n4, n2);
        } else if (n2 == this._vWorkingColumnSOs.size() - 1) {
            this.addColumnToGrid(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 9) {
            this._typedText = "";
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this._datatypeCompletion) {
            return;
        }
        if (keyEvent.getKeyChar() == '\r') {
            return;
        }
        this._typedText = this._typedText + keyEvent.getKeyChar();
        Iterator iterator = this._datatypeHSV.iterator();
        while (iterator.hasNext()) {
            String string = ((String[])iterator.next())[0];
            if (string.indexOf(this._typedText) != 0) continue;
            this._editorTextField.setText(string);
            this._editorTextField.setCaretPosition(string.length());
            this._editorTextField.moveCaretPosition(this._typedText.length());
            keyEvent.consume();
            return;
        }
        this._typedText = this._editorTextField.getText();
    }

    private void initToolbar() {
        int n = 2;
        this._toolbar.setLayout((LayoutManager)new FlowLayout(0, n, 0));
        int n2 = this._toolbar.getHeight();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(SystemColor.control);
        jPanel.setLayout(new FlowLayout(1, 1, 0));
        jPanel.setSize(new Dimension(2 * n2 + 3, n2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(SystemColor.control);
        jPanel2.setLayout(new FlowLayout(1, 1, 0));
        jPanel2.setSize(new Dimension(4 * n2 + 60, n2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(SystemColor.control);
        jPanel3.setLayout(new FlowLayout(1, 1, 0));
        jPanel3.setSize(new Dimension(2 * n2 + 83, n2));
        String[] stringArray = new String[]{ASEUtils.getString("TABLE_EDITOR_TTIP_ADD_COLUMN"), ASEUtils.getString("TABLE_EDITOR_TTIP_DELETE_COLUMN"), ASEUtils.getString("TABLE_EDITOR_TTIP_COLUMN_PROPERTIES"), ASEUtils.getString("TABLE_EDITOR_TTIP_SAVE_TABLE"), ASEUtils.getString("TABLE_EDITOR_TTIP_SAVE_AND_CLOSE")};
        ImageIcon[] imageIconArray = new ImageIcon[]{new ImageIcon(ResultSetTableImages.getAddRec()), ASEMenuItem.DELETE_ICON, ASEMenuItem.PROPERTIES_ICON, new ImageIcon(ASEImages.getExecuteImage()), new ImageIcon(ASEImages.getExecuteAndCloseImage())};
        this._buttonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(((ASAToolBarButton)actionEvent.getSource()).getActionCommand());
                if (n == 0) {
                    TableEditBOPage.this.addColumnToGrid(true);
                } else if (n == 1) {
                    TableEditBOPage.this.delColumnInGrid();
                } else if (n == 2) {
                    TableEditBOPage.this.showAdvColProp();
                } else if (n == 3) {
                    TableEditBOPage.this.doTableSave();
                } else if (n == 4) {
                    TableEditBOPage.this.saveAndClose();
                }
            }
        };
        this._keyStrokes = new KeyStroke[5];
        this._keyStrokes[0] = KeyStroke.getKeyStroke(78, 2);
        this._keyStrokes[1] = KeyStroke.getKeyStroke(82, 2);
        this._keyStrokes[2] = KeyStroke.getKeyStroke(67, 2);
        this._keyStrokes[3] = KeyStroke.getKeyStroke(83, 2);
        this._keyStrokes[4] = KeyStroke.getKeyStroke(88, 2);
        this._toolbarButtons = new ASAToolBarButton[5];
        for (int i = 0; i < 5; ++i) {
            this._toolbarButtons[i] = new ASAToolBarButton();
            this._toolbarButtons[i].setMargin(BTN_MARGIN);
            this._toolbarButtons[i].setIcon((Icon)imageIconArray[i]);
            this._toolbarButtons[i].setToolTipText(stringArray[i]);
            this._toolbarButtons[i].setActionCommand(String.valueOf(i));
            this._toolbarButtons[i].addActionListener(this._buttonAction);
            this._toolbarButtons[i].setNextFocusableComponent((Component)this._jcolumnDataGrid.getTable());
            this._toolbarButtons[i].registerKeyboardAction(this._buttonAction, this._keyStrokes[i], 2);
            if (i == 0 || i == 1) {
                jPanel.add((Component)this._toolbarButtons[i]);
                continue;
            }
            if (i == 2) {
                jPanel2.add((Component)this._toolbarButtons[i]);
                continue;
            }
            if (i != 3 && i != 4) continue;
            jPanel3.add((Component)this._toolbarButtons[i]);
        }
        this._toolbar.add((Component)jPanel);
        this._toolbar.add((Component)new JToolBar.Separator());
        this._toolbar.add((Component)jPanel2);
        this._toolbar.add((Component)new JToolBar.Separator());
        this._toolbar.add((Component)jPanel3);
    }

    void doTableSave() {
        this.saveTable(true);
    }

    protected TableSO getTableSO() {
        return this._tableSO;
    }

    public void fireTableSelectionChanged(boolean bl) {
        this._toolbarButtons[1].setEnabled(bl);
        this._toolbarButtons[2].setEnabled(bl);
        this._tableEditor.setDeletePropertiesMIEnabled(bl, bl);
    }
}

