/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.table;

import com.sybase.asa.ASALabel;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.Modifiable;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.table.JTableEditor;
import com.sybase.aseplugin.table.ProxyTableEditBOPage;
import com.sybase.aseplugin.table.TableEditBOPage;
import com.sybase.aseplugin.table.TableEditGOPage;
import com.sybase.resultSetTable.ResultSetTableImages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class TableEditor
implements WindowListener,
MouseListener,
ActionListener,
Modifiable {
    public static final int NEW_TABLE = 1;
    public static final int EXISTING_TABLE = 2;
    public static final int EXISTING_TABLE_NEW_COLUMN = 3;
    static final int TABLE_DELETED = 4;
    static final int TABLE_SAVED = 5;
    static final int SAVE_ERROR = 6;
    static final int NO_ERROR = 0;
    static final int ZERO_PREC = 1;
    static final int SCALE_TOO_BIG = 2;
    static final int UNKNOWN_ERROR = 4;
    public static final String BASE_TYPE = "0";
    public static final String USER_TYPE = "1";
    public static final String JAVA_TYPE = "2";
    static final int NUM_OPTIONS = 4;
    static final String DEFAULT_OPTIONS = "f;t;t;t";
    protected static final String F1_KEY_RELEASE = "F1_KEY_RELEASE";
    protected TableSO _tableSO;
    private TableEditBOPage _dlgPage;
    private TableBO _parent;
    private JFrame _jFrame = null;
    private JMenuItem _fileSaveTableMI = null;
    private JMenuItem _fileSaveAndCloseTableMI = null;
    private JMenuItem _fileCloseMI = null;
    private JMenuItem _columnNewMI = null;
    private JMenuItem _columnDeleteMI = null;
    private JMenuItem _columnSetDatatypeMI = null;
    private JMenuItem _columnPropertiesMI = null;
    private ASALabel _statusBar;
    private String _id;
    protected static int _mdid = 0;

    public static void showFrame(TableBO tableBO, int n, int n2) {
        new TableEditor(n, n2, tableBO);
    }

    public static void showFrame(TableBO tableBO, int n) {
        new TableEditor(n, -1, tableBO);
    }

    public TableEditor(int n, int n2, TableBO tableBO) {
        try {
            Object object;
            this._parent = tableBO;
            this._tableSO = (TableSO)tableBO.getSO();
            String string = this.generateID(n2, n);
            TableEditor tableEditor = (TableEditor)Support.getOpenWindow(string);
            if (tableEditor != null && (object = (JFrame)tableEditor.getWindow()) != null) {
                object.requestFocus();
                return;
            }
            this._jFrame = new JFrame();
            this._jFrame.getContentPane().setLayout(new BorderLayout());
            this._statusBar = new ASALabel(" ");
            this._jFrame.getContentPane().add((Component)this._statusBar, "South");
            object = new TableEditGOPage();
            this._jFrame.getContentPane().add((Component)object, "Center");
            this._jFrame.setDefaultCloseOperation(0);
            if (this._tableSO.isProxyTable()) {
                this._jFrame.setIconImage(ASEImages.getProxyTableSmallImage());
                this._dlgPage = new ProxyTableEditBOPage((TableEditGOPage)((Object)object), n, this, this._parent, n2);
            } else {
                this._jFrame.setIconImage(ASEImages.getTableSmallImage());
                this._dlgPage = new TableEditBOPage((TableEditGOPage)((Object)object), n, this, this._parent);
            }
            this.initMenus();
            this._jFrame.getRootPane().registerKeyboardAction(this, F1_KEY_RELEASE, KeyStroke.getKeyStroke(112, 0, true), 2);
            this._jFrame.addWindowListener(this);
            this._jFrame.setVisible(true);
            Support.addOpenWindow(string, this, this._tableSO.getConnection());
        }
        catch (SQLException sQLException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_START_TABLE_EDITOR"), this._tableSO.getConnection().getCurrentUser());
            Support.showDetailsError(this._tableSO.getConnection(), this.getClass(), (Container)Support.getViewerFrame(), aSEMessageText.toString(), sQLException);
        }
    }

    public String getTitle(int n, int n2) {
        return this.getTitle(n >= 0, n2 == 1);
    }

    public String getTitle(boolean bl, boolean bl2) {
        Object object;
        String string;
        if (bl) {
            string = bl2 ? ASEUtils.getString("TABLE_EDITOR_TITLE_PROXY_LOCAL") : ASEUtils.getString("TABLE_EDITOR_TITLE_PROXY_ON_RPC") + this._tableSO.getRemoteObjectName();
        } else if (bl2) {
            string = ASEUtils.getString("TABLE_EDITOR_WINT_TABLE_NEW");
        } else {
            object = new ASEMessageText(ASEUtils.getString("TABLE_EDITOR_WINT_TABLE"), this._tableSO.getFullyQualifiedName());
            string = ((ASEMessageText)object).toString();
        }
        object = Support.getFullTitle(string, this._tableSO.getConnection());
        return object;
    }

    public final String generateID(int n, int n2) {
        return this.generateID(n >= 0, n2 == 1);
    }

    public final String generateID(boolean bl, boolean bl2) {
        if (this._id != null) {
            return this._id;
        }
        this._id = this._tableSO != null ? this.getTitle(bl, bl2) + ":" + this._tableSO.getFullyQualifiedName() : this.getTitle(bl, bl2) + ":";
        return this._id;
    }

    public TableEditBOPage getTableEditBOPage() {
        return this._dlgPage;
    }

    private void initMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ASEUtils.getString("TABLE_EDITOR_MNAM_FILE"));
        this._setAndAppendMnemonicIfNecessary(jMenu, Support.getMnemonic("TABLE_EDITOR_MNEM_FILE"));
        this._fileSaveTableMI = new JMenuItem(ASEUtils.getString("TABLE_EDITOR_MENU_FILE_SAVE_TABLE"));
        this._setAndAppendMnemonicIfNecessary(this._fileSaveTableMI, Support.getMnemonic("TABLE_EDITOR_MNEM_FILE_SAVE_TABLE"));
        this._fileSaveTableMI.setIcon(new ImageIcon(ASEImages.getExecuteImage()));
        this._fileSaveTableMI.addMouseListener(this);
        this._fileSaveTableMI.addActionListener(this);
        jMenu.add(this._fileSaveTableMI);
        this._fileSaveAndCloseTableMI = new JMenuItem(ASEUtils.getString("TABLE_EDITOR_MENU_FILE_SAVE_AND_CLOSE_TABLE"));
        this._setAndAppendMnemonicIfNecessary(this._fileSaveAndCloseTableMI, Support.getMnemonic("TABLE_EDITOR_MNEM_FILE_SAVE_AND_CLOSE_TABLE"));
        this._fileSaveAndCloseTableMI.setIcon(new ImageIcon(ASEImages.getExecuteAndCloseImage()));
        this._fileSaveAndCloseTableMI.addMouseListener(this);
        this._fileSaveAndCloseTableMI.addActionListener(this);
        jMenu.add(this._fileSaveAndCloseTableMI);
        jMenu.add(new JSeparator());
        this._fileCloseMI = new JMenuItem(ASEUtils.getString("MENU_CLOSE"));
        this._setAndAppendMnemonicIfNecessary(this._fileCloseMI, Support.getMnemonic("TABLE_EDITOR_MNEM_FILE_CLOSE"));
        this._fileCloseMI.setIcon(new ImageIcon(ASEImages.getEmptyImage()));
        this._fileCloseMI.addMouseListener(this);
        this._fileCloseMI.addActionListener(this);
        jMenu.add(this._fileCloseMI);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(ASEUtils.getString("TABLE_EDITOR_MNAM_COLUMN"));
        this._setAndAppendMnemonicIfNecessary(jMenu2, Support.getMnemonic("TABLE_EDITOR_MNEM_COLUMN"));
        this._columnNewMI = new JMenuItem(ASEUtils.getString("TABLE_EDITOR_MENE_COLUMN_NEW"));
        this._setAndAppendMnemonicIfNecessary(this._columnNewMI, Support.getMnemonic("TABLE_EDITOR_MNEM_COLUMN_NEW"));
        this._columnNewMI.setIcon(new ImageIcon(ResultSetTableImages.getAddRec()));
        this._columnNewMI.addMouseListener(this);
        this._columnNewMI.addActionListener(this);
        jMenu2.add(this._columnNewMI);
        this._columnDeleteMI = new JMenuItem(ASEUtils.getString("CONTEXT_MENU_DELETE_TEXT"));
        this._setAndAppendMnemonicIfNecessary(this._columnDeleteMI, Support.getMnemonic("TABLE_EDITOR_MNEM_COLUMN_DELETE"));
        this._columnDeleteMI.setIcon(ASEMenuItem.DELETE_ICON);
        this._columnDeleteMI.addMouseListener(this);
        this._columnDeleteMI.addActionListener(this);
        this._columnDeleteMI.setEnabled(false);
        jMenu2.add(this._columnDeleteMI);
        jMenu2.add(new JSeparator());
        this._columnSetDatatypeMI = new JMenuItem(ASEUtils.getString("TABLE_EDITOR_MENE_COLUMN_SET_DATA_TYPE"));
        this._setAndAppendMnemonicIfNecessary(this._columnSetDatatypeMI, Support.getMnemonic("TABLE_EDITOR_MNEM_COLUMN_SET_DATA_TYPE"));
        this._columnSetDatatypeMI.setIcon(new ImageIcon(ASEImages.getEmptyImage()));
        this._columnSetDatatypeMI.addMouseListener(this);
        this._columnSetDatatypeMI.addActionListener(this);
        jMenu2.add(this._columnSetDatatypeMI);
        jMenu2.add(new JSeparator());
        this._columnPropertiesMI = new JMenuItem(ASEUtils.getString("CONTEXT_MENU_PROPERTIES_TEXT"));
        this._setAndAppendMnemonicIfNecessary(this._columnPropertiesMI, Support.getMnemonic("TABLE_EDITOR_MNEM_COLUMN_PROPERTIES"));
        this._columnPropertiesMI.setIcon(ASEMenuItem.PROPERTIES_ICON);
        this._columnPropertiesMI.addMouseListener(this);
        this._columnPropertiesMI.addActionListener(this);
        this._columnPropertiesMI.setEnabled(false);
        jMenu2.add(this._columnPropertiesMI);
        jMenuBar.add(jMenu2);
        this._jFrame.setJMenuBar(jMenuBar);
    }

    private void _setAndAppendMnemonicIfNecessary(JMenuItem jMenuItem, char c) {
        String string = jMenuItem.getText();
        if (!Support.containsMnemonic(string, c)) {
            jMenuItem.setText(Support.appendMnemonic(string, c));
        }
        jMenuItem.setMnemonic(c);
    }

    JFrame getJFrame() {
        return this._jFrame;
    }

    int getDialogType() {
        return 0;
    }

    TableSO getTableSO() {
        return this._tableSO;
    }

    void loadJava() {
        this._dlgPage.loadJavaClasses();
    }

    boolean closeWindow() {
        if (this._jFrame != null) {
            this._jFrame.requestFocus();
        }
        if (this._dlgPage.closeWindow()) {
            this._parent.refresh();
            this._dlgPage.removeOpenWindow();
            this.getJFrame().removeWindowListener(this);
            this.releaseResources();
            return true;
        }
        return false;
    }

    private void updateStatusBar(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this._statusBar.setText(string);
    }

    void releaseResources() {
        this._fileSaveTableMI.removeMouseListener(this);
        this._fileSaveTableMI.removeActionListener(this);
        this._fileSaveAndCloseTableMI.removeMouseListener(this);
        this._fileSaveAndCloseTableMI.removeActionListener(this);
        this._fileCloseMI.removeMouseListener(this);
        this._fileCloseMI.removeActionListener(this);
        this._columnNewMI.removeMouseListener(this);
        this._columnNewMI.removeActionListener(this);
        this._columnDeleteMI.removeMouseListener(this);
        this._columnDeleteMI.removeActionListener(this);
        this._columnSetDatatypeMI.removeMouseListener(this);
        this._columnSetDatatypeMI.removeActionListener(this);
        this._columnPropertiesMI.removeMouseListener(this);
        this._columnPropertiesMI.removeActionListener(this);
        this._dlgPage.releaseResources();
        this._dlgPage = null;
        this._tableSO = null;
        this._parent = null;
        this._jFrame.setMenuBar(null);
        this._jFrame.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, true));
        this._jFrame.dispose();
        this._jFrame = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._fileSaveTableMI) {
            this._dlgPage.doTableSave();
        } else if (actionEvent.getSource() == this._fileSaveAndCloseTableMI) {
            this._dlgPage.doTableSave();
            this.closeWindow();
        } else if (actionEvent.getSource() == this._fileCloseMI) {
            this.closeWindow();
        } else if (actionEvent.getSource() == this._columnNewMI) {
            this._dlgPage.addColumnToGrid(true);
        } else if (actionEvent.getSource() == this._columnDeleteMI) {
            this._dlgPage.delColumnInGrid();
        } else if (actionEvent.getSource() == this._columnSetDatatypeMI) {
            int n = this._dlgPage._jcolumnDataGrid.getTable().getSelectedRow();
            if (n == -1) {
                return;
            }
            this._dlgPage._jcolumnDataGrid._comboBoxEditor.showDialog();
            String string = this._dlgPage._jcolumnDataGrid._comboBoxEditor.getDataTypeValue();
            if (string != null && !string.equals("")) {
                this._dlgPage._jcolumnDataGrid.getTable().getModel().setValueAt(string, n, JTableEditor.DATATYPE_COLUMN);
                this._dlgPage.setupDatatypeInputs(string, new Integer(0), new Integer(0), n);
            }
        } else if (actionEvent.getSource() == this._columnPropertiesMI) {
            this._dlgPage.showAdvColProp();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._fileSaveTableMI) {
            this.updateStatusBar(ASEUtils.getString("TABLE_EDITOR_MHNT_FILE_SAVE_TABLE"));
        } else if (mouseEvent.getSource() == this._fileSaveAndCloseTableMI) {
            this.updateStatusBar(ASEUtils.getString("TABLE_EDITOR_MHNT_FILE_SAVE_AND_CLOSE_TABLE"));
        } else if (mouseEvent.getSource() == this._fileCloseMI) {
            this.updateStatusBar(ASEUtils.getString("TABLE_EDITOR_MHNT_FILE_CLOSE"));
        } else if (mouseEvent.getSource() == this._columnNewMI) {
            this.updateStatusBar(ASEUtils.getString("TABLE_EDITOR_MHNT_COLUMN_NEW"));
        } else if (mouseEvent.getSource() == this._columnDeleteMI) {
            this.updateStatusBar(ASEUtils.getString("TABLE_EDITOR_MHNT_COLUMN_DELETE"));
        } else if (mouseEvent.getSource() == this._columnSetDatatypeMI) {
            this.updateStatusBar(ASEUtils.getString("TABLE_EDITOR_MHNT_COLUMN_SET_DATA_TYPE"));
        } else if (mouseEvent.getSource() == this._columnPropertiesMI) {
            this.updateStatusBar(ASEUtils.getString("TABLE_EDITOR_MHNT_COLUMN_PROPERTIES"));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.updateStatusBar(" ");
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this._dlgPage.onSetActive();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public final boolean isModified() {
        return this._dlgPage._modified;
    }

    @Override
    public final Window getWindow() {
        return this.getJFrame();
    }

    public void setDeletePropertiesMIEnabled(boolean bl, boolean bl2) {
        this._columnDeleteMI.setEnabled(bl);
        this._columnPropertiesMI.setEnabled(bl2);
    }
}

